#include <QQuickView>
#include <QQuickItem>

#include "inappbrowser.h"
#include "../cordova.h"

#define INAPPBROWSER_STATE_NAME "InAppBrowser"

InAppBrowser::InAppBrowser(Cordova *cordova): CPlugin(cordova) {
}

void InAppBrowser::loadUrl(int loadEndCb, int closeCb, QString url) {
    if (open)
        return;
    open = true;
    m_closeCb = closeCb;
    m_loadFinishedCb = loadEndCb;

    m_cordova->rootObject()->setProperty("inappbrowserUrl", url);
    m_cordova->pushViewState(INAPPBROWSER_STATE_NAME);
}

void InAppBrowser::close(int, int) {
    if (!open)
        return;
    open = false;
    m_cordova->popViewState(INAPPBROWSER_STATE_NAME);
    this->cb(m_closeCb);
}

void InAppBrowser::loadFinished() {
    this->callbackWithoutRemove(m_loadFinishedCb, "");
}

