#ifndef CAPTURE_H
#define CAPTURE_H

#include "../cplugin.h"
#include <QAudioRecorder>
#include <QtCore>

class Capture: public CPlugin {
    Q_OBJECT
public:
    explicit Capture(Cordova *cordova);

    virtual const QString fullName() override {
        return Capture::fullID();
    }

    virtual const QString shortName() override {
        return "Capture";
    }

    static const QString fullID() {
        return "com.cordova.Capture";
    }

public slots:
    void getSupportedFormats(int scId, int ecId);
    void startAudioRecordApp(int scId, int ecId, QVariantMap p_options);
    void record();
    void cancel();
private slots:
    void onError(QMediaRecorder::Error);
private:
    QSharedPointer<QAudioRecorder> m_recorder;

    int m_scId, m_ecId;
    QList<QString> m_files;
    QVariantMap m_options;
};

#endif // CAPTURE_H
