# Development Report for Jan 20, 2017

This week we worked on refactoring the storage and runtime aspects of containerd, much of this work won't be completed until next week.

## Distribution tool

@stevvooe started work on a `dist` tool for fetching images and other distribution aspects.  One of the problems we wanted to solve with containerd is the ability to decouple the fetch of image contents, the unpacking of the contents, and the storage of the contents.  Separating these lets us download content as non-root on machines and only elevate privileges when the contents need to be unpacked on disk.

* https://github.com/containerd/containerd/pull/452

## Shim Work

A large part of my week I have been working on the shim.  It is a very core aspect of containerd and allows containers to run without being tied to the lifecycle of the containerd daemon.  With this work we will end up with one shim per container that manages all additional processes in the container.  This saves resources on the system as well as makes interacting with the shim much easier.  We are placing the shim behind a GRPC API instead of the pipe based protocol that we have today.

I don't have a PR open at this time but expect something next week.

## General Improvements

We worked on the build process this week as well as improvements across the codebase.  There were 31 commits merged this week from various contributors.

Overall, there were no large features hitting master this week.  Many of those are still in the works but a lot was done to simplify existing code and reduce complexity where we can.

