#
# Copyright (C) 2005  Robert Collins  <robertc@squid-cache.org>
# 
# 
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

"""Fake VCS specific tests."""

import os
import tests
import unittest

import config_manager.implementations as implementations
# if this fails to import, then the vcs module is bust
# and this test script will never be reached to be imported
import config_manager.implementations.fake_vcs as fake_vcs

# the implementation tests test the contract, specific tests
# for the fake vcs go in this file

class TestFakeImplementation(unittest.TestCase):

    def test_is_registered(self):
        # Implementations should register when loading, once this suite is 
        # parameterised from the list of all implementations, this test can
        # go.
        instances = [imp for imp in 
            implementations.all_implementations if
            isinstance(imp, fake_vcs.FakeVCS)]
        self.assertEqual(1, len(instances))


def test_suite():
    loader = tests.TestLoader()
    return loader.loadTestsFromName(__name__)
