#include <stdio.h>
#include <stdlib.h>
#include <colorblind.h>
#include "_test.h"

int main(int argc, char** argv) {
        printf("1..16\n");
        COLORBLIND_RUNTIME* runtime = colorblind_create();
        ok(runtime != NULL,"colorblind_create returns a valid pointer");
        ok(runtime->filter_type == colorblind_filter_t_no_filter,"starts without any filter");
        int r = colorblind_set_filter_type(runtime,colorblind_filter_t_selective_saturate_red);
        ok(r == 0,"colorblind_filter_selective_saturate_red doesn't need arguments");
        ok(runtime->filter_type == colorblind_filter_t_selective_saturate_red,"set effectivelly sets the filter.");
        r = colorblind_set_filter_type(runtime,colorblind_filter_t_selective_saturate);
        ok(r != 0,"colorblind_filter_selective_saturate need arguments");
        ok(runtime->filter_type == colorblind_filter_t_selective_saturate_red,"doesn't set without arguments.");
        COLORBLIND_XCOLOR xs[4];
        r = colorblind_set_base_colors(runtime, xs, 4);
        ok(r == 0,"sets the base_color (plural).");
        ok(runtime->base_color == xs,"effectivelly sets the base_color (plural).");
        ok(runtime->base_color_count == 4,"when sets 4 colors, set count to 4.");
        r = colorblind_set_base_color(runtime, &xs[0]);
        ok(r == 0,"sets the base_color.");
        ok(runtime->base_color == &xs[0],"effectivelly sets the base_color.");
        ok(runtime->base_color_count == 1,"when sets a sigle color, set count to 1.");
        r = colorblind_remove_base_color(runtime);
        ok(r == 0,"removing the base_color.");
        ok(runtime->base_color == NULL,"effectivelly cleans the base_color.");
        ok(runtime->base_color_count == 0,"when removing the base color, set count to 0.");
        colorblind_destroy(runtime);
        ok(1,"destroyed");
        return 0;
}
