#ifndef H_CDW_FORM
#define H_CDW_FORM

#include <stdbool.h>
#include <stddef.h>

#include "main.h"
#include "cdw_ncurses.h"
#include "cdw_config.h"
#include "cdw_widgets.h"


/* this data structure is in "draft" version, it may change many times */
typedef struct {
	cdw_id_t widget_type;    /* widget type from cdw_widgets.h */
	int begin_y;             /* start row in parent window */
	int begin_x;             /* start col in parent window */
	int n_cols;              /* number of columns occupied by widget */
	int n_lines;             /* number of lines occupied by widget */
	int field_enum;          /* field index, useful when widgets are placed in ncurses form */
	void *data1;             /* e.g. for initial label string or for widget associated with field */
	size_t data2;            /* generic int, usage depends on type of widget */
} cdw_form_descr_t;




struct cdw_form_type {
	/* these three fields are "foreign" - they are just pointers
	   to data provided and managed by client's code */
	WINDOW *window;
	WINDOW *subwindow;
	FIELD **fields;

	/* this is pointer to memory allocated by cdw form, but it's
	   client's responsibility to free this memory */
	FORM *form;

	/* TODO: make "form" and "fields" fields fully "owned" by cdw form */

	int n_fields;
	cdw_id_t *field_widget_types; /* table of widget types/IDs, allocated at runtime */

	cdw_id_t form_id; /* useful when client code uses several forms */

	int return_keys[N_RETURN_KEYS_MAX];
	int n_return_keys;

	/* this one you have to initialize yourself */
	int (* handle_enter)(cdw_form_t *cdw_form, int fi);
};

/* these are for "cdw form" data structure */
cdw_form_t *cdw_form_new(int n_fields);
void        cdw_form_delete_form_objects(cdw_form_t *cdw_form);
void        cdw_form_delete(cdw_form_t **cdw_form);
int         cdw_form_driver(cdw_form_t *cdw_form, int initial_fi);
cdw_rv_t    cdw_form_description_to_fields(cdw_form_descr_t descr[], cdw_form_t *cdw_form);
void        cdw_form_add_return_char(cdw_form_t *form, int key);
void        cdw_form_add_return_chars(cdw_form_t *form, ...);
void        cdw_form_driver_go_to_field(cdw_form_t *cdw_form, int fi);

bool cdw_form_is_movement_key(int key);


CDW_DROPDOWN *cdw_form_get_dropdown(cdw_form_t *cdw_form, int fi);
CDW_BUTTON   *cdw_form_get_button(cdw_form_t *cdw_form, int fi);
CDW_CHECKBOX *cdw_form_get_checkbox(cdw_form_t *cdw_form, int fi);
bool          cdw_form_get_checkbox_state(cdw_form_t *cdw_form, int fi);
const char   *cdw_form_get_string(cdw_form_t *cdw_form, int fi);


void cdw_form_redraw_widgets(cdw_form_t *cdw_form);
void *cdw_form_set_function(cdw_form_t *cdw_form, int fi, cdw_form_widget_function_t function);

typedef CDW_DROPDOWN * (* cdw_form_dropdown_maker_t)(WINDOW *window, int begin_y, int begin_x, int width);
typedef char         * (* cdw_form_text_maker_t)(int n_cols);


#endif /* H_CDW_FORM */
