{ -*- buffer-read-only: t -*-

  Copyright 2015-2022 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal }

{$ifdef read_interface}

  strict private
    function GetRadius: Single;
    procedure SetRadius(const Value: Single);
    function GetSlices: Integer;
    procedure SetSlices(const Value: Integer);
    function GetStacks: Integer;
    procedure SetStacks(const Value: Integer);
  public
    procedure CreateNode; override;
    class function ClassX3DType: string; override;

    strict private FFdRadius: TSFFloat;
    { Internal wrapper for property @link(Radius). This wrapper API may change, we advise to access simpler @link(Radius) instead. }
    public property FdRadius: TSFFloat read FFdRadius;
    {  }
    property Radius: Single read GetRadius write SetRadius;

    strict private FFdSolid: TSFBool;
    { Internal wrapper for property @link(Solid). This wrapper API may change, we advise to access simpler @link(Solid) instead. }
    public property FdSolid: TSFBool read FFdSolid;

    strict private FFdTexCoord: TSFNode;
    { Internal wrapper for property @link(TexCoord). This wrapper API may change, we advise to access simpler @link(TexCoord) instead. }
    public property FdTexCoord: TSFNode read FFdTexCoord;

    strict private FFdSlices: TSFInt32;
    { Internal wrapper for property @link(Slices). This wrapper API may change, we advise to access simpler @link(Slices) instead. }
    public property FdSlices: TSFInt32 read FFdSlices;
    {  }
    property Slices: Integer read GetSlices write SetSlices;

    strict private FFdStacks: TSFInt32;
    { Internal wrapper for property @link(Stacks). This wrapper API may change, we advise to access simpler @link(Stacks) instead. }
    public property FdStacks: TSFInt32 read FFdStacks;
    {  }
    property Stacks: Integer read GetStacks write SetStacks;

{$endif read_interface}

{$ifdef read_implementation}

{ TSphereNode ----------------------------------------------- }

function TSphereNode.GetRadius: Single;
begin
  Result := FdRadius.Value;
end;

procedure TSphereNode.SetRadius(const Value: Single);
begin
  FdRadius.Send(Value);
end;

function TSphereNode.GetSlices: Integer;
begin
  Result := FdSlices.Value;
end;

procedure TSphereNode.SetSlices(const Value: Integer);
begin
  FdSlices.Send(Value);
end;

function TSphereNode.GetStacks: Integer;
begin
  Result := FdStacks.Value;
end;

procedure TSphereNode.SetStacks(const Value: Integer);
begin
  FdStacks.Send(Value);
end;

class function TSphereNode.ClassX3DType: String;
begin
  Result := 'Sphere';
end;

procedure TSphereNode.CreateNode;
begin
  inherited;

  FFdRadius := TSFFloat.Create(Self, False, 'radius', 1);
   FdRadius.ChangeAlways := chGeometry;
   FdRadius.MustBeNonnegative := true;
  AddField(FFdRadius);

  FFdSolid := TSFBool.Create(Self, False, 'solid', true);
   FdSolid.ChangeAlways := chGeometry;
  AddField(FFdSolid);

  FFdTexCoord := TSFNode.Create(Self, True, 'texCoord', [TTextureCoordinateGeneratorNode, TProjectedTextureCoordinateNode, TMultiGeneratedTextureCoordinateNode]);
   FdTexCoord.ChangeAlways := chGeometry;
  AddField(FFdTexCoord);

  FFdSlices := TSFInt32.Create(Self, True, 'slices', -1);
   FdSlices.ChangeAlways := chGeometry;
  AddField(FFdSlices);

  FFdStacks := TSFInt32.Create(Self, True, 'stacks', -1);
   FdStacks.ChangeAlways := chGeometry;
  AddField(FFdStacks);
end;

{$endif read_implementation}
