{ -*- buffer-read-only: t -*-

  Copyright 2015-2022 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal }

{$ifdef read_interface}

  strict private
    function GetDescription: String;
    procedure SetDescription(const Value: String);
    function GetLoop: Boolean;
    procedure SetLoop(const Value: Boolean);
    function GetPauseTime: TFloatTime;
    procedure SetPauseTime(const Value: TFloatTime);
    function GetResumeTime: TFloatTime;
    procedure SetResumeTime(const Value: TFloatTime);
    function GetSpeed: Single;
    procedure SetSpeed(const Value: Single);
    function GetStartTime: TFloatTime;
    procedure SetStartTime(const Value: TFloatTime);
    function GetStopTime: TFloatTime;
    procedure SetStopTime(const Value: TFloatTime);
    function GetFlipVertically: Boolean;
    procedure SetFlipVertically(const Value: Boolean);
  public
    procedure CreateNode; override;
    class function ClassX3DType: string; override;

    strict private FFdDescription: TSFString;
    { Internal wrapper for property @link(Description). This wrapper API may change, we advise to access simpler @link(Description) instead. }
    public property FdDescription: TSFString read FFdDescription;
    {  }
    property Description: String read GetDescription write SetDescription;

    strict private FFdLoop: TSFBool;
    { Internal wrapper for property @link(Loop). This wrapper API may change, we advise to access simpler @link(Loop) instead. }
    public property FdLoop: TSFBool read FFdLoop;
    {  }
    property Loop: Boolean read GetLoop write SetLoop;

    strict private FFdPauseTime: TSFTime;
    { Internal wrapper for property @link(PauseTime). This wrapper API may change, we advise to access simpler @link(PauseTime) instead. }
    public property FdPauseTime: TSFTime read FFdPauseTime;
    {  }
    property PauseTime: TFloatTime read GetPauseTime write SetPauseTime;

    strict private FFdResumeTime: TSFTime;
    { Internal wrapper for property @link(ResumeTime). This wrapper API may change, we advise to access simpler @link(ResumeTime) instead. }
    public property FdResumeTime: TSFTime read FFdResumeTime;
    {  }
    property ResumeTime: TFloatTime read GetResumeTime write SetResumeTime;

    strict private FFdSpeed: TSFFloat;
    { Internal wrapper for property @link(Speed). This wrapper API may change, we advise to access simpler @link(Speed) instead. }
    public property FdSpeed: TSFFloat read FFdSpeed;
    {  }
    property Speed: Single read GetSpeed write SetSpeed;

    strict private FFdStartTime: TSFTime;
    { Internal wrapper for property @link(StartTime). This wrapper API may change, we advise to access simpler @link(StartTime) instead. }
    public property FdStartTime: TSFTime read FFdStartTime;
    {  }
    property StartTime: TFloatTime read GetStartTime write SetStartTime;

    strict private FFdStopTime: TSFTime;
    { Internal wrapper for property @link(StopTime). This wrapper API may change, we advise to access simpler @link(StopTime) instead. }
    public property FdStopTime: TSFTime read FFdStopTime;
    {  }
    property StopTime: TFloatTime read GetStopTime write SetStopTime;

    strict private FFdUrl: TMFString;
    { Internal wrapper for property @link(Url). This wrapper API may change, we advise to access simpler @link(Url) instead. }
    public property FdUrl: TMFString read FFdUrl;
    {  }
    procedure SetUrl(const Value: array of string); overload;
    {  }
    procedure SetUrl(const Value: TCastleStringList); overload;

    strict private FFdFlipVertically: TSFBool;
    { Internal wrapper for property @link(FlipVertically). This wrapper API may change, we advise to access simpler @link(FlipVertically) instead. }
    public property FdFlipVertically: TSFBool read FFdFlipVertically;
    {  }
    property FlipVertically: Boolean read GetFlipVertically write SetFlipVertically;

    strict private FEventDuration_changed: TSFTimeEvent;
    {  }
    public property EventDuration_changed: TSFTimeEvent read FEventDuration_changed;

    strict private FEventElapsedTime: TSFTimeEvent;
    {  }
    public property EventElapsedTime: TSFTimeEvent read FEventElapsedTime;

    strict private FEventIsActive: TSFBoolEvent;
    {  }
    public property EventIsActive: TSFBoolEvent read FEventIsActive;

    strict private FEventIsPaused: TSFBoolEvent;
    {  }
    public property EventIsPaused: TSFBoolEvent read FEventIsPaused;

{$endif read_interface}

{$ifdef read_implementation}

{ TMovieTextureNode ----------------------------------------------- }

function TMovieTextureNode.GetDescription: String;
begin
  Result := FdDescription.Value;
end;

procedure TMovieTextureNode.SetDescription(const Value: String);
begin
  FdDescription.Send(Value);
end;

function TMovieTextureNode.GetLoop: Boolean;
begin
  Result := FdLoop.Value;
end;

procedure TMovieTextureNode.SetLoop(const Value: Boolean);
begin
  FdLoop.Send(Value);
end;

function TMovieTextureNode.GetPauseTime: TFloatTime;
begin
  Result := FdPauseTime.Value;
end;

procedure TMovieTextureNode.SetPauseTime(const Value: TFloatTime);
begin
  FdPauseTime.Send(Value);
end;

function TMovieTextureNode.GetResumeTime: TFloatTime;
begin
  Result := FdResumeTime.Value;
end;

procedure TMovieTextureNode.SetResumeTime(const Value: TFloatTime);
begin
  FdResumeTime.Send(Value);
end;

function TMovieTextureNode.GetSpeed: Single;
begin
  Result := FdSpeed.Value;
end;

procedure TMovieTextureNode.SetSpeed(const Value: Single);
begin
  FdSpeed.Send(Value);
end;

function TMovieTextureNode.GetStartTime: TFloatTime;
begin
  Result := FdStartTime.Value;
end;

procedure TMovieTextureNode.SetStartTime(const Value: TFloatTime);
begin
  FdStartTime.Send(Value);
end;

function TMovieTextureNode.GetStopTime: TFloatTime;
begin
  Result := FdStopTime.Value;
end;

procedure TMovieTextureNode.SetStopTime(const Value: TFloatTime);
begin
  FdStopTime.Send(Value);
end;

procedure TMovieTextureNode.SetUrl(const Value: array of string);
begin
  FdUrl.Send(Value);
end;

procedure TMovieTextureNode.SetUrl(const Value: TCastleStringList);
begin
  FdUrl.Send(Value);
end;

function TMovieTextureNode.GetFlipVertically: Boolean;
begin
  Result := FdFlipVertically.Value;
end;

procedure TMovieTextureNode.SetFlipVertically(const Value: Boolean);
begin
  FdFlipVertically.Send(Value);
end;

class function TMovieTextureNode.ClassX3DType: String;
begin
  Result := 'MovieTexture';
end;

procedure TMovieTextureNode.CreateNode;
begin
  inherited;

  FFdDescription := TSFString.Create(Self, True, 'description', '');
   FdDescription.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdDescription);

  FFdLoop := TSFBool.Create(Self, True, 'loop', false);
   FdLoop.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdLoop);

  FFdPauseTime := TSFTime.Create(Self, True, 'pauseTime', 0);
   FdPauseTime.ChangeAlways := chTimeStopStart;
  AddField(FFdPauseTime);

  FFdResumeTime := TSFTime.Create(Self, True, 'resumeTime', 0);
   FdResumeTime.ChangeAlways := chTimeStopStart;
  AddField(FFdResumeTime);

  FFdSpeed := TSFFloat.Create(Self, True, 'speed', 1.0);
   FdSpeed.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdSpeed);

  FFdStartTime := TSFTime.Create(Self, True, 'startTime', 0);
   FdStartTime.ChangeAlways := chTimeStopStart;
  AddField(FFdStartTime);

  FFdStopTime := TSFTime.Create(Self, True, 'stopTime', 0);
   FdStopTime.ChangeAlways := chTimeStopStart;
  AddField(FFdStopTime);

  FFdUrl := TMFString.Create(Self, True, 'url', []);
   FdUrl.ChangeAlways := chTextureImage;
  AddField(FFdUrl);

  FFdFlipVertically := TSFBool.Create(Self, False, 'flipVertically', false);
   FdFlipVertically.ChangeAlways := chTextureImage;
  AddField(FFdFlipVertically);

  FEventDuration_changed := TSFTimeEvent.Create(Self, 'duration_changed', false);
  AddEvent(FEventDuration_changed);

  FEventElapsedTime := TSFTimeEvent.Create(Self, 'elapsedTime', false);
  AddEvent(FEventElapsedTime);

  FEventIsActive := TSFBoolEvent.Create(Self, 'isActive', false);
  AddEvent(FEventIsActive);

  FEventIsPaused := TSFBoolEvent.Create(Self, 'isPaused', false);
  AddEvent(FEventIsPaused);
end;

{$endif read_implementation}
