#!
#! @ingroup group_sdk_cmake_camitk_cdash_projects
#!
#! macro camitk_sub_project_add adds a subproject definition from targets and its dependencies (if any) to the variable
#! Typically recursively call this function accross all targets to generate Project.xml file.
#!
#! Usage:
#! \code
#! camitk_sub_project_add(ACTION|COMPONENT|CEP_LIBRARY|APPLICATION target name
#!               [DEPENDENCIES dep1 dep2 dep3]
#!               
#! )
#! \endcode
#!
#! \param TARGET_TYPE name              the library / exe program targeted for CMake compilation
#! \param DEPENDENCIES (optional)       the library dependencies to build the target
macro(camitk_sub_project_add)
    parse_arguments(ADD_SUB_PROJECT
        "ACTION;COMPONENT;CEP_LIBRARY;APPLICATION;CORELIB;DEPENDENCIES"  # possible lists
        "" #possible options
        ${ARGN}
    )

    # check types
    # CORE LIBRARIES
    if(ADD_SUB_PROJECT_CORELIB)
        set(SUB_PROJECT_NAME ${ADD_SUB_PROJECT_CORELIB})
        # Add the xml node for this current subproject
        set(xml_subproject_corelibraries ${xml_subproject_corelibraries} "\n <SubProject name=\"${SUB_PROJECT_NAME}\">" CACHE INTERNAL "")
        foreach(DEPENDENCY ${ADD_SUB_PROJECT_DEPENDENCIES})
                set(xml_subproject_corelibraries ${xml_subproject_corelibraries} "\n  <Dependency name=\"${DEPENDENCY}\"/>" CACHE INTERNAL "")
        endforeach()
        set(xml_subproject_corelibraries ${xml_subproject_corelibraries} " </SubProject>" CACHE INTERNAL "")
    endif()
    
    # LIBRARY
    if(ADD_SUB_PROJECT_CEP_LIBRARY)
        set(SUB_PROJECT_NAME ${ADD_SUB_PROJECT_CEP_LIBRARY})
        # Add the xml node for this current subproject
        set(xml_subproject_libraries ${xml_subproject_libraries} "\n <SubProject name=\"${SUB_PROJECT_NAME}\">" CACHE INTERNAL "")
        foreach(DEPENDENCY ${ADD_SUB_PROJECT_DEPENDENCIES})
                set(xml_subproject_libraries ${xml_subproject_libraries} "\n  <Dependency name=\"${DEPENDENCY}\"/>" CACHE INTERNAL "")
        endforeach()
        set(xml_subproject_libraries ${xml_subproject_libraries} "  </SubProject>" CACHE INTERNAL "")
        set(CAMITK_CEP_LIBRARY_TARGETS ${CAMITK_CEP_LIBRARY_TARGETS} ${SUB_PROJECT_NAME} CACHE STRING "List of CamiTK CEP library targets" FORCE)
    endif()
    
    # COMPONENTS
    if(ADD_SUB_PROJECT_COMPONENT)
        set(SUB_PROJECT_NAME ${ADD_SUB_PROJECT_COMPONENT})
        # Add the xml node for this current subproject
        set(xml_subproject_components ${xml_subproject_components} "\n <SubProject name=\"${SUB_PROJECT_NAME}\">" CACHE INTERNAL "")
        foreach(DEPENDENCY ${ADD_SUB_PROJECT_DEPENDENCIES})
                set(xml_subproject_components ${xml_subproject_components} "\n  <Dependency name=\"${DEPENDENCY}\"/>" CACHE INTERNAL "")
        endforeach()
        set(xml_subproject_components ${xml_subproject_components} "  </SubProject>" CACHE INTERNAL "")
        set(CAMITK_COMPONENT_TARGETS ${CAMITK_COMPONENT_TARGETS} ${SUB_PROJECT_NAME} CACHE STRING "List of CamiTK component targets" FORCE)
    endif()
    
    # ACTIONS
    if(ADD_SUB_PROJECT_ACTION)
        set(SUB_PROJECT_NAME ${ADD_SUB_PROJECT_ACTION})
        if(SUB_PROJECT_NAME STREQUAL "action-application")
            # Particular case of action-applications
            set(xml_subproject_action_application "\n <SubProject name=\"${SUB_PROJECT_NAME}\">" CACHE INTERNAL "")
            set(xml_subproject_action_application ${xml_subproject_action_application} "\n  <Dependency name=\"library-camitkcore\"/>" CACHE INTERNAL "")
            set(xml_subproject_action_application ${xml_subproject_action_application} "  </SubProject>" CACHE INTERNAL "")
        else()
            # Add the xml node for this current subproject
            set(xml_subproject_actions ${xml_subproject_actions} "\n <SubProject name=\"${SUB_PROJECT_NAME}\">" CACHE INTERNAL "")
            foreach(DEPENDENCY ${ADD_SUB_PROJECT_DEPENDENCIES})
                    set(xml_subproject_actions ${xml_subproject_actions} "\n  <Dependency name=\"${DEPENDENCY}\"/>" CACHE INTERNAL "")
            endforeach()
            set(xml_subproject_actions ${xml_subproject_actions} "  </SubProject>" CACHE INTERNAL "")
        endif()
        set(CAMITK_ACTION_TARGETS ${CAMITK_ACTION_TARGETS} ${SUB_PROJECT_NAME} CACHE STRING "List of CamiTK action targets" FORCE)
    endif()
    
    # APPLICATION
    if(ADD_SUB_PROJECT_APPLICATION)
        set(SUB_PROJECT_NAME ${ADD_SUB_PROJECT_APPLICATION})
        # Add the xml node for this current subproject
        set(xml_subproject_applications ${xml_subproject_applications} "\n <SubProject name=\"${SUB_PROJECT_NAME}\">" CACHE INTERNAL "")
        foreach(DEPENDENCY ${ADD_SUB_PROJECT_DEPENDENCIES})
                set(xml_subproject_applications ${xml_subproject_applications} "\n  <Dependency name=\"${DEPENDENCY}\"/>" CACHE INTERNAL "")
        endforeach()
        set(xml_subproject_applications ${xml_subproject_applications} " </SubProject>" CACHE INTERNAL "")
        set(CAMITK_APPLICATION_TARGETS ${CAMITK_APPLICATION_TARGETS} ${SUB_PROJECT_NAME} CACHE STRING "List of CamiTK applications targets" FORCE)
    endif()
    
    # CDash subprojects listing
    set(CAMITK_SUBPROJECTS ${CAMITK_SUBPROJECTS} ${SUB_PROJECT_NAME} CACHE INTERNAL "")

endmacro()