
/*
 Copyright 2012, Kovid Goyal <kovid at kovidgoyal.net>
 Released under the GPLv3 License
*/


(function() {
  var CalibreExtract, inline_styles, log, merge,
    __bind = function(fn, me){ return function(){ return fn.apply(me, arguments); }; };

  if (typeof window !== "undefined" && window !== null ? window.calibre_utils : void 0) {
    log = window.calibre_utils.log;
  }

  merge = function(node, cnode) {
    var name, rule, rules, style, val, _i, _len, _results;
    rules = node.ownerDocument.defaultView.getMatchedCSSRules(node, '');
    if (rules) {
      _results = [];
      for (_i = 0, _len = rules.length; _i < _len; _i++) {
        rule = rules[_i];
        style = rule.style;
        _results.push((function() {
          var _j, _len1, _results1;
          _results1 = [];
          for (_j = 0, _len1 = style.length; _j < _len1; _j++) {
            name = style[_j];
            val = style.getPropertyValue(name);
            if (val && !cnode.style.getPropertyValue(name)) {
              _results1.push(cnode.style.setProperty(name, val));
            } else {
              _results1.push(void 0);
            }
          }
          return _results1;
        })());
      }
      return _results;
    }
  };

  inline_styles = function(node) {
    var cnl, cnode, i, nl, _i, _len;
    cnode = node.cloneNode(true);
    merge(node, cnode);
    nl = node.getElementsByTagName('*');
    cnl = cnode.getElementsByTagName('*');
    for (i = _i = 0, _len = nl.length; _i < _len; i = ++_i) {
      node = nl[i];
      merge(node, cnl[i]);
    }
    return cnode;
  };

  CalibreExtract = (function() {

    CalibreExtract.name = 'CalibreExtract';

    function CalibreExtract() {
      this.extract = __bind(this.extract, this);

      this.mark = __bind(this.mark, this);
      if (!this instanceof arguments.callee) {
        throw new Error('CalibreExtract constructor called as function');
      }
      this.marked_node = null;
    }

    CalibreExtract.prototype.mark = function(node) {
      return this.marked_node = node;
    };

    CalibreExtract.prototype.extract = function(node) {
      var cnode;
      if (node == null) {
        node = null;
      }
      if (node === null) {
        node = this.marked_node;
      }
      cnode = inline_styles(node);
      return cnode.outerHTML;
    };

    return CalibreExtract;

  })();

  if (typeof window !== "undefined" && window !== null) {
    window.calibre_extract = new CalibreExtract();
  }

}).call(this);

