[![Build Status](https://travis-ci.org/haskell/c2hs.svg?branch=master)](https://travis-ci.org/haskell/c2hs)

`c2hs` is a interfacing tool that eases Haskell access to C libraries.
The tool gets information about the C data type definitions and
function signatures by analysing the C header files of the library.
It uses this information to compute the missing details in the
template of a Haskell module &mdash; called the binding file &mdash;
that implements a Haskell binding to the C library.  Hooks embedded in
the binding file signal where, which, and how C objects are accessed
from Haskell.  The Haskell code in the binding file determines Haskell
types signatures and marshaling details.

Further information is on the
[wiki](https://github.com/haskell/c2hs/wiki/Home).  Also see the
[user guide](https://github.com/haskell/c2hs/wiki/User-Guide) (also
available in the `doc` directory of the repository).


## Installing

To install `c2hs` from Hackage:

    cabal install c2hs

If you like to build from the GitHub repository, see the file
`INSTALL`.  See the `REGRESSION-SUITE` file for a description of how
to run the regression suite for checking C2HS performance against
existing Haskell packages that use it.


## License

All code **generated by** `c2hs` is under a BSD licence. Hence, `c2hs` is useful for both open and closed source projects.

The tool itself is released under the GPLv2. This is the same situation as for the GNU C Compiler. For details, see the file `COPYING`.
