import dump

header = """/* Copyright (C) 2006 Charlie C
*
* This software is provided 'as-is', without any express or implied
* warranty.  In no event will the authors be held liable for any damages
* arising from the use of this software.
*
* Permission is granted to anyone to use this software for any purpose,
* including commercial applications, and to alter it and redistribute it
* freely, subject to the following restrictions:
*
* 1. The origin of this software must not be misrepresented; you must not
*    claim that you wrote the original software. If you use this software
*    in a product, an acknowledgment in the product documentation would be
*    appreciated but is not required.
* 2. Altered source versions must be plainly marked as such, and must not be
*    misrepresented as being the original software.
* 3. This notice may not be removed or altered from any source distribution.
*/
// Auto generated from makesdna dna.c
"""

dtList = dump.DataTypeList

out = "../BlenderSerialize/autogenerated/"
spaces = 4


def addSpaces(file, space):
  for i in range(0, space):
    file.write(" ")


def write(file, spaces, string):
  addSpaces(file, spaces)
  file.write(string)


###################################################################################
blender = open(out + "blender.h", 'w')
blender.write(header)
blender.write("#ifndef __BLENDER_H__\n")
blender.write("#define __BLENDER_H__\n")
for dt in dtList:
  blender.write("#include \"%s.h\"\n" % dt.filename)

blender.write("#endif//__BLENDER_H__")
blender.close()

###################################################################################
blenderC = open(out + "blender_Common.h", 'w')
blenderC.write(header)
blenderC.write("#ifndef __BLENDERCOMMON_H__\n")
blenderC.write("#define __BLENDERCOMMON_H__\n")

strUnRes = """
// put an empty struct in the case
typedef struct bInvalidHandle {
	int unused;
}bInvalidHandle;

"""
blenderC.write(strUnRes)

blenderC.write("namespace Blender {\n")
for dt in dtList:
  write(blenderC, 4, "class %s;\n" % dt.name)

blenderC.write("}\n")
blenderC.write("#endif//__BLENDERCOMMON_H__")
blenderC.close()

for dt in dtList:
  fp = open(out + dt.filename + ".h", 'w')

  fp.write(header)
  strUpper = dt.filename.upper()

  fp.write("#ifndef __%s__H__\n" % strUpper)
  fp.write("#define __%s__H__\n" % strUpper)
  fp.write("\n\n")

  fp.write("// -------------------------------------------------- //\n")
  fp.write("#include \"blender_Common.h\"\n")

  for i in dt.includes:
    fp.write("#include \"%s\"\n" % i)

  fp.write("\nnamespace Blender {\n")
  fp.write("\n\n")

  addSpaces(fp, 4)
  fp.write("// ---------------------------------------------- //\n")

  write(fp, 4, "class %s\n" % dt.name)

  write(fp, 4, "{\n")
  write(fp, 4, "public:\n")
  for i in dt.dataTypes:
    write(fp, 8, i + ";\n")

  write(fp, 4, "};\n")
  fp.write("}\n")
  fp.write("\n\n")
  fp.write("#endif//__%s__H__\n" % strUpper)
  fp.close()
