# Functional test: tests of Datafield object

import unittest
import numpy
import bornagain as ba


class DatafieldTest(unittest.TestCase):
    """
    Test creation of ba.Datafield object.
    """

    def test_create_1d_output_data_from_numpy(self):
        input = numpy.array([0, 1, 2, 3, 4, 5, 6], dtype=float)
        output_data = ba.importArrayToDatafield(input)
        output = output_data.npArray()
        self.assertEqual(input.size, output.size)
        numpy.testing.assert_allclose(input, output)

    def test_create_2d_output_data_from_numpy(self):
        input = numpy.array([[0, 1], [2, 3]], dtype=float)
        output_data = ba.importArrayToDatafield(input)
        output = output_data.npArray()
        self.assertEqual(input.size, output.size)
        numpy.testing.assert_allclose(input, output)

if __name__ == '__main__':
    unittest.main()
