/***************************************************************************
 *   Copyright (C) 2005-2006 Gao Xianchao                                  *
 *                 2007 Gao Xianchao gnap_an linux_lyb ahlongxp            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

/*
 * Author:	gxc
 * Create data:	2005-10-12 20:09
 */

#ifndef EPOLLREACTOR_H_
#define EPOLLREACTOR_H_

#include <list>
#include "BitStorm.h"

typedef struct
{
	unsigned int id;
	unsigned int interval;
	unsigned int lastShotTick;
	ITimerCallback* callback;
	bool oneShot;
	bool remove;
} TTimerInfo;

typedef std::list<TTimerInfo> TTimerList;
typedef std::list<unsigned int> TTimerIDList;

class CEpollReactor : public ISocketReactor
{
public:
	CEpollReactor();
	virtual ~CEpollReactor();
private:
	int _epollHandle;
	bool _toExit;
	unsigned int _freeTimerID;
	TTimerIDList _freeTimerIDList;
	TTimerList _timerList;
	TTimerList _timerAddList;
	struct epoll_event* _epollEvents;
private:
	void updateTimerList();	
public:	
	bool addSocket(ISocket* socket);
	void removeSocket(ISocket* socket);
	void updateMask(ISocket* socket);
	
	unsigned int addTimer(ITimerCallback* callback, unsigned int interval,  bool oneShot);
	void removeTimer(unsigned int id);
	
	bool start();
	void update();
	void stop() ;	
};

#endif /*EPOLLREACTOR_H_*/
