\newpage

# The Barman project

## Support and sponsor opportunities

Barman is free software, written and maintained by EnterpriseDB. If you
require support on using Barman, or if you need new features, please
get in touch with EnterpriseDB. You can sponsor the development of new
features of Barman and PostgreSQL which will be made publicly
available as open source.

For further information, please visit:

- [Barman website][11]
- [Support section][12]
- [EnterpriseDB website][13]
- [Barman FAQs][14]
- [2ndQuadrant blog: Barman][15]

## Contributing to Barman

EnterpriseDB has a team of software engineers, architects, database
administrators, system administrators, QA engineers, developers and
managers that dedicate their time and expertise to improve Barman's code.
We adopt lean and agile methodologies for software development, and
we believe in the _devops_ culture that allowed us to implement rigorous
testing procedures through cross-functional collaboration.
Every Barman commit is the contribution of multiple individuals, at different
stages of the production pipeline.

Even though this is our preferred way of developing Barman, we gladly
accept patches from external developers, as long as:

- user documentation (tutorial and man pages) is provided.
- source code is properly documented and contains relevant comments.
- code supplied is covered by unit tests.
- no unrelated feature is compromised or broken.
- source code is rebased on the current master branch.
- commits and pull requests are limited to a single feature (multi-feature
patches are hard to test and review).
- changes to the user interface are discussed beforehand with EnterpriseDB.

We also require that any contributions provide a copyright assignment
and a disclaimer of any work-for-hire ownership claims from the employer
of the developer.

You can use Github's pull requests system for this purpose.

## Authors

In alphabetical order:

* Abhijit Menon-Sen
* Jane Threefoot
* Michael Wallace

Past contributors (in alphabetical order):

* Anna Bellandi (QA/testing)
* Britt Cole (documentation reviewer)
* Carlo Ascani (developer)
* Francesco Canovai (QA/testing)
* Gabriele Bartolini (architect)
* Gianni Ciolli (QA/testing)
* Giulio Calacoci (developer)
* Giuseppe Broccolo (developer)
* Jonathan Battiato (QA/testing)
* Leonardo Cecchi (developer)
* Marco Nenciarini (project leader)
* Niccolò Fei (QA/testing)
* Rubens Souza (QA/testing)
* Stefano Bianucci (developer)

## Links

- [check-barman][16]: a Nagios plugin for Barman, written by Holger
  Hamann (MIT license)
- [puppet-barman][17]: Barman module for Puppet (GPL)
- [Tutorial on "How To Back Up, Restore, and Migrate PostgreSQL Databases with Barman on CentOS 7"][26], by Sadequl Hussain (available on DigitalOcean Community)
- [BarmanAPI][27]: RESTFul API for Barman, written by Mehmet Emin Karakaş (GPL)

## License and Contributions

Barman is the property of EnterpriseDB UK Limited and its code is
distributed under GNU General Public License 3.

© Copyright EnterpriseDB UK Limited 2011-2022

Barman has been partially funded through [4CaaSt][18], a research
project funded by the European Commission's Seventh Framework
programme.

Contributions to Barman are welcome, and will be listed in the
`AUTHORS` file. EnterpriseDB UK Limited requires that any contributions
provide a copyright assignment and a disclaimer of any work-for-hire
ownership claims from the employer of the developer. This lets us make
sure that all of the Barman distribution remains free code. Please
contact barman@enterprisedb.com for a copy of the relevant Copyright
Assignment Form.
