//
// BAGEL - Parallel electron correlation program.
// Filename: _complex_eriroot_6.cc
// Copyright (C) 2013 Toru Shiozaki
//
// Author: Ryan D. Reynolds <RyanDReynolds@u.northwestern.edu>
// Maintainer: Shiozaki group
//
// This file is part of the BAGEL package.
//
// The BAGEL package is free software; you can redistribute it and/or modify
// it under the terms of the GNU Library General Public License as published by
// the Free Software Foundation; either version 3, or (at your option)
// any later version.
//
// The BAGEL package is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public License
// along with the BAGEL package; see COPYING.  If not, write to
// the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
//

#include <algorithm>
#include <complex>
#include "comperirootlist.h"

using namespace std;
using namespace bagel;

void ComplexERIRootList::complex_eriroot6(const complex<double>* ta, complex<double>* rr, complex<double>* ww, const int n) {

  static constexpr double ax[6] = {9.874701406848116e-02,8.983028345696176e-01,2.552589802668170e+00,5.196152530054465e+00,9.124248037531178e+00,
    1.512995978110807e+01};
  static constexpr double aw[6] = {5.701352362624799e-01,2.604923102641610e-01,5.160798561588392e-02,3.905390584629060e-03,8.573687043587890e-05,
    2.658551684356309e-07};
  static constexpr double xr[20280] = {   3.403009729197280e-02,  -1.390072396736739e-03,   4.179041520415700e-05,  -1.088856592366314e-06,   2.569953979567360e-08,
  -5.561676991108144e-10,   1.096220880855613e-11,  -1.913276782296516e-13,   2.717762835954217e-15,  -2.137067956133818e-17,  -4.125629266725559e-19,   2.689340804471909e-20,
  -8.705793297848696e-22,   1.987516038694328e-23,   3.403404433309250e-02,  -1.390380485507232e-03,   4.180495870138687e-05,  -1.089381175682930e-06,   2.571503920035781e-08,
  -5.565454531980332e-10,   1.096930275951761e-11,  -1.913960168630657e-13,   2.715844508631585e-15,  -2.122627001771629e-17,  -4.180742618514867e-19,   2.704065062224759e-20,
  -8.732652239726669e-22,   1.990972630084805e-23,   3.404101006830634e-02,  -1.390924233500604e-03,   4.183062803926581e-05,  -1.090307099461476e-06,   2.574239623855197e-08,
  -5.572121137435888e-10,   1.098181594560617e-11,  -1.915162009865763e-13,   2.712440577015161e-15,  -2.097083790257043e-17,  -4.278126401259303e-19,   2.730066769920773e-20,
  -8.780071834790462e-22,   1.997069930027237e-23,   3.404943501822623e-02,  -1.391581944910615e-03,   4.186167979953824e-05,  -1.091427227956570e-06,   2.577549046037649e-08,
  -5.580184296794230e-10,   1.099693983129257e-11,  -1.916608449118011e-13,   2.708292056147965e-15,  -2.066091027724047e-17,  -4.396114881333309e-19,   2.761543297783263e-20,
  -8.837457182661510e-22,   2.004439461404989e-23,   3.405761581278672e-02,  -1.392220655045879e-03,   4.189183700885033e-05,  -1.092515144146817e-06,   2.580763220388027e-08,
  -5.588013781785831e-10,   1.101161427003798e-11,  -1.918005449627063e-13,   2.704230721511686e-15,  -2.035893091859482e-17,  -4.510898038983694e-19,   2.792136790746855e-20,
  -8.893212775555486e-22,   2.011589956972164e-23,   3.406420758712369e-02,  -1.392735345915454e-03,   4.191614036481020e-05,  -1.093391924210271e-06,   2.583353552180285e-08,
  -5.594322477207634e-10,   1.102343035969849e-11,  -1.919125701787317e-13,   2.700934557543001e-15,  -2.011486659387186e-17,  -4.603539318939394e-19,   2.816808743878903e-20,
  -8.938162138409827e-22,   2.017347519797967e-23,   3.406856401576638e-02,  -1.393075520034537e-03,   4.193220404615926e-05,  -1.093971465514132e-06,   2.585065703794123e-08,
  -5.598491817059138e-10,   1.103123554392282e-11,  -1.919863417033623e-13,   2.698744549900589e-15,  -1.995320441509312e-17,  -4.664839989778135e-19,   2.833124371944966e-20,
  -8.967880134512598e-22,   2.021150603554401e-23,   3.407080146732386e-02,  -1.393250239092978e-03,   4.194045489361623e-05,  -1.094269143577858e-06,   2.585945132188071e-08,
  -5.600633178284350e-10,   1.103524304933210e-11,  -1.920241486577416e-13,   2.697616174604557e-15,  -1.987006285904397e-17,  -4.696347099966338e-19,   2.841507198063649e-20,
  -8.983146756762816e-22,   2.023103222285586e-23,   3.407158026737800e-02,  -1.393311055382393e-03,   4.194332689610356e-05,  -1.094372762049610e-06,   2.586251250225407e-08,
  -5.601378531388360e-10,   1.103663776593487e-11,  -1.920372952483493e-13,   2.697222843732546e-15,  -1.984110552437133e-17,  -4.707317623033623e-19,   2.844425549492451e-20,
  -8.988461240272474e-22,   2.023782777073552e-23,   3.407170385386101e-02,  -1.393320706266606e-03,   4.194378265376377e-05,  -1.094389205296332e-06,   2.586299828125524e-08,
  -5.601496810213476e-10,   1.103685908196416e-11,  -1.920393808392520e-13,   2.697160399549462e-15,  -1.983650948474754e-17,  -4.709058692635847e-19,   2.844888681675172e-20,
  -8.989304613360139e-22,   2.023890609620691e-23,   2.903844646344079e-01,  -1.021201868729264e-02,   2.215344148720468e-04,  -2.798218589037832e-06,  -9.104311927257046e-09,
   1.492081184706092e-09,  -3.772910297070608e-11,   2.928813468908003e-13,   1.288171535860545e-14,  -5.673733781823155e-16,   9.505888750065577e-18,   6.395521265208336e-20,
  -8.016890067239804e-21,   1.959866545884722e-22,   2.904052225614558e-01,  -1.021280074056165e-02,   2.215289967636072e-04,  -2.796815202212794e-06,  -9.156957919522755e-09,
   1.492627520670661e-09,  -3.769449820738355e-11,   2.909766618744555e-13,   1.292021859476956e-14,  -5.669902958628798e-16,   9.456155571234406e-18,   6.533394877072178e-20,
  -8.020000580113477e-21,   1.950044753763506e-22,   2.904418498025492e-01,  -1.021418036420195e-02,   2.215194124472897e-04,  -2.794338496953256e-06,  -9.249812730382102e-09,
   1.493588495572251e-09,  -3.763335635675461e-11,   2.876169052904683e-13,   1.298798748107224e-14,  -5.663086172885887e-16,   9.368387453323021e-18,   6.776087478980150e-20,
  -8.025262083385664e-21,   1.932686783401734e-22,   2.904861390891612e-01,  -1.021584807133748e-02,   2.215077821164564e-04,  -2.791342945887484e-06,  -9.362025714004990e-09,
   1.494745328492907e-09,  -3.755928477217526e-11,   2.835561211153438e-13,   1.306964329220877e-14,  -5.654745816504445e-16,   9.262235678968194e-18,   7.068551054613721e-20,
  -8.031237771237232e-21,   1.911651242865690e-22,   2.905291335596385e-01,  -1.021746647808360e-02,   2.214964488067539e-04,  -2.788434193501387e-06,  -9.470888799040231e-09,
   1.495862930410138e-09,  -3.748723295105472e-11,   2.796159533521919e-13,   1.314860852140651e-14,  -5.646547335269949e-16,   9.159163717803226e-18,   7.351418021220361e-20,
  -8.036634753837018e-21,   1.891182528410532e-22,   2.905637687699764e-01,  -1.021876983384937e-02,   2.214872881952825e-04,  -2.786090423615014e-06,  -9.558536315451779e-09,
   1.496759365474258e-09,  -3.742908569694067e-11,   2.764432274041388e-13,   1.321200345850645e-14,  -5.639869953107939e-16,   9.076115468912901e-18,   7.578537536579070e-20,
  -8.040693450109796e-21,   1.874659317080573e-22,   2.905866548175171e-01,  -1.021963086653823e-02,   2.214812200266086e-04,  -2.784541449767508e-06,  -9.616427156375458e-09,
   1.497349809351328e-09,  -3.739061256690209e-11,   2.743474467135022e-13,   1.325378674809314e-14,  -5.635422078502106e-16,   9.021231692431546e-18,   7.728244290485033e-20,
  -8.043234044668450e-21,   1.863724625515281e-22,   2.905984078105420e-01,  -1.022007298567684e-02,   2.214780990937936e-04,  -2.783745899628395e-06,  -9.646149113169581e-09,
   1.497652441663567e-09,  -3.737083918773899e-11,   2.732713803835928e-13,   1.327521138770264e-14,  -5.633126891943841e-16,   8.993044150668094e-18,   7.805011433641091e-20,
  -8.044495100602867e-21,   1.858104081628491e-22,   2.906024985334653e-01,  -1.022022685936586e-02,   2.214770120862819e-04,  -2.783468988717785e-06,  -9.656492876584501e-09,
   1.497757681870918e-09,  -3.736395440244700e-11,   2.728968803162550e-13,   1.328266316335815e-14,  -5.632326282770878e-16,   8.983232890207021e-18,   7.831712714878935e-20,
  -8.044927075665534e-21,   1.856146997523586e-22,   2.906031476741933e-01,  -1.022025127652989e-02,   2.214768395581142e-04,  -2.783425046181540e-06,  -9.658134230704001e-09,
   1.497774377592445e-09,  -3.736286176416029e-11,   2.728374539607958e-13,   1.328384540751238e-14,  -5.632199154139241e-16,   8.981675962811735e-18,   7.835948975083579e-20,
  -8.044995294440144e-21,   1.855836397194275e-22,   7.268341727240334e-01,  -1.870924845375437e-02,   1.479346377278326e-04,   3.741825247850602e-06,  -9.382152489014208e-08,
  -9.059755102677758e-10,   6.029463952450697e-11,  -8.855134499100212e-14,  -3.699120354308550e-14,   4.570037143296225e-16,   2.024640759604835e-17,  -5.499694667634804e-19,
  -8.037475155605363e-21,   4.725895671491445e-22,   7.268479365852885e-01,  -1.870819906380511e-02,   1.478823348672367e-04,   3.740974650117728e-06,  -9.373786093979572e-08,
  -9.061265829534767e-10,   6.019926422838981e-11,  -8.707907145723902e-14,  -3.690737705819476e-14,   4.542949782571567e-16,   2.019697436525616e-17,  -5.466788829197078e-19,
  -8.031320751651002e-21,   4.695700843653294e-22,   7.268722192048915e-01,  -1.870634759340638e-02,   1.477900836420846e-04,   3.739473648976267e-06,  -9.359034294493336e-08,
  -9.063908308797289e-10,   6.003115095004593e-11,  -8.448856124733102e-14,  -3.675963318210648e-14,   4.495289969622588e-16,   2.010978179411619e-17,  -5.408903121006781e-19,
  -8.020262382444409e-21,   4.642596148673981e-22,   7.269015753087380e-01,  -1.870410910757064e-02,   1.476785972262422e-04,   3.737658439300164e-06,  -9.341214723642396e-08,
  -9.067064107118057e-10,   5.982816971951505e-11,  -8.136857785288032e-14,  -3.658126825597864e-14,   4.437891046311838e-16,   2.000440478821997e-17,  -5.339208473562740e-19,
  -8.006553587144477e-21,   4.578678319726356e-22,   7.269300666933065e-01,  -1.870193637190562e-02,   1.475704359075293e-04,   3.735896074992162e-06,  -9.323935108994701e-08,
  -9.070086422431007e-10,   5.963143618640649e-11,  -7.835279821553247e-14,  -3.640841673304883e-14,   4.382411293828315e-16,   1.990216735023382e-17,  -5.271864808495480e-19,
  -7.992895223895720e-21,   4.516938062426557e-22,   7.269530139592332e-01,  -1.870018629340206e-02,   1.474833510781269e-04,   3.734476202034345e-06,  -9.310028703731587e-08,
  -9.072491655486033e-10,   5.947317721220398e-11,  -7.593265016580559e-14,  -3.626938614472749e-14,   4.337890558501624e-16,   1.981985031525586e-17,  -5.217838471189071e-19,
  -7.981643267557567e-21,   4.467422452256339e-22,   7.269681746450949e-01,  -1.869902999467098e-02,   1.474258307198449e-04,   3.733537909516704e-06,  -9.300846364192607e-08,
  -9.074066573077971e-10,   5.936871355767431e-11,  -7.433801594306642e-14,  -3.617762310957894e-14,   4.308556588297930e-16,   1.976547852569641e-17,  -5.182248664461696e-19,
  -7.974087039575656e-21,   4.434811639340428e-22,   7.269759596224797e-01,  -1.869843621766641e-02,   1.473962986045731e-04,   3.733056031167836e-06,  -9.296132884649089e-08,
  -9.074870915984687e-10,   5.931510079875894e-11,  -7.352050215375073e-14,  -3.613053114468267e-14,   4.293518296544468e-16,   1.973756281570119e-17,  -5.164005508898801e-19,
  -7.970169254120479e-21,   4.418097841228065e-22,   7.269786691341370e-01,  -1.869822955414762e-02,   1.473860208498644e-04,   3.732888305780678e-06,  -9.294492647750834e-08,
  -9.075150166579248e-10,   5.929644585010661e-11,  -7.323618284474791e-14,  -3.611414556741237e-14,   4.288288233966421e-16,   1.972784758518028e-17,  -5.157661205727813e-19,
  -7.968799709016355e-21,   4.412285765648075e-22,   7.269790990905762e-01,  -1.869819675977850e-02,   1.473843899672056e-04,   3.732861689919231e-06,  -9.294232380543010e-08,
  -9.075194446187447e-10,   5.929348582599069e-11,  -7.319107590959414e-14,  -3.611154564940197e-14,   4.287458492131901e-16,   1.972630596363893e-17,  -5.156654708172123e-19,
  -7.968582100128103e-21,   4.411363721519119e-22,   1.223523953586138e+00,  -1.882980491971795e-02,  -1.326629548869124e-04,   3.798701664330292e-06,   8.565424882974308e-08,
  -9.543842001331062e-10,  -5.484962065021644e-11,  -2.948673126676905e-14,   3.292712864105220e-14,   3.793256127879759e-16,  -1.747403626983609e-17,  -4.590966262912642e-19,
   7.240052663761921e-21,   3.925935205740069e-22,   1.223511612306218e+00,  -1.882873968964554e-02,  -1.326152036495408e-04,   3.797806624036677e-06,   8.557811894053356e-08,
  -9.544229498572932e-10,  -5.476467590850050e-11,  -2.826505066638330e-14,   3.285483225967284e-14,   3.770639652793466e-16,  -1.742973064196390e-17,  -4.563623676022428e-19,
   7.229612440496415e-21,   3.900976592291733e-22,   1.223489839511914e+00,  -1.882686027909995e-02,  -1.325309804187018e-04,   3.796227287697501e-06,   8.544388308345586e-08,
  -9.544893975854258e-10,  -5.461494300205771e-11,  -2.611550456366489e-14,   3.272741567915444e-14,   3.730845757962214e-16,  -1.735160654479233e-17,  -4.515523701855516e-19,
   7.211066371099062e-21,   3.857080160055104e-22,   1.223463517732932e+00,  -1.882458802477737e-02,  -1.324291957176598e-04,   3.794317497968738e-06,   8.528172812310041e-08,
  -9.545664682388236e-10,  -5.443414575593300e-11,  -2.352667900320847e-14,   3.257360041733990e-14,   3.682919206452541e-16,  -1.725723034072341e-17,  -4.457609829807709e-19,
   7.188430120528174e-21,   3.804244118172540e-22,   1.223437971408438e+00,  -1.882238252507475e-02,  -1.323304465639909e-04,   3.792463467210478e-06,   8.512448297577611e-08,
  -9.546378622034380e-10,  -5.425890435600896e-11,  -2.102438574572925e-14,   3.242454947380418e-14,   3.636594150657404e-16,  -1.716570873099460e-17,  -4.401648193961830e-19,
   7.166237095815847e-21,   3.753206579277626e-22,   1.223417396207715e+00,  -1.882060606504846e-02,  -1.322509396909280e-04,   3.790969856407581e-06,   8.499793151820012e-08,
  -9.546929282965549e-10,  -5.411792788113399e-11,  -1.901635727040977e-14,   3.230466948886034e-14,   3.599419080834318e-16,  -1.709205011071030e-17,  -4.356752103860762e-19,
   7.148203729763880e-21,   3.712273433098731e-22,   1.223403802726433e+00,  -1.881943234012006e-02,  -1.321984245770619e-04,   3.789982891774871e-06,   8.491436884234874e-08,
  -9.547281188103046e-10,  -5.402486888648535e-11,  -1.769329264197745e-14,   3.222554963422735e-14,   3.574924710900463e-16,  -1.704341222913964e-17,  -4.327176367756052e-19,
   7.136212274204092e-21,   3.685314459249735e-22,   1.223396822517465e+00,  -1.881882961585905e-02,  -1.321714622345714e-04,   3.789476034198670e-06,   8.487147404068690e-08,
  -9.547458214052802e-10,  -5.397710823406417e-11,  -1.701501069992989e-14,   3.218494708108938e-14,   3.562367374521966e-16,  -1.701844502693006e-17,  -4.312015848429417e-19,
   7.130030906914052e-21,   3.671497191378441e-22,   1.223394393102300e+00,  -1.881861983847283e-02,  -1.321620788078096e-04,   3.789299617145550e-06,   8.485654707736366e-08,
  -9.547519241893206e-10,  -5.396048941150152e-11,  -1.677911538379603e-14,   3.217081965083602e-14,   3.558000129554141e-16,  -1.700975666620138e-17,  -4.306743550297584e-19,
   7.127875745170866e-21,   3.666692331727284e-22,   1.223394007592817e+00,  -1.881858654999042e-02,  -1.321605898376948e-04,   3.789271622159008e-06,   8.485417851461370e-08,
  -9.547528898281924e-10,  -5.395785245680236e-11,  -1.674169091696969e-14,   3.216857804343753e-14,   3.557307271694947e-16,  -1.700837802389875e-17,  -4.305907120820263e-19,
   7.127533576176246e-21,   3.665930073909067e-22,   1.657622435447476e+00,  -1.105351332529015e-02,  -2.151052160790227e-04,  -2.195907392257828e-06,   2.049701401958161e-08,
   1.410082342764905e-09,   2.744379653634619e-11,   3.957029011435309e-14,  -1.335403374051714e-14,  -3.982210678750035e-16,  -3.802742973178365e-18,   1.208218014748453e-19,
   5.993054474927372e-21,   9.530433464536386e-23,   1.657602292955120e+00,  -1.105412626500181e-02,  -2.150934712802201e-04,  -2.194584985646917e-06,   2.053518817836046e-08,
   1.410139177335171e-09,   2.740843871604794e-11,   3.824328939569005e-14,  -1.336890401778213e-14,  -3.975729835044266e-16,  -3.766192764343010e-18,   1.214738394463807e-19,
   5.981720573944025e-21,   9.448967396107072e-23,   1.657566752130703e+00,  -1.105520750433267e-02,  -2.150727300388772e-04,  -2.192251541502546e-06,   2.060250654102436e-08,
   1.410237347251417e-09,   2.734601825960128e-11,   3.590357228053936e-14,  -1.339501796630355e-14,  -3.964267409584163e-16,  -3.701757430526673e-18,   1.226195408762921e-19,
   5.961624552369223e-21,   9.305317346684286e-23,   1.657523777356016e+00,  -1.105651443480697e-02,  -2.150476199222812e-04,  -2.189429854134690e-06,   2.068383947476065e-08,
   1.410352450112447e-09,   2.727048605636185e-11,   3.307742957162377e-14,  -1.342638242258672e-14,  -3.950361236940222e-16,  -3.623940907166867e-18,   1.239967041536628e-19,
   5.937159079433186e-21,   9.131783239777490e-23,   1.657482059833796e+00,  -1.105778264027159e-02,  -2.150232124898874e-04,  -2.186690545592083e-06,   2.076272363580041e-08,
   1.410460417129745e-09,   2.719710572487047e-11,   3.033707852537677e-14,  -1.345660781851793e-14,  -3.936813700657728e-16,  -3.548502455457428e-18,   1.253250161697197e-19,
   5.913236172067566e-21,   8.963498647631202e-23,   1.657448453919944e+00,  -1.105880390317816e-02,  -2.150035280042892e-04,  -2.184483749894838e-06,   2.082621976351940e-08,
   1.410544692512126e-09,   2.713795225754463e-11,   2.813179850191331e-14,  -1.348079758308508e-14,  -3.925865954540143e-16,  -3.487805377639386e-18,   1.263889187449326e-19,
   5.893841261117663e-21,   8.828060842522046e-23,   1.657426248308587e+00,  -1.105947854606451e-02,  -2.149905099938015e-04,  -2.183025517290146e-06,   2.086815144037523e-08,
   1.410599058208656e-09,   2.709884555976088e-11,   2.667572214560896e-14,  -1.349670374215356e-14,  -3.918615268593607e-16,  -3.447734748650907e-18,   1.270889079796427e-19,
   5.880965457958621e-21,   8.738630283693169e-23,   1.657414844843428e+00,  -1.105982494887794e-02,  -2.149838212671017e-04,  -2.182276638565148e-06,   2.088967749552175e-08,
   1.410626568916503e-09,   2.707875649399455e-11,   2.592830816278162e-14,  -1.350484820248800e-14,  -3.914886568226920e-16,  -3.427168006238664e-18,   1.274474527333971e-19,
   5.874334606075506e-21,   8.692723443973160e-23,   1.657410875791418e+00,  -1.105994550822192e-02,  -2.149814926604199e-04,  -2.182015983438271e-06,   2.089716858350192e-08,
   1.410636079221858e-09,   2.707176337180944e-11,   2.566821977876477e-14,  -1.350767911856234e-14,  -3.913587944772039e-16,  -3.420011387179338e-18,   1.275720989792516e-19,
   5.872023734141147e-21,   8.676748349171714e-23,   1.657410245958878e+00,  -1.105996463888663e-02,  -2.149811231172559e-04,  -2.181974621010760e-06,   2.089835725652502e-08,
   1.410637585288554e-09,   2.707065361508340e-11,   2.562694998853588e-14,  -1.350812816377564e-14,  -3.913381832436299e-16,  -3.418875816933277e-18,   1.275918715707676e-19,
   5.871656890942764e-21,   8.674213473854701e-23,   1.932186917526706e+00,  -2.523771768320294e-03,  -6.813701724999202e-05,  -1.558583747939428e-06,  -3.119167089461968e-08,
  -5.385619599980650e-10,  -7.429764921007667e-12,  -5.640476381494195e-14,   9.556544903248364e-16,   5.829301094149177e-17,   1.735704695491937e-18,   3.839701543800508e-20,
   6.919671534429046e-22,   6.943234391002674e-24,   1.932180494353309e+00,  -2.524211900943932e-03,  -6.815462130957074e-05,  -1.559089552114441e-06,  -3.120208724675507e-08,
  -5.386697826114551e-10,  -7.427101896095731e-12,  -5.620281033755798e-14,   9.631123299585619e-16,   5.849279318270654e-17,   1.739924012089651e-18,   3.844384388850312e-20,
   6.906389558678250e-22,   6.872033510738316e-24,   1.932169159213861e+00,  -2.524988637705814e-03,  -6.818568870608997e-05,  -1.559982132735167e-06,  -3.122046395869420e-08,
  -5.388597114918151e-10,  -7.422386948702511e-12,  -5.584591075644906e-14,   9.762862220043189e-16,   5.884550434843044e-17,   1.747362270926560e-18,   3.852604761854439e-20,
   6.882853678549463e-22,   6.746212390401445e-24,   1.932155450341822e+00,  -2.525928073598493e-03,  -6.822326384305342e-05,  -1.561061589034464e-06,  -3.124267996779327e-08,
  -5.390888193743839e-10,  -7.416658284928167e-12,  -5.541340668161345e-14,   9.922407985658591e-16,   5.927233304839706e-17,   1.756345078154500e-18,   3.862472244915907e-20,
   6.854223741894394e-22,   6.593750485309946e-24,   1.932142139596968e+00,  -2.526840268538695e-03,  -6.825974962614593e-05,  -1.562109651106742e-06,  -3.126424131102445e-08,
  -5.393106501768979e-10,  -7.411068383234084e-12,  -5.499255723991699e-14,   1.007754929509932e-15,   5.968703139718000e-17,   1.765053224958004e-18,   3.871975219889886e-20,
   6.826251875619325e-22,   6.445409899902560e-24,   1.932131414907621e+00,  -2.527575269129456e-03,  -6.828914818108815e-05,  -1.562954059721130e-06,  -3.128160684376859e-08,
  -5.394889358083367e-10,  -7.406544710352441e-12,  -5.465282250384057e-14,   1.020271314051716e-15,   6.002134980952752e-17,   1.772059617463308e-18,   3.879576022456898e-20,
   6.803590060361595e-22,   6.325669522690808e-24,   1.932124327378574e+00,  -2.528061016998233e-03,  -6.830857720030234e-05,  -1.563512080474854e-06,  -3.129307971293548e-08,
  -5.396065387090649e-10,  -7.403545492761143e-12,  -5.442798706648144e-14,   1.028550922403541e-15,   6.024237990318623e-17,   1.776685006655292e-18,   3.884571701544092e-20,
   6.788552759644922e-22,   6.246429973465508e-24,   1.932120687331822e+00,  -2.528310494215551e-03,  -6.831855585215573e-05,  -1.563798666462448e-06,  -3.129897097137968e-08,
  -5.396668699595887e-10,  -7.402002139752603e-12,  -5.431241665898906e-14,   1.032805680898633e-15,   6.035592596637356e-17,   1.779059029686787e-18,   3.887128929013799e-20,
   6.780810954122256e-22,   6.205700382388301e-24,   1.932119420338589e+00,  -2.528397330618964e-03,  -6.832202915990748e-05,  -1.563898417827076e-06,  -3.130102138081827e-08,
  -5.396878586957791e-10,  -7.401464466141782e-12,  -5.427217433866363e-14,   1.034287031572351e-15,   6.039545252130229e-17,   1.779885117270084e-18,   3.888017674705251e-20,
   6.778113252616649e-22,   6.191518294687475e-24,   1.932119219282236e+00,  -2.528411110529892e-03,  -6.832258033297157e-05,  -1.563914247112894e-06,  -3.130134674795016e-08,
  -5.396911888392042e-10,  -7.401379121220559e-12,  -5.426578763043174e-14,   1.034522122551898e-15,   6.040172511674501e-17,   1.780016195881860e-18,   3.888158643695602e-20,
   6.777685017570048e-22,   6.189267518207873e-24,   2.906456208804606e-02,  -1.101784778611767e-03,   3.086595300546530e-05,  -7.540105464961622e-07,   1.682069334884583e-08,
  -3.483124157711296e-10,   6.694591044484694e-12,  -1.181428420196244e-13,   1.847958251163387e-15,  -2.341181892086015e-17,   1.453827656614158e-19,   3.708198585631805e-21,
  -2.047132803446910e-22,   7.116688139131068e-24,   2.906747486782894e-02,  -1.101998001214418e-03,   3.087546812320654e-05,  -7.543390560500468e-07,   1.683016512076406e-08,
  -3.485462556700455e-10,   6.699453569864432e-12,  -1.182212961154864e-13,   1.848528477036737e-15,  -2.339062801034027e-17,   1.440520757069952e-19,   3.761254391157946e-21,
  -2.060936595885785e-22,   7.135034861886177e-24,   2.907261524528866e-02,  -1.102374311315625e-03,   3.089226204354534e-05,  -7.549188949490114e-07,   1.684688377535937e-08,
  -3.489589951501815e-10,   6.708034763143033e-12,  -1.183596699321224e-13,   1.849530029147102e-15,  -2.335301285958076e-17,   1.416970976265180e-19,   3.854981730545190e-21,
  -2.085303294202526e-22,   7.167442212243321e-24,   2.907883229249167e-02,  -1.102829478212055e-03,   3.091257684246205e-05,  -7.556203469735811e-07,   1.686710963919287e-08,
  -3.494582977194503e-10,   6.718413257260682e-12,  -1.185268908666416e-13,   1.850733222118134e-15,  -2.330714689146563e-17,   1.388375712279305e-19,   3.968504737495869e-21,
  -2.114784326751978e-22,   7.206687877471508e-24,   2.908486900133547e-02,  -1.103271481166874e-03,   3.093230586056549e-05,  -7.563016235485769e-07,   1.688675449466943e-08,
  -3.499432355843089e-10,   6.728490630003702e-12,  -1.186891185333116e-13,   1.851892973066074e-15,  -2.326222128024735e-17,   1.360491666992539e-19,   4.078906811597325e-21,
  -2.143421394955519e-22,   7.244847889858101e-24,   2.908973303217062e-02,  -1.103627649616054e-03,   3.094820486469638e-05,  -7.568506797847085e-07,   1.690258725540362e-08,
  -3.503340553512875e-10,   6.736610336315858e-12,  -1.188197296133553e-13,   1.852821300332763e-15,  -2.322574310772671e-17,   1.337939581926349e-19,   4.167985776092201e-21,
  -2.166503541194163e-22,   7.275632731467513e-24,   2.909294755581176e-02,  -1.103863046698781e-03,   3.095871336817368e-05,  -7.572135983594624e-07,   1.691305274843013e-08,
  -3.505923804703395e-10,   6.741976428434952e-12,  -1.189059970288659e-13,   1.853431801755414e-15,  -2.320149849817228e-17,   1.322993947044197e-19,   4.226916406561030e-21,
  -2.181761944969267e-22,   7.295996139473720e-24,   2.909459850939042e-02,  -1.103983948999319e-03,   3.096411083032084e-05,  -7.574000090531599e-07,   1.691842835824515e-08,
  -3.507250670136602e-10,   6.744732400220502e-12,  -1.189502876715606e-13,   1.853744418927655e-15,  -2.318900426098352e-17,   1.315305156264589e-19,   4.257201404414155e-21,
  -2.189599764997997e-22,   7.306460314805263e-24,   2.909517316149147e-02,  -1.104026032482352e-03,   3.096598960063626e-05,  -7.574648965174698e-07,   1.692029956015707e-08,
  -3.507712536378349e-10,   6.745691677486460e-12,  -1.189657015534018e-13,   1.853853084083769e-15,  -2.318464860463161e-17,   1.312626854020607e-19,   4.267745767101509e-21,
  -2.192328092721065e-22,   7.310103515568735e-24,   2.909526435193807e-02,  -1.104032710662149e-03,   3.096628774198099e-05,  -7.574751935262477e-07,   1.692059650228056e-08,
  -3.507785830021251e-10,   6.745843903287519e-12,  -1.189681474347652e-13,   1.853870320903661e-15,  -2.318395709326938e-17,   1.312201742353814e-19,   4.269419173281724e-21,
  -2.192761055130399e-22,   7.310681691128910e-24,   2.528673873797415e-01,  -8.574569424435926e-03,   1.879163447751166e-04,  -2.750942651266243e-06,   1.251691270317854e-08,
   7.153535371290118e-10,  -2.630017713373103e-11,   4.518077704863033e-13,  -8.020856961718532e-16,  -2.106487487544686e-16,   7.077108956458574e-18,  -1.130214867091797e-19,
  -3.752658107817834e-22,   8.396362904483322e-23,   2.528850182120740e-01,  -8.575340735745958e-03,   1.879231766576275e-04,  -2.750264638802646e-06,   1.247991147078097e-08,
   7.162314612723591e-10,  -2.630166853431411e-11,   4.510823680097172e-13,  -7.723362693244407e-16,  -2.112073087116104e-16,   7.073914317418845e-18,  -1.124004487462150e-19,
  -3.941797400135437e-22,   8.409502961715714e-23,   2.529161285893494e-01,  -8.576701570397166e-03,   1.879352146972011e-04,  -2.749067609558865e-06,   1.241462074954620e-08,
   7.177794040955059e-10,  -2.630423671211330e-11,   4.498008691085804e-13,  -7.198546588974929e-16,  -2.121902860751483e-16,   7.068182789697804e-18,  -1.113038691793731e-19,
  -4.274987579103572e-22,   8.432444978160257e-23,   2.529537484352389e-01,  -8.578346839607875e-03,   1.879497423650728e-04,  -2.747619014742261e-06,   1.233566806420435e-08,
   7.196491996766619e-10,  -2.630723405827746e-11,   4.482486889656120e-13,  -6.564135417190346e-16,  -2.133744596443499e-16,   7.061091162486616e-18,  -1.099766074491442e-19,
  -4.676946056243247e-22,   8.459770914119352e-23,   2.529902700144821e-01,  -8.579943759176681e-03,   1.879638153530886e-04,  -2.746211556961118e-06,   1.225901966411618e-08,
   7.214622752741037e-10,  -2.631003062891022e-11,   4.467391659891634e-13,  -5.948474458075603e-16,  -2.145193688806480e-16,   7.054038376847018e-18,  -1.086868116677094e-19,
  -5.066174359380482e-22,   8.485862970336915e-23,   2.530196919564106e-01,  -8.581230016603335e-03,   1.879751307160407e-04,  -2.745076877340739e-06,   1.219727096326433e-08,
   7.229213667399389e-10,  -2.631220241798971e-11,   4.455211885491577e-13,  -5.452661616522797e-16,  -2.154383478611252e-16,   7.048236289626240e-18,  -1.076468370870941e-19,
  -5.379022962356371e-22,   8.506570316866100e-23,   2.530391337609423e-01,  -8.582079854531216e-03,   1.879825971042074e-04,  -2.744326685333353e-06,   1.215646768461668e-08,
   7.238847740104942e-10,  -2.631359779945744e-11,   4.447154298328143e-13,  -5.125114320474411e-16,  -2.160439542468031e-16,   7.044343465498734e-18,  -1.069591877491795e-19,
  -5.585399895014929e-22,   8.520100544291809e-23,   2.530491181534542e-01,  -8.582516256634714e-03,   1.879864281729622e-04,  -2.743941297260248e-06,   1.213551299361105e-08,
   7.243793025016375e-10,  -2.631430211904178e-11,   4.443013435700407e-13,  -4.956927094060204e-16,  -2.163544552067058e-16,   7.042326110986873e-18,  -1.066059076906467e-19,
  -5.691276562618858e-22,   8.527001699312417e-23,   2.530525933279202e-01,  -8.582668145553089e-03,   1.879877610895309e-04,  -2.743807138945945e-06,   1.212821948124584e-08,
   7.245513914836103e-10,  -2.631454530976399e-11,   4.441571708229481e-13,  -4.898391822947580e-16,  -2.164624471966333e-16,   7.041621055647509e-18,  -1.064829232353645e-19,
  -5.728110733965064e-22,   8.529396184679831e-23,   2.530531447909695e-01,  -8.582692248003265e-03,   1.879879725802522e-04,  -2.743785848897614e-06,   1.212706209937690e-08,
   7.245786979168034e-10,  -2.631458380801458e-11,   4.441342903995019e-13,  -4.889103263867230e-16,  -2.164795802061665e-16,   7.041509035589749e-18,  -1.064634062485119e-19,
  -5.733954994104758e-22,   8.529775799295296e-23,   6.546112964760764e-01,  -1.737256260280600e-02,   1.834788355402842e-04,   2.171339188313585e-06,  -9.828159200843705e-08,
   3.971256863983745e-10,   4.453825348582882e-11,  -9.033968169931895e-13,  -1.221031583642301e-14,   7.518306575912209e-16,  -4.504832386929010e-18,  -4.274675180293151e-19,
   1.007671635034128e-20,   1.381858410450447e-22,   6.546283873185079e-01,  -1.737195065802385e-02,   1.834239034122730e-04,   2.171696908816807e-06,  -9.821934390142455e-08,
   3.953864677602141e-10,   4.450585356744086e-11,  -9.009156511754636e-13,  -1.222743650254413e-14,   7.496664541865605e-16,  -4.445733351252509e-18,  -4.264435157138839e-19,
   1.000603697305379e-20,   1.384429406597044e-22,   6.546585402342330e-01,  -1.737087079253880e-02,   1.833270031831031e-04,   2.172326798740403e-06,  -9.810954331256085e-08,
   3.923215327742201e-10,   4.444864799739021e-11,  -8.965435039168592e-13,  -1.225744632814459e-14,   7.458519891234146e-16,  -4.341803711604826e-18,  -4.246352312147406e-19,
   9.881685271203922e-21,   1.388882362248715e-22,   6.546949943966557e-01,  -1.736956487266247e-02,   1.832098787604837e-04,   2.173086230728697e-06,  -9.797683468114056e-08,
   3.886220984609411e-10,   4.437941433272597e-11,  -8.912667237277120e-13,  -1.229339457349348e-14,   7.412468430061602e-16,  -4.216729038026356e-18,  -4.224462528976741e-19,
   9.731936119709652e-21,   1.394125045173558e-22,   6.547303760695243e-01,  -1.736829696714545e-02,   1.830962270359003e-04,   2.173821133531412e-06,  -9.784806987952617e-08,
   3.850377782721072e-10,   4.431214094468872e-11,  -8.861546485651104e-13,  -1.232793755361484e-14,   7.367839442245176e-16,  -4.095933506899027e-18,  -4.203187795248491e-19,
   9.587208412045783e-21,   1.399066841243832e-22,   6.547588737864742e-01,  -1.736727545802842e-02,   1.830047069555800e-04,   2.174411486457913e-06,  -9.774438625835479e-08,
   3.821553252806954e-10,   4.425790182419768e-11,  -8.820439659234847e-13,  -1.235551134102948e-14,   7.331942095514040e-16,  -3.999068745190143e-18,  -4.186031883703640e-19,
   9.471079751388033e-21,   1.402942661605671e-22,   6.547777019763703e-01,  -1.736660041366094e-02,   1.829442498718684e-04,   2.174800761666113e-06,  -9.767589729838148e-08,
   3.802531115589014e-10,   4.422203986925506e-11,  -8.793313882283530e-13,  -1.237360774139179e-14,   7.308248802210220e-16,  -3.935280427070988e-18,  -4.174687231116630e-19,
   9.394569899604610e-21,   1.405452457477541e-22,   6.547873703507359e-01,  -1.736625373083516e-02,   1.829132077566059e-04,   2.175000419834896e-06,  -9.764073215738377e-08,
   3.792769940331766e-10,   4.420361634756123e-11,  -8.779394897605787e-13,  -1.238286286488295e-14,   7.296089525793465e-16,  -3.902589455145252e-18,  -4.168858658082007e-19,
   9.355348214844820e-21,   1.406725551780076e-22,   6.547907353892981e-01,  -1.736613306227745e-02,   1.829024041380467e-04,   2.175069872380987e-06,  -9.762849375716984e-08,
   3.789373683759221e-10,   4.419720280873554e-11,  -8.774552081811944e-13,  -1.238607811248764e-14,   7.291858710001668e-16,  -3.891221781697270e-18,  -4.166829565994672e-19,
   9.341707851366001e-21,   1.407166152198497e-22,   6.547912693685128e-01,  -1.736611391372410e-02,   1.829006897940581e-04,   2.175080891630267e-06,  -9.762655174616326e-08,
   3.788834802042527e-10,   4.419618501801033e-11,  -8.773783679760798e-13,  -1.238658803934041e-14,   7.291187401029371e-16,  -3.889418397158895e-18,  -4.166507557898614e-19,
   9.339543840502753e-21,   1.407235950270952e-22,   1.146401230364911e+00,  -1.968738056943910e-02,  -7.971267158046020e-05,   4.946913137825336e-06,   5.398438890161633e-08,
  -2.154647580789560e-09,  -4.001947617917401e-11,   1.077152347550709e-12,   3.055375415676978e-14,  -5.567898826710440e-16,  -2.395700369988541e-17,   2.588434155415816e-19,
   1.848552175806863e-20,  -7.888496763624413e-23,   1.146393817641343e+00,  -1.968599630219904e-02,  -7.968261738565943e-05,   4.944910714471564e-06,   5.392903329535146e-08,
  -2.152556212908524e-09,  -3.994127730715327e-11,   1.075307295849120e-12,   3.045618170015091e-14,  -5.554779051808837e-16,  -2.384751929710731e-17,   2.582612644176460e-19,
   1.837897731705796e-20,  -7.898791523235358e-23,   1.146380740027503e+00,  -1.968355419566647e-02,  -7.962961138421399e-05,   4.941378991939063e-06,   5.383144607511036e-08,
  -2.148868897750780e-09,  -3.980350029015474e-11,   1.072055256267765e-12,   3.028438480351319e-14,  -5.531653457455718e-16,  -2.365486138155254e-17,   2.572335006614619e-19,
   1.819160647540194e-20,  -7.916485762944484e-23,   1.146364930278267e+00,  -1.968060194956238e-02,  -7.956555872779942e-05,   4.937111096311039e-06,   5.371359350655705e-08,
  -2.144415159704451e-09,  -3.963724976752117e-11,   1.068128960264165e-12,   3.007727791949900e-14,  -5.503731454019215e-16,  -2.342279727447017e-17,   2.559898005603208e-19,
   1.796610417180871e-20,  -7.937083756017772e-23,   1.146349586468167e+00,  -1.967773677162443e-02,  -7.950342226776820e-05,   4.932970723622503e-06,   5.359934213288974e-08,
  -2.140096781836228e-09,  -3.947622343036570e-11,   1.064323767295684e-12,   2.987688214290869e-14,  -5.476668955725684e-16,  -2.319845309227341e-17,   2.547815014420113e-19,
   1.774830540437348e-20,  -7.956250635879231e-23,   1.146337228574024e+00,  -1.967542920273652e-02,  -7.945339798223086e-05,   4.929637317042640e-06,   5.350741567450099e-08,
  -2.136621699361276e-09,  -3.934676502994228e-11,   1.061262925609043e-12,   2.971591769511103e-14,  -5.454899082286599e-16,  -2.301839566005120e-17,   2.538074570683921e-19,
   1.757364562219318e-20,  -7.971101552142432e-23,   1.146329064107255e+00,  -1.967390468680417e-02,  -7.942035850250742e-05,   4.927435651717790e-06,   5.344672755993358e-08,
  -2.134327259772870e-09,  -3.926134947073972e-11,   1.059242612988650e-12,   2.960978580813385e-14,  -5.440529279530382e-16,  -2.289974483995402e-17,   2.531635122539842e-19,
   1.745862220205440e-20,  -7.980627867266400e-23,   1.146324871698726e+00,  -1.967312186288686e-02,  -7.940339599493079e-05,   4.926305297388147e-06,   5.341557838400146e-08,
  -2.133149521830684e-09,  -3.921752411380900e-11,   1.058205777258208e-12,   2.955535321172521e-14,  -5.433154443910628e-16,  -2.283891321522886e-17,   2.528327202111296e-19,
   1.739967212707135e-20,  -7.985431742804716e-23,   1.146323412561918e+00,  -1.967284940785512e-02,  -7.939749281015488e-05,   4.925911915942937e-06,   5.340473934528454e-08,
  -2.132739689526543e-09,  -3.920227660081504e-11,   1.057845007138168e-12,   2.953641877569665e-14,  -5.430588320447549e-16,  -2.281775631543592e-17,   2.527175699234152e-19,
   1.737917308932923e-20,  -7.987089745538805e-23,   1.146323181020295e+00,  -1.967280617365856e-02,  -7.939655609264445e-05,   4.925849494038518e-06,   5.340301946809119e-08,
  -2.132674659064400e-09,  -3.919985732968401e-11,   1.057787763112568e-12,   2.953341467905780e-14,  -5.430181147868445e-16,  -2.281439977104311e-17,   2.526992964449200e-19,
   1.737592107951327e-20,  -7.987352182372168e-23,   1.609810796631855e+00,  -1.287180986400592e-02,  -2.384432624959679e-04,  -1.607224565218982e-06,   5.506645015872475e-08,
   2.019805002596069e-09,   2.029245738218297e-11,  -6.304277122041050e-13,  -2.827296262198434e-14,  -3.463288563855369e-16,   8.968573411625270e-18,   4.639969572742872e-19,
   6.213695926047945e-21,  -1.482789844452339e-22,   1.609788505116122e+00,  -1.287225526496027e-02,  -2.384121319657702e-04,  -1.605341601179994e-06,   5.509411951707182e-08,
   2.018546365695512e-09,   2.021904910724250e-11,  -6.315355285543536e-13,  -2.823399864645218e-14,  -3.439804865778286e-16,   9.004103929901736e-18,   4.628698585084728e-19,
   6.150459567934570e-21,  -1.490708349618360e-22,   1.609749173776437e+00,  -1.287304075325999e-02,  -2.383571892048772e-04,  -1.602020046117880e-06,   5.514285892865936e-08,
   2.016323737875720e-09,   2.008960288016523e-11,  -6.334838768896335e-13,  -2.816512678857986e-14,  -3.398415190065018e-16,   9.066482191700363e-18,   4.608765160433224e-19,
   6.039077419552930e-21,  -1.504570233116322e-22,   1.609701617976877e+00,  -1.287398984330313e-02,  -2.382907306280657e-04,  -1.598005231876085e-06,   5.520165265595694e-08,
   2.013633147252828e-09,   1.993321822632145e-11,  -6.358289181639134e-13,  -2.808164350738919e-14,  -3.348447777136565e-16,   9.141372713464057e-18,   4.584584163438811e-19,
   5.904733649544170e-21,  -1.521144191613696e-22,   1.609655455899635e+00,  -1.287491043839493e-02,  -2.382261916214355e-04,  -1.594109444131318e-06,   5.525857945902528e-08,
   2.011018072128398e-09,   1.978155279027598e-11,  -6.380940173753664e-13,  -2.800038806507218e-14,  -3.300025708572913e-16,   9.213512694780962e-18,   4.561029305910780e-19,
   5.774672747967003e-21,  -1.537037483797938e-22,   1.609618271390345e+00,  -1.287565150977979e-02,  -2.381741839751960e-04,  -1.590972284531710e-06,   5.530433215994903e-08,
   2.008909189400799e-09,   1.965948077196867e-11,  -6.399105730912675e-13,  -2.793477899212048e-14,  -3.261078845413213e-16,   9.271225362561138e-18,   4.541996639472977e-19,
   5.670154310100476e-21,  -1.549700483235232e-22,   1.609593702027411e+00,  -1.287614092826528e-02,  -2.381398104921307e-04,  -1.588899911024524e-06,   5.533451246586329e-08,
   2.007514596640446e-09,   1.957887054400867e-11,  -6.411069194975104e-13,  -2.789135214409208e-14,  -3.235373524723341e-16,   9.309164109931399e-18,   4.529392357637111e-19,
   5.601216445710638e-21,  -1.557999332451569e-22,   1.609581084947380e+00,  -1.287639218511794e-02,  -2.381221556669822e-04,  -1.587835835446822e-06,   5.534999533909409e-08,
   2.006798072877253e-09,   1.953748967294760e-11,  -6.417200638972890e-13,  -2.786902769334522e-14,  -3.222181922626892e-16,   9.328586677414737e-18,   4.522910882049152e-19,
   5.565852592535660e-21,  -1.562239988812376e-22,   1.609576693530916e+00,  -1.287647962416056e-02,  -2.381160103620033e-04,  -1.587465504034385e-06,   5.535538172300248e-08,
   2.006548627150003e-09,   1.952308928402990e-11,  -6.419332775950758e-13,  -2.786125385718681e-14,  -3.217591947750486e-16,   9.335337206106843e-18,   4.520653583221385e-19,
   5.553550099425667e-21,  -1.563712615399357e-22,   1.609575996677106e+00,  -1.287649349890549e-02,  -2.381150351686347e-04,  -1.587406738956100e-06,   5.535623634585858e-08,
   2.006509041030090e-09,   1.952080426419320e-11,  -6.419671023297939e-13,  -2.786002008533523e-14,  -3.216863652374023e-16,   9.336407962891058e-18,   4.520295316393791e-19,
   5.551598158575318e-21,  -1.563946140891904e-22,   1.920870046811868e+00,  -3.153047930527662e-03,  -9.022250933941884e-05,  -2.153953351571421e-06,  -4.384585051295634e-08,
  -7.298613038864205e-10,  -8.147757817426702e-12,   2.508163599031726e-14,   4.806686846473178e-15,   1.720846942549749e-16,   4.218444958331049e-18,   7.371256386355319e-20,
   5.629078784170110e-22,  -1.891107158268168e-23,   1.920861538828741e+00,  -3.153656136957058e-03,  -9.024723630206382e-05,  -2.154637091496931e-06,  -4.385715410991303e-08,
  -7.298025098444589e-10,  -8.134770423310259e-12,   2.567215088546619e-14,   4.824581399455327e-15,   1.724588661459970e-16,   4.221552305847101e-18,   7.356256360961758e-20,
   5.548413520616609e-22,  -1.912271244290895e-23,   1.920846524466211e+00,  -3.154729483036938e-03,  -9.029087255006175e-05,  -2.155843513647909e-06,  -4.387708449088314e-08,
  -7.296978168684802e-10,  -8.111815713884247e-12,   2.671514602183804e-14,   4.856166946366501e-15,   1.731184575022470e-16,   4.226994388273162e-18,   7.329662170623845e-20,
   5.405804461399830e-22,  -1.949659298197109e-23,   1.920828365711554e+00,  -3.156027651025177e-03,  -9.034364671552283e-05,  -2.157302250365419e-06,  -4.390115892503378e-08,
  -7.295696001186444e-10,  -8.083993402872323e-12,   2.797808879657111e-14,   4.894378038530523e-15,   1.739149461077941e-16,   4.233505212407682e-18,   7.297288477057346e-20,
   5.232893079200674e-22,  -1.994943527379155e-23,   1.920810734127177e+00,  -3.157288169040002e-03,  -9.039488811674019e-05,  -2.158718280384309e-06,  -4.392450312738093e-08,
  -7.294434307178672e-10,  -8.056915656802246e-12,   2.920595433471061e-14,   4.931490919868557e-15,   1.746870107676384e-16,   4.239752593455807e-18,   7.265634538179969e-20,
   5.064544805421248e-22,  -2.038981982225821e-23,   1.920796527930322e+00,  -3.158303825857929e-03,  -9.043617407838043e-05,  -2.159858953444922e-06,  -4.394328965431348e-08,
  -7.293405721014075e-10,  -8.035053206651214e-12,   3.019641159616632e-14,   4.961401538101267e-15,   1.753081468403793e-16,   4.244732859741316e-18,   7.239972367207672e-20,
   4.928575423083251e-22,  -2.074513906263833e-23,   1.920787139542653e+00,  -3.158975051662222e-03,  -9.046345831421871e-05,  -2.160612659194288e-06,  -4.395569401607650e-08,
  -7.292720080977170e-10,  -8.020582906724661e-12,   3.085152650539083e-14,   4.981172254003273e-15,   1.757181751811357e-16,   4.247997970467484e-18,   7.222935796127759e-20,
   4.838557846963069e-22,  -2.098019644584480e-23,   1.920782317789608e+00,  -3.159319788496970e-03,  -9.047747106651881e-05,  -2.160999713630659e-06,  -4.396206132746409e-08,
  -7.292366125296730e-10,  -8.013144297451911e-12,   3.118815669174931e-14,   4.991327407226437e-15,   1.759286181062425e-16,   4.249666787080727e-18,   7.214162112787647e-20,
   4.792276506257461e-22,  -2.110099253784753e-23,   1.920780639475914e+00,  -3.159439782127840e-03,  -9.048234849112797e-05,  -2.161134429951236e-06,  -4.396427706312465e-08,
  -7.292242633704435e-10,  -8.010554040337131e-12,   3.130535531828773e-14,   4.994862310221319e-15,   1.760018445696721e-16,   4.250246363868558e-18,   7.211104436171163e-20,
   4.776159423566758e-22,  -2.114304989709257e-23,   1.920780373147873e+00,  -3.159458823693229e-03,  -9.048312247873323e-05,  -2.161155807503713e-06,  -4.396462864776116e-08,
  -7.292223023327176e-10,  -8.010142946136944e-12,   3.132395461707353e-14,   4.995423265294925e-15,   1.760134636450741e-16,   4.250338274412981e-18,   7.210619039084012e-20,
   4.773601463936973e-22,  -2.114972444572751e-23,   2.509979972667050e-02,  -8.869522794597899e-04,   2.322820015690789e-05,  -5.328937259678682e-07,   1.122459294649441e-08,
  -2.213892755226473e-10,   4.096967403385522e-12,  -7.118034311998239e-14,   1.130602924716758e-15,  -1.620758701401519e-17,   1.868735398860671e-19,  -3.811061456564667e-22,
  -1.894355459025565e-23,   9.233400016500741e-25,   2.510199010732313e-02,  -8.871028910333988e-04,   2.323454671751695e-05,  -5.331024644227827e-07,   1.123038960929772e-08,
  -2.215302823942117e-10,   4.099951400244572e-12,  -7.123508586870938e-14,   1.131386582545997e-15,  -1.620925383196470e-17,   1.867309081111752e-19,  -3.735639991890042e-22,
  -1.949146506656204e-23,   9.376749674715430e-25,   2.510585555614652e-02,  -8.873686954647028e-04,   2.324574798295292e-05,  -5.334708944584406e-07,   1.124062133008038e-08,
  -2.217791788826811e-10,   4.105218379230116e-12,  -7.133168466285080e-14,   1.132768847555151e-15,  -1.621216253232766e-17,   1.864764709577371e-19,  -3.601706706732223e-22,
  -2.045870315016929e-23,   9.629595197157652e-25,   2.511053052988005e-02,  -8.876901907822154e-04,   2.325929720836999e-05,  -5.339165877594444e-07,   1.125299946558091e-08,
  -2.220802966230628e-10,   4.111590112505381e-12,  -7.144850031685009e-14,   1.134439418430057e-15,  -1.621562423054052e-17,   1.861640933211896e-19,  -3.438302640291446e-22,
  -2.162905260620394e-23,   9.935173780642464e-25,   2.511506978460108e-02,  -8.880023785104683e-04,   2.327245531284565e-05,  -5.343494515968881e-07,   1.126502205142670e-08,
  -2.223727730185614e-10,   4.117778660201158e-12,  -7.156191055973499e-14,   1.136060251218369e-15,  -1.621892632180934e-17,   1.858559088018768e-19,  -3.278154339617299e-22,
  -2.276600080520517e-23,   1.023165251588693e-24,   2.511872717347303e-02,  -8.882539342599659e-04,   2.328305871572565e-05,  -5.346982990390236e-07,   1.127471166646181e-08,
  -2.226085003390622e-10,   4.122766207724007e-12,  -7.165327778597400e-14,   1.137365301923302e-15,  -1.622154433378338e-17,   1.856041029829774e-19,  -3.148053326430628e-22,
  -2.368248175997984e-23,   1.047036966654460e-24,   2.512114421661077e-02,  -8.884201878751893e-04,   2.329006692304041e-05,  -5.349288787817539e-07,   1.128111653465455e-08,
  -2.227643196614164e-10,   4.126062934845831e-12,  -7.171365424731260e-14,   1.138227325226715e-15,  -1.622325356277436e-17,   1.854359821179458e-19,  -3.061552504337609e-22,
  -2.428835605211232e-23,   1.062805013970571e-24,   2.512238557847252e-02,  -8.885055763583519e-04,   2.329366648862615e-05,  -5.350473134118915e-07,   1.128440640383620e-08,
  -2.228443573203743e-10,   4.127756284947174e-12,  -7.174466125634426e-14,   1.138669912585695e-15,  -1.622412491103013e-17,   1.853491082323796e-19,  -3.016965576382484e-22,
  -2.459958825192532e-23,   1.070900824859725e-24,   2.512281766089148e-02,  -8.885352980820611e-04,   2.329491943251542e-05,  -5.350885389970323e-07,   1.128555157847663e-08,
  -2.228722178640058e-10,   4.128345722370865e-12,  -7.175545365787009e-14,   1.138823942749858e-15,  -1.622442716760073e-17,   1.853187856738321e-19,  -3.001420483198848e-22,
  -2.470792929654864e-23,   1.073718354264057e-24,   2.512288622713535e-02,  -8.885400145805507e-04,   2.329511826135362e-05,  -5.350950810876010e-07,   1.128573330693116e-08,
  -2.228766390769214e-10,   4.128439260412802e-12,  -7.175716626942834e-14,   1.138848384435191e-15,  -1.622447508290110e-17,   1.853139698513763e-19,  -2.998952447036648e-22,
  -2.472512218496005e-23,   1.074165443539511e-24,   2.213726844266038e-01,  -7.198993906969130e-03,   1.564791640334045e-04,  -2.466334345248500e-06,   2.149825882576645e-08,
   2.277635844703352e-10,  -1.481508363432197e-11,   3.499002792738615e-13,  -4.449654614185488e-15,  -2.112829219852905e-17,   2.724728601104839e-18,  -7.193114183268225e-20,
   1.316313753641782e-21,  -5.079218119386062e-24,   2.213873783543147e-01,  -7.199686788400640e-03,   1.564911383470077e-04,  -2.466115037850310e-06,   2.147729028285216e-08,
   2.284511390981690e-10,  -1.482652064591630e-11,   3.498192772509685e-13,  -4.437910251463369e-15,  -2.150005281884354e-17,   2.732538565788166e-18,  -7.195541338650028e-20,
   1.309106608925395e-21,  -4.845330041260563e-24,   2.214133069198174e-01,  -7.200909337454206e-03,   1.565122575911948e-04,  -2.465727542854601e-06,   2.144027797873640e-08,
   2.296642056432266e-10,  -1.484667621863153e-11,   3.496753272453958e-13,  -4.417160646129257e-15,  -2.215611888182396e-17,   2.746282993715189e-18,  -7.199685647350578e-20,
   1.296378352596949e-21,  -4.433076447147535e-24,   2.214446615504472e-01,  -7.202387569565200e-03,   1.565377787990661e-04,  -2.465258086985838e-06,   2.139550019253296e-08,
   2.311308283675228e-10,  -1.487100552184042e-11,   3.494995208965630e-13,  -4.392024915271684e-15,  -2.294958808037902e-17,   2.762840838074599e-18,  -7.204461112609381e-20,
   1.280968304247856e-21,  -3.935337459380939e-24,   2.214751016869626e-01,  -7.203822520220914e-03,   1.565625371586220e-04,  -2.464801412537488e-06,   2.135200756201905e-08,
   2.325543577215141e-10,  -1.489457887799343e-11,   3.493270283513059e-13,  -4.367576478147746e-15,  -2.372002323356704e-17,   2.778849864996577e-18,  -7.208850278101155e-20,
   1.265988805436680e-21,  -3.452942928357193e-24,   2.214996250137836e-01,  -7.204978432183169e-03,   1.565824698528754e-04,  -2.464432851813096e-06,   2.131695390922470e-08,
   2.337009596282486e-10,  -1.491353691134263e-11,   3.491867644514366e-13,  -4.347847461880560e-15,  -2.434077896202679e-17,   2.791699892860068e-18,  -7.212209486284932e-20,
   1.253907482793010e-21,  -3.064909108592208e-24,   2.215158301535343e-01,  -7.205742206054606e-03,   1.565956349893575e-04,  -2.464188985562244e-06,   2.129378298124075e-08,
   2.344585277350973e-10,  -1.492604818590038e-11,   3.490934409889978e-13,  -4.334794423204942e-15,  -2.475101237537043e-17,   2.800168114503117e-18,  -7.214342767562043e-20,
   1.245917519327044e-21,  -2.808786731185829e-24,   2.215241524420271e-01,  -7.206134430530292e-03,   1.566023940508621e-04,  -2.464063647176590e-06,   2.128188109798202e-08,
   2.348475485211063e-10,  -1.493246841740839e-11,   3.490453171201692e-13,  -4.328085980691776e-15,  -2.496170173625214e-17,   2.804509882702619e-18,  -7.215411596601702e-20,
   1.241812181712196e-21,  -2.677343504653970e-24,   2.215270491184229e-01,  -7.206270946265917e-03,   1.566047463070178e-04,  -2.464020005861573e-06,   2.127773814016770e-08,
   2.349829465121932e-10,  -1.493470225637585e-11,   3.490285356750758e-13,  -4.325750237277178e-15,  -2.503503643848343e-17,   2.806019949264919e-18,  -7.215779360874258e-20,
   1.240382946169903e-21,  -2.631607493288842e-24,   2.215275087823868e-01,  -7.206292609357777e-03,   1.566051195635690e-04,  -2.464013079819612e-06,   2.127708069091204e-08,
   2.350044321064425e-10,  -1.493505669875393e-11,   3.490258711958177e-13,  -4.325379548592462e-15,  -2.504667375631686e-17,   2.806259522589296e-18,  -7.215837518194380e-20,
   1.240156130272208e-21,  -2.624350483519767e-24,   5.881852055698501e-01,  -1.582630413726087e-02,   2.005253567586090e-04,   7.113589706692182e-07,  -8.182784202094959e-08,
   1.141370832922371e-09,   1.742517903154843e-11,  -9.235878390859715e-13,   8.458344466003116e-15,   3.466901268194678e-16,  -1.214274159560196e-17,   5.493141521909173e-20,
   7.248357123225562e-21,  -1.785728171132872e-22,   5.882039126706887e-01,  -1.582610035547466e-02,   2.004794685434953e-04,   7.124138918010410e-07,  -8.180308904139012e-08,
   1.139571242047001e-09,   1.744635769374412e-11,  -9.224118104846235e-13,   8.408532949787140e-15,   3.469256442524410e-16,  -1.209860407216017e-17,   5.369425679916968e-20,
   7.233114120244994e-21,  -1.773215006979439e-22,   5.882369181641057e-01,  -1.582574054070764e-02,   2.003985094427552e-04,   7.142739509041370e-07,  -8.175938820694164e-08,
   1.136397720785898e-09,   1.748362232924141e-11,  -9.203360780975622e-13,   8.320790500651385e-15,   3.473361022533432e-16,  -1.202080025805180e-17,   5.151864395201744e-20,
   7.206139080236942e-21,  -1.751184625711347e-22,   5.882768228257891e-01,  -1.582530504222723e-02,   2.003006322386835e-04,   7.165208263778046e-07,  -8.170650417049752e-08,
   1.132563479946344e-09,   1.752850354821104e-11,  -9.178250473255230e-13,   8.214948259870480e-15,   3.478237299426422e-16,  -1.192685153278625e-17,   4.890042054558119e-20,
   7.173387570637725e-21,  -1.724629322290153e-22,   5.883155553677629e-01,  -1.582488184230343e-02,   2.002056350738207e-04,   7.186996177318264e-07,  -8.165512293518329e-08,
   1.128844632814805e-09,   1.757188568822256e-11,  -9.153863125182873e-13,   8.112467198086804e-15,   3.482880241232339e-16,  -1.183578680311966e-17,   4.637181212292557e-20,
   7.141454816216538e-21,  -1.698937952979177e-22,   5.883467533489553e-01,  -1.582454061324283e-02,   2.001291211665205e-04,   7.204530788828503e-07,  -8.161370062582258e-08,
   1.125851191300533e-09,   1.760669943658599e-11,  -9.134209416474938e-13,   8.030102182856123e-15,   3.486555620461884e-16,  -1.176252611800198e-17,   4.434417865743129e-20,
   7.115632006326857e-21,  -1.678304430041613e-22,   5.883673662400881e-01,  -1.582431498604338e-02,   2.000785692777359e-04,   7.216108808178916e-07,  -8.158631471804227e-08,
   1.123874360353187e-09,   1.762963804479863e-11,  -9.121218919777312e-13,   7.975770983086196e-15,   3.488952538010288e-16,  -1.171416575956123e-17,   4.300894027643235e-20,
   7.098520991224516e-21,  -1.664701072080458e-22,   5.883779512721259e-01,  -1.582419906958181e-02,   2.000526106721142e-04,   7.222052034926230e-07,  -8.157224617836661e-08,
   1.122859528629110e-09,   1.764139781740072e-11,  -9.114546548606080e-13,   7.947898410201352e-15,   3.490173680225718e-16,  -1.168934557451188e-17,   4.232464809112181e-20,
   7.089718962961803e-21,  -1.657724656211470e-22,   5.883816353821878e-01,  -1.582415871645830e-02,   2.000435758932865e-04,   7.224120209170221e-07,  -8.156734876799953e-08,
   1.122506365355174e-09,   1.764548768362432e-11,  -9.112223989542462e-13,   7.938201737105198e-15,   3.490597152876987e-16,  -1.168070909915355e-17,   4.208669931758118e-20,
   7.086653001652614e-21,  -1.655297972748230e-22,   5.883822199946237e-01,  -1.582415231262504e-02,   2.000421422150073e-04,   7.224448379990008e-07,  -8.156657158195421e-08,
   1.122450325970534e-09,   1.764613653574392e-11,  -9.111855422913083e-13,   7.936663228459613e-15,   3.490664278264076e-16,  -1.167933872425308e-17,   4.204895082141876e-20,
   7.086166365100530e-21,  -1.654912963758424e-22,   1.066768326250999e+00,  -2.007650249029486e-02,  -1.672615552730308e-05,   5.425680623559546e-06,   4.200627591387765e-09,
  -2.667020982252895e-09,  -3.029132243971274e-13,   1.585715417316890e-12,  -1.890033686803214e-15,  -1.067043103402805e-15,   2.348249019465559e-18,   7.744857454944828e-19,
  -1.232293543655577e-21,  -5.469746038867739e-22,   1.066766762914672e+00,  -2.007498523134950e-02,  -1.672379542970164e-05,   5.423206023123393e-06,   4.200145609620567e-09,
  -2.663954586211539e-09,  -3.076755969150497e-13,   1.582213835973392e-12,  -1.880365322228304e-15,  -1.063196923494381e-15,   2.340809325716284e-18,   7.706723572371685e-19,
  -1.228255651245651e-21,  -5.435643416756460e-22,   1.066764004562630e+00,  -2.007230856541246e-02,  -1.671963123379389e-05,   5.418841871827115e-06,   4.199289778429842e-09,
  -2.658549437860930e-09,  -3.160583887411039e-13,   1.576045686381305e-12,  -1.863330696250345e-15,  -1.056426074960250e-15,   2.327701855058638e-18,   7.639635408730618e-19,
  -1.221160396811013e-21,  -5.375697248995503e-22,   1.066760669439917e+00,  -2.006907286913701e-02,  -1.671459624329035e-05,   5.413568646544940e-06,   4.198245763347932e-09,
  -2.652022936300630e-09,  -3.261600509429142e-13,   1.568604875450174e-12,  -1.842775431118350e-15,  -1.048265569939432e-15,   2.311886138665382e-18,   7.558851221870367e-19,
  -1.212631060277296e-21,  -5.303597868020925e-22,   1.066757432080990e+00,  -2.006593271267020e-02,  -1.670970878230853e-05,   5.408453626697484e-06,   4.197222705972543e-09,
  -2.645697015150325e-09,  -3.359300706509206e-13,   1.561400048039498e-12,  -1.822865900945677e-15,  -1.040371566249723e-15,   2.296567967631569e-18,   7.480781720814417e-19,
  -1.204403281423174e-21,  -5.234009799400291e-22,   1.066754824336342e+00,  -2.006340376068186e-02,  -1.670577181016868e-05,   5.404335994058130e-06,   4.196391719182550e-09,
  -2.640608013865763e-09,  -3.437745531333973e-13,   1.555609221045321e-12,  -1.806859361583536e-15,  -1.034032323054859e-15,   2.284253160206379e-18,   7.418143041427868e-19,
  -1.197812360734053e-21,  -5.178239358450541e-22,   1.066753101297548e+00,  -2.006173302530183e-02,  -1.670317047800160e-05,   5.401616584423525e-06,   4.195839281954459e-09,
  -2.637248754199707e-09,  -3.489452725457406e-13,   1.551789241374228e-12,  -1.796298333108240e-15,  -1.029853267200629e-15,   2.276128112159145e-18,   7.376876108768411e-19,
  -1.193475350117337e-21,  -5.141528163531964e-22,   1.066752216469447e+00,  -2.006087513127777e-02,  -1.670183461563669e-05,   5.400220485247131e-06,   4.195554548558392e-09,
  -2.635524683322008e-09,  -3.515967364747847e-13,   1.549829505606742e-12,  -1.790879624735570e-15,  -1.027710149399184e-15,   2.271959325165792e-18,   7.355721715404006e-19,
  -1.191253680937126e-21,  -5.122718685488649e-22,   1.066751908502457e+00,  -2.006057655068285e-02,  -1.670136966386909e-05,   5.399734631412745e-06,   4.195455280553407e-09,
  -2.634924774883597e-09,  -3.525189745190649e-13,   1.549147720873773e-12,  -1.788994371057050e-15,  -1.026964699190860e-15,   2.270508947180894e-18,   7.348364802509308e-19,
  -1.190481297272638e-21,  -5.116178786833900e-22,   1.066751859632600e+00,  -2.006052917087468e-02,  -1.670129588277672e-05,   5.399657536483496e-06,   4.195439520307650e-09,
  -2.634829585755786e-09,  -3.526652911750894e-13,   1.549039546178007e-12,  -1.788695244161435e-15,  -1.026846429363107e-15,   2.270278820948648e-18,   7.347197649668785e-19,
  -1.190358772772386e-21,  -5.115141322956573e-22,   1.554411679971090e+00,  -1.483832032940906e-02,  -2.510458750334924e-04,  -3.844870726478708e-07,   9.833810296664770e-08,
   2.184783750976649e-09,  -1.115620397466602e-11,  -1.621864023777492e-12,  -2.887327876608377e-14,   4.636949352991376e-16,   3.108763735546976e-17,   3.845963245285640e-19,
  -1.331728338292360e-20,  -5.654285484042844e-22,   1.554388255317329e+00,  -1.483842135118793e-02,  -2.509906538386204e-04,  -3.824654460012297e-07,   9.832155365815879e-08,
   2.181616458528025e-09,  -1.122935113936970e-11,  -1.620251957343189e-12,  -2.874481076975023e-14,   4.655248691565737e-16,   3.100433597426273e-17,   3.806337508360280e-19,
  -1.333766373737033e-20,  -5.623041467904781e-22,   1.554346926344123e+00,  -1.483859914806674e-02,  -2.508932229396613e-04,  -3.789006600321378e-07,   9.829226955181118e-08,
   2.176030324291856e-09,  -1.135814792579615e-11,  -1.617402531572995e-12,  -2.851841344058508e-14,   4.687373810958114e-16,   3.085725395692213e-17,   3.736602531097527e-19,
  -1.337298023399679e-20,  -5.567946454874405e-22,   1.554296958063698e+00,  -1.483881336201369e-02,  -2.507754217263553e-04,  -3.745941838988108e-07,   9.825671828498261e-08,
   2.169279954905381e-09,  -1.151342609824145e-11,  -1.613948635585158e-12,  -2.824514004277194e-14,   4.725940146806947e-16,   3.067924030976979e-17,   3.652593980739406e-19,
  -1.341458959614720e-20,  -5.501386653280203e-22,   1.554248457214675e+00,  -1.483902050093903e-02,  -2.506610762770141e-04,  -3.704178243452962e-07,   9.822205875316836e-08,
   2.162731473404964e-09,  -1.166368180842031e-11,  -1.610586958767703e-12,  -2.798036296087224e-14,   4.763087454585630e-16,   3.050626246593073e-17,   3.571370365570788e-19,
  -1.345384089549797e-20,  -5.436837495612900e-22,   1.554209390929489e+00,  -1.483918678484823e-02,  -2.505689710732086e-04,  -3.670564780348670e-07,   9.819403236698411e-08,
   2.157459445650079e-09,  -1.178437826434773e-11,  -1.607872633656695e-12,  -2.776742902313735e-14,   4.792803942938177e-16,   3.036679731061157e-17,   3.506174289436715e-19,
  -1.348464631961728e-20,  -5.384885735514403e-22,   1.554183579252355e+00,  -1.483929637623483e-02,  -2.505081145023477e-04,  -3.648368651963623e-07,   9.817546163858087e-08,
   2.153977422735265e-09,  -1.186396229538190e-11,  -1.606076030409654e-12,  -2.762690585617910e-14,   4.812337978850104e-16,   3.027458499310341e-17,   3.463209677681760e-19,
  -1.350460443451004e-20,  -5.350580921217295e-22,   1.554170324533858e+00,  -1.483935256821837e-02,  -2.504768632608320e-04,  -3.636974531041515e-07,   9.816590880400292e-08,
   2.152189744673943e-09,  -1.190477995029325e-11,  -1.605152455354022e-12,  -2.755479610247198e-14,   4.822338109665184e-16,   3.022721233537905e-17,   3.441181091720950e-19,
  -1.351473123923753e-20,  -5.332971255875122e-22,   1.554165711237090e+00,  -1.483937211227608e-02,  -2.504659862221133e-04,  -3.633009443587356e-07,   9.816258132626945e-08,
   2.151567607754723e-09,  -1.191897854526979e-11,  -1.604830848221598e-12,  -2.752970649793174e-14,   4.825813730601579e-16,   3.021072112147014e-17,   3.433519538619793e-19,
  -1.351823646886400e-20,  -5.326843251521635e-22,   1.554164979176571e+00,  -1.483937521298065e-02,  -2.504642601973657e-04,  -3.632380273976933e-07,   9.816205318148354e-08,
   2.151468887030477e-09,  -1.192123126975667e-11,  -1.604779806559257e-12,  -2.752572554366368e-14,   4.826365025716840e-16,   3.020810406380705e-17,   3.432304026138331e-19,
  -1.351879177547279e-20,  -5.325870878784743e-22,   1.906632211382343e+00,  -3.991319505509985e-03,  -1.207936851165626e-04,  -2.982251937136223e-06,  -6.022277067835185e-08,
  -8.925475501707725e-10,  -4.090369328685970e-12,   3.171890688765650e-13,   1.485242308981862e-14,   4.076650489174954e-16,   7.391350797899198e-18,   4.642733848458923e-20,
  -2.564334866190478e-21,  -1.207565723128185e-22,   1.906620818934027e+00,  -3.992161189130585e-03,  -1.208275899195888e-04,  -2.983083241855842e-06,  -6.022805324554059e-08,
  -8.919011069459678e-10,  -4.050750958054773e-12,   3.185701092695525e-13,   1.488305059437043e-14,   4.078689365494331e-16,   7.374285707739359e-18,   4.551884081711366e-20,
  -2.590174492827181e-21,  -1.212210088938583e-22,   1.906600714191844e+00,  -3.993646542268898e-03,  -1.208874177835999e-04,  -2.984549592642598e-06,  -6.023732887591638e-08,
  -8.907582347113321e-10,  -3.980778695192566e-12,   3.210075100503676e-13,   1.493703372354444e-14,   4.082248650635329e-16,   7.344043944724786e-18,   4.391304826340977e-20,
  -2.635783510063493e-21,  -1.220385258548915e-22,   1.906576398910089e+00,  -3.995442969588303e-03,  -1.209597661930355e-04,  -2.986321866888990e-06,  -6.024846736278255e-08,
  -8.893724874910139e-10,  -3.896056703077955e-12,   3.239557431694416e-13,   1.500220879780413e-14,   4.086487118142422e-16,   7.307253330321885e-18,   4.196665309820790e-20,
  -2.690958722295863e-21,  -1.230236628981172e-22,   1.906552789434394e+00,  -3.997187247681622e-03,  -1.210300048601186e-04,  -2.988041465537667e-06,  -6.025919897699525e-08,
  -8.880232753684409e-10,  -3.813694160244630e-12,   3.268187722240969e-13,   1.506537253011948e-14,   4.090533102438583e-16,   7.271305154638354e-18,   4.007226370124702e-20,
  -2.744546575985174e-21,  -1.239764141349019e-22,   1.906533766636730e+00,  -3.998592657210174e-03,  -1.210865911298362e-04,  -2.989426109891624e-06,  -6.026778583166551e-08,
  -8.869335350262475e-10,  -3.747261004946598e-12,   3.291258548696337e-13,   1.511617939821513e-14,   4.093743239687828e-16,   7.242179157258019e-18,   3.854269166743364e-20,
  -2.787733441180619e-21,  -1.247413367006797e-22,   1.906521195089684e+00,  -3.999521445143125e-03,  -1.211239837498513e-04,  -2.990340743475986e-06,  -6.027343126254479e-08,
  -8.862120669032228e-10,  -3.703322571279397e-12,   3.306506562983658e-13,   1.514971385267246e-14,   4.095840296363832e-16,   7.222851622114681e-18,   3.753027854041283e-20,
  -2.816278757563015e-21,  -1.252455020641426e-22,   1.906514738497361e+00,  -3.999998458783099e-03,  -1.211431870877547e-04,  -2.990810354159918e-06,  -6.027632160969101e-08,
  -8.858411294794997e-10,  -3.680745537849003e-12,   3.314338139080685e-13,   1.516692368006453e-14,   4.096909762283848e-16,   7.212900770680103e-18,   3.700983112355060e-20,
  -2.830940636063942e-21,  -1.255040169523662e-22,   1.906512491141453e+00,  -4.000164493574355e-03,  -1.211498710550583e-04,  -2.990973790940821e-06,  -6.027732621192785e-08,
  -8.857119530076442e-10,  -3.672885397983550e-12,   3.317064148155632e-13,   1.517291185021580e-14,   4.097280809441045e-16,   7.209433267594790e-18,   3.682860113787739e-20,
  -2.836044229991157e-21,  -1.255939318868918e-22,   1.906512134513233e+00,  -4.000190841285602e-03,  -1.211509317119225e-04,  -2.990999725370200e-06,  -6.027748556154392e-08,
  -8.856914512378906e-10,  -3.671638007264621e-12,   3.317496735709780e-13,   1.517386200163153e-14,   4.097339632998868e-16,   7.208882831851318e-18,   3.679983847243548e-20,
  -2.836854118628386e-21,  -1.256081971291230e-22,   2.188704841778253e-02,  -7.239573779607391e-04,   1.778053649372349e-05,  -3.839905678452226e-07,   7.637668040969720e-09,
  -1.433789904855638e-10,   2.532746359209680e-12,  -4.293909377274369e-14,   6.757916888120267e-16,  -9.268382226174786e-18,   1.549584322168893e-19,  -1.139382860364739e-21,
  -2.426243282755644e-23,  -4.585669743489477e-25,   2.188872400526152e-02,  -7.240658512367771e-04,   1.778485290895343e-05,  -3.841257008494111e-07,   7.641250866324486e-09,
  -1.434640270621737e-10,   2.534533698119639e-12,  -4.297053097730483e-14,   6.764406839063315e-16,  -9.274368305983067e-18,   1.548108055771055e-19,  -1.142306418799503e-21,
  -2.420679911163009e-23,  -4.507619763733114e-25,   2.189168093718612e-02,  -7.242572850655008e-04,   1.779247093511843e-05,  -3.843642101332429e-07,   7.647574866825727e-09,
  -1.436141258373732e-10,   2.537688867969216e-12,  -4.302601892545825e-14,   6.775853417796424e-16,  -9.284942654346547e-18,   1.545505826840462e-19,  -1.147418846843698e-21,
  -2.410982917888393e-23,  -4.370021695411802e-25,   2.189525705611354e-02,  -7.244888218099031e-04,   1.780168553685016e-05,  -3.846527289167842e-07,   7.655225410254664e-09,
  -1.437957128310506e-10,   2.541506489137398e-12,  -4.309314371125842e-14,   6.789686152481662e-16,  -9.297749284782821e-18,   1.542363689029860e-19,  -1.153522061219076e-21,
  -2.399461096997801e-23,  -4.203844652736326e-25,   2.189872928250181e-02,  -7.247136490968614e-04,   1.781063384890642e-05,  -3.849329340295411e-07,   7.662656086122037e-09,
  -1.439720843714751e-10,   2.545215036006107e-12,  -4.315833681410011e-14,   6.803105743552825e-16,  -9.310202530875823e-18,   1.539318021380955e-19,  -1.159364512667028e-21,
  -2.388489230854083e-23,  -4.042739913175293e-25,   2.190152688719646e-02,  -7.248948067554000e-04,   1.781784459708983e-05,  -3.851587468134053e-07,   7.668644765848156e-09,
  -1.441142315135826e-10,   2.548204359587566e-12,  -4.321087670217911e-14,   6.813909956892648e-16,  -9.320249481546949e-18,   1.536867776866520e-19,  -1.164012089348661e-21,
  -2.379803145678779e-23,  -3.913111006313480e-25,   2.190337570230739e-02,  -7.250145319606326e-04,   1.782261036162001e-05,  -3.853080006194108e-07,   7.672603263841045e-09,
  -1.442081914115211e-10,   2.550180515993220e-12,  -4.324560449850098e-14,   6.821046040150060e-16,  -9.326895515014936e-18,   1.535250302601973e-19,  -1.167054242218683e-21,
  -2.374138250802473e-23,  -3.827530194375799e-25,   2.190432522158978e-02,  -7.250760225985654e-04,   1.782505812850777e-05,  -3.853846621919450e-07,   7.674636539484715e-09,
  -1.442564540885281e-10,   2.551195634203072e-12,  -4.326344209355220e-14,   6.824709787122602e-16,  -9.330310783748606e-18,   1.534420144943225e-19,  -1.168607604729666e-21,
  -2.371252151127540e-23,  -3.783603704308084e-25,   2.190465572070239e-02,  -7.250974259361025e-04,   1.782591014694178e-05,  -3.854113469606873e-07,   7.675344302985376e-09,
  -1.442732539113323e-10,   2.551548997948014e-12,  -4.326965114304004e-14,   6.825984832909111e-16,  -9.331499850636962e-18,   1.534131279134554e-19,  -1.169146845676444e-21,
  -2.370251293416661e-23,  -3.768318400623259e-25,   2.190470816684556e-02,  -7.251008223964735e-04,   1.782604535294255e-05,  -3.854155815612308e-07,   7.675456618310309e-09,
  -1.442759198857158e-10,   2.551605073927891e-12,  -4.327063645795155e-14,   6.826187157762464e-16,  -9.331688555836388e-18,   1.534085443814165e-19,  -1.169232348330658e-21,
  -2.370092645559244e-23,  -3.765893009646304e-25,   1.949015064273724e-01,  -6.059461079288648e-03,   1.290431277381605e-04,  -2.102200026894112e-06,   2.320764888638230e-08,
  -2.640644642878738e-11,  -7.006411226681766e-12,   2.112190624025047e-13,  -3.857057790500719e-15,   4.094871406082163e-17,   7.109493525511508e-19,  -2.686779675388068e-20,
   4.531315761804060e-22,  -1.842724627691330e-23,   1.949136302880735e-01,  -6.060052395924746e-03,   1.290561256639848e-04,  -2.102221266626946e-06,   2.319767726448597e-08,
  -2.598847976157152e-11,  -7.016471837385770e-12,   2.113535024604097e-13,  -3.853965615648548e-15,   4.080517185009139e-17,   7.138262918108402e-19,  -2.699726443167483e-20,
   4.547389887978187e-22,  -1.833156495489264e-23,   1.949350240152686e-01,  -6.061095787691502e-03,   1.290790561207837e-04,  -2.102258425246699e-06,   2.318007070371667e-08,
  -2.525075766881562e-11,  -7.034217287872579e-12,   2.115903265358099e-13,  -3.848499493405656e-15,   4.055135203556025e-17,   7.189105720093157e-19,  -2.722514309410551e-20,
   4.575562501320848e-22,  -1.816271430504904e-23,   1.949608952167772e-01,  -6.062357475377551e-03,   1.291067760479884e-04,  -2.102302813434626e-06,   2.315876109821583e-08,
  -2.435833291999767e-11,  -7.055663913665040e-12,   2.118760179273553e-13,  -3.841872848484640e-15,   4.024351585328914e-17,   7.250719010326376e-19,  -2.749972598041920e-20,
   4.609304603741984e-22,  -1.795850526000186e-23,   1.949860122882495e-01,  -6.063582307433376e-03,   1.291336778734394e-04,  -2.102345334475312e-06,   2.313805362143170e-08,
  -2.349160252541872e-11,  -7.076472009384520e-12,   2.121526500624054e-13,  -3.835422041715803e-15,   3.994371819339459e-17,   7.310671227363307e-19,  -2.776526997208549e-20,
   4.641721252840889e-22,  -1.776022822935766e-23,   1.950062475329763e-01,  -6.064569021530951e-03,   1.291553437556547e-04,  -2.102379180195865e-06,   2.312135727784701e-08,
  -2.279310399202214e-11,  -7.093226188815795e-12,   2.123749901796239e-13,  -3.830212603994967e-15,   3.970152186723894e-17,   7.359067030713954e-19,  -2.797846049781619e-20,
   4.667592529420452e-22,  -1.760047428722837e-23,   1.950196192383641e-01,  -6.065221027216526e-03,   1.291696573050795e-04,  -2.102401344706023e-06,   2.311031745073453e-08,
  -2.233141568428259e-11,  -7.104292859584289e-12,   2.125216579409800e-13,  -3.826764050257695e-15,   3.954114891546641e-17,   7.391094388591700e-19,  -2.811897639542332e-20,
   4.684568821204114e-22,  -1.749489975933042e-23,   1.950264864394248e-01,  -6.065555864129751e-03,   1.291770071067737e-04,  -2.102412665339157e-06,   2.310464575098366e-08,
  -2.209427557459617e-11,  -7.109974826832514e-12,   2.125969012681872e-13,  -3.824991118618587e-15,   3.945868658551209e-17,   7.407556847622350e-19,  -2.819102774322848e-20,
   4.693250176041061e-22,  -1.744067849670106e-23,   1.950288766619730e-01,  -6.065672407310177e-03,   1.291795651307173e-04,  -2.102416595733332e-06,   2.310267131050829e-08,
  -2.201173025196680e-11,  -7.111952280868793e-12,   2.126230780386048e-13,  -3.824373725461011e-15,   3.942996840673868e-17,   7.413289121389266e-19,  -2.821608831595896e-20,
   4.696265946439992e-22,  -1.742180570302384e-23,   1.950292559588127e-01,  -6.065690901113846e-03,   1.291799710471532e-04,  -2.102417218964853e-06,   2.310235797721921e-08,
  -2.199863113588499e-11,  -7.112266065775708e-12,   2.126272313447119e-13,  -3.824275739042462e-15,   3.942541044848791e-17,   7.414198866432417e-19,  -2.822006425013154e-20,
   4.696744229755030e-22,  -1.741881082275530e-23,   5.281134593104124e-01,  -1.420837171686336e-02,   2.020106593740566e-04,  -4.006706763722415e-07,  -5.671762608247621e-08,
   1.288225730673521e-09,  -3.386501545217398e-12,  -5.375124537546101e-13,   1.345959766660215e-14,  -2.239978986582025e-17,  -5.425810593237211e-18,   1.796398990018998e-19,
  -1.425939471504658e-21,  -1.124822638274075e-22,   5.281323336786165e-01,  -1.420848018464781e-02,   2.019787314364366e-04,  -3.994718716843199e-07,  -5.672197692089528e-08,
   1.287166723341331e-09,  -3.351648672905179e-12,  -5.375648532977527e-13,   1.343646394091005e-14,  -2.150503753806285e-17,  -5.433554645050130e-18,   1.788282453576698e-19,
  -1.402477614822433e-21,  -1.122877372749143e-22,   5.281656353624234e-01,  -1.420867130519651e-02,   2.019223921943469e-04,  -3.973573693078630e-07,  -5.672961438564171e-08,
   1.285298015718336e-09,  -3.290199745919861e-12,  -5.376548811525888e-13,   1.339561849958589e-14,  -1.992962418999713e-17,  -5.447102465223208e-18,   1.773972492865290e-19,
  -1.361200304284575e-21,  -1.119427719345825e-22,   5.282058999609514e-01,  -1.420890194558934e-02,   2.018542629639692e-04,  -3.948018670801564e-07,  -5.673878210813553e-08,
   1.283038233478762e-09,  -3.215979509689367e-12,  -5.377596034552749e-13,   1.334618434615250e-14,  -1.803039641007991e-17,  -5.463286100790385e-18,   1.756688916936101e-19,
  -1.311494349799486e-21,  -1.115227156960296e-22,   5.282449837867803e-01,  -1.420912536090966e-02,   2.017881209334854e-04,  -3.923224713952050e-07,  -5.674761125338403e-08,
   1.280844352644369e-09,  -3.144016284105776e-12,  -5.378569384402094e-13,   1.329814941460104e-14,  -1.619270615767441e-17,  -5.478789524514860e-18,   1.739931542328876e-19,
  -1.263457237257894e-21,  -1.111118901314212e-22,   5.282764660921788e-01,  -1.420930499301004e-02,   2.017348353825731e-04,  -3.903261354331971e-07,  -5.675467326157140e-08,
   1.279076904767134e-09,  -3.086107084268963e-12,  -5.379322552332065e-13,   1.325942102048646e-14,  -1.471661649131197e-17,  -5.491130676724905e-18,   1.726447286301697e-19,
  -1.224914184153311e-21,  -1.107787659394108e-22,   5.282972675128405e-01,  -1.420942352017361e-02,   2.016996240734039e-04,  -3.890074979675216e-07,  -5.675931493197319e-08,
   1.277908965541741e-09,  -3.047872791027922e-12,  -5.379805101375814e-13,   1.323381437971777e-14,  -1.374336142007954e-17,  -5.499213076855955e-18,   1.717544630119182e-19,
  -1.199521462443385e-21,  -1.105575862261045e-22,   5.283079495657543e-01,  -1.420948433681574e-02,   2.016815410215876e-04,  -3.883304709521473e-07,  -5.676169099175802e-08,
   1.277309160342304e-09,  -3.028247264821113e-12,  -5.380048238939355e-13,   1.322065933851174e-14,  -1.324420332776027e-17,  -5.503341413787938e-18,   1.712975014914417e-19,
  -1.186504526431546e-21,  -1.104436738868256e-22,   5.283116674769655e-01,  -1.420950549621153e-02,   2.016752469926142e-04,  -3.880948504015382e-07,  -5.676251678190124e-08,
   1.277100390674196e-09,  -3.021417951319242e-12,  -5.380132121451858e-13,   1.321607984269981e-14,  -1.307057102850805e-17,  -5.504774762030044e-18,   1.711384889063203e-19,
  -1.181977593419680e-21,  -1.104039738448131e-22,   5.283122574547041e-01,  -1.420950885351778e-02,   2.016742482141857e-04,  -3.880574618473667e-07,  -5.676264776554885e-08,
   1.277067261709670e-09,  -3.020334305989880e-12,  -5.380145397152262e-13,   1.321535310358799e-14,  -1.304302292233451e-17,  -5.505002045840151e-18,   1.711132575591756e-19,
  -1.181259408585197e-21,  -1.103976715370974e-22,   9.866034036326683e-01,  -1.995272000939789e-02,   4.706375525534148e-05,   5.080309781764478e-06,  -4.579456329256636e-08,
  -2.181597613554756e-09,   3.796866818887266e-11,   9.904240043245602e-13,  -3.125695466071374e-14,  -4.017822004155331e-16,   2.628557632674647e-17,   1.606622052769777e-19,
  -1.981809073612062e-20,  -4.586475734658491e-23,   9.866077647408344e-01,  -1.995129831850037e-02,   4.703829143108595e-05,   5.078280733182331e-06,  -4.574211082892357e-08,
  -2.179668904895470e-09,   3.788882003456765e-11,   9.890891766880885e-13,  -3.114982316946755e-14,  -4.009674415141831e-16,   2.616785978406132e-17,   1.603133225210212e-19,
  -1.971131956133802e-20,  -4.611853548323044e-23,   9.866154580791220e-01,  -1.994879018365595e-02,   4.699338387874446e-05,   5.074701908518434e-06,  -4.564964805815749e-08,
  -2.176267794185464e-09,   3.774815307278200e-11,   9.867360778072925e-13,  -3.096118742738472e-14,  -3.995312625221901e-16,   2.596067769456225e-17,   1.596962899088806e-19,
  -1.952350985339630e-20,  -4.655996975803081e-23,   9.866247576978400e-01,  -1.994575810620687e-02,   4.693912168191595e-05,   5.070376849746812e-06,  -4.553799509681783e-08,
  -2.172158757455541e-09,   3.757844246725996e-11,   9.838944773428333e-13,  -3.073376694732552e-14,  -3.977971400382185e-16,   2.571105360320279e-17,   1.589477656987983e-19,
  -1.929741114606115e-20,  -4.708297715595846e-23,   9.866337822068285e-01,  -1.994281544070907e-02,   4.688648725110240e-05,   5.066180768103676e-06,  -4.542976538739501e-08,
  -2.168173566259760e-09,   3.741409318475212e-11,   9.811398680181387e-13,  -3.051370146406513e-14,  -3.961163283945457e-16,   2.546966559306787e-17,   1.582186284979782e-19,
  -1.907896511030555e-20,  -4.757950019514465e-23,   9.866410497989853e-01,  -1.994044545698347e-02,   4.684411597137212e-05,   5.062802328753609e-06,  -4.534269217696684e-08,
  -2.164965861777297e-09,   3.728198365052132e-11,   9.789236305505860e-13,  -3.033692744988921e-14,  -3.947641866258324e-16,   2.527588021323852e-17,   1.576294887254180e-19,
  -1.890373534195073e-20,  -4.797152494352100e-23,   9.866458509026476e-01,  -1.993887970242695e-02,   4.681613262637125e-05,   5.060570831149252e-06,  -4.528521210968768e-08,
  -2.162847595625979e-09,   3.719482888072699e-11,   9.774605698267831e-13,  -3.022036655372657e-14,  -3.938716462580555e-16,   2.514815940184219e-17,   1.572393448075049e-19,
  -1.878831166155736e-20,  -4.822669059648632e-23,   9.866483161306302e-01,  -1.993807570173787e-02,   4.680176642757354e-05,   5.059425133222480e-06,  -4.525571076082612e-08,
  -2.161760175057120e-09,   3.715011425294063e-11,   9.767096476433739e-13,  -3.016058362652861e-14,  -3.934135722355925e-16,   2.508267028117781e-17,   1.570387260351471e-19,
  -1.872914875992374e-20,  -4.835653634926743e-23,   9.866491741171525e-01,  -1.993779587613351e-02,   4.679676687071458e-05,   5.059026407592192e-06,  -4.524544531763707e-08,
  -2.161381753698144e-09,   3.713455784120560e-11,   9.764483506588726e-13,  -3.013978782878425e-14,  -3.932541812793614e-16,   2.505989235842550e-17,   1.569688574218206e-19,
  -1.870857449074528e-20,  -4.840154071392389e-23,   9.866493102650128e-01,  -1.993775147233793e-02,   4.679597354455695e-05,   5.058963137463344e-06,  -4.524381646472638e-08,
  -2.161321706541192e-09,   3.713208958153216e-11,   9.764068896708708e-13,  -3.013648840097311e-14,  -3.932288903094348e-16,   2.505627858293519e-17,   1.569577682726120e-19,
  -1.870531048795397e-20,  -4.840867329311624e-23,   1.491054363287088e+00,  -1.683525171529260e-02,  -2.448705279533406e-04,   1.506908289937536e-06,   1.352368873388746e-07,
   1.292236665122162e-09,  -6.516517319546890e-11,  -2.021171044012093e-12,   1.180263774265387e-14,   1.754901665271321e-15,   2.406683983745077e-17,  -8.825569795138905e-19,
  -3.430080777481103e-20,   4.456295479480119e-23,   1.491031558381582e+00,  -1.683482375286444e-02,  -2.447949721875959e-04,   1.508087168534407e-06,   1.351456413629012e-07,
   1.288349561147304e-09,  -6.513224720495772e-11,  -2.015366227462490e-12,   1.189771571854218e-14,   1.750372871616796e-15,   2.386457558952283e-17,  -8.820260411611325e-19,
  -3.408421749666846e-20,   4.835235992455877e-23,   1.490991324463902e+00,  -1.683406834249046e-02,  -2.446616944828318e-04,   1.510164383951939e-06,   1.349846748010609e-07,
   1.281499938036266e-09,  -6.507394975527150e-11,  -2.005135946862746e-12,   1.206479729237999e-14,   1.742384176235262e-15,   2.350875614069607e-17,  -8.810673418061315e-19,
  -3.370299417878454e-20,   5.498833871708949e-23,   1.490942682892201e+00,  -1.683315444261193e-02,  -2.445006046327756e-04,   1.512671176400066e-06,   1.347900979399766e-07,
   1.273233030035864e-09,  -6.500311750041923e-11,  -1.992786536703542e-12,   1.226566863635469e-14,   1.732728369310393e-15,   2.308033196033649e-17,  -8.798710187529019e-19,
  -3.324364058942133e-20,   6.292689680430496e-23,   1.490895472663345e+00,  -1.683226677420603e-02,  -2.443442957028975e-04,   1.515099498707692e-06,   1.346012750086584e-07,
   1.265224113238376e-09,  -6.493400171494175e-11,  -1.980820089606329e-12,   1.245945379124020e-14,   1.723359164967166e-15,   2.266634415613138e-17,  -8.786711051955773e-19,
  -3.279941009919238e-20,   7.054416621965534e-23,   1.490857447999572e+00,  -1.683155134357371e-02,  -2.442184284920352e-04,   1.517051981745354e-06,   1.344492112268981e-07,
   1.258784011310077e-09,  -6.487807086142431e-11,  -1.971195938913321e-12,   1.261469468324897e-14,   1.715814724902466e-15,   2.233421294995851e-17,  -8.776770353674730e-19,
  -3.244276297692031e-20,   7.661683252634959e-23,   1.490832325544125e+00,  -1.683107843515691e-02,  -2.441352837398084e-04,   1.518340317388523e-06,   1.343487544884981e-07,
   1.254534268224708e-09,  -6.484098968545403e-11,  -1.964844236952773e-12,   1.271685007988091e-14,   1.710831116058747e-15,   2.211541713415934e-17,  -8.770068118197531e-19,
  -3.220769372525148e-20,   8.059847403013820e-23,   1.490819425063526e+00,  -1.683083552318784e-02,  -2.440925929890704e-04,   1.519001373698021e-06,   1.342971726733048e-07,
   1.252353602566881e-09,  -6.482190874486561e-11,  -1.961584735202360e-12,   1.276918051685181e-14,   1.708272301008249e-15,   2.200326213927290e-17,  -8.766585038095949e-19,
  -3.208715895784208e-20,   8.263365578827860e-23,   1.490814935108594e+00,  -1.683075096735714e-02,  -2.440777353650629e-04,   1.519231370374931e-06,   1.342792203494536e-07,
   1.251594885320492e-09,  -6.481526140868484e-11,  -1.960450617996012e-12,   1.278737372719627e-14,   1.707381763057235e-15,   2.196425851827708e-17,  -8.765366181002833e-19,
  -3.204523510474806e-20,   8.334049637495163e-23,   1.490814222622913e+00,  -1.683073754912708e-02,  -2.440753777256495e-04,   1.519267863406854e-06,   1.342763716198578e-07,
   1.251474500795029e-09,  -6.481420628137683e-11,  -1.960270667359578e-12,   1.279025974834359e-14,   1.707240450805723e-15,   2.195807074467715e-17,  -8.765172455011613e-19,
  -3.203858376119287e-20,   8.345258998408451e-23,   1.888482649114362e+00,  -5.118569416595688e-03,  -1.629574564361970e-04,  -4.089777714471233e-06,  -7.799332892404309e-08,
  -8.147907757979707e-10,   1.406564077100613e-11,   1.085038138127564e-12,   3.480257272450758e-14,   6.781278631930794e-16,   3.572817253916317e-18,  -3.149718613679590e-19,
  -1.461008950634151e-20,  -3.620467332835600e-22,   1.888467284054678e+00,  -5.119722286408850e-03,  -1.630012092397786e-04,  -4.090523284688453e-06,  -7.797246557460486e-08,
  -8.126190315396444e-10,   1.415723823998407e-11,   1.087281430608488e-12,   3.481467594262970e-14,   6.764022682232849e-16,   3.480720215447248e-18,  -3.175864555183948e-19,
  -1.464732713309292e-20,  -3.614767302052712e-22,   1.888440168844335e+00,  -5.121756710645671e-03,  -1.630784019545691e-04,  -4.091837188876665e-06,  -7.793554705264007e-08,
  -8.087833865101369e-10,   1.431888744153832e-11,   1.091234946168742e-12,   3.483571490840124e-14,   6.733465031002169e-16,   3.318030815894977e-18,  -3.221963215715360e-19,
  -1.471261901496298e-20,  -3.604533272294834e-22,   1.888407375180569e+00,  -5.124217043191780e-03,  -1.631717274751778e-04,  -4.093423133018063e-06,  -7.789072604780625e-08,
  -8.041392049495972e-10,   1.451439588519534e-11,   1.096007358659302e-12,   3.486061391471452e-14,   6.696328209039825e-16,   3.120994932096310e-18,  -3.277643656148012e-19,
  -1.479086187241303e-20,  -3.591857572403951e-22,   1.888375533731269e+00,  -5.126605789574655e-03,  -1.632623087085786e-04,  -4.094959760782068e-06,  -7.784702740181309e-08,
  -7.996243552411868e-10,   1.470423391716284e-11,   1.100631699253236e-12,   3.488421781052769e-14,   6.660081594299235e-16,   2.929392990128628e-18,  -3.331630842646825e-19,
  -1.486607386429604e-20,  -3.579237305259275e-22,   1.888349878426772e+00,  -5.128530345972118e-03,  -1.633352671563266e-04,  -4.096195511765189e-06,  -7.781169020409494e-08,
  -7.959826999021395e-10,   1.485719451110337e-11,   1.104350802649097e-12,   3.490282572077494e-14,   6.630742295992592e-16,   2.774810890106350e-18,  -3.375073980817579e-19,
  -1.492612818612391e-20,  -3.568844856878235e-22,   1.888332923779337e+00,  -5.129802162933583e-03,  -1.633834706098749e-04,  -4.097011027311258e-06,  -7.778827433019968e-08,
  -7.935741325227608e-10,   1.495828244299635e-11,   1.106805274234246e-12,   3.491492202677934e-14,   6.611287149175221e-16,   2.672553671620011e-18,  -3.403756553317497e-19,
  -1.496554809365968e-20,  -3.561867156608295e-22,   1.888324216113643e+00,  -5.130455334057142e-03,  -1.634082234731682e-04,  -4.097429509723880e-06,  -7.777622884410960e-08,
  -7.923365298072222e-10,   1.501020031806946e-11,   1.108064819345800e-12,   3.492107233862127e-14,   6.601274898621452e-16,   2.620005135177844e-18,  -3.418478986158440e-19,
  -1.498571063646217e-20,  -3.558249576201996e-22,   1.888321185228495e+00,  -5.130682681382213e-03,  -1.634168386285728e-04,  -4.097575114791256e-06,  -7.777203306816454e-08,
  -7.919056613357903e-10,   1.502827150484828e-11,   1.108503065210737e-12,   3.492320318219450e-14,   6.597786684467640e-16,   2.601709643555057e-18,  -3.423602074232869e-19,
  -1.499271541078719e-20,  -3.556984999309853e-22,   1.888320704263905e+00,  -5.130718758515310e-03,  -1.634182057205853e-04,  -4.097598217861750e-06,  -7.777136710276675e-08,
  -7.918372832452194e-10,   1.503113918623416e-11,   1.108572601653627e-12,   3.492354085106055e-14,   6.597232993491000e-16,   2.598806140469929e-18,  -3.424414981184304e-19,
  -1.499382635535949e-20,  -3.556784069873278e-22,   1.924919449253058e-02,  -5.982655296062089e-04,   1.382091509035060e-05,  -2.817941827070353e-07,   5.292029126729438e-09,
  -9.484533212241338e-11,   1.590894246214880e-12,  -2.557727936015904e-14,   4.380523141644527e-16,  -4.469875357858539e-18,   7.478302215668062e-20,  -2.486204186360367e-21,
  -2.118155089453390e-23,   7.179198190920445e-25,   1.925049620228737e-02,  -5.983450988539439e-04,   1.382390456378817e-05,  -2.818835257185149e-07,   5.294280001781228e-09,
  -9.489593320684578e-11,   1.592050554892601e-12,  -2.559269339460979e-14,   4.383639099497405e-16,  -4.482496870061696e-18,   7.466056924294252e-20,  -2.481094980821992e-21,
  -2.099428404985063e-23,   7.153358797121826e-25,   1.925279331904156e-02,  -5.984855205485273e-04,   1.382918056936458e-05,  -2.820412115139340e-07,   5.298253030795170e-09,
  -9.498524445081716e-11,   1.594091542423603e-12,  -2.561992618823989e-14,   4.389133131490691e-16,  -4.504746451505134e-18,   7.444542979651160e-20,  -2.472094730874390e-21,
  -2.066488140573464e-23,   7.108015300215122e-25,   1.925557140838271e-02,  -5.986553549311172e-04,   1.383556213287791e-05,  -2.822319527705231e-07,   5.303059518957280e-09,
  -9.509328294377618e-11,   1.596560655680123e-12,  -2.565291513727158e-14,   4.395769562492331e-16,  -4.531614649389239e-18,   7.418686417795710e-20,  -2.461237046885155e-21,
  -2.026832040795864e-23,   7.053612727657256e-25,   1.925826873917628e-02,  -5.988202638370380e-04,   1.384175908911348e-05,  -2.824171901155614e-07,   5.307727940757959e-09,
  -9.519820927321671e-11,   1.598958809951953e-12,  -2.568500172429449e-14,   4.402204780431247e-16,  -4.557659941400178e-18,   7.393750666936263e-20,  -2.450723183359791e-21,
  -1.988517913237838e-23,   7.001247216855132e-25,   1.926044196742032e-02,  -5.989531385558190e-04,   1.384675259866737e-05,  -2.825664643868661e-07,   5.311490456557514e-09,
  -9.528276842798653e-11,   1.600891578114980e-12,  -2.571089428054695e-14,   4.407383687026688e-16,  -4.578614580390023e-18,   7.373780907990085e-20,  -2.442272310070907e-21,
  -1.957783496317871e-23,   6.959383009104521e-25,   1.926187814172056e-02,  -5.990409526572159e-04,   1.385005286836005e-05,  -2.826651263951990e-07,   5.313977490520739e-09,
  -9.533865922833123e-11,   1.602169131027350e-12,  -2.572802515892843e-14,   4.410803267603694e-16,  -4.592447774310580e-18,   7.360642972718647e-20,  -2.436697369011355e-21,
  -1.937538691609960e-23,   6.931876975602230e-25,   1.926261573041517e-02,  -5.990860533758184e-04,   1.385174791504802e-05,  -2.827158015513637e-07,   5.315254958356275e-09,
  -9.536736666127322e-11,   1.602825343607905e-12,  -2.573682934256023e-14,   4.412558599328346e-16,  -4.599547684310537e-18,   7.353913839411912e-20,  -2.433837221364251e-21,
  -1.927161758069727e-23,   6.917799899283252e-25,   1.926287246199549e-02,  -5.991017517269400e-04,   1.385233792345963e-05,  -2.827334406966941e-07,   5.315699633636756e-09,
  -9.537735931583305e-11,   1.603053764784692e-12,  -2.573989477897315e-14,   4.413169433542882e-16,  -4.602018221051004e-18,   7.351574538306649e-20,  -2.432842174016333e-21,
  -1.923553111227418e-23,   6.912907979807694e-25,   1.926291320209767e-02,  -5.991042428691128e-04,   1.385243155118276e-05,  -2.827362398427726e-07,   5.315770199421403e-09,
  -9.537894504903259e-11,   1.603090013046941e-12,  -2.574038127181463e-14,   4.413266358585833e-16,  -4.602410230262365e-18,   7.351203457994009e-20,  -2.432684295208473e-21,
  -1.922980617671545e-23,   6.912132066817169e-25,   1.725773800340605e-01,  -5.121799644983185e-03,   1.060025697221059e-04,  -1.742460202332573e-06,   2.141127141633080e-08,
  -1.360314949625390e-10,  -2.571539230858328e-12,   1.148165884139180e-13,  -2.119126846110331e-15,   4.933175413258505e-17,  -2.545202033725607e-19,  -2.091249491183885e-20,
  -3.038387908753477e-23,   1.052849377722932e-24,   1.725873418904390e-01,  -5.122290152948098e-03,   1.060145927172575e-04,  -1.742585806674318e-06,   2.140758911519062e-08,
  -1.358028528423113e-10,  -2.577124129552878e-12,   1.149802780247297e-13,  -2.120201765352067e-15,   4.922413117297979e-17,  -2.545767644980117e-19,  -2.090685942184736e-20,
  -2.753080446031674e-23,   1.014987923633373e-24,   1.726049206568820e-01,  -5.123155690366320e-03,   1.060358057821099e-04,  -1.742807262447655e-06,   2.140108524292524e-08,
  -1.353991495981406e-10,  -2.586981065690637e-12,   1.152688157619287e-13,  -2.122098556223517e-15,   4.903425029681623e-17,  -2.546623400930436e-19,  -2.089713626962102e-20,
  -2.250782375372456e-23,   9.485017619249889e-25,   1.726261786476923e-01,  -5.124202355853061e-03,   1.060614539474416e-04,  -1.743074750501559e-06,   2.139320978703420e-08,
  -1.349105432560713e-10,  -2.598904090552193e-12,   1.156172154487189e-13,  -2.124392277402733e-15,   4.880468039461291e-17,  -2.547415988751246e-19,  -2.088575403352633e-20,
  -1.645323694930725e-23,   8.686534520867638e-25,   1.726468171692380e-01,  -5.125218491231057e-03,   1.060863497036574e-04,  -1.743334110375539e-06,   2.138555300986271e-08,
  -1.344357480682081e-10,  -2.610482853665122e-12,   1.159549089062177e-13,  -2.126619046023768e-15,   4.858185489419007e-17,  -2.547932282269640e-19,  -2.087509549052265e-20,
  -1.059566584838751e-23,   7.917116280899516e-25,   1.726634444630777e-01,  -5.126037112936894e-03,   1.061064032220774e-04,  -1.743542823004889e-06,   2.137937662507897e-08,
  -1.340529266395575e-10,  -2.619813490075605e-12,   1.162265728553818e-13,  -2.128412917751670e-15,   4.840237550873481e-17,  -2.548167177471900e-19,  -2.086678817605308e-20,
  -5.891263562411306e-24,   7.301393858116917e-25,   1.726744320551204e-01,  -5.126578061320657e-03,   1.061196531621713e-04,  -1.743680626713982e-06,   2.137529137195773e-08,
  -1.337998023268971e-10,  -2.625980445634200e-12,   1.164058987283993e-13,  -2.129598271983084e-15,   4.828379120319047e-17,  -2.548233897941670e-19,  -2.086143501487082e-20,
  -2.789706315389787e-24,   6.896548864750145e-25,   1.726800748864085e-01,  -5.126855869684439e-03,   1.061264573100640e-04,  -1.743751361520935e-06,   2.137319215933138e-08,
  -1.336697605793398e-10,  -2.629147916864183e-12,   1.164979339885379e-13,  -2.130207004222648e-15,   4.822289629823889e-17,  -2.548240824313675e-19,  -2.085872791915625e-20,
  -1.199078913064359e-24,   6.689264382010707e-25,   1.726820389536978e-01,  -5.126952564302619e-03,   1.061288255034454e-04,  -1.743775976005868e-06,   2.137246131178223e-08,
  -1.336244903523843e-10,  -2.630250454992595e-12,   1.165299586045817e-13,  -2.130418878208444e-15,   4.820170187119945e-17,  -2.548238885542597e-19,  -2.085779236852040e-20,
  -6.457917987073649e-25,   6.617216279870199e-25,   1.726823506254649e-01,  -5.126967908448268e-03,   1.061292013006222e-04,  -1.743779881728668e-06,   2.137234532697150e-08,
  -1.336173062108206e-10,  -2.630425415968357e-12,   1.165350400381392e-13,  -2.130452499647304e-15,   4.819833863602920e-17,  -2.548238371452178e-19,  -2.085764422640208e-20,
  -5.580091420454044e-25,   6.605787946007700e-25,   4.744624310906230e-01,  -1.262503833499905e-02,   1.925817245372023e-04,  -1.110715484827245e-06,  -3.274089215366472e-08,
   1.073123134050963e-09,  -1.274614317592903e-11,  -1.480064317581397e-13,   1.035314955127539e-14,  -1.161584880178183e-16,  -3.365081188437084e-19,   3.829460947177462e-20,
  -3.167918189264681e-21,   3.456887449563793e-23,   4.744804484199650e-01,  -1.262534718886547e-02,   1.925632086311253e-04,  -1.109711941446223e-06,  -3.275849557755449e-08,
   1.072825609499323e-09,  -1.271900984421090e-11,  -1.483930520578128e-13,   1.035112549653629e-14,  -1.159521410794986e-16,  -3.554141396726661e-19,   3.852637068070035e-20,
  -3.152877063982890e-21,   3.418530129295379e-23,   4.745122388584919e-01,  -1.262589193735084e-02,   1.925305290483432e-04,  -1.107941401993436e-06,  -3.278952609318403e-08,
   1.072300006598812e-09,  -1.267113733722259e-11,  -1.490746770142147e-13,   1.034748978557104e-14,  -1.155870885205283e-16,  -3.886986973768194e-19,   3.893306058009123e-20,
  -3.126359338423842e-21,   3.351025616289508e-23,   4.745506777704765e-01,  -1.262655026257675e-02,   1.924909989589557e-04,  -1.105800836923661e-06,  -3.282699566586713e-08,
   1.071663392004060e-09,  -1.261325746959996e-11,  -1.498979270282325e-13,   1.034298409657438e-14,  -1.151440494377210e-16,  -4.288182318068645e-19,   3.942099424766918e-20,
  -3.094332331878240e-21,   3.269701435631136e-23,   4.745879910599146e-01,  -1.262718894446788e-02,   1.924526096148441e-04,  -1.103723222380737e-06,  -3.286331513070281e-08,
   1.071044278885053e-09,  -1.255707727547277e-11,  -1.506960973266771e-13,   1.033849576855952e-14,  -1.147122731964082e-16,  -4.676311080493785e-19,   3.989065973756559e-20,
  -3.063281416016749e-21,   3.191070883026776e-23,   4.746180483397184e-01,  -1.262770316539218e-02,   1.924216734803174e-04,  -1.102049816438797e-06,  -3.289253396638804e-08,
   1.070544742770805e-09,  -1.251182547251301e-11,  -1.513383558363640e-13,   1.033479830529925e-14,  -1.143632408096409e-16,  -4.988019768465595e-19,   4.026614804048677e-20,
  -3.038296125031145e-21,   3.127954837438077e-23,   4.746379087630456e-01,  -1.262804281001939e-02,   1.924012264537571e-04,  -1.100944203333975e-06,  -3.291182183885423e-08,
   1.070214273277879e-09,  -1.248192697176778e-11,  -1.517623872799819e-13,   1.033231513702726e-14,  -1.141320216621153e-16,  -5.193520189336840e-19,   4.051286235540043e-20,
  -3.021800457013357e-21,   3.086360440141689e-23,   4.746481077649083e-01,  -1.262821718944220e-02,   1.923907243879120e-04,  -1.100376462577859e-06,  -3.292172108072127e-08,
   1.070044442387722e-09,  -1.246657362214507e-11,  -1.519800357718192e-13,   1.033102756992793e-14,  -1.140130992184391e-16,  -5.298908848175161e-19,   4.063912904450639e-20,
  -3.013333524740122e-21,   3.065034243151102e-23,   4.746516575769955e-01,  -1.262827787673775e-02,   1.923870688027195e-04,  -1.100178862291139e-06,  -3.292516564676457e-08,
   1.069985312251653e-09,  -1.246122990185483e-11,  -1.520557724890294e-13,   1.033057745685949e-14,  -1.139716785053047e-16,  -5.335567155272211e-19,   4.068300845110397e-20,
  -3.010387229239642e-21,   3.057616961334754e-23,   4.746522208812002e-01,  -1.262828750664062e-02,   1.923864887000655e-04,  -1.100147506183316e-06,  -3.292571220658459e-08,
   1.069975928214383e-09,  -1.246038193434680e-11,  -1.520677900161288e-13,   1.033050593692309e-14,  -1.139651042485343e-16,  -5.341383223385144e-19,   4.068996824009974e-20,
  -3.009919725850539e-21,   3.056440201818978e-23,   9.079101421998450e-01,  -1.934776739825795e-02,   1.023723593016786e-04,   4.055348425413910e-06,  -7.868196326203683e-08,
  -1.056664714905004e-09,   5.096902272440790e-11,  -4.078984288104014e-14,  -2.754250478149335e-14,   5.281105291336788e-16,   1.464789686987897e-17,  -5.831881757191264e-19,
  -7.046109055712057e-21,   4.207586076441391e-22,   9.079196515545096e-01,  -1.934663032459710e-02,   1.023285001778298e-04,   4.054357382446598e-06,  -7.861112658060090e-08,
  -1.056718028381142e-09,   5.089796733117305e-11,  -3.908244404237559e-14,  -2.748208996490825e-14,   5.252173411408493e-16,   1.460486140538602e-17,  -5.802414551187618e-19,
  -7.034139021330664e-21,   4.183837529146832e-22,   9.079364276652140e-01,  -1.934462416687631e-02,   1.022511422604494e-04,   4.052608639131893e-06,  -7.848621488901161e-08,
  -1.056809404718777e-09,   5.077271706730827e-11,  -3.607756719941802e-14,  -2.737563417504651e-14,   5.201244856900392e-16,   1.452898610486535e-17,  -5.750558749060747e-19,
  -7.012904780472105e-21,   4.142054600997627e-22,   9.079567079005809e-01,  -1.934219868597120e-02,   1.021576551130510e-04,   4.050493986160313e-06,  -7.833530791784928e-08,
  -1.056915309378014e-09,   5.062148130868559e-11,  -3.245740909777795e-14,  -2.724715737570201e-14,   5.139869472497663e-16,   1.443734204575126e-17,  -5.688091603693836e-19,
  -6.987036838592857e-21,   4.091737566242754e-22,   9.079763897221187e-01,  -1.933984447577896e-02,   1.020669568389022e-04,   4.048441063015472e-06,  -7.818895398866862e-08,
  -1.057013325552971e-09,   5.047489247402851e-11,  -2.895699528566578e-14,  -2.712269664467506e-14,   5.080504586462195e-16,   1.434848619161724e-17,  -5.627697600597856e-19,
  -6.961726016233885e-21,   4.043107416837094e-22,   9.079922409301491e-01,  -1.933794824462081e-02,   1.019939326147660e-04,   4.046787216918916e-06,  -7.807115621394415e-08,
  -1.057088858719339e-09,   5.035696574255202e-11,  -2.614709859819346e-14,  -2.702262051880697e-14,   5.032836325949978e-16,   1.427698466378731e-17,  -5.579222239607211e-19,
  -6.941194739060190e-21,   4.004086655273180e-22,   9.080027130645986e-01,  -1.933669539082312e-02,   1.019456996356292e-04,   4.045694366821192e-06,  -7.799336796147883e-08,
  -1.057137094638541e-09,   5.027912175082273e-11,  -2.429525261579653e-14,  -2.695658390602556e-14,   5.001413893365605e-16,   1.422977683503442e-17,  -5.547277198337847e-19,
  -6.927559355962662e-21,   3.978378248237044e-22,   9.080080903693202e-01,  -1.933605203435731e-02,   1.019209359155920e-04,   4.045133130526866e-06,  -7.795343555652128e-08,
  -1.057161348723703e-09,   5.023916982702607e-11,  -2.334574966799742e-14,  -2.692269935772260e-14,   4.985300414358392e-16,   1.420554547933564e-17,  -5.530898639163174e-19,
  -6.920535791447006e-21,   3.965199176539942e-22,   9.080099618880102e-01,  -1.933582811523764e-02,   1.019123176665297e-04,   4.044937786232348e-06,  -7.793953919770882e-08,
  -1.057169708273085e-09,   5.022526812339090e-11,  -2.301550648228825e-14,  -2.691091005260640e-14,   4.979695699961925e-16,   1.419711346667706e-17,  -5.525202186589084e-19,
  -6.918087818168907e-21,   3.960615807368669e-22,   9.080102588674348e-01,  -1.933579258268905e-02,   1.019109501161137e-04,   4.044906787742375e-06,  -7.793733415468913e-08,
  -1.057171030912239e-09,   5.022306230098894e-11,  -2.296311282783455e-14,  -2.690903946691378e-14,   4.978806485974831e-16,   1.419577551419435e-17,  -5.524298439945805e-19,
  -6.917699199314899e-21,   3.959888666718251e-22,   1.419963668613637e+00,  -1.868377744895013e-02,  -2.132762663215013e-04,   3.774801732385021e-06,   1.413428853307699e-07,
  -8.455347486688682e-10,  -1.062222364306245e-10,  -5.496580270136822e-13,   7.897733424618917e-14,   1.526224019884699e-15,  -4.256368489498338e-17,  -1.787002259773102e-18,
   1.011923055389823e-20,   1.519867954230599e-21,   1.419943831922789e+00,  -1.868271861139835e-02,  -2.131975894069419e-04,   3.774000677247635e-06,   1.411959133500048e-07,
  -8.465390861759279e-10,  -1.060185792692817e-10,  -5.447350140014636e-13,   7.879990192438581e-14,   1.517416848511131e-15,  -4.249783984885004e-17,  -1.776453458626833e-18,
   1.019111100081806e-20,   1.509534000044225e-21,   1.419908835667638e+00,  -1.868085046044556e-02,  -2.130588293997072e-04,   3.772586461116844e-06,   1.409368103756473e-07,
  -8.483034873467764e-10,  -1.056596003611120e-10,  -5.360721485568799e-13,   7.848704841193302e-14,   1.501920102083121e-15,  -4.238130969464089e-17,  -1.757900524373989e-18,
   1.031648409622158e-20,   1.491362306404717e-21,   1.419866527875046e+00,  -1.867859178716034e-02,  -2.128911528818304e-04,   3.770875115130034e-06,   1.406238945486099e-07,
  -8.504238006502251e-10,  -1.052261623178166e-10,  -5.256375354961479e-13,   7.810913319107471e-14,   1.483255518188246e-15,  -4.223981597113724e-17,  -1.735569177191093e-18,
   1.046560958777620e-20,   1.469495686008573e-21,   1.419825466725494e+00,  -1.867639943603483e-02,  -2.127284942536918e-04,   3.769212454935417e-06,   1.403205337675881e-07,
  -8.524683538529427e-10,  -1.048060611730815e-10,  -5.155502232513352e-13,   7.774266965772578e-14,   1.465213794557147e-15,  -4.210185081669884e-17,  -1.713997890562015e-18,
   1.060780229360084e-20,   1.448379549093367e-21,   1.419792395934147e+00,  -1.867463354287804e-02,  -2.125975436569126e-04,   3.767872098798852e-06,   1.400764455483328e-07,
  -8.541055475702783e-10,  -1.044681150556757e-10,  -5.074543433770517e-13,   7.744774587990713e-14,   1.450735012856757e-15,  -4.199027845777457e-17,  -1.696697208641853e-18,
   1.072051811512452e-20,   1.431448465234983e-21,   1.419770547033325e+00,  -1.867346678792495e-02,  -2.125110554661039e-04,   3.766985957170291e-06,   1.399153008718221e-07,
  -8.551825519076192e-10,  -1.042450421104767e-10,  -5.021195500485020e-13,   7.725300996689206e-14,   1.441194752977940e-15,  -4.191634494592049e-17,  -1.685302769975955e-18,
   1.079410646801720e-20,   1.420299715041274e-21,   1.419759327717907e+00,  -1.867286763924584e-02,  -2.124666525109543e-04,   3.766530739657553e-06,   1.398325900260151e-07,
  -8.557341552626605e-10,  -1.041305563855067e-10,  -4.993844553434955e-13,   7.715304849461754e-14,   1.436303728687488e-15,  -4.187831245080499e-17,  -1.679462771695302e-18,
   1.083162275846809e-20,   1.414586348300780e-21,   1.419755422913991e+00,  -1.867265910576402e-02,  -2.124511997040748e-04,   3.766372274551971e-06,   1.398038088659703e-07,
  -8.559259088442921e-10,  -1.040907201849067e-10,  -4.984332086816301e-13,   7.711826311621912e-14,   1.434602691942523e-15,  -4.186506472135790e-17,  -1.677431950402973e-18,
   1.084463698709636e-20,   1.412599675822853e-21,   1.419754803284007e+00,  -1.867262601464317e-02,  -2.124487476536718e-04,   3.766347127255415e-06,   1.397992420296170e-07,
  -8.559563262484086e-10,  -1.040843992793567e-10,  -4.982822934911185e-13,   7.711274349420942e-14,   1.434332823908691e-15,  -4.186296200695916e-17,  -1.677109774518910e-18,
   1.084670009522128e-20,   1.412284509249474e-21,   1.865058871522035e+00,  -6.640810408226209e-03,  -2.199661860717736e-04,  -5.436810740484564e-06,  -8.770576188667005e-08,
   3.580459177968562e-11,   6.367439630945173e-11,   2.574438104247230e-12,   5.602282738480193e-14,   2.624929351087098e-16,  -3.323400014698761e-17,  -1.532186934604047e-18,
  -3.553200167011018e-20,  -2.499798651950969e-22,   1.865038151745203e+00,  -6.642339230169024e-03,  -2.200150045269046e-04,  -5.436734463440956e-06,  -8.761452177718083e-08,
   4.088333371876565e-11,   6.381839963514357e-11,   2.575116614707413e-12,   5.587583717511994e-14,   2.545437484147968e-16,  -3.344621224951279e-17,  -1.533520184025849e-18,
  -3.536954182072249e-20,  -2.410364115131816e-22,   1.865001587713573e+00,  -6.645036835704556e-03,  -2.201011033364578e-04,  -5.436595997422770e-06,  -8.745336374055951e-08,
   4.984583763807175e-11,   6.407217798067565e-11,   2.576292011304629e-12,   5.561574957290487e-14,   2.405122021901811e-16,  -3.381982803205546e-17,  -1.535819347904475e-18,
  -3.508119551544947e-20,  -2.252399512467481e-22,   1.864957367858444e+00,  -6.648298766190475e-03,  -2.202051430638083e-04,  -5.436421956925686e-06,  -8.725821131388183e-08,
   6.068504674595423e-11,   6.437850656561307e-11,   2.577676055617866e-12,   5.530002137954135e-14,   2.235365961693985e-16,  -3.427017734283983e-17,  -1.538508451659320e-18,
  -3.472966072510272e-20,  -2.061126140785365e-22,   1.864914433459668e+00,  -6.651465346090116e-03,  -2.203060677007559e-04,  -5.436246083201888e-06,  -8.706846949267028e-08,
   7.120926436351898e-11,   6.467531519724334e-11,   2.578980634628605e-12,   5.499223505040431e-14,   2.070482557340156e-16,  -3.470586291362897e-17,  -1.541023544556899e-18,
  -3.438540719173747e-20,  -1.875174491060375e-22,   1.864879841390479e+00,  -6.654016268350510e-03,  -2.203873172570035e-04,  -5.436099444332007e-06,  -8.691540751534624e-08,
   7.968863443017456e-11,   6.491401113169856e-11,   2.580003615829015e-12,   5.474336901978816e-14,   1.937593564327184e-16,  -3.505576152209528e-17,  -1.542981234436245e-18,
  -3.410594521758958e-20,  -1.725187654248402e-22,   1.864856981278782e+00,  -6.655701855799096e-03,  -2.204409790489597e-04,  -5.436000120599786e-06,  -8.681416492452203e-08,
   8.529222859401135e-11,   6.507153639977210e-11,   2.580665885291733e-12,   5.457847434246838e-14,   1.849753543681052e-16,  -3.528643544430152e-17,  -1.544241312150276e-18,
  -3.392023851920646e-20,  -1.625989489355559e-22,   1.864845240810010e+00,  -6.656567480444798e-03,  -2.204685287575494e-04,  -5.435948362387437e-06,  -8.676214049646197e-08,
   8.817011905280591e-11,   6.515237099680237e-11,   2.581001755373325e-12,   5.449365450806314e-14,   1.804634535070933e-16,  -3.540473231090134e-17,  -1.544878048880389e-18,
  -3.382454716735941e-20,  -1.575019186469770e-22,   1.864841154319703e+00,  -6.656868768203974e-03,  -2.204781163818363e-04,  -5.435930227948463e-06,  -8.674402790261993e-08,
   8.917182315282389e-11,   6.518049631456446e-11,   2.581117983441055e-12,   5.446411014803720e-14,   1.788929035887375e-16,  -3.544588027449298e-17,  -1.545098019076020e-18,
  -3.379118968957614e-20,  -1.557274194577529e-22,   1.864840505844625e+00,  -6.656916578382657e-03,  -2.204796377438516e-04,  -5.435927344588722e-06,  -8.674115344537390e-08,
   8.933078112232368e-11,   6.518495894482482e-11,   2.581136395208528e-12,   5.445942081896747e-14,   1.786436722504051e-16,  -3.545240863817707e-17,  -1.545132846889921e-18,
  -3.378589388635417e-20,  -1.554458104789209e-22,   1.705770836142293e-02,  -4.999166838371944e-04,   1.089094116924039e-05,  -2.104391866600601e-07,   3.726540595569292e-09,
  -6.380741854952623e-11,   1.049603961897411e-12,  -1.378209916607924e-14,   3.031278630843271e-16,  -3.792531355337242e-18,  -3.911059665953524e-20,  -2.217029541139169e-21,
   3.690499324502830e-23,   1.238021889263472e-24,   1.705873361015350e-02,  -4.999760813069870e-04,   1.089304573371655e-05,  -2.104992360931399e-07,   3.728025964990488e-09,
  -6.383476081748926e-11,   1.050396436095765e-12,  -1.379518655183522e-14,   3.029701572842535e-16,  -3.803617211145992e-18,  -3.888361343619463e-20,  -2.208122816414650e-21,
   3.687387239233984e-23,   1.235323849674897e-24,   1.706054283910635e-02,  -5.000809028492895e-04,   1.089675995238584e-05,  -2.106052151687238e-07,   3.730647827502575e-09,
  -6.388302776895196e-11,   1.051794437161199e-12,  -1.381830961489354e-14,   3.026926602854952e-16,  -3.823141188663232e-18,  -3.848324209010322e-20,  -2.192422364441647e-21,
   3.682008806000464e-23,   1.230595781967169e-24,   1.706273085338986e-02,  -5.002076776646590e-04,   1.090125238765594e-05,  -2.107334018572267e-07,   3.733819754169957e-09,
  -6.394142867458745e-11,   1.053484349821765e-12,  -1.384632163394501e-14,   3.023584331032942e-16,  -3.846686423887837e-18,  -3.799935068379413e-20,  -2.173463687273373e-21,
   3.675696760815650e-23,   1.224933693709325e-24,   1.706485522812249e-02,  -5.003307730599448e-04,   1.090561478363666e-05,  -2.108578806303633e-07,   3.736900620641068e-09,
  -6.399816099545157e-11,   1.055124297393693e-12,  -1.387356891627262e-14,   3.020353584238843e-16,  -3.869477429481398e-18,  -3.752984572121198e-20,  -2.155086495032495e-21,
   3.669768676329455e-23,   1.219494072887433e-24,   1.706656680340875e-02,  -5.004299547376876e-04,   1.090912994575877e-05,  -2.109581858858613e-07,   3.739383683494845e-09,
  -6.404389088015059e-11,   1.056444995842218e-12,  -1.389555738517743e-14,   3.017760873663553e-16,  -3.887790102019462e-18,  -3.715179320718288e-20,  -2.140301702953200e-21,
   3.665135269813558e-23,   1.215152354261446e-24,   1.706769788305124e-02,  -5.004955008558786e-04,   1.091145312964504e-05,  -2.110244789254487e-07,   3.741025013545978e-09,
  -6.407412163685281e-11,   1.057317483644906e-12,  -1.391010575627825e-14,   3.016052521015386e-16,  -3.899867565433713e-18,  -3.690206694021845e-20,  -2.130541743867345e-21,
   3.662142894382379e-23,   1.212302989575321e-24,   1.706827877786271e-02,  -5.005291645937410e-04,   1.091264632792292e-05,  -2.110585276296547e-07,   3.741868090191702e-09,
  -6.408965068131479e-11,   1.057765484195701e-12,  -1.391758284424799e-14,   3.015176704286097e-16,  -3.906062741798365e-18,  -3.677384626872543e-20,  -2.125532487238878e-21,
   3.660627529175671e-23,   1.210845712749865e-24,   1.706848096860395e-02,  -5.005408819910624e-04,   1.091306165255762e-05,  -2.110703792388188e-07,   3.742161558618037e-09,
  -6.409505636110296e-11,   1.057921404759481e-12,  -1.392018623660230e-14,   3.014872107686395e-16,  -3.908217887060954e-18,  -3.672922195772263e-20,  -2.123789438280147e-21,
   3.660103487361449e-23,   1.210339446947122e-24,   1.706851305372650e-02,  -5.005427414008228e-04,   1.091312755985641e-05,  -2.110722599566325e-07,   3.742208129339060e-09,
  -6.409591419907264e-11,   1.057946146724805e-12,  -1.392059940294218e-14,   3.014823783767265e-16,  -3.908559824695813e-18,  -3.672214088673459e-20,  -2.123512862648742e-21,
   3.660020490188392e-23,   1.210259154689957e-24,   1.536617235041209e-01,  -4.351816928337095e-03,   8.705058491925355e-05,  -1.424023022830439e-06,   1.830083745467092e-08,
  -1.653067920610631e-10,  -6.350979543374439e-14,   7.165658334762582e-14,  -7.467389038869635e-16,   2.113006285251059e-17,  -1.114766151338259e-18,  -1.492566142474356e-20,
   3.614287813967618e-22,   1.049968578854937e-23,   1.536699051441350e-01,  -4.352217975420613e-03,   8.706087846443043e-05,  -1.424176801202650e-06,   1.830072368646464e-08,
  -1.651646189053343e-10,  -6.556540399944260e-14,   7.172597787721020e-14,  -7.513698440908434e-16,   2.105599755487357e-17,  -1.112528156537664e-18,  -1.485094047594650e-20,
   3.614469650969029e-22,   1.046189432532690e-23,   1.536843425613496e-01,  -4.352925664273343e-03,   8.707904152925775e-05,  -1.424448036863425e-06,   1.830052055306396e-08,
  -1.649136419990915e-10,  -6.920239709292655e-14,   7.184822451290934e-14,  -7.595335330402433e-16,   2.092561931893458e-17,  -1.108578954734372e-18,  -1.471931422442105e-20,
   3.614911522940969e-22,   1.039555754688519e-23,   1.537018017784769e-01,  -4.353781468796114e-03,   8.710100440238498e-05,  -1.424775832529458e-06,   1.830027084323546e-08,
  -1.646099704695026e-10,  -7.361705384397224e-14,   7.199570413501450e-14,  -7.693920607798891e-16,   2.076849446985099e-17,  -1.103803113283233e-18,  -1.456052416544761e-20,
   3.615651326840416e-22,   1.031592847453551e-23,   1.537187522853554e-01,  -4.354612331404382e-03,   8.712232547487260e-05,  -1.425093856673504e-06,   1.830002414823945e-08,
  -1.643149752591888e-10,  -7.792026890372119e-14,   7.213851707169345e-14,  -7.789488379024209e-16,   2.061651450464496e-17,  -1.099166312217886e-18,  -1.440676323644349e-20,
   3.616583603854010e-22,   1.023923287285954e-23,   1.537324083971553e-01,  -4.355281708204783e-03,   8.713950137799384e-05,  -1.425349913583136e-06,   1.829982233972688e-08,
  -1.640771906122432e-10,  -8.139944218441538e-14,   7.225330952850861e-14,  -7.866378286933612e-16,   2.049447788640796e-17,  -1.095430572780230e-18,  -1.428317344188846e-20,
   3.617487253230669e-22,   1.017787797056781e-23,   1.537414326040904e-01,  -4.355724042344349e-03,   8.715085087150477e-05,  -1.425519043248416e-06,   1.829968748024800e-08,
  -1.639199981175111e-10,  -8.370456314627553e-14,   7.232903730939320e-14,  -7.917137661509602e-16,   2.041403215814189e-17,  -1.092961855576194e-18,  -1.420164314085813e-20,
   3.618158781955542e-22,   1.013754439628504e-23,   1.537460671181548e-01,  -4.355951208853462e-03,   8.715667936788327e-05,  -1.425605878334678e-06,   1.829961775649417e-08,
  -1.638392510405987e-10,  -8.489025265872320e-14,   7.236788852666165e-14,  -7.943190150936734e-16,   2.037277934350076e-17,  -1.091693983961947e-18,  -1.415981527275792e-20,
   3.618526590282104e-22,   1.011689529417091e-23,   1.537476802274169e-01,  -4.356030277313933e-03,   8.715870802757270e-05,  -1.425636098723808e-06,   1.829959341410992e-08,
  -1.638111429059396e-10,  -8.530324509370420e-14,   7.238140490399589e-14,  -7.952255589776952e-16,   2.035843045804194e-17,  -1.091252678656728e-18,  -1.414526335244335e-20,
   3.618658256452423e-22,   1.010971835638825e-23,   1.537479362067895e-01,  -4.356042824440770e-03,   8.715902994783826e-05,  -1.425640894123944e-06,   1.829958954777603e-08,
  -1.638066823718851e-10,  -8.536879565690701e-14,   7.238354947530344e-14,  -7.953694037618985e-16,   2.035615394008192e-17,  -1.091182649055686e-18,  -1.414295447871984e-20,
   3.618679323080392e-22,   1.010857995733465e-23,   4.269486074982875e-01,  -1.114508567638841e-02,   1.767620969238256e-04,  -1.480276564847165e-06,  -1.449630562215960e-08,
   7.510028289427292e-10,  -1.289187293731499e-11,   1.147602526665100e-13,   5.993322354240309e-15,  -1.314114477429835e-16,  -1.032071333119166e-18,  -4.365133577718431e-20,
   2.192837727752416e-23,   6.674105797971159e-23,   4.269651623378521e-01,  -1.114549951656168e-02,   1.767538415790963e-04,  -1.479570668717378e-06,  -1.451424993625283e-08,
   7.512216118828698e-10,  -1.287623044618131e-11,   1.143114278833987e-13,   5.988967312259121e-15,  -1.316180283640592e-16,  -1.032080455802358e-18,  -4.317426837209244e-20,
   1.871197667701781e-23,   6.654070565263745e-23,   4.269943729718980e-01,  -1.114622958234462e-02,   1.767392667305427e-04,  -1.478324939326578e-06,  -1.454589511279550e-08,
   7.516069368557451e-10,  -1.284863831930142e-11,   1.135189162089725e-13,   5.981282616289198e-15,  -1.319805544131486e-16,  -1.032112041582969e-18,  -4.233365306338997e-20,
   1.309928033632230e-23,   6.618818928420064e-23,   4.270296936896540e-01,  -1.114711210993023e-02,   1.767216287550811e-04,  -1.476818309817939e-06,  -1.458413037339342e-08,
   7.520716460263837e-10,  -1.281528947344003e-11,   1.125596629530359e-13,   5.971989898626139e-15,  -1.324155372347523e-16,  -1.032176430654705e-18,  -4.131917602569049e-20,
   6.418953004386017e-24,   6.576362613934859e-23,   4.270639812859049e-01,  -1.114796856362911e-02,   1.767044915515109e-04,  -1.475355407009875e-06,  -1.462121665106563e-08,
   7.525214889448103e-10,  -1.278293158830059e-11,   1.116274572302631e-13,   5.962968328884321e-15,  -1.328342679002728e-16,  -1.032266096962711e-18,  -4.033643277083319e-20,
   4.506926102388590e-26,   6.535323089338960e-23,   4.270916021066917e-01,  -1.114865830464124e-02,   1.766906756143425e-04,  -1.474176701966265e-06,  -1.465107005916081e-08,
   7.528829526685164e-10,  -1.275687638898685e-11,   1.108757861262887e-13,   5.955700380045468e-15,  -1.331690562533911e-16,  -1.032357598042737e-18,  -3.954624403311855e-20,
  -5.010193314099723e-24,   6.502387081908929e-23,   4.271098530509578e-01,  -1.114911397187757e-02,   1.766815411849709e-04,  -1.473397732199499e-06,  -1.467078549127144e-08,
   7.531213488868837e-10,  -1.273966540030294e-11,   1.103787546958329e-13,   5.950897694536505e-15,  -1.333890381380219e-16,  -1.032427416689999e-18,  -3.902483267754061e-20,
  -8.311824083970859e-24,   6.480684129401596e-23,   4.271192256597404e-01,  -1.114934794746490e-02,   1.766768486403282e-04,  -1.472997662290835e-06,  -1.468090685572219e-08,
   7.532436367445501e-10,  -1.273082853490716e-11,   1.101234002416724e-13,   5.948431235307683e-15,  -1.335016260474009e-16,  -1.032466148998417e-18,  -3.875728885476447e-20,
  -9.995394014922916e-24,   6.469557234735600e-23,   4.271224878622556e-01,  -1.114942937982099e-02,   1.766752151059959e-04,  -1.472858409257512e-06,  -1.468442913959011e-08,
   7.532861778598894e-10,  -1.272775306967494e-11,   1.100345050896846e-13,   5.947572753321863e-15,  -1.335407522991797e-16,  -1.032480086707525e-18,  -3.866420370729273e-20,
  -1.057947147002824e-23,   6.465687368909750e-23,   4.271230055279268e-01,  -1.114944230177751e-02,   1.766749558746705e-04,  -1.472836311479837e-06,  -1.468498805143434e-08,
   7.532929274905852e-10,  -1.272726504930899e-11,   1.100203978612636e-13,   5.947436523656817e-15,  -1.335469582010226e-16,  -1.032482320075542e-18,  -3.864943408156405e-20,
  -1.067206614741057e-23,   6.465073414408158e-23,   8.324334393586598e-01,  -1.835671594431496e-02,   1.429961435592506e-04,   2.691908493129498e-06,  -8.810484865948483e-08,
   7.359598013012817e-11,   4.084583126258578e-11,  -5.578746377201674e-13,  -4.511271498775462e-15,   5.769920197677752e-16,  -1.110404435745020e-17,  -4.426779026072952e-19,
   1.073175765940204e-20,   1.838933224829042e-22,   8.324467463909941e-01,  -1.835595863699001e-02,   1.429469079595188e-04,   2.691968535947104e-06,  -8.804756165586226e-08,
   7.252759074916741e-11,   4.083306995355153e-11,  -5.559852235798032e-13,  -4.556079341090339e-15,   5.747617848627596e-16,  -1.104027642090486e-17,  -4.413332400021821e-19,
   1.067440044712421e-20,   1.838956895209502e-22,   8.324702231450916e-01,  -1.835462234409787e-02,   1.428600571296696e-04,   2.692073677300136e-06,  -8.794649278419006e-08,
   7.064539659921339e-11,   4.081045802557271e-11,  -5.526574035951694e-13,  -4.634927071161948e-15,   5.708321369047327e-16,  -1.092804165575943e-17,  -4.389605787187241e-19,
   1.057353421019713e-20,   1.838975617090734e-22,   8.324986051560104e-01,  -1.835300646377028e-02,   1.427550807791418e-04,   2.692199444059947e-06,  -8.782430478439074e-08,
   6.837452864162944e-11,   4.078295479914947e-11,  -5.486437261154025e-13,  -4.729902250827833e-15,   5.660899754104210e-16,  -1.079281055122016e-17,  -4.360915698291551e-19,
   1.045214689491027e-20,   1.838958890831157e-22,   8.325261512929198e-01,  -1.835143777361556e-02,   1.426532182546256e-04,   2.692320102228532e-06,  -8.770571364824878e-08,
   6.617534292950007e-11,   4.075608732092694e-11,  -5.447581507765996e-13,  -4.821717636476745e-15,   5.614964313170613e-16,  -1.066203627446678e-17,  -4.333064380215857e-19,
   1.033491353793525e-20,   1.838901339491411e-22,   8.325483373548813e-01,  -1.835017404193017e-02,   1.425711925851495e-04,   2.692416276796466e-06,  -8.761019748108508e-08,
   6.440752306111769e-11,   4.073432326757232e-11,  -5.416357342934985e-13,  -4.895407750358171e-15,   5.578031427842253e-16,  -1.055704752776226e-17,  -4.310628180857724e-19,
   1.024090611549334e-20,   1.838825311507290e-22,   8.325629951852868e-01,  -1.834933898309988e-02,   1.425170078629732e-04,   2.692479325400522e-06,  -8.754709158042776e-08,
   6.324124497201105e-11,   4.071988334563847e-11,  -5.395762890788763e-13,  -4.943966375497582e-15,   5.553662140906755e-16,  -1.048784931792748e-17,  -4.295802999792584e-19,
   1.017899993219694e-20,   1.838760522732492e-22,   8.325705219639048e-01,  -1.834891013814145e-02,   1.424891864804656e-04,   2.692511548797096e-06,  -8.751468661865874e-08,
   6.264288186895547e-11,   4.071244964921193e-11,  -5.385198373033995e-13,  -4.968862011864271e-15,   5.541158264556538e-16,  -1.045236721524943e-17,  -4.288189647640584e-19,
   1.014727370492260e-20,   1.838722745104668e-22,   8.325731416137307e-01,  -1.834876087436223e-02,   1.424795037998205e-04,   2.692522739767302e-06,  -8.750340824314947e-08,
   6.243470784533888e-11,   4.070985940281095e-11,  -5.381523160806590e-13,  -4.977520557226138e-15,   5.536807914118425e-16,  -1.044002601119715e-17,  -4.285539765316557e-19,
   1.013624153114149e-20,   1.838708878484732e-22,   8.325735573106490e-01,  -1.834873718823889e-02,   1.424779673300320e-04,   2.692524514448815e-06,  -8.750161854252119e-08,
   6.240167784880694e-11,   4.070944822968753e-11,  -5.380940043761279e-13,  -4.978894235474829e-15,   5.536117655937314e-16,  -1.043806804335556e-17,  -4.285119266193506e-19,
   1.013449137211095e-20,   1.838706643958295e-22,   1.342154466394668e+00,  -2.017254024341113e-02,  -1.554172608562388e-04,   5.762900417068043e-06,   9.932945138783141e-08,
  -3.258432811148342e-09,  -8.111254101908094e-11,   2.394421435890974e-12,   8.768616230429468e-14,  -1.330191551327672e-15,  -8.397672983083937e-17,   3.844981223375886e-19,
   6.700890244512958e-20,   1.787175555184537e-23,   1.342140006941862e+00,  -2.017093004497473e-02,  -1.553620157477490e-04,   5.759884614285687e-06,   9.921801527722640e-08,
  -3.253789274588305e-09,  -8.088938414321391e-11,   2.389983736158133e-12,   8.734447199843114e-14,  -1.328208689922415e-15,  -8.358220067617945e-17,   3.845218741462758e-19,
   6.657035249215425e-20,   1.586126134983081e-23,   1.342114497146027e+00,  -2.016808950729295e-02,  -1.552645852293133e-04,   5.754566700340270e-06,   9.902163689022315e-08,
  -3.245602758669707e-09,  -8.049634195033756e-11,   2.382158785640496e-12,   8.674288974201476e-14,  -1.324709906285690e-15,  -8.288821573165154e-17,   3.845525065761457e-19,
   6.579998645174021e-20,   1.236411574902502e-23,   1.342083657478241e+00,  -2.016465586244781e-02,  -1.551468569691938e-04,   5.748142215940317e-06,   9.878460382095857e-08,
  -3.235715597730785e-09,  -8.002229962782894e-11,   2.372706048189810e-12,   8.601772242950524e-14,  -1.320479182153154e-15,  -8.205272646475737e-17,   3.845705182300205e-19,
   6.487433372751144e-20,   8.220640371538999e-24,   1.342053726241956e+00,  -2.016132375735689e-02,  -1.550326581237576e-04,   5.741911709815785e-06,   9.855494556233792e-08,
  -3.226129936195629e-09,  -7.956339155184361e-11,   2.363539208163547e-12,   8.531611575490806e-14,  -1.316372152485849e-15,  -8.124549155382225e-17,   3.845683307091929e-19,
   6.398185867653632e-20,   4.286761077838785e-24,   1.342029619312267e+00,  -2.015864032895059e-02,  -1.549407252270354e-04,   5.736896985751188e-06,   9.837025730525392e-08,
  -3.218416891002417e-09,  -7.919461942454081e-11,   2.356161480824980e-12,   8.475260642161449e-14,  -1.313063670754804e-15,  -8.059793698173564e-17,   3.845526511869152e-19,
   6.326726730750634e-20,   1.180551995212013e-24,   1.342013692469349e+00,  -2.015686759407979e-02,  -1.548800090163509e-04,   5.733585542826731e-06,   9.824837578267158e-08,
  -3.213324671750691e-09,  -7.895139027334647e-11,   2.351289817641322e-12,   8.438107802450270e-14,  -1.310877539127607e-15,  -8.017138343563004e-17,   3.845355477314888e-19,
   6.279721247064943e-20,  -8.414171692693786e-25,   1.342005514073227e+00,  -2.015595734185624e-02,  -1.548488380447436e-04,   5.731885637721091e-06,   9.818583235758540e-08,
  -3.210710941091620e-09,  -7.882661914416283e-11,   2.348789039313290e-12,   8.419053626039075e-14,  -1.309754875034513e-15,  -7.995274096778227e-17,   3.845246942307159e-19,
   6.255647527532949e-20,  -1.870392542562887e-24,   1.342002667634872e+00,  -2.015564054123765e-02,  -1.548379902475719e-04,   5.731294078299240e-06,   9.816407127407470e-08,
  -3.209801425879495e-09,  -7.878321347453346e-11,   2.347918788282219e-12,   8.412425715095723e-14,  -1.309364124764903e-15,  -7.987670615432319e-17,   3.845205883621081e-19,
   6.247278917178858e-20,  -2.227044204371330e-24,   1.342002215950350e+00,  -2.015559027033957e-02,  -1.548362689248922e-04,   5.731200211098264e-06,   9.816061845663260e-08,
  -3.209657108674518e-09,  -7.877632663976309e-11,   2.347780699393322e-12,   8.411374150040346e-14,  -1.309302118237063e-15,  -7.986464359395546e-17,   3.845199212633904e-19,
   6.245951430636458e-20,  -2.283569136658582e-24,   1.834530211583983e+00,  -8.684632395310464e-03,  -2.932593299449352e-04,  -6.723197373046072e-06,  -6.483055287715279e-08,
   2.627309563298828e-09,   1.595348256627392e-10,   4.099631797143885e-12,   2.073961320595197e-14,  -2.902782904371681e-15,  -1.346433412086553e-16,  -2.722223386182390e-18,
   1.369675587760311e-20,   3.024449470701763e-21,   1.834502647949078e+00,  -8.686514366910227e-03,  -2.932945277077931e-04,  -6.720667938875658e-06,  -6.460571927647958e-08,
   2.635218720779382e-09,   1.595776374614153e-10,   4.089495846236138e-12,   2.017585421972740e-14,  -2.915926771385362e-15,  -1.345170767398308e-16,  -2.699391862247474e-18,
   1.459783195162266e-20,   3.037849299620849e-21,   1.834454008949780e+00,  -8.689834545605166e-03,  -2.933565317870510e-04,  -6.716198734345584e-06,  -6.420895246970899e-08,
   2.649158164757116e-09,   1.596519791147288e-10,   4.071575394738527e-12,   1.918156202075789e-14,  -2.939022908853048e-15,  -1.342897869501565e-16,  -2.659029672194925e-18,
   1.618432709798805e-20,   3.061192915330845e-21,   1.834395189840452e+00,  -8.693848334579306e-03,  -2.934313322709810e-04,  -6.710784339884537e-06,  -6.372910307172301e-08,
   2.665985906791620e-09,   1.597398277107554e-10,   4.049845604040605e-12,   1.798006413817793e-14,  -2.966786385759209e-15,  -1.340072950361463e-16,  -2.610095590537492e-18,
   1.809677420331947e-20,   3.088907455084430e-21,   1.834338084758987e+00,  -8.697743796182614e-03,  -2.935037634771535e-04,  -6.705517485298853e-06,  -6.326319651629701e-08,
   2.682292635696005e-09,   1.598229678556371e-10,   4.028687902289234e-12,   1.681453330855382e-14,  -2.993566034010758e-15,  -1.337250607596444e-16,  -2.562459080206726e-18,
   1.994704400600613e-20,   3.115274906572651e-21,   1.834292078422643e+00,  -8.700881172478631e-03,  -2.935619814059240e-04,  -6.701266949853849e-06,  -6.288781387988829e-08,
   2.695408059744708e-09,   1.598884105806873e-10,   4.011598703107287e-12,   1.587622424203800e-14,  -3.015015477440993e-15,  -1.334919785118376e-16,  -2.523990145026880e-18,
   2.143304088964930e-20,   3.136130952632020e-21,   1.834261676677899e+00,  -8.702953923906315e-03,  -2.936003862836874e-04,  -6.698454541064553e-06,  -6.263974143819999e-08,
   2.704064170684755e-09,   1.599309032022077e-10,   4.000284581164726e-12,   1.525651732295354e-14,  -3.029128151534298e-15,  -1.333351667573110e-16,  -2.498525183444503e-18,
   2.241271334488319e-20,   3.149723550785285e-21,   1.834246063439938e+00,  -8.704018266154686e-03,  -2.936200890802427e-04,  -6.697009081504228e-06,  -6.251233631390734e-08,
   2.708506300982790e-09,   1.599524930734099e-10,   3.994467484636889e-12,   1.493836515561369e-14,  -3.036356885937752e-15,  -1.332537729576236e-16,  -2.485433769749931e-18,
   2.291512328198971e-20,   3.156645623572641e-21,   1.834240629031931e+00,  -8.704388701940563e-03,  -2.936269436435417e-04,  -6.696505792555328e-06,  -6.246799051764016e-08,
   2.710051915909150e-09,   1.599599706766614e-10,   3.992441717004183e-12,   1.482764489271430e-14,  -3.038869918913774e-15,  -1.332253057225469e-16,  -2.480874972920943e-18,
   2.308988010177151e-20,   3.159045619193186e-21,   1.834239766662544e+00,  -8.704447484130086e-03,  -2.936280312175828e-04,  -6.696425918819853e-06,  -6.246095339006699e-08,
   2.710297159532558e-09,   1.599611555153228e-10,   3.992120204623428e-12,   1.481007584974029e-14,  -3.039268560462680e-15,  -1.332207818443767e-16,  -2.480151449884846e-18,
   2.311760629973487e-20,   3.159426024140281e-21,   1.521761692351676e-02,  -4.219652887686166e-04,   8.685424627153400e-06,  -1.597682802877150e-07,   2.676116385781911e-09,
  -4.229256487518993e-11,   7.759157133851336e-13,  -6.719046560029305e-15,   1.212819569247655e-16,  -6.570216862657944e-18,  -7.654941027062577e-20,   9.630177663173106e-22,
   9.394147133842611e-23,   1.091715828568311e-24,   1.521843421486779e-02,  -4.220103635956628e-04,   8.686936121496139e-06,  -1.598080439995105e-07,   2.677211196866628e-09,
  -4.230614316272211e-11,   7.762278525911940e-13,  -6.741082189426989e-15,   1.209777643417523e-16,  -6.564939429035001e-18,  -7.596650753090441e-20,   9.710309391025207e-22,
   9.398051218988401e-23,   1.092540011323852e-24,   1.521987645427923e-02,  -4.220899079506081e-04,   8.689603678619721e-06,  -1.598782181526356e-07,   2.679143362716912e-09,
  -4.233013746631044e-11,   7.767779893286847e-13,  -6.779949694654356e-15,   1.204430123391159e-16,  -6.555593705213368e-18,  -7.493779745642854e-20,   9.851726066006522e-22,
   9.404693368984384e-23,   1.093800706774213e-24,   1.522162062334200e-02,  -4.221861093754904e-04,   8.692830172536894e-06,  -1.599630913386703e-07,   2.681480362213551e-09,
  -4.235921163997202e-11,   7.774421359692658e-13,  -6.826923553168462e-15,   1.197997960433720e-16,  -6.544235447161478e-18,  -7.369359063853103e-20,   1.002276000367052e-21,
   9.412302993775092e-23,   1.094996163961215e-24,   1.522331403959937e-02,  -4.222795163300328e-04,   8.695963292827362e-06,  -1.600455034745837e-07,   2.683749712650225e-09,
  -4.238749916069760e-11,   7.780857460031338e-13,  -6.872498550641819e-15,   1.191789457731572e-16,  -6.533149031532510e-18,  -7.248545438874818e-20,   1.018881972444883e-21,
   9.419246283999424e-23,   1.095813579663107e-24,   1.522467838214121e-02,  -4.223547754214964e-04,   8.698487935759256e-06,  -1.601119070460582e-07,   2.685578324077796e-09,
  -4.241033221240124e-11,   7.786034214144847e-13,  -6.909194195532138e-15,   1.186813571986954e-16,  -6.524174958102099e-18,  -7.151200139339196e-20,   1.032260472824308e-21,
   9.424520225393398e-23,   1.096227230290630e-24,   1.522557998807152e-02,  -4.224045109998689e-04,   8.700156489199926e-06,  -1.601557919237951e-07,   2.686786859179116e-09,
  -4.242544190996263e-11,   7.789450973224114e-13,  -6.933432707724736e-15,   1.183538132579117e-16,  -6.518223995926764e-18,  -7.086866908271461e-20,   1.041100929305915e-21,
   9.427848182490239e-23,   1.096381079875843e-24,   1.522604302833711e-02,  -4.224300543655649e-04,   8.701013468458237e-06,  -1.601783309448714e-07,   2.687407568164418e-09,
  -4.243320827241018e-11,   7.791204423862965e-13,  -6.945877457482836e-15,   1.181859915229290e-16,  -6.515161380965278e-18,  -7.053825940571587e-20,   1.045640923139223e-21,
   9.429508588859341e-23,   1.096423223345680e-24,   1.522620419732099e-02,  -4.224389452491459e-04,   8.701311763416844e-06,  -1.601861761819099e-07,   2.687623622494582e-09,
  -4.243591250999471e-11,   7.791814534608812e-13,  -6.950208506707740e-15,   1.181276413638804e-16,  -6.514094373211331e-18,  -7.042325293336607e-20,   1.047221103686627e-21,
   9.430078751804680e-23,   1.096432030342083e-24,   1.522622977278899e-02,  -4.224403561232741e-04,   8.701359099453478e-06,  -1.601874211283819e-07,   2.687657907857839e-09,
  -4.243634168671531e-11,   7.791911341585031e-13,  -6.950895762730044e-15,   1.181183849279477e-16,  -6.513925004566776e-18,  -7.040500278440035e-20,   1.047471856190284e-21,
   9.430168860371405e-23,   1.096433149784647e-24,   1.375457388886079e-01,  -3.719036119772898e-03,   7.161157842797813e-05,  -1.157102163702598e-06,   1.512980040760037e-08,
  -1.450844697897106e-10,   1.655731075529378e-12,   5.042445779580135e-14,  -8.865885735639580e-16,  -2.961639756389463e-17,  -1.206303191518399e-18,   1.470605650311265e-20,
   8.625471757969005e-22,   9.787231066671180e-24,   1.375524695715857e-01,  -3.719362030145067e-03,   7.162010188792553e-05,  -1.157237360049193e-06,   1.513209990149757e-08,
  -1.449867493154816e-10,   1.653302764356308e-12,   5.032656354826851e-14,  -8.915053691435207e-16,  -2.953776565611872e-17,  -1.200947582922928e-18,   1.477807222269318e-20,
   8.629808927972324e-22,   9.798062265448570e-24,   1.375643466189546e-01,  -3.719937134904159e-03,   7.163514271204804e-05,  -1.157475842128223e-06,   1.513615457892801e-08,
  -1.448144756676119e-10,   1.649007582476334e-12,   5.015404542600569e-14,  -9.001627480852408e-16,  -2.939871619477942e-17,  -1.191495588029063e-18,   1.490518408819296e-20,
   8.637243528917981e-22,   9.815284681249231e-24,   1.375787095822284e-01,  -3.720632610195139e-03,   7.165333201812388e-05,  -1.157764091108438e-06,   1.514105272908922e-08,
  -1.446064257152863e-10,   1.643796116087380e-12,   4.994580663453918e-14,  -9.105999923928818e-16,  -2.923006071286001e-17,  -1.180062904372453e-18,   1.505894798796201e-20,
   8.645859536133468e-22,   9.832898861335592e-24,   1.375926540615297e-01,  -3.721307820502118e-03,   7.167099174534132e-05,  -1.158043786283380e-06,   1.514580272214740e-08,
  -1.444047318130382e-10,   1.638718427838150e-12,   4.974404226399266e-14,  -9.206994529727679e-16,  -2.906579310190196e-17,  -1.168960967625674e-18,   1.520827127597637e-20,
   8.653830150196635e-22,   9.846648623482765e-24,   1.376038883861785e-01,  -3.721851800493961e-03,   7.168521952648700e-05,  -1.158269010613113e-06,   1.514962563186864e-08,
  -1.442424483604537e-10,   1.634614686614984e-12,   4.958178363039096e-14,  -9.288119169057691e-16,  -2.893307444742686e-17,  -1.160015106805665e-18,   1.532859458384988e-20,
   8.659967713359662e-22,   9.855334425403141e-24,   1.376113122358816e-01,  -3.722211272044317e-03,   7.169462164391787e-05,  -1.158417788614231e-06,   1.515214996571659e-08,
  -1.441353114649014e-10,   1.631896543637906e-12,   4.947470337617284e-14,  -9.341609661204933e-16,  -2.884518692033149e-17,  -1.154102750503288e-18,   1.540811422615425e-20,
   8.663883954151165e-22,   9.859906992606425e-24,   1.376151248641376e-01,  -3.722395883841703e-03,   7.169945028300364e-05,  -1.158494178947683e-06,   1.515344578182138e-08,
  -1.440803215589530e-10,   1.630498650227154e-12,   4.941975506597760e-14,  -9.369043951142794e-16,  -2.879999389212134e-17,  -1.151066141263173e-18,   1.544895453902944e-20,
   8.665851916516939e-22,   9.861895166315399e-24,   1.376164519044111e-01,  -3.722460140616563e-03,   7.170113096719493e-05,  -1.158520765028547e-06,   1.515389671484967e-08,
  -1.440611865955646e-10,   1.630011782894775e-12,   4.940063657719892e-14,  -9.378587033234346e-16,  -2.878425471891994e-17,  -1.150009169384168e-18,   1.546316983695577e-20,
   8.666529993478153e-22,   9.862529918160208e-24,   1.376166624883801e-01,  -3.722470337326785e-03,   7.170139767015489e-05,  -1.158524983765475e-06,   1.515396826754953e-08,
  -1.440581503671502e-10,   1.629934508674476e-12,   4.939760305798700e-14,  -9.380101119575572e-16,  -2.878175668616317e-17,  -1.149841440035326e-18,   1.546542562941821e-20,
   8.666637267632929e-22,   9.862627928128299e-24,   3.850797664291502e-01,  -9.804946064373416e-03,   1.580521340074496e-04,  -1.607445058203045e-06,  -2.217886105385426e-09,
   4.970872932259421e-10,  -7.781209802939160e-12,   2.196181748402189e-13,   1.429568025771313e-16,  -1.996398058059179e-16,  -1.855015592676731e-18,   2.703650680479788e-20,
   2.657075266534372e-21,   3.845250970525753e-23,   3.850945811578060e-01,  -9.805396502719112e-03,   1.580508246982734e-04,  -1.606975504548069e-06,  -2.228825965528760e-09,
   4.975090204497195e-10,  -7.780983706506370e-12,   2.189483623474736e-13,   1.356568380183168e-16,  -1.994891995436112e-16,  -1.838648517451283e-18,   2.732350974911938e-20,
   2.655572357122270e-21,   3.856736658168139e-23,   3.851207218728126e-01,  -9.806191200300570e-03,   1.580485093991321e-04,  -1.606146651564996e-06,  -2.248129320676807e-09,
   4.982520946568253e-10,  -7.780600016106638e-12,   2.177668891507574e-13,   1.228320049634168e-16,  -1.992222437738840e-16,  -1.809776751839099e-18,   2.783052658509988e-20,
   2.652863289152265e-21,   3.876354798073826e-23,   3.851523313223953e-01,  -9.807151972967790e-03,   1.580457011850291e-04,  -1.605143851729610e-06,  -2.271470814384746e-09,
   4.991488037634790e-10,  -7.780161991802148e-12,   2.163389600805449e-13,   1.074196623697376e-16,  -1.988973755818689e-16,  -1.774878879748302e-18,   2.844460617800185e-20,
   2.649489415131451e-21,   3.898974561417360e-23,   3.851830170376531e-01,  -9.808084481551063e-03,   1.580429660872759e-04,  -1.604169784191896e-06,  -2.294130002236240e-09,
   5.000174037953158e-10,  -7.779763823172007e-12,   2.149535091290064e-13,   9.255769408184164e-17,  -1.985798374501908e-16,  -1.741015730685892e-18,   2.904174679473579e-20,
   2.646110720768152e-21,   3.919782679426186e-23,   3.852077369135640e-01,  -9.808835560089447e-03,   1.580407563282978e-04,  -1.603384682430165e-06,  -2.312383723219107e-09,
   5.007157688539204e-10,  -7.779462376870445e-12,   2.138379529236710e-13,   8.065676489569172e-17,  -1.983224826471636e-16,  -1.713747019913042e-18,   2.952349055566271e-20,
   2.643314296544293e-21,   3.935723733383280e-23,   3.852240712999058e-01,  -9.809331791699393e-03,   1.580392930254316e-04,  -1.602865702771682e-06,  -2.324445350403642e-09,
   5.011765664887335e-10,  -7.779272613044221e-12,   2.131010809624144e-13,   7.282793137054027e-17,  -1.981516676181796e-16,  -1.695733802078064e-18,   2.984214912200145e-20,
   2.641429743271122e-21,   3.945856115659186e-23,   3.852324597680335e-01,  -9.809586609431745e-03,   1.580385405803324e-04,  -1.602599120570735e-06,  -2.330639541065836e-09,
   5.014130010931255e-10,  -7.779178069144034e-12,   2.127227449195957e-13,   6.881830056907298e-17,  -1.980637109149115e-16,  -1.686484857285058e-18,   3.000589585904562e-20,
   2.640450534021887e-21,   3.950935753490465e-23,   3.852353794478666e-01,  -9.809675297742525e-03,   1.580382785306493e-04,  -1.602506324436967e-06,  -2.332795480832085e-09,
   5.014952613662824e-10,  -7.779145624811584e-12,   2.125910748194345e-13,   6.742443900853129e-17,  -1.980330593546822e-16,  -1.683265950110112e-18,   3.006290520225047e-20,
   2.640107892404065e-21,   3.952684076561575e-23,   3.852358427606880e-01,  -9.809689371197703e-03,   1.580382369396496e-04,  -1.602491598505408e-06,  -2.333137598544260e-09,
   5.015083133742566e-10,  -7.779140498289644e-12,   2.125701812160461e-13,   6.720333436640444e-17,  -1.980281935973686e-16,  -1.682755166850235e-18,   3.007195254595235e-20,
   2.640053433473416e-21,   3.952960576980012e-23,   7.614658173585513e-01,  -1.710706861032490e-02,   1.670473319106279e-04,   1.341874218966893e-06,  -7.811172172597655e-08,
   8.655047953299534e-10,   2.554406422644121e-11,  -4.836725514605429e-13,   5.114365467203548e-15,  -8.505630281982912e-17,  -1.755704839378089e-17,   1.561313013223625e-19,
   1.192414743103829e-20,  -7.320325167069448e-23,   7.614813902264194e-01,  -1.710668838100488e-02,   1.670035977743666e-04,   1.342677582657265e-06,  -7.807566140146477e-08,
   8.645483717974234e-10,   2.555601563825143e-11,  -4.839391611026137e-13,   5.042658170986266e-15,  -8.426898877310030e-17,  -1.748356012196077e-17,   1.556649273768406e-19,
   1.191812115671581e-20,  -7.192556200650549e-23,   7.615088654881325e-01,  -1.710601727808399e-02,   1.669264447245814e-04,   1.344094400296199e-06,  -7.801201930365223e-08,
   8.628603307142957e-10,   2.557695249130096e-11,  -4.844074505142126e-13,   4.916381305451571e-15,  -8.288164652966464e-17,  -1.735392134271658e-17,   1.548493334123883e-19,
   1.190729692037854e-20,  -6.969080397106810e-23,   7.615420832275425e-01,  -1.710520546253268e-02,   1.668331786070997e-04,   1.345806386006583e-06,  -7.793504040071529e-08,
   8.608184252121281e-10,   2.560201143292381e-11,  -4.849700528752524e-13,   4.764115208498101e-15,  -8.120725224760640e-17,  -1.719721671108576e-17,   1.538755271880687e-19,
   1.189388148018543e-20,  -6.702211053131128e-23,   7.615743245282772e-01,  -1.710441704080198e-02,   1.667426669838246e-04,   1.347467047746287e-06,  -7.786028751850638e-08,
   8.588354400763344e-10,   2.562606838313486e-11,  -4.855123910730844e-13,   4.616747309196804e-15,  -7.958509861323696e-17,  -1.704515002531578e-17,   1.529430759209337e-19,
   1.188051420868079e-20,  -6.446648751958523e-23,   7.616002934702524e-01,  -1.710378166557409e-02,   1.666697731437979e-04,   1.348803920493372e-06,  -7.780005112636283e-08,
   8.572374459250101e-10,   2.564525534314773e-11,  -4.859465531258400e-13,   4.498351561087254e-15,  -7.828067267843506e-17,  -1.692269028470685e-17,   1.522010785921670e-19,
   1.186949817993132e-20,  -6.243279697715419e-23,   7.616174512133870e-01,  -1.710336170693287e-02,   1.666216165481919e-04,   1.349686844432226e-06,  -7.776023998349491e-08,
   8.561812626172167e-10,   2.565783937702635e-11,  -4.862321000484955e-13,   4.420275348508597e-15,  -7.741987936966973e-17,  -1.684179246733588e-17,   1.517152425870240e-19,
   1.186209730744102e-20,  -6.110122826132925e-23,   7.616262618950143e-01,  -1.710314600282673e-02,   1.665968890349143e-04,   1.350140126539377e-06,  -7.773979258926152e-08,
   8.556387825792484e-10,   2.566427272497460e-11,  -4.863783280268038e-13,   4.380228206936112e-15,  -7.697817431608594e-17,  -1.680025423683732e-17,   1.514671165094452e-19,
   1.185825887395834e-20,  -6.042118947441195e-23,   7.616293284314875e-01,  -1.710307091942623e-02,   1.665882829073825e-04,   1.350297872986340e-06,  -7.773267529442854e-08,
   8.554499548139753e-10,   2.566650727156801e-11,  -4.864291581230599e-13,   4.366297189790092e-15,  -7.682449096547784e-17,  -1.678579754176161e-17,   1.513809721451378e-19,
   1.185691685615155e-20,  -6.018509791878839e-23,   7.616298150437527e-01,  -1.710305900445828e-02,   1.665869172576766e-04,   1.350322904104806e-06,  -7.773154585916550e-08,
   8.554199898494106e-10,   2.566686164315680e-11,  -4.864372210317151e-13,   4.364086897479319e-15,  -7.680010619656122e-17,  -1.678350351407568e-17,   1.513673125680354e-19,
   1.185670361063309e-20,  -6.014766201778864e-23,   1.259446519145455e+00,  -2.111774779666512e-02,  -7.914566899269195e-05,   6.752770061055232e-06,   2.149642398978073e-08,
  -4.149134311676831e-09,   1.385105923292780e-11,   3.872349564694239e-12,  -8.643736250710591e-15,  -3.512221444850869e-15,  -9.294652125867704e-18,   2.477765790053780e-18,
   3.704489510916512e-21,  -1.764286429512866e-21,   1.259439123746749e+00,  -2.111586205167843e-02,  -7.913346905897392e-05,   6.748942636479417e-06,   2.151562314060218e-08,
  -4.141693398226885e-09,   1.382758185586860e-11,   3.860815059145918e-12,  -8.682013861232165e-15,  -3.499906444618798e-15,  -9.266416436017456e-18,   2.465778311192250e-18,
   3.820816786417668e-21,  -1.747460382918403e-21,   1.259426075391903e+00,  -2.111253548932080e-02,  -7.911193336979887e-05,   6.742194700850821e-06,   2.154947319469688e-08,
  -4.128582094874049e-09,   1.378607454504920e-11,   3.840495697609323e-12,  -8.749453842047130e-15,  -3.478225760938052e-15,  -9.216021348997435e-18,   2.444723786078995e-18,
   4.024956125787036e-21,  -1.717953835968722e-21,   1.259410298789313e+00,  -2.110851444747856e-02,  -7.908587733453074e-05,   6.734044589981621e-06,   2.159035868641182e-08,
  -4.112758942758110e-09,   1.373574531554708e-11,   3.815982260445472e-12,  -8.830828653351197e-15,  -3.452093078610666e-15,  -9.154110322458817e-18,   2.419430056841961e-18,
   4.269890014457926e-21,  -1.682585512448938e-21,   1.259394984820539e+00,  -2.110461243097112e-02,  -7.906056704695481e-05,   6.726142607716285e-06,   2.163000099068709e-08,
  -4.097430701383485e-09,   1.368674210212370e-11,   3.792244562872664e-12,  -8.909641661508747e-15,  -3.426811359678816e-15,  -9.092994454337040e-18,   2.395047847555489e-18,
   4.505663048937921e-21,  -1.648575035352266e-21,   1.259382649293368e+00,  -2.110147012078256e-02,  -7.904016628215536e-05,   6.719784033095261e-06,   2.166190142035108e-08,
  -4.085105795168817e-09,   1.364716237858731e-11,   3.773164348388858e-12,  -8.972999194621848e-15,  -3.406507137001445e-15,  -9.043037464111426e-18,   2.375528796887773e-18,
   4.694162038504794e-21,  -1.621408057180992e-21,   1.259374498787863e+00,  -2.109939427821024e-02,  -7.902668037562148e-05,   6.715585902324892e-06,   2.168296354754894e-08,
  -4.076973124417135e-09,   1.362095824515273e-11,   3.760577290991479e-12,  -9.014799027307864e-15,  -3.393120922424546e-15,  -9.009674258224870e-18,   2.362690885264941e-18,
   4.818015188996921e-21,  -1.603569481217474e-21,   1.259370313296136e+00,  -2.109832840066410e-02,  -7.901975303422255e-05,   6.713431043616486e-06,   2.169377466183964e-08,
  -4.072800133989527e-09,   1.360748554562291e-11,   3.754119662928440e-12,  -9.036244822629920e-15,  -3.386255857827802e-15,  -8.992431936258749e-18,   2.356116480643063e-18,
   4.881402068947773e-21,  -1.594443336392654e-21,   1.259368856526522e+00,  -2.109795743879432e-02,  -7.901734164171518e-05,   6.712681197550496e-06,   2.169753672564023e-08,
  -4.071348247413361e-09,   1.360279376301891e-11,   3.751873049094668e-12,  -9.043705968359198e-15,  -3.383867903381663e-15,  -8.986413306602197e-18,   2.353831135498413e-18,
   4.903429801348699e-21,  -1.591272432970510e-21,   1.259368625358629e+00,  -2.109789857351586e-02,  -7.901695897421790e-05,   6.712562215482412e-06,   2.169813367329932e-08,
  -4.071117879634881e-09,   1.360204912373199e-11,   3.751516590960854e-12,  -9.044889794497579e-15,  -3.383489038793086e-15,  -8.985457413091034e-18,   2.353468622006517e-18,
   4.906923654017973e-21,  -1.590769516861456e-21,   1.794570878809904e+00,  -1.136551562060003e-02,  -3.776471600094363e-04,  -7.093349189752525e-06,   3.512749846222291e-08,
   7.769729164101709e-09,   2.593225767340574e-10,   1.859609750044187e-12,  -2.021220101176377e-13,  -9.677530150483308e-15,  -1.534168749480987e-16,   4.482067668127812e-18,
   3.362963923114022e-19,   8.146928451583803e-21,   1.794535518222977e+00,  -1.136748486721674e-02,  -3.776253822229571e-04,  -7.086039068904640e-06,   3.548573800626083e-08,
   7.772882812304979e-09,   2.587801979275416e-10,   1.827612233009799e-12,  -2.027034944658111e-13,  -9.652362926215971e-15,  -1.513671576016326e-16,   4.535832003246018e-18,
   3.356611894616080e-19,   8.041731042537934e-21,   1.794473125809254e+00,  -1.137095795806154e-02,  -3.775867926699018e-04,  -7.073137997594522e-06,   3.611723266972281e-08,
   7.778396590021513e-09,   2.578219608033260e-10,   1.771222657239895e-12,  -2.037225310117734e-13,  -9.607735537551112e-15,  -1.477538685604984e-16,   4.630073731568887e-18,
   3.345154500525044e-19,   7.856036173176851e-21,   1.794397683480710e+00,  -1.137515479895089e-02,  -3.775398532218633e-04,  -7.057534077551698e-06,   3.687977677418505e-08,
   7.784977225801359e-09,   2.566612123128698e-10,   1.703156472310025e-12,  -2.049428308903137e-13,  -9.553399282645441e-15,  -1.433906412296610e-16,   4.742963755007318e-18,
   3.330877262042489e-19,   7.631379917169506e-21,   1.794324448782398e+00,  -1.137922602652632e-02,  -3.774939958717857e-04,  -7.042382109305815e-06,   3.761892393564896e-08,
   7.791274919869978e-09,   2.555322566935855e-10,   1.637205901364298e-12,  -2.061149949174230e-13,  -9.500262972691166e-15,  -1.391612868679764e-16,   4.851436709041713e-18,
   3.316576894872128e-19,   7.413184677710341e-21,   1.794265454311225e+00,  -1.138250360983267e-02,  -3.774568466490142e-04,  -7.030173072279610e-06,   3.821356980850236e-08,
   7.796283364299528e-09,   2.546212741524247e-10,   1.584168266353758e-12,  -2.070503395717653e-13,  -9.457180947106347e-15,  -1.357588288679355e-16,   4.938019395848087e-18,
   3.304743030664047e-19,   7.237345927252963e-21,   1.794226473017880e+00,  -1.138466832828978e-02,  -3.774321977560002e-04,  -7.022104192575175e-06,   3.860610846015749e-08,
   7.799561109092858e-09,   2.540185771988006e-10,   1.549166784078711e-12,  -2.076640268260269e-13,  -9.428578577182262e-15,  -1.335128547896592e-16,   4.994839098865206e-18,
   3.296770559870528e-19,   7.121127815813525e-21,   1.794206454631003e+00,  -1.138577968998702e-02,  -3.774195080424203e-04,  -7.017960016497784e-06,   3.880757430949280e-08,
   7.801234576254303e-09,   2.537088366734548e-10,   1.531205746913770e-12,  -2.079778332530185e-13,  -9.413848424809913e-15,  -1.323601603483734e-16,   5.023897311610664e-18,
   3.292629193497520e-19,   7.061436776144818e-21,   1.794199487107477e+00,  -1.138616645789128e-02,  -3.774150862853657e-04,  -7.016517531336889e-06,   3.887767698930203e-08,
   7.801815480348229e-09,   2.536009926100820e-10,   1.524956458890612e-12,  -2.080868413796832e-13,  -9.408714871205091e-15,  -1.319590698047777e-16,   5.033991957049351e-18,
   3.291180264928925e-19,   7.040659649913174e-21,   1.794198381460270e+00,  -1.138622783017604e-02,  -3.774143843767428e-04,  -7.016288625644060e-06,   3.888880040019366e-08,
   7.801907587710241e-09,   2.535838775331008e-10,   1.523964888177829e-12,  -2.081041292590783e-13,  -9.407899934389393e-15,  -1.318954277452904e-16,   5.035592920503571e-18,
   3.290949984713109e-19,   7.037362554841050e-21,   1.365753096705532e-02,  -3.594808725053035e-04,   7.000314552311859e-06,  -1.227644892381934e-07,   2.002519424491339e-09,
  -2.572566760416259e-11,   6.032531449414573e-13,  -7.042415913886983e-15,  -1.464964434663029e-16,  -7.244185883970638e-18,   8.601122909028514e-20,   6.846820572617884e-21,
   1.410013910953531e-22,  -4.414789274649072e-25,   1.365818951614290e-02,  -3.595154853505358e-04,   7.001445728309044e-06,  -1.227887270721614e-07,   2.003363308618589e-09,
  -2.573990466707789e-11,   6.028767045974670e-13,  -7.065952396782393e-15,  -1.461074724085239e-16,  -7.209136343345809e-18,   8.683150852763271e-20,   6.840727408474123e-21,
   1.398836877457019e-22,  -4.939707332876680e-25,   1.365935162316984e-02,  -3.595765658245761e-04,   7.003442091060791e-06,  -1.228315060774611e-07,   2.004851928305825e-09,
  -2.576506341225630e-11,   6.022133154954929e-13,  -7.107386917079715e-15,  -1.454183595278850e-16,  -7.147319327743913e-18,   8.827322083057274e-20,   6.829669176040694e-21,
   1.379058680154677e-22,  -5.862007364957865e-25,   1.366075700342779e-02,  -3.596504344754291e-04,   7.005856770400811e-06,  -1.228832536248160e-07,   2.006651255515882e-09,
  -2.579554900020240e-11,   6.014125844741936e-13,  -7.157326394978985e-15,  -1.445803717771324e-16,  -7.072618914134993e-18,   9.000684509577152e-20,   6.815776031472708e-21,
   1.355048315589539e-22,  -6.970539120500727e-25,   1.366212147729033e-02,  -3.597221548220705e-04,   7.008201586272636e-06,  -1.229335088728412e-07,   2.008397250128032e-09,
  -2.582521010193032e-11,   6.006367681636942e-13,  -7.205635542848517e-15,  -1.437619578175281e-16,  -7.000153868560569e-18,   9.167962628974259e-20,   6.801744863726624e-21,
   1.331642411752483e-22,  -8.039605491272779e-25,   1.366322079079019e-02,  -3.597799389235356e-04,   7.010091031536734e-06,  -1.229740079254445e-07,   2.009803255966719e-09,
  -2.584915205219813e-11,   6.000128729325972e-13,  -7.244430129031695e-15,  -1.430991483305008e-16,  -6.941815598369640e-18,   9.301987880864554e-20,   6.790053270796865e-21,
   1.312718610657811e-22,  -8.895735332153098e-25,   1.366394725197249e-02,  -3.598181251166032e-04,   7.011339784201106e-06,  -1.230007758780183e-07,   2.010732053116939e-09,
  -2.586499561333340e-11,   5.996011503389859e-13,  -7.270004876579349e-15,  -1.426594639748262e-16,  -6.903285936452579e-18,   9.390190409109212e-20,   6.782138162790420e-21,
   1.300181150074356e-22,  -9.458945326972287e-25,   1.366432034137634e-02,  -3.598377366327823e-04,   7.011981152933106e-06,  -1.230145246378563e-07,   2.011208952541898e-09,
  -2.587313919033769e-11,   5.993898772373852e-13,  -7.283120174831759e-15,  -1.424331367207669e-16,  -6.883505124730823e-18,   9.435375475577061e-20,   6.778014894772603e-21,
   1.293732479643382e-22,  -9.747403658395903e-25,   1.366445020123899e-02,  -3.598445627723591e-04,   7.012204399051473e-06,  -1.230193103597140e-07,   2.011374928648037e-09,
  -2.587597477450137e-11,   5.993163681782426e-13,  -7.287682120399341e-15,  -1.423542774345132e-16,  -6.876621195327180e-18,   9.451084844052051e-20,   6.776570454584631e-21,
   1.291486364757199e-22,  -9.847680340899264e-25,   1.366447080833792e-02,  -3.598456459948537e-04,   7.012239825698767e-06,  -1.230200698040105e-07,   2.011401266148128e-09,
  -2.587642479664732e-11,   5.993047045605199e-13,  -7.288405898100560e-15,  -1.423417595653721e-16,  -6.875528856387285e-18,   9.453576863588892e-20,   6.776340800595131e-21,
   1.291129861676831e-22,  -9.863586984495832e-25,   1.237329792294456e-01,  -3.197773495483418e-03,   5.909119066518855e-05,  -9.356729772931740e-07,   1.271803067816382e-08,
  -9.288238135875072e-11,   2.454997784168379e-12,  -2.244255556512565e-15,  -2.540178864352396e-15,  -5.079950448292801e-17,   5.433877234265380e-19,   6.876209405868542e-20,
   1.303704036529487e-21,  -3.538920961170305e-24,   1.237385334172979e-01,  -3.198036959937420e-03,   5.909836354704182e-05,  -9.357601155394394e-07,   1.272140486896425e-08,
  -9.288936034080829e-11,   2.448382884199629e-12,  -2.406528998929383e-15,  -2.537645117660317e-15,  -5.044719219890983e-17,   5.509694820976215e-19,   6.870873315388065e-20,
   1.293322349112816e-21,  -4.042265357294443e-24,   1.237483344182469e-01,  -3.198501867054698e-03,   5.911102173478788e-05,  -9.359138784486062e-07,   1.272735114026473e-08,
  -9.290193008307739e-11,   2.436716341421651e-12,  -2.691898087360488e-15,  -2.533148706308906e-15,  -4.982578322287741e-17,   5.642947627335709e-19,   6.861163365289676e-20,
   1.274946128671335e-21,  -4.926804002932828e-24,   1.237601868296642e-01,  -3.199064071714704e-03,   5.912633074834356e-05,  -9.360998207378630e-07,   1.273452858070219e-08,
  -9.291756366255503e-11,   2.422618537283139e-12,  -3.035324618481887e-15,  -2.527668114402297e-15,  -4.907480620579606e-17,   5.803175272634477e-19,   6.848921620934592e-20,
   1.252628576193215e-21,  -5.990194891776553e-24,   1.237716939261385e-01,  -3.199609885879701e-03,   5.914119519097556e-05,  -9.362803414940902e-07,   1.274148286037378e-08,
  -9.293319372201928e-11,   2.408942632636585e-12,  -3.366995366274014e-15,  -2.522302275200587e-15,  -4.834623937158485e-17,   5.957773404441061e-19,   6.836515481643805e-20,
   1.230863377153266e-21,  -7.015983677736241e-24,   1.237809645961079e-01,  -3.200049612190666e-03,   5.915317173745878e-05,  -9.364257748101020e-07,   1.274707550101390e-08,
  -9.294610889778401e-11,   2.397932699444339e-12,  -3.632951823985048e-15,  -2.517947226407973e-15,  -4.775965868944953e-17,   6.081634668589665e-19,   6.826148554464445e-20,
   1.213259368803678e-21,  -7.837639145673295e-24,   1.237870908337592e-01,  -3.200340187998152e-03,   5.916108657739587e-05,  -9.365218785885005e-07,   1.275076630160002e-08,
  -9.295480117518014e-11,   2.390661069255259e-12,  -3.808087505713491e-15,  -2.515053670195221e-15,  -4.737222772430211e-17,   6.163145890474687e-19,   6.819116337611184e-20,
   1.201593038750625e-21,  -8.378259559815054e-24,   1.237902370563408e-01,  -3.200489416443019e-03,   5.916515152045459e-05,  -9.365712337347043e-07,   1.275266024595802e-08,
  -9.295931390608830e-11,   2.386927836067131e-12,  -3.897841428239379e-15,  -2.513562808638734e-15,  -4.717331694231595e-17,   6.204902339780844e-19,   6.815448809713026e-20,
   1.195591433644727e-21,  -8.655175915397426e-24,   1.237913321448650e-01,  -3.200541357385039e-03,   5.916656640790714e-05,  -9.365884124464268e-07,   1.275331921849713e-08,
  -9.296089237002873e-11,   2.385628624939943e-12,  -3.929051394869076e-15,  -2.513043124268858e-15,  -4.710409280644010e-17,   6.219419570347945e-19,   6.814163364655801e-20,
   1.193500875572711e-21,  -8.751444672757264e-24,   1.237915059211363e-01,  -3.200549599726401e-03,   5.916679093328091e-05,  -9.365911384809530e-07,   1.275342377734379e-08,
  -9.296114321907712e-11,   2.385422466333928e-12,  -3.934002576479046e-15,  -2.512960620678127e-15,  -4.709310829808143e-17,   6.221722472102291e-19,   6.813958958580638e-20,
   1.193169054914105e-21,  -8.766715758339083e-24,   3.482667242855683e-01,  -8.617589861036664e-03,   1.388506267727017e-04,  -1.571533218534344e-06,   6.327407668416687e-09,
   3.775973712357972e-10,  -2.724644853236023e-12,   9.974199885363646e-14,  -7.699373008142768e-15,  -2.055043758981505e-16,   2.825154841856499e-18,   1.992860041687960e-19,
   4.223013827612047e-21,  -6.877604121271846e-24,   3.482797486041571e-01,  -8.618030601196064e-03,   1.388541628478795e-04,  -1.571177669755334e-06,   6.323340680918975e-09,
   3.777831885715379e-10,  -2.744590933378188e-12,   9.907503223229702e-14,  -7.686669348176696e-15,  -2.044826467043363e-16,   2.849803612206721e-18,   1.991493446504389e-19,
   4.191361672535951e-21,  -8.458288695961061e-24,   3.483027304862514e-01,  -8.618808212587948e-03,   1.388604003930278e-04,  -1.570550159931591e-06,   6.316141718488211e-09,
   3.781100117419797e-10,  -2.779758522523301e-12,   9.790095802470348e-14,  -7.664170310267510e-15,  -2.026804500867756e-16,   2.893135175949683e-18,   1.988989531922500e-19,
   4.135295237046089e-21,  -1.123684303060804e-23,   3.483305208788661e-01,  -8.619748369516173e-03,   1.388679396267424e-04,  -1.569791132891161e-06,   6.307397974410053e-09,
   3.785034149647179e-10,  -2.822236395370066e-12,   9.648602593846156e-14,  -7.636822701901237e-15,  -2.005023674264930e-16,   2.945255942313744e-18,   1.985804429299596e-19,
   4.067135657898660e-21,  -1.457853936502835e-23,   3.483574997875455e-01,  -8.620660911923364e-03,   1.388752551483600e-04,  -1.569054036703388e-06,   6.298869219838000e-09,
   3.788834483666426e-10,  -2.863423649029871e-12,   9.511742874843801e-14,  -7.610126396354702e-15,  -1.983891631641131e-16,   2.995563714573280e-18,   1.982548182134837e-19,
   4.000592470308918e-21,  -1.780344663499188e-23,   3.483792339869068e-01,  -8.621395939832858e-03,   1.388811459692308e-04,  -1.568460065918359e-06,   6.291969582666709e-09,
   3.791882572009803e-10,  -2.896567969120803e-12,   9.401848185752268e-14,  -7.588514704179759e-15,  -1.966877058227317e-16,   3.035882466247799e-18,   1.979807738236269e-19,
   3.946721326740188e-21,  -2.038757192476598e-23,   3.483935957257739e-01,  -8.621881582063560e-03,   1.388850373076579e-04,  -1.568067494782837e-06,   6.287396242296433e-09,
   3.793890139067714e-10,  -2.918451673316621e-12,   9.329406831094419e-14,  -7.574182569389793e-15,  -1.955638694221421e-16,   3.062422021566860e-18,   1.977939652848824e-19,
   3.910996145874530e-21,  -2.208831237806338e-23,   3.484009712175382e-01,  -8.622130966775898e-03,   1.388870353210553e-04,  -1.567865864221510e-06,   6.285043228662186e-09,
   3.794919095855933e-10,  -2.929684589879850e-12,   9.292258868936468e-14,  -7.566806431202220e-15,  -1.949868687934586e-16,   3.076019644544912e-18,   1.976962631420985e-19,
   3.892610278090098e-21,  -2.295961192996220e-23,   3.484035383332150e-01,  -8.622217764891667e-03,   1.388877306881540e-04,  -1.567795680643146e-06,   6.284223542847986e-09,
   3.795276911524340e-10,  -2.933593446836970e-12,   9.279337798628313e-14,  -7.564236569923429e-15,  -1.947860614079089e-16,   3.080747368959783e-18,   1.976619760127954e-19,
   3.886204685075274e-21,  -2.326253876825007e-23,   3.484039456995084e-01,  -8.622231538437735e-03,   1.388878410304977e-04,  -1.567784543275818e-06,   6.284093436871054e-09,
   3.795333676653048e-10,  -2.934213687639103e-12,   9.277287811832197e-14,  -7.563828648332974e-15,  -1.947541971353513e-16,   3.081497353745199e-18,   1.976565217836525e-19,
   3.885187910841063e-21,  -2.331059307509800e-23,   6.957842682767623e-01,  -1.572601617479179e-02,   1.763182802456634e-04,   2.595250736113484e-07,  -5.570050384720840e-08,
   1.327377795454878e-09,   1.299089913832915e-11,  -4.815510308154926e-13,  -7.492028246865031e-15,  -4.937273751899863e-16,   7.485308528159273e-19,   6.560395973225435e-19,
   9.246118906863971e-21,  -6.714162647015687e-23,   6.958007353935398e-01,  -1.572593883100071e-02,   1.762870504620256e-04,   2.607612829308416e-07,  -5.568246656849478e-08,
   1.326404822785344e-09,   1.297133917326868e-11,  -4.831300574928505e-13,  -7.487123812140543e-15,  -4.903738109551462e-16,   8.032465220092138e-19,   6.553254148835876e-19,
   9.193382796319807e-21,  -7.122276067355240e-23,   6.958297895123594e-01,  -1.572580207543100e-02,   1.762319532109719e-04,   2.629418445605031e-07,  -5.565066182443823e-08,
   1.324685512748941e-09,   1.293683682615959e-11,  -4.859070953744366e-13,  -7.478284420705025e-15,  -4.844596149123285e-16,   8.995195714018626e-19,   6.540412998641374e-19,
   9.099568991576717e-21,  -7.839943898289007e-23,   6.958649180264086e-01,  -1.572563622972765e-02,   1.761653429898843e-04,   2.655773243237340e-07,  -5.561224123240520e-08,
   1.322602278523872e-09,   1.289513612889324e-11,  -4.892494737138952e-13,  -7.467280199244168e-15,  -4.773136657708084e-16,   1.015464894872947e-18,   6.524478359004615e-19,
   8.984844001366143e-21,  -8.703537427427374e-23,   6.958990159529519e-01,  -1.572547472771154e-02,   1.761006935538952e-04,   2.681344618372589e-07,  -5.557498301380248e-08,
   1.320575498018986e-09,   1.285467500526728e-11,  -4.924778210401790e-13,  -7.456267904953507e-15,  -4.703824111360662e-16,   1.127528165055517e-18,   6.508584411052406e-19,
   8.872140948147388e-21,  -9.537440682251518e-23,   6.959264817710300e-01,  -1.572534426430123e-02,   1.760486232733204e-04,   2.701934968726680e-07,  -5.554499680445345e-08,
   1.318939597288773e-09,   1.282209547480254e-11,  -4.950668083226923e-13,  -7.447160989901862e-15,  -4.648029774591083e-16,   1.217448351820951e-18,   6.495476963128625e-19,
   8.780406384085901e-21,  -1.020599903025971e-22,   6.959446292118381e-01,  -1.572525788043318e-02,   1.760142212805896e-04,   2.715535992142946e-07,  -5.552519641545348e-08,
   1.317857083220304e-09,   1.280057515083470e-11,  -4.967718253415006e-13,  -7.441028209767272e-15,  -4.611183145906930e-16,   1.276690538868903e-18,   6.486667576412543e-19,
   8.719332603197852e-21,  -1.064618072401379e-22,   6.959539483325744e-01,  -1.572521346377233e-02,   1.759965557944474e-04,   2.722519309843507e-07,  -5.551503228598871e-08,
   1.317300684964312e-09,   1.278952582108120e-11,  -4.976456586275998e-13,  -7.437843191615596e-15,  -4.592267270918859e-16,   1.307059778710141e-18,   6.482097777794719e-19,
   8.687827797639552e-21,  -1.087174099216199e-22,   6.959571918649069e-01,  -1.572519799548525e-02,   1.759904074122196e-04,   2.724949685220900e-07,  -5.551149525496218e-08,
   1.317106949827144e-09,   1.278568038241664e-11,  -4.979495218420435e-13,  -7.436728963115316e-15,  -4.585684487864354e-16,   1.317621383963479e-18,   6.480499940181841e-19,
   8.676839974421252e-21,  -1.095017043174510e-22,   6.959577065653528e-01,  -1.572519554046995e-02,   1.759894317605993e-04,   2.725335341291817e-07,  -5.551093400947871e-08,
   1.317076203140089e-09,   1.278507018242058e-11,  -4.979977273407700e-13,  -7.436551882087823e-15,  -4.584639941290874e-16,   1.319296952526613e-18,   6.480246040024884e-19,
   8.675095301779876e-21,  -1.096261235471399e-22,   1.174222709769231e+00,  -2.142694692045448e-02,   1.367442566172639e-06,   6.485735396780113e-06,  -5.002945888024345e-08,
  -2.661087253258420e-09,   1.000843852861633e-10,   1.705750071036989e-12,  -1.170444847633554e-13,  -1.912375680259314e-15,   7.990653089253702e-17,   1.301247151072963e-18,
  -2.998263594363581e-20,   6.388882358303327e-22,   1.174222783042890e+00,  -2.142513149624063e-02,   1.340073586140711e-06,   6.483267933367906e-06,  -4.989225753420875e-08,
  -2.657828479127702e-09,   9.978397299701484e-11,   1.699474729905163e-12,  -1.167130099870387e-13,  -1.905531830202686e-15,   7.973005945484884e-17,   1.304862361395528e-18,
  -2.978041819515996e-20,   6.195392042124207e-22,   1.174222910340674e+00,  -2.142192871109985e-02,   1.291842503011088e-06,   6.478916508620089e-06,  -4.965050437420949e-08,
  -2.652088276733116e-09,   9.925459479848127e-11,   1.688420665305196e-12,  -1.161287150572272e-13,  -1.893441667027967e-15,   7.941963707131826e-17,   1.311128280697129e-18,
  -2.942842420396198e-20,   5.855348148844188e-22,   1.174223060872400e+00,  -2.141805682261050e-02,   1.233626422618033e-06,   6.473658897185461e-06,  -4.935875436832841e-08,
  -2.645164117411015e-09,   9.861566455746418e-11,   1.675086178420628e-12,  -1.154231960296642e-13,  -1.878798423385308e-15,   7.904589879458730e-17,   1.318512684613271e-18,
  -2.901096421378350e-20,   5.446508565801073e-22,   1.174223203451454e+00,  -2.141429905832853e-02,   1.177221562134722e-06,   6.468559267466049e-06,  -4.907613570470821e-08,
  -2.638459991726180e-09,   9.799665717547604e-11,   1.662175047102587e-12,  -1.147393522172443e-13,  -1.864558618866374e-15,   7.868476399822458e-17,   1.325480561891125e-18,
  -2.861420116303245e-20,   5.052075491989891e-22,   1.174223315767241e+00,  -2.141127256704581e-02,   1.131861476598895e-06,   6.464454197438415e-06,  -4.884889634217470e-08,
  -2.633071918839157e-09,   9.749889133121196e-11,   1.651798217049902e-12,  -1.141892154061941e-13,  -1.853070025430971e-15,   7.839503042239194e-17,   1.330950446412990e-18,
  -2.830062134305028e-20,   4.736092719330949e-22,   1.174223388738997e+00,  -2.140927306534785e-02,   1.101926951286495e-06,   6.461743168685655e-06,  -4.869895319143054e-08,
  -2.629517778923919e-09,   9.717041612220330e-11,   1.644953255029460e-12,  -1.138260655888493e-13,  -1.845470265965831e-15,   7.820415738340186e-17,   1.334494867295650e-18,
  -2.809635706420950e-20,   4.528163833133466e-22,   1.174223425828846e+00,  -2.140824633371145e-02,   1.086566072924112e-06,   6.460351397975439e-06,  -4.862201590642930e-08,
  -2.627694474638263e-09,   9.700186426717730e-11,   1.641441709944311e-12,  -1.136396852864135e-13,  -1.841564883210467e-15,   7.810631237610153e-17,   1.336293498375824e-18,
  -2.799236426949668e-20,   4.421650824934882e-22,   1.174223438677094e+00,  -2.140788898757923e-02,   1.081221477515906e-06,   6.459867054585356e-06,  -4.859524763516019e-08,
  -2.627060161869443e-09,   9.694321987712290e-11,   1.640220069022734e-12,  -1.135748321300785e-13,  -1.840205176383696e-15,   7.807228466223759e-17,   1.336916093758750e-18,
  -2.795631264382583e-20,   4.384620759415702e-22,   1.174223440713028e+00,  -2.140783228248676e-02,   1.080373453967602e-06,   6.459790199526793e-06,  -4.859100037544188e-08,
  -2.626959519644677e-09,   9.693391484665312e-11,   1.640026239184810e-12,  -1.135645416917604e-13,  -1.839989390568393e-15,   7.806688626621137e-17,   1.337014728096879e-18,
  -2.795059857778613e-20,   4.378746628659574e-22,   1.742559219999122e+00,  -1.470359282061715e-02,  -4.531646146623663e-04,  -4.949864822840964e-06,   2.517278020438773e-07,
   1.353876440003272e-08,   1.638843854262909e-10,  -1.064485456912755e-11,  -5.612970195745961e-13,  -6.012439265705380e-15,   4.906455266834692e-16,   2.439117178723469e-17,
   2.311391658137680e-19,  -2.249751097323986e-20,   1.742517022573925e+00,  -1.470494092897544e-02,  -4.530218213420472e-04,  -4.937350954994888e-06,   2.519414220183444e-07,
   1.351754049511613e-08,   1.624544781726536e-10,  -1.066206388664783e-11,  -5.591954216017313e-13,  -5.893191823406632e-15,   4.916903848818339e-16,   2.422398981949817e-17,
   2.227051584988566e-19,  -2.255193020298122e-20,   1.742442575574349e+00,  -1.470731685721423e-02,  -4.527697665301994e-04,  -4.915286294236550e-06,   2.523167401906774e-07,
   1.348006454206221e-08,   1.599358875998647e-10,  -1.069210759974158e-11,  -5.554838702595016e-13,  -5.683481115021333e-15,   4.934925233629269e-16,   2.392872725309801e-17,
   2.079042597413130e-19,  -2.264376254967968e-20,   1.742352572262974e+00,  -1.471018503192269e-02,  -4.524648198036832e-04,  -4.888633201185081e-06,   2.527678242731020e-07,
   1.343470417001401e-08,   1.568980638315186e-10,  -1.072788838678330e-11,  -5.509903797534098e-13,  -5.431096515854965e-15,   4.956011554575086e-16,   2.357125349237781e-17,
   1.901450917240825e-19,  -2.274770305295347e-20,   1.742265218294512e+00,  -1.471296435885190e-02,  -4.521686165622676e-04,  -4.862787895136554e-06,   2.532028487536913e-07,
   1.339062342315527e-08,   1.539570480699805e-10,  -1.076205117559925e-11,  -5.466225996113200e-13,  -5.187343206905857e-15,   4.975746743251276e-16,   2.322378560039007e-17,
   1.730496263515570e-19,  -2.284122123150291e-20,   1.742194861183819e+00,  -1.471519973432787e-02,  -4.519298804225705e-04,  -4.841988082081876e-06,   2.535512383941308e-07,
   1.335508012821199e-08,   1.515935763609927e-10,  -1.078916321487986e-11,  -5.431000626407592e-13,  -4.991880127804999e-15,   4.991121012265000e-16,   2.294357068944083e-17,
   1.593815530503524e-19,  -2.291130462317656e-20,   1.742148377368724e+00,  -1.471667506196791e-02,  -4.517720699159812e-04,  -4.828254139329690e-06,   2.537804405102527e-07,
   1.333157800527464e-08,   1.500346641837321e-10,  -1.080687856274563e-11,  -5.407705531111052e-13,  -4.863163187985176e-15,   5.001024437218183e-16,   2.275826912221273e-17,
   1.504007781126628e-19,  -2.295505750704840e-20,   1.742124507842893e+00,  -1.471743216652965e-02,  -4.516910087966153e-04,  -4.821204258975251e-06,   2.538978354432960e-07,
   1.331950369761085e-08,   1.492349630432186e-10,  -1.081591455272771e-11,  -5.395736645072644e-13,  -4.797197489772951e-15,   5.006031484084255e-16,   2.266306570960654e-17,
   1.458044476350936e-19,  -2.297673920981630e-20,   1.742116200176141e+00,  -1.471769559667639e-02,  -4.516627918896625e-04,  -4.818750986144971e-06,   2.539386462865803e-07,
   1.331530035563066e-08,   1.489567590442473e-10,  -1.081904979998907e-11,  -5.391569857411742e-13,  -4.774259276844454e-15,   5.007761701124556e-16,   2.262992268615643e-17,
   1.442071567636316e-19,  -2.298416064560795e-20,   1.742114881879999e+00,  -1.471773739528144e-02,  -4.516583141202880e-04,  -4.818361709395075e-06,   2.539451200541047e-07,
   1.331463330670692e-08,   1.489126185150073e-10,  -1.081954685493655e-11,  -5.390908602657154e-13,  -4.770620331103256e-15,   5.008035668219497e-16,   2.262466303356557e-17,
   1.439538075807425e-19,  -2.298533239321413e-20,   1.232300579663921e-02,  -3.088607397562921e-04,   5.704739596151597e-06,  -9.413294103508896e-08,   1.613193781954460e-09,
  -1.434418758558531e-11,   3.099067794168614e-13,  -1.454485792777291e-14,  -2.575809407045920e-16,   3.733935609392207e-18,   4.762576751200092e-19,   8.001821016966959e-21,
  -2.343935720881000e-22,  -1.614569918814647e-23,   1.232354244142308e-02,  -3.088872628542324e-04,   5.705649429765867e-06,  -9.414662739334061e-08,   1.613622130578848e-09,
  -1.437260516338580e-11,   3.092709368118288e-13,  -1.453131108049684e-14,  -2.556218773548284e-16,   3.770838996224722e-18,   4.747124398099347e-19,   7.889035993253519e-21,
  -2.365136895832752e-22,  -1.605127365675249e-23,   1.232448942923377e-02,  -3.089340664494323e-04,   5.707255039671911e-06,  -9.417079877991458e-08,   1.614377247322766e-09,
  -1.442272628660216e-11,   3.081531327587456e-13,  -1.450730938007324e-14,  -2.521704603824143e-16,   3.835488274059753e-18,   4.719757234273875e-19,   7.690598174038645e-21,
  -2.402055727855513e-22,  -1.588377181468822e-23,   1.232563465577683e-02,  -3.089906672680854e-04,   5.709196891203171e-06,  -9.420006388340520e-08,   1.615289133229103e-09,
  -1.448329542915240e-11,   3.068085406904539e-13,  -1.447811991241001e-14,  -2.480061683847704e-16,   3.912867700425839e-18,   4.686493611657135e-19,   7.451625715397921e-21,
  -2.445864295907939e-22,  -1.567973819051845e-23,   1.232674654626240e-02,  -3.090456200339903e-04,   5.711082353272823e-06,  -9.422851246561856e-08,   1.616173114002020e-09,
  -1.454205512946105e-11,   3.055106259288333e-13,  -1.444961018746095e-14,  -2.439732072954192e-16,   3.987155740836235e-18,   4.654024968771234e-19,   7.220666676527400e-21,
  -2.487523387743908e-22,  -1.548013619900114e-23,   1.232764235990601e-02,  -3.090898933337996e-04,   5.712601504866312e-06,  -9.425145786682124e-08,   1.616884335897134e-09,
  -1.458936258783531e-11,   3.044703318018066e-13,  -1.442651988322287e-14,  -2.407312490950856e-16,   4.046407626013215e-18,   4.627743404902521e-19,   7.035351008896327e-21,
  -2.520463187345330e-22,  -1.531826388680761e-23,   1.232823434124652e-02,  -3.091191503337741e-04,   5.713605454462324e-06,  -9.426663328530116e-08,   1.617353858416880e-09,
  -1.462060847654691e-11,   3.037855107697371e-13,  -1.441120219457934e-14,  -2.385924284149131e-16,   4.085270185594959e-18,   4.610316293570705e-19,   6.913262188833017e-21,
  -2.541926665003625e-22,  -1.521078315743575e-23,   1.232853836548795e-02,  -3.091341758195116e-04,   5.714121068109243e-06,  -9.427443076478138e-08,   1.617594844797825e-09,
  -1.463665038639006e-11,   3.034346217731681e-13,  -1.440331733168710e-14,  -2.374950972011222e-16,   4.105138404815398e-18,   4.601347987265916e-19,   6.850676708211683e-21,
  -2.552855859369853e-22,  -1.515542809065084e-23,   1.232864418605829e-02,  -3.091394056755695e-04,   5.714300538128222e-06,  -9.427714541366033e-08,   1.617678700701491e-09,
  -1.464223322693060e-11,   3.033126188503201e-13,  -1.440056999418845e-14,  -2.371133292205194e-16,   4.112039473238992e-18,   4.598223528282752e-19,   6.828911266012220e-21,
  -2.556645028887958e-22,  -1.513613616340714e-23,   1.232866097842743e-02,  -3.091402355863589e-04,   5.714329017831790e-06,  -9.427757622260631e-08,   1.617692006452922e-09,
  -1.464311911391873e-11,   3.032932647044744e-13,  -1.440013389017222e-14,  -2.370527558877703e-16,   4.113133901626731e-18,   4.597727579484312e-19,   6.825458245420035e-21,
  -2.557245613991573e-22,  -1.513307361230699e-23,   1.118209559326419e-01,  -2.766618195604623e-03,   4.903261540303042e-05,  -7.440498492607153e-07,   1.139092470321500e-08,
  -4.527627854644485e-11,   1.048331572433806e-12,  -1.017054873166132e-13,  -3.107811893605330e-15,   4.547676332982906e-17,   4.393344821522900e-18,   7.914372274871130e-20,
  -2.224276537672492e-21,  -1.539235591197448e-22,   1.118255656095099e-01,  -2.766827614930769e-03,   4.903903054132171e-05,  -7.440939546116314e-07,   1.139230740958661e-08,
  -4.547389947293081e-11,   1.040545044608625e-12,  -1.015426134203507e-13,  -3.089754789416689e-15,   4.584326433198847e-17,   4.378642648184282e-18,   7.806724055273247e-20,
  -2.245242690039565e-21,  -1.530470615853943e-22,   1.118336999468433e-01,  -2.767197149004422e-03,   4.905035076491169e-05,  -7.441719290104016e-07,   1.139473846009677e-08,
  -4.582233946554445e-11,   1.026843837915247e-12,  -1.012542446245836e-13,  -3.057943975446116e-15,   4.648549936972547e-17,   4.352600190883725e-18,   7.617310241097222e-20,
  -2.281763194444855e-21,  -1.514913715981597e-22,   1.118435369099470e-01,  -2.767644011273460e-03,   4.906404033961415e-05,  -7.442664717897131e-07,   1.139766321130132e-08,
  -4.624322352578694e-11,   1.010341326172454e-12,  -1.009038914460283e-13,  -3.019565579488283e-15,   4.725450468167604e-17,   4.320940071664450e-18,   7.389181656929546e-20,
  -2.325117829541029e-21,  -1.495949296236732e-22,   1.118530873384030e-01,  -2.768077836013762e-03,   4.907733102678533e-05,  -7.443585194543382e-07,   1.140048694283778e-08,
  -4.665133446602164e-11,   9.943890841314772e-13,  -1.005620526203198e-13,  -2.982400498990378e-15,   4.799311111936625e-17,   4.290029744098840e-18,   7.168678529215709e-20,
  -2.366365048332817e-21,  -1.477381761009478e-22,   1.118607816662968e-01,  -2.768427332919742e-03,   4.908803860653887e-05,  -7.444328631559209e-07,   1.140275057774851e-08,
  -4.697976133421610e-11,   9.815868981200480e-13,  -1.002854453454145e-13,  -2.952526914530498e-15,   4.858245462688149e-17,   4.265004680387702e-18,   6.991735129383251e-20,
  -2.398993512646094e-21,  -1.462313365131531e-22,   1.118658662480716e-01,  -2.768658280787711e-03,   4.909511436298697e-05,  -7.444820817637109e-07,   1.140424091031771e-08,
  -4.719661213221735e-11,   9.731512748589040e-13,  -1.001020707336783e-13,  -2.932819437661013e-15,   4.896911267508735e-17,   4.248408381177163e-18,   6.875153679749761e-20,
  -2.420261217435082e-21,  -1.452303075912836e-22,   1.118684775190375e-01,  -2.768776885592271e-03,   4.909874821933244e-05,  -7.445073868139126e-07,   1.140500458823681e-08,
  -4.730792341166188e-11,   9.688265434189620e-13,  -1.000077149690692e-13,  -2.922708759651959e-15,   4.916682475824899e-17,   4.239866899208531e-18,   6.815388812341058e-20,
  -2.431092936360140e-21,  -1.447145982099690e-22,   1.118693864109246e-01,  -2.768818167403017e-03,   4.910001303489514e-05,  -7.445161990746941e-07,   1.140527012620888e-08,
  -4.734665803927392e-11,   9.673224529866119e-13,  -9.997484432473278e-14,  -2.919191247763874e-15,   4.923550419844335e-17,   4.236891025851627e-18,   6.794603887631718e-20,
  -2.434848665056349e-21,  -1.445348423611796e-22,   1.118695306402671e-01,  -2.768824718273147e-03,   4.910021374458748e-05,  -7.445175976777731e-07,   1.140531225075100e-08,
  -4.735280429787081e-11,   9.670838301753530e-13,  -9.996962681843319e-14,  -2.918633143162812e-15,   4.924639622266020e-17,   4.236418656749120e-18,   6.791306403626570e-20,
  -2.435443966627087e-21,  -1.445063053436316e-22,   3.159016987085650e-01,  -7.579944112180521e-03,   1.208385848711958e-04,  -1.413059507809052e-06,   1.328315041835027e-08,
   3.123084221061991e-10,  -4.222400109749552e-12,  -2.228452528863636e-13,  -1.048429813871352e-14,   1.297583159811063e-16,   1.441873822589481e-17,   2.445976866866444e-19,
  -6.653453085231220e-21,  -4.886293199243548e-22,   3.159130422307561e-01,  -7.580340516624979e-03,   1.208460212010777e-04,  -1.412770337432304e-06,   1.327690356311849e-08,
   3.118771854997000e-10,  -4.248699286816939e-12,  -2.223784161322260e-13,  -1.042491187933842e-14,   1.308871022261348e-16,   1.437435556513528e-17,   2.411711729130629e-19,
  -6.725077771690283e-21,  -4.860207307018528e-22,   3.159330586169029e-01,  -7.581039913019462e-03,   1.208591397934237e-04,  -1.412260418097514e-06,   1.326585130016114e-08,
   3.111170229288958e-10,  -4.294978744310069e-12,  -2.215516748958530e-13,  -1.032027887136424e-14,   1.328646517016149e-16,   1.429569839868390e-17,   2.351409885504217e-19,
  -6.849914046025622e-21,  -4.813843789730714e-22,   3.159572636043347e-01,  -7.581885519007446e-03,   1.208749979326770e-04,  -1.411644374228790e-06,   1.325243643256514e-08,
   3.101991273529983e-10,  -4.350725996202263e-12,  -2.205468810784036e-13,  -1.019402055759683e-14,   1.352317401571948e-16,   1.420000529592904e-17,   2.278765571537231e-19,
  -6.998239113735534e-21,  -4.757217650388996e-22,   3.159807623916497e-01,  -7.582706301855916e-03,   1.208903874893380e-04,  -1.411046911266127e-06,   1.323936090687644e-08,
   3.093094168217495e-10,  -4.404620278153450e-12,  -2.195661487710347e-13,  -1.007172970779035e-14,   1.375044013635569e-16,   1.410650741618620e-17,   2.208531596202911e-19,
  -7.139489482642593e-21,  -4.701666139901677e-22,   3.159996934287015e-01,  -7.583367430198309e-03,   1.209027813460066e-04,  -1.410566019337577e-06,   1.322878983047683e-08,
   3.085936596178849e-10,  -4.447876390093029e-12,  -2.187723128948791e-13,  -9.973414052631820e-15,   1.393171658729635e-16,   1.403076108168905e-17,   2.152159424414656e-19,
  -7.251322974142886e-21,  -4.656505859366829e-22,   3.160122030730094e-01,  -7.583804251092225e-03,   1.209109691365121e-04,  -1.410248458282211e-06,   1.322178627558158e-08,
   3.081211819869170e-10,  -4.476380795844163e-12,  -2.182459236493251e-13,  -9.908547151144868e-15,   1.405061818908486e-16,   1.398050274027363e-17,   2.115011707847897e-19,
  -7.324266087633298e-21,  -4.626467348501394e-22,   3.160186274828555e-01,  -7.584028566866068e-03,   1.209151733861299e-04,  -1.410085438469974e-06,   1.321818393966604e-08,
   3.078786914170198e-10,  -4.490994924741799e-12,  -2.179750316278493e-13,  -9.875265362446114e-15,   1.411140724850680e-16,   1.395462921544589e-17,   2.095966222621350e-19,
  -7.361431379014084e-21,  -4.610980663617088e-22,   3.160208635748761e-01,  -7.584106640010823e-03,   1.209166366224933e-04,  -1.410028707955832e-06,   1.321692921080730e-08,
   3.077943141441175e-10,  -4.496077647521444e-12,  -2.178806552594013e-13,  -9.863686187030750e-15,   1.413252207117661e-16,   1.394561363092997e-17,   2.089342313542624e-19,
  -7.374320277673707e-21,  -4.605580805029192e-22,   3.160212184127069e-01,  -7.584119029048024e-03,   1.209168688136206e-04,  -1.410019706080377e-06,   1.321673005976998e-08,
   3.077809257628281e-10,  -4.496884022477278e-12,  -2.178656747643912e-13,  -9.861848961995559e-15,   1.413587064466066e-16,   1.394418250463236e-17,   2.088291430143364e-19,
  -7.376363346862642e-21,  -4.604723468264449e-22,   6.357023987628139e-01,  -1.431606102460355e-02,   1.750021438918197e-04,  -4.076305117353303e-07,  -2.733135237232413e-08,
   1.435578710558517e-09,  -6.118762016112702e-12,  -9.367327943372138e-13,  -1.680349652967709e-14,   2.090975119226410e-16,   3.509477683715949e-17,   7.036665107990471e-19,
  -1.745664368058858e-20,  -1.209566038446504e-21,   6.357187742146631e-01,  -1.431617098749401e-02,   1.749867184893856e-04,  -4.063000445840583e-07,  -2.734043880078543e-08,
   1.433747280090632e-09,  -6.159903562329256e-12,  -9.359424135023100e-13,  -1.665924226134280e-14,   2.123958023955446e-16,   3.497788843016293e-17,   6.951354739873222e-19,
  -1.765420004631616e-20,  -1.204030190682571e-21,   6.357476677755199e-01,  -1.431636471719724e-02,   1.749594958565034e-04,  -4.039538062246077e-07,  -2.735651782070724e-08,
   1.430516998369705e-09,  -6.232192939795054e-12,  -9.345389654178541e-13,  -1.640511185926411e-14,   2.181802542909362e-16,   3.477068867315065e-17,   6.801166568940189e-19,
  -1.799866589133161e-20,  -1.194155452698704e-21,   6.357826041631520e-01,  -1.431659846327856e-02,   1.749265706674120e-04,  -4.011190822644762e-07,  -2.737603872468787e-08,
   1.426613143748764e-09,  -6.319085681296818e-12,  -9.328269476661237e-13,  -1.609851339155032e-14,   2.251145589535953e-16,   3.451853762966771e-17,   6.620146994983582e-19,
  -1.840818438389893e-20,  -1.182035087052248e-21,   6.358165176932576e-01,  -1.431682484200578e-02,   1.748945998114853e-04,  -3.983696649054844e-07,  -2.739507063863462e-08,
   1.422825703376042e-09,  -6.402895522677592e-12,  -9.311493758312399e-13,  -1.580160735073833e-14,   2.317832284104703e-16,   3.427209317507264e-17,   6.445039007537013e-19,
  -1.879842050034697e-20,  -1.170083328843000e-21,   6.358438364798791e-01,  -1.431700682453988e-02,   1.748688390104230e-04,  -3.961565488839361e-07,  -2.741046058054985e-08,
   1.419776285827253e-09,  -6.470022321767050e-12,  -9.297868459814514e-13,  -1.556295185049670e-14,   2.371103501568978e-16,   3.407238353630273e-17,   6.304424132956945e-19,
  -1.910756584247847e-20,  -1.160324115782683e-21,   6.358618875069126e-01,  -1.431712688681898e-02,   1.748518140363366e-04,  -3.946950319553419e-07,  -2.742065833123520e-08,
   1.417762118427812e-09,  -6.514188114878923e-12,  -9.288810997120608e-13,  -1.540551191034689e-14,   2.406083862053821e-16,   3.393984766040850e-17,   6.211730061148125e-19,
  -1.930929359274693e-20,  -1.153812005293385e-21,   6.358711573439796e-01,  -1.431718848625386e-02,   1.748430700628050e-04,  -3.939447423025068e-07,  -2.742590411370678e-08,
   1.416728005550639e-09,  -6.536810527179456e-12,  -9.284142874160116e-13,  -1.532473934127177e-14,   2.423979897229567e-16,   3.387160854611101e-17,   6.164196105406407e-19,
  -1.941210349075335e-20,  -1.150448280701639e-21,   6.358743837591986e-01,  -1.431720991722289e-02,   1.748400265097586e-04,  -3.936836399733344e-07,  -2.742773134764496e-08,
   1.416368114304467e-09,  -6.544675102431320e-12,  -9.282515439873916e-13,  -1.529663851892984e-14,   2.430197949018254e-16,   3.384782943771637e-17,   6.147662471145466e-19,
  -1.944776228048160e-20,  -1.149274424362816e-21,   6.358748957451278e-01,  -1.431721331758207e-02,   1.748395435334916e-04,  -3.936422086640456e-07,  -2.742802137052292e-08,
   1.416311006477915e-09,  -6.545922657826691e-12,  -9.282257062689905e-13,  -1.529217991386050e-14,   2.431184154344492e-16,   3.384405470005310e-17,   6.145039333588921e-19,
  -1.945341490164062e-20,  -1.149088003544338e-21,   1.089006300052270e+00,  -2.112144944968279e-02,   7.308461385937804e-05,   5.398045606561106e-06,  -7.773147615277555e-08,
  -1.483371041095112e-10,   9.000516183499830e-11,  -2.432299254857750e-12,  -1.174678565282568e-13,   2.128136770312563e-15,   1.163310922504243e-16,   3.808798152823147e-19,
  -3.462658571805171e-20,  -2.299509806215733e-21,   1.089013065354710e+00,  -2.111993188870288e-02,   7.304158270081357e-05,   5.397867359047907e-06,  -7.760842021702733e-08,
  -1.530108602952913e-10,   8.970674858911669e-11,  -2.425084631720117e-12,  -1.169853548018292e-13,   2.129467050923842e-15,   1.160795785098948e-16,   3.645194333041574e-19,
  -3.545214657436804e-20,  -2.291858431907150e-21,   1.089024999639459e+00,  -2.111725417596830e-02,   7.296570899646504e-05,   5.397549311620314e-06,  -7.739162335056496e-08,
  -1.612462143241758e-10,   8.918121832546635e-11,  -2.412351129550410e-12,  -1.161348676560089e-13,   2.131746262506945e-15,   1.156317875489746e-16,   3.357022543830289e-19,
  -3.689417392923909e-20,  -2.277946424061230e-21,   1.089039425254266e+00,  -2.111401633863279e-02,   7.287405614852065e-05,   5.397158717680057e-06,  -7.713004453463545e-08,
  -1.711847746413014e-10,   8.854748720962698e-11,  -2.396948337355863e-12,  -1.151079842638313e-13,   2.134386366072564e-15,   1.150835591166355e-16,   3.009447471682914e-19,
  -3.861291492796496e-20,  -2.260430082004583e-21,   1.089053423687915e+00,  -2.111087318824533e-02,   7.278517992055093e-05,   5.396773252463471e-06,  -7.687670870074518e-08,
  -1.808123048256496e-10,   8.793409836875358e-11,  -2.381990179957372e-12,  -1.141127224217564e-13,   2.136828118234723e-15,   1.145443387721944e-16,   2.672975248681961e-19,
  -4.025537631675992e-20,  -2.242707972603993e-21,   1.089064696559957e+00,  -2.110834116930961e-02,   7.271365306224829e-05,   5.396458230114213e-06,  -7.667305408039098e-08,
  -1.885533180815782e-10,   8.744126765711172e-11,  -2.369936332853267e-12,  -1.133121204029612e-13,   2.138708455215263e-15,   1.141049724143099e-16,   2.402610928486473e-19,
  -4.155991174580408e-20,  -2.227923467887840e-21,   1.089072143474314e+00,  -2.110666808692527e-02,   7.266642395525004e-05,   5.396247869505840e-06,  -7.653869270746531e-08,
  -1.936611942777389e-10,   8.711625352826223e-11,  -2.361969575393086e-12,  -1.127836719865879e-13,   2.139908552929324e-15,   1.138122279582157e-16,   2.224304218324872e-19,
  -4.241283935386432e-20,  -2.217908039313331e-21,   1.089075967203263e+00,  -2.110580888857884e-02,   7.264218023104606e-05,   5.396139159535099e-06,  -7.646975658768406e-08,
  -1.962820915408444e-10,   8.694954092653638e-11,  -2.357877720475053e-12,  -1.125124669975991e-13,   2.140511761925443e-15,   1.136611454283986e-16,   2.132843169179553e-19,
  -4.284805404103123e-20,  -2.212689072414229e-21,   1.089077297988789e+00,  -2.110550983824410e-02,   7.263374368070595e-05,   5.396101213861485e-06,  -7.644577306246424e-08,
  -1.971939619547536e-10,   8.689154654426429e-11,  -2.356453427203457e-12,  -1.124181001056897e-13,   2.140719630152560e-15,   1.136084416280805e-16,   2.101026611590520e-19,
  -4.299908851958261e-20,  -2.210860581199733e-21,   1.089077509161456e+00,  -2.110546238314671e-02,   7.263240499704186e-05,   5.396095187271206e-06,  -7.644196769725372e-08,
  -1.973386462882964e-10,   8.688234512808821e-11,  -2.356227407426362e-12,  -1.124031267332511e-13,   2.140752517057030e-15,   1.136000726591389e-16,   2.095978585461454e-19,
  -4.302303444915805e-20,  -2.210569856973222e-21,   1.676242775010627e+00,  -1.847672102506821e-02,  -4.791362037398385e-04,   1.319018637254236e-06,   5.270171160734018e-07,
   1.185339374960658e-08,  -3.790430028194231e-10,  -2.622536630668637e-11,  -1.805934908013986e-13,   3.199509248520616e-14,   1.137784821596336e-15,  -1.396453276755161e-17,
  -2.017445042989810e-18,  -3.698048625162790e-20,   1.676198445010153e+00,  -1.847631247393483e-02,  -4.788427930177241e-04,   1.329712844860404e-06,   5.264796876369063e-07,
   1.180344162628872e-08,  -3.794267850593055e-10,  -2.611950792732938e-11,  -1.761677803594587e-13,   3.191479957749911e-14,   1.126030092623671e-15,  -1.418517312068464e-17,
  -2.001717889241517e-18,  -3.605929413540361e-20,   1.676120246025909e+00,  -1.847558920583477e-02,  -4.783253119338232e-04,   1.348545385203562e-06,   5.255309829667295e-07,
   1.171546869252072e-08,  -3.800947549371716e-10,  -2.593294538130879e-11,  -1.683982216669899e-13,   3.177224664250444e-14,   1.105367713333080e-15,  -1.456919712399333e-17,
  -1.973973865998122e-18,  -3.444702157867293e-20,   1.676025724475684e+00,  -1.847471058155402e-02,  -4.776999891217504e-04,   1.371253943336374e-06,   5.243831178012111e-07,
   1.160937771933956e-08,  -3.808868078549924e-10,  -2.570773928159845e-11,  -1.590706554248760e-13,   3.159839337800634e-14,   1.080517251906694e-15,  -1.502458028560770e-17,
  -1.940439147373210e-18,  -3.251984841501884e-20,   1.675934003840781e+00,  -1.847385340416990e-02,  -4.770933774057832e-04,   1.393232161111565e-06,   5.232680856677295e-07,
   1.150668648967005e-08,  -3.816393895846777e-10,  -2.548952070612472e-11,  -1.500860298924153e-13,   3.142809219410833e-14,   1.056533869932075e-15,  -1.545731929723447e-17,
  -1.907901146036280e-18,  -3.067234314440755e-20,   1.675860143000740e+00,  -1.847315985178075e-02,  -4.766050148597786e-04,   1.410889702897719e-06,   5.223693318304631e-07,
   1.142417452689800e-08,  -3.822340109454329e-10,  -2.531402011092119e-11,  -1.428984172561099e-13,   3.128981867756900e-14,   1.037314168711942e-15,  -1.579928430431044e-17,
  -1.881702914632333e-18,  -2.920068410171216e-20,   1.675811350832403e+00,  -1.847270008741747e-02,  -4.762824683332033e-04,   1.422534107380915e-06,   5.217752097951603e-07,
   1.136975714958507e-08,  -3.826212433265044e-10,  -2.519819668704788e-11,  -1.381735243705741e-13,   3.119792601588068e-14,   1.024663568093195e-15,  -1.602201477648420e-17,
  -1.864399158369474e-18,  -2.823636996330598e-20,   1.675786297973423e+00,  -1.847246351999145e-02,  -4.761168731229443e-04,   1.428506841092823e-06,   5.214700255541939e-07,
   1.134184369286074e-08,  -3.828183526198971e-10,  -2.513876054435416e-11,  -1.357546448528376e-13,   3.115057382595293e-14,   1.018182164084628e-15,  -1.613540148118070e-17,
  -1.855515347357920e-18,  -2.774365724392824e-20,   1.675777578773594e+00,  -1.847238110790800e-02,  -4.760592438143663e-04,   1.430584556103211e-06,   5.213637916279477e-07,
   1.133213332617619e-08,  -3.828866796159973e-10,  -2.511808038179768e-11,  -1.349139370051672e-13,   3.113406694620101e-14,   1.015928685073692e-15,  -1.617470855111340e-17,
  -1.852423666660557e-18,  -2.757256291517538e-20,   1.675776195188809e+00,  -1.847236802679843e-02,  -4.760500991985799e-04,   1.430914206294835e-06,   5.213469332097883e-07,
   1.133059267000171e-08,  -3.828975089464394e-10,  -2.511479906356644e-11,  -1.347805854428506e-13,   3.113144632241034e-14,   1.015571204486043e-15,  -1.618093853827427e-17,
  -1.851933079305811e-18,  -2.754543152495668e-20,   1.117227768778616e-02,  -2.673223388143533e-04,   4.721440378507486e-06,  -7.036503528235341e-08,   1.363931169574773e-09,
  -1.245779274584005e-11,  -1.638842351058665e-13,  -1.660369830553091e-14,   2.502502445338458e-16,   2.323078826968080e-17,   2.599103298285442e-19,  -2.393471707397548e-20,
  -9.134343827159694e-22,   6.670618397768812e-24,   1.117272185954336e-02,  -2.673421710652622e-04,   4.722206337083348e-06,  -7.037697810161789e-08,   1.363708726799932e-09,
  -1.248929112891070e-11,  -1.632085394761849e-13,  -1.652843815169432e-14,   2.511837137278400e-16,   2.310981438266422e-17,   2.547624122472017e-19,  -2.387384703402485e-20,
  -9.024315860462118e-22,   6.898230438291921e-24,   1.117350566584178e-02,  -2.673771681607352e-04,   4.723557783234784e-06,  -7.039807503815624e-08,   1.363317002719599e-09,
  -1.254475160516408e-11,  -1.620143693113566e-13,  -1.639597052688862e-14,   2.528136173687366e-16,   2.289662120936001e-17,   2.457332181515123e-19,  -2.376516661864692e-20,
  -8.831039378301088e-22,   7.293962749436974e-24,   1.117445355210067e-02,  -2.674194917607016e-04,   4.725191796431165e-06,  -7.042362593308396e-08,   1.362844656639662e-09,
  -1.261161260387765e-11,  -1.605671602648350e-13,  -1.623635159239340e-14,   2.547552834768131e-16,   2.263928480078552e-17,   2.349074559248141e-19,  -2.363159983902938e-20,
  -8.598809842287158e-22,   7.762507936548312e-24,   1.117537384766143e-02,  -2.674605837453094e-04,   4.726777890524537e-06,  -7.044847237498272e-08,   1.362387506707770e-09,
  -1.267630861038335e-11,  -1.591589092154398e-13,  -1.608198450070530e-14,   2.566097700066912e-16,   2.238995226155500e-17,   2.244944091401455e-19,  -2.349971464450334e-20,
  -8.374917413804861e-22,   8.207001831233298e-24,   1.117611530030051e-02,  -2.674936904753658e-04,   4.728055500249398e-06,  -7.046851843739292e-08,   1.362020233774322e-09,
  -1.272827566104087e-11,  -1.580220798200137e-13,  -1.595804935747442e-14,   2.580820165149742e-16,   2.218944397381779e-17,   2.161746063997577e-19,  -2.339189928765866e-20,
  -8.195664230258491e-22,   8.557717885797187e-24,   1.117660527547306e-02,  -2.675155685579918e-04,   4.728899659878634e-06,  -7.048177922998913e-08,   1.361778037036625e-09,
  -1.276254065606108e-11,  -1.572697362502645e-13,  -1.587636115414714e-14,   2.590442696051494e-16,   2.205712466318754e-17,   2.107106126464575e-19,  -2.331989631929543e-20,
  -8.077761053225590e-22,   8.785884756914381e-24,   1.117685691244915e-02,  -2.675268045402388e-04,   4.729333157048684e-06,  -7.048859382649500e-08,   1.361653809275854e-09,
  -1.278011454212858e-11,  -1.568830190110070e-13,  -1.583447399850569e-14,   2.595351699712991e-16,   2.198922613077647e-17,   2.079149533215857e-19,  -2.328268593829086e-20,
  -8.017380372128288e-22,   8.901957470540739e-24,   1.117694449879894e-02,  -2.675307154127478e-04,   4.729484036655021e-06,  -7.049096643236608e-08,   1.361610594850751e-09,
  -1.278622766227398e-11,  -1.567483625332221e-13,  -1.581990491918583e-14,   2.597055137841591e-16,   2.196560200768296e-17,   2.069435462203196e-19,  -2.326969752303356e-20,
  -7.996391104023375e-22,   8.942182687130639e-24,   1.117695839763164e-02,  -2.675313360184364e-04,   4.729507979025671e-06,  -7.049134296656361e-08,   1.361603738464964e-09,
  -1.278719755788455e-11,  -1.567269917495477e-13,  -1.581759348771970e-14,   2.597325204011357e-16,   2.196185359263710e-17,   2.067894754732106e-19,  -2.326763468702518e-20,
  -7.993061667550354e-22,   8.948557578816061e-24,   1.014867450631329e-01,  -2.407038793532545e-03,   4.116902776290265e-05,  -5.688103734304954e-07,   1.045948023226743e-08,
  -6.268644666005803e-11,  -2.679089544144058e-12,  -1.373998483510137e-13,   2.013539309543631e-15,   2.278916048470876e-16,   2.438453629705997e-18,  -2.273770578250519e-19,
  -8.841732751900032e-21,   6.021514501734005e-23,   1.014906164202257e-01,  -2.407198986228772e-03,   4.117489034467572e-05,  -5.688713064085761e-07,   1.045577761022274e-08,
  -6.294526015181912e-11,  -2.673628889460859e-12,  -1.366605984358240e-13,   2.022247913318887e-15,   2.267417339913636e-16,   2.388608037543949e-18,  -2.268159629721192e-19,
  -8.735582913860631e-21,   6.248745925014733e-23,   1.014974479351896e-01,  -2.407481663070449e-03,   4.118523328471530e-05,  -5.689790172965824e-07,   1.044925058528341e-08,
  -6.340077207477745e-11,  -2.663975837724290e-12,  -1.353593184289172e-13,   2.037447656519680e-15,   2.247152406653485e-16,   2.301179522346719e-18,  -2.258131703645657e-19,
  -8.549108517189019e-21,   6.643895311410510e-23,   1.015057094338512e-01,  -2.407823503355208e-03,   4.119773721965949e-05,  -5.691095921079825e-07,   1.044136880908394e-08,
  -6.394959290099757e-11,  -2.652273425058112e-12,  -1.337911426722709e-13,   2.055544287733683e-15,   2.222690334015796e-16,   2.196352028225360e-18,  -2.245791051754739e-19,
  -8.325034665227402e-21,   7.111885127120811e-23,   1.015137303471735e-01,  -2.408155381604066e-03,   4.120987283225670e-05,  -5.692366963185005e-07,   1.043372861433148e-08,
  -6.448030010517632e-11,  -2.640881982432987e-12,  -1.322743768539574e-13,   2.072817318360994e-15,   2.198987931489605e-16,   2.095517762487427e-18,  -2.233588985266023e-19,
  -8.108987297732861e-21,   7.555994288960779e-23,   1.015201924590524e-01,  -2.408422756786793e-03,   4.121964698271125e-05,  -5.693393360702122e-07,   1.042758187886625e-08,
  -6.490634472780536e-11,  -2.631683227759184e-12,  -1.310564923669611e-13,   2.086522068593819e-15,   2.179926106236356e-16,   2.014951085960844e-18,  -2.223602173037761e-19,
  -7.936002454677177e-21,   7.906509541827374e-23,   1.015244627857447e-01,  -2.408599442555065e-03,   4.122610451953568e-05,  -5.694072789437521e-07,   1.042352419921286e-08,
  -6.518714098325154e-11,  -2.625594190049715e-12,  -1.302536938708764e-13,   2.095475453951495e-15,   2.167346440401548e-16,   1.962038184076380e-18,  -2.216927027355904e-19,
  -7.822216167241419e-21,   8.134596560831650e-23,   1.015266558888833e-01,  -2.408690181940062e-03,   4.122942044982900e-05,  -5.694422080345001e-07,   1.042144161643927e-08,
  -6.533111890170440e-11,  -2.622463898039971e-12,  -1.298420235431278e-13,   2.100041849622713e-15,   2.160891169783620e-16,   1.934964894183980e-18,  -2.213475680619916e-19,
  -7.763941962690503e-21,   8.250644478803043e-23,   1.015274192322140e-01,  -2.408721765058171e-03,   4.123057453819079e-05,  -5.694543713384703e-07,   1.042071695032032e-08,
  -6.538119603437682e-11,  -2.621373850717399e-12,  -1.296988342164805e-13,   2.101626203622518e-15,   2.158645150444594e-16,   1.925557690888256e-18,  -2.212270707590394e-19,
  -7.743684642502724e-21,   8.290863634775324e-23,   1.015275403649380e-01,  -2.408726776885136e-03,   4.123075767367279e-05,  -5.694563017679711e-07,   1.042060196508870e-08,
  -6.538914089132077e-11,  -2.621200850541635e-12,  -1.296761166134116e-13,   2.101877380547358e-15,   2.158288775978219e-16,   1.924065651861989e-18,  -2.212079319619951e-19,
  -7.740471297710486e-21,   8.297237686490722e-23,   2.874136128637619e-01,  -6.677023317877608e-03,   1.053381082767456e-04,  -1.158771863928993e-06,   1.784862773440175e-08,
   1.068376270295137e-10,  -1.358655838870605e-11,  -3.609957706763962e-13,   5.559360144726166e-15,   7.259973391069112e-16,   8.150632956161971e-18,  -7.266325761636719e-19,
  -2.867735756201348e-20,   1.657525984150174e-22,   2.874235082296484e-01,  -6.677348890051144e-03,   1.053480413810587e-04,  -1.158677329629744e-06,   1.782970210556365e-08,
   1.061641563784854e-10,  -1.357137600716781e-11,  -3.586412116262181e-13,   5.588626670791415e-15,   7.223166463394684e-16,   7.988994153287707e-18,  -7.249997903586974e-19,
  -2.833249348039582e-20,   1.736612403056632e-22,   2.874409695030918e-01,  -6.677923346630210e-03,   1.053655598880367e-04,  -1.158511024289056e-06,   1.779632511838108e-08,
   1.049795284908755e-10,  -1.354452706067909e-11,  -3.544966044752635e-13,   5.639727294255061e-15,   7.158292682797359e-16,   7.705485714331098e-18,  -7.220743371984892e-19,
  -2.772660053509203e-20,   1.874189880765558e-22,   2.874620851307834e-01,  -6.678617950540926e-03,   1.053867287755323e-04,  -1.158310779987776e-06,   1.775599533316687e-08,
   1.035533985781198e-10,  -1.351196052981077e-11,  -3.495020220338834e-13,   5.700600873330555e-15,   7.079971674173039e-16,   7.365563706032533e-18,  -7.184619677750396e-19,
  -2.699842675235034e-20,   2.037210488019265e-22,   2.874825851452493e-01,  -6.679292223310001e-03,   1.054072638012351e-04,  -1.158117278031380e-06,   1.771687537333961e-08,
   1.021755560773080e-10,  -1.348024125231538e-11,  -3.446712784233844e-13,   5.758739784337415e-15,   7.004071517189575e-16,   7.038597991650890e-18,  -7.148777263704402e-19,
  -2.629622077360540e-20,   2.191999497952635e-22,   2.874991006418665e-01,  -6.679835382468062e-03,   1.054237955478001e-04,  -1.157962032583514e-06,   1.768538344981241e-08,
   1.010703172336183e-10,  -1.345461461145493e-11,  -3.407925141391644e-13,   5.804894237867825e-15,   6.943023380240565e-16,   6.777357688143062e-18,  -7.119355397007720e-19,
  -2.573389670024982e-20,   2.314230363901236e-22,   2.875100142535674e-01,  -6.680194279554867e-03,   1.054347140460608e-04,  -1.157859760459424e-06,   1.766458523276914e-08,
   1.003423085972383e-10,  -1.343764502870362e-11,  -3.382357675360340e-13,   5.835060028803228e-15,   6.902731320489253e-16,   6.605788572504815e-18,  -7.099648600723561e-19,
  -2.536397068131191e-20,   2.393799419266329e-22,   2.875156190593763e-01,  -6.680378586426093e-03,   1.054403195523090e-04,  -1.157807334955589e-06,   1.765390778466441e-08,
   9.996915595332968e-11,  -1.342891927590440e-11,  -3.369246942879441e-13,   5.850449158604275e-15,   6.882054190326324e-16,   6.518004824995803e-18,  -7.089446752136081e-19,
  -2.517450566593481e-20,   2.434292875993933e-22,   2.875175698862878e-01,  -6.680442735491258e-03,   1.054422703350545e-04,  -1.157789103069045e-06,   1.765019194766904e-08,
   9.983939045224632e-11,  -1.342588044222423e-11,  -3.364686717438715e-13,   5.855789203455926e-15,   6.874859685486468e-16,   6.487502597999720e-18,  -7.085882988798802e-19,
  -2.510864178706007e-20,   2.448328392159815e-22,   2.875178794567396e-01,  -6.680452915034565e-03,   1.054425798848281e-04,  -1.157786210645352e-06,   1.764960232146809e-08,
   9.981880385028112e-11,  -1.342539813793735e-11,  -3.363963218903492e-13,   5.856635822582345e-15,   6.873718128839328e-16,   6.482664768249672e-18,  -7.085316856518002e-19,
  -2.509819394946573e-20,   2.450552856316348e-22,   5.811994668711370e-01,  -1.294096211023487e-02,   1.683818104900281e-04,  -6.330358840619510e-07,  -2.458382357753290e-09,
   9.309443794365547e-10,  -3.657829216892038e-11,  -1.047708622560477e-12,   1.931615204477131e-14,   1.726638765951972e-15,   2.201118054549083e-17,  -1.821050393859433e-18,
  -7.590998211951177e-20,   3.429841795772022e-22,   5.812152492770345e-01,  -1.294113713880982e-02,   1.683801411488358e-04,  -6.321796384001482e-07,  -2.509199558251665e-09,
   9.289700420921530e-10,  -3.652599024279980e-11,  -1.042121394762087e-12,   1.939545260973326e-14,   1.717401445551179e-15,   2.158307157747039e-17,  -1.817317140405535e-18,
  -7.500279256945222e-20,   3.659975440775043e-22,   5.812430974196789e-01,  -1.294144578654024e-02,   1.683771724777799e-04,  -6.306702572440806e-07,  -2.598806901936157e-09,
   9.254951176049444e-10,  -3.643354154767752e-11,  -1.032287873024318e-12,   1.953394761283791e-14,   1.701118915074748e-15,   2.083215615613893e-17,  -1.810600467327283e-18,
  -7.340872196207741e-20,   4.060429673743328e-22,   5.812767714158786e-01,  -1.294181867791255e-02,   1.683735433739499e-04,  -6.288476126249365e-07,  -2.707057941303710e-09,
   9.213082212790836e-10,  -3.632147892489854e-11,  -1.020440058915201e-12,   1.969898585479692e-14,   1.681459023816658e-15,   1.993177322339807e-17,  -1.802260388280492e-18,
  -7.149255963635696e-20,   4.535143072074589e-22,   5.813094612585641e-01,  -1.294218033041182e-02,   1.683699791149914e-04,  -6.270808488831746e-07,  -2.812038039138543e-09,
   9.172593479227847e-10,  -3.621240754599241e-11,  -1.008983377333362e-12,   1.985666928138499e-14,   1.662404489507257e-15,   1.906565972126163e-17,  -1.793938326925353e-18,
  -6.964434460981692e-20,   4.986097134236204e-22,   5.813357955619324e-01,  -1.294247142669508e-02,   1.683670783006840e-04,  -6.256594459405537e-07,  -2.896531053424532e-09,
   9.140088475089298e-10,  -3.612434018458706e-11,  -9.997862150321802e-13,   1.998189157323930e-14,   1.647076896540621e-15,   1.837361434266757e-17,  -1.787074495592879e-18,
  -6.816403037393028e-20,   5.342350250776809e-22,   5.813531966978196e-01,  -1.294266365743543e-02,   1.683651470603679e-04,  -6.247211265391654e-07,  -2.952324500216161e-09,
   9.118664580242358e-10,  -3.606604922561781e-11,  -9.937246434230673e-13,   2.006375601246072e-14,   1.636959836257395e-15,   1.791909790186464e-17,  -1.782461612597333e-18,
  -6.719007292025218e-20,   5.574336694309544e-22,   5.813621329818753e-01,  -1.294276233987062e-02,   1.683641508137301e-04,  -6.242395382854906e-07,  -2.980965333923044e-09,
   9.107679321424490e-10,  -3.603608399776873e-11,  -9.906166043608079e-13,   2.010552590356348e-14,   1.631767713878087e-15,   1.768653830497999e-17,  -1.780068914413840e-18,
  -6.669120150180152e-20,   5.692420202721450e-22,   5.813652433323003e-01,  -1.294279668126752e-02,   1.683638033506880e-04,  -6.240719622108366e-07,  -2.990932163635317e-09,
   9.103858495878692e-10,  -3.602564955874517e-11,  -9.895355976568899e-13,   2.012002115815498e-14,   1.629961103300259e-15,   1.760572997878660e-17,  -1.779232346053843e-18,
  -6.651777215924972e-20,   5.733353096556409e-22,   5.813657369018352e-01,  -1.294280213049284e-02,   1.683637481793721e-04,  -6.240453723373972e-07,  -2.992513673228548e-09,
   9.103252311358915e-10,  -3.602399353095192e-11,  -9.893640935561718e-13,   2.012231930893797e-14,   1.629674445486333e-15,   1.759291327159329e-17,  -1.779099415609490e-18,
  -6.649026115993997e-20,   5.739840656424583e-22,   1.006070749620755e+00,  -2.029841413513673e-02,   1.306021706954126e-04,   4.218400133409453e-06,  -6.639116376000661e-08,
   8.726124136212020e-10,  -1.285731896886232e-11,  -4.087366817708846e-12,   3.815455551569565e-14,   6.020630431730013e-15,   3.459425465998602e-17,  -5.543994120493407e-18,
  -1.936569081551556e-19,   5.596353525288476e-22,   1.006082918390635e+00,  -2.029722507295167e-02,   1.305647311980885e-04,   4.219153459018521e-06,  -6.640803053121581e-08,
   8.648753081911218e-10,  -1.275495333616050e-11,  -4.067781736283640e-12,   3.826649258886817e-14,   5.992396607062653e-15,   3.351782546386941e-17,  -5.535589503824709e-18,
  -1.909971129289552e-19,   6.406337416759031e-22,   1.006104387512271e+00,  -2.029512679287880e-02,   1.304986611889192e-04,   4.220476911637689e-06,  -6.643767435486229e-08,
   8.512540503855214e-10,  -1.257410898485147e-11,  -4.033300747682919e-12,   3.846042147745941e-14,   5.942617094489237e-15,   3.163159643243162e-17,  -5.520304363306399e-18,
  -1.863248646589434e-19,   7.815793090333032e-22,   1.006130343319417e+00,  -2.029258925631747e-02,   1.304187560012047e-04,   4.222067367314934e-06,  -6.647331886532616e-08,
   8.348358299976665e-10,  -1.235506249614170e-11,  -3.991737513570557e-12,   3.868883875615287e-14,   5.882491817983135e-15,   2.937309248652117e-17,  -5.501053371616360e-18,
  -1.807110105178717e-19,   9.486633126146988e-22,   1.006155535652668e+00,  -2.029012557406953e-02,   1.303411722530976e-04,   4.223601031040235e-06,  -6.650771113158715e-08,
   8.189524375920306e-10,  -1.214203757069929e-11,  -3.951526296175156e-12,   3.890425049070248e-14,   5.824196723540820e-15,   2.720388177209466e-17,  -5.481570569290315e-18,
  -1.752988331420484e-19,   1.107387539350715e-21,   1.006175826603524e+00,  -2.028814065979207e-02,   1.302786623882022e-04,   4.224829148457638e-06,  -6.653526591270908e-08,
   8.061964090960399e-10,  -1.197016093050285e-11,  -3.919231215383790e-12,   3.907327400438637e-14,   5.777288723647470e-15,   2.547302674065686e-17,  -5.465313398113550e-18,
  -1.709658897586715e-19,   1.232782023079944e-21,   1.006189232707684e+00,  -2.028682896428256e-02,   1.302373523909810e-04,   4.225637057861459e-06,  -6.655339954353892e-08,
   7.977867260624706e-10,  -1.185645925044399e-11,  -3.897939425519772e-12,   3.918276482766748e-14,   5.746319528590041e-15,   2.433742595937548e-17,  -5.454298557041036e-18,
  -1.681160176822992e-19,   1.314438436909637e-21,   1.006196116828576e+00,  -2.028615531516809e-02,   1.302161363135432e-04,   4.226050843202430e-06,  -6.656268910975351e-08,
   7.934739053808219e-10,  -1.179802860010819e-11,  -3.887019979983557e-12,   3.923831653327368e-14,   5.730423740694702e-15,   2.375674534048840e-17,  -5.448558267309495e-18,
  -1.666565772572391e-19,   1.356002914046643e-21,   1.006198512821528e+00,  -2.028592084054199e-02,   1.302087516381283e-04,   4.226194687612341e-06,  -6.656591877827756e-08,
   7.919737359429479e-10,  -1.177768503985762e-11,  -3.883221739657728e-12,   3.925754423065369e-14,   5.724892407972676e-15,   2.355503238402163e-17,  -5.446547044090584e-18,
  -1.661492596106642e-19,   1.370411061321424e-21,   1.006198893028416e+00,  -2.028588363241638e-02,   1.302075797811495e-04,   4.226217505321139e-06,  -6.656643110889107e-08,
   7.917357246733571e-10,  -1.177445650161894e-11,  -3.882619123855934e-12,   3.926059029833197e-14,   5.724014725519111e-15,   2.352304221193870e-17,  -5.446227262107264e-18,
  -1.660687863405528e-19,   1.372694649948210e-21,   1.594990537400327e+00,  -2.208957481819425e-02,  -4.071675096932510e-04,   1.090840344279919e-05,   6.157267913173734e-07,
  -5.393479427514741e-09,  -9.743982752793874e-10,  -7.811792365850230e-12,   1.368094836377498e-12,   3.582922785120603e-14,  -1.518937492248694e-15,  -8.389741349691676e-17,
   8.802698884547549e-19,   1.498162507783045e-19,   1.594953045598349e+00,  -2.208652506734740e-02,  -4.068286465532041e-04,   1.090323407650079e-05,   6.143973059243992e-07,
  -5.407119039568907e-09,  -9.709349032160987e-10,  -7.701007158589750e-12,   1.361875377285268e-12,   3.543462117839086e-14,  -1.513126794763375e-15,  -8.290518741465779e-17,
   8.886653827987129e-19,   1.479140930188513e-19,   1.594886915668123e+00,  -2.208114493492597e-02,  -4.062313156644720e-04,   1.089410277969735e-05,   6.120553175490167e-07,
  -5.431013953186260e-09,  -9.648368865183364e-10,  -7.506580104689723e-12,   1.350921276882979e-12,   3.474238652119756e-14,  -1.502835579790442e-15,  -8.116541821926575e-17,
   9.031056982143015e-19,   1.445784630067962e-19,   1.594806993152255e+00,  -2.207464127039272e-02,  -4.055100359790967e-04,   1.088304437856627e-05,   6.092300160084312e-07,
  -5.459615121584588e-09,  -9.574855048386639e-10,  -7.273268521393288e-12,   1.337710044477901e-12,   3.391221190646744e-14,  -1.490327534945022e-15,  -7.908039289410607e-17,
   9.199366827768227e-19,   1.405802756734758e-19,   1.594729450227644e+00,  -2.206832977298943e-02,  -4.048108959149284e-04,   1.087229165596015e-05,   6.064942190612476e-07,
  -5.487075448619388e-09,  -9.503723351523820e-10,  -7.048640381501793e-12,   1.324921128980089e-12,   3.311346078208933e-14,  -1.478119712293546e-15,  -7.707578541962350e-17,
   9.356242922461638e-19,   1.367357326348054e-19,   1.594667014492268e+00,  -2.206324685271463e-02,  -4.042484403101404e-04,   1.086361700051711e-05,   6.042952720222916e-07,
  -5.508979475139777e-09,  -9.446588146888146e-10,  -6.869013668074189e-12,   1.314644641361656e-12,   3.247510523303415e-14,  -1.468239615916659e-15,  -7.547479568000968e-17,
   9.478011069278953e-19,   1.336649138670623e-19,   1.594625773647763e+00,  -2.205988890404964e-02,  -4.038771525897875e-04,   1.085787890186217e-05,   6.028446793806424e-07,
  -5.523347103317195e-09,  -9.408916156890306e-10,  -6.750968435526827e-12,   1.307866927939189e-12,   3.205578103460205e-14,  -1.461689122738366e-15,  -7.442366380858901e-17,
   9.556240398218949e-19,   1.316486089026596e-19,   1.594604599315914e+00,  -2.205816467018190e-02,  -4.036865938171656e-04,   1.085493025213775e-05,   6.021004821013898e-07,
  -5.530692822857151e-09,  -9.389595103497966e-10,  -6.690546666204848e-12,   1.304390214446186e-12,   3.184120559589740e-14,  -1.458318451370950e-15,  -7.388594567735700e-17,
   9.595729421255696e-19,   1.306171018873459e-19,   1.594597230162174e+00,  -2.205756457196819e-02,  -4.036202864289415e-04,   1.085390365183821e-05,   6.018415769850225e-07,
  -5.533244362469071e-09,  -9.382874262198233e-10,  -6.669548122331127e-12,   1.303180744512269e-12,   3.176664264063698e-14,  -1.457144203209893e-15,  -7.369911985894006e-17,
   9.609365256786009e-19,   1.302587064739773e-19,   1.594596060815344e+00,  -2.205746934641133e-02,  -4.036097652300136e-04,   1.085374073048056e-05,   6.018004979833309e-07,
  -5.533649009705962e-09,  -9.381807948438214e-10,  -6.666217451535546e-12,   1.302988848306548e-12,   3.175481631357686e-14,  -1.456957816275818e-15,  -7.366948891946887e-17,
   9.611523925721959e-19,   1.302018639537991e-19,   1.017367983403252e-02,  -2.325783558908716e-04,   3.998712353398030e-06,  -5.088076375296798e-08,   1.045801935521411e-09,
  -2.028386417123461e-11,  -3.917861984975846e-13,   4.106131719774967e-15,   9.313473571150522e-16,   4.089932375461462e-18,  -1.246819083329732e-18,  -2.539061529211663e-20,
   1.380978445619083e-21,   5.932336404959526e-23,   1.017405588751825e-02,  -2.325927327982141e-04,   3.999297676209899e-06,  -5.089971032336316e-08,   1.045278529072371e-09,
  -2.027561448508849e-11,  -3.894438966306881e-13,   4.116962387988585e-15,   9.263472852853697e-16,   3.973697819613588e-18,  -1.238672759307105e-18,  -2.500570053675339e-20,
   1.372378995416126e-21,   5.841867254184527e-23,   1.017471948408870e-02,  -2.326181053978956e-04,   4.000330254605067e-06,  -5.093313550901570e-08,   1.044357608070556e-09,
  -2.026104188636539e-11,  -3.853213822798325e-13,   4.135764963514421e-15,   9.175521701181651e-16,   3.770164492712319e-18,  -1.224341701080267e-18,  -2.433171660824915e-20,
   1.357204375472475e-21,   5.683533190440759e-23,   1.017552198764025e-02,  -2.326487935823396e-04,   4.001578463104780e-06,  -5.097354278991065e-08,   1.043248510287685e-09,
  -2.024339376649424e-11,  -3.803542813981357e-13,   4.157978427011240e-15,   9.069639649474160e-16,   3.526702540312544e-18,  -1.207086187267189e-18,  -2.352554971288821e-20,
   1.338855014965606e-21,   5.494277466589602e-23,   1.017630112323343e-02,  -2.326785928527153e-04,   4.002789788311222e-06,  -5.101275814833261e-08,   1.042176508608664e-09,
  -2.022623365410213e-11,  -3.755509865547303e-13,   4.178999050395744e-15,   8.967341462859795e-16,   3.293113157709584e-18,  -1.190412060208568e-18,  -2.275210883030181e-20,
   1.321043286601152e-21,   5.312841770546374e-23,   1.017692884135486e-02,  -2.327026042822233e-04,   4.003765320243355e-06,  -5.104434140625371e-08,   1.041316271975914e-09,
  -2.021239019241326e-11,  -3.716948635244926e-13,   4.195545913254379e-15,   8.885281741624044e-16,   3.106900519355417e-18,  -1.177034925501543e-18,  -2.213556032755869e-20,
   1.306696562506279e-21,   5.168308715851401e-23,   1.017734365402579e-02,  -2.327184733118302e-04,   4.004409789777508e-06,  -5.106520707965807e-08,   1.040749482194884e-09,
  -2.020323325065694e-11,  -3.691533276215922e-13,   4.206291294436394e-15,   8.831229320134008e-16,   2.984810863731396e-18,  -1.168222638114887e-18,  -2.173133248081731e-20,
   1.297218000947455e-21,   5.073596738928676e-23,   1.017755668875179e-02,  -2.327266236542256e-04,   4.004740711067204e-06,  -5.107592136967780e-08,   1.040458914854220e-09,
  -2.019852783202115e-11,  -3.678501410879281e-13,   4.211751488606772e-15,   8.803523675927496e-16,   2.922406624385998e-18,  -1.163705482239972e-18,  -2.152472052814486e-20,
   1.292350861125969e-21,   5.025201796047849e-23,   1.017763083880360e-02,  -2.327294605886820e-04,   4.004855884149326e-06,  -5.107965038030607e-08,   1.040357860783500e-09,
  -2.019688960996538e-11,  -3.673968754006937e-13,   4.213642733340544e-15,   8.793888881215605e-16,   2.900733065483376e-18,  -1.162134578050573e-18,  -2.145296275598189e-20,
   1.290656905026557e-21,   5.008396277652074e-23,   1.017764260546038e-02,  -2.327299107774300e-04,   4.004874160194166e-06,  -5.108024211362396e-08,   1.040341828717215e-09,
  -2.019662962498889e-11,  -3.673249635797266e-13,   4.213942410245260e-15,   8.792360371023885e-16,   2.897295990310795e-18,  -1.161885360483892e-18,  -2.144158315654851e-20,
   1.290388102267334e-21,   5.005731312738185e-23,   9.247792008797266e-02,  -2.102268088486908e-03,   3.529168159356773e-05,  -4.160600815289825e-07,   8.321477265681504e-09,
  -1.582213474536546e-10,  -4.401212375010395e-12,   5.146626650527111e-14,   8.699532277869559e-15,   4.257418797213432e-17,  -1.202339122116234e-17,  -2.451762189444712e-19,
   1.329477386600950e-20,   5.780673531498932e-22,   9.248123800542851e-02,  -2.102385624378713e-03,   3.529632906750141e-05,  -4.162075453419784e-07,   8.315544920008697e-09,
  -1.581182568187395e-10,  -4.379364477357725e-12,   5.158128350097786e-14,   8.651311605073308e-15,   4.145299449783803e-17,  -1.194495263571438e-17,  -2.414278699124653e-19,
   1.321231285487125e-20,   5.692066017579410e-22,   9.248709287337557e-02,  -2.102593051878945e-03,   3.530452695550337e-05,  -4.164676684691196e-07,   8.305101795255300e-09,
  -1.579361815390946e-10,  -4.340914918928459e-12,   5.178125982340998e-14,   8.566491138835218e-15,   3.948986238732120e-17,  -1.180696161776509e-17,  -2.348648127118048e-19,
   1.306677531941958e-20,   5.536995758423602e-22,   9.249417323958734e-02,  -2.102843932655820e-03,   3.531443541345593e-05,  -4.167820771958861e-07,   8.292515711126350e-09,
  -1.577157270782200e-10,  -4.294593813796976e-12,   5.201803220169789e-14,   8.464377338201199e-15,   3.714184925131164e-17,  -1.164080922638369e-17,  -2.270150800543008e-19,
   1.289074481708097e-20,   5.351650920662824e-22,   9.250104736190426e-02,  -2.103087543283204e-03,   3.532404965362785e-05,  -4.170871583365962e-07,   8.280341087662910e-09,
  -1.575014171013376e-10,  -4.249806249004320e-12,   5.224264334731855e-14,   8.365719127628194e-15,   3.488930223056766e-17,  -1.148025261435273e-17,  -2.194845091582148e-19,
   1.271982632766414e-20,   5.173974679170768e-22,   9.250658551340334e-02,  -2.103283835752081e-03,   3.533179138589718e-05,  -4.173328263451863e-07,   8.270564630841029e-09,
  -1.573285620861653e-10,  -4.213854709811068e-12,   5.241985530920333e-14,   8.286578736503302e-15,   3.309379922263027e-17,  -1.135144140334697e-17,  -2.134818750767484e-19,
   1.258212542397677e-20,   5.032443746004657e-22,   9.251024524454060e-02,  -2.103413563326734e-03,   3.533690533511044e-05,  -4.174951097163409e-07,   8.264119800487236e-09,
  -1.572142410416397e-10,  -4.190161468904141e-12,   5.253513665309116e-14,   8.234449012107080e-15,   3.191667283060541e-17,  -1.126658528837695e-17,  -2.095465436040415e-19,
   1.249113407393027e-20,   4.939702642113143e-22,   9.251212475939750e-02,  -2.103480191139517e-03,   3.533953108316548e-05,  -4.175784346246196e-07,   8.260814790609583e-09,
  -1.571555005578246e-10,  -4.178013277505759e-12,   5.259377930004109e-14,   8.207728805962305e-15,   3.131503038515887e-17,  -1.122308803010189e-17,  -2.075351423855159e-19,
   1.244440627504803e-20,   4.892315870543208e-22,   9.251277895254949e-02,  -2.103503382593996e-03,   3.534044491775103e-05,  -4.176074341748996e-07,   8.259665202371856e-09,
  -1.571350504556663e-10,  -4.173788077534419e-12,   5.261410147285859e-14,   8.198436690411077e-15,   3.110607888617000e-17,  -1.120796121324188e-17,  -2.068365774376051e-19,
   1.242814241722002e-20,   4.875860625343344e-22,   9.251288276450542e-02,  -2.103507062807512e-03,   3.534058992686656e-05,  -4.176120358879571e-07,   8.259482814179068e-09,
  -1.571318050720679e-10,  -4.173117743095142e-12,   5.261732210347920e-14,   8.196962543896526e-15,   3.107294277327147e-17,  -1.120556140349325e-17,  -2.067257969699888e-19,
   1.242556157721123e-20,   4.873251214078323e-22,   2.623097678733959e-01,  -5.885051877945664e-03,   9.315160924311870e-05,  -8.765752797491950e-07,   1.611427840150305e-08,
  -2.959744919441359e-10,  -1.729042750685970e-11,   2.155257566254740e-13,   2.702781767955822e-14,   1.400668496246471e-16,  -3.862269667054286e-17,  -8.002403981319492e-19,
   4.314306104332028e-20,   1.912945499558803e-21,   2.623185187469934e-01,  -5.885299378059813e-03,   9.316054118431474e-05,  -8.768491333009310e-07,   1.609076039498070e-08,
  -2.955443478164252e-10,  -1.722265242981666e-11,   2.159050666157581e-13,   2.687300315098958e-14,   1.364128479937978e-16,  -3.836808796495184e-17,  -7.878579330762878e-19,
   4.287713186270941e-20,   1.883215853945896e-21,   2.623339604665497e-01,  -5.885736157897860e-03,   9.317629116607665e-05,  -8.773320226400508e-07,   1.604933874999535e-08,
  -2.947847897693855e-10,  -1.710338773768141e-11,   2.165646804519565e-13,   2.660069288730689e-14,   1.300155966182513e-16,  -3.792016731260251e-17,  -7.661798018240051e-19,
   4.240762484404073e-20,   1.831191854283848e-21,   2.623526338929169e-01,  -5.886264422396092e-03,   9.319531821467659e-05,  -8.779153753896278e-07,   1.599938101108787e-08,
  -2.938653761967426e-10,  -1.695972534863914e-11,   2.173458720537059e-13,   2.627287973197625e-14,   1.223652422940244e-16,  -3.738082305396874e-17,  -7.402560766866289e-19,
   4.183947604755778e-20,   1.769020110876467e-21,   2.623707629189477e-01,  -5.886777362997301e-03,   9.321377052695806e-05,  -8.784810950708507e-07,   1.595101846247544e-08,
  -2.929718459501070e-10,  -1.682083867891782e-11,   2.180871615833009e-13,   2.595617694113191e-14,   1.150270932007380e-16,  -3.685963180730966e-17,  -7.153909426073650e-19,
   4.128754935105856e-20,   1.709430111412074e-21,   2.623853682765439e-01,  -5.887190660451807e-03,   9.322862200832879e-05,  -8.789364091841667e-07,   1.591215512468113e-08,
  -2.922513370334016e-10,  -1.670936660707616e-11,   2.186721811711493e-13,   2.570214051900932e-14,   1.091786871986937e-16,  -3.644148326727887e-17,  -6.955741547881650e-19,
   4.084269404700680e-20,   1.661969467174881e-21,   2.623950196526479e-01,  -5.887463798795276e-03,   9.323842902002551e-05,  -8.792370657720692e-07,   1.588652227852352e-08,
  -2.917749021792829e-10,  -1.663590972138688e-11,   2.190528341329979e-13,   2.553481288427435e-14,   1.053448932923459e-16,  -3.616601869619907e-17,  -6.825838512293431e-19,
   4.054864488061368e-20,   1.630873200265580e-21,   2.623999762246874e-01,  -5.887604080383035e-03,   9.324346335584272e-05,  -8.793914033201151e-07,   1.587337321120401e-08,
  -2.915301271470824e-10,  -1.659824843097672e-11,   2.192464946293806e-13,   2.544904738037751e-14,   1.033855231547134e-16,  -3.602481443273255e-17,  -6.759448254352582e-19,
   4.039761005185003e-20,   1.614985353223229e-21,   2.624017014254478e-01,  -5.887652908581059e-03,   9.324521527888145e-05,  -8.794451117270967e-07,   1.586879888461416e-08,
  -2.914449146375364e-10,  -1.658514998925606e-11,   2.193136103383417e-13,   2.541922219649410e-14,   1.027050502577827e-16,  -3.597570838651060e-17,  -6.736391530090939e-19,
   4.034503707624755e-20,   1.609468398769079e-21,   2.624019751920204e-01,  -5.887660657034124e-03,   9.324549326957852e-05,  -8.794536340278114e-07,   1.586807311240465e-08,
  -2.914313918125796e-10,  -1.658307191748876e-11,   2.193242469413841e-13,   2.541449059797480e-14,   1.025971399063922e-16,  -3.596791789827990e-17,  -6.732735164882180e-19,
   4.033669428901131e-20,   1.608593548536126e-21,   5.320820966730689e-01,  -1.162389866388474e-02,   1.609867182689998e-04,  -5.790772811774768e-07,   5.616727604617106e-09,
  -1.705396599615662e-10,  -4.788528460317403e-11,   5.247183944602541e-13,   7.040675357846090e-14,   2.688883425432192e-16,  -9.852994619400591e-17,  -2.076472789193040e-18,
   1.137678050987689e-19,   5.160382332313066e-21,   5.320971947450128e-01,  -1.162406205933902e-02,   1.609895104145225e-04,  -5.792283824740647e-07,   5.551466705201575e-09,
  -1.694965510847730e-10,  -4.770854539409071e-11,   5.253847760916789e-13,   7.001248217918798e-14,   2.594496882969828e-16,  -9.785917879488282e-17,  -2.043198379440783e-18,
   1.130534273829595e-19,   5.077744177164402e-21,   5.321238357003890e-01,  -1.162435040621259e-02,   1.609944078394891e-04,  -5.794942051468988e-07,   5.436511731700486e-09,
  -1.676550189199240e-10,  -4.739751480890878e-11,   5.265356350672260e-13,   6.931905550763338e-14,   2.429300365187742e-16,  -9.667920394458138e-17,  -1.984959745495937e-18,
   1.117918003755905e-19,   4.933174568862307e-21,   5.321560505165484e-01,  -1.162469913451598e-02,   1.610002798583290e-04,  -5.798142797704344e-07,   5.297845467890235e-09,
  -1.654266251060839e-10,  -4.702282272407509e-11,   5.278849181340027e-13,   6.848442103844106e-14,   2.231831504777343e-16,  -9.525851514504877e-17,  -1.915341197297077e-18,
   1.102644982385408e-19,   4.760471940939878e-21,   5.321873244024714e-01,  -1.162503773259034e-02,   1.610059280310941e-04,  -5.801235769086363e-07,   5.163584337100860e-09,
  -1.632617041560668e-10,  -4.666054987531300e-11,   5.291507479588528e-13,   6.767820835347017e-14,   2.042511707797626e-16,  -9.388577813875061e-17,  -1.848592575767624e-18,
   1.087801854694065e-19,   4.595010530537400e-21,   5.322125184519514e-01,  -1.162531054472236e-02,   1.610104407208663e-04,  -5.803717207244084e-07,   5.055678151366226e-09,
  -1.615165243899540e-10,  -4.636975912746588e-11,   5.301391574045905e-13,   6.703161805179718e-14,   1.891691178113295e-16,  -9.278453777185240e-17,  -1.795415211570409e-18,
   1.075833943569315e-19,   4.463278066891619e-21,   5.322291663351358e-01,  -1.162549083460197e-02,   1.610134043335815e-04,  -5.805351892187408e-07,   4.984499229786620e-09,
  -1.603627883303730e-10,  -4.617812345869282e-11,   5.307770313703835e-13,   6.660577177440511e-14,   1.792855831287320e-16,  -9.205912003928501e-17,  -1.760565837631839e-18,
   1.067921119982171e-19,   4.376991197765313e-21,   5.322377158518067e-01,  -1.162558342840645e-02,   1.610149206381510e-04,  -5.806189832903519e-07,   4.947983611775107e-09,
  -1.597701208630336e-10,  -4.607986797974114e-11,   5.310999130515356e-13,   6.638751444742082e-14,   1.742353018747219e-16,  -9.168728312250546e-17,  -1.742758101257896e-18,
   1.063856174724870e-19,   4.332912662950230e-21,   5.322406915944760e-01,  -1.162561565753409e-02,   1.610154475023963e-04,  -5.806481239336622e-07,   4.935280087912448e-09,
  -1.595638108308064e-10,  -4.604569448834791e-11,   5.312115488672062e-13,   6.631161719802117e-14,   1.724815378151988e-16,  -9.155797330149179e-17,  -1.736574104347784e-18,
   1.062441130453365e-19,   4.317607872835347e-21,   5.322411638040967e-01,  -1.162562077190052e-02,   1.610155310658047e-04,  -5.806527469821186e-07,   4.933264501771500e-09,
  -1.595310710064826e-10,  -4.604027282310316e-11,   5.312292285472562e-13,   6.629957663435354e-14,   1.722034308698718e-16,  -9.153745890367683e-17,  -1.735593460218117e-18,
   1.062216572970561e-19,   4.315180975129542e-21,   9.272632303528852e-01,  -1.906812872473811e-02,   1.752762664404578e-04,   3.245110637264499e-06,  -5.974315208369665e-08,
  -4.760200498691815e-10,  -7.917843453524922e-11,   2.565769764108879e-13,   2.019990858605531e-13,   7.241710922332590e-16,  -3.016174975177526e-16,  -5.100117517511564e-18,
   3.599462600322565e-19,   1.496144808375860e-20,   9.272795938088214e-01,  -1.906721759415316e-02,   1.752420692080090e-04,   3.244668881571880e-06,  -5.984855587977831e-08,
  -4.754864817171713e-10,  -7.867287500691454e-11,   2.584436674396215e-13,   2.007939179765695e-13,   7.014846971750604e-16,  -2.995069267535871e-16,  -5.005113582263984e-18,
   3.574279980546904e-19,   1.469400049820715e-20,   9.273084647090717e-01,  -1.906560999009346e-02,   1.751816808354859e-04,   3.243889811643161e-06,  -6.003397416869449e-08,
  -4.745422824114784e-10,  -7.778333874022480e-11,   2.616778286279743e-13,   1.986745167569416e-13,   6.618380064403752e-16,  -2.957954441501150e-16,  -4.839007607519298e-18,
   3.529855833150465e-19,   1.422656921833919e-20,   9.273433711465350e-01,  -1.906366622885472e-02,   1.751085789159544e-04,   3.242948460738993e-06,  -6.025721678573809e-08,
  -4.733959891380666e-10,  -7.671200803061854e-11,   2.654876159949445e-13,   1.961238527444332e-13,   6.145469337757672e-16,  -2.913290472533727e-16,  -4.640741344017721e-18,
   3.476160851670271e-19,   1.366893854382044e-20,   9.273772529300454e-01,  -1.906177943782999e-02,   1.750375296466076e-04,   3.242035357403446e-06,  -6.047292654468828e-08,
  -4.722784952929620e-10,  -7.567647482073969e-11,   2.690812246112580e-13,   1.936603858039526e-13,   5.693129304539145e-16,  -2.870157227425720e-16,  -4.450958336930850e-18,
   3.424064559157100e-19,   1.313548264315272e-20,   9.274045442261549e-01,  -1.906025959152235e-02,   1.749802338290873e-04,   3.241300307296298e-06,  -6.064597739013790e-08,
  -4.713749511143570e-10,  -7.484547491837866e-11,   2.719016788043619e-13,   1.916849027191934e-13,   5.333530671196773e-16,  -2.835571334381233e-16,  -4.299983425248849e-18,
   3.382121751959405e-19,   1.271133733139677e-20,   9.274225761491813e-01,  -1.905925536680737e-02,   1.749423447281495e-04,   3.240814861217922e-06,  -6.075997343735288e-08,
  -4.707763092629937e-10,  -7.429793402918438e-11,   2.737291542255566e-13,   1.903839609201664e-13,   5.098249447848553e-16,  -2.812796728659387e-16,  -4.201151588064001e-18,
   3.354420622874452e-19,   1.243379227905073e-20,   9.274318358849538e-01,  -1.905873966873571e-02,   1.749228778927299e-04,   3.240565642529768e-06,  -6.081840688445953e-08,
  -4.704683892595411e-10,  -7.401723003109659e-11,   2.746564991261511e-13,   1.897172303791544e-13,   4.978140187142176e-16,  -2.801125345613546e-16,  -4.150682873712776e-18,
   3.340199402445299e-19,   1.229209752950989e-20,   9.274350587380678e-01,  -1.905856017838249e-02,   1.749161008556794e-04,   3.240478912602771e-06,  -6.083872784481356e-08,
  -4.703611374954455e-10,  -7.391960548807115e-11,   2.749774994738633e-13,   1.894853858652411e-13,   4.936449220273465e-16,  -2.797066908358645e-16,  -4.133162212874033e-18,
   3.335250343175279e-19,   1.224291240940159e-20,   9.274355701565438e-01,  -1.905853169588179e-02,   1.749150253655279e-04,   3.240465150371328e-06,  -6.084195167862867e-08,
  -4.703441144523549e-10,  -7.390411747418647e-11,   2.750283538507245e-13,   1.894486056389064e-13,   4.929838851774195e-16,  -2.796423075131463e-16,  -4.130384079932600e-18,
   3.334465032609502e-19,   1.223511371652898e-20,   1.501161851771873e+00,  -2.467225782146501e-02,  -2.247987500486655e-04,   1.865101027848757e-05,   2.848899608928523e-07,
  -2.583293989386810e-08,  -5.032898155079336e-10,   3.950286471285575e-11,   9.817314718122617e-13,  -6.094384685954271e-14,  -1.945041551880476e-15,   9.196267932769659e-17,
   3.804790090772846e-18,  -1.329819921592394e-19,   1.501141090871019e+00,  -2.466709520322576e-02,  -2.246423191195910e-04,   1.862741704485522e-05,   2.842106335839239e-07,
  -2.575823495537967e-08,  -5.008664956344986e-10,   3.930852192616308e-11,   9.741919883004126e-13,  -6.050364466765382e-14,  -1.923950024011603e-15,   9.107618005542924e-17,
   3.750660216902464e-18,  -1.313974646198536e-19,   1.501104469408660e+00,  -2.465799096918955e-02,  -2.243665983366591e-04,   1.858584241656740e-05,   2.830146607409103e-07,
  -2.562672245266965e-08,  -4.966062020740580e-10,   3.896678420113914e-11,   9.609586757243645e-13,  -5.973053045611413e-14,  -1.886996564758977e-15,   8.952110486561519e-17,
   3.656006696476915e-18,  -1.286204246336736e-19,   1.501060205894155e+00,  -2.464699103849575e-02,  -2.240337114292472e-04,   1.853566526609862e-05,   2.815730878566478e-07,
  -2.546821581790108e-08,  -4.914812660472015e-10,   3.855556199616125e-11,   9.450759475250903e-13,  -5.880183513794826e-14,  -1.842757376054828e-15,   8.765624561963628e-17,
   3.543004496469706e-18,  -1.252944417983324e-19,   1.501017256093301e+00,  -2.463632191673567e-02,  -2.237110915660086e-04,   1.848705379066163e-05,   2.801784463716789e-07,
  -2.531488290858514e-08,  -4.865338534671433e-10,   3.815845164321529e-11,   9.297812594084640e-13,  -5.790669430462653e-14,  -1.800273413179445e-15,   8.586206454646888e-17,
   3.434811600542129e-18,  -1.220989936876898e-19,   1.500982670933438e+00,  -2.462773375314849e-02,  -2.234515800735165e-04,   1.844796426508090e-05,   2.790583787292544e-07,
  -2.519174753089462e-08,  -4.825681015265148e-10,   3.784004123088433e-11,   9.175483576123060e-13,  -5.719015762028371e-14,  -1.766377821762671e-15,   8.442822950808897e-17,
   3.348722730260508e-18,  -1.195485446409719e-19,   1.500959824839286e+00,  -2.462206214570341e-02,  -2.232802886280839e-04,   1.842216943075199e-05,   2.783199366999677e-07,
  -2.511057119599113e-08,  -4.799572712711849e-10,   3.763037162541410e-11,   9.095080919770106e-13,  -5.671891472211070e-14,  -1.744140244174728e-15,   8.348639697082186e-17,
   3.292356459874134e-18,  -1.178748321046168e-19,   1.500948094490998e+00,  -2.461915052320438e-02,  -2.231923807003543e-04,   1.840893330787947e-05,   2.779412296227771e-07,
  -2.506894171780218e-08,  -4.786194672577198e-10,   3.752292159626458e-11,   9.053922886761013e-13,  -5.647759716596688e-14,  -1.732769454741525e-15,   8.300445319103922e-17,
   3.263569534371348e-18,  -1.170188695641682e-19,   1.500944011988257e+00,  -2.461813726854550e-02,  -2.231617928368524e-04,   1.840432806584544e-05,   2.778094995788655e-07,
  -2.505446149393450e-08,  -4.781543064162715e-10,   3.748555845931562e-11,   9.039618522343163e-13,  -5.639371377051527e-14,  -1.728819571908392e-15,   8.283698351501325e-17,
   3.253575352086502e-18,  -1.167215110831219e-19,   1.500943364168025e+00,  -2.461797648668565e-02,  -2.231569394053651e-04,   1.840359735859960e-05,   2.777885997463224e-07,
  -2.505216412302677e-08,  -4.780805142902063e-10,   3.747963114408691e-11,   9.037349615957173e-13,  -5.638040782046615e-14,  -1.728193150967391e-15,   8.281042144146110e-17,
   3.251990615863521e-18,  -1.166743512891094e-19,   9.303859989163978e-03,  -2.027809738472929e-04,   3.473770625795280e-06,  -3.780814556031229e-08,   5.720499609935163e-10,
  -2.517111063614902e-11,   8.855940275388493e-14,   2.594873057593011e-14,   1.456382961182776e-16,  -4.181602046053100e-17,   9.304355316739123e-03,  -2.027972391987302e-04,
   3.474260177255612e-06,  -3.784334116318580e-08,   5.722453250015812e-10,  -2.509677332351730e-11,   8.909687456448714e-14,   2.574642085307750e-14,   1.435445915540618e-16,
  -4.136745106341328e-17,   9.305168527677680e-03,  -2.028239521219713e-04,   3.475063977777728e-06,  -3.790104530456819e-08,   5.725668534678736e-10,  -2.497516592705736e-11,
   8.997336904228548e-14,   2.541591999058859e-14,   1.401384429227214e-16,  -4.063605999814083e-17,   9.306031476060954e-03,  -2.028523111505164e-04,   3.475917039107675e-06,
  -3.796217197937812e-08,   5.729091117400823e-10,  -2.484671268560580e-11,   9.089549135378322e-14,   2.506742922578448e-14,   1.365660833648986e-16,  -3.986676330570011e-17,
   9.306710670739472e-03,  -2.028746403817228e-04,   3.476588523870238e-06,  -3.801020541702307e-08,   5.731792574554664e-10,  -2.474603892429786e-11,   9.161551970351438e-14,
   2.479474745246006e-14,   1.337846577816394e-16,  -3.926618948438953e-17,   9.307102667220530e-03,  -2.028875312341515e-04,   3.476976099433354e-06,  -3.803789702126679e-08,
   5.733354779227138e-10,  -2.468810584365139e-11,   9.202879487838992e-14,   2.463800916714865e-14,   1.321914044473683e-16,  -3.892152697241870e-17,   9.307249869568299e-03,
  -2.028923726740031e-04,   3.477121647100800e-06,  -3.804828993837157e-08,   5.733941994813347e-10,  -2.466638303797762e-11,   9.218355673423386e-14,   2.457927147590803e-14,
   1.315953734152486e-16,  -3.879246828697536e-17,   9.307274270663414e-03,  -2.028931752539717e-04,   3.477145774194999e-06,  -3.805001242023569e-08,   5.734039365407280e-10,
  -2.466278383985988e-11,   9.220918823201182e-14,   2.456954113813374e-14,   1.314966912834561e-16,  -3.877109421496663e-17,   8.460494363906756e-02,  -1.837921654590392e-03,
   3.097765574154819e-05,  -3.129466182985837e-07,   4.373096203091088e-09,  -2.172309664940517e-10,   4.538972397156093e-13,   2.548865803893650e-13,   1.236401431931757e-15,
  -3.998101081488668e-16,   8.460935950771813e-02,  -1.838056327637364e-03,   3.098139550013212e-05,  -3.132496092507060e-07,   4.374118194284790e-09,  -2.164999103044398e-10,
   4.584155637447681e-13,   2.529535881989807e-13,   1.216447452063912e-15,  -3.954710340029226e-16,   8.461660925661511e-02,  -1.838277507316740e-03,   3.098753556656517e-05,
  -3.137462786410783e-07,   4.375802715739576e-09,  -2.153038644724978e-10,   4.657773560519070e-13,   2.497959684193872e-13,   1.183986873472460e-15,  -3.883965292570138e-16,
   8.462430232497463e-02,  -1.838512321071604e-03,   3.099405153380328e-05,  -3.142722807631202e-07,   4.377599261197236e-09,  -2.140403229819300e-10,   4.735134527778418e-13,
   2.464667297205682e-13,   1.149944450396935e-15,  -3.809558384847170e-16,   8.463035718996338e-02,  -1.838697211154079e-03,   3.099918027472646e-05,  -3.146855231502995e-07,
   4.379019732077902e-09,  -2.130499172358543e-10,   4.795476165463327e-13,   2.438619035507003e-13,   1.123440676537829e-15,  -3.751473799022120e-16,   8.463385172318771e-02,
  -1.838803951051104e-03,   3.100214042869980e-05,  -3.149237237639268e-07,   4.379842139454418e-09,  -2.124799366297894e-10,   4.830084479162592e-13,   2.423647163529572e-13,
   1.108259416765783e-15,  -3.718141042318579e-16,   8.463516398393905e-02,  -1.838844039785152e-03,   3.100325204465133e-05,  -3.150131157858971e-07,   4.380151456515562e-09,
  -2.122662054643263e-10,   4.843039553400045e-13,   2.418036593607763e-13,   1.102580268964364e-15,  -3.705659860842008e-16,   8.463538151146011e-02,  -1.838850685427461e-03,
   3.100343631347745e-05,  -3.150279309103105e-07,   4.380202756320716e-09,  -2.122307923941800e-10,   4.845184899114595e-13,   2.417107168180605e-13,   1.101640004405593e-15,
  -3.703592801463800e-16,   2.401993726976709e-01,  -5.178124907563075e-03,   8.392132888942657e-05,  -6.849289070852420e-07,   7.016811336646409e-09,  -5.475414994427803e-10,
  -6.850652988904543e-13,   8.411407646627267e-13,   3.153964928984574e-15,  -1.278814909962029e-15,   2.402113273524262e-01,  -5.178419995904183e-03,   8.392731268279002e-05,
  -6.856877908440411e-07,   7.015481665122313e-09,  -5.451257375431577e-10,  -6.737481117694618e-13,   8.349647362255718e-13,   3.092833266637664e-15,  -1.264679012255030e-15,
   2.402309534678881e-01,  -5.178904660649712e-03,   8.393713526892335e-05,  -6.869311769599632e-07,   7.013315600939042e-09,  -5.411729725223731e-10,  -6.553397936870272e-13,
   8.248769105112344e-13,   2.993416871288104e-15,  -1.241634568854625e-15,   2.402517791290499e-01,  -5.179419238882013e-03,   8.394755673858372e-05,  -6.882471908538437e-07,
   7.011039940532084e-09,  -5.369965264706983e-10,  -6.360376548321632e-13,   8.142421073523813e-13,   2.889197563346199e-15,  -1.217401337954947e-15,   2.402681696389505e-01,
  -5.179824439859626e-03,   8.395575773152893e-05,  -6.892805063318838e-07,   7.009265309980384e-09,  -5.337224413073444e-10,  -6.210125296282024e-13,   8.059222823338458e-13,
   2.808087617613280e-15,  -1.198486944735643e-15,   2.402776291652817e-01,  -5.180058379437110e-03,   8.396049038229285e-05,  -6.898758949852650e-07,   7.008247644237102e-09,
  -5.318380182199054e-10,  -6.124073088502805e-13,   8.011406365685986e-13,   2.761640210900575e-15,  -1.187633779437848e-15,   2.402811813573293e-01,  -5.180146243105470e-03,
   8.396226748268035e-05,  -6.900992885111824e-07,   7.007866726476579e-09,  -5.311313636721022e-10,  -6.091884072316892e-13,   7.993488302421503e-13,   2.744267008351000e-15,
  -1.183570117867950e-15,   2.402817701864251e-01,  -5.180160808664310e-03,   8.396256205950176e-05,  -6.901363096513230e-07,   7.007803648469958e-09,  -5.310142764327972e-10,
  -6.086554836355833e-13,   7.990520102442004e-13,   2.741390745124898e-15,  -1.182897129819621e-15,   4.881206915792627e-01,  -1.036290676953052e-02,   1.542862341698494e-04,
  -5.695955663505963e-07,  -6.850235267320787e-09,  -9.090385683845485e-10,  -6.048164589820530e-12,   2.117980934350545e-12,   6.667149583703032e-15,  -3.301815890244393e-15,
   4.881426357367614e-01,  -1.036315432225740e-02,   1.542803137127696e-04,  -5.708381152209766e-07,  -6.862865387396129e-09,  -9.029616609974605e-10,  -6.024250201086846e-12,
   2.102052470281149e-12,   6.537261027359915e-15,  -3.264638292634538e-15,   4.881786600035224e-01,  -1.036356109170928e-02,   1.542705866164321e-04,  -5.728718138536715e-07,
  -6.883564261695207e-09,  -8.930192060107147e-10,  -5.985352160323988e-12,   2.076037653692966e-12,   6.326262894977905e-15,  -3.204047520106888e-15,   4.882168836929442e-01,
  -1.036399320954647e-02,   1.542602549511638e-04,  -5.750213904733269e-07,  -6.905479400575428e-09,  -8.825152351608077e-10,  -5.944565920430554e-12,   2.048615614067099e-12,
   6.105390070839211e-15,  -3.140353236687038e-15,   4.882469653275580e-01,  -1.036433365268146e-02,   1.542521163088155e-04,  -5.767070985951616e-07,  -6.922692233090250e-09,
  -8.742815510071743e-10,  -5.912817270312971e-12,   2.027165185405179e-12,   5.933723644618703e-15,  -3.090654871988450e-15,   4.882643257825732e-01,  -1.036453027477170e-02,
   1.542474163086729e-04,  -5.776775454255817e-07,  -6.932612343280930e-09,  -8.695429171268337e-10,  -5.894634054019909e-12,   2.014837953209001e-12,   5.835511717532263e-15,
  -3.062144097041727e-15,   4.882708447598272e-01,  -1.036460413582964e-02,   1.542456508394349e-04,  -5.780415032406192e-07,  -6.936334853043606e-09,  -8.677660005463343e-10,
  -5.887832347536894e-12,   2.010218800093079e-12,   5.798793980174533e-15,  -3.051470244232134e-15,   4.882719253711789e-01,  -1.036461638080763e-02,   1.542453581574475e-04,
  -5.781018104887918e-07,  -6.936951775891881e-09,  -8.674715823023528e-10,  -5.886706250754570e-12,   2.009453628069995e-12,   5.792716007896398e-15,  -3.049702597590975e-15,
   8.540185170834388e-01,  -1.752769054158808e-02,   2.078674244651037e-04,   2.124736350398869e-06,  -8.412505841786689e-08,  -1.622150302159157e-09,   5.139174585302932e-12,
   4.752429647954642e-12,   1.631465661764243e-14,  -9.202508266517426e-15,   8.540479538331017e-01,  -1.752679117775375e-02,   2.077956614051741e-04,   2.122541276575154e-06,
  -8.411336268089323e-08,  -1.608648490815159e-09,   5.200671146790028e-12,   4.708222965650424e-12,   1.614216162804969e-14,  -9.091744215249698e-15,   8.540962716527983e-01,
  -1.752531537755110e-02,   2.076778581705075e-04,   2.118951306745642e-06,  -8.409406918015235e-08,  -1.586576684705332e-09,   5.301150951076701e-12,   4.636050151249270e-12,
   1.586248996609212e-14,  -8.911307426976331e-15,   8.541475305795116e-01,  -1.752375032213227e-02,   2.075528699789025e-04,   2.115160501831720e-06,  -8.407347120368738e-08,
  -1.563283540555888e-09,   5.407125212234902e-12,   4.560009534372333e-12,   1.557045263912983e-14,  -8.721739825236429e-15,   8.541878643739057e-01,  -1.752251925262373e-02,
   2.074545109847112e-04,   2.112190422089350e-06,  -8.405716950601623e-08,  -1.545043118522261e-09,   5.490066456469638e-12,   4.500554197456062e-12,   1.534399317261345e-14,
  -8.573906930643394e-15,   8.542111388892025e-01,  -1.752180903324013e-02,   2.073977490477406e-04,   2.110481650430342e-06,  -8.404772510701451e-08,  -1.534552734385990e-09,
   5.537750024616910e-12,   4.466396588682290e-12,   1.521463929230977e-14,  -8.489130534685429e-15,   8.542198781518573e-01,  -1.752154238691063e-02,   2.073764349367499e-04,
   2.109840993526963e-06,  -8.404417177867362e-08,  -1.530620379320866e-09,   5.555621167481471e-12,   4.453599322209652e-12,   1.516631744825083e-14,  -8.457397977984968e-15,
   8.542213267807576e-01,  -1.752149818900123e-02,   2.073729018473741e-04,   2.109734848393808e-06,  -8.404358240189397e-08,  -1.529968898235129e-09,   5.558581748539244e-12,
   4.451479533402014e-12,   1.515832065913032e-14,  -8.452143214264920e-15,   1.400348278372035e+00,  -2.553903264944845e-02,   8.294545483001722e-06,   1.882866462805464e-05,
  -2.543573512395087e-07,  -2.341224333424255e-08,   6.614745432659102e-10,   3.058500364355340e-11,  -1.392529051649477e-12,  -3.812629073392482e-14,   1.400349037451587e+00,
  -2.553110921042650e-02,   8.084984868122685e-06,   1.879609122298772e-05,  -2.530069433373209e-07,  -2.332381226188026e-08,   6.562515476803312e-10,   3.039805094776817e-11,
  -1.376657119033235e-12,  -3.781255736252287e-14,   1.400350263251752e+00,  -2.551811148095529e-02,   7.741771262426433e-06,   1.874270643554281e-05,  -2.507979174147196e-07,
  -2.317903675220592e-08,   6.477217922651491e-10,   3.009228393452711e-11,  -1.350788399491208e-12,  -3.729958111628588e-14,   1.400351536302980e+00,  -2.550433329562615e-02,
   7.378698876080501e-06,   1.868618277696582e-05,  -2.484646525023277e-07,  -2.302595886985378e-08,   6.387314370749521e-10,   2.976939494150464e-11,  -1.323593068974925e-12,
  -3.675808273910107e-14,   1.400352518238333e+00,  -2.549349948910433e-02,   7.093756127885821e-06,   1.864178632034962e-05,  -2.466360660550569e-07,  -2.290587578057391e-08,
   6.316994655637158e-10,   2.951640104560922e-11,  -1.302372390179291e-12,  -3.633395338939310e-14,   1.400353076941307e+00,  -2.548725097102367e-02,   6.929628955650093e-06,
   1.861619945854866e-05,  -2.455838322119552e-07,  -2.283672946962941e-08,   6.276585337631346e-10,   2.937084176502445e-11,  -1.290198137849447e-12,  -3.608999446708841e-14,
   1.400353285230720e+00,  -2.548490532391969e-02,   6.868057758748957e-06,   1.860659798415785e-05,  -2.451892888027409e-07,  -2.281079378443485e-08,   6.261443953917645e-10,
   2.931626743928600e-11,  -1.285640261194251e-12,  -3.599853935022916e-14,   1.400353319678092e+00,  -2.548451653802515e-02,   6.857854624812967e-06,   1.860500675281896e-05,
  -2.451239182008037e-07,  -2.280649612557620e-08,   6.258935776650364e-10,   2.930722542517454e-11,  -1.284885448181403e-12,  -3.598338747239308e-14,   8.545614643015557e-03,
  -1.766863089916543e-04,   3.059409832214097e-06,  -3.232843470306075e-08,   1.456314633633058e-10,  -1.515501583836459e-11,   6.655999027429348e-13,   9.059781154614344e-15,
  -9.853898995067082e-16,  -7.405975599747966e-18,   8.546050285342381e-03,  -1.767001860746503e-04,   3.059541957448463e-06,  -3.234977849518765e-08,   1.470082083291434e-10,
  -1.512854850821392e-11,   6.618682544031095e-13,   9.021774696386611e-15,  -9.759170680770534e-16,  -7.409352823066546e-18,   8.546765477573213e-03,  -1.767229740871487e-04,
   3.059759698206233e-06,  -3.238479081478295e-08,   1.492627031962712e-10,  -1.508518021609400e-11,   6.557688968186190e-13,   8.959375994033655e-15,  -9.604592275890162e-16,
  -7.413889646360453e-18,   8.547524372031550e-03,  -1.767471628067388e-04,   3.059991872035794e-06,  -3.242190498455775e-08,   1.516472334114122e-10,  -1.503927470592159e-11,
   6.493332133090915e-13,   8.893161392259186e-15,  -9.441834554698196e-16,  -7.417350972621041e-18,   8.548121640637821e-03,  -1.767662058799352e-04,   3.060175413682114e-06,
  -3.245108756288175e-08,   1.535183403806618e-10,  -1.500322762851364e-11,   6.442943972640859e-13,   8.841048244577882e-15,  -9.314651773258465e-16,  -7.419108663993935e-18,
   8.548466341925721e-03,  -1.767771985836676e-04,   3.060281667218845e-06,  -3.246791880164781e-08,   1.545959814922913e-10,  -1.498245654345865e-11,   6.413968231680507e-13,
   8.810972464271384e-15,  -9.241614511657421e-16,  -7.419739904784089e-18,   8.548595781802788e-03,  -1.767813269395704e-04,   3.060321628428647e-06,  -3.247423709749750e-08,
   1.550002291655314e-10,  -1.497466291608841e-11,   6.403107213227517e-13,   8.799678719135448e-15,  -9.214256588190928e-16,  -7.419905020602989e-18,   8.548617238374081e-03,
  -1.767820112993069e-04,   3.060328255837921e-06,  -3.247528433991074e-08,   1.550672170068708e-10,  -1.497337133373535e-11,   6.401307880052933e-13,   8.797806621162320e-15,
  -9.209725218644363e-16,  -7.419928608880221e-18,   7.772637873859507e-02,  -1.604246927242628e-03,   2.750711169536739e-05,  -2.748042755238542e-07,   6.829731970674638e-10,
  -1.291607898670237e-10,   6.094893214690661e-12,   8.900896752983407e-14,  -9.512619366165256e-15,  -6.657140675810331e-17,   7.773029451954046e-02,  -1.604364888425517e-03,
   2.750776594184076e-05,  -2.749858862781143e-07,   6.955580602503607e-10,  -1.289002723283852e-10,   6.058861568701238e-12,   8.866611854578446e-14,  -9.421535530831646e-15,
  -6.664824296097976e-17,   7.773672298646284e-02,  -1.604558596332702e-03,   2.750884762623183e-05,  -2.752837640559147e-07,   7.161635445239600e-10,  -1.284733321189729e-10,
   5.999966940535664e-12,   8.810307001978385e-14,  -9.272909545402177e-15,  -6.676397176846955e-17,   7.774354419419685e-02,  -1.604764210826394e-03,   2.751000573269946e-05,
  -2.755994747558670e-07,   7.379535567115050e-10,  -1.280213234944821e-10,   5.937823271926031e-12,   8.750537184745292e-14,  -9.116426424789198e-15,  -6.687278913941026e-17,
   7.774891259867599e-02,  -1.604926085094431e-03,   2.751092465224736e-05,  -2.758476799481464e-07,   7.550490010432431e-10,  -1.276663202399404e-10,   5.889166801130170e-12,
   8.703480775258356e-14,  -8.994151976167900e-15,  -6.694843848015200e-17,   7.775201084130837e-02,  -1.605019527767284e-03,   2.751145797386154e-05,  -2.759908195898270e-07,
   7.648937620232205e-10,  -1.274617335448047e-10,   5.861186422219379e-12,   8.676317205172395e-14,  -8.923935507945383e-15,  -6.698813537120060e-17,   7.775317426817889e-02,
  -1.605054620551941e-03,   2.751165880699710e-05,  -2.760445502234982e-07,   7.685865380326237e-10,  -1.273849645202502e-10,   5.850698411873892e-12,   8.666115866911405e-14,
  -8.897634576659553e-15,  -6.700229819495533e-17,   7.775336712315008e-02,  -1.605060437901247e-03,   2.751169212778666e-05,  -2.760534558048425e-07,   7.691984560919411e-10,
  -1.273722418737394e-10,   5.848960870061701e-12,   8.664424790025951e-14,  -8.893278300466250e-15,  -6.700460677271447e-17,   2.207791968666929e-01,  -4.538521654582918e-03,
   7.603271710351914e-05,  -6.534861175020247e-07,  -2.309054261814150e-09,  -3.111450806131531e-10,   1.776237169021983e-11,   2.906397722311485e-13,  -3.067113650240033e-14,
  -1.821223827117721e-16,   2.207900133346084e-01,  -4.538802179691439e-03,   7.603095190757538e-05,  -6.539217086840653e-07,  -2.272510104834442e-09,  -3.102917059703638e-10,
   1.764618753519032e-11,   2.896910838466352e-13,  -3.037785975182664e-14,  -1.827429384447944e-16,   2.208077701689032e-01,  -4.539262839805394e-03,   7.602807617425883e-05,
  -6.546359307124067e-07,  -2.212693037546365e-09,  -3.088928118735751e-10,   1.745628025278174e-11,   2.881316560382492e-13,  -2.989933620090690e-14,  -1.837222888283956e-16,
   2.208266113421266e-01,  -4.539751816062211e-03,   7.602505480567702e-05,  -6.553925923558461e-07,  -2.149461125374078e-09,  -3.074112769240842e-10,   1.725589444344800e-11,
   2.864743385819715e-13,  -2.939555680720251e-14,  -1.847085333962925e-16,   2.208414393003336e-01,  -4.540136773354421e-03,   7.602269865274827e-05,  -6.559872333434960e-07,
  -2.099869505529560e-09,  -3.062473299181034e-10,   1.709899745171255e-11,   2.851681668640865e-13,  -2.900193814070787e-14,  -1.854468755481944e-16,   2.208499967474977e-01,
  -4.540358991972146e-03,   7.602134754624079e-05,  -6.563300695793425e-07,  -2.071318072068876e-09,  -3.055764071093121e-10,   1.700877172045991e-11,   2.844136260324459e-13,
  -2.877591337887132e-14,  -1.858579766206109e-16,   2.208532101431760e-01,  -4.540442447141661e-03,   7.602084183027328e-05,  -6.564587432559488e-07,  -2.060609719120944e-09,
  -3.053246227960549e-10,   1.697495189495688e-11,   2.841301540064203e-13,  -2.869125370247902e-14,  -1.860095305190045e-16,   2.208537428089352e-01,  -4.540456281551083e-03,
   7.602075808697925e-05,  -6.564800693452535e-07,  -2.058835341333569e-09,  -3.052828940611427e-10,   1.696934898065195e-11,   2.840831574247558e-13,  -2.867723146872329e-14,
  -1.860345045013242e-16,   4.490899567478807e-01,  -9.159156686609495e-03,   1.462210659619484e-04,  -8.133137150253038e-07,  -2.200706289620684e-08,  -4.234154787407621e-10,
   3.968837937304145e-11,   6.872119479565319e-13,  -7.731676209905078e-14,  -3.181451345821994e-16,   4.491107282225335e-01,  -9.159505973198515e-03,   1.462027340954130e-04,
  -8.138991876901169e-07,  -2.192579733384243e-08,  -4.213896121957556e-10,   3.939579017040274e-11,   6.854821149443195e-13,  -7.656319865102899e-14,  -3.219966827818044e-16,
   4.491448261478316e-01,  -9.160079560352372e-03,   1.461726884352003e-04,  -8.148582638055773e-07,  -2.179283002948238e-08,  -4.180676229265599e-10,   3.891758417531077e-11,
   6.826290761024114e-13,  -7.533373753042212e-14,  -3.281832249222223e-16,   4.491810042219582e-01,  -9.160688420445099e-03,   1.461408742050279e-04,  -8.158731038193167e-07,
  -2.165234211179350e-08,  -4.145479129825539e-10,   3.841304891696888e-11,   6.795840578709910e-13,  -7.403950457742013e-14,  -3.345642598409897e-16,   4.492094747773594e-01,
  -9.161167769881066e-03,   1.461158842987096e-04,  -8.166697526352865e-07,  -2.154221089719761e-08,  -4.117816429324369e-10,   3.801805166675984e-11,   6.771749890992176e-13,
  -7.302836439272618e-14,  -3.394549734660769e-16,   4.492259049791424e-01,  -9.161444481209100e-03,   1.461014813621777e-04,  -8.171286988369684e-07,  -2.147882533897992e-08,
  -4.101866854276691e-10,   3.779091960487759e-11,   6.757796765577452e-13,  -7.244777861510176e-14,  -3.422254222249831e-16,   4.492320745487082e-01,  -9.161548402170117e-03,
   1.460960765459160e-04,  -8.173008836460534e-07,  -2.145505613667291e-08,  -4.095880490711893e-10,   3.770578550466540e-11,   6.752547873924911e-13,  -7.223032119972542e-14,
  -3.432559705809055e-16,   4.492330972360756e-01,  -9.161565629248032e-03,   1.460951808116270e-04,  -8.173294176174137e-07,  -2.145111777518654e-08,  -4.094888316274141e-10,
   3.769168154291122e-11,   6.751677303485367e-13,  -7.219430393235432e-14,  -3.434262841123609e-16,   7.873598773370727e-01,  -1.578785216858299e-02,   2.243572910074247e-04,
   5.684536945301228e-07,  -1.054766049502106e-07,  -1.256194993918131e-10,   1.013454535824186e-10,   9.612587473139482e-13,  -1.944251414798018e-13,   1.008953169160563e-16,
   7.873916262959240e-01,  -1.578761002438076e-02,   2.242684028883081e-04,   5.682991391433326e-07,  -1.052689188589340e-07,  -1.227512439183318e-10,   1.006125365606684e-10,
   9.610683573211142e-13,  -1.923916301955962e-13,   7.393998217051946e-17,   7.874437383943106e-01,  -1.578721254748956e-02,   2.241226041060162e-04,   5.680483590064698e-07,
  -1.049290773116798e-07,  -1.180433962214310e-10,   9.941507222957303e-11,   9.606608612034877e-13,  -1.890740585321204e-13,   3.033714055455507e-17,   7.874990211933555e-01,
  -1.578679085037676e-02,   2.239680704612920e-04,   5.677862671370354e-07,  -1.045699813195307e-07,  -1.130492806234378e-10,   9.815223556150030e-11,   9.601007231905312e-13,
  -1.855819306231888e-13,  -1.505595399278853e-17,   7.875425202441104e-01,  -1.578645901311324e-02,   2.238465745638958e-04,   5.675828987680620e-07,  -1.042884547492020e-07,
  -1.091198931190154e-10,   9.716397364901285e-11,   9.595683918905329e-13,  -1.828538144904431e-13,  -5.015537864474250e-17,   7.875676208700800e-01,  -1.578626751947728e-02,
   2.237765060730863e-04,   5.674666928895133e-07,  -1.041264134988199e-07,  -1.068525984247766e-10,   9.659586371067741e-11,   9.592248214248749e-13,  -1.812874265606376e-13,
  -7.016356660415331e-17,   7.875770457383255e-01,  -1.578619561474764e-02,   2.237502039399741e-04,   5.674232760288577e-07,  -1.040656471387613e-07,  -1.060012915962655e-10,
   9.638295429709277e-11,   9.590889750645735e-13,  -1.807007513851357e-13,  -7.763015792899374e-17,   7.875786080099918e-01,  -1.578618369566921e-02,   2.237458444743186e-04,
   5.674160906471308e-07,  -1.040555785534235e-07,  -1.058601798614587e-10,   9.634768372720231e-11,   9.590660970942832e-13,  -1.806035816031147e-13,  -7.886539602836702e-17,
   1.299619592336999e+00,  -2.466702392477029e-02,   1.977194168781328e-04,   1.206738807145416e-05,  -5.231122811809913e-07,  -2.806448488281360e-09,   8.369934021745696e-10,
  -1.548923311282655e-11,  -9.634112586838862e-13,   4.628700700471320e-14,   1.299646851023871e+00,  -2.466188753480484e-02,   1.972826087090405e-04,   1.206303605782636e-05,
  -5.213701960347562e-07,  -2.849248959578341e-09,   8.332319231404929e-10,  -1.526885547875076e-11,  -9.597121231411959e-13,   4.565634944551488e-14,   1.299691557208902e+00,
  -2.465345674420222e-02,   1.965665783889927e-04,   1.205584893292581e-05,  -5.185160431283960e-07,  -2.919047605785962e-09,   8.270676672226096e-10,  -1.490935217435736e-11,
  -9.536099935301301e-13,   4.462805641463118e-14,   1.299738935052434e+00,  -2.464451296695830e-02,   1.958082549099864e-04,   1.204816521089715e-05,  -5.154953877994090e-07,
  -2.992479708201049e-09,   8.205416655096085e-10,  -1.453097904666543e-11,  -9.470959223678014e-13,   4.354647469805333e-14,   1.299776179082688e+00,  -2.463747557949663e-02,
   1.952124914526185e-04,   1.204207655871753e-05,  -5.131237718632931e-07,  -3.049817356053889e-09,   8.154163815774903e-10,  -1.423542191837751e-11,  -9.419414619370941e-13,
   4.270212132465350e-14,   1.299797656286779e+00,  -2.463341473341450e-02,   1.948690815394425e-04,   1.203854610015408e-05,  -5.117573306015000e-07,  -3.082726811607914e-09,
   8.124627856759097e-10,  -1.406573819107945e-11,  -9.389557399816176e-13,   4.221756624228705e-14,   1.299805717968842e+00,  -2.463188995286368e-02,   1.947402064276949e-04,
   1.203721725221662e-05,  -5.112446460794371e-07,  -3.095050467807462e-09,   8.113544961706431e-10,  -1.400218768842410e-11,  -9.378325175779074e-13,   4.203612715794045e-14,
   1.299807054138124e+00,  -2.463163720433994e-02,   1.947188476849069e-04,   1.203699681194965e-05,  -5.111596838406722e-07,  -3.097091489496233e-09,   8.111708243546119e-10,
  -1.399166210485086e-11,  -9.376462195482676e-13,   4.200607823112296e-14,   7.885395872364719e-03,  -1.537404107148782e-04,   2.678341080875455e-06,  -3.153216296522202e-08,
   4.845972288328522e-12,   4.547879205181544e-13,   5.155579618339818e-13,  -1.633293093151521e-14,  -3.719679234212451e-16,   3.009179040538157e-17,   7.885777040726679e-03,
  -1.537538716594226e-04,   2.678351345526676e-06,  -3.153190628391823e-08,   5.928912840067933e-12,   4.082880532678388e-13,   5.140780800779767e-13,  -1.618729191167615e-14,
  -3.718877531749849e-16,   2.977172754674059e-17,   7.886402792334738e-03,  -1.537759699902405e-04,   2.678368859357007e-06,  -3.153153177620377e-08,   7.704453409552755e-12,
   3.322600826659236e-13,   5.116490205749426e-13,  -1.594936623140154e-14,  -3.717255060046676e-16,   2.924905181731389e-17,   7.887066765983716e-03,  -1.537994180509906e-04,
   2.678388342839873e-06,  -3.153119793189785e-08,   9.585338747866895e-12,   2.520072412230496e-13,   5.090721994583347e-13,  -1.569848557502747e-14,  -3.715121057875531e-16,
   2.869819151939704e-17,   7.887589318812534e-03,  -1.538178718212860e-04,   2.678404327430610e-06,  -3.153098106314355e-08,   1.106336097317765e-11,   1.891499233555950e-13,
   5.070446979541292e-13,  -1.550217852773253e-14,  -3.713146031691695e-16,   2.826736008378009e-17,   7.887890895110721e-03,  -1.538285218642794e-04,   2.678413813199282e-06,
  -3.153087424618713e-08,   1.191545695652647e-11,   1.529944778636004e-13,   5.058747877067850e-13,  -1.538934036629998e-14,  -3.711888733253567e-16,   2.801979768080679e-17,
   7.888004140169897e-03,  -1.538325210636977e-04,   2.678417424460279e-06,  -3.153083759699025e-08,   1.223525746396743e-11,   1.394405283166307e-13,   5.054355140988986e-13,
  -1.534705424489742e-14,  -3.711394520372598e-16,   2.792703910914564e-17,   7.888022912167907e-03,  -1.538331839883757e-04,   2.678418025676615e-06,  -3.153083170435005e-08,
   1.228826000736939e-11,   1.371949678888201e-13,   5.053627003198524e-13,  -1.534004923350830e-14,  -3.711311435328883e-16,   2.791167377921282e-17,   7.172869032206793e-02,
  -1.397337843696611e-03,   2.421636687193018e-05,  -2.763557909510074e-07,  -4.085397300604542e-10,   1.425312006173384e-11,   4.710485991696977e-12,  -1.542005234967155e-13,
  -3.509218113819511e-15,   2.892386382015477e-16,   7.173213590098308e-02,  -1.397455768144853e-03,   2.421607398862603e-05,  -2.763391908576972e-07,  -3.986507606904099e-10,
   1.381451146188415e-11,   4.696503524498586e-12,  -1.528003349318564e-13,  -3.509488222430860e-15,   2.861745746772739e-16,   7.173779235538688e-02,  -1.397649355947086e-03,
   2.421559922337295e-05,  -2.763123811017744e-07,  -3.824379855241105e-10,   1.309743627281690e-11,   4.673550010230277e-12,  -1.505128467912662e-13,  -3.509625964317337e-15,
   2.811706478981362e-16,   7.174379426247278e-02,  -1.397854761844375e-03,   2.421510367604377e-05,  -2.762845329240214e-07,  -3.652642893774175e-10,   1.234058995914379e-11,
   4.649196344016511e-12,  -1.481007432876020e-13,  -3.509360529139065e-15,   2.758966421186165e-16,   7.174851777472784e-02,  -1.398016413278123e-03,   2.421471962006868e-05,
  -2.762630486956662e-07,  -3.517697207547919e-10,   1.174785255184484e-11,   4.630031540949162e-12,  -1.462132952450258e-13,  -3.508856642887629e-15,   2.717716298266834e-16,
   7.175124379802092e-02,  -1.398109703861957e-03,   2.421450035396991e-05,  -2.762508226441102e-07,  -3.439902469264951e-10,   1.140693315867062e-11,   4.618971943797009e-12,
  -1.451283637491262e-13,  -3.508448581520612e-15,   2.694012634217464e-16,   7.175226744537395e-02,  -1.398144735099953e-03,   2.421441846701162e-05,  -2.762462642728297e-07,
  -3.410705847150732e-10,   1.127913356984265e-11,   4.614819117763031e-12,  -1.447217820784951e-13,  -3.508273304268659e-15,   2.685131031798596e-16,   7.175243712949604e-02,
  -1.398150542013102e-03,   2.421440491679133e-05,  -2.762455103778318e-07,  -3.405866937166347e-10,   1.125796050395623e-11,   4.614130736332788e-12,  -1.446544286132771e-13,
  -3.508243089369472e-15,   2.683659799588390e-16,   2.037906553600339e-01,  -3.962572024472235e-03,   6.784172623351946e-05,  -7.162341822188159e-07,  -4.163244000908381e-09,
   1.081054146914223e-10,   1.354911086515732e-11,  -4.794083953263146e-13,  -1.067496863899039e-14,   9.265481401270788e-16,   2.038003029136170e-01,  -3.962877299728203e-03,
   6.783833221075020e-05,  -7.160917711859409e-07,  -4.134829247600358e-09,   1.067439179776649e-10,   1.350641846649719e-11,  -4.749209391402141e-13,  -1.068353532523613e-14,
   9.168126884341104e-16,   2.038161406112250e-01,  -3.963378417180601e-03,   6.783277774745312e-05,  -7.158593514695702e-07,  -4.088247768618488e-09,   1.045183265090344e-10,
   1.343631341195420e-11,  -4.675894868769776e-13,  -1.069653155018782e-14,   9.009119984976027e-16,   2.038329451945310e-01,  -3.963910085641982e-03,   6.782690762350346e-05,
  -7.156145942651281e-07,  -4.038910844975549e-09,   1.021697067020191e-10,   1.336190293153545e-11,  -4.598582416057691e-13,  -1.070888400313537e-14,   8.841507991785465e-16,
   2.038461701735932e-01,  -3.964328471227531e-03,   6.782230486803220e-05,  -7.154233102180756e-07,  -4.000147326841674e-09,   1.003306414384990e-10,   1.330332568781981e-11,
  -4.538083295544944e-13,  -1.071757486091617e-14,   8.710395486185891e-16,   2.038538024410739e-01,  -3.964569913638656e-03,   6.781965536173703e-05,  -7.153134526970835e-07,
  -3.977802160310523e-09,   9.927300248685606e-11,   1.326951369909499e-11,  -4.503306414448848e-13,  -1.072218076443580e-14,   8.635047450552894e-16,   2.038566684095189e-01,
  -3.964660574630284e-03,   6.781866173676632e-05,  -7.152723012994271e-07,  -3.969416246011128e-09,   9.887655069020377e-11,   1.325681589262459e-11,  -4.490273447883465e-13,
  -1.072383327516093e-14,   8.606813826138190e-16,   2.038571434835520e-01,  -3.964675602827423e-03,   6.781849709729358e-05,  -7.152654852007229e-07,  -3.968026420131810e-09,
   9.881087014061724e-11,   1.325471099429059e-11,  -4.488114422686321e-13,  -1.072410314730484e-14,   8.602136878373116e-16,   4.147221953992190e-01,  -8.034707936366859e-03,
   1.342429216370783e-04,  -1.179729442812032e-06,  -2.076661490106000e-08,   5.007284484539248e-10,   2.852868841658397e-11,  -1.181559071065817e-12,  -2.334437923824658e-14,
   2.328038565214298e-15,   4.147412641816388e-01,  -8.035209176293637e-03,   1.342255283072150e-04,  -1.179045008780489e-06,  -2.070683805214565e-08,   4.973764602312396e-10,
   2.843447142485696e-11,  -1.170274573904221e-12,  -2.340513948995230e-14,   2.303939380208524e-15,   4.147725669399441e-01,  -8.036031838084861e-03,   1.341970108739581e-04,
  -1.177924773454206e-06,  -2.060885063999870e-08,   4.918975893242919e-10,   2.827964208260117e-11,  -1.151837045689858e-12,  -2.350172295879266e-14,   2.264566930839402e-15,
   4.148057792311106e-01,  -8.036904468216196e-03,   1.341668012744866e-04,  -1.176740689318251e-06,  -2.050507691427808e-08,   4.861165448849382e-10,   2.811514781774250e-11,
  -1.132392346333278e-12,  -2.359994168075342e-14,   2.223047861465140e-15,   4.148319157754926e-01,  -8.037591032148067e-03,   1.341430620346350e-04,  -1.175812108807662e-06,
  -2.042355025332511e-08,   4.815902545504570e-10,   2.798554291117229e-11,  -1.117175082031462e-12,  -2.367418193608709e-14,   2.190558687401128e-15,   4.148469990040956e-01,
  -8.037987181362774e-03,   1.341293760222162e-04,  -1.175277526189241e-06,  -2.037655729794093e-08,   4.789874060989513e-10,   2.791068768384987e-11,  -1.108427201433114e-12,
  -2.371581088352452e-14,   2.171883212257078e-15,   4.148526627775323e-01,  -8.038135924179806e-03,   1.341242395024648e-04,  -1.175077034064781e-06,  -2.035892188058858e-08,
   4.780117770291819e-10,   2.788256804314113e-11,  -1.105148756574171e-12,  -2.373121414011022e-14,   2.164884483627728e-15,   4.148536016222514e-01,  -8.038160579631855e-03,
   1.341233881939316e-04,  -1.175043812749431e-06,  -2.035599913308965e-08,   4.778501456549845e-10,   2.787790624623054e-11,  -1.104605648513723e-12,  -2.373375540584563e-14,
   2.163725087568082e-15,   7.278017119516568e-01,  -1.399373331209157e-02,   2.213944527405047e-04,  -1.009763194209141e-06,  -8.481054479322319e-08,   2.008714137007396e-09,
   5.674208853533024e-11,  -3.245376593420694e-12,  -3.366228237885293e-14,   5.884206936280681e-15,   7.278330737552836e-01,  -1.399415459269361e-02,   2.213227135119399e-04,
  -1.006982289168851e-06,  -8.469112351208078e-08,   1.999469493170352e-09,   5.659984029943307e-11,  -3.216772531062333e-12,  -3.406387130402959e-14,   5.826472390008826e-15,
   7.278845519621735e-01,  -1.399484535285515e-02,   2.212050151070471e-04,  -1.002426304836378e-06,  -8.449529780006068e-08,   1.984353702519188e-09,   5.636522328489299e-11,
  -3.170025447378865e-12,  -3.471211847974407e-14,   5.732044717272209e-15,   7.279391644428456e-01,  -1.399557716249318e-02,   2.210802273408333e-04,  -9.976046880761024e-07,
  -8.428781642344342e-08,   1.968397048717225e-09,   5.611480736532871e-11,  -3.120709378349038e-12,  -3.538508729996300e-14,   5.632330296602832e-15,   7.279821376051839e-01,
  -1.399615227612175e-02,   2.209820905755950e-04,  -9.938191717898016e-07,  -8.412474888868815e-08,   1.955898520727568e-09,   5.591667834074315e-11,  -3.082104021639127e-12,
  -3.590403880758359e-14,   5.554203263534655e-15,   7.280069353936829e-01,  -1.399648385537339e-02,   2.209254827153331e-04,  -9.916381239518936e-07,  -8.403072839775502e-08,
   1.948709139355691e-09,   5.580191752151500e-11,  -3.059906763336784e-12,  -3.619928452619076e-14,   5.509254654983603e-15,   7.280162466686864e-01,  -1.399660830433959e-02,
   2.209042313393555e-04,  -9.908198072085860e-07,  -8.399543961168639e-08,   1.946013939115110e-09,   5.575874545192926e-11,  -3.051587071149770e-12,  -3.630935213560459e-14,
   5.492402500274520e-15,   7.280177901172519e-01,  -1.399662893024949e-02,   2.209007089064440e-04,  -9.906841957865898e-07,  -8.398959087947988e-08,   1.945567407460078e-09,
   5.575158494847450e-11,  -3.050208785457921e-12,  -3.632755529293938e-14,   5.489610412795749e-15,   1.204833447366443e+00,  -2.264641266572598e-02,   2.934821545620427e-04,
   4.149717376767705e-06,  -4.249522487272773e-07,   1.012056176782931e-08,   2.153102690116843e-10,  -2.152097596881344e-11,   4.023384984583835e-13,   1.826706657665647e-14,
   1.204874487868383e+00,  -2.264459215017068e-02,   2.931220208053999e-04,   4.163590918308162e-06,  -4.244755471246913e-07,   1.005776935753636e-08,   2.167671478262612e-10,
  -2.142590406001280e-11,   3.952322275962323e-13,   1.832558194537088e-14,   1.204941825894981e+00,  -2.264159932132681e-02,   2.925311024571017e-04,   4.186302631785626e-06,
  -4.236907936622136e-07,   9.954891706410333e-09,   2.191387290406726e-10,  -2.126963589185210e-11,   3.836262426958757e-13,   1.841839521564803e-14,   1.205013227022045e+00,
  -2.263841805825641e-02,   2.919045001627555e-04,   4.210314718197933e-06,  -4.228551763096750e-07,   9.846011091125905e-09,   2.216279083357955e-10,  -2.110356846707172e-11,
   3.713929785488154e-13,   1.851249450349519e-14,   1.205069384097060e+00,  -2.263591031206733e-02,   2.914116566322765e-04,   4.229149604837503e-06,  -4.221954304493716e-07,
   9.760524742754034e-09,   2.235672488366226e-10,  -2.097269307580066e-11,   3.618243159776308e-13,   1.858340383558074e-14,   1.205101779022345e+00,  -2.263446141181046e-02,
   2.911273457323457e-04,   4.239994462531280e-06,  -4.218138364960021e-07,   9.711270431413815e-09,   2.246786252139063e-10,  -2.089709204472426e-11,   3.563256668397987e-13,
   1.862307391411013e-14,   1.205113940913785e+00,  -2.263391702742667e-02,   2.910206066265447e-04,   4.244062069396262e-06,  -4.216703855923909e-07,   9.692790364226428e-09,
   2.250944763334285e-10,  -2.086869001725082e-11,   3.542653290321782e-13,   1.863773458797654e-14,   1.205115956777624e+00,  -2.263382677168616e-02,   2.910029142775314e-04,
   4.244736083222810e-06,  -4.216465981985310e-07,   9.689727842007777e-09,   2.251633315102201e-10,  -2.086398128894474e-11,   3.539240337282342e-13,   1.864015238779342e-14,
   7.310898508264833e-03,  -1.338216763820789e-04,   2.302441740312345e-06,  -3.087714102817204e-08,   9.765239683835960e-11,   6.913443923482841e-12,   3.599155469023508e-14,
  -1.388152532213794e-14,   3.805714228967185e-16,   7.326197062793199e-18,   7.311226331411485e-03,  -1.338348250408652e-04,   2.302525659164070e-06,  -3.086764704091583e-08,
   9.774605681513842e-11,   6.872589722570648e-12,   3.741918568515078e-14,  -1.384230109264592e-14,   3.762655349526768e-16,   7.390848002768568e-18,   7.311764514902564e-03,
  -1.338564078437345e-04,   2.302663488629912e-06,  -3.085210288101759e-08,   9.790197053042426e-11,   6.805606727068435e-12,   3.975063445470468e-14,  -1.377768185255001e-14,
   3.692250102951262e-16,   7.495245682601379e-18,   7.312335581068004e-03,  -1.338793050013736e-04,   2.302809822801006e-06,  -3.083566602789729e-08,   9.807032657043930e-11,
   6.734649441966038e-12,   4.220789319746668e-14,  -1.370881172488510e-14,   3.617928898375548e-16,   7.603672678745940e-18,   7.312785021751227e-03,  -1.338973223924055e-04,
   2.302925051715718e-06,  -3.082277115335741e-08,   9.820492945023274e-11,   6.678890489551382e-12,   4.412979318163187e-14,  -1.365439309320620e-14,   3.559715696564066e-16,
   7.687317060260721e-18,   7.313044406210727e-03,  -1.339077194635847e-04,   2.302991578073424e-06,  -3.081534569735599e-08,   9.828345287006844e-11,   6.646744967042202e-12,
   4.523417037547280e-14,  -1.362290074916838e-14,   3.526231079748034e-16,   7.734916773682847e-18,   7.313141808307302e-03,  -1.339116234561949e-04,   2.303016564223359e-06,
  -3.081256046838732e-08,   9.831309792703331e-11,   6.634680449019195e-12,   4.564797121940170e-14,  -1.361105885707577e-14,   3.513678313348353e-16,   7.752664149160081e-18,
   7.313157954133440e-03,  -1.339122705877247e-04,   2.303020706291275e-06,  -3.081209894051035e-08,   9.831802038572753e-11,   6.632680922677122e-12,   4.571651698768211e-14,
  -1.360909504170872e-14,   3.511598622404619e-16,   7.755599352447738e-18,   6.650571021853761e-02,  -1.216929345071540e-03,   2.088587619855938e-05,  -2.760496499033128e-07,
   6.297506978744107e-10,   7.158872706234361e-11,   2.009097332802562e-13,  -1.295322738528583e-13,   3.643242326467278e-15,   6.747855163503658e-17,   6.650868352045766e-02,
  -1.217046848822179e-03,   2.088641732956866e-05,  -2.759509875761403e-07,   6.303407132764591e-10,   7.120745635493530e-11,   2.145778512327766e-13,  -1.291694945510113e-13,
   3.602088221148961e-15,   6.813078917118395e-17,   6.651356473317641e-02,  -1.217239720557578e-03,   2.088730609843239e-05,  -2.757894071104508e-07,   6.313299583896826e-10,
   7.058233313452553e-11,   2.368992822060301e-13,  -1.285716456479131e-13,   3.534793072902375e-15,   6.918464406225269e-17,   6.651874415385797e-02,  -1.217444332092797e-03,
   2.088824972135902e-05,  -2.756184869455708e-07,   6.324075765343597e-10,   6.992011128633668e-11,   2.604254571636377e-13,  -1.279342059524569e-13,   3.463749031543996e-15,
   7.028003421615577e-17,   6.652282044073557e-02,  -1.217605333331800e-03,   2.088899277593074e-05,  -2.754843546741803e-07,   6.332758293245524e-10,   6.939972479386101e-11,
   2.788261877184167e-13,  -1.274303369823935e-13,   3.408098457234138e-15,   7.112568747034217e-17,   6.652517296789238e-02,  -1.217698238641484e-03,   2.088942177670845e-05,
  -2.754070976436045e-07,   6.337849715335326e-10,   6.909971513880102e-11,   2.893998232401620e-13,  -1.271386708953807e-13,   3.376086180669471e-15,   7.160718151776399e-17,
   6.652605636944728e-02,  -1.217733123308461e-03,   2.088958290300316e-05,  -2.753781158265999e-07,   6.339776792660954e-10,   6.898711825403452e-11,   2.933616874195527e-13,
  -1.270289833146456e-13,   3.364085047017994e-15,   7.178675362909365e-17,   6.652620280612216e-02,  -1.217738905825298e-03,   2.088960961369853e-05,  -2.753733132033469e-07,
   6.340097034326422e-10,   6.896845686132019e-11,   2.940179675747601e-13,  -1.270107923979536e-13,   3.362096731438546e-15,   7.181645529494607e-17,   1.889701341699478e-01,
  -3.455094932134371e-03,   5.896249437693468e-05,  -7.527708518038783e-07,   8.451199921187063e-11,   2.614393495400094e-10,  -2.934810052701942e-13,  -3.898096714743288e-13,
   1.163128153373383e-14,   1.940038436999685e-16,   1.889785251105294e-01,  -3.455415028294072e-03,   5.896256615740663e-05,  -7.524084808964299e-07,   8.440034582250678e-11,
   2.602913944328221e-10,  -2.498199152059627e-13,  -3.887549622983125e-13,   1.150112657028138e-14,   1.963215639964993e-16,   1.889923002054153e-01,  -3.455940408402938e-03,
   5.896268408937432e-05,  -7.518147640040022e-07,   8.428299188370678e-11,   2.584091568794773e-10,  -1.785133766577241e-13,  -3.870153227589624e-13,   1.128826398996161e-14,
   2.000708819275951e-16,   1.890069166566047e-01,  -3.456497728625905e-03,   5.896280937205268e-05,  -7.511863781851208e-07,   8.424778241954723e-11,   2.564151150877741e-10,
  -1.033534936402753e-13,  -3.851584466244552e-13,   1.106349821516000e-14,   2.039740675540141e-16,   1.890184198884076e-01,  -3.456936235077624e-03,   5.896290809418934e-05,
  -7.506929880752631e-07,   8.428449362380649e-11,   2.548480872944893e-10,  -4.456463241136100e-14,  -3.836892094188498e-13,   1.088740118630881e-14,   2.069918339111338e-16,
   1.890250586316024e-01,  -3.457189262688172e-03,   5.896296512396916e-05,  -7.504087047624701e-07,   8.433142368378444e-11,   2.539446466754636e-10,  -1.078135346421715e-14,
  -3.828381593298317e-13,   1.078609071903283e-14,   2.087118855892521e-16,   1.890275515462899e-01,  -3.457284268943524e-03,   5.896298655033659e-05,  -7.503020407894599e-07,
   8.435390263967843e-11,   2.536055702444789e-10,   1.877251152025529e-15,  -3.825179943643402e-13,   1.074810784034045e-14,   2.093537200668680e-16,   1.890279647826142e-01,
  -3.457300017161580e-03,   5.896299010266642e-05,  -7.502843643103517e-07,   8.435788480566717e-11,   2.535493726853764e-10,   3.974154048249065e-15,  -3.824648915437894e-13,
   1.074181481071339e-14,   2.094598993473986e-16,   3.846348528209509e-01,  -7.022096098720374e-03,   1.185111735114929e-04,  -1.406533857393516e-06,  -6.723867433980790e-09,
   7.723860374916716e-10,  -4.347771756738244e-12,  -8.838886559028066e-13,   2.959263924406990e-14,   3.734451952326491e-16,   3.846517061963528e-01,  -7.022692777809204e-03,
   1.185053878795909e-04,  -1.405456679799952e-06,  -6.731835097523227e-09,   7.697784358753827e-10,  -4.236437155348792e-12,  -8.817923141899816e-13,   2.927382175777799e-14,
   3.804056753170462e-16,   3.846793731386991e-01,  -7.023671995879310e-03,   1.184958853233944e-04,  -1.403690986190293e-06,  -6.744747015266903e-09,   7.655022799452021e-10,
  -4.054571233566009e-12,  -8.783261588324814e-13,   2.875223244640967e-14,   3.916859961127086e-16,   3.847087290860647e-01,  -7.024710577662905e-03,   1.184857963095607e-04,
  -1.401821071803124e-06,  -6.758219597085746e-09,   7.609712881734280e-10,  -3.862828416720575e-12,  -8.746150629117116e-13,   2.820123617833056e-14,   4.034573027282751e-16,
   3.847318317794151e-01,  -7.025527625671648e-03,   1.184778518532944e-04,  -1.400352060392295e-06,  -6.768658136915878e-09,   7.574099864546016e-10,  -3.712814833222394e-12,
  -8.716705755455156e-13,   2.776937508396081e-14,   4.125788438282489e-16,   3.847451645583690e-01,  -7.025999031371943e-03,   1.184732652230847e-04,  -1.399505315125752e-06,
  -6.774616697742433e-09,   7.553565458085412e-10,  -3.626594685290832e-12,  -8.699617751067008e-13,   2.752085202266681e-14,   4.177861924125551e-16,   3.847501711046195e-01,
  -7.026176024591432e-03,   1.184715425727033e-04,  -1.399187552225448e-06,  -6.776841797275968e-09,   7.545858101300741e-10,  -3.594285291100461e-12,  -8.693183208102527e-13,
   2.742766386277168e-14,   4.197308859289392e-16,   3.847510010089581e-01,  -7.026205362468953e-03,   1.184712570016343e-04,  -1.399134888939060e-06,  -6.777209985823284e-09,
   7.544580682340640e-10,  -3.588933085735427e-12,  -8.692115652204056e-13,   2.741222370010908e-14,   4.200526820810084e-16,   6.752642232267102e-01,  -1.229073531113528e-02,
   2.026160872017466e-04,  -2.002229152761703e-06,  -3.829224397910187e-08,   2.321598785939302e-09,  -2.408067922345569e-11,  -1.918954653882646e-12,   8.127801644683492e-14,
   2.642169572395338e-16,   6.752929906899180e-01,  -1.229157861436814e-02,   2.025831227699758e-04,  -1.998973454688656e-06,  -3.834000768375791e-08,   2.315897060907474e-09,
  -2.377244156404417e-11,  -1.916968739416338e-12,   8.052219539286719e-14,   2.881420118202569e-16,   6.753402137054008e-01,  -1.229296203978944e-02,   2.025289779864642e-04,
  -1.993634549406045e-06,  -3.841795225125399e-08,   2.306541449171191e-09,  -2.326857850744797e-11,  -1.913622923678520e-12,   7.928448701475960e-14,   3.270239666177971e-16,
   6.753903163102221e-01,  -1.229442861207175e-02,   2.024714878329531e-04,  -1.987977506046210e-06,  -3.850002419896653e-08,   2.296620898958215e-09,  -2.273687008963358e-11,
  -1.909957188792226e-12,   7.797540890929576e-14,   3.677461400772100e-16,   6.754297439453141e-01,  -1.229558183621654e-02,   2.024262151323242e-04,  -1.983531135331935e-06,
  -3.856415817772566e-08,   2.288818140796225e-09,  -2.232052970154682e-11,  -1.906989184586113e-12,   7.694823359978054e-14,   3.994093082134419e-16,   6.754524970500159e-01,
  -1.229624699346728e-02,   2.024000763287788e-04,  -1.980967352833017e-06,  -3.860098840075976e-08,   2.284316952724177e-09,  -2.208109880161917e-11,  -1.905243204059006e-12,
   7.635666894268564e-14,   4.175288022301838e-16,   6.754610408110305e-01,  -1.229649669276510e-02,   2.023902588656711e-04,  -1.980005062586738e-06,  -3.861478402974259e-08,
   2.282627080826722e-09,  -2.199135010835821e-11,  -1.904581341400221e-12,   7.613476520540694e-14,   4.243038213596705e-16,   6.754624570482031e-01,  -1.229653808010194e-02,
   2.023886313708926e-04,  -1.979845572180778e-06,  -3.861706903478167e-08,   2.282346979910139e-09,  -2.197648141425760e-11,  -1.904471300141574e-12,   7.609799387987942e-14,
   4.254253478284701e-16,   1.119117194925438e+00,  -2.019864144758167e-02,   3.095866892568008e-04,  -9.232838123025089e-07,  -2.106406263382272e-07,   9.833116026369001e-09,
  -1.636476319935022e-10,  -5.537326659467155e-12,   4.294884143652055e-13,  -9.741949155900922e-15,   1.119160885942520e+00,  -2.019898672825658e-02,   3.094049789054545e-04,
  -9.094370620410842e-07,  -2.109699791634385e-07,   9.815841934677260e-09,  -1.619630866432302e-10,  -5.583260540442967e-12,   4.282152560000434e-13,  -9.593445299242233e-15,
   1.119232592838696e+00,  -2.019954932438379e-02,   3.091064750193110e-04,  -8.867234453108839e-07,  -2.115080806364513e-07,   9.787387077690487e-09,  -1.592014092609636e-10,
  -5.658122235409888e-12,   4.261059685128053e-13,  -9.350136801617067e-15,   1.119308653593394e+00,  -2.020014052571978e-02,   3.087894725402080e-04,  -8.626471471726780e-07,
  -2.120755386165655e-07,   9.757063578182156e-09,  -1.562762183191143e-10,  -5.736814962660328e-12,   4.238419583731678e-13,  -9.092634237123701e-15,   1.119368495116312e+00,
  -2.020060163878315e-02,   3.085397974454982e-04,  -8.437168301144689e-07,  -2.125195927994395e-07,   9.733104702349786e-09,  -1.539778384655301e-10,  -5.798210627130706e-12,
   4.220415725398497e-13,  -8.890467145352478e-15,   1.119403023334635e+00,  -2.020086608722619e-02,   3.083956281358034e-04,  -8.327989452277637e-07,  -2.127748485559551e-07,
   9.719240004052126e-09,  -1.526529136202127e-10,  -5.833428708383760e-12,   4.209951287834221e-13,  -8.773990508296559e-15,   1.119415987607076e+00,  -2.020096507489938e-02,
   3.083414766124806e-04,  -8.287005279506589e-07,  -2.128705075853291e-07,   9.714026592048770e-09,  -1.521556784393399e-10,  -5.846612926641424e-12,   4.206007847964619e-13,
  -8.730290025427930e-15,   1.119418136546047e+00,  -2.020098146688952e-02,   3.083324994573539e-04,  -8.280212282538563e-07,  -2.128863543099221e-07,   9.713162021370745e-09,
  -1.520732697677048e-10,  -5.848796262631706e-12,   4.205353432413451e-13,  -8.723048037026641e-15,   6.810155271322211e-03,  -1.168474203625404e-04,   1.945707470365007e-06,
  -2.826757853628433e-08,   2.206048854441716e-10,   4.566944614416234e-12,  -1.745540090571898e-13,  -1.729877891942058e-15,   2.876735598882582e-16,  -8.045839543375718e-18,
   6.810432534468014e-03,  -1.168594656389817e-04,   1.945893804528546e-06,  -2.826112884326591e-08,   2.202457592405840e-10,   4.561158867684651e-12,  -1.734180475241005e-13,
  -1.768728969384549e-15,   2.871884886444586e-16,  -7.957409537138912e-18,   6.810887725653171e-03,  -1.168792379319981e-04,   1.946199484870250e-06,  -2.825054683298023e-08,
   2.196579424310946e-10,   4.551578246696537e-12,  -1.715546492029282e-13,  -1.832183632488587e-15,   2.863800399576013e-16,  -7.812470893008201e-18,   6.811370744302788e-03,
  -1.169002151764235e-04,   1.946523540539383e-06,  -2.823932698047942e-08,   2.190365963633163e-10,   4.541300888789266e-12,  -1.695794513422563e-13,  -1.899071815379493e-15,
   2.855058319133730e-16,  -7.659000921371316e-18,   6.811750901060310e-03,  -1.169167224337320e-04,   1.946778361074174e-06,  -2.823050307189805e-08,   2.185493108411262e-10,
   4.533132070054365e-12,  -1.680264315647683e-13,  -1.951393449716924e-15,   2.848060420992334e-16,  -7.538454684427526e-18,   6.811970304388542e-03,  -1.169262483156436e-04,
   1.946925337767099e-06,  -2.822541310842666e-08,   2.182687767986277e-10,   4.528385522330336e-12,  -1.671307480907709e-13,  -1.981461258647397e-15,   2.843974816739869e-16,
  -7.468980426538479e-18,   6.812052693923970e-03,  -1.169298252318085e-04,   1.946980512887353e-06,  -2.822350224794159e-08,   2.181635634675668e-10,   4.526597079190704e-12,
  -1.667945230001838e-13,  -1.992727836457407e-15,   2.842431782100395e-16,  -7.442910284193531e-18,   6.812066351242829e-03,  -1.169304181490965e-04,   1.946989658104950e-06,
  -2.822318552036773e-08,   2.181461297085897e-10,   4.526300299353544e-12,  -1.667387948519038e-13,  -1.994594157590769e-15,   2.842175535901211e-16,  -7.438589744260149e-18,
   6.195156825599130e-02,  -1.062816019116199e-03,   1.767906489906634e-05,  -2.552408891487886e-07,   1.887705146416282e-09,   4.672937191900932e-11,  -1.732538781911883e-12,
  -1.434952734329655e-14,   2.698182023556535e-15,  -7.717989217509263e-17,   6.195408731719189e-02,  -1.062924753703406e-03,   1.768065653098280e-05,  -2.551748071592840e-07,
   1.884133351743209e-09,   4.668057362517780e-11,  -1.721878175512960e-12,  -1.472251755656380e-14,   2.693928737998985e-15,  -7.634338637167248e-17,   6.195822292448174e-02,
  -1.063103238841391e-03,   1.768326728829705e-05,  -2.550663755061266e-07,   1.878286070672975e-09,   4.659967221554258e-11,  -1.704389990770289e-12,  -1.533175933691289e-14,
   2.686828047505863e-15,  -7.497215578519764e-17,   6.196261134167955e-02,  -1.063292597809410e-03,   1.768603456797768e-05,  -2.549513931052652e-07,   1.872103928327256e-09,
   4.651275801947794e-11,  -1.685851426436530e-12,  -1.597402752056607e-14,   2.679133910884933e-15,  -7.351996907311392e-17,   6.196606520699428e-02,  -1.063441604367186e-03,
   1.768821031051011e-05,  -2.548609537989879e-07,   1.867254668366222e-09,   4.644358311851271e-11,  -1.671274475095853e-12,  -1.647646971382012e-14,   2.672963650883017e-15,
  -7.237914315654611e-17,   6.196805856347899e-02,  -1.063527590972958e-03,   1.768946512525106e-05,  -2.548087806432748e-07,   1.864462523745320e-09,   4.640335202518534e-11,
  -1.662867088091776e-12,  -1.676522699009774e-14,   2.669356842932388e-15,  -7.172158252285619e-17,   6.196880710061662e-02,  -1.063559878288112e-03,   1.768993616039831e-05,
  -2.547891931129248e-07,   1.863415265971568e-09,   4.638818657512523e-11,  -1.659711029827769e-12,  -1.687342928499920e-14,   2.667993816952666e-15,  -7.147482040785615e-17,
   6.196893118199222e-02,  -1.063565230293081e-03,   1.769001423276567e-05,  -2.547859464111872e-07,   1.863241732372689e-09,   4.638566961319355e-11,  -1.659187920841739e-12,
  -1.689135329020023e-14,   2.667767421117853e-15,  -7.143392444110641e-17,   1.760364783597084e-01,  -3.019125308971068e-03,   5.010042760913504e-05,  -7.128928836289101e-07,
   4.585193406049345e-09,   1.670126247168147e-10,  -5.893631863445959e-12,  -3.086121529563261e-14,   8.197877810471812e-15,  -2.468047493280094e-16,   1.760436157519159e-01,
  -3.019428822566660e-03,   5.010427374350229e-05,  -7.126561682612873e-07,   4.572997767584259e-09,   1.669014370813992e-10,  -5.861194910160231e-12,  -3.205641806482160e-14,
   8.187243521580480e-15,  -2.442228920792333e-16,   1.760553333213757e-01,  -3.019927016460306e-03,   5.011058039151849e-05,  -7.122676838454245e-07,   4.553026571930119e-09,
   1.667163678941036e-10,  -5.807977265017092e-12,  -3.400901417464655e-14,   8.169394822573458e-15,  -2.399892781113913e-16,   1.760677670911463e-01,  -3.020455539777092e-03,
   5.011726218668498e-05,  -7.118556393015558e-07,   4.531903404105069e-09,   1.665165588669227e-10,  -5.751554502567061e-12,  -3.606793803056270e-14,   8.149927760388603e-15,
  -2.355039040986806e-16,   1.760775529116237e-01,  -3.020871418810569e-03,   5.012251353438311e-05,  -7.115314804192287e-07,   4.515328436206683e-09,   1.663568289636996e-10,
  -5.707182746100546e-12,  -3.767896755668482e-14,   8.134226920473072e-15,  -2.319789268155144e-16,   1.760832006515313e-01,  -3.021111402040637e-03,   5.012554128392819e-05,
  -7.113444513912955e-07,   4.505782362566980e-09,   1.662636548551222e-10,  -5.681588423684994e-12,  -3.860497730786215e-14,   8.125014022032234e-15,  -2.299466445883656e-16,
   1.760853214626605e-01,  -3.021201512707450e-03,   5.012667768526292e-05,  -7.112742295120271e-07,   4.502201432852070e-09,   1.662284801143461e-10,  -5.671980068610906e-12,
  -3.895199531261684e-14,   8.121525915376315e-15,  -2.291838939406927e-16,   1.760856730189722e-01,  -3.021216449554257e-03,   5.012686603111519e-05,  -7.112625897263121e-07,
   4.501608038500887e-09,   1.662226395442852e-10,  -5.670387482123884e-12,  -3.900948117925928e-14,   8.120946206663085e-15,  -2.290574778522848e-16,   3.583346287069782e-01,
  -6.142245813492563e-03,   1.014604310810527e-04,  -1.402653741117285e-06,   6.237721834449636e-09,   4.787740995066407e-10,  -1.606114754946223e-11,  -1.622860297235228e-14,
   1.878448615843774e-14,  -6.235743076419013e-16,   3.583490775993303e-01,  -6.142842233455010e-03,   1.014655683340351e-04,  -1.401973269880386e-06,   6.204322979179118e-09,
   4.786774527933031e-10,  -1.598657198417550e-11,  -1.926194230713034e-14,   1.877230268420529e-14,  -6.175631316517943e-16,   3.583727982936630e-01,  -6.143821143630684e-03,
   1.014739816359741e-04,  -1.400856285459467e-06,   6.149608252647227e-09,   4.785123444749327e-10,  -1.586418514754436e-11,  -2.421943773509306e-14,   1.875126494972412e-14,
  -6.076994984711535e-16,   3.583979684610269e-01,  -6.144859557990564e-03,   1.014828812078929e-04,  -1.399671244299285e-06,   6.091707818580171e-09,   4.783284159528000e-10,
  -1.573438062490319e-11,  -2.944953308334691e-14,   1.872754029294806e-14,  -5.972401448389559e-16,   3.584177780045956e-01,  -6.145676589225928e-03,   1.014898652711068e-04,
  -1.398738733414253e-06,   6.046252876606185e-09,   4.781773589170878e-10,  -1.563226658599838e-11,  -3.354379591846692e-14,   1.870785913418403e-14,  -5.890137248538013e-16,
   3.584292106755260e-01,  -6.146148031231060e-03,   1.014938879249841e-04,  -1.398200613268467e-06,   6.020065227937226e-09,   4.780876606631001e-10,  -1.557335214973802e-11,
  -3.589791969053724e-14,   1.869609776465872e-14,  -5.842682510545587e-16,   3.584335037941535e-01,  -6.146325046762122e-03,   1.014953969633534e-04,  -1.397998553385684e-06,
   6.010240063956986e-09,   4.780535025259933e-10,  -1.555123256373054e-11,  -3.678026209269282e-14,   1.869160529418274e-14,  -5.824866964023234e-16,   3.584342154419682e-01,
  -6.146354388795633e-03,   1.014956470285300e-04,  -1.397965059576090e-06,   6.008611853860588e-09,   4.780478152581548e-10,  -1.554756610475257e-11,  -3.692643570333267e-14,
   1.869085660082191e-14,  -5.821914005298225e-16,   6.291805756924760e-01,  -1.077307395260275e-02,   1.763063323895411e-04,  -2.287985919104270e-06,  -5.326302748926516e-10,
   1.375794340233152e-09,  -4.485814627631899e-11,   2.032664354598565e-13,   4.044845625571792e-14,  -1.636921477684235e-15,   6.292056633879284e-01,  -1.077404381271256e-02,
   1.763053469612400e-04,  -2.286024129977853e-06,  -6.264581666025960e-10,   1.376273856333529e-09,  -4.469604704627991e-11,   1.952177755130855e-13,   4.049588479628862e-14,
  -1.624382507595114e-15,   6.292468487155587e-01,  -1.077563538888545e-02,   1.763036719293515e-04,  -2.282803095211640e-06,  -7.802412852758697e-10,   1.377043894862503e-09,
  -4.442981467503183e-11,   1.820512443028611e-13,   4.057089384271706e-14,  -1.603768625454393e-15,   6.292905492773865e-01,  -1.077732335033742e-02,   1.763018168114923e-04,
  -2.279384739371279e-06,  -9.430764496270662e-10,   1.377837692368547e-09,  -4.414716258564702e-11,   1.681439884423953e-13,   4.064662114525812e-14,  -1.581857141886385e-15,
   6.293249416629333e-01,  -1.077865118831503e-02,   1.763003005761655e-04,  -2.276694056407066e-06,  -1.070981898761500e-09,   1.378445608555615e-09,  -4.392460230705893e-11,
   1.572448875454555e-13,   4.070343280198855e-14,  -1.564585578568817e-15,   6.293447901056982e-01,  -1.077941727043326e-02,   1.762994030021657e-04,  -2.275141045181481e-06,
  -1.144699730172318e-09,   1.378789726304693e-09,  -4.379611483226788e-11,   1.509732489319927e-13,   4.073510668085580e-14,  -1.554607219782057e-15,   6.293522433789700e-01,
  -1.077970489668407e-02,   1.762990616993696e-04,  -2.274557843040520e-06,  -1.172362812309640e-09,   1.378917677015288e-09,  -4.374785840608535e-11,   1.486216742770340e-13,
   4.074679055007881e-14,  -1.550858274495231e-15,   6.293534788649395e-01,  -1.077975257246748e-02,   1.762990048991482e-04,  -2.274461167310501e-06,  -1.176947377744183e-09,
   1.378938819777242e-09,  -4.373985878863788e-11,   1.482320511645781e-13,   4.074871625129282e-14,  -1.550236729870839e-15,   1.043142717996969e+00,  -1.781016323039612e-02,
   2.839981294723059e-04,  -2.962755864811284e-06,  -5.922751707063154e-08,   5.258870494615031e-09,  -1.811517780590693e-10,   2.471245533419060e-12,   9.225885926427097e-14,
  -6.724069091602154e-15,   1.043183026934141e+00,  -1.781140144362803e-02,   2.839453963334905e-04,  -2.955214890867616e-06,  -5.960953668518433e-08,   5.265706532730457e-09,
  -1.807614593110105e-10,   2.436869057349741e-12,   9.336133165197712e-14,  -6.721879594973366e-15,   1.043249194810463e+00,  -1.781343183104068e-02,   2.838585920910092e-04,
  -2.942828358652431e-06,  -6.023606953664942e-08,   5.276854799587706e-09,  -1.801175635103701e-10,   2.380446333362711e-12,   9.516238900309412e-14,  -6.717791996160107e-15,
   1.043319396189784e+00,  -1.781558304766712e-02,   2.837661679127402e-04,  -2.929676086538178e-06,  -6.090003199200484e-08,   5.288583150449584e-09,  -1.794301079989771e-10,
   2.320594528499452e-12,   9.706142922999243e-14,  -6.712786242869261e-15,   1.043374639349441e+00,  -1.781727376222491e-02,   2.836931994035872e-04,  -2.919318548113639e-06,
  -6.142196564099619e-08,   5.297740440080044e-09,  -1.788860236308808e-10,   2.273503979798050e-12,   9.854726432217476e-14,  -6.708364090787973e-15,   1.043406518971046e+00,
  -1.781824858272748e-02,   2.836509956316674e-04,  -2.913338362876007e-06,  -6.172293924990596e-08,   5.302996040003169e-09,  -1.785708016381220e-10,   2.246332625206458e-12,
   9.940126832956715e-14,  -6.705618998117479e-15,   1.043418489653476e+00,  -1.781861446285413e-02,   2.836351302719762e-04,  -2.911092244777874e-06,  -6.183591153879850e-08,
   5.304964041861930e-09,  -1.784522024358411e-10,   2.236130585527858e-12,   9.972129307917022e-14,  -6.704551768679913e-15,   1.043420473942609e+00,  -1.781867510350705e-02,
   2.836324994424987e-04,  -2.910719892255667e-06,  -6.185463586857365e-08,   5.305289974717778e-09,  -1.784325307864615e-10,   2.234439508830911e-12,   9.977430681061702e-14,
  -6.704372940180356e-15,   6.371840551802242e-03,  -1.025731546172734e-04,   1.629944016343619e-06,  -2.423599166107081e-08,   2.703712049878850e-10,   5.717275358452719e-13,
  -1.366058303802810e-13,   3.091448003750769e-15,   3.573262930642542e-17,  -4.669117222656496e-18,   6.372072965724456e-03,  -1.025834983444145e-04,   1.630173230967017e-06,
  -2.423510363348003e-08,   2.700815332331909e-10,   5.805831030983806e-13,  -1.364456262651198e-13,   3.067480372812745e-15,   3.659681847682783e-17,  -4.671173621127331e-18,
   6.372454534117265e-03,  -1.026004789558117e-04,   1.630549345737430e-06,  -2.423363684346187e-08,   2.696062467502327e-10,   5.950691557174939e-13,  -1.361801682843824e-13,
   3.028128309979696e-15,   3.800997610187226e-17,  -4.674244785149527e-18,   6.372859439365756e-03,  -1.026184963003637e-04,   1.630948190576006e-06,  -2.423206833266921e-08,
   2.691022818347257e-10,   6.103695798358540e-13,  -1.358951663890608e-13,   2.986366117192882e-15,   3.950189375263162e-17,  -4.677090490153867e-18,   6.373178124863328e-03,
  -1.026326757569656e-04,   1.631261908415445e-06,  -2.423082514462201e-08,   2.687059143847147e-10,   6.223601211204587e-13,  -1.356684639792840e-13,   2.953494745988991e-15,
   4.067056485717818e-17,  -4.679031922566615e-18,   6.373362053688404e-03,  -1.026408588827256e-04,   1.631442890932253e-06,  -2.423010417188485e-08,   2.684772659609562e-10,
   6.292596635077071e-13,  -1.355366680563662e-13,   2.934522467083043e-15,   4.134283011100450e-17,  -4.680033143535990e-18,   6.373431122528412e-03,  -1.026439317058665e-04,
   1.631510838404506e-06,  -2.422983277794614e-08,   2.683914257320053e-10,   6.318466480356358e-13,  -1.354869959095093e-13,   2.927397910179905e-15,   4.159485669653273e-17,
  -4.680386613987313e-18,   6.373442571768918e-03,  -1.026444410691266e-04,   1.631522100971031e-06,  -2.422978775564067e-08,   2.683771975170771e-10,   6.322752739973108e-13,
  -1.354787524736001e-13,   2.926216898712460e-15,   4.163661177273429e-17,  -4.680444020770333e-18,   5.796457083296079e-02,  -9.330653357982400e-04,   1.482089468926920e-05,
  -2.198139757364653e-07,   2.413552772183275e-09,   7.556345139672651e-12,  -1.330521569061980e-12,   3.027708418409718e-14,   3.087145372621465e-16,  -4.375040792497996e-17,
   5.796668406692188e-02,  -9.331591385160368e-04,   1.482293949967553e-05,  -2.198024921883213e-07,   2.410729507715010e-09,   7.643233644551978e-12,  -1.329120979011399e-12,
   3.005230223969265e-14,   3.169792750441730e-16,  -4.377722785209971e-17,   5.797015349034563e-02,  -9.333131271503229e-04,   1.482629465013713e-05,  -2.197835522113089e-07,
   2.406096913111441e-09,   7.785389302629679e-12,  -1.326798178434725e-12,   2.968320895422426e-14,   3.304954501386557e-16,  -4.381834291596745e-17,   5.797383509917369e-02,
  -9.334765159393925e-04,   1.482985236450367e-05,  -2.197633362777113e-07,   2.401184451111313e-09,   7.935567009033209e-12,  -1.324301643902142e-12,   2.929147321254320e-14,
   3.447667423313660e-16,  -4.385801894473005e-17,   5.797673274908311e-02,  -9.336051001050134e-04,   1.483265059663160e-05,  -2.197473401764099e-07,   2.397320562375909e-09,
   8.053279424625167e-12,  -1.322313852580122e-12,   2.898310788218062e-14,   3.559472574670710e-16,  -4.388639230761450e-17,   5.797840512142319e-02,  -9.336793070665830e-04,
   1.483426482675840e-05,  -2.197380740892811e-07,   2.395091541484029e-09,   8.121021846166252e-12,  -1.321157458868657e-12,   2.880511878002419e-14,   3.623792535969204e-16,
  -4.390162666322179e-17,   5.797903312934676e-02,  -9.337071722393663e-04,   1.483487085689792e-05,  -2.197345880833251e-07,   2.394254693604431e-09,   8.146423560865477e-12,
  -1.320721485082121e-12,   2.873827747385533e-14,   3.647906545388003e-16,  -4.390713207836028e-17,   5.797913723146583e-02,  -9.337117912758716e-04,   1.483497130824627e-05,
  -2.197340098853425e-07,   2.394115983158928e-09,   8.150632346895519e-12,  -1.320649124643049e-12,   2.872719733082713e-14,   3.651901741229598e-16,  -4.390803333291719e-17,
   1.647094369928845e-01,  -2.651089300264732e-03,   4.207147925075146e-05,  -6.203572619290924e-07,   6.559998396147456e-09,   3.685933361391596e-11,  -4.360916211919907e-12,
   1.005543265102697e-13,   7.545533093487913e-16,  -1.324732174184640e-16,   1.647154352308620e-01,  -2.651353950059033e-03,   4.207702798986791e-05,  -6.203023733110572e-07,
   6.550732452513067e-09,   3.714892924421028e-11,  -4.357368650394521e-12,   9.987222931300132e-14,   7.807687313825424e-16,  -1.326096632634562e-16,   1.647252828718809e-01,
  -2.651788398038620e-03,   4.208613143907171e-05,  -6.202119714353900e-07,   6.535526665587718e-09,   3.762287198281201e-11,  -4.351470139391423e-12,   9.875202062711810e-14,
   8.236513942501999e-16,  -1.328244429076362e-16,   1.647357327444792e-01,  -2.652249357107186e-03,   4.209578315204589e-05,  -6.201156502369019e-07,   6.519400040186015e-09,
   3.812375625938165e-11,  -4.345110200871521e-12,   9.756281903063091e-14,   8.689432446741650e-16,  -1.330398415092811e-16,   1.647439574023140e-01,  -2.652612117035913e-03,
   4.210337349113679e-05,  -6.200395575687825e-07,   6.506714062730864e-09,   3.851650235214925e-11,  -4.340031844230163e-12,   9.662651041629598e-14,   9.044358303487407e-16,
  -1.332003346522402e-16,   1.647487042348433e-01,  -2.652821465945062e-03,   4.210775177612924e-05,  -6.199955280220514e-07,   6.499395062690997e-09,   3.874258146801792e-11,
  -4.337071806152997e-12,   9.608599257829853e-14,   9.248581279166402e-16,  -1.332893476709328e-16,   1.647504867595474e-01,  -2.652900077229120e-03,   4.210939544082706e-05,
  -6.199789727826796e-07,   6.496647146880526e-09,   3.882736634353027e-11,  -4.335954767267919e-12,   9.588299387254920e-14,   9.325153302462310e-16,  -1.333220913939062e-16,
   1.647507822407412e-01,  -2.652913108105370e-03,   4.210966787936639e-05,  -6.199762273702842e-07,   6.496191663838908e-09,   3.884141484267206e-11,  -4.335769311319613e-12,
   9.584934242160748e-14,   9.337840102873560e-16,  -1.333274832021240e-16,   3.352855979296992e-01,  -5.395598120265540e-03,   8.547751252030732e-05,  -1.246379499144066e-06,
   1.218823885134401e-08,   1.361043187155589e-10,  -1.123120517428230e-11,   2.659588662024903e-13,   9.151667867779720e-16,  -3.002757233701744e-16,   3.352977826607185e-01,
  -5.396129518709129e-03,   8.548778392180314e-05,  -1.246179334720546e-06,   1.216432577160708e-08,   1.368742741693141e-10,  -1.122621731558740e-11,   2.644055857519485e-13,
   9.801193822713952e-16,  -3.008538636741570e-16,   3.353177869040441e-01,  -5.397001832012106e-03,   8.550463135289465e-05,  -1.245849950827754e-06,   1.212507698576804e-08,
   1.381349163413702e-10,  -1.121784378972187e-11,   2.618536534226237e-13,   1.086416389218734e-15,  -3.017804732999396e-16,   3.353390143587201e-01,  -5.397927337766025e-03,
   8.552248775400480e-05,  -1.245499388705837e-06,   1.208344256860734e-08,   1.394679805202801e-10,  -1.120870772996416e-11,   2.591432226271780e-13,   1.198751633495906e-15,
  -3.027331504949951e-16,   3.353557214947558e-01,  -5.398655653232832e-03,   8.553652633906192e-05,  -1.245222728243397e-06,   1.205068456832637e-08,   1.405137951854362e-10,
  -1.120133621629408e-11,   2.570082284246188e-13,   1.286830299549614e-15,  -3.034608525290774e-16,   3.353653639173784e-01,  -5.399075953274266e-03,   8.554462247094082e-05,
  -1.245062755429962e-06,   1.203178273503916e-08,   1.411160263672356e-10,  -1.119700940067017e-11,   2.557753432999958e-13,   1.337529713688040e-15,  -3.038719950273540e-16,
   3.353689848199943e-01,  -5.399233775379396e-03,   8.554766155090203e-05,  -1.245002626146234e-06,   1.202468556539207e-08,   1.413419189206068e-10,  -1.119537093814153e-11,
   2.553122445404909e-13,   1.356542764661004e-15,  -3.040247161227412e-16,   3.353695850404952e-01,  -5.399259936402207e-03,   8.554816526398081e-05,  -1.244992655803646e-06,
   1.202350914269644e-08,   1.413793505888694e-10,  -1.119509861717736e-11,   2.552354720391935e-13,   1.359693125831362e-15,  -3.040499439299787e-16,   5.887373898744622e-01,
  -9.470862306329221e-03,   1.495281097607626e-04,  -2.130957617003320e-06,   1.722186272130973e-08,   4.646341809598306e-10,  -2.879105425964282e-11,   7.207842717283696e-13,
  -1.763496159435767e-15,  -6.224812955514268e-16,   5.887586976868091e-01,  -9.471769657100218e-03,   1.495424661043778e-04,  -2.130278710575313e-06,   1.716036612807419e-08,
   4.667360126032787e-10,  -2.879473363950143e-11,   7.175262840190923e-13,  -1.601644829468088e-15,  -6.250999306696131e-16,   5.887936793309994e-01,  -9.473259006668931e-03,
   1.495659964045437e-04,  -2.129162035700195e-06,   1.705940561374341e-08,   4.701794284201501e-10,  -2.880031106161435e-11,   7.121684673172792e-13,  -1.336505544310167e-15,
  -6.293466558569377e-16,   5.888307994894358e-01,  -9.474839031062363e-03,   1.495909122783748e-04,  -2.127974252789972e-06,   1.695227378887423e-08,   4.738235243430387e-10,
  -2.880560095929682e-11,   7.064708726433167e-13,  -1.055945574235906e-15,  -6.337818660195587e-16,   5.888600146451222e-01,  -9.476082307876298e-03,   1.496104838466138e-04,
  -2.127037361572897e-06,   1.686795722618246e-08,   4.766844630367753e-10,  -2.880931003468349e-11,   7.019778417189006e-13,  -8.357066140953484e-16,  -6.372210990553132e-16,
   5.888768758417665e-01,  -9.476799742691810e-03,   1.496217640073279e-04,  -2.126495822657759e-06,   1.681929528549093e-08,   4.783327644469010e-10,  -2.881126882479750e-11,
   6.993812478588213e-13,  -7.088292537154602e-16,  -6.391853934138405e-16,   5.888832074943663e-01,  -9.477069130608251e-03,   1.496259969895824e-04,  -2.126292310638008e-06,
   1.680102202734569e-08,   4.789511880365954e-10,  -2.881197003804556e-11,   6.984055280505484e-13,  -6.612285493562764e-16,  -6.399191216707867e-16,   5.888842570619836e-01,
  -9.477113784667503e-03,   1.496266985176718e-04,  -2.126258567234796e-06,   1.679799296217071e-08,   4.790536726318210e-10,  -2.881208446370700e-11,   6.982437531021740e-13,
  -6.533403231715284e-16,  -6.400405427724401e-16,   9.762068893383609e-01,  -1.568990890925986e-02,   2.455383268648268e-04,  -3.278060580160525e-06,   9.028203896139019e-09,
   1.899108238110167e-09,  -9.766213957138931e-11,   2.829492637012485e-12,  -3.621334213008168e-14,  -1.109400349887903e-15,   9.762418443313624e-01,  -1.569129857476256e-02,
   2.455448447643715e-04,  -3.275287556193480e-06,   8.818169558231928e-09,   1.907463866838690e-09,  -9.779515067216452e-11,   2.823289041387347e-12,  -3.567053416230234e-14,
  -1.128846451725418e-15,   9.762992290898600e-01,  -1.569357906351292e-02,   2.455554148414677e-04,  -3.270726636381261e-06,   8.473164996570349e-09,   1.921167247191217e-09,
  -9.801194059970569e-11,   2.813033433771232e-12,  -3.477837030848299e-14,  -1.160690516998546e-15,   9.763601193994111e-01,  -1.569599765167474e-02,   2.455664536144731e-04,
  -3.265875532719157e-06,   8.106819089490033e-09,   1.935688839564373e-09,  -9.823983701023804e-11,   2.802054566564255e-12,  -3.383029638007194e-14,  -1.194370251072781e-15,
   9.764080408546637e-01,  -1.569790023296756e-02,   2.455750130583225e-04,  -3.262049285134500e-06,   7.818308928592466e-09,   1.947103765078064e-09,  -9.841764601758832e-11,
   2.793344131059980e-12,  -3.308314313330330e-14,  -1.220796672110951e-15,   9.764356974467095e-01,  -1.569899790461341e-02,   2.455799015037266e-04,  -3.259837716351628e-06,
   7.651726650641944e-09,   1.953686050885600e-09,  -9.851964268179089e-11,   2.788289148442945e-12,  -3.265154430391668e-14,  -1.236015734116786e-15,   9.764460828064249e-01,
  -1.569941002593678e-02,   2.455817274508023e-04,  -3.259006614227821e-06,   7.589158756250507e-09,   1.956156724233948e-09,  -9.855782613447936e-11,   2.786385661304604e-12,
  -3.248939918005357e-14,  -1.241724545191519e-15,   9.764478043302600e-01,  -1.569947833749948e-02,   2.455820296152251e-04,  -3.258868813605898e-06,   7.578786463353756e-09,
   1.956566218755937e-09,  -9.856414939855831e-11,   2.786069852073058e-12,  -3.246251733623022e-14,  -1.242670540086713e-15,   5.985888795263262e-03,  -9.062352765339595e-05,
   1.364950474845430e-06,  -1.996658077803250e-08,   2.561742282864796e-10,  -1.657841349732966e-12,  -5.217749747894965e-14,   2.517628393570514e-15,  -4.639653726112464e-17,
  -4.571282818738459e-19,   5.986083476301543e-03,  -9.063205992624594e-05,   1.365168563785834e-06,  -1.996887690378874e-08,   2.560607623781840e-10,  -1.650362218939792e-12,
  -5.235420441536779e-14,   2.514882832823894e-15,  -4.600389087978579e-17,  -4.722165822810676e-19,   5.986403099071039e-03,  -9.064606772718107e-05,   1.365526521405759e-06,
  -1.997263869218144e-08,   2.558742214460702e-10,  -1.638090207125180e-12,  -5.264316168972981e-14,   2.510320108210730e-15,  -4.535843359134279e-17,  -4.969299844030467e-19,
   5.986742273888838e-03,  -9.066093202882910e-05,   1.365906245970056e-06,  -1.997661981491139e-08,   2.556759234487104e-10,  -1.625077134727350e-12,  -5.294822276530665e-14,
   2.505403470717180e-15,  -4.467238984117706e-17,  -5.230756069268846e-19,   5.987009228228741e-03,  -9.067263099352889e-05,   1.366205021522605e-06,  -1.997974543393849e-08,
   2.555195993479051e-10,  -1.614841969912441e-12,  -5.318718782822053e-14,   2.501479671744687e-15,  -4.413163632374687e-17,  -5.435961051662548e-19,   5.987163301606503e-03,
  -9.067938296754781e-05,   1.366377422784258e-06,  -1.998154626614351e-08,   2.554292766653757e-10,  -1.608937554915553e-12,  -5.332465010579105e-14,   2.499193403089602e-15,
  -4.381922577524033e-17,  -5.554162277058711e-19,   5.987221159356640e-03,  -9.068191845244106e-05,   1.366442155886382e-06,  -1.998222192515458e-08,   2.553953397860214e-10,
  -1.606720862671657e-12,  -5.337618362690317e-14,   2.498330775815479e-15,  -4.370185027757260e-17,  -5.598505052064462e-19,   5.987230750194705e-03,  -9.068233874807081e-05,
   1.366452886045709e-06,  -1.998233389516633e-08,   2.553897132179579e-10,  -1.606353439273445e-12,  -5.338472156419804e-14,   2.498187566230468e-15,  -4.368239033449114e-17,
  -5.605853232109367e-19,   5.445366746902103e-02,  -8.243910908144744e-04,   1.241499735523038e-05,  -1.814299769332904e-07,   2.314889440906263e-09,  -1.419633925866444e-11,
  -5.134706987255610e-13,   2.418838255304503e-14,  -4.511536494585566e-16,  -3.927358844421083e-18,   5.445543817628321e-02,  -8.244686163798017e-04,   1.241696757452395e-05,
  -1.814495727230791e-07,   2.313773043724337e-09,  -1.412444395296382e-11,  -5.151920424356331e-13,   2.416442484029661e-14,  -4.474837478776424e-16,  -4.070779553412844e-18,
   5.445834528054386e-02,  -8.245958930507088e-04,   1.242020131306746e-05,  -1.814816686018812e-07,   2.311937681982541e-09,  -1.400647040728842e-11,  -5.180072880082550e-13,
   2.412456719426184e-14,  -4.414503641179614e-16,  -4.305714896902069e-18,   5.446143021697231e-02,  -8.247309514539411e-04,   1.242363161377724e-05,  -1.815156245664834e-07,
   2.309986676215035e-09,  -1.388136568848897e-11,  -5.209800360856457e-13,   2.408155972605068e-14,  -4.350368349965435e-16,  -4.554298045067559e-18,   5.446385827659704e-02,
  -8.248372489229319e-04,   1.242633059298635e-05,  -1.815422755352246e-07,   2.308448664761155e-09,  -1.378296192349131e-11,  -5.233091354219629e-13,   2.404719547235565e-14,
  -4.299810095226468e-16,  -4.749423121740417e-18,   5.446525963682237e-02,  -8.248985975909769e-04,   1.242788795166866e-05,  -1.815576272555897e-07,   2.307560024573272e-09,
  -1.372619311564408e-11,  -5.246491042897450e-13,   2.402715616691996e-14,  -4.270598770093722e-16,  -4.861827625915577e-18,   5.446578587655404e-02,  -8.249216350640165e-04,
   1.242847270333630e-05,  -1.815633864847899e-07,   2.307226138133947e-09,  -1.370488002773955e-11,  -5.251514816955446e-13,   2.401959211206462e-14,  -4.259623391405069e-16,
  -4.903997570404522e-18,   5.446587310911502e-02,  -8.249254538780309e-04,   1.242856963155113e-05,  -1.815643408696335e-07,   2.307170781491439e-09,  -1.370134729848132e-11,
  -5.252347160325635e-13,   2.401833620000051e-14,  -4.257803737146495e-16,  -4.910985778323260e-18,   1.547336285152884e-01,  -2.342486425411917e-03,   3.526549121725400e-05,
  -5.142256550362556e-07,   6.478015467706294e-09,  -3.461142677269903e-11,  -1.712298053644162e-12,   7.721971786364495e-14,  -1.478274883025500e-15,  -9.411905459354011e-18,
   1.547386581339997e-01,  -2.342706126452984e-03,   3.527100131114780e-05,  -5.142729705337740e-07,   6.474293469051539e-09,  -3.438164567188998e-11,  -1.717958669236698e-12,
   7.715949728319075e-14,  -1.467232948525478e-15,  -9.860315239099752e-18,   1.547469156307059e-01,  -2.343066815425748e-03,   3.528004470419353e-05,  -5.143504106607752e-07,
   6.468174594891005e-09,  -3.400456066078710e-11,  -1.727219513332125e-12,   7.705898589948718e-14,  -1.449075777584894e-15,  -1.059502086502751e-17,   1.547556782387918e-01,
  -2.343449553505458e-03,   3.528963729018486e-05,  -5.144322600675534e-07,   6.461670320584740e-09,  -3.360463362264999e-11,  -1.737002484831595e-12,   7.695009663896710e-14,
  -1.429769108441345e-15,  -1.137264087858552e-17,   1.547625750118202e-01,  -2.343750784257788e-03,   3.529718442068193e-05,  -5.144964439560711e-07,   6.456542990219202e-09,
  -3.329002753144371e-11,  -1.744670203438768e-12,   7.686278152843044e-14,  -1.414545589872328e-15,  -1.198320243833412e-17,   1.547665554966025e-01,  -2.343924635965851e-03,
   3.530153910055718e-05,  -5.145333927476197e-07,   6.453580534557333e-09,  -3.310851826058047e-11,  -1.749082742573247e-12,   7.681174219510792e-14,  -1.405748233136739e-15,
  -1.233499290673211e-17,   1.547680502502149e-01,  -2.343989920058877e-03,   3.530317415279635e-05,  -5.145472498135730e-07,   6.452467466295701e-09,  -3.304037037951630e-11,
  -1.750737302276931e-12,   7.679245401751122e-14,  -1.402442562211763e-15,  -1.246698433158336e-17,   1.547682980292371e-01,  -2.344000741887009e-03,   3.530344517696130e-05,
  -5.145495458936266e-07,   6.452282925730709e-09,  -3.302907445633746e-11,  -1.751011442975191e-12,   7.678925027108543e-14,  -1.401894485394900e-15,  -1.248885801825903e-17,
   3.149809691735044e-01,  -4.768164858362125e-03,   7.174025336903997e-05,  -1.041746621380787e-06,   1.280242106460481e-08,  -4.814122465738966e-11,  -4.487892478201098e-12,
   1.915643756067924e-13,  -3.838610190430301e-15,  -1.025401970022389e-17,   3.149912002086905e-01,  -4.768609826997973e-03,   7.175112928521103e-05,  -1.041810309223030e-06,
   1.279266631727244e-08,  -4.757010277169099e-11,  -4.502674138355794e-12,   1.914829451674920e-13,  -3.813937383095807e-15,  -1.133286118399119e-17,   3.150079972189838e-01,
  -4.769340333573047e-03,   7.176897778700775e-05,  -1.041914276284794e-06,   1.277662978894100e-08,  -4.663270839633002e-11,  -4.526869076375458e-12,   1.913452891224817e-13,
  -3.773347013887351e-15,  -1.310131739183891e-17,   3.150258216537413e-01,  -4.770115482617108e-03,   7.178790816330118e-05,  -1.042023795928266e-06,   1.275958323108529e-08,
  -4.563832973222811e-11,  -4.552444400317806e-12,   1.911938288422190e-13,  -3.730161415698403e-15,  -1.497416762545229e-17,   3.150398506695911e-01,  -4.770725547090141e-03,
   7.180280047995953e-05,  -1.042109411185911e-06,   1.274614542072793e-08,  -4.485594710764247e-11,  -4.572501707839893e-12,   1.910707258954264e-13,  -3.696090669168964e-15,
  -1.644546328899054e-17,   3.150479475266192e-01,  -4.771077634457664e-03,   7.181139272450119e-05,  -1.042158590055395e-06,   1.273838136272511e-08,  -4.440449962175702e-11,
  -4.584048835292466e-12,   1.909981177424661e-13,  -3.676394517305399e-15,  -1.729350660293342e-17,   3.150509880596580e-01,  -4.771209848128921e-03,   7.181461874341727e-05,
  -1.042177013482371e-06,   1.273546421373595e-08,  -4.423499202296278e-11,  -4.588379536438558e-12,   1.909705574018502e-13,  -3.668992153534881e-15,  -1.761175195317912e-17,
   3.150514920758937e-01,  -4.771231764509273e-03,   7.181515347825452e-05,  -1.042180065122370e-06,   1.273498056658681e-08,  -4.420689452923366e-11,  -4.589097129277484e-12,
   1.909659733089940e-13,  -3.667764775954673e-15,  -1.766449492170014e-17,   5.530917148220434e-01,  -8.371743846538937e-03,   1.258129841770958e-04,  -1.812065085008709e-06,
   2.114165534665776e-08,  -5.030003102555315e-12,  -1.155989868789226e-11,   4.681159506699267e-13,  -1.017065062888922e-14,   3.012175945770213e-17,   5.531096549457013e-01,
  -8.372517438223131e-03,   1.258308931630043e-04,  -1.812060420287672e-06,   2.111651176344891e-08,  -3.629809964789543e-12,  -1.159939709812293e-11,   4.682027072678588e-13,
  -1.012138073726442e-14,   2.760342509322858e-17,   5.531391083820290e-01,  -8.373787409998232e-03,   1.258602779974481e-04,  -1.812051321746483e-06,   2.107517411112328e-08,
  -1.331022819771956e-12,  -1.166409672177656e-11,   4.683358238728677e-13,  -1.004023220801956e-14,   2.347134585663085e-17,   5.531703632269893e-01,  -8.375134942294594e-03,
   1.258914362685639e-04,  -1.812039709468527e-06,   2.103122971255859e-08,   1.108352016492631e-12,  -1.173255270481991e-11,   4.684644247807113e-13,  -9.953769994347894e-15,
   1.908993195835163e-17,   5.531949627437737e-01,  -8.376195452822831e-03,   1.259159425472386e-04,  -1.812029152837381e-06,   2.099658599889956e-08,   3.028277397503502e-12,
  -1.178628618409866e-11,   4.685564820880806e-13,  -9.885466213166839e-15,   1.564400631910918e-17,   5.532091603230538e-01,  -8.376807492331549e-03,   1.259300794037496e-04,
  -1.812022492097846e-06,   2.097656871930099e-08,   4.136350960379652e-12,  -1.181723990353203e-11,   4.686059427594683e-13,  -9.845943905983750e-15,   1.365622757968935e-17,
   5.532144917907673e-01,  -8.377037318895058e-03,   1.259353867621918e-04,  -1.812019883507448e-06,   2.096904755316120e-08,   4.552452161649358e-12,  -1.182885256148297e-11,
   4.686238227116350e-13,  -9.831083491055616e-15,   1.290997577639315e-17,   5.532153755650027e-01,  -8.377075415918572e-03,   1.259362664709915e-04,  -1.812019445429514e-06,
   2.096780057604343e-08,   4.621427335031734e-12,  -1.183077695720744e-11,   4.686267500134601e-13,  -9.828619142491078e-15,   1.278628335988660e-17,   9.171331151454953e-01,
  -1.387831117676745e-02,   2.079764716658740e-04,  -2.932809249975231e-06,   2.922311426613516e-08,   3.561703653811332e-10,  -3.720242874276203e-11,   1.486019118342288e-12,
  -3.848058091726718e-14,   5.016293237132397e-16,   9.171627609670381e-01,  -1.387956132570961e-02,   2.080009626071567e-04,  -2.932264545934749e-06,   2.914190048047656e-08,
   3.606490336874200e-10,  -3.735423977857300e-11,   1.488405834445989e-12,  -3.840853204807540e-14,   4.948351924908640e-16,   9.172114318268904e-01,  -1.388161347061035e-02,
   2.080411177595502e-04,  -2.931365703896902e-06,   2.900834150393559e-08,   3.680065281438968e-10,  -3.760324774869387e-11,   1.492298637210182e-12,  -3.828904697249190e-14,
   4.836522906734203e-16,   9.172630786922809e-01,  -1.388379071373631e-02,   2.080836565070888e-04,  -2.930405678264209e-06,   2.886630807725787e-08,   3.758202119662627e-10,
  -3.786717113798409e-11,   1.496394652219772e-12,  -3.816062669799567e-14,   4.717468076568784e-16,   9.173037274492519e-01,  -1.388550404024994e-02,   2.081170847248930e-04,
  -2.929645580519862e-06,   2.875429763222710e-08,   3.819745315946696e-10,  -3.807466636994356e-11,   1.499593176711689e-12,  -3.805837423741408e-14,   4.623486247068750e-16,
   9.173271876040484e-01,  -1.388649276402440e-02,   2.081363567401829e-04,  -2.929205087653164e-06,   2.868956231098656e-08,   3.855282698820230e-10,  -3.819432970683488e-11,
   1.501429047023716e-12,  -3.799888748403417e-14,   4.569133685259814e-16,   9.173359973072512e-01,  -1.388686402629161e-02,   2.081435897790443e-04,  -2.929039333059767e-06,
   2.866523618928455e-08,   3.868631034887495e-10,  -3.823924812487557e-11,   1.502116531208374e-12,  -3.797645988263878e-14,   4.548702300544735e-16,   9.173374576512453e-01,
  -1.388692556762212e-02,   2.081447885585307e-04,  -2.929011838653493e-06,   2.866120287048176e-08,   3.870843907377314e-10,  -3.824669313139495e-11,   1.502230391097353e-12,
  -3.797273745329180e-14,   4.545314375431148e-16,   5.643811054046268e-03,  -8.059549583756351e-05,   1.148687725981245e-06,  -1.618020032324319e-08,   2.153212662370908e-10,
  -2.234342233040612e-12,  -2.501946374734091e-15,   1.088058729666609e-15,  -3.678141316013129e-17,   6.207026189154581e-19,   5.643974890383457e-03,  -8.060241465085383e-05,
   1.148871535829398e-06,  -1.618335205104374e-08,   2.153141933321534e-10,  -2.231042279749867e-12,  -2.647853300960075e-15,   1.091101159986976e-15,  -3.675088017242406e-17,
   6.156041840960961e-19,   5.644243873153737e-03,  -8.061377396893587e-05,   1.149173284536769e-06,  -1.618852270823278e-08,   2.153023572586220e-10,  -2.225618390553942e-12,
  -2.887289706873966e-15,   1.096076751718454e-15,  -3.669979758130073e-17,   6.072115416396519e-19,   5.644529310359743e-03,  -8.062582839613857e-05,   1.149493456493994e-06,
  -1.619400453152191e-08,   2.152894928904630e-10,  -2.219854438298671e-12,  -3.141221750675998e-15,   1.101330302817268e-15,  -3.664429392863481e-17,   5.982755344757091e-19,
   5.644753969546584e-03,  -8.063531624373357e-05,   1.149745428565354e-06,  -1.619831539031452e-08,   2.152791475273262e-10,  -2.215311833697928e-12,  -3.340973386096494e-15,
   1.105446060796496e-15,  -3.659967071802024e-17,   5.912206823666337e-19,   5.644883632214470e-03,  -8.064079224678524e-05,   1.149890844574526e-06,  -1.620080192145268e-08,
   2.152730884347336e-10,  -2.212687670699316e-12,  -3.456215802896593e-15,   1.107813791753792e-15,  -3.657354053018097e-17,   5.871403387484272e-19,   5.644932323245263e-03,
  -8.064284861231780e-05,   1.149945449351546e-06,  -1.620173538338991e-08,   2.152707964450304e-10,  -2.211701792570644e-12,  -3.499483217554166e-15,   1.108701469197243e-15,
  -3.656365709757534e-17,   5.856064605180590e-19,   5.644940394554934e-03,  -8.064318948813358e-05,   1.149954500854811e-06,  -1.620189010460009e-08,   2.152704156318741e-10,
  -2.211538343915980e-12,  -3.506655026783480e-15,   1.108848539015427e-15,  -3.656201501689631e-17,   5.853521103211221e-19,   5.134181062327029e-02,  -7.331750074277160e-04,
   1.044908593062664e-05,  -1.471322461356608e-07,   1.954050529534123e-09,  -2.003523306460307e-11,  -3.688274702468881e-14,   1.044447655096463e-14,  -3.510836188814335e-16,
   6.001624937512778e-18,   5.134330095905837e-02,  -7.332379211549777e-04,   1.045075383702300e-05,  -1.471604898354342e-07,   1.953955255837511e-09,  -2.000355191989389e-11,
  -3.827613065144238e-14,   1.047394434782923e-14,  -3.508249583223418e-16,   5.954200976158287e-18,   5.134574775799038e-02,  -7.333412128756475e-04,   1.045349191133562e-05,
  -1.472068236609288e-07,   1.953796701906139e-09,  -1.995147937910992e-11,  -4.056279854162076e-14,   1.052214324304259e-14,  -3.503912751943647e-16,   5.876126724296988e-18,
   5.134834423390782e-02,  -7.334508251327264e-04,   1.045639713214282e-05,  -1.472559428468938e-07,   1.953625547034320e-09,  -1.989614122988176e-11,  -4.298803263397860e-14,
   1.057304463887151e-14,  -3.499188089843663e-16,   5.792985972953374e-18,   5.135038784289971e-02,  -7.335370990640447e-04,   1.045868349214931e-05,  -1.472945675968756e-07,
   1.953488735896935e-09,  -1.985252832455755e-11,  -4.489589892384629e-14,   1.061292920913017e-14,  -3.495380775733537e-16,   5.727339041865783e-18,   5.135156731727356e-02,
  -7.335868928462443e-04,   1.046000296936163e-05,  -1.473168457358957e-07,   1.953408933364959e-09,  -1.982733387020774e-11,  -4.599663921269677e-14,   1.063587707379615e-14,
  -3.493147845439141e-16,   5.689367169563552e-18,   5.135201023441845e-02,  -7.336055915508461e-04,   1.046049844126627e-05,  -1.473252089480774e-07,   1.953378806811856e-09,
  -1.981786846010323e-11,  -4.640991595581248e-14,   1.064448092408494e-14,  -3.492302620310577e-16,   5.675092186265628e-18,   5.135208365494971e-02,  -7.336086911627654e-04,
   1.046058057256700e-05,  -1.473265951409019e-07,   1.953373804469097e-09,  -1.981629918816772e-11,  -4.647841920047518e-14,   1.064590643340305e-14,  -3.492162156746674e-16,
   5.672725051490906e-18,   1.458912534285753e-01,  -2.083347166214900e-03,   2.968837241925686e-05,  -4.177094600380289e-07,   5.522345291779380e-09,  -5.506529782225704e-11,
  -1.960499006909111e-13,   3.323735283039464e-14,  -1.106251589388922e-15,   1.944591354510283e-17,   1.458954877787693e-01,  -2.083525769250893e-03,   2.969308494818748e-05,
  -4.177869691275640e-07,   5.521874612114596e-09,  -5.496444606763714e-11,  -2.004450455560738e-13,   3.333316996707652e-14,  -1.105659787128345e-15,   1.930485696535776e-17,
   1.459024396343873e-01,  -2.083818998765199e-03,   2.970082102027255e-05,  -4.179141084820693e-07,   5.521095141317384e-09,  -5.479867711397030e-11,  -2.076585227237321e-13,
   3.348994159807803e-14,  -1.104660338301937e-15,   1.907257386361859e-17,   1.459098167489590e-01,  -2.084130170171401e-03,   2.970902917138552e-05,  -4.180488712153333e-07,
   5.520258857849723e-09,  -5.462250617047149e-11,  -2.153100014654744e-13,   3.365556977720705e-14,  -1.103561923395230e-15,   1.882513426046845e-17,   1.459156230536322e-01,
  -2.084375087023793e-03,   2.971548872408334e-05,  -4.181548273305288e-07,   5.519594035233689e-09,  -5.448365845515052e-11,  -2.213298542127230e-13,   3.378539858241431e-14,
  -1.102670015573560e-15,   1.862969911008214e-17,   1.459189741766950e-01,  -2.084516442671985e-03,   2.971921653526264e-05,  -4.182159354140491e-07,   5.519207682631397e-09,
  -5.440344661390702e-11,  -2.248032554362695e-13,   3.386011593435976e-14,  -1.102144277504320e-15,   1.851663047427109e-17,   1.459202325928472e-01,  -2.084569524888976e-03,
   2.972061634211155e-05,  -4.182388743045210e-07,   5.519062098693766e-09,  -5.437331114780292e-11,  -2.261074045754297e-13,   3.388813342203102e-14,  -1.101944778702445e-15,
   1.847411942180451e-17,   1.459204411952426e-01,  -2.084578324119373e-03,   2.972084837890144e-05,  -4.182426763422543e-07,   5.519037939448708e-09,  -5.436831496566075e-11,
  -2.263235781449976e-13,   3.389277563039270e-14,  -1.101911599255166e-15,   1.846706983134889e-17,   2.969817626545723e-01,  -4.240867557021821e-03,   6.042198493126937e-05,
  -8.488850900658875e-07,   1.112669008816469e-08,  -1.049356832101286e-10,  -7.532332102260230e-13,   8.168987024643586e-14,  -2.690121137372077e-15,   4.964387425181635e-17,
   2.969903802319487e-01,  -4.241230484516868e-03,   6.043147549565684e-05,  -8.490323234828441e-07,   1.112495505321737e-08,  -1.046876422003680e-10,  -7.639408962079946e-13,
   8.193589108637315e-14,  -2.689634619830831e-15,   4.933619542315334e-17,   2.970045283548683e-01,  -4.241826333693120e-03,   6.044705468231579e-05,  -8.492737742221528e-07,
   1.112209019883752e-08,  -1.042799167715147e-10,  -7.815175196485024e-13,   8.233862094931604e-14,  -2.688770556694324e-15,   4.882925027434972e-17,   2.970195419318420e-01,
  -4.242458636779763e-03,   6.046358388831700e-05,  -8.495296228882079e-07,   1.111902792508561e-08,  -1.038465751201079e-10,  -8.001651584010953e-13,   8.276437750339343e-14,
  -2.687764877130388e-15,   4.828884850983786e-17,   2.970313586551673e-01,  -4.242956306805874e-03,   6.047659135892187e-05,  -8.497307240499054e-07,   1.111660165243069e-08,
  -1.035050174830163e-10,  -8.148390443468288e-13,   8.309830982404807e-14,  -2.686909075474578e-15,   4.786174997704644e-17,   2.970381787018083e-01,  -4.243243539605562e-03,
   6.048409778163043e-05,  -8.498466819385815e-07,   1.111519489085621e-08,  -1.033076916190439e-10,  -8.233068410094007e-13,   8.329057064218633e-14,  -2.686389389628671e-15,
   4.761454373315245e-17,   2.970407397698203e-01,  -4.243351401721440e-03,   6.048691643410994e-05,  -8.498902060806882e-07,   1.111466540708295e-08,  -1.032335548498495e-10,
  -8.264864303841516e-13,   8.336267980067135e-14,  -2.686189368537149e-15,   4.752157960853983e-17,   2.970411643073360e-01,  -4.243369281587406e-03,   6.048738366167418e-05,
  -8.498974198172277e-07,   1.111457757263912e-08,  -1.032212635656915e-10,  -8.270134847135161e-13,   8.337462834976227e-14,  -2.686155955057269e-15,   4.750616232012078e-17,
   5.214880390708289e-01,  -7.446554618045323e-03,   1.060562961448976e-04,  -1.485854738260500e-06,   1.914801980136765e-08,  -1.595114856778434e-10,  -2.574875641537212e-12,
   1.945265069570720e-13,  -6.387838461927770e-15,   1.282887086466059e-16,   5.215031644720575e-01,  -7.447189745455400e-03,   1.060726125575718e-04,  -1.486076731023687e-06,
   1.914222033082231e-08,  -1.589199319224214e-10,  -2.600386383288028e-12,   1.951680596380389e-13,  -6.390757282343390e-15,   1.277093102642019e-16,   5.215279969397071e-01,
  -7.448232477242904e-03,   1.060993949148529e-04,  -1.486440555384776e-06,   1.913266017246607e-08,  -1.579474252220634e-10,  -2.642273974038988e-12,   1.962190906756086e-13,
  -6.395404860310460e-15,   1.267533481634752e-16,   5.215543483816233e-01,  -7.449338987699968e-03,   1.061278080582715e-04,  -1.486825767685049e-06,   1.912246256673897e-08,
  -1.569136536743370e-10,  -2.686730018057551e-12,   1.973313412862006e-13,  -6.400140277499539e-15,   1.257325062329636e-16,   5.215750887515276e-01,  -7.450209883367775e-03,
   1.061501657153177e-04,  -1.487128327730740e-06,   1.911439822925526e-08,  -1.560987204937539e-10,  -2.721724271812458e-12,   1.982045271068737e-13,  -6.403725052140440e-15,
   1.249244073061547e-16,   5.215870590845681e-01,  -7.450712520766119e-03,   1.061630672953939e-04,  -1.487302698713354e-06,   1.910972860070327e-08,  -1.556278663358358e-10,
  -2.741922932277003e-12,   1.987075908835612e-13,  -6.405736933665466e-15,   1.244561604228377e-16,   5.215915541883976e-01,  -7.450901271108885e-03,   1.061679116904496e-04,
  -1.487368130923462e-06,   1.910797217102986e-08,  -1.554509538790551e-10,  -2.749508250874074e-12,   1.988963318181897e-13,  -6.406481644994723e-15,   1.242799746332852e-16,
   5.215922993227797e-01,  -7.450932559443702e-03,   1.061687147036722e-04,  -1.487378974830670e-06,   1.910768086268838e-08,  -1.554216227260561e-10,  -2.750765653305575e-12,
   1.989276096435053e-13,  -6.406604523289935e-15,   1.242507506283806e-16,   8.647362133614651e-01,  -1.234703850138515e-02,   1.756992346163998e-04,  -2.444892010920258e-06,
   3.014511920996298e-08,  -1.585453005721054e-10,  -9.896245361676147e-12,   5.671457245168672e-13,  -1.930891537034490e-14,   4.619283977833653e-16,   8.647612681594918e-01,
  -1.234808302202100e-02,   1.757248484581573e-04,  -2.445102971473375e-06,   3.012307024597069e-08,  -1.568128897276643e-10,  -9.973965691799716e-12,   5.694958625258901e-13,
  -1.934690469037428e-14,   4.613344973857064e-16,   8.648024022807237e-01,  -1.234979783338231e-02,   1.757668838238854e-04,  -2.445447499840550e-06,   3.008675297757331e-08,
  -1.539637915341234e-10,  -1.010166373801739e-11,   5.733516756829966e-13,  -1.940894551216457e-14,   4.603436700185696e-16,   8.648460523163980e-01,  -1.235161746431312e-02,
   1.758114676624205e-04,  -2.445810625218001e-06,   3.004805392580420e-08,  -1.509337966362114e-10,  -1.023730688158771e-11,   5.774398077927914e-13,  -1.947433303382753e-14,
   4.592707770698919e-16,   8.648804076963355e-01,  -1.235304958366289e-02,   1.758465416371851e-04,  -2.446094633689969e-06,   3.001747903036706e-08,  -1.485441945624292e-10,
  -1.034416379360875e-11,   5.806548588014660e-13,  -1.952547200244652e-14,   4.584107908713197e-16,   8.649002358888676e-01,  -1.235387611181340e-02,   1.758667779954172e-04,
  -2.446257829043886e-06,   2.999978612110161e-08,  -1.471631129233470e-10,  -1.040587498010570e-11,   5.825093850887287e-13,  -1.955485618705484e-14,   4.579082132927908e-16,
   8.649076817671720e-01,  -1.235418648589270e-02,   1.758743759048528e-04,  -2.446318975955245e-06,   2.999313326956699e-08,  -1.466441259426382e-10,  -1.042905606161884e-11,
   5.832055990092054e-13,  -1.956586580102906e-14,   4.577183062279726e-16,   8.649089160383577e-01,  -1.235423793507823e-02,   1.758756353119737e-04,  -2.446329104829897e-06,
   2.999202998996442e-08,  -1.465580765308143e-10,  -1.043289907497219e-11,   5.833209969571488e-13,  -1.956768951197096e-14,   4.576867639312450e-16,   5.338656610350156e-03,
  -7.212745102526208e-05,   9.737340522450834e-07,  -1.308758626168615e-08,   1.719021284810257e-10,  -2.041191294146140e-12,   1.481114848692003e-14,   2.584427138599972e-16,
  -1.614295052083263e-17,   4.565825190175293e-19,   5.338795475378305e-03,  -7.213304864088456e-05,   9.738810041990047e-07,  -1.309048415701703e-08,   1.719329678123074e-10,
  -2.040381661617037e-12,   1.474587737469490e-14,   2.607767946087070e-16,  -1.618886449081136e-17,   4.564079308824611e-19,   5.339023459945955e-03,  -7.214223892571680e-05,
   9.741222684061144e-07,  -1.309524067304611e-08,   1.719834943609192e-10,  -2.039047480659338e-12,   1.463859348891778e-14,   2.646078210281982e-16,  -1.626398848545419e-17,
   4.561082760282865e-19,   5.339265389784791e-03,  -7.215199174159725e-05,   9.743782938830938e-07,  -1.310028654863295e-08,   1.720369692782503e-10,  -2.037624965241423e-12,
   1.452457963746657e-14,   2.686717972322137e-16,  -1.634335848543818e-17,   4.557725865719251e-19,   5.339455804749562e-03,  -7.215966813735612e-05,   9.745798057193483e-07,
  -1.310425684035947e-08,   1.720789545662496e-10,  -2.036500481974970e-12,   1.443472204093560e-14,   2.718693947755922e-16,  -1.640557447540074e-17,   4.554955507993014e-19,
   5.339565702926284e-03,  -7.216409868753050e-05,   9.746961095234794e-07,  -1.310654783635347e-08,   1.721031450826626e-10,  -2.035849534273547e-12,   1.438281222140270e-14,
   2.737144740792728e-16,  -1.644138063992282e-17,   4.553305160936738e-19,   5.339606971914230e-03,  -7.216576246971932e-05,   9.747397841528459e-07,  -1.310740806434694e-08,
   1.721122212956310e-10,  -2.035604721515177e-12,   1.436330989481811e-14,   2.744072590142671e-16,  -1.645480729986858e-17,   4.552675698581685e-19,   5.339613812899298e-03,
  -7.216603826894236e-05,   9.747470239213473e-07,  -1.310755065608296e-08,   1.721137254085968e-10,  -2.035564120491765e-12,   1.436007659503464e-14,   2.745220948119156e-16,
  -1.645703196260564e-17,   4.552570842254202e-19,   4.856582423084990e-02,  -6.561435222888044e-04,   8.857931069032469e-06,  -1.190420215590273e-07,   1.562466189998003e-09,
  -1.848237025382009e-11,   1.302305245668108e-13,   2.543060977167053e-15,  -1.535432122342614e-16,   4.340431684956237e-18,   4.856708746545788e-02,  -6.561944366210660e-04,
   8.859266701003705e-06,  -1.190682558455242e-07,   1.562736792287320e-09,  -1.847441576953599e-11,   1.296095816525059e-13,   2.565259959954082e-15,  -1.539855747683965e-16,
   4.339158028320701e-18,   4.856916140719699e-02,  -6.562780288192509e-04,   8.861459521754627e-06,  -1.191113153443761e-07,   1.563180066885506e-09,  -1.846130927272680e-11,
   1.285889426896049e-13,   2.601697542291303e-15,  -1.547094601760687e-16,   4.336944612418833e-18,   4.857136220682000e-02,  -6.563667375849358e-04,   8.863786497587048e-06,
  -1.191569934549805e-07,   1.563649105832582e-09,  -1.844733714175413e-11,   1.275042562028819e-13,   2.640352717669222e-15,  -1.554743906847160e-16,   4.334429413901509e-18,
   4.857309438319716e-02,  -6.564365598004438e-04,   8.865618001386421e-06,  -1.191929341322527e-07,   1.564017292885303e-09,  -1.843629385488689e-11,   1.266493673089645e-13,
   2.670768616477334e-15,  -1.560740943741865e-16,   4.332329242215262e-18,   4.857409411037755e-02,  -6.564768587530480e-04,   8.866675062732303e-06,  -1.192136728915917e-07,
   1.564229400127932e-09,  -1.842990166145638e-11,   1.261555001521949e-13,   2.688319785870008e-15,  -1.564192705803958e-16,   4.331068784856064e-18,   4.857446952814262e-02,
  -6.564919920127565e-04,   8.867072011995864e-06,  -1.192214598758088e-07,   1.564308976516917e-09,  -1.842749775783601e-11,   1.259699548561423e-13,   2.694909955515888e-15,
  -1.565487126596446e-16,   4.330586318070023e-18,   4.857453175955249e-02,  -6.564945005989390e-04,   8.867137812662390e-06,  -1.192227506468520e-07,   1.564322163643852e-09,
  -1.842709908799928e-11,   1.259391931499785e-13,   2.696002345535901e-15,  -1.565701602973742e-16,   4.330505859384365e-18,   1.380031425420008e-01,  -1.864472215959554e-03,
   2.516954210996468e-05,  -3.381653708717438e-07,   4.431407118046097e-09,  -5.196790702515130e-11,   3.411705198636161e-13,   8.464362633235500e-15,  -4.797827883018952e-16,
   1.356201753332322e-17,   1.380067319697987e-01,  -1.864616846645984e-03,   2.517332982441203e-05,  -3.382391010701099e-07,   4.432112283688087e-09,  -5.194150221028048e-11,
   3.392293829082757e-13,   8.533796286321864e-15,  -4.812056553601573e-16,   1.356068019767191e-17,   1.380126249868543e-01,  -1.864854304030282e-03,   2.517954839869237e-05,
  -3.383601135053846e-07,   4.433266916764595e-09,  -5.189800449211675e-11,   3.360386337255865e-13,   8.647775099968753e-15,  -4.835346957487402e-16,   1.355811197130254e-17,
   1.380188784640593e-01,  -1.865106295522459e-03,   2.518614736732564e-05,  -3.384884794326510e-07,   4.434487976822992e-09,  -5.185164627927997e-11,   3.326474969704304e-13,
   8.768704117203510e-15,  -4.859966820210613e-16,   1.355487987355318e-17,   1.380238003677104e-01,  -1.865304636487229e-03,   2.519134120995979e-05,  -3.385894767880138e-07,
   4.435445990020570e-09,  -5.181501459461494e-11,   3.299746771261002e-13,   8.863867100877096e-15,  -4.879275184932460e-16,   1.355196880972862e-17,   1.380266410485779e-01,
  -1.865419111888722e-03,   2.519433884605573e-05,  -3.386477533700683e-07,   4.435997687773664e-09,  -5.179381459982705e-11,   3.284305490163531e-13,   8.918783800104666e-15,
  -4.890391250849801e-16,   1.355014141484198e-17,   1.380277077816043e-01,  -1.865462100232246e-03,   2.519546451993056e-05,  -3.386696347307034e-07,   4.436204630663701e-09,
  -5.178584261454911e-11,   3.278504130810470e-13,   8.939404840296939e-15,  -4.894560300260606e-16,   1.354942734531466e-17,   1.380278846094083e-01,  -1.865469226254764e-03,
   2.519565111816017e-05,  -3.386732617698821e-07,   4.436238922532150e-09,  -5.178452055428314e-11,   3.277542314026424e-13,   8.942823033978251e-15,  -4.895251108301338e-16,
   1.354930750781087e-17,   2.809245871840264e-01,  -3.795374363552958e-03,   5.123283569924044e-05,  -6.880066501350721e-07,   8.989007579005522e-09,  -1.037017723131207e-10,
   5.841100252079561e-13,   2.201625962640913e-14,  -1.147301726147055e-15,   3.253499405896971e-17,   2.809318934411777e-01,  -3.795668607956667e-03,   5.124051763344456e-05,
  -6.881536449118721e-07,   8.990199133850650e-09,  -1.036333106627069e-10,   5.794642630128221e-13,   2.218313528438809e-14,  -1.150892012504174e-15,   3.254313351745954e-17,
   2.809438886363196e-01,  -3.796151703002105e-03,   5.125312948979050e-05,  -6.883948891055191e-07,   8.992148056889881e-09,  -1.035205592170137e-10,   5.718272356049650e-13,
   2.245711240320572e-14,  -1.156771547456244e-15,   3.255564502901130e-17,   2.809566175413627e-01,  -3.796664365652137e-03,   5.126651261767338e-05,  -6.886507704324124e-07,
   8.994206211173748e-09,  -1.034004311533895e-10,   5.637098424085360e-13,   2.274785380222674e-14,  -1.162990411339437e-15,   3.256776332206593e-17,   2.809666360355541e-01,
  -3.797067878347994e-03,   5.127704591260461e-05,  -6.888520796952994e-07,   8.995818884479882e-09,  -1.033055348970477e-10,   5.573113533347147e-13,   2.297668953017521e-14,
  -1.167870316715051e-15,   3.257646158284309e-17,   2.809724182167453e-01,  -3.797300771248438e-03,   5.128312516422920e-05,  -6.889682308202389e-07,   8.996746739539681e-09,
  -1.032506261691554e-10,   5.536146344516224e-13,   2.310876295936501e-14,  -1.170680826289289e-15,   3.258114494609061e-17,   2.809745895423071e-01,  -3.797388228218709e-03,
   5.128540803672989e-05,  -6.890118413509026e-07,   8.997094619350448e-09,  -1.032299805098145e-10,   5.522257195653589e-13,   2.315835927665245e-14,  -1.171735106131611e-15,
   3.258283994408284e-17,   2.809749494737128e-01,  -3.797402725641159e-03,   5.128578645832093e-05,  -6.890190701370547e-07,   8.997152256967912e-09,  -1.032265567778887e-10,
   5.519954469566636e-13,   2.316658065035424e-14,  -1.171909810317514e-15,   3.258311755549461e-17,   4.932928114912876e-01,  -6.664473598233574e-03,   8.995226911646483e-05,
  -1.206877498859841e-06,   1.567876021054964e-08,  -1.750560254214079e-10,   6.466891105594512e-13,   5.544418524070781e-14,  -2.630002545827437e-15,   7.562380304059542e-17,
   4.933056392955605e-01,  -6.664989715503223e-03,   8.996566337083042e-05,  -1.207125159261911e-06,   1.568001364627125e-08,  -1.748841102044229e-10,   6.360211075348918e-13,
   5.583337408089534e-14,  -2.639109630835939e-15,   7.569116716852667e-17,   4.933266995917751e-01,  -6.665837081632633e-03,   8.998765294077946e-05,  -1.207531554482821e-06,
   1.568205480454627e-08,  -1.746010417813806e-10,   6.184817722010573e-13,   5.647252657398502e-14,  -2.654034806919376e-15,   7.579997894389375e-17,   4.933490480686716e-01,
  -6.666736305989618e-03,   9.001098656558601e-05,  -1.207962526912061e-06,   1.568419810365376e-08,  -1.742995399943477e-10,   5.998357752575661e-13,   5.715103391562590e-14,
  -2.669836647185482e-15,   7.591301725685958e-17,   4.933666377949608e-01,  -6.667444075126574e-03,   9.002935096441765e-05,  -1.208301527217440e-06,   1.568586856341934e-08,
  -1.740614277779058e-10,   5.851356746024961e-13,   5.768524952662252e-14,  -2.682247364088045e-15,   7.600022429983994e-17,   4.933767897141391e-01,  -6.667852572528301e-03,
   9.003994970263180e-05,  -1.208497099744338e-06,   1.568682606769502e-08,  -1.739236762982323e-10,   5.766417067356214e-13,   5.799364576057148e-14,  -2.689399602119046e-15,
   7.604984883410639e-17,   4.933806019635974e-01,  -6.668005973032711e-03,   9.004392968783161e-05,  -1.208570525704823e-06,   1.568718438124015e-08,  -1.738718864383911e-10,
   5.734502008131214e-13,   5.810946850404589e-14,  -2.692083400159799e-15,   7.606835009281183e-17,   4.933812339039390e-01,  -6.668031401661047e-03,   9.004458943017088e-05,
  -1.208582696397914e-06,   1.568724371146865e-08,  -1.738632982141366e-10,   5.729210608946737e-13,   5.812866866997365e-14,  -2.692528175715819e-15,   7.607140990902416e-17,
   8.179846150551682e-01,  -1.105090246450368e-02,   1.491201430687768e-04,  -1.996519721230650e-06,   2.558326333627409e-08,  -2.617324793798109e-10,  -5.214591393074796e-13,
   1.658103329983848e-13,  -7.235191424634615e-15,   2.192340509125555e-16,   8.180058798576287e-01,  -1.105175612239374e-02,   1.491419787132913e-04,  -1.996887831747839e-06,
   2.558179905803853e-08,  -2.612187616284776e-10,  -5.509423693803104e-13,   1.669475412797061e-13,  -7.266713506115876e-15,   2.197608580135190e-16,   8.180407917179381e-01,
  -1.105315765257839e-02,   1.491778244428219e-04,  -1.997491608756059e-06,   2.557934937144478e-08,  -2.603729453038568e-10,  -5.994345653430595e-13,   1.688163779661754e-13,
  -7.318447745397300e-15,   2.206223257368757e-16,   8.180778389519788e-01,  -1.105464493737400e-02,   1.492158581375034e-04,  -1.998131532984597e-06,   2.557668769139000e-08,
  -2.594721157174049e-10,  -6.510117814347564e-13,   1.708019677800700e-13,  -7.373321823232930e-15,   2.215318110857676e-16,   8.181069975295461e-01,  -1.105581554899072e-02,
   1.492457898329056e-04,  -1.998634627189801e-06,   2.557454771479878e-08,  -2.587607285844858e-10,  -6.916925376635980e-13,   1.723665214021587e-13,  -7.416493226806347e-15,
   2.222442384631670e-16,   8.181238264005829e-01,  -1.105649117618238e-02,   1.492630635858225e-04,  -1.998924760071154e-06,   2.557329454599445e-08,  -2.583491987044294e-10,
  -7.152059534472802e-13,   1.732702092936234e-13,  -7.441402249529322e-15,   2.226540501870418e-16,   8.181301459764150e-01,  -1.105674488928853e-02,   1.492695499731157e-04,
  -1.999033667622200e-06,   2.557282053640703e-08,  -2.581944808905355e-10,  -7.240422323567926e-13,   1.736096952692271e-13,  -7.450754680539665e-15,   2.228076840185945e-16,
   8.181311935453979e-01,  -1.105678694630934e-02,   1.492706251804908e-04,  -1.999051718484248e-06,   2.557274178140927e-08,  -2.581688244764886e-10,  -7.255073285343637e-13,
   1.736659774247208e-13,  -7.452304918605181e-15,   2.228331375844497e-16,   5.064793983001074e-03,  -6.492199393519140e-05,   8.319055762101308e-07,  -1.064284430058663e-08,
   1.349745323395128e-10,  -1.644084794454761e-12,   1.688823046092629e-14,  -5.025551546527165e-17,  -4.710364436579511e-18,   1.961294131872438e-19,   5.064912601446360e-03,
  -6.492654586991921e-05,   8.320210262366938e-07,  -1.064518506900877e-08,   1.350103503877843e-10,  -1.644218630943869e-12,   1.686880166488882e-14,  -4.923444321330827e-17,
  -4.742159227277011e-18,   1.967386072516597e-19,   5.065107344735040e-03,  -6.493401933024528e-05,   8.322105781763737e-07,  -1.064902795015282e-08,   1.350691211850639e-10,
  -1.644436129124794e-12,   1.683681456385973e-14,  -4.755595209338244e-17,  -4.794358699719235e-18,   1.977360481587270e-19,   5.065313998609149e-03,  -6.494195023163703e-05,
   8.324117373744823e-07,  -1.065310572078235e-08,   1.351314402504251e-10,  -1.644663897024491e-12,   1.680274929741077e-14,  -4.577191013188408e-17,  -4.849750324954188e-18,
   1.987907948429549e-19,   5.065476648019742e-03,  -6.494819260400116e-05,   8.325700723898944e-07,  -1.065631507466639e-08,   1.351804557241878e-10,  -1.644840966917885e-12,
   1.677584962376645e-14,  -4.436566793434408e-17,  -4.893346395744268e-18,   1.996182575364279e-19,   5.065570520875725e-03,  -6.495179548428689e-05,   8.326614593069658e-07,
  -1.065816730612101e-08,   1.352087314837654e-10,  -1.644942281022112e-12,   1.676028916666625e-14,  -4.355322089831348e-17,  -4.918507475693377e-18,   2.000947451960726e-19,
   5.065605771955116e-03,  -6.495314845555392e-05,   8.326957776440289e-07,  -1.065886284697038e-08,   1.352193470366972e-10,  -1.644980159747049e-12,   1.675443923135422e-14,
  -4.324797333285222e-17,  -4.927955876766180e-18,   2.002734707907535e-19,   5.065611615372975e-03,  -6.495337273275068e-05,   8.327014664861824e-07,  -1.065897814332324e-08,
   1.352211065964188e-10,  -1.644986429942990e-12,   1.675346916058221e-14,  -4.319736544632390e-17,  -4.929522092931760e-18,   2.003030865412263e-19,   4.607449428843628e-02,
  -5.905960043930290e-04,   7.567821047317245e-06,  -9.681404196102299e-08,   1.227514454473407e-09,  -1.493248535672918e-11,   1.523250396715494e-13,  -3.976398840880091e-16,
  -4.511851427932908e-17,   1.856410548983355e-18,   4.607557335638807e-02,  -5.906374115476066e-04,   7.568870981838466e-06,  -9.683530056878643e-08,   1.227837390154681e-09,
  -1.493351889396556e-11,   1.521390029399276e-13,  -3.879731723442838e-16,  -4.542000067260067e-17,   1.862251438632128e-18,   4.607734492940969e-02,  -5.907053946570763e-04,
   7.570594817917937e-06,  -9.687020101340129e-08,   1.228367250992213e-09,  -1.493519463120921e-11,   1.518327249697993e-13,  -3.720822562185377e-16,  -4.591498796990242e-17,
   1.871815861558955e-18,   4.607922485257153e-02,  -5.907775389118209e-04,   7.572424211107950e-06,  -9.690723442911455e-08,   1.228929078950510e-09,  -1.493694417706406e-11,
   1.515065598463708e-13,  -3.551916713682863e-16,  -4.644027034426842e-17,   1.881931237370325e-18,   4.608070446861299e-02,  -5.908343232788945e-04,   7.573864148484364e-06,
  -9.693638088752886e-08,   1.229370953688698e-09,  -1.493830039456880e-11,   1.512490113960711e-13,  -3.418776664175466e-16,  -4.685371294652471e-17,   1.889867938019438e-18,
   4.608155842671112e-02,  -5.908670972368529e-04,   7.574695242770986e-06,  -9.695320226262182e-08,   1.229625853079587e-09,  -1.493907479638834e-11,   1.511000324933054e-13,
  -3.341854785987753e-16,  -4.709233494634678e-17,   1.894438647153992e-18,   4.608187910454876e-02,  -5.908794046733849e-04,   7.575007341730655e-06,  -9.695951892845263e-08,
   1.229721548546215e-09,  -1.493936402281901e-11,   1.510440246664958e-13,  -3.312953965717320e-16,  -4.718194283378819e-17,   1.896153153388913e-18,   4.608193226191674e-02,
  -5.908814448329751e-04,   7.575059077380737e-06,  -9.696056601003005e-08,   1.229737410289533e-09,  -1.493941188344099e-11,   1.510347371507052e-13,  -3.308162403182775e-16,
  -4.719679677698335e-17,   1.896437260144757e-18,   1.309238672995987e-01,  -1.678218283469017e-03,   2.150427144541493e-05,  -2.750782978780690e-07,   3.485850709527802e-09,
  -4.228085960940384e-11,   4.245156058423945e-13,  -7.490099056026407e-16,  -1.428025878408631e-16,   5.743263998357239e-18,   1.309269335111324e-01,  -1.678335933081216e-03,
   2.150725290931446e-05,  -2.751384810608622e-07,   3.486749866638700e-09,  -4.228261884908950e-11,   4.239271438499247e-13,  -7.190893008580134e-16,  -1.437396065574249e-16,
   5.761860089096335e-18,   1.309319675012406e-01,  -1.678529092540147e-03,   2.151214801764164e-05,  -2.752372831078189e-07,   3.488225060318891e-09,  -4.228544197438011e-11,
   4.229583880221866e-13,  -6.699014573720279e-16,  -1.452781518261456e-16,   5.792318290682061e-18,   1.309373093719716e-01,  -1.678734074907900e-03,   2.151734285693807e-05,
  -2.753421218706557e-07,   3.489789104577924e-09,  -4.228834917318399e-11,   4.219267929569047e-13,  -6.176166341447980e-16,  -1.469110339216498e-16,   5.824540856298170e-18,
   1.309415137550965e-01,  -1.678895415392689e-03,   2.152143176628549e-05,  -2.754246320591677e-07,   3.491019108613184e-09,  -4.229057311879352e-11,   4.211122645336724e-13,
  -5.764011858636113e-16,  -1.481963780362971e-16,   5.849830400207838e-18,   1.309439403081939e-01,  -1.678988535470698e-03,   2.152379177361646e-05,  -2.754722509066655e-07,
   3.491728603824668e-09,  -4.229183091198901e-11,   4.206411188188157e-13,  -5.525881183436291e-16,  -1.489382757241964e-16,   5.864397411735610e-18,   1.309448515259548e-01,
  -1.679023504371296e-03,   2.152467802099194e-05,  -2.754901323704953e-07,   3.491994957429368e-09,  -4.229229836781350e-11,   4.204639975277128e-13,  -5.436410087192791e-16,
  -1.492168843525743e-16,   5.869862149652632e-18,   1.309450025745521e-01,  -1.679029301040190e-03,   2.152482493135085e-05,  -2.754930964850140e-07,   3.492039105715244e-09,
  -4.229237559896428e-11,   4.204346265139187e-13,  -5.421576300889341e-16,  -1.492630686977475e-16,   5.870767727235082e-18,   2.665137777487406e-01,  -3.416242884257605e-03,
   4.377414494567267e-05,  -5.598658234708947e-07,   7.087686899556963e-09,  -8.550373144096468e-11,   8.327446501765989e-13,  -7.466263283702561e-17,  -3.468713531121796e-16,
   1.351913721136847e-17,   2.665200193213205e-01,  -3.416482333161212e-03,   4.378020669151199e-05,  -5.599874928770977e-07,   7.089447450384017e-09,  -8.550282555924538e-11,
   8.313162436522352e-13,  -4.168423132754550e-18,  -3.490994955388840e-16,   1.356526446274087e-17,   2.665302664982604e-01,  -3.416875464842488e-03,   4.379015910971175e-05,
  -5.601872315009075e-07,   7.092335451084793e-09,  -8.550118533805620e-11,   8.289648591578601e-13,   1.117289474779492e-16,  -3.527585535153115e-16,   1.364084580274107e-17,
   2.665411403950680e-01,  -3.417292658980416e-03,   4.380072086357443e-05,  -5.603991676326719e-07,   7.095396808989423e-09,  -8.549923670070383e-11,   8.264611258451553e-13,
   2.349353779841638e-16,  -3.566427067844557e-16,   1.372084676611074e-17,   2.665496988245446e-01,  -3.417621029913618e-03,   4.380903408233542e-05,  -5.605659609763583e-07,
   7.097803912729592e-09,  -8.549755218660179e-11,   8.244843504726822e-13,   3.320660413620342e-16,  -3.597007033020213e-16,   1.378366478875004e-17,   2.665546383083105e-01,
  -3.417810554013401e-03,   4.381383222933769e-05,  -5.606622200505061e-07,   7.099192215679938e-09,  -8.549651946999034e-11,   8.233409792722933e-13,   3.881887328137634e-16,
  -3.614659868700489e-16,   1.381986066572158e-17,   2.665564931802246e-01,  -3.417881724997312e-03,   4.381563406172457e-05,  -5.606983661690326e-07,   7.099713370048755e-09,
  -8.549612022376984e-11,   8.229111527300043e-13,   4.092759567144899e-16,  -3.621289534970536e-16,   1.383344165479078e-17,   2.665568006542552e-01,  -3.417893522754324e-03,
   4.381593274547858e-05,  -5.607043578991168e-07,   7.099799750020733e-09,  -8.549605343875932e-11,   8.228398775423110e-13,   4.127721301406157e-16,  -3.622388541766689e-16,
   1.383569232118363e-17,   4.679881099332787e-01,  -5.998779522767291e-03,   7.686318786875820e-05,  -9.827977829023251e-07,   1.241874874614397e-08,  -1.482732384091606e-10,
   1.356940898404972e-12,   4.810477285275217e-15,  -8.044437719367601e-16,   3.026439889507092e-17,   4.679990694860595e-01,  -5.999199845714747e-03,   7.687380771140833e-05,
  -9.830086415284226e-07,   1.242160579750544e-08,  -1.482563299764295e-10,   1.353629479342924e-12,   4.968571294610067e-15,  -8.095483850796298e-16,   3.037812406527520e-17,
   4.680170624611236e-01,  -5.999889938909620e-03,   7.689124365294780e-05,  -9.833547816487637e-07,   1.242629094422261e-08,  -1.482282285813149e-10,   1.348178518637434e-12,
   5.228527569117805e-15,  -8.179334752592936e-16,   3.056459198490887e-17,   4.680361558873257e-01,  -6.000622269535237e-03,   7.690974691271742e-05,  -9.837220378136649e-07,
   1.243125521416012e-08,  -1.481979435315650e-10,   1.342374600284182e-12,   5.504930754265673e-15,  -8.268375099394316e-16,   3.076213367148653e-17,   4.680511835922667e-01,
  -6.001198681595252e-03,   7.692431079590087e-05,  -9.840110519066585e-07,   1.243515701888605e-08,  -1.481737703114656e-10,   1.337792379245436e-12,   5.722873460981767e-15,
  -8.338499235047614e-16,   3.091737014686784e-17,   4.680598568068655e-01,  -6.001531365923875e-03,   7.693271658688503e-05,  -9.841778401495961e-07,   1.243740677839782e-08,
  -1.481596835665651e-10,   1.335142072825286e-12,   5.848817463264679e-15,  -8.378988733089850e-16,   3.100686746068736e-17,   4.680631137668903e-01,  -6.001656297046877e-03,
   7.693587317519955e-05,  -9.842404693807811e-07,   1.243825119793140e-08,  -1.481543681506737e-10,   1.334145756686861e-12,   5.896141861198374e-15,  -8.394196611457015e-16,
   3.104045700696597e-17,   4.680636536589438e-01,  -6.001677006424577e-03,   7.693639643176340e-05,  -9.842508509976448e-07,   1.243839115210234e-08,  -1.481534856880796e-10,
   1.333980545004735e-12,   5.903988201682427e-15,  -8.396717728199267e-16,   3.104602402577267e-17,   7.760244935000017e-01,  -9.947211658051737e-03,   1.274463127030724e-04,
  -1.628555642755178e-06,   2.049078147342358e-08,  -2.386174415746660e-10,   1.829469091752284e-12,   2.839781724004180e-14,  -2.176194597174964e-15,   7.990056465383341e-17,
   7.760426652739144e-01,  -9.947908121104425e-03,   1.274638301014077e-04,  -1.628894433457736e-06,   2.049457969366037e-08,  -2.385258552693198e-10,   1.820499159672231e-12,
   2.881711823858938e-14,  -2.190558831441220e-15,   8.027167874730041e-17,   7.760724989878579e-01,  -9.949051582312150e-03,   1.274925900564648e-04,  -1.629450516227147e-06,
   2.050080108819953e-08,  -2.383745893334405e-10,   1.805732027667263e-12,   2.950684321321093e-14,  -2.214169172203848e-15,   8.088096611623941e-17,   7.761041573190868e-01,
  -9.950265024893124e-03,   1.275231097272796e-04,  -1.630040430676874e-06,   2.050738340787725e-08,  -2.382128431004915e-10,   1.790006461201418e-12,   3.024056288999268e-14,
  -2.239261078454811e-15,   8.152752148207535e-17,   7.761290743697046e-01,  -9.951220113281853e-03,   1.275471311351676e-04,  -1.630504600217854e-06,   2.051254989973572e-08,
  -2.380846478851095e-10,   1.777589415519097e-12,   3.081935679089378e-14,  -2.259037088325803e-15,   8.203639956565776e-17,   7.761434551994353e-01,  -9.951771354630620e-03,
   1.275609952667004e-04,  -1.630772442827961e-06,   2.051552603098660e-08,  -2.380103027003306e-10,   1.770406872120308e-12,   3.115393229779731e-14,  -2.270461634391829e-15,
   8.233009609532143e-17,   7.761488554786903e-01,  -9.951978359018381e-03,   1.275662015572986e-04,  -1.630873013059113e-06,   2.051664254734610e-08,  -2.379823170196553e-10,
   1.767706650023709e-12,   3.127967121627571e-14,  -2.274753822006508e-15,   8.244038437913942e-17,   7.761497506593807e-01,  -9.952012673369075e-03,   1.275670645835225e-04,
  -1.630889683627261e-06,   2.051682757046804e-08,  -2.379776743868518e-10,   1.767258885690698e-12,   3.130051964858782e-14,  -2.275465427274140e-15,   8.245866635942104e-17,
   4.817656351937425e-03,  -5.874325207790657e-05,   7.161333524767635e-07,  -8.724996513377985e-09,   1.059672461311168e-10,  -1.267364089861239e-12,   1.419780772027947e-14,
  -1.197589726130185e-16,  -4.317019661864006e-19,   6.076462941070824e-20,   4.817758445274273e-03,  -5.874698335409354e-05,   7.162240035458061e-07,  -8.726803039004823e-09,
   1.059975287724315e-10,  -1.267716827068426e-12,   1.419580905297032e-14,  -1.194375454118767e-16,  -4.450917854891470e-19,   6.114156769398359e-20,   4.817926057366466e-03,
  -5.875310940615603e-05,   7.163728406321856e-07,  -8.729769103938707e-09,   1.060472393981881e-10,  -1.268295201410605e-12,   1.419248916631134e-14,  -1.189084732377919e-16,
  -4.671060637725292e-19,   6.176059047644465e-20,   4.818103919469312e-03,  -5.875961037977032e-05,   7.165307936789013e-07,  -8.732916817976141e-09,   1.060999817902585e-10,
  -1.268907947086162e-12,   1.418891379259890e-14,  -1.183451871494685e-16,  -4.905093297017081e-19,   6.241771305274392e-20,   4.818243907088548e-03,  -5.876472722969012e-05,
   7.166551219424647e-07,  -8.735394439855923e-09,   1.061414871010681e-10,  -1.269389488978535e-12,   1.418606174528946e-14,  -1.179005023272003e-16,  -5.089599350838874e-19,
   6.293507980010304e-20,   4.818324700372981e-03,  -5.876768048412925e-05,   7.167268815842008e-07,  -8.736824465846036e-09,   1.061654393247111e-10,  -1.269667118333561e-12,
   1.418440044345369e-14,  -1.176433144593635e-16,  -5.196209972533905e-19,   6.323374449549467e-20,   4.818355039752547e-03,  -5.876878950217777e-05,   7.167538294361555e-07,
  -8.737361481644040e-09,   1.061744333756011e-10,  -1.269771318342319e-12,   1.418377370905970e-14,  -1.175466335938809e-16,  -5.236267604159881e-19,   6.334591147202411e-20,
   4.818360068975797e-03,  -5.876897333999028e-05,   7.167582965018240e-07,  -8.737450501113789e-09,   1.061759242552057e-10,  -1.269788588210464e-12,   1.418366966588721e-14,
  -1.175306018558740e-16,  -5.242909010576487e-19,   6.336450556390946e-20,   4.382628057259570e-02,  -5.343880612988701e-04,   6.514665995972361e-06,  -7.937042098070633e-08,
   9.638977000146163e-10,  -1.152307253272482e-11,   1.288051143929636e-13,  -1.072583871157394e-15,  -4.610840200581721e-18,   5.763991171580708e-19,   4.382720931565012e-02,
  -5.344220043134163e-04,   6.515490570559356e-06,  -7.938684576444279e-08,   9.641723954650689e-10,  -1.152622898715988e-11,   1.287841135004478e-13,  -1.069535151897441e-15,
  -4.737208869794987e-18,   5.799646354008347e-19,   4.382873408279333e-02,  -5.344777323413383e-04,   6.516844412680058e-06,  -7.941381293213810e-08,   9.646233187119870e-10,
  -1.153140417039120e-11,   1.287492713980744e-13,  -1.064516966037451e-15,  -4.944975997685542e-18,   5.858202711115373e-19,   4.383035209426786e-02,  -5.345368709858338e-04,
   6.518281174146670e-06,  -7.944243156339374e-08,   9.651017368922667e-10,  -1.153688638946358e-11,   1.287118036706325e-13,  -1.059174311690333e-15,  -5.165857172867962e-18,
   5.920365866807915e-19,   4.383162556157231e-02,  -5.345834184059282e-04,   6.519412079736224e-06,  -7.946495774638735e-08,   9.654782207939404e-10,  -1.154119435965681e-11,
   1.286819557346745e-13,  -1.054956599448292e-15,  -5.339998530700390e-18,   5.969310256212016e-19,   4.383236053803820e-02,  -5.346102838351143e-04,   6.520064814311183e-06,
  -7.947795931671990e-08,   9.656954834182364e-10,  -1.154367793784298e-11,   1.286645852183478e-13,  -1.052517256970977e-15,  -5.440621721418125e-18,   5.997565602198838e-19,
   4.383263653535746e-02,  -5.346203724494968e-04,   6.520309935268876e-06,  -7.948284177552504e-08,   9.657770651144721e-10,  -1.154461004749845e-11,   1.286580350538744e-13,
  -1.051600273173176e-15,  -5.478429925665035e-18,   6.008177375675418e-19,   4.383268228619858e-02,  -5.346220448017089e-04,   6.520350568242716e-06,  -7.948365112560921e-08,
   9.657905883120443e-10,  -1.154476453169803e-11,   1.286569478264723e-13,  -1.051448217940765e-15,  -5.484698399964295e-18,   6.009936513671198e-19,   1.245354148450739e-01,
  -1.518500454951207e-03,   1.851182409675611e-05,  -2.255303848287664e-07,   2.738430127916937e-09,  -3.270474971849109e-11,   3.637757120868464e-13,  -2.940597739048132e-15,
  -1.746761454875174e-17,   1.789541542228656e-18,   1.245380539245908e-01,  -1.518596903540640e-03,   1.851416668294733e-05,  -2.255769988644231e-07,   2.739205712785689e-09,
  -3.271338572084532e-11,   3.636980271156672e-13,  -2.931133609199713e-15,  -1.785620938776358e-17,   1.800565263045123e-18,   1.245423866425209e-01,  -1.518755253915222e-03,
   1.851801289577035e-05,  -2.256535321695353e-07,   2.740478836731912e-09,  -3.272754248101661e-11,   3.635693698366877e-13,  -2.915555825519049e-15,  -1.849513727997605e-17,
   1.818670856904275e-18,   1.245469843197749e-01,  -1.518923295482043e-03,   1.852209467508961e-05,  -2.257347518991646e-07,   2.741829549970484e-09,  -3.274253580391836e-11,
   3.634313242247636e-13,  -2.898971013071415e-15,  -1.917442850434951e-17,   1.837893554743106e-18,   1.245506029539213e-01,  -1.519055559256562e-03,   1.852530752763089e-05,
  -2.257986809162795e-07,   2.742892444792771e-09,  -3.275431524895915e-11,   3.633215724027527e-13,  -2.885878424102543e-15,  -1.971000281809152e-17,   1.853029983526053e-18,
   1.245526914338524e-01,  -1.519131896951000e-03,   1.852716191635456e-05,  -2.258355790717192e-07,   2.743505812388504e-09,  -3.276110521559687e-11,   3.632577874553410e-13,
  -2.878306294788142e-15,  -2.001948108191001e-17,   1.861768715417286e-18,   1.245534756968677e-01,  -1.519160563588707e-03,   1.852785829342453e-05,  -2.258494353514215e-07,
   2.743736128579520e-09,  -3.276365336771382e-11,   3.632337514110857e-13,  -2.875459833765486e-15,  -2.013576650955227e-17,   1.865050797957657e-18,   1.245536057006396e-01,
  -1.519165315550913e-03,   1.852797372977309e-05,  -2.258517322626855e-07,   2.743774306286129e-09,  -3.276407567870705e-11,   3.632297626516017e-13,  -2.874987831132393e-15,
  -2.015504634743953e-17,   1.865594881779496e-18,   2.535092018446202e-01,  -3.091118421808934e-03,   3.768321265493825e-05,  -4.590758885180176e-07,   5.572419304348422e-09,
  -6.643089868223370e-11,   7.321800618543353e-13,  -5.582827914501823e-15,  -5.211297816822108e-17,   4.224028350548687e-18,   2.535145740287053e-01,  -3.091314745923814e-03,
   3.768797947058985e-05,  -4.591705620749300e-07,   5.573979505681621e-09,  -6.644722432436152e-11,   7.319535677942010e-13,  -5.560489822567060e-15,  -5.301877963390340e-17,
   4.250005448760983e-18,   2.535233938303144e-01,  -3.091637072987361e-03,   3.769580593218112e-05,  -4.593260006874461e-07,   5.576540469233518e-09,  -6.647397680295957e-11,
   7.315791185579939e-13,  -5.523721845423136e-15,  -5.450821132444963e-17,   4.292676696610475e-18,   2.535327529902440e-01,  -3.091979126679096e-03,   3.770411172049009e-05,
  -4.594909556662299e-07,   5.579257358759504e-09,  -6.650229694138866e-11,   7.311782308496856e-13,  -5.484577134368954e-15,  -5.609188866803893e-17,   4.337988780789227e-18,
   2.535401191825410e-01,  -3.092248353525682e-03,   3.771064936623424e-05,  -4.596207924408105e-07,   5.581395208034451e-09,  -6.652453693951374e-11,   7.308601436985453e-13,
  -5.453675120338675e-15,  -5.734062011026259e-17,   4.373674477596454e-18,   2.535443705502851e-01,  -3.092403741146175e-03,   3.771442274888624e-05,  -4.596957303248083e-07,
   5.582628858950515e-09,  -6.653735276694475e-11,   7.306755316342220e-13,  -5.435802901714651e-15,  -5.806223631977688e-17,   4.394279286464123e-18,   2.535459670178423e-01,
  -3.092462092924623e-03,   3.771583976331111e-05,  -4.597238714811721e-07,   5.583092079906200e-09,  -6.654216158418905e-11,   7.306060117056128e-13,  -5.429084510218582e-15,
  -5.833338963916778e-17,   4.402018459668048e-18,   2.535462316571271e-01,  -3.092471765682237e-03,   3.771607465751815e-05,  -4.597285363458160e-07,   5.583168863971829e-09,
  -6.654295852166048e-11,   7.305944774257594e-13,  -5.427970461020207e-15,  -5.837834663748312e-17,   4.403301436473465e-18,   4.451525964276615e-01,  -5.427884239347736e-03,
   6.616970914781973e-05,  -8.060476207806409e-07,   9.778399378602839e-09,  -1.161813866722016e-10,   1.258273265709388e-12,  -8.460360882765146e-15,  -1.475108000819814e-16,
   9.420852615376727e-18,   4.451620296842222e-01,  -5.428228943722479e-03,   6.617807354763856e-05,  -8.062131614096693e-07,   9.781077765849541e-09,  -1.162058704449231e-10,
   1.257643938033099e-12,  -8.410522263464820e-15,  -1.495077967635669e-16,   9.479434216421309e-18,   4.451775167648083e-01,  -5.428794882887583e-03,   6.619180671459122e-05,
  -8.064849480001785e-07,   9.785473778942748e-09,  -1.162459558416329e-10,   1.256605010078758e-12,  -8.328486559617270e-15,  -1.527919911315637e-16,   9.575687849237884e-18,
   4.451939509276771e-01,  -5.429395457601587e-03,   6.620638090963636e-05,  -8.067733683002191e-07,   9.790136934048428e-09,  -1.162883415831371e-10,   1.255494756099412e-12,
  -8.241144509495656e-15,  -1.562846554821225e-16,   9.677931979259132e-18,   4.452068855498795e-01,  -5.429868163395415e-03,   6.621785250182280e-05,  -8.070003809589491e-07,
   9.793805877020874e-09,  -1.163215920519920e-10,   1.254615274261130e-12,  -8.172191539233705e-15,  -1.590391031223502e-16,   9.758479064008187e-18,   4.452143507138969e-01,
  -5.430140991331668e-03,   6.622447363292748e-05,  -8.071314041548955e-07,   9.795922899801855e-09,  -1.163407384566002e-10,   1.254105418425568e-12,  -8.132311479836273e-15,
  -1.606310335068533e-16,   9.804996473294757e-18,   4.452171540216013e-01,  -5.430243444748914e-03,   6.622696005652004e-05,  -8.071806065090808e-07,   9.796717787916388e-09,
  -1.163479199692607e-10,   1.253913529435604e-12,  -8.117319870082908e-15,  -1.612292509218381e-16,   9.822470277744422e-18,   4.452176187133758e-01,  -5.430260428070537e-03,
   6.622737222331036e-05,  -8.071887626006448e-07,   9.796849548039391e-09,  -1.163491099774947e-10,   1.253881698236451e-12,  -8.114833938749198e-15,  -1.613284367935533e-16,
   9.825367130000536e-18,   7.381584285087553e-01,  -9.000584664754943e-03,   1.097214616753329e-04,  -1.336338733714589e-06,   1.619059971562400e-08,  -1.908981048274748e-10,
   1.981481019490034e-12,  -8.744906252093330e-15,  -4.721286082942517e-16,   2.408766662587168e-17,   7.381740705272958e-01,  -9.001156137720316e-03,   1.097353097409178e-04,
  -1.336610597199885e-06,   1.619480563578254e-08,  -1.909221893856705e-10,   1.979493019800784e-12,  -8.617218089908334e-15,  -4.772558590016612e-16,   2.424691912032587e-17,
   7.381997508612378e-01,  -9.002094387045483e-03,   1.097580461704767e-04,  -1.337056929037118e-06,   1.620170721030743e-08,  -1.909614494787974e-10,   1.976214526683161e-12,
  -8.407004754077018e-15,  -4.856910415971871e-16,   2.450873591604651e-17,   7.382270016227142e-01,  -9.003090056218478e-03,   1.097821747968054e-04,  -1.337530553974990e-06,
   1.620902605569917e-08,  -1.910027281147765e-10,   1.972715554121751e-12,  -8.183146059243501e-15,  -4.946658526543856e-16,   2.478705694497606e-17,   7.382484495216763e-01,
  -9.003873735722459e-03,   1.098011666983265e-04,  -1.337903322596663e-06,   1.621478293217636e-08,  -1.910349393979476e-10,   1.969947169079143e-12,  -8.006383849533076e-15,
  -5.017467694947745e-16,   2.500646810955426e-17,   7.382608280873988e-01,  -9.004326045613095e-03,   1.098121283162803e-04,  -1.338118463958866e-06,   1.621810409492785e-08,
  -1.910534186545758e-10,   1.968343589997744e-12,  -7.904136531064908e-15,  -5.058403991114423e-16,   2.513324315407390e-17,   7.382654764684936e-01,  -9.004495898735766e-03,
   1.098162447056206e-04,  -1.338199253432868e-06,   1.621935098919026e-08,  -1.910603368908591e-10,   1.967740315968957e-12,  -7.865697320354589e-15,  -5.073789387844284e-16,
   2.518087650567180e-17,   7.382662470098184e-01,  -9.004524054652387e-03,   1.098169270662450e-04,  -1.338212645536954e-06,   1.621955766733532e-08,  -1.910614825840093e-10,
   1.967640255866381e-12,  -7.859323132005080e-15,  -5.076340445084503e-16,   2.518877389541232e-17,   4.593516673724892e-03,  -5.340597380873270e-05,   6.208266251007321e-07,
  -7.214932008180142e-09,   8.375457120162992e-11,  -9.668703569815269e-13,   1.088803906035451e-14,  -1.108927718605398e-16,   6.950996540314608e-19,   1.100215808277234e-20,
   4.593605165993369e-03,  -5.340905889365664e-05,   6.208982703242480e-07,  -7.216310724601651e-09,   8.377784463811367e-11,  -9.672007806619077e-13,   1.089071994664178e-14,
  -1.108323220915245e-16,   6.908373206670779e-19,   1.115390826613399e-20,   4.593750447768680e-03,  -5.341412398609656e-05,   6.210159019305352e-07,  -7.218574450265360e-09,
   8.381605584057411e-11,  -9.677430913833775e-13,   1.089510867470147e-14,  -1.107325189647676e-16,   6.838216962481511e-19,   1.140344564965889e-20,   4.593904613012656e-03,
  -5.341949902003001e-05,   6.211407376974965e-07,  -7.220976899531321e-09,   8.385660642775597e-11,  -9.683183432362392e-13,   1.089974859895400e-14,  -1.106258513413290e-16,
   6.763526750832077e-19,   1.166878750930293e-20,   4.594025949148391e-03,  -5.342372961952180e-05,   6.212389982516678e-07,  -7.222867973721150e-09,   8.388852396167131e-11,
  -9.687709373559899e-13,   1.090338801711311e-14,  -1.105413460719178e-16,   6.704564785692862e-19,   1.187802049744004e-20,   4.594095977522849e-03,  -5.342617134940432e-05,
   6.212957120111430e-07,  -7.223959483476572e-09,   8.390694579878461e-11,  -9.690320851416551e-13,   1.090548348795396e-14,  -1.104923528215203e-16,   6.670464351859676e-19,
   1.199893618893521e-20,   4.594122274425349e-03,  -5.342708827504687e-05,   6.213170096639388e-07,  -7.224369381542528e-09,   8.391386368468349e-11,  -9.691301386689086e-13,
   1.090626942943052e-14,  -1.104739130788333e-16,   6.657645625373143e-19,   1.204437207323666e-20,   4.594126633542443e-03,  -5.342724027027397e-05,   6.213205401113017e-07,
  -7.224437329348725e-09,   8.391501043926251e-11,  -9.691463919131872e-13,   1.090639966146718e-14,  -1.104708541959227e-16,   6.655520016504786e-19,   1.205190534799277e-20,
   4.178727918800210e-02,  -4.858348083977894e-04,   5.647665789626967e-06,  -6.563409835771415e-08,   7.618954174091969e-10,  -8.794117134140047e-12,   9.895898285745371e-14,
  -1.004336092834648e-15,   6.134113221406343e-18,   1.070112110322930e-19,   4.178808420298307e-02,  -4.858628733483811e-04,   5.648317528079125e-06,  -6.564663828488045e-08,
   7.621069354361108e-10,  -8.797109093034150e-12,   9.898258668939396e-14,  -1.003749401248387e-15,   6.093886079650604e-18,   1.084401209148827e-19,   4.178940583262838e-02,
  -4.859089503836549e-04,   5.649387592884958e-06,  -6.566722767890637e-08,   7.624542124890647e-10,  -8.802019585523749e-12,   9.902121935276160e-14,  -1.002780931148104e-15,
   6.027673817587773e-18,   1.107898552859055e-19,   4.179080827526689e-02,  -4.859578469489502e-04,   5.650523191940608e-06,  -6.568907879461483e-08,   7.628227490836907e-10,
  -8.807228234967874e-12,   9.906205251540213e-14,  -1.001746069914037e-15,   5.957182401072003e-18,   1.132884658781905e-19,   4.179191207120452e-02,  -4.859963326186313e-04,
   5.651417042958220e-06,  -6.570627876144889e-08,   7.631128245755857e-10,  -8.811326188292050e-12,   9.909407303586782e-14,  -1.000926380706813e-15,   5.901534992781158e-18,
   1.152587635784049e-19,   4.179254911996724e-02,  -4.860185449808957e-04,   5.651932953409204e-06,  -6.571620641060427e-08,   7.632802469205247e-10,  -8.813690682095043e-12,
   9.911250637814909e-14,  -1.000451216314233e-15,   5.869351496520527e-18,   1.163974143094686e-19,   4.179278834312956e-02,  -4.860268862329548e-04,   5.652126692657593e-06,
  -6.571993457063234e-08,   7.633431183390482e-10,  -8.814578475457837e-12,   9.911941951688534e-14,  -1.000272389109546e-15,   5.857253363161249e-18,   1.168252824580353e-19,
   4.179282799805759e-02,  -4.860282689301329e-04,   5.652158808225196e-06,  -6.572055257860394e-08,   7.633535403170149e-10,  -8.814725634763235e-12,   9.912056500600650e-14,
  -1.000242724925175e-15,   5.855247243223557e-18,   1.168962232070219e-19,   1.187414516282766e-01,  -1.380533238349922e-03,   1.604822237823784e-05,  -1.865024072751864e-07,
   2.164847100807006e-09,  -2.497956956329836e-11,   2.806336097550020e-13,  -2.825704299525399e-15,   1.622958949617921e-17,   3.482118179547034e-19,   1.187437391322775e-01,
  -1.380612986190055e-03,   1.605007421870896e-05,  -1.865380260478701e-07,   2.165446878033587e-09,  -2.498798342366026e-11,   2.806957024776860e-13,  -2.823802663399561e-15,
   1.610597086369724e-17,   3.525846752758882e-19,   1.187474946314446e-01,  -1.380743916187762e-03,   1.605311468502120e-05,  -1.865965086710067e-07,   2.166431603871580e-09,
  -2.500179195305256e-11,   2.807972786528406e-13,  -2.820664534348963e-15,   1.590249858562228e-17,   3.597757904462995e-19,   1.187514797661271e-01,  -1.380882858002519e-03,
   1.605634135832387e-05,  -1.866585749988886e-07,   2.167476602159635e-09,  -2.501643816406459e-11,   2.809045699628625e-13,  -2.817312578213838e-15,   1.568587499217325e-17,
   3.674229092403757e-19,   1.187546162761947e-01,  -1.380992216779312e-03,   1.605888113178426e-05,  -1.867074300267732e-07,   2.168299113787405e-09,  -2.502796066261164e-11,
   2.809886541742020e-13,  -2.814658507884899e-15,   1.551486676938015e-17,   3.734533791479545e-19,   1.187564264929058e-01,  -1.381055334212846e-03,   1.606034703087688e-05,
  -1.867356286259871e-07,   2.168773838324382e-09,  -2.503460885469801e-11,   2.810370384516745e-13,  -2.813120346563582e-15,   1.541596431649583e-17,   3.769385474660890e-19,
   1.187571062615371e-01,  -1.381079036258070e-03,   1.606089751819065e-05,  -1.867462181243366e-07,   2.168952109091222e-09,  -2.503710500122966e-11,   2.810551802944813e-13,
  -2.812541532664389e-15,   1.537878570908596e-17,   3.782481822318294e-19,   1.187572189436698e-01,  -1.381082965254660e-03,   1.606098877079997e-05,  -1.867479735192327e-07,
   2.168981660390686e-09,  -2.503751875657706e-11,   2.810581861430539e-13,  -2.812445521647566e-15,   1.537262072533490e-17,   3.784653214340714e-19,   2.417147839556820e-01,
  -2.810267709495529e-03,   3.266835246599428e-05,  -3.796464246017378e-07,   4.406366196600057e-09,  -5.081434371707880e-11,   5.691777457275573e-13,  -5.647213681030259e-15,
   2.853743885638688e-17,   8.755468690375452e-19,   2.417194404821940e-01,  -2.810430044924180e-03,   3.267212170732321e-05,  -3.797188789166714e-07,   4.407582440219107e-09,
  -5.083114357464858e-11,   5.692854717712373e-13,  -5.642455979797325e-15,   2.825024077207573e-17,   8.856572050215456e-19,   2.417270853131184e-01,  -2.810696567201692e-03,
   3.267831027817249e-05,  -3.798378416520814e-07,   4.409579264022107e-09,  -5.085871280591095e-11,   5.694614872246841e-13,  -5.634607780626149e-15,   2.777751367763070e-17,
   9.022847594452151e-19,   2.417351975983974e-01,  -2.810979398383256e-03,   3.268487785116164e-05,  -3.799640937494096e-07,   4.411698269322868e-09,  -5.088795163858494e-11,
   5.696471173888353e-13,  -5.626228987329394e-15,   2.727422070831724e-17,   9.199683628217641e-19,   2.417415823924592e-01,  -2.811202010055850e-03,   3.269004730490970e-05,
  -3.800634717805647e-07,   4.413366097020550e-09,  -5.091095239908717e-11,   5.697923853744744e-13,  -5.619597680807822e-15,   2.687689996153785e-17,   9.339147465913848e-19,
   2.417452673354684e-01,  -2.811330492443276e-03,   3.269303099411449e-05,  -3.801208315853594e-07,   4.414328696705899e-09,  -5.092422242553462e-11,   5.698758915868757e-13,
  -5.615755716044544e-15,   2.664710648169694e-17,   9.419752150025444e-19,   2.417466510972267e-01,  -2.811378740527965e-03,   3.269415145509756e-05,  -3.801423720474785e-07,
   4.414690174479196e-09,  -5.092920466433618e-11,   5.699071864177330e-13,  -5.614310200420301e-15,   2.656072373944643e-17,   9.450042189474440e-19,   2.417468804770757e-01,
  -2.811386738426748e-03,   3.269433719049874e-05,  -3.801459427551871e-07,   4.414750095227776e-09,  -5.093003050012335e-11,   5.699123706809140e-13,  -5.614070436720071e-15,
   2.654639965627009e-17,   9.455064366967271e-19,   4.244420501834152e-01,  -4.934723490062244e-03,   5.736426340574415e-05,  -6.666283026606921e-07,   7.735881398073917e-09,
  -8.911575645502173e-11,   9.926916757528307e-13,  -9.573391552604504e-15,   3.521780080889794e-17,   2.097253915267661e-18,   4.244502268468398e-01,  -4.935008537309341e-03,
   5.737088065738141e-05,  -6.667553607725941e-07,   7.738001900927285e-09,  -8.914418373310552e-11,   9.928189579185491e-13,  -9.562054984734374e-15,   3.459171975097299e-17,
   2.119243708187759e-18,   4.244636508461493e-01,  -4.935476527775033e-03,   5.738174525634553e-05,  -6.669639763958504e-07,   7.741483239045835e-09,  -8.919082683774573e-11,
   9.930260931592040e-13,  -9.543362219532441e-15,   3.356113596998982e-17,   2.155413456461850e-18,   4.244778956752945e-01,  -4.935973155217491e-03,   5.739327521533079e-05,
  -6.671853733260156e-07,   7.745177463865083e-09,  -8.924028487456151e-11,   9.932434030369612e-13,  -9.523416225402273e-15,   3.246383894377677e-17,   2.193887399279960e-18,
   4.244891071029206e-01,  -4.936364042283454e-03,   5.740235064231322e-05,  -6.673596425560172e-07,   7.748085022350830e-09,  -8.927918398651397e-11,   9.934126304533580e-13,
  -9.507637763734044e-15,   3.159753012293372e-17,   2.224235396369750e-18,   4.244955777065232e-01,  -4.936589646350631e-03,   5.740758876527188e-05,  -6.674602282301237e-07,
   7.749763104619267e-09,  -8.930162352927458e-11,   9.935095736001790e-13,  -9.498499255659202e-15,   3.109647121167946e-17,   2.241777393820161e-18,   4.244980075334575e-01,
  -4.936674365850656e-03,   5.740955583017185e-05,  -6.674980013229656e-07,   7.750393255025230e-09,  -8.931004792736853e-11,   9.935458402461641e-13,  -9.495061517362423e-15,
   3.090811152834121e-17,   2.248369799719386e-18,   4.244984103147391e-01,  -4.936688409474985e-03,   5.740988190448623e-05,  -6.675042628683519e-07,   7.750497712203142e-09,
  -8.931144429303638e-11,   9.935518447591561e-13,  -9.494491339137682e-15,   3.087687728824382e-17,   2.249462860272291e-18,   7.038159266524090e-01,  -8.182827273491098e-03,
   9.512178876980541e-05,  -1.105354497588227e-06,   1.282227477785108e-08,  -1.473648375457109e-10,   1.621052600126057e-12,  -1.457741221240538e-14,   6.243374970175220e-19,
   5.714949402845820e-18,   7.038294852380926e-01,  -8.183299915932704e-03,   9.513275659620184e-05,  -1.105564571757048e-06,   1.282573469363142e-08,  -1.474079069372947e-10,
   1.621022883586066e-12,  -1.454665382059403e-14,  -9.205971376877955e-19,   5.769888237089543e-18,   7.038517449827865e-01,  -8.184075899925529e-03,   9.515076419394983e-05,
  -1.105909486606713e-06,   1.283141464241729e-08,  -1.474785449087169e-10,   1.620969607621365e-12,  -1.449595395445789e-14,  -3.464169310334805e-18,   5.860285006076605e-18,
   7.038753658309717e-01,  -8.184899367175440e-03,   9.516987454955506e-05,  -1.106275527822686e-06,   1.283744141773898e-08,  -1.475534054018651e-10,   1.620906961809064e-12,
  -1.444187846151343e-14,  -6.173044391840152e-18,   5.956482776211225e-18,   7.038939566767656e-01,  -8.185547504137233e-03,   9.518491660141821e-05,  -1.106563647524401e-06,
   1.284218445389513e-08,  -1.476122543061423e-10,   1.620853222012194e-12,  -1.439911841876886e-14,  -8.312154772755461e-18,   6.032393625378836e-18,   7.039046862640478e-01,
  -8.185921582271776e-03,   9.519359850610109e-05,  -1.106729944401658e-06,   1.284492172468000e-08,  -1.476461903606168e-10,   1.620820426060688e-12,  -1.437435954316301e-14,
  -9.549570716350972e-18,   6.076284547569529e-18,   7.039087154151903e-01,  -8.186062057173777e-03,   9.519685880686612e-05,  -1.106792393813382e-06,   1.284594959164388e-08,
  -1.476589286136951e-10,   1.620807773743229e-12,  -1.436504697503557e-14,  -1.001477994602768e-17,   6.092781393511405e-18,   7.039093833091183e-01,  -8.186085343154990e-03,
   9.519739925678493e-05,  -1.106802745870304e-06,   1.284611997501618e-08,  -1.476610398936763e-10,   1.620805658647617e-12,  -1.436350247272776e-14,  -1.009192391214702e-17,
   6.095516792701844e-18,   4.389308003845013e-03,  -4.876427874626344e-05,   5.416929680477878e-07,  -6.016367374375177e-09,   6.679279889278044e-11,  -7.400807729651068e-13,
   8.126512595445487e-15,  -8.595369233429408e-17,   7.834838471058891e-19,  -2.842957214787302e-21,   4.389385205620735e-03,  -4.876685099501819e-05,   5.417500971952585e-07,
  -6.017422734391295e-09,   6.681018264738031e-11,  -7.403378511253714e-13,   8.129614497205387e-15,  -8.596696535442114e-17,   7.825281183511195e-19,  -2.795050373465094e-21,
   4.389511950725905e-03,  -4.877107408393916e-05,   5.418438946795726e-07,  -6.019155543222027e-09,   6.683872566992623e-11,  -7.407599143680332e-13,   8.134703978003744e-15,
  -8.598857618821691e-17,   7.809520703708438e-19,  -2.716193844893288e-21,   4.389646445092611e-03,  -4.877555555120588e-05,   5.419434356624466e-07,  -6.020994546905464e-09,
   6.686901851157365e-11,  -7.412077937097682e-13,   8.140100503413759e-15,  -8.601126328027662e-17,   7.792701485889227e-19,  -2.632235801180329e-21,   4.389752298669112e-03,
  -4.877908281066069e-05,   5.420217855131142e-07,  -6.022442112834503e-09,   6.689286383328157e-11,  -7.415603041762211e-13,   8.144344832021796e-15,  -8.602894137876667e-17,
   7.779394979764036e-19,  -2.565953767473094e-21,   4.389813391164392e-03,  -4.878111858981756e-05,   5.420670069830736e-07,  -6.023277635810645e-09,   6.690662731655515e-11,
  -7.417637556556431e-13,   8.146793205701926e-15,  -8.603907278931990e-17,   7.771687568053725e-19,  -2.527618243560814e-21,   4.389836332443598e-03,  -4.878188306947149e-05,
   5.420839888959986e-07,  -6.023591402724494e-09,   6.691179599700019e-11,  -7.418401557432516e-13,   8.147712383961183e-15,  -8.604286380826759e-17,   7.768788068687077e-19,
  -2.513207205118571e-21,   4.389840135312201e-03,  -4.878200979420064e-05,   5.420868039334134e-07,  -6.023643415122404e-09,   6.691265279852568e-11,  -7.418528202584874e-13,
   8.147864739806361e-15,  -8.604349151529427e-17,   7.768307156024795e-19,  -2.510817542530342e-21,   3.992959036027555e-02,  -4.436092576586415e-04,   4.927787362092572e-06,
  -5.473091831956374e-08,   6.076101047004733e-10,  -6.732166886952823e-12,   7.390526571919494e-14,  -7.808078811399088e-16,   7.078325131540712e-18,  -2.398872451660266e-20,
   3.993029266573717e-02,  -4.436326574140844e-04,   4.928307062266471e-06,  -5.474051840495263e-08,   6.077681961306672e-10,  -6.734502040613868e-12,   7.393327966815969e-14,
  -7.809186248128371e-16,   7.069213833495251e-18,  -2.353800416388592e-20,   3.993144566744890e-02,  -4.436710748678180e-04,   4.929160331908141e-06,  -5.475628090188893e-08,
   6.080277719264820e-10,  -6.738335804637537e-12,   7.397924247830463e-14,  -7.810987445879740e-16,   7.054189757437304e-18,  -2.279609773121782e-20,   3.993266916428326e-02,
  -4.437118427899766e-04,   4.930065849743355e-06,  -5.477300939559076e-08,   6.083032605003280e-10,  -6.742404037023119e-12,   7.402797628681829e-14,  -7.812875730107910e-16,
   7.038157689190167e-18,  -2.200619034058924e-20,   3.993363211551210e-02,  -4.437439302804290e-04,   4.930778593199928e-06,  -5.478617717297977e-08,   6.085201138604965e-10,
  -6.745605981936036e-12,   7.406630369562951e-14,  -7.814345189114669e-16,   7.025474855045598e-18,  -2.138258202020368e-20,   3.993418787465907e-02,  -4.437624497698109e-04,
   4.931189969936435e-06,  -5.479377750282106e-08,   6.086452811672227e-10,  -6.747453976487052e-12,   7.408841260117953e-14,  -7.815186565836524e-16,   7.018129054191992e-18,
  -2.102190454408329e-20,   3.993439657174537e-02,  -4.437694042436102e-04,   4.931344453278589e-06,  -5.479663168144373e-08,   6.086922859465412e-10,  -6.748147933677251e-12,
   7.409671270989403e-14,  -7.815501247933235e-16,   7.015365660559681e-18,  -2.088631891033982e-20,   3.993443116648571e-02,  -4.437705570588663e-04,   4.931370061488219e-06,
  -5.479710481185771e-08,   6.087000778309062e-10,  -6.748262967902602e-12,   7.409808846585830e-14,  -7.815553344323747e-16,   7.014907326112551e-18,  -2.086383586005929e-20,
   1.134627001298390e-01,  -1.260546456762045e-03,   1.400264696984485e-05,  -1.555213774882684e-07,   1.726536051837906e-09,  -1.912768099098862e-11,   2.098705368999245e-13,
  -2.211706561150655e-15,   1.980390876911185e-17,  -5.629420384296078e-20,   1.134646957790931e-01,  -1.260612948640275e-03,   1.400412370640074e-05,  -1.555486534252037e-07,
   1.726984973043765e-09,  -1.913429451526320e-11,   2.099488513298341e-13,  -2.211957857316080e-15,   1.977536453361133e-17,  -5.491809491499038e-20,   1.134679721127252e-01,
  -1.260722114252577e-03,   1.400654828587360e-05,  -1.555934380955425e-07,   1.727722070388096e-09,  -1.914515220453167e-11,   2.100773337735871e-13,  -2.212365259309821e-15,
   1.972830208646832e-17,  -5.265293027096040e-20,   1.134714487630905e-01,  -1.260837958867365e-03,   1.400912132917509e-05,  -1.556409673418425e-07,   1.728504351383412e-09,
  -1.915667375106262e-11,   2.102135499517686e-13,  -2.212790544432681e-15,   1.967808967928554e-17,  -5.024117497568910e-20,   1.134741850552032e-01,  -1.260929137488476e-03,
   1.401114660083295e-05,  -1.556783798057964e-07,   1.729120129137581e-09,  -1.916574177004087e-11,   2.103206702794223e-13,  -2.213120168233063e-15,   1.963837249994846e-17,
  -4.833714007558523e-20,   1.134757642830225e-01,  -1.260981761781249e-03,   1.401231553417626e-05,  -1.556999739550393e-07,   1.729475554003046e-09,  -1.917097530047591e-11,
   2.103824583536111e-13,  -2.213308361929090e-15,   1.961537077960384e-17,  -4.723588945145183e-20,   1.134763573101390e-01,  -1.261001523355462e-03,   1.401275450096207e-05,
  -1.557080832802594e-07,   1.729609028546809e-09,  -1.917294058068825e-11,   2.104056541120715e-13,  -2.213378644826960e-15,   1.960671824326169e-17,  -4.682190606658183e-20,
   1.134764556134716e-01,  -1.261004799152434e-03,   1.401282726708170e-05,  -1.557094275437601e-07,   1.729631154336247e-09,  -1.917326635598730e-11,   2.104094988096302e-13,
  -2.213390274866256e-15,   1.960528316140931e-17,  -4.675325850212795e-20,   2.309691496005185e-01,  -2.566018060652208e-03,   2.850433145248077e-05,  -3.165842832163144e-07,
   3.514494994748794e-09,  -3.892888273263788e-11,   4.267200146055392e-13,  -4.476362479998535e-15,   3.916472192317577e-17,  -7.025986182330454e-20,   2.309732120213686e-01,
  -2.566153413600248e-03,   2.850733745542129e-05,  -3.166397948613539e-07,   3.515407710444093e-09,  -3.894226435257162e-11,   4.268746481812572e-13,  -4.476637119943186e-15,
   3.909662065184073e-17,  -6.709606862992338e-20,   2.309798814528873e-01,  -2.566375634532844e-03,   2.851227285975616e-05,  -3.167309399792320e-07,   3.516906318834003e-09,
  -3.896423298540558e-11,   4.271283054238035e-13,  -4.477076164412364e-15,   3.898435625925851e-17,  -6.188811899333571e-20,   2.309869586568842e-01,  -2.566611451446355e-03,
   2.851751047185005e-05,  -3.168276707070022e-07,   3.518496781270972e-09,  -3.898754411994836e-11,   4.273971844407438e-13,  -4.477525929432284e-15,   3.886460208005243e-17,
  -5.634294348294668e-20,   2.309925287589660e-01,  -2.566797057489422e-03,   2.852163305523390e-05,  -3.169038118473293e-07,   3.519748717375631e-09,  -3.900589061352033e-11,
   4.276085969038147e-13,  -4.477868220994083e-15,   3.876989596781290e-17,  -5.196499300455987e-20,   2.309957434962052e-01,  -2.566904181138480e-03,   2.852401250127029e-05,
  -3.169477598196188e-07,   3.520471327860986e-09,  -3.901647893376912e-11,   4.277305281172186e-13,  -4.478061076444544e-15,   3.871505503801136e-17,  -4.943282934577516e-20,
   2.309969506851430e-01,  -2.566944408414019e-03,   2.852490604898497e-05,  -3.169642637468131e-07,   3.520742692984787e-09,  -3.902045499068835e-11,   4.277762995356511e-13,
  -4.478132608673438e-15,   3.869442688613349e-17,  -4.848092483203232e-20,   2.309971507952095e-01,  -2.566951076728277e-03,   2.852505416952800e-05,  -3.169669995631363e-07,
   3.520787676571995e-09,  -3.902111408099624e-11,   4.277838860134079e-13,  -4.478144419354166e-15,   3.869100563624528e-17,  -4.832307753123693e-20,   4.055731227333711e-01,
  -4.505830868206057e-03,   5.005250312227822e-05,  -5.559064205167638e-07,   6.170975480195146e-09,  -6.833177325979783e-11,   7.477074340799859e-13,  -7.777070037269858e-15,
   6.503744033984060e-17,   2.242201630962749e-20,   4.055802561865696e-01,  -4.506068541185241e-03,   5.005778123487834e-05,  -5.560038578294750e-07,   6.172574579913986e-09,
  -6.835500954551039e-11,   7.479633886874423e-13,  -7.776772158721558e-15,   6.488447964906747e-17,   2.920869916007782e-20,   4.055919674491916e-01,  -4.506458749970339e-03,
   5.006644709903471e-05,  -5.561638408505157e-07,   6.175200154172429e-09,  -6.839315490693904e-11,   7.483831333319945e-13,  -7.776257779008072e-15,   6.463236922277058e-17,
   4.038104981417477e-20,   4.056043947443936e-01,  -4.506872832597517e-03,   5.007564359377055e-05,  -5.563336276869573e-07,   6.177986625504248e-09,  -6.843362901763493e-11,
   7.488279067354299e-13,  -7.775677447549328e-15,   6.436349864594277e-17,   5.227782808978860e-20,   4.056141756271631e-01,  -4.507198747451989e-03,   5.008288225600964e-05,
  -5.564672743402769e-07,   6.180179979503884e-09,  -6.846548155986717e-11,   7.491775042050297e-13,  -7.775195669842112e-15,   6.415090852580075e-17,   6.167113090870040e-20,
   4.056198205807979e-01,  -4.507386851174282e-03,   5.008706021942063e-05,  -5.565444138655177e-07,   6.181445961784213e-09,  -6.848386395809762e-11,   7.493790863392205e-13,
  -7.774907567358016e-15,   6.402782225611852e-17,   6.710441568318164e-20,   4.056219403576464e-01,  -4.507457488239331e-03,   5.008862915992335e-05,  -5.565733823063355e-07,
   6.181921379965848e-09,  -6.849076666873166e-11,   7.494547488552413e-13,  -7.774797478779287e-15,   6.398152716445373e-17,   6.914698016177135e-20,   4.056222917431443e-01,
  -4.507469197462480e-03,   5.008888923815707e-05,  -5.565781843340582e-07,   6.182000188877083e-09,  -6.849191088849287e-11,   7.494672892276005e-13,  -7.774779129570111e-15,
   6.397384913374486e-17,   6.948568645868613e-20,   6.725272041393060e-01,  -7.471633263481690e-03,   8.299768485601262e-05,  -9.217994532442049e-07,   1.023159427148080e-08,
  -1.132170528822931e-10,   1.234112768491377e-12,  -1.259109639084614e-14,   9.388775073325981e-17,   5.950485241986570e-19,   6.725390329181568e-01,  -7.472027370376950e-03,
   8.300643599467764e-05,  -9.219608865902131e-07,   1.023423295787108e-08,  -1.132546241703504e-10,   1.234478828557680e-12,  -1.258760873689631e-14,   9.350236829307643e-17,
   6.113302145551892e-19,   6.725584526761446e-01,  -7.472674410536405e-03,   8.302080403535989e-05,  -9.222259441832120e-07,   1.023856534922578e-08,  -1.133162957009372e-10,
   1.235078651460808e-12,  -1.258182230002565e-14,   9.286725623002927e-17,   6.381385216060711e-19,   6.725790597678880e-01,  -7.473361037993208e-03,   8.303605185293645e-05,
  -9.225072432719959e-07,   1.024316311225301e-08,  -1.133817232617022e-10,   1.235713578502384e-12,  -1.257559952849542e-14,   9.219002573444857e-17,   6.666920845884074e-19,
   6.725952785462910e-01,  -7.473901466533192e-03,   8.304805357005901e-05,  -9.227286651389621e-07,   1.024678212611866e-08,  -1.134332072918097e-10,   1.236212157573454e-12,
  -1.257064201457110e-14,   9.165462837362427e-17,   6.892420988657391e-19,   6.726046390768046e-01,  -7.474213378104294e-03,   8.305498063893829e-05,  -9.228564672616925e-07,
   1.024887095008804e-08,  -1.134629165852295e-10,   1.236499450613621e-12,  -1.256775677924877e-14,   9.134467129574780e-17,   7.022875378032721e-19,   6.726081541164494e-01,
  -7.474330507723242e-03,   8.305758194377002e-05,  -9.229044611087903e-07,   1.024965536586890e-08,  -1.134740721232534e-10,   1.236607247457628e-12,  -1.256666877375047e-14,
   9.122809605467409e-17,   7.071921659675195e-19,   6.726087367881375e-01,  -7.474349923830528e-03,   8.305801315369470e-05,  -9.229124169278053e-07,   1.024978539620688e-08,
  -1.134759212818052e-10,   1.236625111864212e-12,  -1.256648818000585e-14,   9.120876236718520e-17,   7.080054915458362e-19,   4.202484979754299e-03,  -4.470241293014959e-05,
   4.754524249523849e-07,  -5.056267358551083e-09,   5.376073693095457e-11,  -5.712147629898993e-13,   6.050063347772371e-15,  -6.320985593607215e-17,   6.259250976712018e-19,
  -4.998467146291172e-21,   4.202552732586286e-03,  -4.470457443992353e-05,   4.754984015933533e-07,  -5.057081837785439e-09,   5.377368108161490e-11,  -5.714040663518120e-13,
   6.052557206624253e-15,  -6.323515159408787e-17,   6.259172712377900e-19,  -4.986927350544485e-21,   4.202663964569445e-03,  -4.470812315984897e-05,   4.755738876905899e-07,
  -5.058419132186820e-09,   5.379493484802378e-11,  -5.717148929011017e-13,   6.056651244485354e-15,  -6.327663519799577e-17,   6.259022242679140e-19,  -4.967905720565411e-21,
   4.202781996749310e-03,  -4.471188896824545e-05,   4.756539951485300e-07,  -5.059838369856562e-09,   5.381749196695483e-11,  -5.720447778363456e-13,   6.060995283955896e-15,
  -6.332059348472658e-17,   6.258832647371460e-19,  -4.947617255144319e-21,   4.202874893364720e-03,  -4.471485292709415e-05,   4.757170480135152e-07,  -5.060955509219766e-09,
   5.383524832483132e-11,  -5.723044525104822e-13,   6.064414026087221e-15,  -6.335514602890905e-17,   6.258661718199063e-19,  -4.931573959262921e-21,   4.202928507689966e-03,
  -4.471656358506489e-05,   4.757534402117594e-07,  -5.061600309106256e-09,   5.384549738408709e-11,  -5.724543372734338e-13,   6.066387032179309e-15,  -6.337506975714457e-17,
   6.258554352465012e-19,  -4.922284491508774e-21,   4.202948640756066e-03,  -4.471720597292482e-05,   4.757671064408096e-07,  -5.061842452414174e-09,   5.384934629465349e-11,
  -5.725106245413964e-13,   6.067127912294706e-15,  -6.338254805546098e-17,   6.258512385877219e-19,  -4.918790421981428e-21,   4.202951978118619e-03,  -4.471731245889842e-05,
   4.757693718453711e-07,  -5.061882591900452e-09,   5.384998432180756e-11,  -5.725199551753104e-13,   6.067250723602345e-15,  -6.338378751836406e-17,   6.258505342245381e-19,
  -4.918210924810965e-21,   3.823005895455404e-02,  -4.066584147392601e-04,   4.325196628057745e-06,  -4.599691673121901e-08,   4.890610266240558e-10,  -5.196266672559843e-12,
   5.503244940129635e-14,  -5.747549801417606e-16,   5.681995710875335e-18,  -4.499465801549523e-20,   3.823067530290802e-02,  -4.066780780157186e-04,   4.325614877157555e-06,
  -4.600432593639629e-08,   4.891787683379609e-10,  -5.197987932036146e-12,   5.505508572640534e-14,  -5.749825415831526e-16,   5.681813580225168e-18,  -4.488551006751074e-20,
   3.823168718164006e-02,  -4.067103607570342e-04,   4.326301573515274e-06,  -4.601649111813963e-08,   4.893720953450384e-10,  -5.200814147722163e-12,   5.509224627551462e-14,
  -5.753557108920443e-16,   5.681493943492145e-18,  -4.470560158182093e-20,   3.823276092184583e-02,  -4.067446183543295e-04,   4.327030310340757e-06,  -4.602940172527853e-08,
   4.895772777122602e-10,  -5.203813646045425e-12,   5.513167558491491e-14,  -5.757511141736088e-16,   5.681126681879461e-18,  -4.451371882835417e-20,   3.823360600350955e-02,
  -4.067715815180923e-04,   4.327603901680310e-06,  -4.603956418541849e-08,   4.897387916834522e-10,  -5.206174748118746e-12,   5.516270597737863e-14,  -5.760618933198754e-16,
   5.680817258051673e-18,  -4.436199119253260e-20,   3.823409373369190e-02,  -4.067871433910182e-04,   4.327934961174090e-06,  -4.604542983923416e-08,   4.898320183316203e-10,
  -5.207537579029915e-12,   5.518061394207508e-14,  -5.762410871887018e-16,   5.680630498168127e-18,  -4.427413929426130e-20,   3.823427688444414e-02,  -4.067929871998983e-04,
   4.328059282733936e-06,  -4.604763258276232e-08,   4.898670284690420e-10,  -5.208049372002696e-12,   5.518733850665917e-14,  -5.763083454415943e-16,   5.680558819285009e-18,
  -4.424109576227903e-20,   3.823430724447272e-02,  -4.067939559038806e-04,   4.328079891098347e-06,  -4.604799772600567e-08,   4.898728320378191e-10,  -5.208134210934245e-12,
   5.518845319660703e-14,  -5.763194928323668e-16,   5.680546855745400e-18,  -4.423561545985627e-20,   1.086333638059686e-01,  -1.155548084781388e-03,   1.229034562454879e-05,
  -1.307033584460494e-07,   1.389694114808755e-09,  -1.476504480901435e-11,   1.563469025892750e-13,  -1.631538764541433e-15,   1.607000944025080e-17,  -1.248514961570798e-19,
   1.086351152024701e-01,  -1.155603959312350e-03,   1.229153410223751e-05,  -1.307244114499660e-07,   1.390028614778348e-09,  -1.476993064551653e-11,   1.564109086951013e-13,
  -1.632169291909437e-15,   1.606878997965124e-17,  -1.245148568005545e-19,   1.086379905259124e-01,  -1.155695692906606e-03,   1.229348538744526e-05,  -1.307589783938375e-07,
   1.390577849369030e-09,  -1.477795289308382e-11,   1.565159812072082e-13,  -1.633203141485002e-15,   1.606672531053920e-17,  -1.239600071480285e-19,   1.086410416330123e-01,
  -1.155793038187450e-03,   1.229555613287827e-05,  -1.307956634309863e-07,   1.391160763934444e-09,  -1.478646695952313e-11,   1.566274659051680e-13,  -1.634298414569200e-15,
   1.606444912931609e-17,  -1.233682723979226e-19,   1.086434429910406e-01,  -1.155869655841574e-03,   1.229718602390809e-05,  -1.308245396996103e-07,   1.391619617934235e-09,
  -1.479316890684780e-11,   1.567152009903976e-13,  -1.635159150492602e-15,   1.606259580251467e-17,  -1.229004013305848e-19,   1.086448289101051e-01,  -1.155913875956292e-03,
   1.229812674747202e-05,  -1.308412067439503e-07,   1.391884470501391e-09,  -1.479703726536199e-11,   1.567658330113174e-13,  -1.635655395897759e-15,   1.606150133425603e-17,
  -1.226295117916165e-19,   1.086453493456418e-01,  -1.155930481534555e-03,   1.229848001394511e-05,  -1.308474657600567e-07,   1.391983932636125e-09,  -1.479848997327149e-11,
   1.567848455308157e-13,  -1.635841645935754e-15,   1.606108564369397e-17,  -1.225276251323814e-19,   1.086454356157639e-01,  -1.155933234172451e-03,   1.229853857373312e-05,
  -1.308485033013617e-07,   1.392000420297018e-09,  -1.479873078571884e-11,   1.567879971117485e-13,  -1.635872514527986e-15,   1.606101648860851e-17,  -1.225107272556140e-19,
   2.211383621163268e-01,  -2.352279270112272e-03,   2.501871056095486e-05,  -2.660646602510828e-07,   2.828891897560607e-09,  -3.005446535917556e-11,   3.181506400411883e-13,
  -3.315119182038956e-15,   3.243394094012692e-17,  -2.430402725437635e-19,   2.211419273278304e-01,  -2.352393010394101e-03,   2.502112985082387e-05,  -2.661075137915923e-07,
   2.829572558887230e-09,  -3.006439195664061e-11,   3.182797679084062e-13,  -3.316343096569104e-15,   3.242884397825331e-17,  -2.422556081685384e-19,   2.211477804491537e-01,
  -2.352579746723424e-03,   2.502510192736182e-05,  -2.661778750343408e-07,   2.830690173815463e-09,  -3.008069070316255e-11,   3.184917367050302e-13,  -3.318349406878666e-15,
   3.242033336068202e-17,  -2.409624251650235e-19,   2.211539914025908e-01,  -2.352777906410269e-03,   2.502931717938620e-05,  -2.662525476433971e-07,   2.831876320356603e-09,
  -3.009798850421503e-11,   3.187166306941744e-13,  -3.320474246471842e-15,   3.241110805174802e-17,  -2.395834128687449e-19,   2.211588797012981e-01,  -2.352933872165683e-03,
   2.503263501895421e-05,  -2.663113254388708e-07,   2.832810019919958e-09,  -3.011160454750681e-11,   3.188936078543072e-13,  -3.322143594447484e-15,   3.240370629921322e-17,
  -2.384931591963385e-19,   2.211617009325718e-01,  -2.353023888280746e-03,   2.503454997504724e-05,  -2.663452512868529e-07,   2.833348954760153e-09,  -3.011946366681541e-11,
   3.189957385254125e-13,  -3.323105837889418e-15,   3.239937783536183e-17,  -2.378619602492381e-19,   2.211627603515878e-01,  -2.353057691215230e-03,   2.503526909148021e-05,
  -2.663579915424234e-07,   2.833551345000826e-09,  -3.012241503968343e-11,   3.190340884085483e-13,  -3.323466948426161e-15,   3.239774171334303e-17,  -2.376245619153567e-19,
   2.211629359664362e-01,  -2.353063294587599e-03,   2.503538829697763e-05,  -2.663601034623612e-07,   2.833584894863532e-09,  -3.012290428228808e-11,   3.190404453871621e-13,
  -3.323526795976562e-15,   3.239746993580297e-17,  -2.375851898554727e-19,   3.883106306919183e-01,  -4.130513726312033e-03,   4.393190687639856e-05,  -4.671987324087267e-07,
   4.967352073263134e-09,  -5.276874391847698e-11,   5.582973559628402e-13,  -5.801843360936998e-15,   5.606018833587197e-17,  -3.908498320912822e-19,   3.883168910679652e-01,
  -4.130713449594849e-03,   4.393615498911123e-05,  -4.672739728893436e-07,   4.968546469028551e-09,  -5.278611362934707e-11,   5.585203644231346e-13,  -5.803799593371884e-15,
   5.604268172228607e-17,  -3.891424456158634e-19,   3.883271689267872e-01,  -4.131041350948690e-03,   4.394312969182168e-05,  -4.673975101980901e-07,   4.970507606911542e-09,
  -5.281463301695653e-11,   5.588864167506192e-13,  -5.807004662380272e-15,   5.601363841984217e-17,  -3.863287806316329e-19,   3.883380751252046e-01,  -4.131389311247171e-03,
   4.395053139385007e-05,  -4.675286171378731e-07,   4.972588993175104e-09,  -5.284489998672999e-11,   5.592747552011342e-13,  -5.810396763998184e-15,   5.598240815222123e-17,
  -3.833286817279058e-19,   3.883466587921274e-01,  -4.131663180726512e-03,   4.395635729882502e-05,  -4.676318165895672e-07,   4.974227393477391e-09,  -5.286872436856199e-11,
   5.595803275559991e-13,  -5.813060031921175e-15,   5.595753007173237e-17,  -3.809570124521432e-19,   3.883516127671197e-01,  -4.131821245337087e-03,   4.395971983379085e-05,
  -4.676913820671946e-07,   4.975173081956189e-09,  -5.288247553373526e-11,   5.597566583494120e-13,  -5.814594511309551e-15,   5.594305210950356e-17,  -3.795840308023176e-19,
   3.883534730666844e-01,  -4.131880601905107e-03,   4.396098255416646e-05,  -4.677137508300999e-07,   4.975528223017259e-09,  -5.288763954435425e-11,   5.598228683339156e-13,
  -5.815170241944440e-15,   5.593759272191693e-17,  -3.790676595266381e-19,   3.883537814396898e-01,  -4.131890441197403e-03,   4.396119187104772e-05,  -4.677174588430956e-07,
   4.975587094083787e-09,  -5.288849556945050e-11,   5.598338433761380e-13,  -5.815265652113182e-15,   5.593668654853478e-17,  -3.789820212174177e-19,   6.439022918047967e-01,
  -6.849277369075531e-03,   7.284850158446002e-05,  -7.747130220793917e-07,   8.236676367408127e-09,  -8.748191397398258e-11,   9.245011952727701e-13,  -9.551612403541589e-15,
   8.972427466206981e-17,  -5.154100634443394e-19,   6.439126728473239e-01,  -6.849608551863120e-03,   7.285554562909719e-05,  -7.748377566481752e-07,   8.238654046763664e-09,
  -8.751049872538763e-11,   9.248574222466278e-13,  -9.554141816648198e-15,   8.966284277513488e-17,  -5.112978656270998e-19,   6.439297157355705e-01,  -6.850152280570977e-03,
   7.286711079060219e-05,  -7.750425580545369e-07,   8.241901276509962e-09,  -8.755743061309235e-11,   9.254420454763137e-13,  -9.558278837054729e-15,   8.956128041139245e-17,
  -5.045214014839991e-19,   6.439478005452248e-01,  -6.850729271171817e-03,   7.287938398214788e-05,  -7.752599081698652e-07,   8.245347584260441e-09,  -8.760723628329411e-11,
   9.260621287812421e-13,  -9.562647525121202e-15,   8.945254529533704e-17,  -4.972961620804180e-19,   6.439620341008785e-01,  -6.851183403763394e-03,   7.288904425140536e-05,
  -7.754309928125208e-07,   8.248060386588758e-09,  -8.764643888569662e-11,   9.265499577831311e-13,  -9.566070452279154e-15,   8.936626663263896e-17,  -4.915845547312938e-19,
   6.439702488509732e-01,  -6.851445507778634e-03,   7.289461986397456e-05,  -7.755297407145910e-07,   8.249626214286280e-09,  -8.766906558512725e-11,   9.268314210656703e-13,
  -9.568039762601345e-15,   8.931619100266790e-17,  -4.882781151886560e-19,   6.439733336255308e-01,  -6.851543933318907e-03,   7.289671365309956e-05,  -7.755668237281409e-07,
   8.250214239059267e-09,  -8.767756253419252e-11,   9.269370996126988e-13,  -9.568778098357893e-15,   8.929733364479066e-17,  -4.870345922257324e-19,   6.439738449739284e-01,
  -6.851560248912786e-03,   7.289706073342642e-05,  -7.755729708842008e-07,   8.250311714739898e-09,  -8.767897104612864e-11,   9.269546166201762e-13,  -9.568900426850985e-15,
   8.929420494602796e-17,  -4.868283590544612e-19,   4.030917851034111e-03,  -4.112769126309933e-05,   4.195852503269837e-07,  -4.280163790956978e-09,   4.365609778329710e-11,
  -4.451519527629505e-13,   4.534155479131697e-15,  -4.596176314171335e-17,   4.569054892478498e-19,  -4.219698665311633e-21,   4.030977636169197e-03,  -4.112952080173682e-05,
   4.196225807987733e-07,  -4.280798437805644e-09,   4.366579811369297e-11,  -4.452896522872340e-13,   4.535979779324722e-15,  -4.598334972978400e-17,   4.570848882101720e-19,
  -4.218559011091522e-21,   4.031075786995708e-03,  -4.113252448170483e-05,   4.196838708051244e-07,  -4.281840455129925e-09,   4.368172559305984e-11,  -4.455157549551845e-13,
   4.538975176949934e-15,  -4.601878321115254e-17,   4.573788524830135e-19,  -4.216664590018617e-21,   4.031179937843944e-03,  -4.113571188499045e-05,   4.197489123882330e-07,
  -4.282946308810274e-09,   4.369862970887994e-11,  -4.457557307083211e-13,   4.542154222521873e-15,  -4.605637485024535e-17,   4.576900243898463e-19,  -4.214622471893148e-21,
   4.031261908899773e-03,  -4.113822058123976e-05,   4.198001063571332e-07,  -4.283816761056243e-09,   4.371193610967489e-11,  -4.459446387484648e-13,   4.544656652188892e-15,
  -4.608595526898187e-17,   4.579343760300936e-19,  -4.212992104494881e-21,   4.031309217518702e-03,  -4.113966847631794e-05,   4.198296537634130e-07,  -4.284319172029628e-09,
   4.371961660537114e-11,  -4.460536796546067e-13,   4.546101055124254e-15,  -4.610302493135891e-17,   4.580751782691568e-19,  -4.212041868389215e-21,   4.031326982662797e-03,
  -4.114021218995087e-05,   4.198407495554717e-07,  -4.284507842924122e-09,   4.372250091799672e-11,  -4.460946290734209e-13,   4.546643480912594e-15,  -4.610943442220894e-17,
   4.581280096711430e-19,  -4.211683281998022e-21,   4.031329927504872e-03,  -4.114030231904013e-05,   4.198425888654198e-07,  -4.284539118383538e-09,   4.372297904518480e-11,
  -4.461014172090093e-13,   4.546733397761680e-15,  -4.611049686924095e-17,   4.581367650552604e-19,  -4.211623748104457e-21,   3.666931061798351e-02,  -3.741391269391174e-04,
   3.816972304720546e-06,  -3.893670167276198e-08,   3.971398400577180e-10,  -4.049535038964721e-12,   4.124613449090556e-14,  -4.180537048413150e-16,   4.153639903159666e-18,
  -3.827143294202018e-20,   3.666985448410964e-02,  -3.741557702740925e-04,   3.817311900280475e-06,  -3.894247503605697e-08,   3.972280815207706e-10,  -4.050787500914888e-12,
   4.126271829555634e-14,  -4.182494587053869e-16,   4.155244091415405e-18,  -3.825997943330109e-20,   3.667074736341338e-02,  -3.741830947868550e-04,   3.817869455890341e-06,
  -3.895195423612078e-08,   3.973729697721147e-10,  -4.052844042590963e-12,   4.128994788607601e-14,  -4.185707762884515e-16,   4.157872464898035e-18,  -3.824095646247046e-20,
   3.667169482499022e-02,  -3.742120906328337e-04,   3.818461139617635e-06,  -3.896201415331672e-08,   3.975267422138767e-10,  -4.055026766677561e-12,   4.131884681794050e-14,
  -4.189116587395034e-16,   4.160654339909860e-18,  -3.822047180678071e-20,   3.667244051671643e-02,  -3.742349122727414e-04,   3.818926851501992e-06,  -3.896993263065106e-08,
   3.976477871394923e-10,  -4.056744997861968e-12,   4.134159493473806e-14,  -4.191798909788018e-16,   4.162838584409942e-18,  -3.820413275689535e-20,   3.667287088381806e-02,
  -3.742480837916524e-04,   3.819195644457873e-06,  -3.897450304775993e-08,   3.977176546378432e-10,  -4.057736789360783e-12,   4.135472512169301e-14,  -4.193346752786507e-16,
   4.164097103336810e-18,  -3.819461583306238e-20,   3.667303249355740e-02,  -3.742530299610989e-04,   3.819296582953575e-06,  -3.897621938104564e-08,   3.977438924882685e-10,
  -4.058109248434145e-12,   4.135965597816685e-14,  -4.193927949496611e-16,   4.164569301440253e-18,  -3.819102560815152e-20,   3.667305928282280e-02,  -3.742538498665059e-04,
   3.819313315168656e-06,  -3.897650389293085e-08,   3.977482418883053e-10,  -4.058170990518750e-12,   4.136047335617419e-14,  -4.194024289387760e-16,   4.164647554538436e-18,
  -3.819042960476923e-20,   1.041983891743329e-01,  -1.063142275539505e-03,   1.084619139945035e-05,  -1.106413231470746e-07,   1.128498949089206e-09,  -1.150692320952288e-11,
   1.171966711129739e-13,  -1.187547149708170e-15,   1.178509911819875e-17,  -1.080275597458686e-19,   1.041999346076289e-01,  -1.063189568723086e-03,   1.084715638245728e-05,
  -1.106577283904637e-07,   1.128749677322790e-09,  -1.151048096452345e-11,   1.172437207348999e-13,  -1.188099506761493e-15,   1.178948242763469e-17,  -1.079881533940968e-19,
   1.042024717860611e-01,  -1.063267213209564e-03,   1.084874071319963e-05,  -1.106846639164579e-07,   1.129161360948335e-09,  -1.151632278771025e-11,   1.173209728395267e-13,
  -1.189006139328194e-15,   1.179666256688280e-17,  -1.079227947200274e-19,   1.042051640638055e-01,  -1.063349606904507e-03,   1.085042202120684e-05,  -1.107132495717321e-07,
   1.129598287846191e-09,  -1.152252303425595e-11,   1.174029603054906e-13,  -1.189967940064826e-15,   1.180425975890954e-17,  -1.078525361926892e-19,   1.042072829985334e-01,
  -1.063414456167277e-03,   1.085174537197395e-05,  -1.107357502391597e-07,   1.129942223119535e-09,  -1.152740383412237e-11,   1.174674971697287e-13,  -1.190724731722647e-15,
   1.181022318638179e-17,  -1.077965836457838e-19,   1.042085059164837e-01,  -1.063451883946083e-03,   1.085250916472751e-05,  -1.107487372601702e-07,   1.130140743558332e-09,
  -1.153022110941874e-11,   1.175047475790840e-13,  -1.191161430275000e-15,   1.181365852861755e-17,  -1.077640278441113e-19,   1.042089651417600e-01,  -1.063465938827466e-03,
   1.085279598806005e-05,  -1.107536142890037e-07,   1.130215295375886e-09,  -1.153127911318431e-11,   1.175187364079387e-13,  -1.191325403406540e-15,   1.181494734732207e-17,
  -1.077517527717764e-19,   1.042090412653146e-01,  -1.063468268645189e-03,   1.085284353374272e-05,  -1.107544227407600e-07,   1.130227653692633e-09,  -1.153145449714101e-11,
   1.175210553055827e-13,  -1.191352583691547e-15,   1.181516092483786e-17,  -1.077497153614347e-19,   2.121103527700484e-01,  -2.164174366612913e-03,   2.207893480099366e-05,
  -2.252257897195046e-07,   2.297211777274859e-09,  -2.342354445770075e-11,   2.385445080271000e-13,  -2.416030266465237e-15,   2.392535258732301e-17,  -2.172507775803403e-19,
   2.121134987149816e-01,  -2.164270638458559e-03,   2.208089915369840e-05,  -2.252591842703619e-07,   2.297722111536349e-09,  -2.343078238776863e-11,   2.386400121590504e-13,
  -2.417140379854093e-15,   2.393362917069904e-17,  -2.171450899534233e-19,   2.121186634954049e-01,  -2.164428694597782e-03,   2.208412427198727e-05,  -2.253140142840440e-07,
   2.298560055286084e-09,  -2.344266701768605e-11,   2.387968212812184e-13,  -2.418962407917206e-15,   2.394718027597200e-17,  -2.169700743280083e-19,   2.121241440021008e-01,
  -2.164596418410370e-03,   2.208754680049122e-05,  -2.253722032982973e-07,   2.299449378811269e-09,  -2.345528078494165e-11,   2.389632399416761e-13,  -2.420895170084461e-15,
   2.396150966123966e-17,  -2.167823099446544e-19,   2.121284573891528e-01,  -2.164728428093719e-03,   2.209024065886913e-05,  -2.254180056952986e-07,   2.300149426242452e-09,
  -2.346521024339362e-11,   2.390942354707552e-13,  -2.422415863107438e-15,   2.397275110962259e-17,  -2.166330443033488e-19,   2.121309468091346e-01,  -2.164804617536938e-03,
   2.209179546167749e-05,  -2.254444420956487e-07,   2.300553495490132e-09,  -2.347094167284589e-11,   2.391698448243816e-13,  -2.423293323260716e-15,   2.397922436557448e-17,
  -2.165463002551733e-19,   2.121318816262079e-01,  -2.164833228200479e-03,   2.209237932911900e-05,  -2.254543697828599e-07,   2.300705238509083e-09,  -2.347309406016310e-11,
   2.391982386392906e-13,  -2.423622787647818e-15,   2.398165241128257e-17,  -2.165136134878386e-19,   2.121320365863159e-01,  -2.164837970868110e-03,   2.209247611474593e-05,
  -2.254560154684504e-07,   2.300730392666722e-09,  -2.347345085858947e-11,   2.392029454128520e-13,  -2.423677399467875e-15,   2.398205475069704e-17,  -2.165081891968963e-19,
   3.724577865483984e-01,  -3.800208629284119e-03,   3.876977625476143e-05,  -3.954878350106176e-07,   4.033801246995273e-09,  -4.112961442394924e-11,   4.187951917766655e-13,
  -4.238104933521289e-15,   4.180704848330487e-17,  -3.730277028107097e-19,   3.724633107089441e-01,  -3.800377678940304e-03,   3.877322556933788e-05,  -3.955464726922791e-07,
   4.034697193730840e-09,  -4.114231021450575e-11,   4.189620332771460e-13,  -4.240008689911606e-15,   4.181950173210675e-17,  -3.727592664134095e-19,   3.724723798683993e-01,
  -3.800655219437803e-03,   3.877888873119092e-05,  -3.956427490109309e-07,   4.036168292893360e-09,  -4.116315651736432e-11,   4.192359660315703e-13,  -4.243132996244729e-15,
   4.183986847483603e-17,  -3.723154109717719e-19,   3.724820034312685e-01,  -3.800949735996834e-03,   3.878489853629984e-05,  -3.957449233978090e-07,   4.037729592934169e-09,
  -4.118528163781557e-11,   4.195266778857017e-13,  -4.246446736852767e-15,   4.186137387093867e-17,  -3.718401242706744e-19,   3.724895775761000e-01,  -3.801181539919001e-03,
   3.878962882954410e-05,  -3.958253480464068e-07,   4.038958597800664e-09,  -4.120269826442413e-11,   4.197555043210070e-13,  -4.249053656701989e-15,   4.187822229104366e-17,
  -3.714629353697550e-19,   3.724939489036109e-01,  -3.801315325648094e-03,   3.879235899277767e-05,  -3.958717678430134e-07,   4.039667982177064e-09,  -4.121275135955140e-11,
   4.198875784003462e-13,  -4.250557754011215e-15,   4.188791513531032e-17,  -3.712439931050392e-19,   3.724955904071015e-01,  -3.801365564871753e-03,   3.879338423752275e-05,
  -3.958891999134580e-07,   4.039934382275572e-09,  -4.121652670277335e-11,   4.199371761480450e-13,  -4.251122480358144e-15,   4.189154908244094e-17,  -3.711615398480000e-19,
   3.724958625112014e-01,  -3.801373892813515e-03,   3.879355418869333e-05,  -3.958920895801023e-07,   4.039978542918588e-09,  -4.121715253609558e-11,   4.199453978226531e-13,
  -4.251216087758642e-15,   4.189215115437300e-17,  -3.711478594647694e-19,   6.176148770772288e-01,  -6.301560774178721e-03,   6.428859836221063e-05,  -6.558030872824752e-07,
   6.688853381773735e-09,  -6.819748070154829e-11,   6.941771907770954e-13,  -7.012524970141947e-15,   6.860102040224895e-17,  -5.882133549922951e-19,   6.176240373192800e-01,
  -6.301841094501366e-03,   6.429431801571033e-05,  -6.559003146920733e-07,   6.690338430086008e-09,  -6.821848509909078e-11,   6.944508056828314e-13,  -7.015517969320217e-15,
   6.861405343711506e-17,  -5.874584517014815e-19,   6.176390759292355e-01,  -6.302301315735848e-03,   6.430370867041984e-05,  -6.560599508497515e-07,   6.692776799598276e-09,
  -6.825297366951885e-11,   6.949000253443568e-13,  -7.020428611437351e-15,   6.863526884859614e-17,  -5.862118477706639e-19,   6.176550338588559e-01,  -6.302789686891825e-03,
   6.431367412842975e-05,  -6.562293665516994e-07,   6.695364672181550e-09,  -6.828957747452821e-11,   6.953767314614293e-13,  -7.025635293332736e-15,   6.865753421426406e-17,
  -5.848791516633776e-19,   6.176675934141626e-01,  -6.303174067142639e-03,   6.432151789965592e-05,  -6.563627188893718e-07,   6.697401757176069e-09,  -6.831839120576348e-11,
   6.957519371760869e-13,  -7.029730151882424e-15,   6.867487870727888e-17,  -5.838230902479920e-19,   6.176748420119701e-01,  -6.303395912361795e-03,   6.432604505557985e-05,
  -6.564396876661340e-07,   6.698577565391058e-09,  -6.833502271574267e-11,   6.959684898847839e-13,  -7.032092237555712e-15,   6.868481685612455e-17,  -5.832107160063059e-19,
   6.176775639765383e-01,  -6.303479219689397e-03,   6.432774511610525e-05,  -6.564685918205107e-07,   6.699019124563836e-09,  -6.834126849352818e-11,   6.960498102466166e-13,
  -7.032979008796145e-15,   6.868853515937524e-17,  -5.829802145139586e-19,   6.176780151834489e-01,  -6.303493029189657e-03,   6.432802692908320e-05,  -6.564733831829396e-07,
   6.699092320978678e-09,  -6.834230384593778e-11,   6.960632904010360e-13,  -7.033125992446721e-15,   6.868915080499694e-17,  -5.829419766209793e-19,   3.872811075272313e-03,
  -3.796522293907311e-05,   3.721384944399395e-07,  -3.647387550597148e-09,   3.574498696445918e-11,  -3.502555518446730e-13,   3.430681001210424e-15,  -3.354741432251357e-17,
   3.257941610795267e-19,  -3.080946903603849e-21,   3.872864094774495e-03,  -3.796678185331495e-05,   3.721690566725428e-07,  -3.647886838799717e-09,   3.575232559833176e-11,
  -3.503560595176451e-13,   3.431982660617760e-15,  -3.356322750498276e-17,   3.259628093401352e-19,  -3.082043546919832e-21,   3.872951138020981e-03,  -3.796934121768394e-05,
   3.722192340590613e-07,  -3.648706604700004e-09,   3.576437516404446e-11,  -3.505210933097904e-13,   3.434120030511574e-15,  -3.358919142002147e-17,   3.262395927598224e-19,
  -3.083837949029361e-21,   3.873043501918654e-03,  -3.797205711088501e-05,   3.722724823092934e-07,  -3.649576580381227e-09,   3.577716341749183e-11,  -3.506962533784687e-13,
   3.436388604628912e-15,  -3.361674658774184e-17,   3.265331720728432e-19,  -3.085733888495650e-21,   3.873116195894782e-03,  -3.797419468502177e-05,   3.723143934262851e-07,
  -3.650261357703033e-09,   3.578722981921884e-11,  -3.508341389153013e-13,   3.438174461754583e-15,  -3.363843658392629e-17,   3.267641409603545e-19,  -3.087220151250852e-21,
   3.873158150253935e-03,  -3.797542838175562e-05,   3.723385829411282e-07,  -3.650656596933276e-09,   3.579304012991464e-11,  -3.509137288416692e-13,   3.439205306145727e-15,
  -3.365095587881873e-17,   3.268974055768387e-19,  -3.088075551677053e-21,   3.873173904768133e-03,  -3.797589165865836e-05,   3.723476666827803e-07,  -3.650805020915657e-09,
   3.579522210933511e-11,  -3.509436181997498e-13,   3.439592434623255e-15,  -3.365565729566183e-17,   3.269474416910813e-19,  -3.088396318075046e-21,   3.873176516316773e-03,
  -3.797596845404353e-05,   3.723491724608287e-07,  -3.650829624722587e-09,   3.579558381156869e-11,  -3.509485729231716e-13,   3.439656608617077e-15,  -3.365643663846389e-17,
   3.269557355723407e-19,  -3.088449466207492e-21,   3.523101128153507e-02,  -3.453701127170556e-04,   3.385348581763424e-06,  -3.318033012813958e-08,   3.251725488516834e-10,
  -3.186275344923464e-12,   3.120870103914047e-14,  -3.051677022538620e-16,   2.963111091448130e-18,  -2.800069200260885e-20,   3.523149360061564e-02,  -3.453842941793744e-04,
   3.385626606734369e-06,  -3.318487215340479e-08,   3.252393079364351e-10,  -3.187189621683938e-12,   3.122053955236999e-14,  -3.053114108573765e-16,   2.964638645321911e-18,
  -2.801040075608995e-20,   3.523228543412760e-02,  -3.454075767489875e-04,   3.386083070978956e-06,  -3.319232956455459e-08,   3.253489220638904e-10,  -3.188690865579931e-12,
   3.123997878332386e-14,  -3.055473673255483e-16,   2.967145599918014e-18,  -2.802628371212594e-20,   3.523312566967055e-02,  -3.454322832633373e-04,   3.386567470904508e-06,
  -3.320024373406809e-08,   3.254652559807839e-10,  -3.190284223598927e-12,   3.126061128254850e-14,  -3.057977835607508e-16,   2.969804617550296e-18,  -2.804306108987696e-20,
   3.523378696768893e-02,  -3.454517288019387e-04,   3.386948736802328e-06,  -3.320647315390478e-08,   3.255568293840671e-10,  -3.191538510464746e-12,   3.127685349135723e-14,
  -3.059948972523832e-16,   2.971896510396895e-18,  -2.805621004004867e-20,   3.523416862702369e-02,  -3.454629517565237e-04,   3.387168789087990e-06,  -3.321006864547668e-08,
   3.256096854018002e-10,  -3.192262506505662e-12,   3.128622892042359e-14,  -3.061086693378071e-16,   2.973103473430000e-18,  -2.806377648654377e-20,   3.523431194603820e-02,
  -3.454671661922897e-04,   3.387251423986840e-06,  -3.321141885855164e-08,   3.256295347260777e-10,  -3.192534397385545e-12,   3.128974981473748e-14,  -3.061513945146458e-16,
   2.973556641437732e-18,  -2.806661358514055e-20,   3.523433570332914e-02,  -3.454678648008670e-04,   3.387265122066493e-06,  -3.321164267940089e-08,   3.256328251076568e-10,
  -3.192579468412875e-12,   3.129033347064194e-14,  -3.061584769627880e-16,   2.973631757425436e-18,  -2.806708365432752e-20,   1.001113618635412e-01,  -9.813931269421871e-04,
   9.619702748879068e-06,  -9.428420604479500e-08,   9.240000437242469e-10,  -9.053998547649946e-12,   8.868014979606816e-14,  -8.670707690632580e-16,   8.415874942324068e-18,
  -7.939876164064420e-20,   1.001127324066541e-01,  -9.814334245494116e-04,   9.620492775835148e-06,  -9.429711248842177e-08,   9.241897408077157e-10,  -9.056596261681178e-12,
   8.871377290138193e-14,  -8.674782252971233e-16,   8.420173940572300e-18,  -7.942466821928847e-20,   1.001149824564863e-01,  -9.814995835832393e-04,   9.621789850180232e-06,
  -9.431830317974259e-08,   9.245012112039841e-10,  -9.060861710368414e-12,   8.876898303898020e-14,  -8.681472253216661e-16,   8.427228966093594e-18,  -7.946702936012671e-20,
   1.001173700440458e-01,  -9.815697888546262e-04,   9.623166305668897e-06,  -9.434079177760549e-08,   9.248317759607736e-10,  -9.065388878157764e-12,   8.882758206839181e-14,
  -8.688572143801581e-16,   8.434711512477040e-18,  -7.951174794957656e-20,   1.001192491682213e-01,  -9.816250446991037e-04,   9.624249698768213e-06,  -9.435849305570525e-08,
   9.250919832816943e-10,  -9.068952649798874e-12,   8.887371197767620e-14,  -8.694160721409523e-16,   8.440597855241046e-18,  -7.954677483996982e-20,   1.001203336796863e-01,
  -9.816569355017061e-04,   9.624874992372514e-06,  -9.436870986516929e-08,   9.252421745091312e-10,  -9.071009719587395e-12,   8.890033932577046e-14,  -8.697386369283454e-16,
   8.443993988270223e-18,  -7.956692250247400e-20,   1.001207409306042e-01,  -9.816689111127690e-04,   9.625109805083280e-06,  -9.437254657827874e-08,   9.252985766824951e-10,
  -9.071782235430506e-12,   8.891033908114024e-14,  -8.698597702048722e-16,   8.445269082284675e-18,  -7.957447546087322e-20,   1.001208084385938e-01,  -9.816708962574173e-04,
   9.625148729112471e-06,  -9.437318257892259e-08,   9.253079263544359e-10,  -9.071910294454239e-12,   8.891199673233102e-14,  -8.698798501478932e-16,   8.445480437454366e-18,
  -7.957572680199194e-20,   2.037906387026084e-01,  -1.997762575526363e-03,   1.958224643434174e-05,  -1.919286392761271e-07,   1.880929858351838e-09,  -1.843059113498863e-11,
   1.805152664602608e-13,  -1.764738168117556e-15,   1.711713018329040e-17,  -1.610181933584170e-19,   2.037934286342379e-01,  -1.997844606920615e-03,   1.958385464338427e-05,
  -1.919549120120776e-07,   1.881316000650823e-09,  -1.843587817891390e-11,   1.805836497908268e-13,  -1.765564314671636e-15,   1.712572886934243e-17,  -1.610647417344587e-19,
   2.037980089244424e-01,  -1.997979282851999e-03,   1.958649501744791e-05,  -1.919980484051093e-07,   1.881950021348987e-09,  -1.844455950273087e-11,   1.806959368279828e-13,
  -1.766920737444808e-15,   1.713983892296421e-17,  -1.611407744142103e-19,   2.038028691918706e-01,  -1.998122195463647e-03,   1.958929698278777e-05,  -1.920438268534345e-07,
   1.882622909883676e-09,  -1.845377348522607e-11,   1.808151156576791e-13,  -1.768360236426877e-15,   1.715480247932834e-17,  -1.612209277531382e-19,   2.038066944111748e-01,
  -1.998234676433867e-03,   1.959150237913225e-05,  -1.920798600924883e-07,   1.883152580663662e-09,  -1.846102669522526e-11,   1.809089343462381e-13,  -1.769493295297947e-15,
   1.716657283806622e-17,  -1.612836290074692e-19,   2.038089020854975e-01,  -1.998299594605887e-03,   1.959277525065657e-05,  -1.921006577280460e-07,   1.883458305709021e-09,
  -1.846521336903794e-11,   1.809630886934695e-13,  -1.770147271908675e-15,   1.717336331221336e-17,  -1.613196625289549e-19,   2.038097311015321e-01,  -1.998323972630756e-03,
   1.959325324437130e-05,  -1.921084678531648e-07,   1.883573116382428e-09,  -1.846678563984879e-11,   1.809834260314400e-13,  -1.770392859113468e-15,   1.717591274235407e-17,
  -1.613331645916091e-19,   2.038098685234590e-01,  -1.998328013669276e-03,   1.959333247961047e-05,  -1.921097625146231e-07,   1.883592148310577e-09,  -1.846704627326589e-11,
   1.809867973334834e-13,  -1.770433569365956e-15,   1.717633532257497e-17,  -1.613354012270702e-19,   3.578486821694764e-01,  -3.507995800166075e-03,   3.438568657050928e-05,
  -3.370194244104178e-07,   3.302838613628948e-09,  -3.236316068213215e-11,   3.169608844286527e-13,  -3.097865748584611e-15,   3.001155024914121e-17,  -2.808255435546742e-19,
   3.578535811842430e-01,  -3.508139844187382e-03,   3.438851052191402e-05,  -3.370655579452045e-07,   3.303516626120306e-09,  -3.237244153252097e-11,   3.170807716267165e-13,
  -3.099306077914508e-15,   3.002616511930023e-17,  -2.808874676256347e-19,   3.578616240011741e-01,  -3.508376330021818e-03,   3.439314691420498e-05,  -3.371413031668490e-07,
   3.304629878520436e-09,  -3.238768066310615e-11,   3.172776278812852e-13,  -3.101670834878938e-15,   3.005014374736868e-17,  -2.809883188281824e-19,   3.578701584475548e-01,
  -3.508627279154644e-03,   3.439806705434456e-05,  -3.372216876934763e-07,   3.305811377054756e-09,  -3.240385478915520e-11,   3.174865646642597e-13,  -3.104180326578000e-15,
   3.007556775900172e-17,  -2.810942299864626e-19,   3.578768753884488e-01,  -3.508824791477683e-03,   3.440193964293675e-05,  -3.372849601465822e-07,   3.306741404874757e-09,
  -3.241658697471585e-11,   3.176510403221075e-13,  -3.106155526939051e-15,   3.009556265360111e-17,  -2.811767842172005e-19,   3.578807519813339e-01,  -3.508938785328663e-03,
   3.440417475488635e-05,  -3.373214796882898e-07,   3.307278215186146e-09,  -3.242393619599440e-11,   3.177459789944781e-13,  -3.107295540329837e-15,   3.010709649236801e-17,
  -2.812241071286410e-19,   3.578822077022382e-01,  -3.508981592216888e-03,   3.440501409290349e-05,  -3.373351938523068e-07,   3.307479806608242e-09,  -3.242669613378168e-11,
   3.177816325382028e-13,  -3.107723643018723e-15,   3.011142650160822e-17,  -2.812418166430750e-19,   3.578824490099612e-01,  -3.508988688127453e-03,   3.440515322684278e-05,
  -3.373374672089073e-07,   3.307513224000670e-09,  -3.242715364522048e-11,   3.177875427884211e-13,  -3.107794608027112e-15,   3.011214420654115e-17,  -2.812447490438305e-19,
   5.933898493963390e-01,  -5.817009260615100e-03,   5.701884090801007e-05,  -5.588503626780725e-07,   5.476803596908644e-09,  -5.366418149250247e-11,   5.255313040606060e-13,
  -5.133689653668068e-15,   4.960843126676498e-17,  -4.589590171661201e-19,   5.933979730131907e-01,  -5.817248116438053e-03,   5.702352361479416e-05,  -5.589268606337953e-07,
   5.477927755688729e-09,  -5.367956087751068e-11,   5.257294405227856e-13,  -5.136041713160414e-15,   4.963094189221382e-17,  -4.589899296355331e-19,   5.934113097280740e-01,
  -5.817640260575843e-03,   5.703121173059045e-05,  -5.590524602470311e-07,   5.479773550263996e-09,  -5.370481370874062e-11,   5.260547782273857e-13,  -5.139903100137184e-15,
   4.966786098452800e-17,  -4.590388365632881e-19,   5.934254616699904e-01,  -5.818056387957924e-03,   5.703937036002351e-05,  -5.591857526732638e-07,   5.481732496914046e-09,
  -5.373161582115228e-11,   5.264000744661168e-13,  -5.144000463206890e-15,   4.970698624658861e-17,  -4.590882223508012e-19,   5.934365997981287e-01,  -5.818383905669910e-03,
   5.704579192810369e-05,  -5.592906701033320e-07,   5.483274499424914e-09,  -5.375271422525004e-11,   5.266718879379499e-13,  -5.147225202838630e-15,   4.973774260360467e-17,
  -4.591252682255391e-19,   5.934430280202870e-01,  -5.818572931876709e-03,   5.704949821476001e-05,  -5.593512262539202e-07,   5.484164539978759e-09,  -5.376489253142055e-11,
   5.268287822539037e-13,  -5.149086299584738e-15,   4.975547845222255e-17,  -4.591459165420303e-19,   5.934454419176579e-01,  -5.818643914860728e-03,   5.705089001407448e-05,
  -5.593739668720558e-07,   5.484498781882304e-09,  -5.376946598538155e-11,   5.268877024375246e-13,  -5.149785166691605e-15,   4.976213574172267e-17,  -4.591535317186059e-19,
   5.934458420575999e-01,  -5.818655681399410e-03,   5.705112072746658e-05,  -5.593777365173436e-07,   5.484554188466249e-09,  -5.377022412082743e-11,   5.268974695549221e-13,
  -5.149901014272407e-15,   4.976323914028642e-17,  -4.591547867333710e-19,   3.726640256912378e-03,  -3.515397177708892e-05,   3.315838607754649e-07,  -3.127334459475528e-09,
   2.949283286915085e-11,  -2.781085908606341e-13,   2.622011799626994e-15,  -2.470606637595549e-17,   2.322438151454671e-19,  -2.162553397048895e-21,   3.726687494437061e-03,
  -3.515530830564380e-05,   3.316090748356305e-07,  -3.127730853467792e-09,   2.949844086943268e-11,  -2.781826014346675e-13,   2.622939788989131e-15,  -2.471717746917456e-17,
   2.323685685836619e-19,  -2.163753368229001e-21,   3.726765045079749e-03,  -3.515750255610239e-05,   3.316504712618009e-07,  -3.128381674578549e-09,   2.950764874292572e-11,
  -2.783041257946752e-13,   2.624463593197995e-15,  -2.473542256320221e-17,   2.325733969153098e-19,  -2.165722307338207e-21,   3.726847335840850e-03,  -3.515983099198109e-05,
   3.316944007803371e-07,  -3.129072349683535e-09,   2.951742095685966e-11,  -2.784331051906440e-13,   2.626080955852836e-15,  -2.475478804539211e-17,   2.327907699470706e-19,
  -2.167810128339700e-21,   3.726912101662281e-03,  -3.516166360385479e-05,   3.317289769535385e-07,  -3.129615989645544e-09,   2.952511315159711e-11,  -2.785346363023740e-13,
   2.627354182567213e-15,  -2.477003314396229e-17,   2.329618684166440e-19,  -2.169452253844912e-21,   3.726949480310535e-03,  -3.516272128834966e-05,   3.317489329067515e-07,
  -3.129929764975596e-09,   2.952955303328462e-11,  -2.785932413735578e-13,   2.628089128434986e-15,  -2.477883313655781e-17,   2.330606225735592e-19,  -2.170399553966006e-21,
   3.726963516558623e-03,  -3.516311846853350e-05,   3.317564268241186e-07,  -3.130047596417562e-09,   2.953122035993865e-11,  -2.786152499527664e-13,   2.628365134725883e-15,
  -2.478213795162939e-17,   2.330977076053052e-19,  -2.170755198299688e-21,   3.726965843277889e-03,  -3.516318430731623e-05,   3.317576690618256e-07,  -3.130067128965621e-09,
   2.953149674883860e-11,  -2.786188982843475e-13,   2.628410888133634e-15,  -2.478268578945755e-17,   2.331038550783607e-19,  -2.170814147409956e-21,   3.390129350020667e-02,
  -3.197961253942742e-04,   3.016422569997958e-06,  -2.844940098705636e-08,   2.682966630872458e-10,  -2.529956562925364e-12,   2.385242198514992e-14,  -2.247484764964320e-16,
   2.112583909349877e-18,  -1.966679512545156e-20,   3.390172322056539e-02,  -3.198082838113760e-04,   3.016651942612505e-06,  -2.845300698699248e-08,   2.683476790175326e-10,
  -2.530629828801492e-12,   2.386086332239496e-14,  -2.248495219135845e-16,   2.113717269271884e-18,  -1.967764837330506e-20,   3.390242869974150e-02,  -3.198282449354413e-04,
   3.017028526408984e-06,  -2.845892751284769e-08,   2.684314429625291e-10,  -2.531735322182000e-12,   2.387472440941896e-14,  -2.250154444398150e-16,   2.115578083016737e-18,
  -1.969545613690706e-20,   3.390317729983468e-02,  -3.198494267459633e-04,   3.017428153777671e-06,  -2.846521059085577e-08,   2.685203407063725e-10,  -2.532908633090190e-12,
   2.388943653294056e-14,  -2.251915555724934e-16,   2.117552847894370e-18,  -1.971433844906121e-20,   3.390376647533033e-02,  -3.198660980392651e-04,   3.017742693649105e-06,
  -2.847015608875842e-08,   2.685903165330637e-10,  -2.533832250008547e-12,   2.390101826563454e-14,  -2.253301954097085e-16,   2.119107212700691e-18,  -1.972918939878988e-20,
   3.390410650936564e-02,  -3.198757198084392e-04,   3.017924233200066e-06,  -2.847301050591510e-08,   2.686307060966845e-10,  -2.534365373615486e-12,   2.390770359853888e-14,
  -2.254102229793584e-16,   2.120004352647383e-18,  -1.973775633820722e-20,   3.390423419729179e-02,  -3.198793329615751e-04,   3.017992405458196e-06,  -2.847408241966072e-08,
   2.686458737521329e-10,  -2.534565583129686e-12,   2.391021425107231e-14,  -2.254402771149259e-16,   2.120341253760427e-18,  -1.974097258276140e-20,   3.390425536348634e-02,
  -3.198799318978109e-04,   3.018003706109840e-06,  -2.847426010743571e-08,   2.686483880594452e-10,  -2.534598771582272e-12,   2.391063044051525e-14,  -2.254452591756671e-16,
   2.120397100792790e-18,  -1.974150568297110e-20,   9.633287657084050e-02,  -9.087228684786622e-04,   8.571373919946911e-06,  -8.084094526929809e-08,   7.623835120758353e-10,
  -7.189042061655000e-12,   6.777798567290279e-14,  -6.386202305073679e-16,   6.002176068113406e-18,  -5.584727348541599e-20,   9.633409765104056e-02,  -9.087574174637595e-04,
   8.572025698080596e-06,  -8.085119196063957e-08,   7.625284766405571e-10,  -7.190955135842632e-12,   6.780196862219580e-14,  -6.389071563872927e-16,   6.005387067161182e-18,
  -5.587771976097665e-20,   9.633610231904390e-02,  -9.088141383816272e-04,   8.573095786959440e-06,  -8.086801553298551e-08,   7.627664964800625e-10,  -7.194096377126922e-12,
   6.784134976701703e-14,  -6.393783041818456e-16,   6.010658999084372e-18,  -5.592767225639372e-20,   9.633822951812347e-02,  -9.088743279646842e-04,   8.574231355740349e-06,
  -8.088586932157333e-08,   7.630191042826340e-10,  -7.197430320224426e-12,   6.788314878087682e-14,  -6.398783812794633e-16,   6.016253679711018e-18,  -5.598063478506267e-20,
   9.633990370115317e-02,  -9.089217006003597e-04,   8.575125142518122e-06,  -8.089992228630404e-08,   7.632179444168679e-10,  -7.200054761654043e-12,   6.791605393019365e-14,
  -6.402720552198543e-16,   6.020657265053771e-18,  -5.602228680841997e-20,   9.634086993144558e-02,  -9.089490415245080e-04,   8.575640999695446e-06,  -8.090803330450747e-08,
   7.633327135660908e-10,  -7.201569622953765e-12,   6.793504778558206e-14,  -6.404992964817024e-16,   6.023198876588344e-18,  -5.604631303117404e-20,   9.634123276554279e-02,
  -9.089593085496296e-04,   8.575834715877171e-06,  -8.091107921945730e-08,   7.633758132863740e-10,  -7.202138514715318e-12,   6.794218085712177e-14,  -6.405846362126516e-16,
   6.024153317754987e-18,  -5.605533284830580e-20,   9.634129291075247e-02,  -9.089610104684657e-04,   8.575866827459617e-06,  -8.091158413121181e-08,   7.633829578277237e-10,
  -7.202232819109358e-12,   6.794336330223026e-14,  -6.405987829364923e-16,   6.024311532187319e-18,  -5.605682789230789e-20,   1.960990049389043e-01,  -1.849832130101941e-03,
   1.744822696953250e-05,  -1.645630160080481e-07,   1.551937737715464e-09,  -1.463427993846108e-11,   1.379703743007082e-13,  -1.299935237655762e-15,   1.221509906984435e-17,
  -1.135498713256134e-19,   1.961014906179418e-01,  -1.849902459378287e-03,   1.744955375461498e-05,  -1.645838745502430e-07,   1.552232830651233e-09,  -1.463817406085413e-11,
   1.380191815943169e-13,  -1.300518584575814e-15,   1.222160087502295e-17,  -1.136104099747653e-19,   1.961055713992309e-01,  -1.850017922715222e-03,   1.745173206942322e-05,
  -1.646181212333697e-07,   1.552717348853340e-09,  -1.464456815428038e-11,   1.380993253986311e-13,  -1.301476466613214e-15,   1.223227552592481e-17,  -1.137097228856219e-19,
   1.961099016096138e-01,  -1.850140447003775e-03,   1.745404367768091e-05,  -1.646544650623097e-07,   1.553231562592867e-09,  -1.465135449609046e-11,   1.381843896304780e-13,
  -1.302493157317628e-15,   1.224360334980867e-17,  -1.138150045833672e-19,   1.961133096426500e-01,  -1.850236880608856e-03,   1.745586310502779e-05,  -1.646830717941529e-07,
   1.553636325719242e-09,  -1.465669662431787e-11,   1.382513540638340e-13,  -1.303293518112095e-15,   1.225251926418905e-17,  -1.138977913252234e-19,   1.961152765391594e-01,
  -1.850292536872099e-03,   1.745691320408750e-05,  -1.646995828810286e-07,   1.553869952186170e-09,  -1.465978016873004e-11,   1.382900079381711e-13,  -1.303755510073265e-15,
   1.225766515405420e-17,  -1.139455408129947e-19,   1.961160151385646e-01,  -1.850313436833263e-03,   1.745730754032853e-05,  -1.647057832574748e-07,   1.553957686871563e-09,
  -1.466093816440757e-11,   1.383045242492617e-13,  -1.303929009295267e-15,   1.225959755109999e-17,  -1.139634658486208e-19,   1.961161375725267e-01,  -1.850316901326352e-03,
   1.745737290792251e-05,  -1.647068110744031e-07,   1.553972230448180e-09,  -1.466113012373019e-11,   1.383069306093023e-13,  -1.303957770152815e-15,   1.225991787695178e-17,
  -1.139664368961798e-19,   3.443424631249922e-01,  -3.248235513467337e-03,   3.063842901073696e-05,  -2.889664481379701e-07,   2.725143507028853e-09,  -2.569718997493668e-11,
   2.422672030819457e-13,  -2.282436372964935e-15,   2.143945467437647e-17,  -1.989689893576349e-19,   3.443468278837063e-01,  -3.248359009023212e-03,   3.064075879471873e-05,
  -2.890030748696035e-07,   2.725661670978668e-09,  -2.570402727005534e-11,   2.423528655359226e-13,  -2.283458432036383e-15,   2.145076300108515e-17,  -1.990707469026567e-19,
   3.443539935818610e-01,  -3.248561758286631e-03,   3.064458383240400e-05,  -2.890632106186329e-07,   2.726512453279334e-09,  -2.571525400632665e-11,   2.424935268946430e-13,
  -2.285136683072011e-15,   2.146932821073923e-17,  -1.992376413252604e-19,   3.443615972681041e-01,  -3.248776906314658e-03,   3.064864292829351e-05,  -2.891270288674616e-07,
   2.727415378917444e-09,  -2.572716944498438e-11,   2.426428237442434e-13,  -2.286917947367488e-15,   2.148902834858182e-17,  -1.994145149820882e-19,   3.443675816456799e-01,
  -3.248946240086847e-03,   3.065183777328021e-05,  -2.891772610956173e-07,   2.728126116387198e-09,  -2.573654913300902e-11,   2.427603532079707e-13,  -2.288320180902905e-15,
   2.150453318084901e-17,  -1.995535597675678e-19,   3.443710354418254e-01,  -3.249043970385243e-03,   3.065368170715233e-05,  -2.892062538753635e-07,   2.728536349096214e-09,
  -2.574196320642361e-11,   2.428281946107011e-13,  -2.289129585196136e-15,   2.151348160650401e-17,  -1.996337426149254e-19,   3.443723323945460e-01,  -3.249080669928508e-03,
   3.065437414654146e-05,  -2.892171414776870e-07,   2.728690405428228e-09,  -2.574399640966676e-11,   2.428536721610456e-13,  -2.289433552501590e-15,   2.151684188236401e-17,
  -1.996638402122497e-19,   3.443725473839693e-01,  -3.249086753447660e-03,   3.065448892954166e-05,  -2.892189462813239e-07,   2.728715942991120e-09,  -2.574433345090346e-11,
   2.428578955578372e-13,  -2.289483940907353e-15,   2.151739889896995e-17,  -1.996688286936084e-19,   5.709936420578661e-01,  -5.386271007617254e-03,   5.080508500960530e-05,
  -4.791683127910598e-07,   4.518870075441045e-09,  -4.261127300970415e-11,   4.017190955352108e-13,  -3.784095029886838e-15,   3.551800111498557e-17,  -3.284923000603409e-19,
   5.710008797637326e-01,  -5.386475789719990e-03,   5.080894828898018e-05,  -4.792290474941796e-07,   4.519729275350713e-09,  -4.262260857143123e-11,   4.018610020214123e-13,
  -3.785782007275274e-15,   3.553637503616199e-17,  -3.286449975690821e-19,   5.710127620277861e-01,  -5.386811991457667e-03,   5.081529101829492e-05,  -4.793287650125244e-07,
   4.521140010245351e-09,  -4.264122137768563e-11,   4.020940173999637e-13,  -3.788552016323865e-15,   3.556653721693485e-17,  -3.288952970083669e-19,   5.710253705700058e-01,
  -5.387168753004596e-03,   5.082202186607205e-05,  -4.794345888747116e-07,   4.522637206950176e-09,  -4.266097596117851e-11,   4.023413366406985e-13,  -3.791491973929949e-15,
   3.559853942580969e-17,  -3.291603682820136e-19,   5.710352939512330e-01,  -5.387449544695083e-03,   5.082731960128065e-05,  -4.795178843011468e-07,   4.523815724384727e-09,
  -4.267652651211937e-11,   4.025360302493361e-13,  -3.793806288504065e-15,   3.562372370870258e-17,  -3.293686059740515e-19,   5.710410210858261e-01,  -5.387611602477993e-03,
   5.083037723738373e-05,  -4.795659603271789e-07,   4.524495956340848e-09,  -4.268550247834658e-11,   4.026484126082297e-13,  -3.795142145963803e-15,   3.563825738889085e-17,
  -3.294886333351354e-19,   5.710431717115372e-01,  -5.387672458187147e-03,   5.083152544974919e-05,  -4.795840142237870e-07,   4.524751406555247e-09,  -4.268887331496543e-11,
   4.026906172461286e-13,  -3.795643815520777e-15,   3.564371480388845e-17,  -3.295336762687947e-19,   5.710435282101004e-01,  -5.387682545965881e-03,   5.083171578447336e-05,
  -4.795870069615079e-07,   4.524793751947348e-09,  -4.268943209373647e-11,   4.026976134770622e-13,  -3.795726976635035e-15,   3.564461944183823e-17,  -3.295411412731870e-19,
   3.591102828703514e-03,  -3.264379251516427e-05,   2.967140747330294e-07,  -2.696748368748061e-09,   2.450796394664435e-11,  -2.227086408213846e-13,   2.023579438514465e-15,
  -1.838245825700512e-17,   1.668529582295619e-19,  -1.509461433632072e-21,   3.591145095427452e-03,  -3.264494493790143e-05,   2.967350252355980e-07,  -2.697065764484933e-09,
   2.451229142146684e-11,  -2.227636999716075e-13,   2.024246080476458e-15,  -1.839021559908293e-17,   1.669396021666203e-19,  -1.510365394703577e-21,   3.591214485256281e-03,
  -3.264683692444079e-05,   2.967694215504792e-07,  -2.697586877654967e-09,   2.451939670146713e-11,  -2.228541052520775e-13,   2.025340730924264e-15,  -1.840295388008868e-17,
   1.670818783678895e-19,  -1.511849510180462e-21,   3.591288116165120e-03,  -3.264884460174129e-05,   2.968059223340583e-07,  -2.698139896076775e-09,   2.452693735242022e-11,
  -2.229500550443872e-13,   2.026502579184177e-15,  -1.841647473198901e-17,   1.672328935270047e-19,  -1.513424429056812e-21,   3.591346066204285e-03,  -3.265042475088880e-05,
   2.968346512747468e-07,  -2.698575180291584e-09,   2.453287289795735e-11,  -2.230255845480228e-13,   2.027417205746790e-15,  -1.842711900890755e-17,   1.673517787894890e-19,
  -1.514664011471366e-21,   3.591379511157721e-03,  -3.265133672457042e-05,   2.968512323634123e-07,  -2.698826413698004e-09,   2.453629882371565e-11,  -2.230691807217447e-13,
   2.027945153195765e-15,  -1.843326335029234e-17,   1.674204040380128e-19,  -1.515379443628269e-21,   3.591392070231477e-03,  -3.265167918707333e-05,   2.968574589265453e-07,
  -2.698920758569641e-09,   2.453758536971848e-11,  -2.230855527699128e-13,   2.028143421346157e-15,  -1.843557086127750e-17,   1.674461761917018e-19,  -1.515648103959440e-21,
   3.591394152086222e-03,  -3.265173595552112e-05,   2.968584910790329e-07,  -2.698936397805668e-09,   2.453779863718621e-11,  -2.230882667372636e-13,   2.028176288113092e-15,
  -1.843595337742527e-17,   1.674504484369866e-19,  -1.515692638699117e-21,   3.266830780339319e-02,  -2.969609929375975e-04,   2.699211686436356e-06,  -2.453235396132853e-08,
   2.229492556118515e-10,  -2.025983155326227e-12,   1.840851684483146e-14,  -1.672248411010720e-16,   1.517833376182801e-18,  -1.373029172418226e-20,   3.266869230431484e-02,
  -2.969714765417878e-04,   2.699402273421025e-06,  -2.453524131410700e-08,   2.229886226802564e-10,  -2.026484027163585e-12,   1.841458116821499e-14,  -1.672954027051955e-16,
   1.518621239399829e-18,  -1.373850082884725e-20,   3.266932354446433e-02,  -2.969886879672243e-04,   2.699715177128949e-06,  -2.453998188678635e-08,   2.230532594613914e-10,
  -2.027306441929063e-12,   1.842453900774430e-14,  -1.674112714062261e-16,   1.519914970784203e-18,  -1.375197836498547e-20,   3.266999336577226e-02,  -2.970069518329754e-04,
   2.700047225214995e-06,  -2.454501270191621e-08,   2.231218568148206e-10,  -2.028179294971487e-12,   1.843510813248255e-14,  -1.675342583830049e-16,   1.521288163140717e-18,
  -1.376628036651620e-20,   3.267052053801066e-02,  -2.970213264697208e-04,   2.700308572748767e-06,  -2.454897248756927e-08,   2.231758525130822e-10,  -2.028866385105221e-12,
   1.844342832495688e-14,  -1.676310797055390e-16,   1.522369193555829e-18,  -1.377753704293545e-20,   3.267082478717460e-02,  -2.970296227058168e-04,   2.700459411120318e-06,
  -2.455125796083965e-08,   2.232070181830103e-10,  -2.029262978475289e-12,   1.844823096707277e-14,  -1.676869691802179e-16,   1.522993205880821e-18,  -1.378403385864292e-20,
   3.267093903722722e-02,  -2.970327380915295e-04,   2.700516054243232e-06,  -2.455211621725292e-08,   2.232187219007352e-10,  -2.029411914612450e-12,   1.845003457637859e-14,
  -1.677079585011805e-16,   1.523227553000404e-18,  -1.378647354660320e-20,   3.267095797588614e-02,  -2.970332545148158e-04,   2.700525443747356e-06,  -2.455225848756804e-08,
   2.232206619963367e-10,  -2.029436603509556e-12,   1.845033355937630e-14,  -1.677114379011868e-16,   1.523266400670896e-18,  -1.378687796343647e-20,   9.282926220455208e-02,
  -8.438352559821032e-04,   7.669997199216557e-06,  -6.971038499961034e-08,   6.335257589341774e-10,  -5.756970626376277e-12,   5.230900996490971e-14,  -4.751771782647650e-16,
   4.312842009957690e-18,  -3.900750615983483e-20,   9.283035479058632e-02,  -8.438650458703997e-04,   7.670538765339226e-06,  -6.971858961122635e-08,   6.336376230361114e-10,
  -5.758393876363237e-12,   5.232624137210424e-14,  -4.753776402103445e-16,   4.315078673745758e-18,  -3.903074401552636e-20,   9.283214850324802e-02,  -8.439139533293100e-04,
   7.671427902906230e-06,  -6.973206027470943e-08,   6.338212926797796e-10,  -5.760730805035726e-12,   5.235453596349522e-14,  -4.757068170096963e-16,   4.318751431158361e-18,
  -3.906889480612039e-20,   9.283405184694703e-02,  -8.439658513703556e-04,   7.672371440550040e-06,  -6.974635568207121e-08,   6.340162165471760e-10,  -5.763211056222537e-12,
   5.238456747640304e-14,  -4.760562160212361e-16,   4.322649749120028e-18,  -3.910937854204817e-20,   9.283554984342217e-02,  -8.440066978974811e-04,   7.673114077675692e-06,
  -6.975760768546485e-08,   6.341696488549838e-10,  -5.765163453655968e-12,   5.240820878186735e-14,  -4.763312795841598e-16,   4.325718641935500e-18,  -3.914124144842118e-20,
   9.283641438852137e-02,  -8.440302722276527e-04,   7.673542695359813e-06,  -6.976410201501394e-08,   6.342582081437708e-10,  -5.766290391468868e-12,   5.242185518611432e-14,
  -4.764900581000592e-16,   4.327490118988813e-18,  -3.915963094302786e-20,   9.283673903796920e-02,  -8.440391248121925e-04,   7.673703650718282e-06,  -6.976654080966337e-08,
   6.342914650228124e-10,  -5.766713600162156e-12,   5.242698002760350e-14,  -4.765496874296469e-16,   4.328155394068433e-18,  -3.916653652882113e-20,   9.283679285348193e-02,
  -8.440405922647721e-04,   7.673730331644835e-06,  -6.976694508055244e-08,   6.342969779312922e-10,  -5.766783754766856e-12,   5.242782956881196e-14,  -4.765595721831278e-16,
   4.328265676513268e-18,  -3.916768123627204e-20,   1.889669092789470e-01,  -1.717744345642577e-03,   1.561334896115374e-05,  -1.419052101002683e-07,   1.289629989479461e-09,
  -1.171911297200588e-11,   1.064820444988124e-13,  -9.672757905215518e-16,   8.778720639790759e-18,  -7.937615217815930e-20,   1.889691333901923e-01,  -1.717804987114522e-03,
   1.561445139448228e-05,  -1.419219117259300e-07,   1.289857703912702e-09,  -1.172201015258915e-11,   1.065171185996165e-13,  -9.676837011380292e-16,   8.783266073436802e-18,
  -7.942313354610517e-20,   1.889727847424672e-01,  -1.717904545067470e-03,   1.561626135793143e-05,  -1.419493331309974e-07,   1.290231588184821e-09,  -1.172676722545930e-11,
   1.065747115155353e-13,  -9.683535264325268e-16,   8.790729937400035e-18,  -7.950026295911384e-20,   1.889766592640078e-01,  -1.718010190767401e-03,   1.561818206031896e-05,
  -1.419784334166325e-07,   1.290628381937680e-09,  -1.173181604646520e-11,   1.066358398618366e-13,  -9.690644993285366e-16,   8.798652117161748e-18,  -7.958210570831288e-20,
   1.889797086447442e-01,  -1.718093339569569e-03,   1.561969380169922e-05,  -1.420013384310755e-07,   1.290940714035351e-09,  -1.173579036342482e-11,   1.066839610897683e-13,
  -9.696242099621017e-16,   8.804888681825566e-18,  -7.964651810458332e-20,   1.889814685468635e-01,  -1.718141328406163e-03,   1.562056631273714e-05,  -1.420145585401277e-07,
   1.291120988376304e-09,  -1.173808436756905e-11,   1.067117379623698e-13,  -9.699472985514307e-16,   8.808488633306986e-18,  -7.968369242423255e-20,   1.889821294160903e-01,
  -1.718159349076520e-03,   1.562089395980366e-05,  -1.420195230450787e-07,   1.291188687225343e-09,  -1.173894585473976e-11,   1.067221694317008e-13,  -9.700686345028854e-16,
   8.809840584661398e-18,  -7.969765187394520e-20,   1.889822389650716e-01,  -1.718162336280888e-03,   1.562094827254851e-05,  -1.420203459945756e-07,   1.291199909491807e-09,
  -1.173908866204101e-11,   1.067238986486236e-13,  -9.700887483580225e-16,   8.810064697005827e-18,  -7.969996585896701e-20,   3.318187719035296e-01,  -3.016294341591966e-03,
   2.741645241213907e-05,  -2.491802002194534e-07,   2.264541529249250e-09,  -2.057830984778491e-11,   1.869777274778959e-13,  -1.698458262902630e-15,   1.541304580679471e-17,
  -1.392919271375485e-19,   3.318226773590641e-01,  -3.016400825730934e-03,   2.741838824339611e-05,  -2.492095276280860e-07,   2.264941385550648e-09,  -2.058339705564182e-11,
   1.870393075881451e-13,  -1.699174052287113e-15,   1.542100381106358e-17,  -1.393734174330308e-19,   3.318290889960631e-01,  -3.016575645743653e-03,   2.742156647080192e-05,
  -2.492576785545711e-07,   2.265597909500622e-09,  -2.059175007845377e-11,   1.871404242446978e-13,  -1.700349438158590e-15,   1.543407114221205e-17,  -1.395071927851749e-19,
   3.318358925098828e-01,  -3.016761155610600e-03,   2.742493915159651e-05,  -2.493087775301991e-07,   2.266294661449314e-09,  -2.060061538523374e-11,   1.872477480142325e-13,
  -1.701597023516205e-15,   1.544794063570999e-17,  -1.396491329317152e-19,   3.318412471075448e-01,  -3.016907161773052e-03,   2.742759371231905e-05,  -2.493489978491860e-07,
   2.266843102524573e-09,  -2.060759395189446e-11,   1.873322349651804e-13,  -1.702579176670122e-15,   1.545885892578842e-17,  -1.397608361918914e-19,   3.318443374293470e-01,
  -3.016991428361249e-03,   2.742912580872180e-05,  -2.493722118490377e-07,   2.267159656130433e-09,  -2.061162203002132e-11,   1.873810030892380e-13,  -1.703146115479472e-15,
   1.546516125630441e-17,  -1.398253005214421e-19,   3.318454978908054e-01,  -3.017023071979136e-03,   2.742970114458590e-05,  -2.493809293275852e-07,   2.267278532252691e-09,
  -2.061313472888018e-11,   1.873993177159460e-13,  -1.703359029135502e-15,   1.546752806544810e-17,  -1.398495071708585e-19,   3.318456902546884e-01,  -3.017028317397408e-03,
   2.742979651571289e-05,  -2.493823743950498e-07,   2.267298238045855e-09,  -2.061338548646017e-11,   1.874023537177503e-13,  -1.703394323808322e-15,   1.546792040961673e-17,
  -1.398535197510174e-19,   5.502266765285971e-01,  -5.001662809594869e-03,   4.546235704480076e-05,  -4.131941999914586e-07,   3.755095009622968e-09,  -3.412321489441632e-11,
   3.100467753379846e-13,  -2.816270706339486e-15,   2.555128019162867e-17,  -2.306742746559309e-19,   5.502331526113243e-01,  -5.001839383128906e-03,   4.546556706772575e-05,
  -4.132428310695024e-07,   3.755758051662306e-09,  -3.413165013921042e-11,   3.101488593699092e-13,  -2.817455999494047e-15,   2.556439581869867e-17,  -2.308059285086752e-19,
   5.502437844803231e-01,  -5.002129272193737e-03,   4.547083724961257e-05,  -4.133226755412692e-07,   3.756846700157805e-09,  -3.414550052168372e-11,   3.103164846328092e-13,
  -2.819402337340217e-15,   2.558593155451198e-17,  -2.310220261487833e-19,   5.502550661651210e-01,  -5.002436887328899e-03,   4.547642987686961e-05,  -4.134074085045801e-07,
   3.758002054689832e-09,  -3.416020033190802e-11,   3.104943993775034e-13,  -2.821468214451551e-15,   2.560878848526652e-17,  -2.312512765386619e-19,   5.502639452362365e-01,
  -5.002678996851876e-03,   4.548083170720729e-05,  -4.134741023423408e-07,   3.758911479991670e-09,  -3.417177168275156e-11,   3.106344564264872e-13,  -2.823094550013190e-15,
   2.562678123884478e-17,  -2.314316642268554e-19,   5.502690696524455e-01,  -5.002818728922960e-03,   4.548337225124721e-05,  -4.135125960880807e-07,   3.759436389342663e-09,
  -3.417845074707214e-11,   3.107153010056076e-13,  -2.824033332225152e-15,   2.563716690162727e-17,  -2.315357559208677e-19,   5.502709939463826e-01,  -5.002871200826218e-03,
   4.548432628135751e-05,  -4.135270515203225e-07,   3.759633509785995e-09,  -3.418095899333858e-11,   3.107456617687402e-13,  -2.824385890598520e-15,   2.564106714096609e-17,
  -2.315748408093520e-19,   5.502713129269493e-01,  -5.002879898854398e-03,   4.548448442711630e-05,  -4.135294477493112e-07,   3.759666185941558e-09,  -3.418137478114672e-11,
   3.107506946485669e-13,  -2.824444334111213e-15,   2.564171367832196e-17,  -2.315813195527643e-19,   3.465079116298863e-03,  -3.039317987304553e-05,   2.665669653763287e-07,
  -2.337780335148029e-09,   2.050067664833301e-11,  -1.797626241109440e-13,   1.576139306050610e-15,  -1.381777464747044e-17,   1.211018940360887e-19,  -1.060111458260798e-21,
   3.465117085975922e-03,  -3.039417882807151e-05,   2.665844888554809e-07,  -2.338036500028214e-09,   2.050404683983836e-11,  -1.798040049894466e-13,   1.576623082130950e-15,
  -1.382322239148127e-17,   1.211612740013401e-19,  -1.060734110342936e-21,   3.465179421153276e-03,  -3.039581885359653e-05,   2.666132585651424e-07,  -2.338457078749689e-09,
   2.050958030185840e-11,  -1.798719501788165e-13,   1.577417450062469e-15,  -1.383216805283104e-17,   1.212587838840814e-19,  -1.061756560468417e-21,   3.465245566051042e-03,
  -3.039755915505746e-05,   2.666437882814899e-07,  -2.338903403201828e-09,   2.051545274845249e-11,  -1.799440612894510e-13,   1.578260568558051e-15,  -1.384166322811984e-17,
   1.213622875424542e-19,  -1.062841820259355e-21,   3.465297624212139e-03,  -3.039892885938294e-05,   2.666678173785268e-07,  -2.339254704834623e-09,   2.052007513031218e-11,
  -1.800008247088231e-13,   1.578924275780065e-15,  -1.384913825282901e-17,   1.214437730778108e-19,  -1.063696186701970e-21,   3.465327668708018e-03,  -3.039971937377364e-05,
   2.666816858620519e-07,  -2.339457464691303e-09,   2.052274309214784e-11,  -1.800335886372469e-13,   1.579307381765430e-15,  -1.385345314657558e-17,   1.214908110421910e-19,
  -1.064189362944418e-21,   3.465338950849776e-03,  -3.040001622569322e-05,   2.666868937708503e-07,  -2.339533606212117e-09,   2.052374499408643e-11,  -1.800458926969916e-13,
   1.579451254645169e-15,  -1.385507360425520e-17,   1.215084763576388e-19,  -1.064374575300903e-21,   3.465340821033374e-03,  -3.040006543345948e-05,   2.666877570644729e-07,
  -2.339546227926745e-09,   2.052391107661437e-11,  -1.800479323173757e-13,   1.579475104308200e-15,  -1.385534222739366e-17,   1.215114047468988e-19,  -1.064405277942996e-21,
   3.152186849944204e-02,  -2.764871412981899e-04,   2.424963051856806e-06,  -2.126681724079828e-08,   1.864949140729581e-10,  -1.635302829819240e-12,   1.433815697490501e-14,
  -1.257003444543365e-16,   1.101659194813613e-18,  -9.643573076273295e-21,   3.152221391007395e-02,  -2.764962288046803e-04,   2.425122463167674e-06,  -2.126914757589957e-08,
   1.865255727426372e-10,  -1.635679271793004e-12,   1.434255786553590e-14,  -1.257499011610421e-16,   1.102199302419344e-18,  -9.649234230146097e-21,   3.152278097396989e-02,
  -2.765111481375987e-04,   2.425384181579327e-06,  -2.127297358575968e-08,   1.865759107082539e-10,  -1.636297369377904e-12,   1.434978419695467e-14,  -1.258312774985586e-16,
   1.103086231164159e-18,  -9.658530326378341e-21,   3.152338269494055e-02,  -2.765269796819728e-04,   2.425661910793996e-06,  -2.127703380485130e-08,   1.866293324202602e-10,
  -1.636953364356334e-12,   1.435745400991236e-14,  -1.259176526052745e-16,   1.104027677274739e-18,  -9.668397456606279e-21,   3.152385626868975e-02,  -2.765394398995242e-04,
   2.425880503792804e-06,  -2.128022960017321e-08,   1.866713822794288e-10,  -1.637469741340592e-12,   1.436349172597308e-14,  -1.259856509236814e-16,   1.104768850945415e-18,
  -9.676165293573072e-21,   3.152412958384834e-02,  -2.765466312189223e-04,   2.426006665562346e-06,  -2.128207410911056e-08,   1.866956527578936e-10,  -1.637767794887537e-12,
   1.436697682456838e-14,  -1.260249023639478e-16,   1.105196697231368e-18,  -9.680649206936416e-21,   3.152423221763446e-02,  -2.765493316845846e-04,   2.426054041974368e-06,
  -2.128276676947212e-08,   1.867047670709588e-10,  -1.637879724952623e-12,   1.436828562992348e-14,  -1.260396432354371e-16,   1.105357376755663e-18,  -9.682333139099291e-21,
   3.152424923071828e-02,  -2.765497793282560e-04,   2.426061895367341e-06,  -2.128288158936702e-08,   1.867062779255603e-10,  -1.637898279384812e-12,   1.436850258927420e-14,
  -1.260420868284673e-16,   1.105384012688526e-18,  -9.682612284352646e-21,   8.957157541562329e-02,  -7.856573866695557e-04,   6.890700685386036e-06,  -6.043113604102343e-08,
   5.299382294509546e-10,  -4.646826198099274e-12,   4.074285378908141e-14,  -3.571854664916908e-16,   3.130402207454481e-18,  -2.740118100089520e-20,   8.957255692388844e-02,
  -7.856832094494646e-04,   6.891153663678891e-06,  -6.043775784951528e-08,   5.300253481560204e-10,  -4.647895881595500e-12,   4.075535906098986e-14,  -3.573262760728366e-16,
   3.131936509122868e-18,  -2.741724814749325e-20,   8.957416827527516e-02,  -7.857256037686044e-04,   6.891897354692228e-06,  -6.044862972135961e-08,   5.301683869250981e-10,
  -4.649652244658941e-12,   4.077589291227477e-14,  -3.575574973411311e-16,   3.134456033871947e-18,  -2.744363163027827e-20,   8.957587810714319e-02,  -7.857705901998568e-04,
   6.892686541512442e-06,  -6.046016711494314e-08,   5.303201883699235e-10,  -4.651516295516853e-12,   4.079768692878081e-14,  -3.578029219285439e-16,   3.137130423241810e-18,
  -2.747163558985945e-20,   8.957722379979434e-02,  -7.858059967721420e-04,   6.893307688674975e-06,  -6.046924818855003e-08,   5.304396759176536e-10,  -4.652983613071766e-12,
   4.081484328899763e-14,  -3.579961309903459e-16,   3.139235890463470e-18,  -2.749368139576245e-20,   8.957800044377216e-02,  -7.858264314049279e-04,   6.893666186090706e-06,
  -6.047448948836372e-08,   5.305086421403029e-10,  -4.653830550892466e-12,   4.082474630584324e-14,  -3.581076592201131e-16,   3.140451280862236e-18,  -2.750640708189532e-20,
   8.957829208479316e-02,  -7.858341049653839e-04,   6.893800809450366e-06,  -6.047645773072358e-08,   5.305345410835235e-10,  -4.654148607181098e-12,   4.082846531716911e-14,
  -3.581495436219853e-16,   3.140907725739192e-18,  -2.751118619862042e-20,   8.957834042865070e-02,  -7.858353769759200e-04,   6.893823125411023e-06,  -6.047678399940220e-08,
   5.305388342800866e-10,  -4.654201330761903e-12,   4.082908181394068e-14,  -3.581564867954953e-16,   3.140983390843721e-18,  -2.751197843173415e-20,   1.823354334998643e-01,
  -1.599315179126550e-03,   1.402698222846030e-05,  -1.230160051109067e-07,   1.078763162892687e-09,  -9.459262057507134e-12,   8.293771247464541e-14,  -7.270980503659158e-16,
   6.372231584683755e-18,  -5.577282961213308e-20,   1.823374314968201e-01,  -1.599367744996284e-03,   1.402790432894001e-05,  -1.230294847244765e-07,   1.078940505056067e-09,
  -9.461439538601380e-12,   8.296316811308864e-14,  -7.273846547827396e-16,   6.375353245822771e-18,  -5.580546648564513e-20,   1.823407116272882e-01,  -1.599454044545179e-03,
   1.402941821570002e-05,  -1.230516159340036e-07,   1.079231680236621e-09,  -9.465014845973699e-12,   8.300496666342656e-14,  -7.278552832804590e-16,   6.380479411301487e-18,
  -5.585905822151600e-20,   1.823441922285103e-01,  -1.599545620699773e-03,   1.403102471551889e-05,  -1.230751019057216e-07,   1.079540693053322e-09,  -9.468809365879701e-12,
   8.304933039024075e-14,  -7.283548209186851e-16,   6.385920644461695e-18,  -5.591594088017284e-20,   1.823469315735732e-01,  -1.599617695715438e-03,   1.403228914718258e-05,
  -1.230935876959698e-07,   1.079783926466496e-09,  -9.471796283064479e-12,   8.308425373626775e-14,  -7.287480787370383e-16,   6.390204353745276e-18,  -5.596072062104558e-20,
   1.823485125407015e-01,  -1.599659293260275e-03,   1.403301891866207e-05,  -1.231042570918084e-07,   1.079924316741505e-09,  -9.473520335967390e-12,   8.310441223426065e-14,
  -7.289750832509133e-16,   6.392677139413794e-18,  -5.598656900697241e-20,   1.823491062166722e-01,  -1.599674913862733e-03,   1.403329296328287e-05,  -1.231082637232903e-07,
   1.079977037618723e-09,  -9.474167781210496e-12,   8.311198262216644e-14,  -7.290603347268010e-16,   6.393605803374463e-18,  -5.599627630041864e-20,   1.823492046273363e-01,
  -1.599677503217573e-03,   1.403333839053258e-05,  -1.231089278886319e-07,   1.079985777013487e-09,  -9.474275106966101e-12,   8.311323755774670e-14,  -7.290744668552563e-16,
   6.393759748434686e-18,  -5.599788547428096e-20,   3.201741503277171e-01,  -2.808337187964942e-03,   2.463085221619367e-05,  -2.160114691348614e-07,   1.894267436730284e-09,
  -1.661010555900362e-11,   1.456353516158627e-13,  -1.276748356241365e-15,   1.118897664040644e-17,  -9.791635502260932e-20,   3.201776587350810e-01,  -2.808429491651246e-03,
   2.463247138986419e-05,  -2.160351388250352e-07,   1.894578842553065e-09,  -1.661392910695449e-11,   1.456800489722512e-13,  -1.277251521486995e-15,   1.119445316739889e-17,
  -9.797344760294012e-20,   3.201834185205784e-01,  -2.808581030406900e-03,   2.463512971792680e-05,  -2.160740003895446e-07,   1.895090134647738e-09,  -1.662020716775832e-11,
   1.457534427058022e-13,  -1.278077760262731e-15,   1.120344628570580e-17,  -9.806719551402155e-20,   3.201895303251651e-01,  -2.808741834683312e-03,   2.463795067102809e-05,
  -2.161152408650385e-07,   1.895632748921882e-09,  -1.662687015450662e-11,   1.458313405927518e-13,  -1.278954751081485e-15,   1.121299209432763e-17,  -9.816669806729538e-20,
   3.201943405118691e-01,  -2.808868395694664e-03,   2.464017096534797e-05,  -2.161477012115051e-07,   1.896059857164538e-09,  -1.663211503114589e-11,   1.458926621823063e-13,
  -1.279645155743720e-15,   1.122050716824501e-17,  -9.824502790158617e-20,   3.201971166305710e-01,  -2.808941439415789e-03,   2.464145241654629e-05,  -2.161664362658714e-07,
   1.896306376927581e-09,  -1.663514238141380e-11,   1.459280583022760e-13,  -1.280043685274848e-15,   1.122484525533221e-17,  -9.829024190881051e-20,   3.201981591032042e-01,
  -2.808968868605041e-03,   2.464193362856618e-05,  -2.161734717587666e-07,   1.896398952699867e-09,  -1.663627926271189e-11,   1.459413510752494e-13,  -1.280193352860466e-15,
   1.122647443746725e-17,  -9.830722179100649e-20,   3.201983319086220e-01,  -2.808973415414559e-03,   2.464201339710360e-05,  -2.161746380079119e-07,   1.896414298730922e-09,
  -1.663646772134232e-11,   1.459435546047846e-13,  -1.280218163237786e-15,   1.122674450760638e-17,  -9.831003653247311e-20,   5.309173969714718e-01,  -4.656825256246082e-03,
   4.084323462245898e-05,  -3.581933348696348e-07,   3.141101517793195e-09,  -2.754310981846686e-11,   2.414941694094242e-13,  -2.117095123656691e-15,   1.855233730090386e-17,
  -1.623046014120395e-19,   5.309232146631966e-01,  -4.656978315550491e-03,   4.084591955952961e-05,  -3.582325842808681e-07,   3.141617894344016e-09,  -2.754944999348753e-11,
   2.415682813416702e-13,  -2.117929143556354e-15,   1.856140184152806e-17,  -1.623985405056246e-19,   5.309327656226344e-01,  -4.657229599301550e-03,   4.085032763735968e-05,
  -3.582970250704712e-07,   3.142465724494230e-09,  -2.755986022034192e-11,   2.416899742057215e-13,  -2.119298670308811e-15,   1.857628678409947e-17,  -1.625527860850088e-19,
   5.309429003052067e-01,  -4.657496247272808e-03,   4.085500538236713e-05,  -3.583654106034055e-07,   3.143365493413152e-09,  -2.757090872713951e-11,   2.418191352637636e-13,
  -2.120752317217053e-15,   1.859208633762805e-17,  -1.627164923715030e-19,   5.309508766262206e-01,  -4.657706112567873e-03,   4.085868710634306e-05,  -3.584192368035664e-07,
   3.144073728959522e-09,  -2.757960573535495e-11,   2.419208114206351e-13,  -2.121896687613712e-15,   1.860452463544973e-17,  -1.628453588288185e-19,   5.309554800263175e-01,
  -4.657827234720127e-03,   4.086081202715107e-05,  -3.584503035325124e-07,   3.144482510715764e-09,  -2.758462566060219e-11,   2.419795010327151e-13,  -2.122557263510456e-15,
   1.861170460991638e-17,  -1.629197416821752e-19,   5.309572086694830e-01,  -4.657872718197496e-03,   4.086160997984361e-05,  -3.584619698851356e-07,   3.144636020869050e-09,
  -2.758651082698974e-11,   2.420015415152584e-13,  -2.122805342293363e-15,   1.861440106213890e-17,  -1.629476753542799e-19,   5.309574952179207e-01,  -4.657880257782641e-03,
   4.086174225317966e-05,  -3.584639037757636e-07,   3.144661467824751e-09,  -2.758682332740021e-11,   2.420051951435777e-13,  -2.122846466272387e-15,   1.861484805353856e-17,
  -1.629523058747302e-19,   3.347601325023356e-03,  -2.836754193079180e-05,   2.403693391933418e-07,  -2.036600337659829e-09,   1.725448116012301e-11,  -1.461730233539485e-13,
   1.238229193413585e-15,  -1.048814916397381e-17,   8.882535961873822e-20,  -7.519239203198624e-22,   3.347635561003539e-03,  -2.836841213624977e-05,   2.403840868314521e-07,
  -2.036808617821613e-09,   1.725712851240255e-11,  -1.462044284700193e-13,   1.238583975375950e-15,  -1.049201259496932e-17,   8.886620216933913e-20,  -7.523436980185377e-22,
   3.347691766426843e-03,  -2.836984078371974e-05,   2.404082991020726e-07,  -2.037150575754298e-09,   1.726147511758615e-11,  -1.462559934046798e-13,   1.239166525141079e-15,
  -1.049835659840751e-17,   8.893327106879965e-20,  -7.530330451231557e-22,   3.347751406792558e-03,  -2.837135677660706e-05,   2.404339924161341e-07,  -2.037513463507762e-09,
   1.726608794648117e-11,  -1.463107191416076e-13,   1.239784815539457e-15,  -1.050509019184552e-17,   8.900446251203851e-20,  -7.537647866186296e-22,   3.347798345570899e-03,
  -2.837254993433720e-05,   2.404542147994484e-07,  -2.037799089907340e-09,   1.726971880644095e-11,  -1.463537968076569e-13,   1.240271529254432e-15,  -1.051039109727974e-17,
   8.906050949422962e-20,  -7.543408816613800e-22,   3.347825435457895e-03,  -2.837323855439490e-05,   2.404658861777706e-07,  -2.037963943248412e-09,   1.727181446296016e-11,
  -1.463786610679765e-13,   1.240552467732263e-15,  -1.051345096768407e-17,   8.909286289780714e-20,  -7.546734418083416e-22,   3.347835608093281e-03,  -2.837349714287522e-05,
   2.404702690183973e-07,  -2.038025849729314e-09,   1.727260144369639e-11,  -1.463879984681783e-13,   1.240657971709630e-15,  -1.051460009555600e-17,   8.910501335809223e-20,
  -7.547983374087952e-22,   3.347837294359189e-03,  -2.837354000787049e-05,   2.404709955434028e-07,  -2.038036111741888e-09,   1.727273189917446e-11,  -1.463895463087934e-13,
   1.240675460967527e-15,  -1.051479058607468e-17,   8.910702754653714e-20,  -7.548190414841632e-22,   3.045317154797220e-02,  -2.580598873453302e-04,   2.186642915508314e-06,
  -1.852697900171499e-08,   1.569642330307998e-10,  -1.329737833755368e-12,   1.126418617765080e-14,  -9.541080008148259e-17,   8.080441426728066e-19,  -6.840204817050642e-21,
   3.045348299311647e-02,  -2.580678036153754e-04,   2.186777074958454e-06,  -1.852887372896829e-08,   1.569883160269325e-10,  -1.330023526412261e-12,   1.126741362824172e-14,
  -9.544594545419389e-17,   8.084156726307671e-19,  -6.844022875663131e-21,   3.045399429456238e-02,  -2.580808000394589e-04,   2.186997334290071e-06,  -1.853198452458596e-08,
   1.570278571475511e-10,  -1.330492613141057e-12,   1.127271308190050e-14,  -9.550365642571065e-17,   8.090257741146305e-19,  -6.850292779042068e-21,   3.045453684372279e-02,
  -2.580945910459076e-04,   2.187231066692573e-06,  -1.853528571904656e-08,   1.570698201085233e-10,  -1.330990453718949e-12,   1.127833766794622e-14,  -9.556491146794823e-17,
   8.096733767300438e-19,  -6.856948270711667e-21,   3.045496384638239e-02,  -2.581054452168527e-04,   2.187415029968974e-06,  -1.853788406599837e-08,   1.571028500860529e-10,
  -1.331382331678546e-12,   1.128276530122416e-14,  -9.561313344235462e-17,   8.101832155890605e-19,  -6.862188088685788e-21,   3.045521028342665e-02,  -2.581117096022174e-04,
   2.187521204644970e-06,  -1.853938373891688e-08,   1.571219142990752e-10,  -1.331608522103499e-12,   1.128532099773926e-14,  -9.564096887332847e-17,   8.104775226002548e-19,
  -6.865212856117146e-21,   3.045530282401927e-02,  -2.581140619848899e-04,   2.187561075401502e-06,  -1.853994690295276e-08,   1.571290734724707e-10,  -1.331693464526527e-12,
   1.128628076711104e-14,  -9.565142241049989e-17,   8.105880508593260e-19,  -6.866348831147269e-21,   3.045531816400155e-02,  -2.581144519282934e-04,   2.187567684608653e-06,
  -1.854004025661031e-08,   1.571302602275524e-10,  -1.331707545248082e-12,   1.128643986683852e-14,  -9.565315528962991e-17,   8.106063731888106e-19,  -6.866537142906397e-21,
   8.653479891277530e-02,  -7.332950666139553e-04,   6.213497490349105e-06,  -5.264569569393430e-08,   4.460247533028229e-10,  -3.778542233462339e-12,   3.200796350172496e-14,
  -2.711162486938943e-16,   2.296105586071807e-18,  -1.943656628374112e-20,   8.653568390575178e-02,  -7.333175612442877e-04,   6.213878713730325e-06,  -5.265107969276489e-08,
   4.460931868003411e-10,  -3.779354048461391e-12,   3.201713449301660e-14,  -2.712161148028070e-16,   2.297161219773241e-18,  -1.944741143879919e-20,   8.653713680426961e-02,
  -7.333544914846330e-04,   6.214504595895582e-06,  -5.265991923414882e-08,   4.462055456266086e-10,  -3.780686990110212e-12,   3.203219320302004e-14,  -2.713801013877851e-16,
   2.298894709656576e-18,  -1.946522100269958e-20,   8.653867849533527e-02,  -7.333936795858736e-04,   6.215168762726083e-06,  -5.266929980704243e-08,   4.463247862795044e-10,
  -3.782101637759388e-12,   3.204817579550768e-14,  -2.715541584823916e-16,   2.300734751060468e-18,  -1.948412578295907e-20,   8.653989185300559e-02,  -7.334245224653591e-04,
   6.215691507133391e-06,  -5.267668319001895e-08,   4.464186432427018e-10,  -3.783215185463065e-12,   3.206075717595296e-14,  -2.716911819103467e-16,   2.302183361877746e-18,
  -1.949900934273073e-20,   8.654059212095751e-02,  -7.334423231508128e-04,   6.215993209838193e-06,  -5.268094461457147e-08,   4.464728155211341e-10,  -3.783857920838961e-12,
   3.206801933785146e-14,  -2.717702766785431e-16,   2.303019579377118e-18,  -1.950760109992924e-20,   8.654085508146925e-02,  -7.334490076093160e-04,   6.216106505357821e-06,
  -5.268254488421690e-08,   4.464931588069545e-10,  -3.784099290473140e-12,   3.207074657892678e-14,  -2.717999805501754e-16,   2.303333624388387e-18,  -1.951082779916234e-20,
   8.654089867109271e-02,  -7.334501156605401e-04,   6.216125285878270e-06,  -5.268281015510591e-08,   4.464965310535102e-10,  -3.784139301794786e-12,   3.207119867015160e-14,
  -2.718049045503272e-16,   2.303385683797494e-18,  -1.951136269232110e-20,   1.761536514164397e-01,  -1.492724374154506e-03,   1.264844068204900e-05,  -1.071676555895394e-07,
   9.079455866845301e-10,  -7.691749534505592e-12,   6.515666398310026e-14,  -5.518943782494072e-16,   4.674015071915664e-18,  -3.956459205600825e-20,   1.761554529430654e-01,
  -1.492770165111664e-03,   1.264921671540567e-05,  -1.071786154698012e-07,   9.080848925906445e-10,  -7.693402095381294e-12,   6.517533269597101e-14,  -5.520976628411383e-16,
   4.676163623517776e-18,  -3.958665408175108e-20,   1.761584105206210e-01,  -1.492845341766202e-03,   1.265049078583657e-05,  -1.071966095887035e-07,   9.083136146150667e-10,
  -7.696115481077852e-12,   6.520598660410464e-14,  -5.524314691849700e-16,   4.679691826299596e-18,  -3.962288351957234e-20,   1.761615488477909e-01,  -1.492925114611475e-03,
   1.265184279004262e-05,  -1.072157050526723e-07,   9.085563455548760e-10,  -7.698995190534015e-12,   6.523852119054952e-14,  -5.527857746944063e-16,   4.683436891793850e-18,
  -3.966134077260307e-20,   1.761640188065449e-01,  -1.492987899594035e-03,   1.265290690918392e-05,  -1.072307349581139e-07,   9.087474044623013e-10,  -7.701261969709550e-12,
   6.526413217919083e-14,  -5.530646955073115e-16,   4.686385269861862e-18,  -3.969161770620871e-20,   1.761654442996211e-01,  -1.493024135371771e-03,   1.265352106711402e-05,
  -1.072394096819185e-07,   9.088576796722654e-10,  -7.702570345771240e-12,   6.527891522640457e-14,  -5.532256984429656e-16,   4.688087234136354e-18,  -3.970909547486676e-20,
   1.761659795924155e-01,  -1.493037742519273e-03,   1.265375169594404e-05,  -1.072426672538913e-07,   9.088990912609854e-10,  -7.703061686784229e-12,   6.528446686978893e-14,
  -5.532861627483370e-16,   4.688726413810063e-18,  -3.971565937450165e-20,   1.761660683251731e-01,  -1.493039998112069e-03,   1.265378992631249e-05,  -1.072432072497700e-07,
   9.089059559380410e-10,  -7.703143135320048e-12,   6.528538715852680e-14,  -5.532961858943518e-16,   4.688832370955482e-18,  -3.971674747827345e-20,   3.093191739357063e-01,
  -2.621167751074887e-03,   2.221018520946282e-05,  -1.881823647949664e-07,   1.594318231219265e-09,  -1.350642191523708e-11,   1.144126179320504e-13,  -9.691040580685577e-16,
   8.207309559808910e-18,  -6.947014334192426e-20,   3.093223373485744e-01,  -2.621248158270103e-03,   2.221154789478933e-05,  -1.882016099310632e-07,   1.594562847075323e-09,
  -1.350932374452903e-11,   1.144453991290085e-13,  -9.694609975111429e-16,   8.211081304850150e-18,  -6.950883808138867e-20,   3.093275307433125e-01,  -2.621380165642571e-03,
   2.221378511444769e-05,  -1.882332069247240e-07,   1.594964474222995e-09,  -1.351408833876440e-11,   1.144992256436128e-13,  -9.700471148173333e-16,   8.217274995689781e-18,
  -6.957238080333761e-20,   3.093330415275620e-01,  -2.621520243752770e-03,   2.221615918287791e-05,  -1.882667378387472e-07,   1.595390700490802e-09,  -1.351914499065472e-11,
   1.145563545181333e-13,  -9.706692255732057e-16,   8.223849374003701e-18,  -6.963983042212089e-20,   3.093373786820591e-01,  -2.621630491816203e-03,   2.221802773598449e-05,
  -1.882931297854345e-07,   1.595726192640977e-09,  -1.352312536202620e-11,   1.146013259477088e-13,  -9.711589712197057e-16,   8.229025177623265e-18,  -6.969293236107624e-20,
   3.093398817941843e-01,  -2.621694120476425e-03,   2.221910617416274e-05,  -1.883083622730264e-07,   1.595919831701088e-09,  -1.352542281677414e-11,   1.146272841309890e-13,
  -9.714416696241872e-16,   8.232012930001454e-18,  -6.972358603712159e-20,   3.093408217481599e-01,  -2.621718014114677e-03,   2.221951114969609e-05,  -1.883140824464601e-07,
   1.595992548870391e-09,  -1.352628559145480e-11,   1.146370324982347e-13,  -9.715478363882727e-16,   8.233134992083488e-18,  -6.973509821639215e-20,   3.093409775595386e-01,
  -2.621721974850629e-03,   2.221957828078222e-05,  -1.883150306588418e-07,   1.596004602981305e-09,  -1.352642861174527e-11,   1.146386484724433e-13,  -9.715654356136791e-16,
   8.233320996864312e-18,  -6.973700659974975e-20,   5.129175184543739e-01,  -4.346458194705175e-03,   3.682924966063412e-05,  -3.120467130797120e-07,   2.643721484751550e-09,
  -2.239654241323543e-11,   1.897205624752023e-13,  -1.606976953247513e-15,   1.360920449114175e-17,  -1.151840217178577e-19,   5.129227640712474e-01,  -4.346591527076682e-03,
   3.683150928509442e-05,  -3.120786256400930e-07,   2.644127110084495e-09,  -2.240135425127633e-11,   1.897749195635926e-13,  -1.607568767915324e-15,   1.361545545589390e-17,
  -1.152480350425527e-19,   5.129313758333551e-01,  -4.346810423606776e-03,   3.683521907499571e-05,  -3.121310202276212e-07,   2.644793093670677e-09,  -2.240925494186393e-11,
   1.898641735436238e-13,  -1.608540564765015e-15,   1.362572031802562e-17,  -1.153531536243619e-19,   5.129405138953314e-01,  -4.347042703150648e-03,   3.683915578950385e-05,
  -3.121866216695742e-07,   2.645499867849225e-09,  -2.241763992473688e-11,   1.899589034134943e-13,  -1.609572038898563e-15,   1.363661606084501e-17,  -1.154647337999918e-19,
   5.129477058275140e-01,  -4.347225518080479e-03,   3.684225425121203e-05,  -3.122303851736098e-07,   2.646056185481431e-09,  -2.242424021002070e-11,   1.900334740604093e-13,
  -1.610384048059917e-15,   1.364519391403795e-17,  -1.155525778312202e-19,   5.129518565241660e-01,  -4.347331028043117e-03,   3.684404253295155e-05,  -3.122556439027180e-07,
   2.646377280395659e-09,  -2.242804986874844e-11,   1.900765173518283e-13,  -1.610852768079241e-15,   1.365014550192343e-17,  -1.156032863003197e-19,   5.129534151694141e-01,
  -4.347370648818888e-03,   3.684471406922117e-05,  -3.122651291762376e-07,   2.646497860991333e-09,  -2.242948052894764e-11,   1.900926818803305e-13,  -1.611028794810911e-15,
   1.365200508810139e-17,  -1.156223300950803e-19,   5.129536735380910e-01,  -4.347377216568402e-03,   3.684482538695629e-05,  -3.122667015155906e-07,   2.646517849281414e-09,
  -2.242971768639018e-11,   1.900953614532400e-13,  -1.611057974695279e-15,   1.365231335250698e-17,  -1.156254869958862e-19,   3.237828630528300e-03,  -2.653786298059995e-05,
   2.174950618445417e-07,  -1.782396044499176e-09,   1.460596844142921e-11,  -1.196817149336150e-13,   9.806100420607677e-16,  -8.034053284877247e-18,   6.581669031436782e-20,
  -5.390605424595401e-22,   3.237859606776792e-03,  -2.653862452722345e-05,   2.175075449432838e-07,  -1.782566563498386e-09,   1.460806478473043e-11,  -1.197057686035516e-13,
   9.808728842272255e-16,  -8.036822536101095e-18,   6.584504256640587e-20,  -5.393438095510464e-22,   3.237910460589375e-03,  -2.653987478195905e-05,   2.175280392655208e-07,
  -1.782846522800674e-09,   1.461150667748344e-11,  -1.197452625834142e-13,   9.813044639237766e-16,  -8.041369760312900e-18,   6.589160016573170e-20,  -5.398089847706416e-22,
   3.237964422164984e-03,  -2.654120147050202e-05,   2.175497870861390e-07,  -1.783143614924622e-09,   1.461515934351807e-11,  -1.197871768878252e-13,   9.817625144541386e-16,
  -8.046196144212520e-18,   6.594101876243996e-20,  -5.403027706984717e-22,   3.238006891475759e-03,  -2.654224563323006e-05,   2.175669040102179e-07,  -1.783377452365988e-09,
   1.461803441046376e-11,  -1.198201695598105e-13,   9.821230830964040e-16,  -8.049995567541338e-18,   6.597992404838095e-20,  -5.406915269762238e-22,   3.238031401853459e-03,
  -2.654284826075309e-05,   2.175767830329267e-07,  -1.783512414299064e-09,   1.461969382800955e-11,  -1.198392126389710e-13,   9.823312065714507e-16,  -8.052188703532002e-18,
   6.600238209762588e-20,  -5.409159436205539e-22,   3.238040605840032e-03,  -2.654307455731102e-05,   2.175804928007999e-07,  -1.783563095694312e-09,   1.462031698607911e-11,
  -1.198463639512304e-13,   9.824093651041723e-16,  -8.053012326257508e-18,   6.601081627267420e-20,  -5.410002252269120e-22,   3.238042131537616e-03,  -2.654311206941201e-05,
   2.175811077530224e-07,  -1.783571496958475e-09,   1.462042028504635e-11,  -1.198475494071647e-13,   9.824223213214419e-16,  -8.053148857647094e-18,   6.601221440825650e-20,
  -5.410141966859139e-22,   2.945456795926153e-02,  -2.414152748189443e-04,   1.978555325472893e-06,  -1.621447933579375e-08,   1.328706794310593e-10,  -1.088746071578650e-12,
   8.920621856016705e-15,  -7.308587922415691e-17,   5.987350085313834e-19,  -4.903829134812556e-21,   2.945484975058543e-02,  -2.414222026181997e-04,   1.978668884379850e-06,
  -1.621603054928201e-08,   1.328897498923600e-10,  -1.088964888101981e-12,   8.923012933445186e-15,  -7.311107107523426e-17,   5.989929262035042e-19,  -4.906405881118059e-21,
   2.945531236836099e-02,  -2.414335762013253e-04,   1.978855321488146e-06,  -1.621857734258882e-08,   1.329210608338959e-10,  -1.089324165309391e-12,   8.926939017614272e-15,
  -7.315243712855566e-17,   5.994164561204446e-19,  -4.910637358296905e-21,   2.945580325749607e-02,  -2.414456451037622e-04,   1.979053161687051e-06,  -1.622127999339051e-08,
   1.329542891826156e-10,  -1.089705460238001e-12,   8.931105907171605e-15,  -7.319634269409803e-17,   5.998660122170756e-19,  -4.915129092026120e-21,   2.945618960135275e-02,
  -2.414551438652913e-04,   1.979208874561635e-06,  -1.622340721554627e-08,   1.329804437026709e-10,  -1.090005594969580e-12,   8.934386003157900e-15,  -7.323090600921883e-17,
   6.002199297393303e-19,  -4.918665420376460e-21,   2.945641257256836e-02,  -2.414606259754819e-04,   1.979298744156019e-06,  -1.622463496595504e-08,   1.329955394448917e-10,
  -1.090178830088368e-12,   8.936279304166000e-15,  -7.325085694467347e-17,   6.004242283732057e-19,  -4.920706829932521e-21,   2.945649630135050e-02,  -2.414626845981284e-04,
   1.979332491961228e-06,  -1.622509601524736e-08,   1.330012083216638e-10,  -1.090243885661479e-12,   8.936990312996802e-15,  -7.325834943206300e-17,   6.005009532205177e-19,
  -4.921473498819810e-21,   2.945651018064070e-02,  -2.414630258461851e-04,   1.979338086189365e-06,  -1.622517244165349e-08,   1.330021480336640e-10,  -1.090254669768283e-12,
   8.937108175814450e-15,  -7.325959145669570e-17,   6.005136719200521e-19,  -4.921600590400526e-21,   8.369719756125378e-02,  -6.859982457991285e-04,   5.622202172200313e-06,
  -4.607456752280853e-08,   3.775612502301131e-10,  -3.093747460357662e-12,   2.534856513022593e-14,  -2.076785635256307e-16,   1.701345478485312e-18,  -1.393450000570719e-20,
   8.369799829084315e-02,  -6.860179316211623e-04,   5.622524857709772e-06,  -4.607897540350190e-08,   3.776154402672483e-10,  -3.094369242585407e-12,   2.535535953589845e-14,
  -2.077501475329152e-16,   1.702078350130693e-18,  -1.394182115468157e-20,   8.369931285133543e-02,  -6.860502504463827e-04,   5.623054631682460e-06,  -4.608621229328648e-08,
   3.777044124770772e-10,  -3.095390153524041e-12,   2.536651576534603e-14,  -2.078676914075538e-16,   1.703281807907723e-18,  -1.395384378106812e-20,   8.370070774685642e-02,
  -6.860845450696475e-04,   5.623616808327921e-06,  -4.609389206295030e-08,   3.777988331322569e-10,  -3.096473629333337e-12,   2.537835625925568e-14,  -2.079924514391384e-16,
   1.704559218717006e-18,  -1.396660584897561e-20,   8.370180556971854e-02,  -6.861115364592809e-04,   5.624059277259780e-06,  -4.609993671221449e-08,   3.778731530131522e-10,
  -3.097326482850354e-12,   2.538767687017894e-14,  -2.080906649594372e-16,   1.705564872972446e-18,  -1.397665337994562e-20,   8.370243915789097e-02,  -6.861271142555771e-04,
   5.624314647944703e-06,  -4.610342545013724e-08,   3.779160486106012e-10,  -3.097818742374781e-12,   2.539305681090619e-14,  -2.081473566151757e-16,   1.706145386104616e-18,
  -1.398245349650537e-20,   8.370267707903210e-02,  -6.861329639745947e-04,   5.624410544673622e-06,  -4.610473555367199e-08,   3.779321571167243e-10,  -3.098003602267475e-12,
   2.539507718977999e-14,  -2.081686469206885e-16,   1.706363399207643e-18,  -1.398463177959417e-20,   8.370271651799774e-02,  -6.861339336546136e-04,   5.624426441060834e-06,
  -4.610495272460466e-08,   3.779348273734817e-10,  -3.098034246049875e-12,   2.539541210481383e-14,  -2.081721762004081e-16,   1.706399539300497e-18,  -1.398499287605425e-20,
   1.703773181307003e-01,  -1.396445099324546e-03,   1.144477659942104e-05,  -9.379120779470352e-08,   7.685785795835274e-10,  -6.297754385490096e-12,   5.160053759352702e-14,
  -4.227585698586042e-16,   3.463320420807441e-18,  -2.836536726990871e-20,   1.703789481274500e-01,  -1.396485172560699e-03,   1.144543347077728e-05,  -9.380018065054069e-08,
   7.686888909572483e-10,  -6.299020109580507e-12,   5.161436853018675e-14,  -4.229042877210935e-16,   3.464812214442527e-18,  -2.838026743716150e-20,   1.703816240986619e-01,
  -1.396550962036649e-03,   1.144651189958099e-05,  -9.381491234889234e-08,   7.688700062914702e-10,  -6.301098315598173e-12,   5.163707855207376e-14,  -4.231435624142176e-16,
   3.467261907057238e-18,  -2.840473613383281e-20,   1.703844636030284e-01,  -1.396620773525064e-03,   1.144765628854401e-05,  -9.383054559099797e-08,   7.690622126955685e-10,
  -6.303303881096196e-12,   5.166118148704407e-14,  -4.233975264476887e-16,   3.469862133672314e-18,  -2.843070972537078e-20,   1.703866983745677e-01,  -1.396675718262906e-03,
   1.144855699576154e-05,  -9.384285031750992e-08,   7.692135011719015e-10,  -6.305039982883360e-12,   5.168015485744605e-14,  -4.235974518571627e-16,   3.471909187181114e-18,
  -2.845115861916146e-20,   1.703879881316536e-01,  -1.396707429039761e-03,   1.144907683840470e-05,  -9.384995213006083e-08,   7.693008211393206e-10,  -6.306042045514350e-12,
   5.169110645796655e-14,  -4.237128545229436e-16,   3.473090847003189e-18,  -2.846296309876673e-20,   1.703884724533171e-01,  -1.396719336958629e-03,   1.144927204957018e-05,
  -9.385261902850149e-08,   7.693336122487437e-10,  -6.306418353500559e-12,   5.169521921373262e-14,  -4.237561934928955e-16,   3.473534622150897e-18,  -2.846739636969471e-20,
   1.703885527368318e-01,  -1.396721310877540e-03,   1.144930440888326e-05,  -9.385306111021972e-08,   7.693390479285546e-10,  -6.306480733175646e-12,   5.169590097879800e-14,
  -4.237633777649435e-16,   3.473608186878681e-18,  -2.846813127795582e-20,   2.991761503539944e-01,  -2.452104972541433e-03,   2.009659643801917e-05,  -1.646938265687765e-07,
   1.349595022630424e-09,  -1.105861930354814e-11,   9.060859400518667e-14,  -7.423477912325316e-16,   6.081443429186446e-18,  -4.980776048017159e-20,   2.991790125668641e-01,
  -2.452175339634043e-03,   2.009774987936711e-05,  -1.647095825653810e-07,   1.349788725233126e-09,  -1.106084186631213e-11,   9.063288053778595e-14,  -7.426036621861491e-16,
   6.084062754358681e-18,  -4.983391533387149e-20,   2.991837114714744e-01,  -2.452290863474676e-03,   2.009964355970679e-05,  -1.647354508723515e-07,   1.350106756914109e-09,
  -1.106449111604562e-11,   9.067275836329630e-14,  -7.430238127291049e-16,   6.088363978686126e-18,  -4.987686613468429e-20,   2.991886975341416e-01,  -2.452413449817637e-03,
   2.010165306360054e-05,  -1.647629022561673e-07,   1.350444264094419e-09,  -1.106836400410988e-11,   9.071508208370563e-14,  -7.434697567371133e-16,   6.092929511688029e-18,
  -4.992245843513390e-20,   2.991926217087523e-01,  -2.452509930706814e-03,   2.010323467153215e-05,  -1.647845088920736e-07,   1.350709920940137e-09,  -1.107141253197116e-11,
   9.074839850807770e-14,  -7.438208124704368e-16,   6.096523769995525e-18,  -4.995835298087659e-20,   2.991948864735934e-01,  -2.452565613636019e-03,   2.010414749562372e-05,
  -1.647969794071971e-07,   1.350863251502177e-09,  -1.107317211534687e-11,   9.076762904847844e-14,  -7.440234518693663e-16,   6.098598551759994e-18,  -4.997907370324324e-20,
   2.991957369241840e-01,  -2.452586523492826e-03,   2.010449027907393e-05,  -1.648016623803251e-07,   1.350920831450791e-09,  -1.107383289767278e-11,   9.077485087101336e-14,
  -7.440995522130759e-16,   6.099377740846573e-18,  -4.998685553823442e-20,   2.991958778990106e-01,  -2.452589989620051e-03,   2.010454710080826e-05,  -1.648024386591573e-07,
   1.350930376299066e-09,  -1.107394243397892e-11,   9.077604802119274e-14,  -7.441121673159961e-16,   6.099506907228325e-18,  -4.998814554140655e-20,   4.960982103624875e-01,
  -4.066115855355047e-03,   3.332446625648073e-05,  -2.730976801229033e-07,   2.237917941444061e-09,  -1.833756187825058e-11,   1.502484607056457e-13,  -1.230970782007903e-15,
   1.008428372893068e-17,  -8.258951169304952e-20,   4.961029565251768e-01,  -4.066232539083569e-03,   3.332637890956805e-05,  -2.731238069434811e-07,   2.238239141855220e-09,
  -1.834124736058268e-11,   1.502887327570358e-13,  -1.231395057615410e-15,   1.008862645474784e-17,  -8.263285164045089e-20,   4.961107483166182e-01,  -4.066424102383375e-03,
   3.332951903763308e-05,  -2.731667021427996e-07,   2.238766506512177e-09,  -1.834729859367851e-11,   1.503548583674035e-13,  -1.232091735359883e-15,   1.009575768986852e-17,
  -8.270402310303175e-20,   4.961190162776941e-01,  -4.066627376826471e-03,   3.333285122598677e-05,  -2.732122224229469e-07,   2.239326165718649e-09,  -1.835372066670746e-11,
   1.504250397703587e-13,  -1.232831182703567e-15,   1.010332712937136e-17,  -8.277957132648846e-20,   4.961255234006690e-01,  -4.066787362829341e-03,   3.333547387108149e-05,
  -2.732480508578993e-07,   2.239766681678087e-09,  -1.835877577496824e-11,   1.504802852284867e-13,  -1.233413289821182e-15,   1.010928623560586e-17,  -8.283904975450998e-20,
   4.961292788664146e-01,  -4.066879697066178e-03,   3.333698752916213e-05,  -2.732687296457417e-07,   2.240020936596413e-09,  -1.836169353882945e-11,   1.505121734040379e-13,
  -1.233749298636654e-15,   1.011272612113789e-17,  -8.287338456917683e-20,   4.961306890958579e-01,  -4.066914370092512e-03,   3.333755593762561e-05,  -2.732764950192506e-07,
   2.240116416485963e-09,  -1.836278925660759e-11,   1.505241486651185e-13,  -1.233875485275625e-15,   1.011401797768846e-17,  -8.288627926868953e-20,   4.961309228623499e-01,
  -4.066920117674700e-03,   3.333765016024542e-05,  -2.732777822559940e-07,   2.240132243889093e-09,  -1.836297089112354e-11,   1.505261337853324e-13,  -1.233896403149671e-15,
   1.011423212907013e-17,  -8.288841683597111e-20,   3.135027016367638e-03,  -2.487965864413618e-05,   1.974334352933537e-07,  -1.566643329023152e-09,   1.243061740705501e-11,
  -9.862530956339010e-14,   7.824509204765020e-16,  -6.207239901207802e-18,   4.923916832250052e-20,  -3.905318033118314e-22,   3.135055133959219e-03,  -2.488032797513490e-05,
   1.974440585800427e-07,  -1.566783837002954e-09,   1.243228997088055e-11,  -9.864389168147344e-14,   7.826475321309658e-16,  -6.209245798999796e-18,   4.925906154883032e-20,
  -3.907245717966800e-22,   3.135101294632007e-03,  -2.488142683372205e-05,   1.974614994579224e-07,  -1.567014522725352e-09,   1.243503605873954e-11,  -9.867440157273337e-14,
   7.829703593330408e-16,  -6.212539519487139e-18,   4.929172797935557e-20,  -3.910411285507241e-22,   3.135150276162825e-03,  -2.488259286664176e-05,   1.974800069821184e-07,
  -1.567259324113815e-09,   1.243795028294588e-11,  -9.870678082086873e-14,   7.833129819057052e-16,  -6.216035382939010e-18,   4.932640111465161e-20,  -3.913771503571018e-22,
   3.135188825963376e-03,  -2.488351058342012e-05,   1.974945735181265e-07,  -1.567452002925475e-09,   1.244024409159301e-11,  -9.873226772848360e-14,   7.835826841274631e-16,
  -6.218787349361102e-18,   4.935369740287312e-20,  -3.916416958844275e-22,   3.135211074239396e-03,  -2.488404023285298e-05,   1.975029805586760e-07,  -1.567563209185109e-09,
   1.244156801323771e-11,  -9.874697843277820e-14,   7.837383571876981e-16,  -6.220375845051838e-18,   4.936945397176520e-20,  -3.917944082095924e-22,   3.135219428769988e-03,
  -2.488423912472055e-05,   1.975061375630792e-07,  -1.567604969668480e-09,   1.244206518162911e-11,  -9.875250277204638e-14,   7.837968182483361e-16,  -6.220972394297122e-18,
   4.937537135280278e-20,  -3.918517603760419e-22,   3.135220813657330e-03,  -2.488427209406536e-05,   1.975066608858140e-07,  -1.567611892141634e-09,   1.244214759560121e-11,
  -9.875341852742223e-14,   7.838065092316568e-16,  -6.221071283686291e-18,   4.937635227679151e-20,  -3.918612676968187e-22,   2.851938037642677e-02,  -2.263305690200672e-04,
   1.796054455275186e-06,  -1.425177415736708e-08,   1.130814835998936e-10,  -8.971956869098064e-13,   7.117965892687877e-15,  -5.646733883108478e-17,   4.479292863468906e-19,
  -3.552670483316975e-21,   2.851963616251263e-02,  -2.263366579326189e-04,   1.796151095448410e-06,  -1.425305236023417e-08,   1.130966989341083e-10,  -8.973647286696716e-13,
   7.119754471180299e-15,  -5.648558649627656e-17,   4.481102546512871e-19,  -3.554424072621656e-21,   2.852005608673618e-02,  -2.263466542630695e-04,   1.796309755334828e-06,
  -1.425515091116475e-08,   1.131216801299937e-10,  -8.976422775308001e-13,   7.122691233965937e-15,  -5.651554949275892e-17,   4.484074205481170e-19,  -3.557303747151974e-21,
   2.852050167234087e-02,  -2.263572616792719e-04,   1.796478118516262e-06,  -1.425737787248782e-08,   1.131481908643510e-10,  -8.979368319546915e-13,   7.125808075464024e-15,
  -5.654735138495326e-17,   4.487228413932245e-19,  -3.560360492366636e-21,   2.852085236036353e-02,  -2.263656101603992e-04,   1.796610630478360e-06,  -1.425913067407132e-08,
   1.131690576705415e-10,  -8.981686866709297e-13,   7.128261559686509e-15,  -5.657238604100670e-17,   4.489711551973697e-19,  -3.562767027259912e-21,   2.852105475321157e-02,
  -2.263704283879817e-04,   1.796687109432453e-06,  -1.426014231881991e-08,   1.131811014024394e-10,  -8.983025101312394e-13,   7.129677719310531e-15,  -5.658683659637317e-17,
   4.491144923967590e-19,  -3.564156230546899e-21,   2.852113075448192e-02,  -2.263722377098138e-04,   1.796715828741394e-06,  -1.426052221446463e-08,   1.131856241495658e-10,
  -8.983527651144108e-13,   7.130209540253132e-15,  -5.659226340863081e-17,   4.491683226960775e-19,  -3.564677955401425e-21,   2.852114335281956e-02,  -2.263725376323600e-04,
   1.796720589414924e-06,  -1.426058518829036e-08,   1.131863738705093e-10,  -8.983610957524776e-13,   7.130297699240119e-15,  -5.659316300602916e-17,   4.491772461423570e-19,
  -3.564764442204042e-21,   8.103979718839451e-02,  -6.431340081315634e-04,   5.103613292913163e-06,  -4.049740464339272e-08,   3.213288779502734e-10,  -2.549443764341984e-12,
   2.022619362094603e-14,  -1.604558533707073e-16,   1.272821823896989e-18,  -1.009514560111339e-20,   8.104052402229649e-02,  -6.431513101988515e-04,   5.103887902667459e-06,
  -4.050103674548201e-08,   3.213721133774114e-10,  -2.549924108206746e-12,   2.023127598946539e-14,  -1.605077053006465e-16,   1.273336054016832e-18,  -1.010012837354640e-20,
   8.104171726609989e-02,  -6.431797154650826e-04,   5.104338745737918e-06,  -4.050699992348423e-08,   3.214430991776084e-10,  -2.550712782512392e-12,   2.023962100243193e-14,
  -1.605928471073727e-16,   1.274180465139755e-18,  -1.010831088267320e-20,   8.104298342849746e-02,  -6.432098571738569e-04,   5.104817161394095e-06,  -4.051332798852186e-08,
   3.215184312674221e-10,  -2.551549779301827e-12,   2.024847772140140e-14,  -1.606832142552244e-16,   1.275076748529907e-18,  -1.011699653101149e-20,   8.104397993283442e-02,
  -6.432335799619560e-04,   5.105193703324218e-06,  -4.051830869577682e-08,   3.215777257440228e-10,  -2.552208610530689e-12,   2.025544946514715e-14,  -1.607543518602286e-16,
   1.275782344028636e-18,  -1.012383462520255e-20,   8.104455504614828e-02,  -6.432472712897805e-04,   5.105411023576156e-06,  -4.052118335448675e-08,   3.216119488432681e-10,
  -2.552588879158483e-12,   2.025947357987369e-14,  -1.607954140538263e-16,   1.276189643493812e-18,  -1.012778200267703e-20,   8.104477100902877e-02,  -6.432524126032447e-04,
   5.105492631484221e-06,  -4.052226285430670e-08,   3.216248005428141e-10,  -2.552731682172576e-12,   2.026098478556657e-14,  -1.608108346940169e-16,   1.276342604845653e-18,
  -1.012926446735020e-20,   8.104480680807888e-02,  -6.432532648539598e-04,   5.105506159268213e-06,  -4.052244179879968e-08,   3.216269309268572e-10,  -2.552755354257416e-12,
   2.026123529537601e-14,  -1.608133909585649e-16,   1.276367961241895e-18,  -1.012951021685907e-20,   1.649678090680353e-01,  -1.309188965662912e-03,   1.038911661272777e-05,
  -8.243811495953129e-08,   6.541097438520347e-10,  -5.189748325127973e-12,   4.117323752324468e-14,  -3.266302457515012e-16,   2.591005244347492e-18,  -2.055002731854629e-20,
   1.649692886398078e-01,  -1.309224186433840e-03,   1.038967561917993e-05,  -8.244550860986269e-08,   6.541977555928118e-10,  -5.190726131986471e-12,   4.118358338853875e-14,
  -3.267357973162958e-16,   2.592052017742275e-18,  -2.056016983051694e-20,   1.649717176539806e-01,  -1.309282009314680e-03,   1.039059337312478e-05,  -8.245764749030391e-08,
   6.543422570875133e-10,  -5.192331588413583e-12,   4.120057081861252e-14,  -3.269091148924127e-16,   2.593770911690211e-18,  -2.057682545220842e-20,   1.649742951041211e-01,
  -1.309343366966482e-03,   1.039156725491315e-05,  -8.247052914919228e-08,   6.544956060607747e-10,  -5.194035411987939e-12,   4.121859989709782e-14,  -3.270930693487512e-16,
   2.595595397329696e-18,  -2.059450521480425e-20,   1.649763236276724e-01,  -1.309391658010061e-03,   1.039233375852475e-05,  -8.248066807341311e-08,   6.546163082360197e-10,
  -5.195376554741347e-12,   4.123279184732946e-14,  -3.272378794878968e-16,   2.597031716211247e-18,  -2.060842424945829e-20,   1.649774943510287e-01,  -1.309419528617254e-03,
   1.039277614420522e-05,  -8.248651984211353e-08,   6.546859741266587e-10,  -5.196150644511261e-12,   4.124098349032444e-14,  -3.273214670911782e-16,   2.597860819971475e-18,
  -2.061645918859948e-20,   1.649779339735903e-01,  -1.309429994477823e-03,   1.039294226848319e-05,  -8.248871731454273e-08,   6.547121355531461e-10,  -5.196441339941352e-12,
   4.124405975885987e-14,  -3.273528578726922e-16,   2.598172189957019e-18,  -2.061947676471503e-20,   1.649780068475494e-01,  -1.309431729353009e-03,   1.039296980617410e-05,
  -8.248908158101359e-08,   6.547164722469301e-10,  -5.196489527767966e-12,   4.124456970628001e-14,  -3.273580614920484e-16,   2.598223805744726e-18,  -2.061997699101599e-20,
   2.896772562850577e-01,  -2.298886489881730e-03,   1.824289728159787e-05,  -1.447582233734578e-07,   1.148592061376497e-09,  -9.113002479741719e-12,   7.229865251105985e-14,
  -5.735503404153340e-16,   4.549704329286365e-18,  -3.608492560888673e-20,   2.896798543573358e-01,  -2.298948336228264e-03,   1.824387887586280e-05,  -1.447712063448033e-07,
   1.148746606674352e-09,  -9.114719471538098e-12,   7.231681944686773e-14,  -5.737356841771901e-16,   4.551542382650023e-18,  -3.610273361799849e-20,   2.896841196146914e-01,
  -2.299049871028093e-03,   1.824549041720620e-05,  -1.447925217613932e-07,   1.149000345849830e-09,  -9.117538592194846e-12,   7.234664871118830e-14,  -5.740400219755619e-16,
   4.554560627541747e-18,  -3.613197719335071e-20,   2.896886455200127e-01,  -2.299157612752532e-03,   1.824720051692775e-05,  -1.448151414689437e-07,   1.149269620863989e-09,
  -9.120530441832751e-12,   7.237830706931257e-14,  -5.743630376437333e-16,   4.557764282823519e-18,  -3.616301891271347e-20,   2.896922075309287e-01,  -2.299242410005317e-03,
   1.824854646838553e-05,  -1.448329450377803e-07,   1.149481569331941e-09,  -9.122885437689497e-12,   7.240322757987521e-14,  -5.746173176626082e-16,   4.560286347050965e-18,
  -3.618745761807542e-20,   2.896942632770261e-01,  -2.299291349741306e-03,   1.824932328096999e-05,  -1.448432205230886e-07,   1.149603900008737e-09,  -9.124244709993165e-12,
   7.241761178513164e-14,  -5.747640936900197e-16,   4.561742188625902e-18,  -3.620156516456312e-20,   2.896950352376781e-01,  -2.299309727398083e-03,   1.824961498894204e-05,
  -1.448470792018604e-07,   1.149649838487075e-09,  -9.124755160153057e-12,   7.242301359255811e-14,  -5.748192144733026e-16,   4.562288930024161e-18,  -3.620686334861142e-20,
   2.896951632016042e-01,  -2.299312773773535e-03,   1.824966334408958e-05,  -1.448477188400555e-07,   1.149657453557818e-09,  -9.124839776150600e-12,   7.242390904031503e-14,
  -5.748283517919723e-16,   4.562379563318434e-18,  -3.620774163327750e-20,   4.803470071250440e-01,  -3.812046756091132e-03,   3.025063556205037e-05,  -2.400401752086110e-07,
   1.904611932607728e-09,  -1.511131218731876e-11,   1.198866657228201e-13,  -9.510692544700642e-16,   7.544375109641221e-18,  -5.983607287560697e-20,   4.803513152859921e-01,
  -3.812149310595547e-03,   3.025226325582677e-05,  -2.400617037589992e-07,   1.904868201843493e-09,  -1.511415932726343e-11,   1.199167903542652e-13,  -9.513765915922886e-16,
   7.547422863731854e-18,  -5.986559635901635e-20,   4.803583879972972e-01,  -3.812317677066015e-03,   3.025493553694001e-05,  -2.400970492903016e-07,   1.905288955793795e-09,
  -1.511883403277926e-11,   1.199662535987338e-13,  -9.518812446659574e-16,   7.552427542260385e-18,  -5.991407855267035e-20,   4.803658929188210e-01,  -3.812496335948453e-03,
   3.025777124897829e-05,  -2.401345576156908e-07,   1.905735471495156e-09,  -1.512379515991304e-11,   1.200187498680105e-13,  -9.524168693620503e-16,   7.557739656045655e-18,
  -5.996554177813771e-20,   4.803717994967303e-01,  -3.812636947976849e-03,   3.026000312511022e-05,  -2.401640797503828e-07,   1.906086927493024e-09,  -1.512770024714751e-11,
   1.200600733572481e-13,  -9.528385165584367e-16,   7.561921594330949e-18,  -6.000605799745988e-20,   4.803752083645786e-01,  -3.812718100553385e-03,   3.026129124694866e-05,
  -2.401811187083623e-07,   1.906289777980658e-09,  -1.512995421158691e-11,   1.200839254186207e-13,  -9.530819005983083e-16,   7.564335584606778e-18,  -6.002944646940326e-20,
   4.803764884408731e-01,  -3.812748574649086e-03,   3.026177496131781e-05,  -2.401875172251695e-07,   1.906365953826125e-09,  -1.513080064721633e-11,   1.200928827603406e-13,
  -9.531733018912316e-16,   7.565242158729499e-18,  -6.003823016381712e-20,   4.803767006325020e-01,  -3.812753626192828e-03,   3.026185514452131e-05,  -2.401885778824525e-07,
   1.906378581245952e-09,  -1.513094095865270e-11,   1.200943676025258e-13,  -9.531884533946346e-16,   7.565392441472169e-18,  -6.003968624443265e-20,   3.038552835582184e-03,
  -2.337215247611651e-05,   1.797651128861404e-07,  -1.382569232040100e-09,   1.063268942201640e-11,  -8.176625729198824e-14,   6.287526546654763e-16,  -4.834595707358309e-18,
   3.717188330193100e-20,  -2.857686189740769e-22,   3.038578435750765e-03,  -2.337274313693632e-05,   1.797741991602570e-07,  -1.382685713635401e-09,   1.063403332718254e-11,
  -8.178072871975275e-14,   6.289010628498180e-16,  -4.836063279733908e-18,   3.718599182396027e-20,  -2.859011994604868e-22,   3.038620463507756e-03,  -2.337371283826675e-05,
   1.797891165801571e-07,  -1.382876951926224e-09,   1.063623979420958e-11,  -8.180448908352494e-14,   6.291447395757434e-16,  -4.838473028778818e-18,   3.720915891082461e-20,
  -2.861189144729559e-22,   3.038665059480016e-03,  -2.337474181526085e-05,   1.798049462443491e-07,  -1.383079890787164e-09,   1.063858133780340e-11,  -8.182970497899387e-14,
   6.294033547032535e-16,  -4.841030626859531e-18,   3.723374868104117e-20,  -2.863500121469884e-22,   3.038700157666915e-03,  -2.337555166099656e-05,   1.798174050905683e-07,
  -1.383239619403196e-09,   1.064042437051308e-11,  -8.184955314453893e-14,   6.296069262050324e-16,  -4.843043953815180e-18,   3.725310653617220e-20,  -2.865319489484685e-22,
   3.038720413886657e-03,  -2.337601905301134e-05,   1.798245956619915e-07,  -1.383331807790299e-09,   1.064148811116913e-11,  -8.186100916112709e-14,   6.297244273508137e-16,
  -4.844206078146069e-18,   3.726428056878612e-20,  -2.866369729792103e-22,   3.038728020368486e-03,  -2.337619456604551e-05,   1.798272958549942e-07,  -1.383366426557694e-09,
   1.064188757345841e-11,  -8.186531124595826e-14,   6.297685532336371e-16,  -4.844642504055749e-18,   3.726847695180506e-20,  -2.866764152248032e-22,   3.038729281255413e-03,
  -2.337622365998482e-05,   1.798277434539015e-07,  -1.383372165172543e-09,   1.064195379095255e-11,  -8.186602439058474e-14,   6.297758678903957e-16,  -4.844714849831648e-18,
   3.726917258465499e-20,  -2.866829535883632e-22,   2.764175353494826e-02,  -2.126167663634720e-04,   1.635325503111968e-06,  -1.257724977150750e-08,   9.672571000697454e-11,
  -7.438286755906725e-13,   5.719770840138283e-15,  -4.398037804476943e-17,   3.381530823880449e-19,  -2.599640295923389e-21,   2.764198642000527e-02,  -2.126221396124124e-04,
   1.635408161062404e-06,  -1.257830940605154e-08,   9.673793552924292e-11,  -7.439603223512856e-13,   5.721120911225237e-15,  -4.399372856679967e-17,   3.382814276676700e-19,
  -2.600846376698767e-21,   2.764236874704161e-02,  -2.126309609976667e-04,   1.635543865019704e-06,  -1.258004910319919e-08,   9.675800778765296e-11,  -7.441764706797311e-13,
   5.723337641411935e-15,  -4.401565008032544e-17,   3.384921787457217e-19,  -2.602826923702441e-21,   2.764277443716470e-02,  -2.126403216143823e-04,   1.635687867674853e-06,
  -1.258189524058100e-08,   9.677930883929682e-11,  -7.444058599983442e-13,   5.725690266421953e-15,  -4.403891657812603e-17,   3.387158719783012e-19,  -2.604929212319834e-21,
   2.764309372581435e-02,  -2.126476887912718e-04,   1.635801205956316e-06,  -1.258334829381899e-08,   9.679607493113193e-11,  -7.445864190102413e-13,   5.727542158888312e-15,
  -4.405723183551047e-17,   3.388919704585720e-19,  -2.606584285907970e-21,   2.764327799690126e-02,  -2.126519406623354e-04,   1.635866618675399e-06,  -1.258418693274113e-08,
   9.680575179331374e-11,  -7.446906345373991e-13,   5.728611068262811e-15,  -4.406780369327903e-17,   3.389936206745008e-19,  -2.607539686325795e-21,   2.764334719316256e-02,
  -2.126535373066247e-04,   1.635891182365259e-06,  -1.258450186010548e-08,   9.680938570680399e-11,  -7.447297706572801e-13,   5.729012481963855e-15,  -4.407177386455869e-17,
   3.390317951862352e-19,  -2.607898491232618e-21,   2.764335866346688e-02,  -2.126538019745582e-04,   1.635895254178174e-06,  -1.258455406435727e-08,   9.680998808818440e-11,
  -7.447362581429272e-13,   5.729079023486730e-15,  -4.407243199487421e-17,   3.390381233608216e-19,  -2.607957970526598e-21,   7.854595965399640e-02,  -6.041652868163339e-04,
   4.646890828621891e-06,  -3.573912747109816e-08,   2.748528130104051e-10,  -2.113640766709289e-12,   1.625312549510086e-14,  -1.249732931558197e-16,   9.608853756036681e-19,
  -7.387055474193693e-21,   7.854662141303674e-02,  -6.041805552758384e-04,   4.647125706920467e-06,  -3.574213849614138e-08,   2.748875526797393e-10,  -2.114014850105754e-12,
   1.625696181547119e-14,  -1.250112295752032e-16,   9.612500768559587e-19,  -7.390482601933253e-21,   7.854770782182527e-02,  -6.042056218538108e-04,   4.647511319126338e-06,
  -3.574708196623554e-08,   2.749445893939708e-10,  -2.114629050565109e-12,   1.626326080761317e-14,  -1.250735210516776e-16,   9.618489394047629e-19,  -7.396110406786837e-21,
   7.854886061844504e-02,  -6.042322206953765e-04,   4.647920512657674e-06,  -3.575232789363677e-08,   2.750051178093893e-10,  -2.115280876215889e-12,   1.626994595429162e-14,
  -1.251396343925725e-16,   9.624845778975823e-19,  -7.402084145008731e-21,   7.854976789928605e-02,  -6.042531550394294e-04,   4.648242571244574e-06,  -3.575645684518268e-08,
   2.750527598220232e-10,  -2.115793947165043e-12,   1.627520823481340e-14,  -1.251916784458949e-16,   9.629849728800697e-19,  -7.406787103343985e-21,   7.855029151835889e-02,
  -6.042652370259283e-04,   4.648428446022287e-06,  -3.575883989584009e-08,   2.750802572969776e-10,  -2.116090082809957e-12,   1.627824561472696e-14,  -1.252217191009053e-16,
   9.632738184027679e-19,  -7.409501912043770e-21,   7.855048814433421e-02,  -6.042697740014053e-04,   4.648498245450541e-06,  -3.575973478378630e-08,   2.750905833141624e-10,
  -2.116201290807616e-12,   1.627938625952014e-14,  -1.252330006134130e-16,   9.633822936937146e-19,  -7.410521470591609e-21,   7.855052073799940e-02,  -6.042705260736934e-04,
   4.648509815789324e-06,  -3.575988312578815e-08,   2.750922950226284e-10,  -2.116219725447811e-12,   1.627957534185937e-14,  -1.252348707355969e-16,   9.634002756022522e-19,
  -7.410690483392292e-21,   1.598912549736946e-01,  -1.229862698808982e-03,   9.459394341695339e-06,  -7.275197818172363e-08,   5.595012321189627e-10,  -4.302610550121092e-12,
   3.308550355488752e-14,  -2.544005630974318e-16,   1.956015979263532e-18,  -1.503737204337331e-20,   1.598926020765108e-01,  -1.229893779887658e-03,   9.459872469228440e-06,
  -7.275810754311816e-08,   5.595719495605669e-10,  -4.303372049031780e-12,   3.309331291913007e-14,  -2.544777879173532e-16,   1.956758376833535e-18,  -1.504434831780771e-20,
   1.598948136131115e-01,  -1.229944806402931e-03,   9.460657436651339e-06,  -7.276817066591365e-08,   5.596880557465268e-10,  -4.304622339702576e-12,   3.310613539463260e-14,
  -2.546045908184908e-16,   1.957977440629146e-18,  -1.505580429806921e-20,   1.598971602914012e-01,  -1.229998952054439e-03,   9.461490407150891e-06,  -7.277884948273850e-08,
   5.598112697771914e-10,  -4.305949221696310e-12,   3.311974394144728e-14,  -2.547391736517496e-16,   1.959271366684574e-18,  -1.506796446022148e-20,   1.598990071880834e-01,
  -1.230041566831283e-03,   9.462146002319125e-06,  -7.278725453943584e-08,   5.599082517378941e-10,  -4.306993649148734e-12,   3.313045604609159e-14,  -2.548451165072553e-16,
   1.960289986700738e-18,  -1.507753781747032e-20,   1.599000730877306e-01,  -1.230066161399768e-03,   9.462524376351433e-06,  -7.279210557139040e-08,   5.599642266828638e-10,
  -4.307596474542914e-12,   3.313663905578251e-14,  -2.549062684076307e-16,   1.960877969867758e-18,  -1.508306409047628e-20,   1.599004733473250e-01,  -1.230075397046082e-03,
   9.462666462821938e-06,  -7.279392724060644e-08,   5.599852467308730e-10,  -4.307822853927407e-12,   3.313896099706384e-14,  -2.549292334837154e-16,   1.961098785631262e-18,
  -1.508513950694274e-20,   1.599005396962760e-01,  -1.230076927994109e-03,   9.462690015860141e-06,  -7.279422921143907e-08,   5.599887311521642e-10,  -4.307860380207787e-12,
   3.313934590049007e-14,  -2.549330403755833e-16,   1.961135390177963e-18,  -1.508548354990753e-20,   2.807630185938437e-01,  -2.159592554517059e-03,   1.661034000815418e-05,
  -1.277497321931909e-07,   9.824630800297483e-10,  -7.555221989025992e-12,   5.809689729091233e-14,  -4.467177903914802e-16,   3.434689731931489e-18,  -2.640503014175286e-20,
   2.807653840556265e-01,  -2.159647131719993e-03,   1.661117958208512e-05,  -1.277604951208242e-07,   9.825872571919218e-10,  -7.556559152379728e-12,   5.811061023760688e-14,
  -4.468533941092197e-16,   3.435993346049558e-18,  -2.641727985087611e-20,   2.807692674305605e-01,  -2.159736732357993e-03,   1.661255795529996e-05,  -1.277781655852399e-07,
   9.827911352785147e-10,  -7.558754615620430e-12,   5.813312601705046e-14,  -4.470760549678591e-16,   3.438133962868953e-18,  -2.643739551668261e-20,   2.807733881092080e-01,
  -2.159831810081685e-03,   1.661402062010851e-05,  -1.277969171851696e-07,   9.830074944725142e-10,  -7.561084570333731e-12,   5.815702210779889e-14,  -4.473123770765278e-16,
   3.440406034089397e-18,  -2.645874765816573e-20,   2.807766311901858e-01,  -2.159906640023982e-03,   1.661517182051927e-05,  -1.278116761479984e-07,   9.831777911403245e-10,
  -7.562918545530115e-12,   5.817583215620926e-14,  -4.474984085207196e-16,   3.442194681228588e-18,  -2.647555760197399e-20,   2.807785028698003e-01,  -2.159949827159449e-03,
   1.661583623106181e-05,  -1.278201943773069e-07,   9.832760810340323e-10,  -7.563977084175354e-12,   5.818668928609852e-14,  -4.476057888271275e-16,   3.443227151007016e-18,
  -2.648526123309339e-20,   2.807792057105652e-01,  -2.159966044606353e-03,   1.661608572954980e-05,  -1.278233931598035e-07,   9.833129914461043e-10,  -7.564374597832324e-12,
   5.819076652668783e-14,  -4.476461145878217e-16,   3.443614892718403e-18,  -2.648890547479913e-20,   2.807793222168229e-01,  -2.159968732893398e-03,   1.661612708779734e-05,
  -1.278239234092063e-07,   9.833191099585659e-10,  -7.564440492564655e-12,   5.819144240246678e-14,  -4.476527993386044e-16,   3.443679168516915e-18,  -2.648950958280176e-20,
   4.655652895311638e-01,  -3.581067542116520e-03,   2.754350552945284e-05,  -2.118364496636692e-07,   1.629134458552584e-09,  -1.252817813378177e-11,   9.633711295023851e-14,
  -7.407538501427659e-16,   5.695450141323256e-18,  -4.378511213888186e-20,   4.655692119740313e-01,  -3.581158042822109e-03,   2.754489772306214e-05,  -2.118542969055926e-07,
   1.629340370913662e-09,  -1.253039543723462e-11,   9.635985194808192e-14,  -7.409787096922336e-16,   5.697611787541043e-18,  -4.380542361405392e-20,   4.655756514423937e-01,
  -3.581306619893196e-03,   2.754718336142013e-05,  -2.118835983246924e-07,   1.629678444496969e-09,  -1.253403598587006e-11,   9.639718792485042e-14,  -7.413479283288397e-16,
   5.701161347112277e-18,  -4.383877777159372e-20,   4.655824844111984e-01,  -3.581464279146826e-03,   2.754960877331534e-05,  -2.119146924983036e-07,   1.630037214432550e-09,
  -1.253789955019295e-11,   9.643681275280938e-14,  -7.417398001917591e-16,   5.704928883386811e-18,  -4.387418213911156e-20,   4.655878621348813e-01,  -3.581588363237121e-03,
   2.755151771045096e-05,  -2.119391660234555e-07,   1.630319602822928e-09,  -1.254094067416626e-11,   9.646800383499469e-14,  -7.420482795296177e-16,   5.707894808236626e-18,
  -4.390205499786168e-20,   4.655909657810310e-01,  -3.581659976768449e-03,   2.755261944560159e-05,  -2.119532910742228e-07,   1.630482588542089e-09,  -1.254269595812882e-11,
   9.648600727776852e-14,  -7.422263387047706e-16,   5.709606843859316e-18,  -4.391814475269783e-20,   4.655921312417311e-01,  -3.581686868772963e-03,   2.755303316759522e-05,
  -2.119585953415207e-07,   1.630543793919662e-09,  -1.254335512097567e-11,   9.649276821443541e-14,  -7.422932073131071e-16,   5.710249794984234e-18,  -4.392418733075929e-20,
   4.655923244340892e-01,  -3.581691326529340e-03,   2.755310174843819e-05,  -2.119594746087325e-07,   1.630553939725259e-09,  -1.254346438856583e-11,   9.649388896098808e-14,
  -7.423042920384425e-16,   5.710356376750940e-18,  -4.392518901229351e-20  };
  static constexpr double xi[20280] = {  -1.386927510350328e-03,   8.337218125682877e-05,  -3.260234499278599e-06,   1.026641630362290e-07,  -2.778245128611370e-09,
   6.568671005333402e-11,  -1.334540447444581e-12,   2.149501728500978e-14,  -1.817146495046243e-16,  -4.497009761225592e-18,   3.055967024070884e-19,  -1.061234838075791e-20,
   2.600182960019119e-22,  -4.378403942570860e-24,  -1.319564558062818e-03,   7.932612509373389e-05,  -3.102152657616145e-06,   9.769011412515519e-08,  -2.643706075711328e-09,
   6.250508344345686e-11,  -1.269776856523621e-12,   2.044455934615961e-14,  -1.724629653291956e-16,  -4.295724124214165e-18,   2.912441573683822e-19,  -1.010633646453675e-20,
   2.475123871358396e-22,  -4.167137000444700e-24,  -1.191392936182918e-03,   7.162633441565620e-05,  -2.801261254617877e-06,   8.822096231537905e-08,  -2.387555558539432e-09,
   5.644782064669832e-11,  -1.146528187025144e-12,   1.844844866104966e-14,  -1.550321353230188e-16,  -3.905786589073787e-18,   2.637363691650984e-19,  -9.139713914380346e-21,
   2.236671900139154e-22,  -3.764580580468933e-24,  -1.014902890405663e-03,   6.102123834500364e-05,  -2.386728205683568e-06,   7.517237579360043e-08,  -2.034525244686583e-09,
   4.810015193801980e-11,  -9.767731440328175e-13,   1.570490077905853e-14,  -1.313652360514405e-16,  -3.355353593507415e-18,   2.254721962063025e-19,  -7.801257646583272e-21,
   1.907355595204437e-22,  -3.209158028987129e-24,  -8.073289632368882e-04,   4.854502694167859e-05,  -1.898919469054446e-06,   5.981331703189818e-08,  -1.618918892079963e-09,
   3.827351508546616e-11,  -7.770657203647505e-13,   1.248459615322911e-14,  -1.039554614844236e-16,  -2.690864645594003e-18,   1.799792756217671e-19,  -6.217654086175509e-21,
   1.518809846909789e-22,  -2.554527066100433e-24,  -5.889819396388446e-04,   3.541820511353285e-05,  -1.385544400721875e-06,   4.364563322473843e-08,  -1.181370214401588e-09,
   2.792872289326028e-11,  -5.669432000194766e-13,   9.103199843277149e-15,  -7.552091271394280e-17,  -1.975908164396484e-18,   1.316684726669131e-19,  -4.543079559632884e-21,
   1.108953475909049e-22,  -1.864645583747091e-24,  -3.812578523324828e-04,   2.292785501875785e-05,  -8.969712696573908e-07,   2.825647917414504e-08,  -7.648480342096817e-10,
   1.808151304429219e-11,  -3.670086527032442e-13,   5.890569116400809e-15,  -4.874926804542099e-17,  -1.284518693105094e-18,   8.538766354903612e-20,  -2.943817771779634e-21,
   7.182352950143567e-23,  -1.207443987596974e-24,  -2.045248670893584e-04,   1.229988496910816e-05,  -4.812015808819620e-07,   1.515920403903439e-08,  -4.103359884547102e-10,
   9.700551309047657e-12,  -1.968855411663766e-13,   3.159406769848172e-15,  -2.611374719779271e-17,  -6.905873566956722e-19,   4.584911973483886e-20,  -1.580032353883005e-21,
   3.854033478943174e-23,  -6.478478732047125e-25,  -7.611033632172388e-05,   4.577223901664869e-06,  -1.790737559959125e-07,   5.641371758744331e-09,  -1.527038733333205e-10,
   3.609989044917048e-12,  -7.326809318365361e-14,   1.175643201781051e-15,  -9.712889988805286e-18,  -2.571856157342594e-19,   1.706752879876732e-20,  -5.880885748267838e-22,
   1.434350376359767e-23,  -2.411003891008347e-25,  -8.597273373087702e-06,   5.170348552658843e-07,  -2.022787255400223e-08,   6.372407341353491e-10,  -1.724920958786811e-11,
   4.077790171809258e-13,  -8.276229907916873e-15,   1.327969996131529e-16,  -1.097061360010077e-18,  -2.905468696653676e-20,   1.928014468118254e-21,  -6.643124791736443e-23,
   1.620238883786531e-24,  -2.723449613649271e-26,  -1.016291716785011e-02,   4.402273357024713e-04,  -8.306141947435746e-06,  -3.788479772449923e-08,   7.435327507271605e-09,
  -2.234219075932155e-10,   1.939510148720792e-12,   1.046459371142840e-13,  -5.049506004465992e-15,   9.090486204317763e-17,   8.067970740989291e-19,  -9.584729082956239e-20,
   2.439865053463504e-21,  -5.249496754592540e-24,  -9.668834507874034e-03,   4.188110265977060e-04,  -7.900800076518319e-06,  -3.610828933008277e-08,   7.074519574316181e-09,
  -2.124888061409444e-10,   1.840974774117498e-12,   9.965213885584811e-14,  -4.802778346291115e-15,   8.632640131613755e-17,   7.722964453146525e-19,  -9.119545575745382e-20,
   2.317143835824585e-21,  -4.849491382567569e-24,  -8.728933813913833e-03,   3.780762029095274e-04,  -7.130333733112207e-06,  -3.270222712135458e-08,   6.387874496409202e-09,
  -1.917194671861752e-10,   1.655256513542170e-12,   9.011403095031608e-14,  -4.333920108547289e-15,   7.768136886997140e-17,   7.047338262854432e-19,  -8.234252658653692e-20,
   2.085352499436290e-21,  -4.147712709920268e-24,  -7.435078374746183e-03,   3.220122834750261e-04,  -6.070924457536001e-06,  -2.796197176994024e-08,   5.442117186019332e-09,
  -1.631846898160459e-10,   1.402946043039398e-12,   7.690990427919581e-14,  -3.689464818148442e-15,   6.590606767611587e-17,   6.079940226820407e-19,  -7.014902632497853e-20,
   1.769501516030514e-21,  -3.296072938574197e-24,  -5.913815695107450e-03,   2.561086939057347e-04,  -4.826839476076184e-06,  -2.232341114551488e-08,   4.329466720207563e-09,
  -1.297057031407471e-10,   1.110523967526444e-12,   6.129160468961518e-14,  -2.932980216024628e-15,   5.221982637415529e-17,   4.895418058390793e-19,  -5.580466231386608e-20,
   1.402234092607112e-21,  -2.439155816903374e-24,  -4.314037654688333e-03,   1.868168342910748e-04,  -3.519967166968455e-06,  -1.633312241859450e-08,   3.158771475333807e-09,
  -9.456514741740487e-11,   8.069551543705267e-13,   4.478043836179467e-14,  -2.138619817744620e-15,   3.797517248513910e-17,   3.606007744422155e-19,  -4.071338004185627e-20,
   1.019839268183427e-21,  -1.672253587401032e-24,  -2.792398671110506e-03,   1.209186622714328e-04,  -2.277924431128777e-06,  -1.059288820627550e-08,   2.044825663083325e-09,
  -6.118755639748021e-11,   5.209784286666342e-13,   2.901509878247297e-14,  -1.383884444364421e-15,   2.453000727022448e-17,   2.348997118157602e-19,  -2.635496907509661e-20,
   6.588098517899153e-22,  -1.036682650607744e-24,  -1.497934293580451e-03,   6.486349888637873e-05,  -1.221819334120848e-06,  -5.688088865393866e-09,   1.096969341290352e-09,
  -3.281674212232463e-11,   2.790983412441039e-13,   1.557277813564130e-14,  -7.422490303635711e-16,   1.314475154618651e-17,   1.264178185247892e-19,  -1.413818765694548e-20,
   3.530451506568340e-22,  -5.435207238255573e-25,  -5.574245799294752e-04,   2.413741921910343e-05,  -4.546568670689988e-07,  -2.117442302178637e-09,   4.082214236925231e-10,
  -1.221124439031817e-11,   1.038124220344278e-13,   5.796132300828114e-15,  -2.761977610105774e-16,   4.889734629630747e-18,   4.709678761785718e-20,  -5.261293735751009e-21,
   1.313313817082279e-22,  -2.006296580989901e-25,  -6.296548442223758e-05,   2.726508201394585e-06,  -5.135675277916052e-08,  -2.391950078985659e-10,   4.611194999898330e-11,
  -1.379341400042515e-12,   1.172556581142210e-14,   6.547375241581507e-16,  -3.119844598637698e-17,   5.523015452669050e-19,   5.320903200413139e-21,  -5.943056304591535e-22,
   1.483407020046334e-23,  -2.263347971098071e-26,  -1.857562014786348e-02,   2.929482613030313e-04,   1.113404946110377e-05,  -3.702891366668383e-07,  -4.507682915311524e-09,
   3.552682850105095e-10,  -5.407337795498177e-13,  -2.892433734358683e-13,   3.913080723118963e-15,   1.976752741081709e-16,  -5.755990141192800e-18,  -9.530532363225163e-20,
   5.825686852546880e-21,   9.880086531020927e-24,  -1.767176602958169e-02,   2.786663373732467e-04,   1.059168098491729e-05,  -3.521730824429025e-07,  -4.288656576690492e-09,
   3.378083268673918e-10,  -5.112184079105155e-13,  -2.749639829338643e-13,   3.715138560928254e-15,   1.879046851668431e-16,  -5.464721956288029e-18,  -9.064501058909083e-20,
   5.530088792872702e-21,   9.526906511649075e-24,  -1.595266742212905e-02,   2.515138577457002e-04,   9.560361826807536e-06,  -3.177570779458857e-07,  -3.871948743575986e-09,
   3.046706889098581e-10,  -4.563918319256237e-13,  -2.478887549096549e-13,   3.341743514319106e-15,   1.693832209527880e-16,  -4.915320820905994e-18,  -8.179017733005161e-20,
   4.972839152929231e-21,   8.802268752175594e-24,  -1.358679113981872e-02,   2.141675556336846e-04,   8.141506846785014e-06,  -2.704703837286668e-07,  -3.298217390201753e-09,
   2.592023482724605e-10,  -3.834706447381837e-13,  -2.107890089708697e-13,   2.833825369372177e-15,   1.440132916254453e-16,  -4.168067870734743e-18,  -6.962157327371143e-20,
   4.215529480781704e-21,   7.703476619775862e-24,  -1.080586580488113e-02,   1.702970869851964e-04,   6.474345538279017e-06,  -2.149863391670484e-07,  -2.623528023484602e-09,
   2.059302212907641e-10,  -3.009503294108988e-13,  -1.673855733354694e-13,   2.244316149008913e-15,   1.143443657411576e-16,  -3.300877593916302e-18,  -5.534121763904045e-20,
   3.337452760910125e-21,   6.285007593075169e-24,  -7.882134628965863e-03,   1.241994589167192e-04,   4.722136990765501e-06,  -1.567445779832622e-07,  -1.913908032073077e-09,
   1.500833521249497e-10,  -2.171585181547108e-13,  -1.219439280497678e-13,   1.631512650370152e-15,   8.329325703988402e-17,  -2.399511672899048e-18,  -4.034954320805509e-20,
   2.425505370637167e-21,   4.676818719709734e-24,  -5.101716069454218e-03,   8.037938968471228e-05,   3.056212469664866e-06,  -1.014217457581273e-07,  -1.238873929786826e-09,
   9.708658478610312e-11,  -1.395465879489313e-13,  -7.886317464694151e-14,   1.053622954194430e-15,   5.386325357102487e-17,  -1.549562744639639e-18,  -2.610846002052088e-20,
   1.566095118816655e-21,   3.066356800193227e-24,  -2.736659806742224e-03,   4.311465091527964e-05,   1.639358591108248e-06,  -5.439598650294391e-08,  -6.645824395863842e-10,
   5.206400218607552e-11,  -7.457772272662149e-14,  -4.228581515663419e-14,   5.645304006385569e-16,   2.887997888816756e-17,  -8.302463020270380e-19,  -1.400292307202633e-20,
   8.390343095273810e-22,   1.655640488890236e-24,  -1.018381268001762e-03,   1.604375363738812e-05,   6.100404568764906e-07,  -2.024102567998756e-08,  -2.473115711386508e-10,
   1.937239030759708e-11,  -2.771631995266608e-14,  -1.573331431729773e-14,   2.099916357549987e-16,   1.074525549899980e-17,  -3.088304473857179e-19,  -5.210565693551762e-21,
   3.120903027169589e-22,   6.175013724904910e-25,  -1.150340046137754e-04,   1.812259878173722e-06,   6.890864255542215e-08,  -2.286359692290299e-09,  -2.793580706495471e-11,
   2.188225507890137e-12,  -3.130127190698352e-15,  -1.777157370873462e-15,   2.371865576535598e-17,   1.213728415556816e-18,  -3.488252772187108e-20,  -5.885684705478558e-22,
   3.525056733986107e-23,   6.977653012511237e-26,  -1.869515560667027e-02,  -2.626886151149806e-04,   1.130246406859456e-05,   3.380630067055198e-07,  -4.743938853588530e-09,
  -3.232662341357206e-10,  -1.426477633911413e-13,   2.576004833700177e-13,   3.247100312377048e-15,  -1.704922119472439e-16,  -4.805887602097668e-18,   8.543859631681023e-20,
   4.840711745218013e-21,  -1.692872631406201e-23,  -1.778548229885073e-02,  -2.498813864093528e-04,   1.075186213630839e-05,   3.215238959043601e-07,  -4.513245515588579e-09,
  -3.073824853574247e-10,  -1.330426372847041e-13,   2.448891947046808e-13,   3.082807198211296e-15,  -1.620600989432610e-16,  -4.562741820882062e-18,   8.124250486356672e-20,
   4.595144209422233e-21,  -1.618491940328959e-23,  -1.605531694683690e-02,  -2.255327817991363e-04,   9.704899011326101e-06,   2.901035655336108e-07,  -4.074417369725273e-09,
  -2.772349766473013e-10,  -1.158637487985646e-13,   2.207848699882225e-13,   2.772902615518068e-15,  -1.460779840094716e-16,  -4.104093252849145e-18,   7.327720596319316e-20,
   4.132189335462893e-21,  -1.473699318373021e-23,  -1.367421249631883e-02,  -1.920434306825920e-04,   8.264544872748804e-06,   2.469326050232048e-07,  -3.470378591580714e-09,
  -2.358667106335782e-10,  -9.432754186416313e-14,   1.877513589880043e-13,   2.351378777345825e-15,  -1.241903701659585e-16,  -3.480240504218398e-18,   6.234545741978259e-20,
   3.502987201811055e-21,  -1.268062690787821e-23,  -1.087539030922879e-02,  -1.527042308943780e-04,   6.572151390292453e-06,   1.962774665052907e-07,  -2.760235627640994e-09,
  -1.873949452113274e-10,  -7.166840966387468e-14,   1.490991636129526e-13,   1.862180642462960e-15,  -9.859889647088154e-17,  -2.756213004337077e-18,   4.953472851479510e-20,
   2.773396000328056e-21,  -1.018403347213122e-23,  -7.932845866959049e-03,  -1.113684059851216e-04,   4.793450897725252e-06,   1.431043367034667e-07,  -2.013500154488522e-09,
  -1.365772662310364e-10,  -5.031172930944367e-14,   1.086263491540000e-13,   1.353688364918370e-15,  -7.181987002890397e-17,  -2.003610960376806e-18,   3.610266335791563e-20,
   2.015613909549815e-21,  -7.486170268832847e-24,  -5.134538049697139e-03,  -7.207522041363040e-05,   3.102358158985978e-06,   9.259590997444140e-08,  -1.303280880997907e-09,
  -8.835079785123999e-11,  -3.172509990219723e-14,   7.025238287040309e-14,   8.741926450560943e-16,  -4.644217177504089e-17,  -1.293911126735475e-18,   2.335479890977744e-20,
   1.301453838697760e-21,  -4.869922156243114e-24,  -2.754265908760643e-03,  -3.866033585710881e-05,   1.664108656360457e-06,   4.966241245842615e-08,  -6.991166875390599e-10,
  -4.737961768719167e-11,  -1.678701516304157e-14,   3.766930253185917e-14,   4.683882586563272e-16,  -2.490056521088007e-17,  -6.932736166847315e-19,   1.252447015857339e-20,
   6.972574997793172e-22,  -2.619043965538946e-24,  -1.024932917893361e-03,  -1.438621510738864e-05,   6.192501528184681e-07,   1.847964193698757e-08,  -2.601607215623835e-10,
  -1.762942592688983e-11,  -6.216979952194730e-15,   1.401571327513506e-14,   1.742286318296522e-16,  -9.264594935005405e-18,  -2.578806071111927e-19,   4.660222779564674e-21,
   2.593550674559450e-22,  -9.754827036792074e-25,  -1.157740633358098e-04,  -1.625028611238548e-06,   6.994894076925983e-08,   2.087399639272344e-09,  -2.938718296431124e-11,
  -1.991348118946460e-12,  -7.017198937931955e-16,   1.583146874834877e-15,   1.967919918305410e-17,  -1.046479655161262e-18,  -2.912773108370885e-20,   5.263999075978160e-22,
   2.929413857606103e-23,  -1.102038558295429e-25,  -1.099625772120114e-02,  -4.273150798851638e-04,  -6.512465440447930e-06,   8.270960131587378e-08,   7.009088968684541e-09,
   1.620592291624399e-10,   2.070584079331641e-13,  -1.070296225160261e-13,  -3.519583345626367e-15,  -3.517762067269552e-17,   1.371517123253998e-18,   7.049374915800902e-20,
   1.155234414994974e-21,  -1.840872335020627e-23,  -1.046158789064899e-02,  -4.065228643387030e-04,  -6.194446496717212e-06,   7.873455293357021e-08,   6.668245729506771e-09,
   1.541096199479291e-10,   1.940678140271074e-13,  -1.018605267508727e-13,  -3.346536626066227e-15,  -3.335172126327161e-17,   1.307035721706512e-18,   6.702138072401223e-20,
   1.095713400215346e-21,  -1.757536432935205e-23,  -9.444507441526374e-03,  -3.669767500734466e-04,  -5.590046753433103e-06,   7.115403509316493e-08,   6.019888573178312e-09,
   1.390157629866694e-10,   1.705468902613205e-13,  -9.201317031656517e-14,  -3.018131259476291e-15,  -2.992543368451836e-17,   1.183469518932682e-18,   6.043403799647778e-20,
   9.838534092585126e-22,  -1.596472958934093e-23,  -8.044465120383704e-03,  -3.125520739544084e-04,  -4.759147325267669e-06,   6.068251390566758e-08,   5.127435820964142e-09,
   1.182936179927759e-10,   1.404757300853961e-13,  -7.843023537074402e-14,  -2.567576455943895e-15,  -2.530015823818715e-17,   1.011629439860276e-18,   5.140145409683997e-20,
   8.325178069146923e-22,  -1.369872185891486e-23,  -6.398425358970277e-03,  -2.485794832717670e-04,  -3.783613997167992e-06,   4.832465005115251e-08,   4.078214262049814e-09,
   9.400012190407703e-11,   1.080366359380290e-13,  -6.242581548369937e-14,  -2.039767416380970e-15,  -1.997736868043141e-17,   8.073976510660767e-19,   4.082650153744115e-20,
   6.579336721910729e-22,  -1.097305068786917e-23,  -4.667498423744943e-03,  -1.813216786353923e-04,  -2.759040818279921e-06,   3.528624219424992e-08,   2.974924927576209e-09,
   6.851880163705918e-11,   7.664010940078183e-14,  -4.556376698177338e-14,  -1.486526711589992e-15,  -1.448732608651783e-17,   5.905966182342449e-19,   2.974815942509817e-20,
   4.774590388822206e-22,  -8.049845733685935e-24,  -3.021164123230691e-03,  -1.173605877163218e-04,  -1.785429331834312e-06,   2.285474842306957e-08,   1.925585024514557e-09,
   4.432837712266281e-11,   4.867971368160657e-14,  -2.950330193933709e-14,  -9.615799777825743e-16,  -9.340685161710727e-18,   3.829703280797419e-19,   1.924080365651468e-20,
   3.079846665331581e-22,  -5.229785145596047e-24,  -1.620645166172680e-03,  -6.295451157343885e-05,  -9.576394894295570e-07,   1.226405842240562e-08,   1.032938638011181e-09,
   2.377296805179019e-11,   2.585781748947133e-14,  -1.582948093254284e-14,  -5.156516035258577e-16,  -5.000543779352406e-18,   2.056270231508067e-19,   1.031735841175980e-20,
   1.649195213209377e-22,  -2.810726388120149e-24,  -6.030880049445312e-04,  -2.342698859052054e-05,  -3.563493077766113e-07,   4.564330854107158e-09,   3.843851899273973e-10,
   8.845800732605290e-12,   9.589341769976664e-15,  -5.890987329876416e-15,  -1.918666280746330e-16,  -1.859537880061360e-18,   7.654423314981917e-20,   3.838863150940620e-21,
   6.133329568589075e-23,  -1.046638064709960e-24,  -6.812351201324351e-05,  -2.646258740739092e-06,  -4.025216665756895e-08,   5.155863537228978e-10,   4.341930673193417e-11,
   9.991882082468825e-13,   1.082598212549091e-15,  -6.654401090775207e-16,  -2.167244435860797e-17,  -2.100259503709167e-19,   8.646711094207038e-21,   4.336203554333698e-22,
   6.927396038707544e-24,  -1.182382773082514e-25,  -2.515969726826410e-03,  -1.358053634436532e-04,  -4.660243522388100e-06,  -1.243335420894853e-07,  -2.680361274553440e-09,
  -4.418357928015158e-11,  -3.819592042903340e-13,   8.033432290772685e-15,   5.344006346626130e-16,   1.755214685134190e-17,   4.233961086792599e-19,   8.137795592493012e-21,
   8.301820693845996e-23,  -2.158527771240106e-24,  -2.393731383795389e-03,  -1.292108602956485e-04,  -4.434046274803967e-06,  -1.182990376235065e-07,  -2.550156234907468e-09,
  -4.202937089755010e-11,  -3.629324741118045e-13,   7.661560291756873e-15,   5.089749486591503e-16,   1.671166210750609e-17,   4.029616031854937e-19,   7.736878816185045e-21,
   7.868698935394201e-23,  -2.059864222548019e-24,  -2.161163658995475e-03,  -1.166628540902702e-04,  -4.003599085363097e-06,  -1.068153933131899e-07,  -2.302422719335028e-09,
  -3.793388133895266e-11,  -3.269229570368763e-13,   6.946564982639539e-15,   4.603819585401270e-16,   1.510756501377891e-17,   3.640271854233123e-19,   6.976338830741129e-21,
   7.056727332696064e-23,  -1.869634619356956e-24,  -1.840951923821197e-03,  -9.938324771627934e-05,  -3.410762275747428e-06,  -9.099917131070114e-08,  -1.961313637482487e-09,
  -3.230093054208223e-11,  -2.777126211799363e-13,   5.947600885738146e-15,   3.930523065797676e-16,   1.288925571642653e-17,   3.103119956863111e-19,   5.933538361985237e-21,
   5.962209659927794e-23,  -1.602830228531311e-24,  -1.464381521124999e-03,  -7.905876335248168e-05,  -2.713363390725890e-06,  -7.239299879788099e-08,  -1.560147726491010e-09,
  -2.568409711218522e-11,  -2.203096498448444e-13,   4.754409989188021e-15,   3.133350668637457e-16,   1.026825400401003e-17,   2.470069979476514e-19,   4.712738691148680e-21,
   4.704788601548655e-23,  -1.282866343663194e-24,  -1.068302395886237e-03,  -5.767799401302217e-05,  -1.979629590320434e-06,  -5.281711013443883e-08,  -1.138180537045783e-09,
  -1.873152244373586e-11,  -1.603705334931007e-13,   3.482222296259602e-15,   2.289867855192107e-16,   7.500056591138858e-18,   1.802970328710811e-19,   3.433884498926051e-21,
   3.409999827969424e-23,  -9.405306544869622e-25,  -6.915179113872122e-04,  -3.733642265966532e-05,  -1.281495128415442e-06,  -3.419078185040749e-08,  -7.367564797628852e-10,
  -1.212259210400207e-11,  -1.036585644114128e-13,   2.259951123004689e-15,   1.483959892228714e-16,   4.858721724332152e-18,   1.167495662853250e-19,   2.220982601335830e-21,
   2.197783546578447e-23,  -6.108006649063729e-25,  -3.709598082270864e-04,  -2.002917089051698e-05,  -6.874681795286313e-07,  -1.834194455918497e-08,  -3.952293748272308e-10,
  -6.502409157759588e-12,  -5.556550893731710e-14,   1.213957593293631e-15,   7.965324119606830e-17,   2.607498724913970e-18,   6.264109639154381e-20,   1.190936543680377e-21,
   1.176359246345652e-23,  -3.282082005601522e-25,  -1.380457446705033e-04,  -7.453521681546908e-06,  -2.558309115737271e-07,  -6.825681791698697e-09,  -1.470774239944715e-10,
  -2.419663208556157e-12,  -2.067230239488776e-14,   4.519618368876563e-16,   2.964758605813283e-17,   9.704706861062662e-19,   2.331221567718237e-20,   4.431207590417557e-22,
   4.374198742213319e-24,  -1.222076080502104e-25,  -1.559336713045945e-05,  -8.419354136174371e-07,  -2.889818541320316e-08,  -7.710164278714072e-10,  -1.661357114034124e-11,
  -2.733186929781897e-13,  -2.335005219020793e-15,   5.105646072198238e-17,   3.349040923810110e-18,   1.096248880923889e-19,   2.633327533063363e-21,   5.005287469808571e-23,
   4.940396301440368e-25,  -1.380559745142895e-26,  -1.098748336853531e-03,   6.155200336193086e-05,  -2.256732079927868e-06,   6.717344233402495e-08,  -1.739835644849073e-09,
   4.013874304052178e-11,  -8.259461718020137e-13,   1.472545915127985e-14,  -2.080118473758395e-16,   1.348688865557891e-18,   4.471955592820389e-20,  -2.559442702000440e-21,
   9.366891551482448e-23,  -2.250555099998164e-24,  -1.045372406688590e-03,   5.856410780650843e-05,  -2.147275141190764e-06,   6.391806547999834e-08,  -1.655578456919507e-09,
   3.819558151273227e-11,  -7.859446818568438e-13,   1.401062223585490e-14,  -1.978327453353668e-16,   1.278852972480926e-18,   4.272901928890589e-20,  -2.440177842342051e-21,
   8.918826691204747e-23,  -2.141702049694221e-24,  -9.438179113531187e-04,   5.287834977906434e-05,  -1.938949255387749e-06,   5.772111282925748e-08,  -1.495161893507641e-09,
   3.449573048473770e-11,  -7.097870188744319e-13,   1.265034045434573e-14,  -1.784955289229421e-16,   1.147726717103640e-18,   3.886795461297937e-20,  -2.211199989562829e-21,
   8.063498104507617e-23,  -1.934403397133726e-24,  -8.039869171302657e-04,   4.504783703431205e-05,  -1.651968069670121e-06,   4.918231632050075e-08,  -1.274076745922483e-09,
   2.939607316902443e-11,  -6.048287367681365e-13,   1.077695256542919e-14,  -1.519281423490704e-16,   9.705731936606493e-19,   3.340834480181559e-20,  -1.891921452967356e-21,
   6.880301460097831e-23,  -1.648598753658871e-24,  -6.395383288936297e-04,   3.583651677279491e-05,  -1.314290905426684e-06,   3.913242454900737e-08,  -1.013807414338591e-09,
   2.339188761418745e-11,  -4.812705008392559e-13,   8.573243967638559e-15,  -1.207576015516481e-16,   7.665455237855860e-19,   2.680592529367662e-20,  -1.511371486510807e-21,
   5.481842062017601e-23,  -1.312001391816014e-24,  -4.665639904004626e-04,   2.614556440287148e-05,  -9.589464317464622e-07,   2.855420963913704e-08,  -7.398006176564144e-10,
   1.707015299466574e-11,  -3.511930549330836e-13,   6.254822575478652e-15,  -8.804058571080702e-17,   5.559776495399242e-19,   1.969163183357952e-20,  -1.106371658782822e-21,
   4.004384692575462e-23,  -9.575068648158135e-25,  -3.020115405683020e-04,   1.692499601790702e-05,  -6.207905950527293e-07,   1.848592141938536e-08,  -4.789638261485545e-10,
   1.105182397577093e-11,  -2.273695028683667e-13,   4.048962983980044e-15,  -5.696553054383248e-17,   3.585009638913710e-19,   1.280472349559568e-20,  -7.177811171460809e-22,
   2.594304776946592e-23,  -6.199577859296163e-25,  -1.620125102451062e-04,   9.079521271180533e-06,  -3.330350103969204e-07,   9.917363368716700e-09,  -2.569606365620090e-10,
   5.929283489781732e-12,  -1.219818438224733e-13,   2.172087129224777e-15,  -3.055223212481105e-17,   1.919329739581876e-19,   6.885047119216195e-21,  -3.854950421743478e-22,
   1.392314775333569e-23,  -3.326155968970189e-25,  -6.028999795589426e-05,   3.378803436921216e-06,  -1.239348608149317e-07,   3.690654783438810e-09,  -9.562618869763138e-11,
   2.206551068163847e-12,  -4.539469726946869e-14,   8.083080145091475e-16,  -1.136859621592103e-17,   7.137472471874955e-20,   2.564219894575739e-21,  -1.435125968189491e-22,
   5.182040061203798e-24,  -1.237823287394064e-25,  -6.810237175281641e-06,   3.816633098933101e-07,  -1.399946831972412e-08,   4.168905540769924e-10,  -1.080179576352050e-11,
   2.492489510001123e-13,  -5.127718655868107e-15,   9.130494865652117e-17,  -1.284158408794933e-18,   8.061455984055356e-21,   2.896863344471444e-22,  -1.621192838280180e-23,
   5.853670930836217e-25,  -1.398230216496723e-26,  -8.535352610548058e-03,   3.736627183725935e-04,  -8.184216487658134e-06,   4.856932524033880e-08,   3.588435479985141e-09,
  -1.568927339709660e-10,   3.105706742216152e-12,  -4.646747915573053e-15,  -1.920196869591020e-15,   7.009631153066421e-17,  -1.186712371539872e-18,  -6.083679475741814e-21,
   1.096768858944282e-21,  -3.088929187944509e-23,  -8.120432612548901e-03,   3.554918826879662e-04,  -7.785490021783275e-06,   4.616024535484435e-08,   3.415271621283384e-09,
  -1.492639675992387e-10,   2.953036720894576e-12,  -4.345780051768278e-15,  -1.828367869092711e-15,   6.667617455621464e-17,  -1.126832501771874e-18,  -5.858922221882136e-21,
   1.043940898704252e-21,  -2.935199931485296e-23,  -7.331109340510152e-03,   3.209271693298839e-04,  -7.027328413307504e-06,   4.159686365559100e-08,   3.085332970839097e-09,
  -1.347520911311777e-10,   2.663292612197302e-12,  -3.803784098053183e-15,  -1.653056592421259e-15,   6.017484669952280e-17,  -1.013809862586798e-18,  -5.402374847095129e-21,
   9.432396920377015e-22,  -2.644192811028855e-23,  -6.244508030085369e-03,   2.733495741073179e-04,  -5.984315264170303e-06,   3.535267182315328e-08,   2.630123803446204e-09,
  -1.147761366003222e-10,   2.265759103599488e-12,  -3.116871482394843e-15,  -1.410520193377884e-15,   5.123475928477798e-17,  -8.599467277218151e-19,  -4.717807470886264e-21,
   8.042219903273288e-22,  -2.246388832806858e-23,  -4.966889791397486e-03,   2.174145260592974e-04,  -4.758821830810111e-06,   2.805872619234785e-08,   2.093618058480914e-09,
  -9.129047119728385e-11,   1.800034609197080e-12,  -2.384124241741820e-15,  -1.123836453780353e-15,   4.073570890886477e-17,  -6.812228905995288e-19,  -3.842096751613771e-21,
   6.402804891060121e-22,  -1.782220430619768e-23,  -3.623297062478707e-03,   1.585969994300530e-04,  -3.470860928687410e-06,   2.043281658126086e-08,   1.528221566953474e-09,
  -6.659391902670270e-11,   1.311841168650872e-12,  -1.683360429723526e-15,  -8.209455355142150e-16,   2.970650943350560e-17,  -4.953110706550139e-19,  -2.855317487530441e-21,
   4.674281844317440e-22,  -1.297424974610224e-23,  -2.345306438889444e-03,   1.026554523350841e-04,  -2.246357619998407e-06,   1.321057061900961e-08,   9.896003332292192e-10,
  -4.310456796824907e-11,   8.485933986406637e-13,  -1.065738322874599e-15,  -5.318631815268682e-16,   1.922436466386834e-17,  -3.199082822107991e-19,  -1.870654581222935e-21,
   3.027078859886180e-22,  -8.386522400555116e-24,  -1.258102564755319e-03,   5.506733453614616e-05,  -1.204946121198679e-06,   7.082390232828792e-09,   5.309670384964804e-10,
  -2.312257244794247e-11,   4.550651693320031e-13,  -5.651219257118637e-16,  -2.854409489244428e-16,   1.031143921282715e-17,  -1.714170799541645e-19,  -1.009663588868310e-21,
   1.624236033218409e-22,  -4.495640753052093e-24,  -4.681766891107368e-04,   2.049209007592607e-05,  -4.483856622968873e-07,   2.635018664196434e-09,   1.976027845810048e-10,
  -8.604559220856293e-12,   1.693236864800524e-13,  -2.094466036082053e-16,  -1.062379142011642e-16,   3.837036022579616e-18,  -6.376434313616433e-20,  -3.765255690626043e-22,
   6.044783042431434e-23,  -1.672547481485421e-24,  -5.288424165632011e-05,   2.314741549371791e-06,  -5.064851084087092e-08,   2.976363185122176e-10,   2.232104868973422e-11,
  -9.719522352974050e-13,   1.912609618850608e-14,  -2.364337484056309e-17,  -1.200071328365298e-17,   4.334206994167545e-19,  -7.202237046970190e-21,  -4.254586985032872e-23,
   6.828152521423880e-24,  -1.889200208271243e-25,  -1.725486420408417e-02,   3.635437203737815e-04,   6.483274612646103e-06,  -3.887056852738814e-07,   1.906753125757281e-09,
   2.641271697880197e-10,  -6.157463885512550e-12,  -9.806093545916524e-14,   6.584675216828024e-15,  -4.056862628330891e-17,  -4.592596458223154e-18,   1.141864189969475e-19,
   1.808274752478799e-21,  -1.155553606667536e-22,  -1.641538867894798e-02,   3.458263160164881e-04,   6.168259456505613e-06,  -3.697205767672623e-07,   1.811282958922794e-09,
   2.512185170219939e-10,  -5.852516475850973e-12,  -9.333337529033188e-14,   6.258279333664180e-15,  -3.841117728592611e-17,  -4.365652069383350e-18,   1.083675308615582e-19,
   1.721307769807632e-21,  -1.097032601741516e-22,  -1.481868987064541e-02,   3.121398495908591e-04,   5.568928821226467e-06,  -3.336406191170868e-07,   1.630798855023717e-09,
   2.266897285845627e-10,  -5.274692717404918e-12,  -8.432361605321191e-14,   5.639929552912410e-15,  -3.438292095260123e-17,  -3.935422140791234e-18,   9.740772560178398e-20,
   1.555466778975947e-21,  -9.866646904919675e-23,  -1.262117477316960e-02,   2.658016181020550e-04,   4.743757541070974e-06,  -2.840425763757271e-07,   1.384534555592771e-09,
   1.929771171531341e-10,  -4.483685391352242e-12,  -7.188926520121928e-14,   4.793669590593229e-15,  -2.898421781771445e-17,  -3.346063748662284e-18,   8.253225644513976e-20,
   1.326410063464893e-21,  -8.365850163658180e-23,  -1.003803362889802e-02,   2.113621934924424e-04,   3.773378051718333e-06,  -2.258147235851894e-07,   1.097751135397102e-09,
   1.534068516559839e-10,  -3.559231875441196e-12,  -5.722983467523591e-14,   3.804930038739787e-15,  -2.282122401296826e-17,  -2.656782812715374e-18,   6.530906800890669e-20,
   1.056157594270791e-21,  -6.624633372905959e-23,  -7.322138075443046e-03,   1.541532886836120e-04,   2.752751591864328e-06,  -1.646631642983042e-07,   7.987385749480571e-10,
   1.118574067203972e-10,  -2.592258577120586e-12,  -4.177723320812281e-14,   2.770985214860162e-15,  -1.651140407192944e-17,  -1.935344912216872e-18,   4.744465044606701e-20,
   7.711086583662325e-22,  -4.815257770224543e-23,  -4.739293955345289e-03,   9.976687836042913e-05,   1.781861996704554e-06,  -1.065556109198958e-07,   5.161312657640235e-10,
   7.238166031509964e-11,  -1.676150250810865e-12,  -2.705397554471706e-14,   1.791620121095300e-15,  -1.062934751169151e-17,  -1.251542622661287e-18,   3.062582704417741e-20,
   4.994024738356453e-22,  -3.109435951692457e-23,  -2.542259437786519e-03,   5.351443731376523e-05,   9.558645510603370e-07,  -5.715224708808649e-08,   2.766280549080650e-10,
   3.882194156408299e-11,  -8.986541267409094e-13,  -1.451602719211547e-14,   9.605362596291440e-16,  -5.685921890552662e-18,  -6.710458272457564e-19,   1.640551793475007e-20,
   2.679717945358951e-22,  -1.665968453111767e-23,  -9.460411904872776e-04,   1.991377557717599e-05,   3.557067648248510e-07,  -2.126700588264487e-08,   1.029099846329312e-10,
   1.444599326278190e-11,  -3.343519586972503e-13,  -5.402270771516767e-15,   3.573723537128933e-16,  -2.113823306690652e-18,  -2.496737157972015e-19,   6.101965737694300e-21,
   9.972983559641482e-23,  -6.196914581671065e-24,  -1.068626589219059e-04,   2.249408558280031e-06,   4.017990835707653e-08,  -2.402257521353289e-09,   1.162393006759025e-11,
   1.631774570138683e-12,  -3.776654745287881e-14,  -6.102367646758149e-16,   4.036674326919970e-17,  -2.387358052915134e-19,  -2.820185786104678e-20,   6.892111728107118e-22,
   1.126544365344956e-23,  -6.999429505146891e-25,  -1.954183334282016e-02,  -1.578120567880292e-04,   1.469687178718844e-05,   2.128312416174958e-07,  -1.062668165397777e-08,
  -2.351393285937421e-10,   7.398865095304793e-12,   2.372776388329386e-13,  -4.895285938998450e-15,  -2.302972335240676e-16,   2.783958057740510e-18,   2.114416422414213e-19,
  -1.028183659050874e-21,  -1.742574256914182e-22,  -1.859087797130511e-02,  -1.501171775467696e-04,   1.398012354755187e-05,   2.024096052428409e-07,  -1.010651235727861e-08,
  -2.235550839294622e-10,   7.034928057698815e-12,   2.254922413271416e-13,  -4.653469623334978e-15,  -2.187535751011237e-16,   2.646523755494462e-18,   2.007583966341821e-19,
  -9.785575379899627e-22,  -1.653803287493242e-22,  -1.678222990206618e-02,  -1.354883169491550e-04,   1.261755537415059e-05,   1.826147645789312e-07,  -9.118428823384421e-09,
  -2.015804947722978e-10,   6.344330596743700e-12,   2.031748151653907e-13,  -4.195018515350535e-15,  -1.969361042202645e-16,   2.385928887417343e-18,   1.806009670605809e-19,
  -8.839962338834675e-22,  -1.486597146515474e-22,  -1.429318161670370e-02,  -1.153682800270820e-04,   1.074362947436002e-05,   1.554242966130876e-07,  -7.761038930067052e-09,
  -1.714511073267047e-10,   5.397003513639064e-12,   1.726503913802222e-13,  -3.566940469025139e-15,  -1.671772515109317e-16,   2.028843116987574e-18,   1.531720356779946e-19,
  -7.535305037215561e-22,  -1.259634114490839e-22,  -1.136756297354652e-02,  -9.173455979645068e-05,   8.542580311253987e-06,   1.235292570532873e-07,  -6.168606904543857e-09,
  -1.361784680739710e-10,   4.287396685799540e-12,   1.370101854511857e-13,  -2.832288561671264e-15,  -1.325344681748473e-16,   1.611080834158531e-18,   1.213247182037941e-19,
  -5.997778497518014e-22,  -9.968203805694555e-23,  -8.291789224089611e-03,  -6.690211537838370e-05,   6.230014780920734e-06,   9.005733675638216e-08,  -4.497275515510628e-09,
  -9.922700631761641e-11,   3.124450899752948e-12,   9.976211914665767e-14,  -2.063272879948195e-15,  -9.642546712375172e-17,   1.173701829195713e-18,   8.820718163101787e-20,
  -4.377716436792599e-22,  -7.241871430720856e-23,  -5.366837532780716e-03,  -4.329733256118480e-05,   4.031863615006530e-06,   5.826882459849129e-08,  -2.909881615672184e-09,
  -6.417952357353804e-11,   2.021058976602555e-12,   6.449532373083499e-14,  -1.334306233460862e-15,  -6.230498886621907e-17,   7.590499685873119e-19,   5.696800494465143e-20,
  -2.834635507278656e-22,  -4.674827503778188e-23,  -2.878868489800741e-03,  -2.322412749591272e-05,   2.162627737556073e-06,   3.125079336179101e-08,  -1.560646561083302e-09,
  -3.441469738775310e-11,   1.083792916282838e-12,   3.457569182864292e-14,  -7.154316217232822e-16,  -3.339231325556320e-17,   4.069958122716549e-19,   3.052458923417379e-20,
  -1.520868801381278e-22,  -2.504236180674695e-23,  -1.071299776211635e-03,  -8.642111290106592e-06,   8.047507788211502e-07,   1.162847818160248e-08,  -5.807215507702685e-10,
  -1.280497917117340e-11,   4.032627788135741e-13,   1.286380101114702e-14,  -2.661894965692307e-16,  -1.242234305511972e-17,   1.514311182344079e-19,   1.135456043367513e-20,
  -5.659948881514351e-23,  -9.314462226351581e-24,  -1.210115398152349e-04,  -9.761897443482029e-07,   9.090246560080441e-08,   1.313512816788895e-09,  -6.559634197284726e-11,
  -1.446392089624928e-12,   4.555084064489741e-14,   1.453016964383253e-15,  -3.006741901495958e-17,  -1.403131311505975e-18,   1.710490810866003e-20,   1.282505772891453e-21,
  -6.393420718946419e-24,  -1.052060603333597e-24,  -1.280042040948945e-02,  -4.732962118376227e-04,  -4.742601990737141e-06,   2.197966380098639e-07,   9.988392083790076e-09,
   1.177134784951305e-10,  -4.442430106570867e-12,  -2.225136670184864e-13,  -2.945708433253874e-15,   9.164909461857977e-17,   4.983483734225817e-18,   6.873049740053153e-20,
  -1.988345024450949e-21,  -1.032868602167197e-22,  -1.217794211616109e-02,  -4.502552578610656e-04,  -4.510143409761542e-06,   2.091402271799612e-07,   9.500563068373619e-09,
   1.118494007130300e-10,  -4.228762987787535e-12,  -2.115916844648655e-13,  -2.795793270756123e-15,   8.730135945244048e-17,   4.737148986689852e-18,   6.514963389548908e-20,
  -1.894789122125423e-21,  -9.813641206135709e-23,  -1.099386172660894e-02,  -4.064367496752666e-04,  -4.068703604440314e-06,   1.888564214249432e-07,   8.573464626730983e-09,
   1.007516226933975e-10,  -3.821355114026046e-12,  -1.908568525313295e-13,  -2.513341777631007e-15,   7.898618549248337e-17,   4.270183950978254e-18,   5.843548544582169e-20,
  -1.715527315271366e-21,  -8.839074417434621e-23,  -9.364005765475686e-03,  -3.461412447273390e-04,  -3.462514604287251e-06,   1.609108596163239e-07,   7.298990209822579e-09,
   8.558603719974100e-11,  -3.258696447041414e-12,  -1.623955473377540e-13,  -2.129816510645618e-15,   6.745404387572828e-17,   3.630555884661929e-18,   4.938204197853296e-20,
  -1.466282658345424e-21,  -7.507636005516408e-23,  -7.447857142301359e-03,  -2.752792525471262e-04,  -2.751669210849156e-06,   1.280244099705667e-07,   5.802741757450706e-09,
   6.789592518605392e-11,  -2.594845363410316e-12,  -1.290359367886700e-13,  -1.685572607174334e-15,   5.378751324174754e-17,   2.882557762280607e-18,   3.897618735312601e-20,
  -1.170134962605950e-21,  -5.955071899183413e-23,  -5.432970646971804e-03,  -2.007888494410810e-04,  -2.005894199980871e-06,   9.341348689819030e-08,   4.231346956992980e-09,
   4.942409318127914e-11,  -1.894598016310902e-12,  -9.405178324710100e-14,  -1.224626730766147e-15,   3.931614142614316e-17,   2.099741864436651e-18,   2.825534139410240e-20,
  -8.558498882805623e-22,  -4.334441340583469e-23,  -3.516609618184799e-03,  -1.299571019627205e-04,  -1.297777792512127e-06,   6.047411033064813e-08,   2.738162543800520e-09,
   3.194645919430539e-11,  -1.227063853750855e-12,  -6.084465160829885e-14,  -7.905535675503213e-16,   2.548229834729045e-17,   1.357823299783995e-18,   1.821347477071456e-20,
  -5.549354921304992e-22,  -2.801453360433724e-23,  -1.886409890849171e-03,  -6.971052898143723e-05,  -6.960049765840253e-07,   3.244284301375997e-08,   1.468644090559155e-09,
   1.712477335126855e-11,  -6.584367250155919e-13,  -3.262987046846594e-14,  -4.234936918621645e-16,   1.367879853358050e-17,   7.280221273775851e-19,   9.749466824121154e-21,
  -2.979490698491636e-22,  -1.501646521306275e-23,  -7.019856279158913e-04,  -2.594094659241671e-05,  -2.589820872887208e-07,   1.207324774334859e-08,   5.464994400506442e-10,
   6.371022211148599e-12,  -2.450491190038223e-13,  -1.214132489161075e-14,  -1.575184453367577e-16,   5.091473660119936e-18,   2.708715486218626e-19,   3.625359732884755e-21,
  -1.109095230723020e-22,  -5.586576360922532e-24,  -7.929475555599871e-05,  -2.930227334658731e-06,  -2.925367636124465e-08,   1.363774065280566e-09,   6.173094858125131e-11,
   7.196283164019292e-13,  -2.768068524087185e-14,  -1.371436646280818e-15,  -1.779158733704249e-17,   5.751434069123037e-19,   3.059623539258272e-20,   4.094644952780177e-22,
  -1.252871227635227e-23,  -6.310210791656055e-25,  -3.144325639264573e-03,  -1.798542241074677e-04,  -6.440023704527541e-06,  -1.746667569800175e-07,  -3.624534395914809e-09,
  -4.799995086103400e-11,   2.049852040076783e-13,   3.925911566207407e-14,   1.563468193931563e-15,   4.214334845787845e-17,   7.939166308095785e-19,   6.020963528877158e-21,
  -2.641944846534850e-22,  -1.313471887370668e-23,  -2.991577017612278e-03,  -1.711216611307562e-04,  -6.127425134737463e-06,  -1.661851025525377e-07,  -3.448139424044714e-09,
  -4.564049392835937e-11,   1.963222013565475e-13,   3.739470971635506e-14,   1.488478394826220e-15,   4.010303232058734e-17,   7.547721453908228e-19,   5.697406272544150e-21,
  -2.522145226367251e-22,  -1.251327166804094e-23,  -2.700953694334393e-03,  -1.545049981191309e-04,  -5.532564607084157e-06,  -1.500462576478309e-07,  -3.112654627100455e-09,
  -4.116254969500148e-11,   1.793139644665590e-13,   3.383005347532439e-14,   1.345408386455400e-15,   3.621816875916153e-17,   6.805271831467403e-19,   5.094383796601904e-21,
  -2.290744122941242e-22,  -1.132412006201163e-23,  -2.300793395484655e-03,  -1.316218267341367e-04,  -4.713299970125639e-06,  -1.278218473423250e-07,  -2.650974627707710e-09,
  -3.501863457203139e-11,   1.548748605875036e-13,   2.888814076063643e-14,   1.147654829290783e-15,   3.086351939107713e-17,   5.787516764755755e-19,   4.288531232571657e-21,
  -1.965396458456713e-22,  -9.673652770130322e-24,  -1.830184782638138e-03,  -1.047054759021308e-04,  -3.749551852779754e-06,  -1.016813284324742e-07,  -2.108333676933941e-09,
  -2.782070607474227e-11,   1.248401439909823e-13,   2.303350585627654e-14,   9.141265599944539e-16,   2.455924470243110e-17,   4.596349758927701e-19,   3.371834743031032e-21,
  -1.574239500351267e-22,  -7.716024438030049e-24,  -1.335178568989090e-03,  -7.638942984188583e-05,  -2.735605939103618e-06,  -7.418237344522343e-08,  -1.537858265002304e-09,
  -2.027542003319577e-11,   9.204142256112550e-14,   1.683553626785281e-14,   6.675980479238231e-16,   1.792177054968375e-17,   3.348834956020604e-19,   2.436610427868488e-21,
  -1.154838665557221e-22,  -5.641445921584261e-24,  -8.642741513841005e-04,  -4.944908921619318e-05,  -1.770864641532236e-06,  -4.802007679103043e-08,  -9.953683852271508e-10,
  -1.311562660770750e-11,   5.999289713689832e-14,   1.091143257127078e-14,   4.324476200363205e-16,   1.160306706321997e-17,   2.165868636264373e-19,   1.567287009600870e-21,
  -7.502688687289422e-23,  -3.657047171985703e-24,  -4.636352621812924e-04,  -2.652710360582649e-05,  -9.499929746150841e-07,  -2.576041705239785e-08,  -5.339318529906820e-10,
  -7.033368529612798e-12,   3.229683624672835e-14,   5.857133499567440e-15,   2.320681672181536e-16,   6.224987765736427e-18,   1.161354158871711e-19,   8.380187559431722e-22,
  -4.032301946893586e-23,  -1.963258825784768e-24,  -1.725333878581223e-04,  -9.871628935743962e-06,  -3.535253792762720e-07,  -9.586307515162402e-09,  -1.986893235057518e-10,
  -2.617023501699745e-12,   1.203344026625655e-14,   2.180111356783243e-15,   8.637079687432320e-17,   2.316590943437851e-18,   4.321100339703680e-20,   3.114978541836972e-22,
  -1.501522212948917e-23,  -7.307793688587749e-25,  -1.948902504868492e-05,  -1.115080318701700e-06,  -3.993356821732512e-08,  -1.082850750191361e-09,  -2.244348148387127e-11,
  -2.956080546657577e-13,   1.359537883869016e-15,   2.462697161421145e-16,   9.756466622855839e-18,   2.616788144943587e-19,   4.880908616955546e-21,   3.517979920182674e-23,
  -1.696264071839218e-24,  -8.255074855992649e-26,  -8.841385425581653e-04,   4.630389342553789e-05,  -1.594320325944985e-06,   4.480855194401852e-08,  -1.105556446247182e-09,
   2.456460483817943e-11,  -4.980155425187655e-13,   9.034711047004280e-15,  -1.450755053140031e-16,   1.846708799098973e-18,  -3.564008452200183e-21,  -2.727702069951522e-22,
   1.326959497664135e-23,  -8.932642164762268e-25,  -8.411814428048485e-04,   4.405566732134583e-05,  -1.516969812662389e-06,   4.263636962865003e-08,  -1.052004368305843e-09,
   2.337542428274058e-11,  -4.739126945127719e-13,   8.597232982260847e-15,  -1.380235339002196e-16,   1.756418340715609e-18,  -3.363962426785641e-21,  -2.615778169140471e-22,
   1.268281455485848e-23,  -8.500954472449704e-25,  -7.594528081591917e-04,   3.977765799198837e-05,  -1.369760072663707e-06,   3.850166031866183e-08,  -9.500518824056312e-10,
   2.111117377210444e-11,  -4.280172628221746e-13,   7.764297519325534e-15,  -1.246079879080222e-16,   1.584860342658539e-18,  -2.994141209263459e-21,  -2.394460623585604e-22,
   1.154282964334682e-23,  -7.678708918297083e-25,  -6.469254173324596e-04,   3.388632356860387e-05,  -1.166987457092162e-06,   3.280495438605985e-08,  -8.095510083954519e-10,
   1.799024938983454e-11,  -3.647524321794693e-13,   6.616304447848549e-15,  -1.061394395746570e-16,   1.349093686930933e-18,  -2.506007926170883e-21,  -2.073497470425893e-22,
   9.927528687719188e-24,  -6.544789610187204e-25,  -5.145939552351002e-04,   2.695664323504504e-05,  -9.284166479535016e-07,   2.610077106188613e-08,  -6.441602754998495e-10,
   1.431574563161009e-11,  -2.902596544968739e-13,   5.264789255927120e-15,  -8.442383542626280e-17,   1.072399606950350e-18,  -1.958849279297608e-21,  -1.675476496958326e-22,
   7.970116403262519e-24,  -5.208991894927674e-25,  -3.754080446706927e-04,   1.966661387845824e-05,  -6.773844055748869e-07,   1.904476195025633e-08,  -4.700510174332292e-10,
   1.044688514007619e-11,  -2.118209392690754e-13,   3.841887678064843e-15,  -6.158655017820047e-17,   7.819075089659292e-19,  -1.408627605850363e-21,  -1.237652713663775e-22,
   5.857441949194066e-24,  -3.801829296416487e-25,  -2.430032605948768e-04,   1.273076675111664e-05,  -4.385094853377713e-07,   1.232932000927188e-08,  -3.043179920199966e-10,
   6.763692291396912e-12,  -1.371425052883145e-13,   2.487342436313326e-15,  -3.986413393090918e-17,   5.059462199802329e-19,  -9.030555284678043e-22,  -8.077062552381564e-23,
   3.809958455608174e-24,  -2.461691517702757e-25,  -1.303572421522177e-04,   6.829455332777850e-06,  -2.352448736558056e-07,   6.614400041002776e-09,  -1.632633663722105e-10,
   3.628710703953959e-12,  -7.357728245713712e-14,   1.334445785872229e-15,  -2.138450307010959e-17,   2.713596138675816e-19,  -4.820201884374249e-22,  -4.350974662462531e-23,
   2.048893887073139e-24,  -1.320762798544052e-25,  -4.850999204919525e-05,   2.541470351923864e-06,  -8.754321909797656e-08,   2.461480142417047e-09,  -6.075723920153515e-11,
   1.350405508177123e-12,  -2.738146603654531e-14,   4.966056899152679e-16,  -7.957800126864821e-18,   1.009747059282732e-19,  -1.790613673816296e-22,  -1.621477221245855e-23,
   7.631139810673867e-25,  -4.915238522750995e-26,  -5.479589990387387e-06,   2.870796277093568e-07,  -9.888726669655282e-09,   2.780447877136206e-10,  -6.863047320352252e-12,
   1.525399397811563e-13,  -3.092973800439935e-15,   5.609586984068576e-17,  -8.988961942538168e-19,   1.140577783641850e-20,  -2.022078904148567e-23,  -1.832007830739751e-24,
   8.621157366307380e-26,  -5.552201567848139e-27,  -7.166862003530425e-03,   3.112835700163845e-04,  -7.347688410747011e-06,   8.478877747900497e-08,   1.158228083715639e-09,
  -8.885541296185108e-11,   2.429977269948989e-12,  -3.469236068826831e-14,  -2.131364092559677e-16,   2.763595073635331e-17,  -7.881176073208017e-19,   1.508164389219226e-20,
  -4.379879928211103e-23,  -1.174557815677588e-23,  -6.818481610183044e-03,   2.961501458803632e-04,  -6.990085169667094e-06,   8.063814052599065e-08,   1.102974428664934e-09,
  -8.455497552290360e-11,   2.311598908094856e-12,  -3.297516720082915e-14,  -2.038243615403594e-16,   2.631612728576431e-17,  -7.498586062106045e-19,   1.432073421613785e-20,
  -4.071363816109641e-23,  -1.118138853303112e-23,  -6.155734053450919e-03,   2.673616063469998e-04,  -6.309968166471085e-06,   7.275391489646407e-08,   9.974354579666625e-10,
  -7.636628516268732e-11,   2.086503232230043e-12,  -2.972092505659754e-14,  -1.856831310745810e-16,   2.379569513273165e-17,  -6.770524610896686e-19,   1.288448499225623e-20,
  -3.523437310566577e-23,  -1.010530078361118e-23,  -5.243368381242100e-03,   2.277316583570022e-04,  -5.374032069885693e-06,   6.192307125514702e-08,   8.513199781661439e-10,
  -6.507853632004068e-11,   1.776829029929114e-12,  -2.526525231029656e-14,  -1.598825890852903e-16,   2.030733066332658e-17,  -5.767815748512366e-19,   1.092917680171530e-20,
  -2.844620049723244e-23,  -8.618542565615054e-24,  -4.170600586905489e-03,   1.811363677433724e-04,  -4.273982040825713e-06,   4.921707395644143e-08,   6.784705783820931e-10,
  -5.178753107586934e-11,   1.412968570545352e-12,  -2.005698117642372e-14,  -1.284997016602030e-16,   1.618219014078455e-17,  -4.588317378406352e-19,   8.657850125438789e-21,
  -2.141845091378109e-23,  -6.863663498226718e-24,  -3.042422871235434e-03,   1.321361979841175e-04,  -3.117516091237168e-06,   3.588184771451171e-08,   4.957187697582001e-10,
  -3.779256637915065e-11,   1.030555738546434e-12,  -1.460841109505563e-14,  -9.452019377185281e-17,   1.182216802933338e-17,  -3.347462106601410e-19,   6.295100093934747e-21,
  -1.491554055601489e-23,  -5.011921455842560e-24,  -1.969319865412620e-03,   8.552937527706345e-05,  -2.017788601675546e-06,   2.321658160569191e-08,   3.212054780393841e-10,
  -2.446858150084467e-11,   6.669815622954942e-13,  -9.445981712728431e-15,  -6.151553030121590e-17,   7.659751737073841e-18,  -2.166898465116658e-19,   4.065860609758360e-21,
  -9.351582180366782e-24,  -3.246249599889937e-24,  -1.056411798859671e-03,   4.588076403479745e-05,  -1.082374065124052e-06,   1.245163189174005e-08,   1.723976244247878e-10,
  -1.312743955377376e-11,   3.577691197785360e-13,  -5.064439584170611e-15,  -3.309104796006722e-17,   4.110999549301321e-18,  -1.162435004975547e-19,   2.178624057706523e-21,
  -4.933067152210619e-24,  -1.741978354588654e-24,  -3.931218344809160e-04,   1.707355638802259e-05,  -4.027782266075965e-07,   4.633287178407819e-09,   6.416610707323242e-11,
  -4.885317865009618e-12,   1.331334039763495e-13,  -1.884274994921685e-15,  -1.232606279534965e-17,   1.530087915743745e-18,  -4.325806841410234e-20,   8.104131987684433e-22,
  -1.824932959919375e-24,  -6.483159139156072e-25,  -4.440620812343640e-05,   1.928592293082100e-06,  -4.549688532927786e-08,   5.233603627632447e-10,   7.248280428049549e-12,
  -5.518389440001504e-13,   1.503841324499468e-14,  -2.128374016817024e-16,  -1.392539427164771e-18,   1.728402211620479e-19,  -4.886347648251167e-21,   9.153687710335952e-23,
  -2.059468683670169e-25,  -7.323372727637359e-26,  -1.572530645791769e-02,   3.976170009710805e-04,   2.148590980511140e-06,  -3.244994696807929e-07,   5.602648096432745e-09,
   1.048521637249599e-10,  -6.364690197628456e-12,   6.436378081176904e-14,   3.115816378599863e-15,  -1.175219935689086e-16,   5.041982536471163e-19,   8.513322621128527e-20,
  -2.190741515253783e-21,  -2.479803347948169e-23,  -1.496035702414388e-02,   3.782478970462843e-04,   2.045075285273223e-06,  -3.086844142195432e-07,   5.327305068362466e-09,
   9.979171638903933e-11,  -6.052512209511141e-12,   6.110827709522829e-14,   2.964902037021010e-15,  -1.116670392524158e-16,   4.754319173060837e-19,   8.093413401005092e-20,
  -2.079094941013274e-21,  -2.364217628816393e-23,  -1.350536325469368e-02,   3.414174148493209e-04,   1.847772646404682e-06,  -2.786150944191374e-07,   4.804722697655206e-09,
   9.014997216047651e-11,  -5.459769362293219e-12,   5.496688241802698e-14,   2.677577962213359e-15,  -1.005867392593966e-16,   4.224530201028726e-19,   7.297047594623995e-20,
  -1.868809551929277e-21,  -2.142270432583484e-23,  -1.150278759168135e-02,   2.907473697803054e-04,   1.575426048633291e-06,  -2.372528730382233e-07,   4.087680279515623e-09,
   7.684794193262147e-11,  -4.645975055843102e-12,   4.661254813667721e-14,   2.281598473668387e-15,  -8.544540522116408e-17,   3.528899908396276e-19,   6.205514333476402e-20,
  -1.583396886075109e-21,  -1.832777644889938e-23,  -9.148683908504349e-03,   2.312099718852809e-04,   1.254273493816553e-06,  -1.886598908507532e-07,   3.247567583348764e-09,
   6.117099691370933e-11,  -3.691893924010925e-12,   3.691591102392293e-14,   1.815460549880948e-15,  -6.778397866091227e-17,   2.753415380397201e-19,   4.928149593003910e-20,
  -1.252947074583743e-21,  -1.463939740343654e-23,  -6.673493663247869e-03,   1.686355074835652e-04,   9.156716364152283e-07,  -1.375953434632349e-07,   2.366849193907936e-09,
   4.465062633248864e-11,  -2.691130988144657e-12,   2.683604106952612e-14,   1.324751780157966e-15,  -4.934240759478814e-17,   1.977253503605933e-19,   3.590487648466041e-20,
  -9.102065765082260e-22,  -1.071513059125632e-23,  -4.319490541456300e-03,   1.091424825777498e-04,   5.929962715870149e-07,  -8.905051252415891e-08,   1.531077553105859e-09,
   2.891320887973372e-11,  -1.741044088552354e-12,   1.733051683032724e-14,   8.576579458734034e-16,  -3.189358551476262e-17,   1.266472686781977e-19,   2.322120848087206e-20,
  -5.875376874365690e-22,  -6.950982488335177e-24,  -2.317077542471284e-03,   5.854423917321006e-05,   3.181848834793646e-07,  -4.776618232338503e-08,   8.210610322900664e-10,
   1.551320394890820e-11,  -9.337117434333587e-13,   9.285654776266011e-15,   4.601224550857420e-16,  -1.709641172732020e-17,   6.756996160994251e-20,   1.245127740104248e-20,
  -3.147278835094299e-22,  -3.732927504072686e-24,  -8.622463780598399e-04,   2.178556439961213e-05,   1.184164257084933e-07,  -1.777472997963800e-08,   3.055069346788972e-10,
   5.773326410682783e-12,  -3.474298124298976e-13,   3.454035380321619e-15,   1.712308627806974e-16,  -6.360468326844404e-18,   2.509712346350564e-20,   4.632787590845646e-21,
  -1.170615041286554e-22,  -1.389672184497666e-24,  -9.739741022598471e-05,   2.460842782104107e-06,   1.337625620424280e-08,  -2.007787381379594e-09,   3.450880605346951e-11,
   6.521500098926912e-13,  -3.924436551679244e-14,   3.901348889328862e-16,   1.934197862860820e-17,  -7.184361780562734e-19,   2.834063973194754e-21,   5.232973384684270e-22,
  -1.322197994713162e-23,  -1.569841009052405e-25,  -1.992621757713930e-02,  -3.319675611493910e-05,   1.611195902411085e-05,   1.668337226128836e-08,  -1.313543253673029e-08,
  -2.018918269907391e-12,   1.085205569941129e-11,  -1.446661024881085e-14,  -9.295970618548665e-15,   2.280636131598964e-17,   8.169657982021824e-18,  -1.435541071938510e-20,
  -6.750905486250896e-21,   6.608902482100003e-24,  -1.895652421400888e-02,  -3.158056816741008e-05,   1.532593669811972e-05,   1.587125988379928e-08,  -1.249171068423204e-08,
  -1.929635164271457e-12,   1.031653170461708e-11,  -1.373870070589804e-14,  -8.832988454117151e-15,   2.167372321322854e-17,   7.759190026779036e-18,  -1.364208980484117e-20,
  -6.408745373452176e-21,   6.268453026288070e-24,  -1.711225121773333e-02,  -2.850700038908943e-05,   1.383178212679714e-05,   1.432678181825369e-08,  -1.126923871588185e-08,
  -1.756163112070446e-12,   9.301037008792111e-12,  -1.236402484697157e-14,  -7.956767189934553e-15,   1.952883344684904e-17,   6.983792490196107e-18,  -1.229145764584861e-20,
  -5.763574903221433e-21,   5.628734518231852e-24,  -1.457420208248537e-02,  -2.427776904069172e-05,   1.177709317335892e-05,   1.220148129257055e-08,  -9.590445608658809e-09,
  -1.510351479786442e-12,   7.909389927087819e-12,  -1.049108873230820e-14,  -6.759304534143089e-15,   1.659506338197904e-17,   5.926903243836179e-18,  -1.044440466448071e-20,
  -4.886492460089807e-21,   4.763332967704959e-24,  -1.159102079812688e-02,  -1.930749265988528e-05,   9.363986912931328e-06,   9.703667946655745e-09,  -7.621703258691454e-09,
  -1.212492171400486e-12,   6.281065227641507e-12,  -8.313501512291189e-15,  -5.362393000327997e-15,   1.316947365805505e-17,   4.697506315442204e-18,  -8.288078668248950e-21,
  -3.869166202363116e-21,   3.764896001959653e-24,  -8.454760602619925e-03,  -1.408281771769960e-05,   6.828863550214774e-06,   7.077901472012369e-09,  -5.556111702259704e-09,
  -8.910435517315200e-13,   4.576063534029778e-12,  -6.046350494711509e-15,  -3.903621151009530e-15,   9.589240722173592e-18,   3.416959565035072e-18,  -6.034701179460199e-21,
  -2.812233995076147e-21,   2.732516203705945e-24,  -5.472309856364146e-03,  -9.114825985979096e-06,   4.419335977300061e-06,   4.581065586287427e-09,  -3.594744962281483e-09,
  -5.795531817177811e-13,   2.959492285614549e-12,  -3.905907566248245e-15,  -2.523257499539564e-15,   6.199384307807261e-18,   2.207552738662671e-18,  -3.901321531322653e-21,
  -1.815928831158265e-21,   1.762782929885819e-24,  -2.935442869448313e-03,  -4.889291377937296e-06,   2.370438871704116e-06,   2.457342295353351e-09,  -1.927891469972309e-09,
  -3.116610911331099e-13,   1.586877492396905e-12,  -2.093113349800943e-15,  -1.352598643220683e-15,   3.323472291692489e-18,   1.183052535172300e-18,  -2.091467909823768e-21,
  -9.729190582395960e-22,   9.439867553793314e-25,  -1.092352161019111e-03,  -1.819420463975745e-06,   8.820778913760309e-07,   9.144361096132271e-10,  -7.173660757150360e-10,
  -1.160777427875607e-13,   5.904333980444024e-13,  -7.786303033846568e-16,  -5.032167635690388e-16,   1.236490498147387e-18,   4.400989585267107e-19,  -7.781235509057218e-22,
  -3.618953154119102e-22,   3.510741356454480e-25,  -1.233895617301543e-04,  -2.055173661740313e-07,   9.963707337742931e-08,   1.032925278326808e-10,  -8.103109339496099e-11,
  -1.311367884229508e-14,   6.669248531847569e-14,  -8.794743309334710e-17,  -5.684005932845279e-17,   1.396664838470320e-19,   4.970996301794041e-20,  -8.789208387352757e-23,
  -4.087612353919034e-23,   3.965280785873160e-26,  -1.474877185357878e-02,  -4.978397738149110e-04,  -1.093365800556334e-06,   3.903956058439930e-07,   1.073506367008351e-08,
  -6.979358779198941e-11,  -1.119975988382960e-11,  -2.221114408576584e-13,   4.264857836918731e-15,   3.029772807149186e-16,   3.895395626505562e-18,  -1.604824801142518e-19,
  -7.013456305991267e-21,  -3.374423220918233e-23,  -1.403141642545206e-02,  -4.735899044058812e-04,  -1.038281396359770e-06,   3.713854634068981e-07,   1.020792583204913e-08,
  -6.653595672322134e-11,  -1.065142052823967e-11,  -2.109854079452512e-13,   4.062514210673773e-15,   2.879772677558097e-16,   3.692303084001458e-18,  -1.527492310247514e-19,
  -6.659546622278608e-21,  -3.169091497001110e-23,  -1.266691316882207e-02,  -4.274780500979299e-04,  -9.342792190600502e-07,   3.352345727741163e-07,   9.207276736462968e-09,
  -6.028355102542482e-11,  -9.609866094532620e-12,  -1.899538894907331e-13,   3.675535562422007e-15,   2.595523246486413e-16,   3.311568333184378e-18,  -1.380088686362686e-19,
  -5.991570077845570e-21,  -2.795473301470264e-23,  -1.078881207760175e-02,  -3.640379382019523e-04,  -7.926331695947323e-07,   2.854937716009398e-07,   7.833928785529340e-09,
  -5.156950080721024e-11,  -8.179104646324133e-12,  -1.612609842041469e-13,   3.138861588629477e-15,   2.206359382653311e-16,   2.798298095421950e-18,  -1.176619790017655e-19,
  -5.082253179472685e-21,  -2.313891571503467e-23,  -8.580942224461055e-03,  -2.894943096114900e-04,  -6.280161243105697e-07,   2.270410912299158e-07,   6.224429824899020e-09,
  -4.118877572648991e-11,  -6.500716353346661e-12,  -1.278520321872026e-13,   2.502882662609194e-15,   1.751495098239127e-16,   2.208489380958936e-18,  -9.367067486714469e-20,
  -4.026027489415208e-21,  -1.788799066552699e-23,  -6.259422978771293e-03,  -2.111468478468314e-04,  -4.566954608618446e-07,   1.656000933850173e-07,   4.536732066035591e-09,
  -3.014671480432037e-11,  -4.739293741460820e-12,  -9.302309219644228e-14,   1.829472014855438e-15,   1.275672533809145e-16,   1.600939056155735e-18,  -6.837930262129621e-20,
  -2.927314110359861e-21,  -1.274674432121923e-23,  -4.051507755539183e-03,  -1.366566588232850e-04,  -2.949982531803317e-07,   1.071801483484505e-07,   2.934879883464858e-09,
  -1.955619496756279e-11,  -3.066426854584849e-12,  -6.010831967594650e-14,   1.185743480187036e-15,   8.248571937585536e-17,   1.031937750203769e-18,  -4.428095057889973e-20,
  -1.890688818045931e-21,  -8.121862375528725e-24,  -2.173333162313910e-03,  -7.330301721104971e-05,  -1.580780668738292e-07,   5.749224734550024e-08,   1.573907346107432e-09,
  -1.050235779336589e-11,  -1.644592323736789e-12,  -3.221548123155741e-14,   6.365004286903263e-16,   4.422427984073956e-17,   5.523760625933395e-19,  -2.375929404169345e-20,
  -1.013095979706840e-21,  -4.321398416703424e-24,  -8.087562903642724e-04,  -2.727763719865422e-05,  -5.880356590049313e-08,   2.139417436809773e-08,   5.856369587887383e-10,
  -3.909754720363369e-12,  -6.119562586340332e-13,  -1.198460752600783e-14,   2.369156560219999e-16,   1.645405218045811e-17,   2.054011148761685e-19,  -8.842233839001894e-21,
  -3.768557091879125e-22,  -1.603531424674117e-24,  -9.135530879911683e-05,  -3.081213847790176e-06,  -6.641933073293137e-09,   2.416633753626511e-09,   6.615122973557247e-11,
  -4.416648233133989e-13,  -6.912447696411264e-14,  -1.353689182641583e-15,   2.676247828705847e-17,   1.858559241839340e-18,   2.319890987108381e-20,  -9.988125605876806e-22,
  -4.256618561211853e-23,  -1.810492934989416e-25,  -3.981540579433802e-03,  -2.408131768867688e-04,  -8.913484491264081e-06,  -2.395763698906002e-07,  -4.410307579926767e-09,
  -2.260776795658561e-11,   2.277837601176863e-12,   1.198654749064073e-13,   3.659277573944621e-15,   7.222063243267122e-17,   4.358740835140084e-19,  -3.279104798082173e-20,
  -1.603355938940906e-21,  -4.213031342236997e-23,  -3.788143286381516e-03,  -2.291213248160309e-04,  -8.480713861214338e-06,  -2.279297860546821e-07,  -4.194761284436578e-09,
  -2.143292098199037e-11,   2.170092118429375e-12,   1.141120983064406e-13,   3.481846339460018e-15,   6.865324030466401e-17,   4.115059513613226e-19,  -3.129390390373657e-20,
  -1.527255351078336e-21,  -4.009060351687785e-23,  -3.420171629799061e-03,  -2.068734114534412e-04,  -7.657216214815394e-06,  -2.057739982051560e-07,  -3.785183591433795e-09,
  -1.922872656751753e-11,   1.963909284627501e-12,   1.031371800623116e-13,   3.144119683186266e-15,   6.188960931947267e-17,   3.664371373164814e-19,  -2.840643527232568e-20,
  -1.381731917797120e-21,  -3.620668578240916e-23,  -2.913492376540558e-03,  -1.762349372419927e-04,  -6.523150692317150e-06,  -1.752740280430078e-07,  -3.222256178924604e-09,
  -1.625411091022225e-11,   1.677720489582592e-12,   8.797080398746515e-14,   2.678834014825603e-15,   5.262305171899051e-17,   3.068962320415095e-19,  -2.435511031962377e-20,
  -1.179944545235324e-21,  -3.085315018841851e-23,  -2.317589655680491e-03,  -1.401959205989502e-04,  -5.189194445862035e-06,  -1.394126975652495e-07,  -2.561520938984208e-09,
  -1.283228073189773e-11,   1.338243095211936e-12,   7.006494574028300e-14,   2.131303750594896e-15,   4.178405454267873e-17,   2.400628460394662e-19,  -1.949489026676109e-20,
  -9.408478467323044e-22,  -2.455027730289062e-23,  -1.690772816683837e-03,  -1.022823660875249e-04,  -3.785860788330627e-06,  -1.016998781240860e-07,  -1.867741735714469e-09,
  -9.304417528713263e-12,   9.784578508277457e-13,   5.116619542319049e-14,   1.555087834189788e-15,   3.043837880603122e-17,   1.727446903107224e-19,  -1.429350681259315e-20,
  -6.876986520870289e-22,  -1.791466686699375e-23,  -1.094460946351124e-03,  -6.621048871878737e-05,  -2.450700275209134e-06,  -6.582868449738180e-08,  -1.208592270042397e-09,
  -5.998389584757619e-12,   6.342919885990110e-13,   3.314241525555098e-14,   1.006722151659755e-15,   1.968401473021672e-17,   1.107966997471508e-19,  -9.282848743667481e-21,
  -4.457176239963636e-22,  -1.159818439264202e-23,  -5.871197135372990e-04,  -3.551884562932698e-05,  -1.314685899707034e-06,  -3.531271816965874e-08,  -6.482284383280973e-10,
  -3.211066654739970e-12,   3.405178310884907e-13,   1.778513937466533e-14,   5.400776897311354e-16,   1.055413104567388e-17,   5.915443638066051e-20,  -4.988143171681595e-21,
  -2.392579288877667e-22,  -6.222282805953992e-24,  -2.184861246199017e-04,  -1.321776449439597e-05,  -4.892390190608867e-07,  -1.314088811692331e-08,  -2.412115378819883e-10,
  -1.194067008488291e-12,   1.267505500359206e-13,   6.619200179704374e-15,   2.009835196075623e-16,   3.926846054476237e-18,   2.197672603717525e-20,  -1.857335391184378e-21,
  -8.905554190404585e-23,  -2.315572810250332e-24,  -2.467975849914689e-05,  -1.493053486975314e-06,  -5.526350548006774e-08,  -1.484366641603386e-09,  -2.724650519611795e-11,
  -1.348637671925559e-13,   1.431808027867942e-14,   7.477056428840753e-16,   2.270275711227373e-17,   4.435564382128380e-19,   2.481792252648091e-21,  -2.098203980800126e-22,
  -1.005989501819840e-23,  -2.615635991756698e-25,  -7.214067869615559e-04,   3.543294034793518e-05,  -1.148428118685513e-06,   3.047791905513917e-08,  -7.157529273351762e-10,
   1.518329039571831e-11,  -3.003440528734766e-13,   5.410782723799341e-15,  -8.329182826754010e-17,   1.529483364270136e-18,  -1.268034310487781e-20,  -2.847579164382952e-22,
  -5.195995669835413e-24,   9.166232409740459e-26,  -6.863516543104884e-04,   3.371219746369065e-05,  -1.092696200286102e-06,   2.899998742341637e-08,  -6.810726730119991e-10,
   1.444815594698898e-11,  -2.858046520787826e-13,   5.149234252173950e-15,  -7.925753038223198e-17,   1.454625086647523e-18,  -1.207340706241800e-20,  -2.707049932915506e-22,
  -4.911377957313043e-24,   8.644196008503752e-26,  -6.196588811322293e-04,   3.043804217568318e-05,  -9.866357986329007e-07,   2.618695688351363e-08,  -6.150524056842457e-10,
   1.304847240112237e-11,  -2.581208673820797e-13,   4.651074763956907e-15,  -7.157693016919349e-17,   1.312425096972829e-18,  -1.091485996177405e-20,  -2.440593776880354e-22,
  -4.382988477464263e-24,   7.682264971578363e-26,  -5.278371033873791e-04,   2.592940548171407e-05,  -8.405553347602403e-07,   2.231158829076397e-08,  -5.240775819892445e-10,
   1.111930636886724e-11,  -2.199627073375439e-13,   3.964128852311288e-15,  -6.099207589106299e-17,   1.117069456098240e-18,  -9.312419050610202e-21,  -2.075465275731726e-22,
  -3.680874434979003e-24,   6.418393873400637e-26,  -4.198598778175265e-04,   2.062646441431536e-05,  -6.686997381344881e-07,   1.775130513173752e-08,  -4.169963622307971e-10,
   8.848057443386956e-12,  -1.750358248068167e-13,   3.154945777366598e-15,  -4.853182399734606e-17,   8.878775960452846e-19,  -7.418846038793146e-21,  -1.648240887769227e-22,
  -2.887289231030764e-24,   5.008609899667366e-26,  -3.062939589518036e-04,   1.504808450072478e-05,  -4.878809410502446e-07,   1.295212857227537e-08,  -3.042795918231776e-10,
   6.456773052870508e-12,  -1.277322831279243e-13,   2.302601682156013e-15,  -3.541445512819597e-17,   6.473216248711445e-19,  -5.418816233983094e-21,  -1.200870845661803e-22,
  -2.082477984042770e-24,   3.597023074125221e-26,  -1.982639526186759e-04,   9.740950443204674e-06,  -3.158285044447078e-07,   8.384887159520060e-09,  -1.969919690879947e-10,
   4.180315674236716e-12,  -8.269862304673350e-14,   1.490910176122554e-15,  -2.292794609292224e-17,   4.188408307601662e-19,  -3.510427913696443e-21,  -7.766672890139078e-23,
  -1.337796101607442e-24,   2.304061722634789e-26,  -1.063567801683538e-04,   5.225530020427975e-06,  -1.694295865785149e-07,   4.498261548292864e-09,  -1.056832297488475e-10,
   2.242723875143991e-12,  -4.436771690247784e-14,   7.999047179568232e-16,  -1.230062806471039e-17,   2.246362464578162e-19,  -1.883911908805927e-21,  -4.164557869947617e-23,
  -7.148413970562453e-25,   1.229303133787847e-26,  -3.957862014965357e-05,   1.944591833828663e-06,  -6.305078010274172e-08,   1.673976057041111e-09,  -3.932911028987547e-11,
   8.346166484453532e-13,  -1.651121527560059e-14,   2.976846696438375e-16,  -4.577590376734725e-18,   8.358796818360680e-20,  -7.011618454653586e-22,  -1.549527237024871e-23,
  -2.656509834742681e-25,   4.565952654594401e-27,  -4.470719461198304e-06,   2.196573027800518e-07,  -7.122101283832542e-09,   1.890895162736189e-10,  -4.442555756038850e-12,
   9.427712179043570e-14,  -1.865084127750483e-15,   3.362612692914928e-17,  -5.170778639524976e-19,   9.441816037590732e-21,  -7.920359818282464e-23,  -1.750272424246831e-24,
  -3.000087424517963e-26,   5.156053688715464e-28,  -6.032556190148335e-03,   2.567708276560634e-04,  -6.268327483535313e-06,   9.193799533568953e-08,  -1.151435092796045e-10,
  -4.223112123016869e-11,   1.476328407836142e-12,  -3.048571445610383e-14,   3.568965408050300e-16,   7.272927403687429e-18,  -3.038303966528484e-19,   5.538956684077044e-21,
  -2.291235264736939e-22,   2.636328881078590e-24,  -5.739317052625168e-03,   2.442895855960114e-04,  -5.963452893346174e-06,   8.745348718652717e-08,  -1.088833957782676e-10,
  -4.019598165072914e-11,   1.404814049091364e-12,  -2.899503243824515e-14,   3.391268685396085e-16,   6.928283545192710e-18,  -2.894971906089658e-19,   5.275488687837106e-21,
  -2.175867069203910e-22,   2.495974526242805e-24,  -5.181467312668260e-03,   2.205455278678481e-04,  -5.383539105998427e-06,   7.892856476073212e-08,  -9.724381992144316e-11,
  -3.631718841558378e-11,   1.268665381796517e-12,  -2.616276244682211e-14,   3.054928073291021e-16,   6.269041035229376e-18,  -2.620517923310516e-19,   4.771885997125972e-21,
  -1.958017273562871e-22,   2.233941066012155e-24,  -4.413506131817237e-03,   1.878581915547654e-04,  -4.585341181920390e-06,   6.720494870884558e-08,  -8.174287499927303e-11,
  -3.096351067503547e-11,   1.081040082142262e-12,  -2.227064805848953e-14,   2.595219019040495e-16,   5.354501948810880e-18,  -2.239245651890356e-19,   4.074011075859529e-21,
  -1.661262974959739e-22,   1.882845240924857e-24,  -3.510527673488720e-03,   1.494237671954302e-04,  -3.646984413414270e-06,   5.343559779530849e-08,  -6.417841519254839e-11,
  -2.465093580869868e-11,   8.601794096160233e-13,  -1.770302554127951e-14,   2.058892490185644e-16,   4.270300475743477e-18,  -1.786594877062345e-19,   3.247686967405395e-21,
  -1.316320008427371e-22,   1.482198463899302e-24,  -2.560906552549580e-03,   1.090038191954290e-04,  -2.660320385368021e-06,   3.896939220782419e-08,  -4.632383581701570e-11,
  -1.799584237752736e-11,   6.276793703885605e-13,  -1.290766501526682e-14,   1.498794029023683e-16,   3.121803585155057e-18,  -1.306526020399465e-19,   2.373369522690817e-21,
  -9.572743734053247e-23,   1.072194787880102e-24,  -1.657641648151717e-03,   7.055683570877079e-05,  -1.721935111327245e-06,   2.521945433687686e-08,  -2.977355710034817e-11,
  -1.165409784289361e-11,   4.063674192664230e-13,  -8.352150046745616e-15,   9.687992939241454e-17,   2.023548784632077e-18,  -8.470710519241563e-20,   1.538041312115733e-21,
  -6.183600338107007e-23,   6.901453063627093e-25,  -8.892169884784206e-04,   3.784917641977097e-05,  -9.236908688995290e-07,   1.352723990957277e-08,  -1.591337559271488e-11,
  -6.253214408731649e-12,   2.180113654554837e-13,  -4.479609837313821e-15,   5.193255027323829e-17,   1.086286734621807e-18,  -4.547766070473625e-20,   8.255509695210945e-22,
  -3.313597500338597e-23,   3.691516501672819e-25,  -3.309037705105921e-04,   1.408479339104008e-05,  -3.437305216629417e-07,   5.033707564463124e-09,  -5.914295949404027e-12,
  -2.327205375758421e-12,   8.113123981637140e-14,  -1.666893952083058e-15,   1.932080379833729e-17,   4.043408288236315e-19,  -1.692846829840501e-20,   3.072753936393342e-22,
  -1.232633396503583e-23,   1.372340693190158e-25,  -3.737818823087717e-05,   1.590988442301611e-06,  -3.882703512057586e-08,   5.685937794729535e-10,  -6.679311978140488e-13,
  -2.628797790590767e-13,   9.164463076361862e-15,  -1.882870045947490e-16,   2.182350546578836e-18,   4.567530417237107e-20,  -1.912291601734482e-21,   3.471031683672268e-23,
  -1.392275239271261e-24,   1.549919403287587e-26,  -1.412282484718297e-02,   4.008628271233276e-04,  -1.163172473717407e-06,  -2.256123606742892e-07,   6.360769896990301e-09,
  -1.863165825801005e-11,  -3.741947749979955e-12,   1.056654133770653e-13,  -1.425678275238997e-16,  -5.446733172662453e-17,   1.900254260216897e-18,  -1.501777223626610e-20,
  -1.434830299440993e-21,   3.835880216780201e-23,  -1.343591890270854e-02,   3.813445944073277e-04,  -1.105464832835142e-06,  -2.146438381019897e-07,   6.049710839558223e-09,
  -1.765971389928832e-11,  -3.560042447348614e-12,   1.004673556176433e-13,  -1.331139339180966e-16,  -5.184173798544491e-17,   1.805018959545939e-18,  -1.419940268130710e-20,
  -1.364229231538695e-21,   3.641565200760231e-23,  -1.212933272985437e-02,   3.442268917759973e-04,  -9.961582967980016e-07,  -1.937782721424906e-07,   5.458719698694712e-09,
  -1.583771782959143e-11,  -3.213992726752607e-12,   9.060378744305922e-14,  -1.161607401342358e-16,  -4.683772470079801e-17,   1.625013494856591e-18,  -1.267874641062440e-20,
  -1.230263643579826e-21,   3.275108814426855e-23,  -1.033094516151746e-02,   2.931546223131841e-04,  -8.466021069155847e-07,  -1.650550525665066e-07,   4.646605505682389e-09,
  -1.338177595924181e-11,  -2.737611209224885e-12,   7.707378631571626e-14,  -9.481707843805988e-17,  -3.993141254898705e-17,   1.379470945569392e-18,  -1.065525206686591e-20,
  -1.046510920579902e-21,   2.776829779520428e-23,  -8.216780958201782e-03,   2.331356540207737e-04,  -6.719160180232166e-07,  -1.312835664904546e-07,   3.693573206531886e-09,
  -1.056016728979862e-11,  -2.177487997737802e-12,   6.122664594741201e-14,  -7.223793837156093e-17,  -3.178895639188971e-17,   1.093617393186082e-18,  -8.364109794446058e-21,
  -8.313063304624601e-22,   2.198783511841484e-23,  -5.993786621832047e-03,   1.700467051878897e-04,  -4.892911813218632e-07,  -9.576920482741887e-08,   2.693048504859015e-09,
  -7.654379020631150e-12,  -1.588447416148164e-12,   4.461841257757272e-14,  -5.083175532621317e-17,  -2.320574022263706e-17,   7.956599894131228e-19,  -6.036414702819615e-21,
  -6.057870215862109e-22,   1.598172732790744e-23,  -3.879571998837979e-03,   1.100586796760084e-04,  -3.163410987655987e-07,  -6.198961223752437e-08,   1.742581562982972e-09,
  -4.933552017908960e-12,  -1.028174205136238e-12,   2.886123313682897e-14,  -3.210601410693925e-17,  -1.502753929297840e-17,   5.141113548051019e-19,  -3.879480546738517e-21,
  -3.918413205277273e-22,   1.031986895960356e-23,  -2.081102794749537e-03,   5.903647595222993e-05,  -1.695943197067554e-07,  -3.325324383628695e-08,   9.346181388842124e-10,
  -2.640738944808838e-12,  -5.515465348344885e-13,   1.547675099723263e-14,  -1.700348872409160e-17,  -8.063154742466345e-18,   2.755369800245661e-19,  -2.073435843011529e-21,
  -2.101210300883670e-22,   5.529083497600802e-24,  -7.744349181545171e-04,   2.196883815414980e-05,  -6.309780457063015e-08,  -1.237448922774829e-08,   3.477776841061477e-10,
  -9.819466080408205e-13,  -2.052463962015212e-13,   5.758651181846854e-15,  -6.299104212810856e-18,  -3.000776913690721e-18,   1.025029869781997e-19,  -7.705956396873593e-22,
  -7.818231127361739e-23,   2.056646700484969e-24,  -8.747844399266248e-05,   2.481546753088636e-06,  -7.127157150485847e-09,  -1.397795705367569e-09,   3.928384992964377e-11,
  -1.109051645043720e-13,  -2.318419270471388e-14,   6.504724312339817e-16,  -7.110245622068445e-19,  -3.389656986892903e-19,   1.157793895833092e-20,  -8.702709283910573e-23,
  -8.831130631249689e-24,   2.322985385751410e-25,  -1.980488120101641e-02,   9.301270949361347e-05,   1.509389664046361e-05,  -1.803670409847603e-07,  -1.076681378502362e-08,
   2.228374012152840e-10,   6.821688954690030e-12,  -2.423146374650859e-13,  -3.541005131569116e-15,   2.528492724460011e-16,   1.728835951272565e-18,  -2.273097789643146e-19,
  -6.154523491875734e-22,   1.745965115238972e-22,  -1.884111932910021e-02,   8.847258029946248e-05,   1.435781136510585e-05,  -1.715281407028766e-07,  -1.024008152191093e-08,
   2.118484944070460e-10,   6.486945268123450e-12,  -2.302602801253626e-13,  -3.366466525420249e-15,   2.401827401234976e-16,   1.643526274654200e-18,  -2.158535801833251e-19,
  -5.865067156213339e-22,   1.657277782616500e-22,  -1.700811663185755e-02,   7.984323643771769e-05,   1.295847231419530e-05,  -1.547423538917332e-07,  -9.239410921188909e-09,
   1.910075581186756e-10,   5.851420301958758e-12,  -2.074410383401642e-13,  -3.035412667101550e-15,   2.162399804111166e-16,   1.481750277432888e-18,  -1.942262838073610e-19,
  -5.310324801138570e-22,   1.490127572256658e-22,  -1.448555635025494e-02,   6.797854915714365e-05,   1.103395577201545e-05,  -1.316906047924737e-07,  -7.864496291421741e-09,
   1.624409191310655e-10,   4.979010356038813e-12,  -1.762448425823877e-13,  -2.581573195741126e-15,   1.835763604451562e-16,   1.260042532520372e-18,  -1.647750637841259e-19,
  -4.538851806575351e-22,   1.263043608609779e-22,  -1.152055373049465e-02,   5.404669299726715e-05,   8.773459315943307e-06,  -1.046572626735071e-07,  -6.251210400659015e-09,
   1.290084194421434e-10,   3.956357719745108e-12,  -1.398388118080410e-13,  -2.050349736527020e-15,   1.455446917736138e-16,   1.000625917092929e-18,  -1.305515467174996e-19,
  -3.622095392867604e-22,   9.998403818832761e-23,  -8.403380160474774e-03,   3.941270600120367e-05,   6.398411133502611e-06,  -7.629382072058647e-08,  -4.557717657106866e-09,
   9.399458100333505e-11,   2.883802450112035e-12,  -1.018077325855418e-13,  -1.493926831036743e-15,   1.058965267167981e-16,   7.289969958536615e-19,  -9.493669979717251e-20,
  -2.649180872126541e-22,   7.265699109601322e-23,  -5.439062570708151e-03,   2.550534982376452e-05,   4.140852259307417e-06,  -4.936136666696466e-08,  -2.949083347406041e-09,
   6.079182429640585e-11,   1.865650248093205e-12,  -6.581179622166482e-14,  -9.662345599197787e-16,   6.842701068724279e-17,   4.714622557787437e-19,  -6.132332427814657e-20,
  -1.717698289361104e-22,   4.691015194087545e-23,  -2.917610783908262e-03,   1.368031394129441e-05,   2.221089715782237e-06,  -2.647293108856959e-08,  -1.581697292797555e-09,
   3.259719225754708e-11,   1.000525322954509e-12,  -3.527979412256781e-14,  -5.181113911069432e-16,   3.667404621746744e-17,   2.527963609259761e-19,  -3.286076418003078e-20,
  -9.222327213862818e-23,   2.513129686089792e-23,  -1.085716696423726e-03,   5.090633339654453e-06,   8.265057654787219e-07,  -9.850548324269047e-09,  -5.885579365307778e-10,
   1.212860304500514e-11,   3.722892911355154e-13,  -1.312554629781297e-14,  -1.927771954976916e-16,   1.364327005796823e-17,   9.405837932860466e-20,  -1.222389751105693e-20,
  -3.432931459802290e-23,   9.347828976946399e-24,  -1.226400405029358e-04,   5.750233210619538e-07,   9.335985499429109e-08,  -1.112682581849253e-09,  -6.648157349262365e-11,
   1.369989555985439e-12,   4.205237112385655e-14,  -1.482578284204150e-15,  -2.177521429880549e-17,   1.541039218792461e-18,   1.062437380043913e-20,  -1.380703845773464e-21,
  -3.877951512669538e-24,   1.055834503370189e-24,  -1.672410277018550e-02,  -4.851376438203040e-04,   4.523762919087598e-06,   5.346843037872986e-07,   6.272464893099215e-09,
  -3.870931421534795e-10,  -1.376297558632752e-11,   9.931617516816286e-14,   1.540299859447970e-14,   2.247913503677945e-16,  -9.604135686997757e-18,  -3.907006959132376e-19,
   9.234495468375279e-22,   3.539807838079293e-22,  -1.591050077532874e-02,  -4.614929214214650e-04,   4.304829582711492e-06,   5.085621947945811e-07,   5.961281352093747e-09,
  -3.682016874505194e-10,  -1.308079135755611e-11,   9.472166191047506e-14,   1.464095924810499e-14,   2.132263500540236e-16,  -9.135007744755970e-18,  -3.708842793177438e-19,
   8.936640058294055e-22,   3.361562680334651e-22,  -1.436299309971387e-02,  -4.165372938938375e-04,   3.887943428407262e-06,   4.589217131236806e-07,   5.371857695500883e-09,
  -3.322934567646754e-10,  -1.178839625893418e-11,   8.588542185800259e-14,   1.319669382093606e-14,   1.914867444676260e-16,  -8.243437420059581e-18,  -3.335234478467116e-19,
   8.307474591526337e-22,   3.024987868823269e-22,  -1.223313874458934e-02,  -3.546986022889777e-04,   3.313277415430870e-06,   3.906880172773759e-07,   4.565391546611550e-09,
  -2.829195649667489e-10,  -1.001962798757537e-11,   7.353630332725232e-14,   1.121894963469859e-14,   1.620638306171216e-16,  -7.017817620514873e-18,  -2.827429368117023e-19,
   7.321198247352880e-22,   2.566515684231613e-22,  -9.729480598241778e-03,  -2.820502115534363e-04,   2.636616070872339e-06,   3.105891061988935e-07,   3.623405778860805e-09,
  -2.249401030809667e-10,  -7.953030208049096e-12,   5.878362457535647e-14,   8.906772952483150e-15,   1.281041524899475e-16,  -5.579002525489811e-18,  -2.238569683502030e-19,
   6.011143001403829e-22,   2.033602451714809e-22,  -7.097105331411909e-03,  -2.057073052681104e-04,   1.924107747002652e-06,   2.264749557375495e-07,   2.638594257123116e-09,
  -1.640359380550701e-10,  -5.791915205671888e-12,   4.305351143471433e-14,   6.487537210770425e-15,   9.298083083661654e-17,  -4.068051678978581e-18,  -1.626932626169817e-19,
   4.494757065116206e-22,   1.478906318401730e-22,  -4.593656534907001e-03,  -1.331318141029782e-04,   1.245755042791043e-06,   1.465525152242086e-07,   1.705938145350010e-09,
  -1.061541907530822e-10,  -3.744857400388640e-12,   2.794103453376133e-14,   4.195068054840337e-15,   5.998451871466061e-17,  -2.632422146283799e-18,  -1.050492183540660e-19,
   2.956081073831023e-22,   9.553128920759337e-23,  -2.464140863091341e-03,  -7.141109340610521e-05,   6.683505726540196e-07,   7.860438647198381e-08,   9.145770638408651e-10,
  -5.693816412231787e-11,  -2.007723154165076e-12,   1.500864225219025e-14,   2.249215993756528e-15,   3.212254969196788e-17,  -1.411908542175159e-18,  -5.628051297092045e-20,
   1.598568755714283e-22,   5.119222995646727e-23,  -9.169718066656124e-04,  -2.657345770884996e-05,   2.487237604071458e-07,   2.924951106780865e-08,   3.402700569602588e-10,
  -2.118750114722136e-11,  -7.469839397969224e-13,   5.587757497714815e-15,   8.368484397019896e-16,   1.194659287019915e-17,  -5.253847553273610e-19,  -2.093436754202652e-20,
   5.965331426355215e-23,   1.904312679975262e-23,  -1.035790579035944e-04,  -3.001668733550333e-06,   2.809550343775733e-08,   3.303936022889233e-09,   3.843491253952731e-11,
  -2.393279733356218e-12,  -8.437505406127686e-14,   6.312278450498881e-16,   9.452591998230192e-17,   1.349333623381624e-18,  -5.934584733438837e-20,  -2.364535712093516e-21,
   6.741283968650845e-24,   2.150945639511650e-24,  -5.107323213289825e-03,  -3.248286474817597e-04,  -1.221333085508520e-05,  -3.093778585899449e-07,  -3.965221685974577e-09,
   8.798966040484717e-11,   7.663722036032229e-12,   2.773844408169968e-13,   5.952476666875083e-15,   2.888262648596955e-17,  -3.648319846051237e-18,  -1.773689533024874e-19,
  -4.621875552309439e-21,  -6.104897700183807e-23,  -4.859265460818128e-03,  -3.090564170066673e-04,  -1.161996932194584e-05,  -2.943029248799756e-07,  -3.768915506310704e-09,
   8.388312829804824e-11,   7.295882688782148e-12,   2.639212768709572e-13,   5.657991562590439e-15,   2.718642568547260e-17,  -3.479905282161447e-18,  -1.688796491861306e-19,
  -4.394592271987846e-21,  -5.781671386608627e-23,  -4.387283604459570e-03,  -2.790446540922135e-04,  -1.049104369166736e-05,  -2.656394745014363e-07,  -3.396912673728172e-09,
   7.600162108593391e-11,   6.594202482823159e-12,   2.383006339955651e-13,   5.099844650410345e-15,   2.407816526815935e-17,  -3.155880127898519e-18,  -1.526750976365503e-19,
  -3.963240076417164e-21,  -5.177438010773318e-23,  -3.737369373792070e-03,  -2.377152977792918e-04,  -8.936659253282362e-06,  -2.262085867889123e-07,  -2.887600000079627e-09,
   6.501709545281668e-11,   5.624534442559969e-12,   2.030136475762949e-13,   4.335509935319804e-15,   2.002931505379822e-17,  -2.702766101162899e-18,  -1.302618870311400e-19,
  -3.371446698378979e-21,  -4.366396367872503e-23,  -2.972986091559163e-03,  -1.891022494632877e-04,  -7.108673752607237e-06,  -1.798814493463723e-07,  -2.292296337990306e-09,
   5.193109856778292e-11,   4.479708016067021e-12,   1.615025984008121e-13,   3.441928613897850e-15,   1.556035352946129e-17,  -2.161081021388172e-18,  -1.037761759992699e-19,
  -2.678231471813290e-21,  -3.439210983991270e-23,  -2.168927170424641e-03,  -1.379618506814296e-04,  -5.185967330691542e-06,  -1.311951639020141e-07,  -1.669558814235619e-09,
   3.801040519922774e-11,   3.271392997257275e-12,   1.178291308255984e-13,   2.506998502272464e-15,   1.113293703977815e-17,  -1.583121093739029e-18,  -7.580051928761860e-20,
  -1.951708116112103e-21,  -2.488929645165750e-23,  -1.403984175847059e-03,  -8.930648676640693e-05,  -3.356910760927708e-06,  -8.490930265366822e-08,  -1.079547242267919e-09,
   2.465796894506359e-11,   2.119015692689157e-12,   7.627519692400680e-14,   1.621091129352764e-15,   7.112809943185909e-18,  -1.027566502828835e-18,  -4.910578854461666e-20,
  -1.262433409017466e-21,  -1.602498613739710e-23,  -7.531643445584770e-04,  -4.790865827864883e-05,  -1.800792272652078e-06,  -4.554511576165593e-08,  -5.787937307670462e-10,
   1.324236334923844e-11,   1.137123152361854e-12,   4.091830291923192e-14,   8.691531290106506e-16,   3.789822261242933e-18,  -5.520027195511815e-19,  -2.635335490166273e-20,
  -6.769691972247340e-22,  -8.572767805527342e-24,  -2.802769283567438e-04,  -1.782841812880125e-05,  -6.701313274608041e-07,  -1.694826056769874e-08,  -2.153455846729331e-10,
   4.929810948029834e-12,   4.232098982825566e-13,   1.522711159048888e-14,   3.233782106123108e-16,   1.406970059588674e-18,  -2.055174547522663e-19,  -9.808318507800516e-21,
  -2.518884167183718e-22,  -3.187120718915901e-24,  -3.165952952041048e-05,  -2.013863866536216e-06,  -7.569667838390452e-08,  -1.914432129406520e-09,  -2.432425336245096e-11,
   5.568957369710173e-13,   4.780584191258455e-14,   1.720025972520024e-15,   3.652705547495324e-17,   1.588685872286628e-19,  -2.321662661070917e-20,  -1.107953034778419e-21,
  -2.845221254292195e-23,  -3.599555720004217e-25,  -5.959808925684237e-04,   2.753454067561747e-05,  -8.425240088458987e-07,   2.111025400229904e-08,  -4.732535903549956e-10,
   9.538579436557851e-12,  -1.787353681223294e-13,   3.500946534017793e-15,  -4.079893628557800e-17,   7.345406450922397e-19,  -2.678028656376664e-20,  -2.367525363269370e-22,
   9.037154857188703e-24,   3.062246683499741e-25,  -5.670173583182624e-04,   2.619713982192683e-05,  -8.016279772979386e-07,   2.008628683709328e-08,  -4.503142174449752e-10,
   9.076809218835275e-12,  -1.700757877177714e-13,   3.331442894277165e-15,  -3.885014681903992e-17,   6.984319286315524e-19,  -2.546006744288818e-20,  -2.245356337193580e-22,
   8.587194407570320e-24,   2.906709310716818e-25,  -5.119152144549760e-04,   2.365248509682253e-05,  -7.238047315086256e-07,   1.813743111044349e-08,  -4.066485088277564e-10,
   8.197580862540314e-12,  -1.535904411460037e-13,   3.008708781050535e-15,  -3.512879267678974e-17,   6.299052682145028e-19,  -2.295604983225006e-20,  -2.015848002294366e-22,
   7.735597474622087e-24,   2.613560579069071e-25,  -4.360537851496108e-04,   2.014858057189732e-05,  -6.166235599342712e-07,   1.545282205280438e-08,  -3.464849193394380e-10,
   6.985702066052333e-12,  -1.308734215717782e-13,   2.563885351418746e-15,  -2.997863516021679e-17,   5.358877182640089e-19,  -1.952347552821013e-20,  -1.705502788993277e-22,
   6.571716410256557e-24,   2.215290266050774e-25,  -3.468482118482337e-04,   1.602760982547589e-05,  -4.905401155894487e-07,   1.229403871243903e-08,  -2.756787223061674e-10,
   5.558868628140806e-12,  -1.041338648065840e-13,   2.040182512100199e-15,  -2.388867165832327e-17,   4.257425007401718e-19,  -1.550580947301688e-20,  -1.347658998030347e-22,
   5.213841237152328e-24,   1.753661584157754e-25,  -2.530284987619871e-04,   1.169280762205538e-05,  -3.578893928394164e-07,   8.970051609896290e-09,  -2.011543776236882e-10,
   4.056569355981988e-12,  -7.598637938417387e-14,   1.488800799649563e-15,  -1.745216458095288e-17,   3.102802143096594e-19,  -1.129772698263272e-20,  -9.778874182156093e-23,
   3.795659614970063e-24,   1.274367270848357e-25,  -1.637842262198540e-04,   7.568933628082184e-06,  -2.316758398370688e-07,   5.806896510430550e-09,  -1.302254071665144e-10,
   2.626368708995968e-12,  -4.919416787255706e-14,   9.638957391817948e-16,  -1.130747553387049e-17,   2.007140422324416e-19,  -7.307036801744573e-21,  -6.307452077912228e-23,
   2.453555372757485e-24,   8.227830287469513e-26,  -8.786018443025906e-05,   4.060331972018339e-06,  -1.242841716889416e-07,   3.115214878803571e-09,  -6.986319150868166e-11,
   1.409042462036111e-12,  -2.639200018744165e-14,   5.171264097908896e-16,  -6.068731364682407e-18,   1.076352902172508e-19,  -3.918143637703380e-21,  -3.377405672028428e-23,
   1.315258615470638e-24,   4.407923176066419e-26,  -3.269543327712884e-05,   1.510980637440721e-06,  -4.625045856425750e-08,   1.159287914014033e-09,  -2.599888811048955e-11,
   5.243676545504948e-13,  -9.821566161619771e-15,   1.924455736533822e-16,  -2.258742512062170e-18,   4.004975708552767e-20,  -1.457848346311505e-21,  -1.256038042924793e-23,
   4.893280623757841e-25,   1.639570477507859e-26,  -3.693208190904414e-06,   1.706773802705601e-07,  -5.224365667500208e-09,   1.309511511555398e-10,  -2.936792564291148e-12,
   5.923184462450281e-14,  -1.109429155463882e-15,   2.173838087567622e-17,  -2.551497412410688e-19,   4.523855039753536e-21,  -1.646717291581478e-22,  -1.418651665257320e-24,
   5.527134009579312e-26,   1.851890123649193e-27,  -5.098893557249738e-03,   2.109528905485969e-04,  -5.198493708657685e-06,   8.499919314274169e-08,  -6.671692180172844e-10,
  -1.558522910626904e-11,   8.071794525437669e-13,  -1.691122026810054e-14,   4.342650341935079e-16,  -2.532093338331631e-18,  -2.282042364604331e-19,  -1.201496767789646e-22,
   1.010399907908361e-23,   4.661966881288227e-24,  -4.851036418191704e-03,   2.006996444720735e-04,  -4.945755385638245e-06,   8.086013834563123e-08,  -6.343565490418175e-10,
  -1.483772935400061e-11,   7.682777287757653e-13,  -1.609136349331993e-14,   4.128370825787417e-16,  -2.409025383634110e-18,  -2.170861763692621e-19,  -1.035926533321699e-22,
   9.459931217208302e-24,   4.427993855137531e-24,  -4.379521241187295e-03,   1.811937332564304e-04,  -4.464970426113417e-06,   7.298908038295260e-08,  -5.720897861891622e-10,
  -1.341160617603130e-11,   6.941356811971969e-13,  -1.453080158417880e-14,   3.722027580474846e-16,  -2.174873856101169e-18,  -1.959461500339773e-19,  -7.647662236042104e-23,
   8.297580236037753e-24,   3.985901149974383e-24,  -3.730414346229575e-03,   1.543401817989159e-04,  -3.803133522636556e-06,   6.215917147896559e-08,  -4.866714880515908e-10,
  -1.144038760569747e-11,   5.918040597977619e-13,  -1.238073628252214e-14,   3.165149242327209e-16,  -1.852494792979403e-18,  -1.668640808731268e-19,  -4.761921563192128e-23,
   6.818688816270725e-24,   3.383115163686572e-24,  -2.967189064697269e-03,   1.227643847129323e-04,  -3.024979760308171e-06,   4.943250631502484e-08,  -3.866168085702504e-10,
  -9.112534501615334e-12,   4.711472275697888e-13,  -9.850478723880414e-15,   2.513543762314880e-16,  -1.473429103029045e-18,  -1.326940209051340e-19,  -2.437594714920006e-23,
   5.232180163004685e-24,   2.681688487127017e-24,  -2.164542574032078e-03,   8.955658403168725e-05,  -2.206670739916079e-06,   3.605524640772496e-08,  -2.817495909256966e-10,
  -6.655047545197051e-12,   3.439470602160172e-13,  -7.187486975459864e-15,   1.831243366083716e-16,  -1.074808742837054e-18,  -9.678167563915887e-20,  -9.863653140685240e-24,
   3.704799634275411e-24,   1.950844132746194e-24,  -1.401079487782588e-03,   5.796915192545705e-05,  -1.428335756651441e-06,   2.333576765091418e-08,  -1.822510166808332e-10,
  -4.310940272575753e-12,   2.227385980290738e-13,  -4.653063648241099e-15,   1.184326553791707e-16,  -6.956844393565150e-19,  -6.263802471266004e-20,  -3.002676949333214e-24,
   2.350294421827784e-24,   1.260437643253850e-24,  -7.515878223767566e-04,   3.109677391077053e-05,  -7.662055241510228e-07,   1.251748138236116e-08,  -9.773225115016021e-11,
  -2.313424709715237e-12,   1.195139997888963e-13,  -2.496258009818786e-15,   6.350350120305835e-17,  -3.731816979295537e-19,  -3.359917574956789e-20,  -6.798802186972773e-25,
   1.247643474012352e-24,   6.755047923983022e-25,  -2.796878819307414e-04,   1.157203527425041e-05,  -2.851271028872532e-07,   4.658039608775234e-09,  -3.636469378152512e-11,
  -8.610080059529001e-13,   4.447845519410055e-14,  -9.289558030475205e-16,   2.362790272048104e-17,  -1.388708204287541e-19,  -1.250297552203843e-20,  -1.324836013111188e-25,
   4.625847399057456e-25,   2.512925761949879e-25,  -3.159294949228635e-05,   1.307152779976344e-06,  -3.220734419356258e-08,   5.261607883954387e-10,  -4.107600746598794e-12,
  -9.725969443676243e-14,   5.024259805473264e-15,  -1.049333230160921e-16,   2.668892970920403e-18,  -1.568653423209159e-20,  -1.412304855292430e-21,  -1.280502398403702e-26,
   5.222212576299692e-26,   2.838399603478506e-26,  -1.255275960660931e-02,   3.824030521663781e-04,  -3.285304482915224e-06,  -1.307223790867343e-07,   5.321119077807264e-09,
  -7.478774889638718e-11,  -1.049542003903175e-12,   8.219216157899559e-14,  -1.025500055083317e-15,  -4.692610121067521e-18,   4.365915609303717e-19,  -3.649939125392800e-20,
   4.109802216614504e-22,   2.454840943748959e-23,  -1.194228551353062e-02,   3.637911400208545e-04,  -3.124558163370300e-06,  -1.243860759716983e-07,   5.061826793212774e-09,
  -7.109875904596305e-11,  -9.993422117779159e-13,   7.818887925563069e-14,  -9.750288870109544e-16,  -4.523498081739840e-18,   4.161446823355494e-19,  -3.466731806185216e-20,
   3.894323821019184e-22,   2.334001066129272e-23,  -1.078105561593389e-02,   3.283939327215783e-04,  -2.819185932716380e-06,  -1.123247171754307e-07,   4.568814591595258e-09,
  -6.410273456611249e-11,  -9.035102539050966e-13,   7.057630279000287e-14,  -8.792655832909693e-16,  -4.177662901140071e-18,   3.769274703082731e-19,  -3.120561201785844e-20,
   3.490829928469558e-22,   2.104732677815921e-23,  -9.182683871176201e-03,   2.796830756695782e-04,  -2.399624341717372e-06,  -9.570626283174970e-08,   3.890612425537174e-09,
  -5.451395730174737e-11,  -7.709381397499099e-13,   6.010268470101683e-14,  -7.479226872555902e-16,  -3.654933492990967e-18,   3.223237244811481e-19,  -2.648573471115074e-20,
   2.947781276510807e-22,   1.790302426583682e-23,  -7.303589157555591e-03,   2.224317036441514e-04,  -1.907345864522035e-06,  -7.614807999468681e-08,   3.093808306523292e-09,
  -4.329284022116546e-11,  -6.142422063700373e-13,   4.779565024817774e-14,  -5.941094076937800e-16,  -2.981468338270537e-18,   2.573472300390362e-19,  -2.099376922073221e-20,
   2.324917005324886e-22,   1.422099944005725e-23,  -5.327702557892086e-03,   1.622449383701541e-04,  -1.390615332442529e-06,  -5.556288843648099e-08,   2.256438165430479e-09,
  -3.154196206253588e-11,  -4.486925393584930e-13,   3.486046345725226e-14,  -4.329322678691357e-16,  -2.218546743349019e-18,   1.882998891174745e-19,  -1.527187087250857e-20,
   1.684422653944910e-22,   1.036285685770167e-23,  -3.448460024677271e-03,   1.050115593630982e-04,  -8.997934024631126e-07,  -3.597085253101236e-08,   1.460360215332782e-09,
  -2.039965034425380e-11,  -2.906923067694186e-13,   2.256208106162518e-14,  -2.800316156490204e-16,  -1.454651375075926e-18,   1.221256463858794e-19,  -9.866927391809820e-21,
   1.085356622426968e-22,   6.702922615853465e-24,  -1.849849056283211e-03,   5.632981240816564e-05,  -4.825886950402644e-07,  -1.929759751743498e-08,   7.833323894172625e-10,
  -1.093838883621043e-11,  -1.560089699983426e-13,   1.210235818882898e-14,  -1.501636622868214e-16,  -7.854494591898532e-19,   6.557887553160956e-20,  -5.287909917048795e-21,
   5.808614666467715e-23,   3.594354110148837e-24,  -6.883798775598179e-04,   2.096171122682263e-05,  -1.795735217866426e-07,  -7.181406833869595e-09,   2.914937541580957e-10,
  -4.069887496594430e-12,  -5.806477401605118e-14,   4.503548169318067e-15,  -5.587317238610589e-17,  -2.929521733625266e-19,   2.441241910665485e-20,  -1.967132001592394e-21,
   2.159793168769172e-23,   1.337392745407459e-24,  -7.775787186569819e-05,   2.367785661295373e-06,  -2.028403071099752e-08,  -8.112001396129275e-10,   3.292638647067771e-11,
  -4.597149558842355e-13,  -6.559039578881369e-15,   5.087095488030363e-16,  -6.311187096509816e-18,  -3.310314530093511e-20,   2.757729069879730e-21,  -2.221913254474600e-22,
   2.439340587983534e-24,   1.510659647640683e-25,  -1.920866563693028e-02,   2.025621873177058e-04,   1.206514521474370e-05,  -3.105151919876111e-07,  -5.252714560975304e-09,
   3.007482181436775e-10,  -1.963867345223551e-13,  -2.154798100832745e-13,   4.536990825538776e-15,   1.424966997305342e-16,  -6.145722758374918e-18,  -8.299635879143287e-20,
   5.215632611309815e-21,   1.943278444126061e-23,  -1.827399249130578e-02,   1.926819721449277e-04,   1.147735541610681e-05,  -2.953226300997051e-07,  -4.997294099645300e-09,
   2.859859091771805e-10,  -1.831041997814668e-13,  -2.048472199106597e-13,   4.308170576887293e-15,   1.354303456684159e-16,  -5.836665999362716e-18,  -7.891334865224290e-20,
   4.952307715459202e-21,   1.855995368182895e-23,  -1.649628378726273e-02,   1.738998838644089e-04,   1.035969366907951e-05,  -2.664608889479416e-07,  -4.511423430962823e-09,
   2.579608487904466e-10,  -1.593647904126922e-13,  -1.846846416517421e-13,   3.876255561506400e-15,   1.220444261739502e-16,  -5.252947182457798e-18,  -7.116548635481788e-20,
   4.455376960566346e-21,   1.686966246981703e-23,  -1.404975929378459e-02,   1.480702581670035e-04,   8.822102782016074e-06,  -2.268063016987352e-07,  -3.842619871934808e-09,
   2.194932445498925e-10,  -1.296389093690159e-13,  -1.570528823879394e-13,   3.288207935486292e-15,   1.037269909433211e-16,  -4.457532717565610e-18,  -6.053753460852158e-20,
   3.779029137035129e-21,   1.448551450376772e-23,  -1.117405372005590e-02,   1.177331674075496e-04,   7.015491236950615e-06,  -1.802783125851771e-07,  -3.056321690974171e-09,
   1.744053249591623e-10,  -9.841263661644432e-14,  -1.247209644056117e-13,   2.605031154523409e-15,   8.232847157884773e-17,  -3.532561924783925e-18,  -4.808962964349872e-20,
   2.993538533463051e-21,   1.161076383166236e-23,  -8.150690262845553e-03,   8.586044768171109e-05,   5.116779241107081e-06,  -1.314385896534516e-07,  -2.229494463073303e-09,
   1.271213438895631e-10,  -6.903383487460924e-14,  -9.086584635630489e-14,   1.894237160629294e-15,   5.995439128624043e-17,  -2.569366979044396e-18,  -3.504433460296755e-20,
   2.176542668546575e-21,   8.521811117980265e-24,  -5.275533686921846e-03,   5.556561754440069e-05,   3.311608003427041e-06,  -8.504718552723352e-08,  -1.443091710145870e-09,
   8.223861552677371e-11,  -4.350723699215046e-14,  -5.876617360721753e-14,   1.223503354597323e-15,   3.876338079384295e-17,  -1.659867081605539e-18,  -2.266799067318993e-20,
   1.405763823614169e-21,   5.538099778455993e-24,  -2.829897536748946e-03,   2.980438400856391e-05,   1.776347566872797e-06,  -4.561366295649672e-08,  -7.741162278853764e-10,
   4.410317361884120e-11,  -2.301475513799702e-14,  -3.151043430099214e-14,   6.556111513086484e-16,   2.078182861019952e-17,  -8.895161260963479e-19,  -1.215555648872805e-20,
   7.532522336420330e-22,   2.976881306977796e-24,  -1.053077233113901e-03,   1.109070400923302e-05,   6.610162505766996e-07,  -1.697306750312377e-08,  -2.880702684717614e-10,
   1.641046841105555e-11,  -8.522514124125969e-15,  -1.172417183430793e-14,   2.438791035152844e-16,   7.731948462858407e-18,  -3.308992627918142e-19,  -4.522876297271339e-21,
   2.801974224609620e-22,   1.108567457951831e-24,  -1.189531776885928e-04,   1.252775540690556e-06,   7.466672732371023e-08,  -1.917221695546958e-09,  -3.253978644705147e-11,
   1.853662704417079e-12,  -9.619332335499838e-16,  -1.324305565426840e-15,   2.754639831448988e-17,   8.733561715343659e-19,  -3.737560317914930e-20,  -5.108844135819742e-22,
   3.164853761604456e-23,   1.252354478363315e-25,  -1.855014027585573e-02,  -4.222725655416629e-04,   1.123365511213527e-05,   5.571729393172135e-07,  -4.239863526133272e-09,
  -6.242866299808039e-10,  -3.572049609780023e-12,   6.176218590013519e-13,   1.308359389497765e-14,  -4.182573462320691e-16,  -1.871439667412256e-17,   1.266373292322356e-19,
   1.867825156688627e-20,   1.183854927579307e-22,  -1.764752247962730e-02,  -4.016837493475556e-04,   1.068648632111509e-05,   5.298874436531197e-07,  -4.035186993122726e-09,
  -5.935376252918387e-10,  -3.387554101927742e-12,   5.871343212561958e-13,   1.242246128466895e-14,  -3.977036137311015e-16,  -1.776793767358260e-17,   1.207395401615087e-19,
   1.772788655225199e-20,   1.116916004821109e-22,  -1.593077672551500e-02,  -3.625415700678572e-04,   9.646018001236724e-06,   4.780624609204619e-07,  -3.645231777908955e-09,
  -5.352057992872284e-10,  -3.041020377935579e-12,   5.293252509555792e-13,   1.117503541439007e-14,  -3.586926859911574e-16,  -1.598248591825346e-17,   1.094118756342210e-19,
   1.593733277712183e-20,   9.934654711344609e-23,  -1.356814125243119e-02,  -3.087058867693697e-04,   8.214534877911834e-06,   4.068769787600602e-07,  -3.107275229038838e-09,
  -4.552215214646471e-10,  -2.572556377795672e-12,   4.501098363034674e-13,   9.477663420009034e-15,  -3.051633474882925e-16,  -1.355364656711143e-17,   9.361147795479434e-20,
   1.350595930990438e-20,   8.309922298468751e-23,  -1.079102873784111e-02,  -2.454674615342136e-04,   6.532483961398704e-06,   3.233773632381978e-07,  -2.473323201664807e-09,
  -3.615768399459034e-10,  -2.032559812341272e-12,   3.574315920717290e-13,   7.506946681681132e-15,  -2.424450787054701e-16,  -1.073443956640927e-17,   7.477663087185821e-20,
   1.068941645180792e-20,   6.493050890166740e-23,  -7.871309416922097e-03,  -1.790205058907133e-04,   4.764578653328235e-06,   2.357519639088278e-07,  -1.805313971909369e-09,
  -2.634690952387938e-10,  -1.474726533724506e-12,   2.603984738957553e-13,   5.457717731119125e-15,  -1.766950864206178e-16,  -7.803621876861018e-18,   5.473379246279554e-20,
   7.766626523321700e-21,   4.668510548893896e-23,  -5.094708335185887e-03,  -1.158578273793089e-04,   3.083697205263935e-06,   1.525352149709918e-07,  -1.169000330720765e-09,
  -1.704124202958133e-10,  -9.511503519107576e-13,   1.684048644232557e-13,   3.524789918820568e-15,  -1.143009133357125e-16,  -5.039624265952716e-18,   3.550690150443163e-20,
   5.013907379233889e-21,   2.992872459470330e-23,  -2.732900415925393e-03,  -6.214473177940497e-05,   1.654105879812231e-06,   8.180760831247521e-08,  -6.272147707377725e-10,
  -9.138001738829078e-11,  -5.092888765478270e-13,   9.029758730350825e-14,   1.888641110170756e-15,  -6.129528736214210e-17,  -2.700250351959816e-18,   1.906865238200575e-20,
   2.685968109901658e-21,   1.597518102693796e-23,  -1.016982262703333e-03,  -2.312517348826074e-05,   6.155288109474507e-07,   3.044073323196468e-08,  -2.334208460445233e-10,
  -3.400063537386804e-11,  -1.893994741304137e-13,   3.359711794945763e-14,   7.025366887533982e-16,  -2.280722200004986e-17,  -1.004430788784178e-18,   7.098785872912916e-21,
   9.990529466383822e-22,   5.934534007049872e-24,  -1.148759754846351e-04,  -2.612157882209933e-06,   6.952860353847411e-08,   3.438479778917196e-09,  -2.636700693039027e-11,
  -3.840558043532937e-12,  -2.139197856953683e-14,   3.794964783008605e-15,   7.935199759161680e-17,  -2.576209620620867e-18,  -1.134509933429502e-19,   8.019135993717271e-22,
   1.128423947078395e-22,   6.701678222435272e-25,  -6.626810480224235e-03,  -4.382506145897966e-04,  -1.620793386025296e-05,  -3.457227116298931e-07,   3.731792481098353e-10,
   3.861424371766138e-10,   1.794349204263772e-11,   4.368084142528051e-13,   1.831158526494736e-15,  -3.454282217581240e-16,  -1.684882532132230e-17,  -4.096721271733162e-19,
  -2.390763324184885e-21,   2.636472019186734e-22,  -6.304961969088830e-03,  -4.169645727964944e-04,  -1.541948845557751e-05,  -3.287910115164028e-07,   3.630348642374895e-10,
   3.676312871079214e-10,   1.707210966087154e-11,   4.151876464928414e-13,   1.719514967058237e-15,  -3.292903191380223e-16,  -1.603357349132843e-17,  -3.891195964085025e-19,
  -2.237712828504156e-21,   2.518970488194155e-22,  -5.692573915749272e-03,  -3.764636584136630e-04,  -1.391980920877569e-05,  -2.966318916398500e-07,   3.404854121741613e-10,
   3.323105352642574e-10,   1.541404876651069e-11,   3.742136389331014e-13,   1.516324487866024e-15,  -2.983229498556355e-16,  -1.448103216523163e-17,  -3.502773402245455e-19,
  -1.961502525931079e-21,   2.291070763156070e-22,  -4.849314421657851e-03,  -3.206947932129371e-04,  -1.185574380371991e-05,  -2.524596817095229e-07,   3.031392639210054e-10,
   2.834818520826901e-10,   1.313079935635856e-11,   3.181117643189987e-13,   1.254440825430859e-15,  -2.551754840540136e-16,  -1.234067276428121e-17,  -2.973055728920211e-19,
  -1.610272537404963e-21,   1.968898718363725e-22,  -3.857522835054257e-03,  -2.551040241438562e-04,  -9.429375942272969e-06,  -2.006475286136896e-07,   2.512476945638252e-10,
   2.258100836105816e-10,   1.044529482315967e-11,   2.525337308000316e-13,   9.691026774883931e-16,  -2.037907464839183e-16,  -9.820288907462312e-18,  -2.356590318704208e-19,
  -1.234063933603701e-21,   1.579460760605902e-22,  -2.814243330483527e-03,  -1.861093554265465e-04,  -6.878225241764074e-06,  -1.462767578297625e-07,   1.892358014653802e-10,
   1.649188999891720e-10,   7.620334045630928e-12,   1.839306883437649e-13,   6.900931958859480e-16,  -1.491465066304771e-16,  -7.166385535326308e-18,  -1.714280013931540e-19,
  -8.727477665611944e-22,   1.160050536166637e-22,  -1.821711414856111e-03,  -1.204715910818415e-04,  -4.451996826292424e-06,  -9.464270845759622e-08,   1.250356909576690e-10,
   1.068318941662967e-10,   4.932778257599825e-12,   1.189313091027902e-13,   4.394760172106211e-16,  -9.674667080835111e-17,  -4.639779065042801e-18,  -1.107555788373062e-19,
  -5.531536979974683e-22,   7.542335322042877e-23,  -9.772540356183441e-04,  -6.462666860035980e-05,  -2.388154680453101e-06,  -5.075854392565693e-08,   6.777483894690724e-11,
   5.733095127935752e-11,   2.646178664804921e-12,   6.376454816291232e-14,   2.337632900637226e-16,  -5.195501699564340e-17,  -2.489231407791936e-18,  -5.935588243486241e-20,
  -2.934891761134172e-22,   4.055183190003854e-23,  -3.636680877476198e-04,  -2.404967552502886e-05,  -8.886957645623444e-07,  -1.888730563046481e-08,   2.531184525136927e-11,
   2.133745612477781e-11,   9.847290477273118e-13,   2.372420879914843e-14,   8.673281643878698e-17,  -1.934133160978220e-17,  -9.263537148203683e-19,  -2.208064163895789e-20,
  -1.087960056868847e-22,   1.510245081382789e-23,  -4.107923240343647e-05,  -2.716603811174411e-06,  -1.003850677647178e-07,  -2.133444179140208e-09,   2.860800586661413e-12,
   2.410286215200700e-12,   1.112330519894634e-13,   2.679756484781534e-15,   9.792541616788509e-18,  -2.184887413044503e-18,  -1.046396235321980e-19,  -2.494049306035997e-21,
  -1.228183845409903e-23,   1.706154490498778e-24,  -4.978830663019590e-04,   2.169205576034206e-05,  -6.290076132194128e-07,   1.486221059935849e-08,  -3.181251623479319e-10,
   6.294428229511530e-12,  -9.655719752333186e-14,   2.400981478301809e-15,  -3.463912506231044e-17,  -3.724309712777600e-19,  -2.353934904066427e-20,   4.376187729646527e-22,
   1.574716861809567e-23,  -5.164321566155918e-26,  -4.736846539244367e-04,   2.063827617921637e-05,  -5.984693281218549e-07,   1.414118371060882e-08,  -3.026946203171749e-10,
   5.989762313693558e-12,  -9.188963722569579e-14,   2.283803256587334e-15,  -3.298550748916256e-17,  -3.536012706811832e-19,  -2.236360838779384e-20,   4.162228580353241e-22,
   1.497042051977417e-23,  -4.840943937060521e-26,  -4.276489059962818e-04,   1.863332830478452e-05,  -5.403589612708224e-07,   1.276894722015312e-08,  -2.733264567143628e-10,
   5.409644457085431e-12,  -8.299965340219662e-14,   2.061078108768072e-15,  -2.982738518718908e-17,  -3.180757089675788e-19,  -2.013975573714648e-20,   3.755724069026716e-22,
   1.349741853782356e-23,  -4.255620221184247e-26,  -3.642713338281903e-04,   1.587270704394260e-05,  -4.603321092027674e-07,   1.087874794100419e-08,  -2.328706428947939e-10,
   4.610000542243276e-12,  -7.074080987668818e-14,   1.754834514700544e-15,  -2.545592807258294e-17,  -2.697422973529235e-19,  -1.710316883086707e-20,   3.197107266952808e-22,
   1.147858399666213e-23,  -3.507297734147287e-26,  -2.897477887828311e-04,   1.262607601664205e-05,  -3.661981806135734e-07,   8.654813725337780e-09,  -1.852689071122378e-10,
   3.668469227332698e-12,  -5.630071899940912e-14,   1.395216021737371e-15,  -2.028582199958121e-17,  -2.136357375856018e-19,  -1.356414428548552e-20,   2.541504165216755e-22,
   9.116054632641298e-24,  -2.699474536269889e-26,  -2.113716187449227e-04,   9.211129312163076e-06,  -2.671670065390671e-07,   6.314684821020924e-09,  -1.351772911257468e-10,
   2.677092479117117e-12,  -4.109045973124835e-14,   1.017455221106043e-15,  -1.482068429089129e-17,  -1.553061014427030e-19,  -9.871577126424823e-21,   1.853147400645738e-22,
   6.641873856974482e-24,  -1.916496512029369e-26,  -1.368191970565319e-04,   5.962454742665026e-06,  -1.729456664384702e-07,   4.087865402118404e-09,  -8.750914465506285e-11,
   1.733261481115461e-12,  -2.660565234522698e-14,   6.584380075840690e-16,  -9.602768064532942e-18,  -1.002968363622864e-19,  -6.379752474424529e-21,   1.199153770853175e-22,
   4.295694058551151e-24,  -1.218050863343337e-26,  -7.339490431791573e-05,   3.198527239681489e-06,  -9.277739238256221e-08,   2.192998502667479e-09,  -4.694589766029426e-11,
   9.298961982085630e-13,  -1.427449878978328e-14,   3.531685700324109e-16,  -5.153884461923567e-18,  -5.373916402676322e-20,  -3.419571053593188e-21,   6.431683744068258e-23,
   2.303397397422526e-24,  -6.472292815299983e-27,  -2.731243930397760e-05,   1.190273467430974e-06,  -3.452561937391519e-08,   8.160953024587133e-10,  -1.747032754082725e-11,
   3.460564753994110e-13,  -5.312257871531603e-15,   1.314191436761317e-16,  -1.918251551806063e-18,  -1.998968903992034e-20,  -1.272166562311399e-21,   2.393289860131656e-23,
   8.570372331920559e-25,  -2.400540121049429e-27,  -3.085155921853784e-06,   1.344509012340172e-07,  -3.899948378818483e-09,   9.218468377205371e-11,  -1.973417956372029e-12,
   3.909007048890793e-14,  -6.000667160809849e-16,   1.484473354083583e-17,  -2.166877160382697e-19,  -2.257845313842729e-21,  -1.436948507955324e-22,   2.703386439164533e-24,
   9.680687539868630e-26,  -2.710167458516463e-28,  -4.332077611869646e-03,   1.732458908068822e-04,  -4.249803845809391e-06,   7.274897236203524e-08,  -8.159757696708387e-10,
  -4.716424770040661e-13,   5.020685420062541e-13,  -6.206016497034722e-15,   1.842191177217946e-16,  -1.091847204386666e-17,  -1.573274667858608e-19,   4.313529891592562e-21,
   1.321663990888766e-22,   2.015668108960867e-26,  -4.121490488389018e-03,   1.648256417173271e-04,  -4.043236989454641e-06,   6.921028603466148e-08,  -7.760619597888300e-10,
  -4.526310350699059e-13,   4.777999219624079e-13,  -5.915791072588774e-15,   1.750502601907101e-16,  -1.038033904655230e-17,  -1.494173627355466e-19,   4.103869789063419e-21,
   1.255856401748515e-22,   2.691094424634102e-26,  -3.720878542390959e-03,   1.488067390756586e-04,  -3.650264487767079e-06,   6.247936491739699e-08,  -7.002325268627321e-10,
  -4.148820918663940e-13,   4.315761798080111e-13,  -5.359009109382020e-15,   1.576952281739192e-16,  -9.359616223022417e-18,  -1.344765790461084e-19,   3.705035614288186e-21,
   1.131308839812414e-22,   3.657153325752091e-26,  -3.169383769786075e-03,   1.267534979203226e-04,  -3.109269913877865e-06,   5.321516524382562e-08,  -5.960390828797277e-10,
  -3.598380958790491e-13,   3.678345155357429e-13,  -4.583483428878458e-15,   1.339727494849813e-16,  -7.960271072255948e-18,  -1.141157878716139e-19,   3.155991570780425e-21,
   9.610899604017315e-23,   4.373137281176853e-26,  -2.520936518277291e-03,   1.008218852281877e-04,  -2.473148004258327e-06,   4.232459780882962e-08,  -4.737763212661914e-10,
  -2.912068409659873e-13,   2.927499669385828e-13,  -3.660191649755897e-15,   1.062930468114081e-16,  -6.322280547834199e-18,  -9.043715375241210e-20,   2.510393027273144e-21,
   7.625011443527876e-23,   4.444461708414560e-26,  -1.839000988383504e-03,   7.354973858184371e-05,  -1.804155051151555e-06,   3.087372198209576e-08,  -3.454306200537987e-10,
  -2.153716757737345e-13,   2.136602542269440e-13,  -2.678577283626939e-15,   7.738193350192423e-17,  -4.606558922760521e-18,  -6.577895258705351e-20,   1.831388853016051e-21,
   5.550952720988567e-23,   3.807115373640446e-26,  -1.190359213008128e-03,   4.760815467674921e-05,  -1.167810490919040e-06,   1.998339447914798e-08,  -2.235131789250476e-10,
  -1.406659194301729e-13,   1.383427076895441e-13,  -1.737438061328921e-15,   5.002078742203019e-17,  -2.979412469366051e-18,  -4.249482689649677e-20,   1.185470736986717e-21,
   3.588180853707189e-23,   2.705027302724648e-26,  -6.385497012248846e-04,   2.553877973392992e-05,  -6.264555941692535e-07,   1.071958105665788e-08,  -1.198783636554827e-10,
  -7.580516810643345e-14,   7.422375984571716e-14,  -9.330220946500048e-16,   2.681431244121838e-17,  -1.597612781126381e-18,  -2.277285139156098e-20,   6.359388332775767e-22,
   1.923484191486521e-23,   1.517241241199477e-26,  -2.376230247630840e-04,   9.503743272729755e-06,  -2.331226873080634e-07,   3.989043760865395e-09,  -4.460742146991511e-11,
  -2.825429968028405e-14,   2.762238160737068e-14,  -3.473343744108253e-16,   9.975986951272686e-18,  -5.944346878098261e-19,  -8.471487032565625e-21,   2.366529787754686e-22,
   7.156113692994766e-24,   5.731718193937762e-27,  -2.684139151641107e-05,   1.073522918359706e-06,  -2.633304715501615e-08,   4.505934343496615e-10,  -5.038708827819264e-12,
  -3.192351943698538e-15,   3.120193246214208e-15,  -3.923647441299104e-17,   1.126823198617355e-18,  -6.714457662959954e-20,  -9.568681559207232e-22,   2.673184494270447e-23,
   8.083083151012108e-25,   6.489769484350856e-28,  -1.108376052764972e-02,   3.511743262807873e-04,  -4.394964441955575e-06,  -5.820473855087587e-08,   3.740271975755636e-09,
  -7.617310701480996e-11,   7.752155585769785e-13,   4.739794618399447e-14,  -1.188650878745449e-15,  -1.025945205473944e-17,  -4.398701347485497e-19,  -5.211180559595355e-24,
   8.436815767085840e-22,  -5.294674824377581e-24,  -1.054477243742169e-02,   3.340878565803800e-04,  -4.180523897468431e-06,  -5.539619618658373e-08,   3.558685816128797e-09,
  -7.243848182799820e-11,   7.365160586598883e-13,   4.508151302275582e-14,  -1.131409557041859e-15,  -9.760548914613370e-18,  -4.168283029798841e-19,  -1.669335961724798e-23,
   8.018315851091062e-22,  -4.997134806790813e-24,  -9.519503432197920e-03,   3.015895847117885e-04,  -3.772905175209400e-06,  -5.004485147364332e-08,   3.213148833995216e-09,
  -6.534681856671258e-11,   6.633080842724210e-13,   4.067985838480257e-14,  -1.022293318599020e-15,  -8.811555945049968e-18,  -3.736715098168396e-19,  -3.363614722656328e-23,
   7.225608176994533e-22,  -4.447586458244401e-24,  -8.108239488246675e-03,   2.568636735008000e-04,  -3.212392507580558e-06,  -4.266157048051082e-08,   2.737287944049268e-09,
  -5.560927036242248e-11,   5.633276951191868e-13,   3.463015438235370e-14,  -8.716516045965473e-16,  -7.505309258075803e-18,  -3.155708695402264e-19,  -4.758542385187256e-23,
   6.140967777304017e-22,  -3.722865769457970e-24,  -6.449069858666028e-03,   2.042904346288332e-04,  -2.554136821702371e-06,  -3.395950467542400e-08,   2.177539005950410e-09,
  -4.419156349438042e-11,   4.467843151502623e-13,   2.752925636270731e-14,  -6.939888745384566e-16,  -5.969596412732113e-18,  -2.489113234443883e-19,  -5.231456726762808e-23,
   4.874000912497249e-22,  -2.910773036374380e-24,  -4.704395085477121e-03,   1.490165340190276e-04,  -1.862627392421806e-06,  -2.478864972781569e-08,   1.588667118481344e-09,
  -3.221373945226369e-11,   3.251679392443771e-13,   2.007314612515163e-14,  -5.066533644271334e-16,  -4.354697651671142e-18,  -1.803492086498280e-19,  -4.658246822274978e-23,
   3.549359970328457e-22,  -2.093858720520409e-24,  -3.045026260956000e-03,   9.645134980710313e-05,  -1.205398649572167e-06,  -1.605196314515961e-08,   1.028394916612444e-09,
  -2.084139732053068e-11,   2.101525837756363e-13,   1.298912589029155e-14,  -3.281176742671663e-16,  -2.818708897022208e-18,  -1.162121267775507e-19,  -3.372762424201724e-23,
   2.294811154399332e-22,  -1.342727575005548e-24,  -1.633439979765067e-03,   5.173846800176833e-05,  -6.465475111814772e-07,  -8.612650032276908e-09,   5.516866319873985e-10,
  -1.117726216494058e-11,   1.126438127821193e-13,   6.966730346221250e-15,  -1.760598465486677e-16,  -1.512046527113802e-18,  -6.219554254871228e-20,  -1.907339050471945e-23,
   1.230289481614671e-22,  -7.168200367553238e-25,  -6.078485964441031e-04,   1.925322144915244e-05,  -2.405901951181631e-07,  -3.205255243988688e-09,   2.053013454697874e-10,
  -4.159025998212182e-12,   4.190649400394871e-14,   2.592383725305037e-15,  -6.552299991029283e-17,  -5.626760130140841e-19,  -2.312605057244178e-20,  -7.224542037884803e-24,
   4.577326797028847e-23,  -2.663011718659217e-25,  -6.866124516677734e-05,   2.174799791549155e-06,  -2.717639457272869e-08,  -3.620630493600981e-10,   2.319045013950420e-11,
  -4.697882743853660e-13,   4.733461147525141e-15,   2.928276347672149e-16,  -7.401445883709816e-18,  -6.355867285779694e-20,  -2.611933776137634e-21,  -8.183399862333411e-25,
   5.170282480422216e-24,  -3.007277572372862e-26,  -1.823040096434224e-02,   2.831965266717883e-04,   8.027569254076326e-06,  -3.484080192145253e-07,   3.247994171671187e-10,
   2.429873940685630e-10,  -3.784193653768713e-12,  -3.845774517988526e-14,   5.016651277809982e-15,  -1.058125524315731e-16,  -4.733856240366677e-18,   1.231334529767074e-19,
   2.375801294231707e-21,  -9.381113763460740e-23,  -1.734342951026033e-02,   2.693908185743945e-04,   7.637159485985917e-06,  -3.313891738622420e-07,   3.073293538692091e-10,
   2.311438704285507e-10,  -3.595989196327705e-12,  -3.669902838456576e-14,   4.766344598294753e-15,  -1.004665061523744e-16,  -4.498938321044322e-18,   1.169296136980388e-19,
   2.260233119627713e-21,  -8.903048171578144e-23,  -1.565640658064258e-02,   2.431433838518217e-04,   6.894533682796760e-06,  -2.990467475630200e-07,   2.747813232107070e-10,
   2.086260264877322e-10,  -3.239692987603099e-12,  -3.330798266888681e-14,   4.292800278844293e-15,  -9.037920542376861e-17,  -4.053992621698261e-18,   1.052171253021389e-19,
   2.040407673702122e-21,  -8.002610437524003e-23,  -1.333460686298347e-02,   2.070412773173082e-04,   5.872354126408166e-06,  -2.545880974706493e-07,   2.313026661241552e-10,
   1.776521180570446e-10,  -2.752562902721109e-12,  -2.855215743695760e-14,   3.645991732783577e-15,  -7.665274293354844e-17,  -3.445251140271710e-18,   8.926604473664029e-20,
   1.737845609703069e-21,  -6.780465506871955e-23,  -1.060540577354037e-02,   1.646315657000529e-04,   4.670656391982657e-06,  -2.023958108111580e-07,   1.818574403111589e-10,
   1.412646127130469e-10,  -2.184035222768135e-12,  -2.284982183020132e-14,   2.891900341093015e-15,  -6.071499063343380e-17,  -2.734283198899944e-18,   7.072829554039383e-20,
   1.382172495731280e-21,  -5.365446806633149e-23,  -7.735976011594196e-03,   1.200681185573603e-04,   3.407067208407522e-06,  -1.475847055664348e-07,   1.314185066063691e-10,
   1.030275100128337e-10,  -1.590088991972447e-12,  -1.675044533231764e-14,   2.104843248362425e-15,  -4.414162766184159e-17,  -1.991063543401763e-18,   5.143501027826871e-20,
   1.008212028567384e-21,  -3.897770291014220e-23,  -5.007141831737581e-03,   7.770591847830050e-05,   2.205288167304728e-06,  -9.550328731895510e-08,   8.453342520476547e-11,
   6.667805375458653e-11,  -1.027898210750527e-12,  -1.087720866340132e-14,   1.360395733901777e-15,  -2.850843943836539e-17,  -1.287259505939096e-18,   3.322458009703807e-20,
   6.525700781618263e-22,  -2.516020771518303e-23,  -2.685935784303516e-03,   4.168069787207737e-05,   1.182976566302638e-06,  -5.122403847179714e-08,   4.520020164616720e-11,
   3.576559557483293e-11,  -5.510300826692958e-13,  -5.844509181002459e-15,   7.292016439650852e-16,  -1.527534771745896e-17,  -6.901095407609260e-19,   1.780394329952538e-20,
   3.500522984834487e-22,  -1.347767277854471e-23,  -9.995065224848842e-04,   1.551016223589990e-05,   4.402181154510299e-07,  -1.906102871014408e-08,   1.680135537593506e-11,
   1.330906028472106e-11,  -2.050065140580761e-13,  -2.176155617100622e-15,   2.712845554454551e-16,  -5.682130136561351e-18,  -2.567554454574872e-19,   6.622925951679474e-21,
   1.302635539191620e-22,  -5.012959676496394e-24,  -1.129019740642191e-04,   1.751986966962493e-06,   4.972606492957537e-08,  -2.153076513419830e-09,   1.897505509189163e-12,
   1.503356616449689e-12,  -2.315624131107447e-14,  -2.458361836087353e-16,   3.064242323051837e-17,  -6.418005866330716e-19,  -2.900157209990174e-20,   7.480678616640740e-22,
   1.471427339663530e-23,  -5.662088758514256e-25,  -2.002002539585077e-02,  -3.077595602542677e-04,   1.710321689438425e-05,   3.912974306283741e-07,  -1.601374513093350e-08,
  -4.737012715105359e-10,   1.642956322115288e-11,   6.773961452351200e-13,  -1.176925275649959e-14,  -8.065246750079155e-16,   4.204015799760855e-18,   7.621436605256621e-19,
   4.962492474757263e-23,  -7.179557969552110e-22,  -1.904574046824462e-02,  -2.927554025069024e-04,   1.626847209181066e-05,   3.721250519750935e-07,  -1.522754193134875e-08,
  -4.502413905154297e-10,   1.562065888783308e-11,   6.435926127833715e-13,  -1.119116814495451e-14,  -7.660644546563180e-16,   3.999542094246524e-18,   7.234377985360739e-19,
   3.936635495136127e-23,  -6.808225717602407e-22,  -1.719274549104836e-02,  -2.642298912168987e-04,   1.468184869131028e-05,   3.357139083671255e-07,  -1.373506333443356e-08,
  -4.057890385287808e-10,   1.408600683838727e-11,   5.796437006234906e-13,  -1.009387190946450e-14,  -6.896083864350411e-16,   3.610584808744799e-18,   6.504864295319483e-19,
   2.315185240518136e-23,  -6.111006432257827e-22,  -1.464271423259107e-02,  -2.249952013942869e-04,   1.250028774045185e-05,   2.857084020331835e-07,  -1.168659308909956e-08,
  -3.449364475839408e-10,   1.198144122621712e-11,   4.923009202135914e-13,  -8.588005649752440e-15,  -5.853489405577757e-16,   3.075202752654130e-18,   5.513726529386624e-19,
   7.121234356929010e-24,  -5.168898201182135e-22,  -1.164547576502823e-02,  -1.789066016977405e-04,   9.938540488080634e-06,   2.270625654269542e-07,  -9.285742233813079e-09,
  -2.738176211039283e-10,   9.517115938194477e-12,   3.904755185183010e-13,  -6.823364709611288e-15,  -4.640111848468308e-16,   2.445818905875461e-18,   4.364863622508952e-19,
  -3.931619194300457e-24,  -4.083414782068657e-22,  -8.494461656472312e-03,  -1.304783670609015e-04,   7.247597690304355e-06,   1.655282061798396e-07,  -6.768109033587589e-09,
  -1.994273092141368e-10,   6.935043876978308e-12,   2.842020672362638e-13,  -4.973143177260320e-15,  -3.375677517146079e-16,   1.784069678110454e-18,   3.171969476105593e-19,
  -8.438351459065344e-24,  -2.962464380782006e-22,  -5.497997795800966e-03,  -8.444292986466860e-05,   4.690206700232182e-06,   1.070962178116233e-07,  -4.378439388489554e-09,
  -1.289496533109659e-10,   4.485702730754177e-12,   1.836838763248932e-13,  -3.217145511925747e-15,  -2.181082261752876e-16,   1.154741773404243e-18,   2.047984108870452e-19,
  -7.822786600358749e-24,  -1.910589554202382e-22,  -2.949220014430945e-03,  -4.529427903686660e-05,   2.515696469199569e-06,   5.743692930979998e-08,  -2.348067913969161e-09,
  -6.913537455571648e-11,   2.405389727818627e-12,   9.845836764545323e-14,  -1.725264487101670e-15,  -1.168921929227757e-16,   6.194257628215795e-19,   1.097182782831162e-19,
  -4.843175209763250e-24,  -1.022989146016896e-22,  -1.097478683460083e-03,  -1.685483179684582e-05,   9.361264336030594e-07,   2.137225597118118e-08,  -8.736969803700370e-10,
  -2.572241876798336e-11,   8.949998777405057e-13,   3.662939991617202e-14,  -6.419536206725474e-16,  -4.348494914315606e-17,   2.305041399547858e-19,   4.081091926976159e-20,
  -1.885845554092971e-24,  -3.804361173078225e-23,  -1.239686364166662e-04,  -1.903877089917708e-06,   1.057421731547588e-07,   2.414134007962825e-09,  -9.868937934497726e-11,
  -2.905462313870373e-12,   1.010952033784811e-13,   4.137402769117906e-15,  -7.251250100475121e-17,  -4.911715470539935e-18,   2.603721585125019e-20,   4.609583795098277e-21,
  -2.145177376460077e-25,  -4.296880922462493e-24,  -8.664281215128985e-03,  -5.836478588024895e-04,  -1.997891128603228e-05,  -2.504929460684282e-07,   1.335885845378908e-08,
   9.531652443781272e-10,   2.799604735149466e-11,   1.321244942060004e-13,  -2.680871178450409e-14,  -1.328614355144399e-15,  -2.795794691091438e-17,   2.398540905448241e-19,
   4.028839352927839e-20,   1.472192277137234e-21,  -8.243438136580732e-03,  -5.552808304689483e-04,  -1.900471717276042e-05,  -2.380252789517227e-07,   1.272147762146185e-08,
   9.068787764327445e-10,   2.661178388619223e-11,   1.242788915292568e-13,  -2.554147938327646e-14,  -1.263565521867622e-15,  -2.651843113584808e-17,   2.315713876124057e-19,
   3.838129459710617e-20,   1.398398332521363e-21,  -7.442706955921396e-03,  -5.013146421197238e-04,  -1.715266767691504e-05,  -2.144256094148620e-07,   1.150405387812671e-08,
   8.188046441777855e-10,   2.398787214454188e-11,   1.099330865873042e-13,  -2.311597376932729e-14,  -1.140000217386565e-15,  -2.381253638016969e-17,   2.144341690399363e-19,
   3.473175358117502e-20,   1.258898674384394e-21,  -6.340129644517307e-03,  -4.270193456448057e-04,  -1.460543916327992e-05,  -1.821669274755498e-07,   9.818629485454430e-09,
   6.975200863380172e-10,   2.039407993349622e-11,   9.130671676470114e-14,  -1.974844583144830e-14,  -9.702544690285812e-16,  -2.015081577133341e-17,   1.881730979986761e-19,
   2.966654466657423e-20,   1.068593995686877e-21,  -5.043383285138092e-03,  -3.396582524502442e-04,  -1.161340095563689e-05,  -1.445275199459795e-07,   7.824929278674512e-09,
   5.548662813082306e-10,   1.619180989493709e-11,   7.082559357630168e-14,  -1.575305816353230e-14,  -7.711322733759508e-16,  -1.592569261043786e-17,   1.539275549984753e-19,
   2.365981648408545e-20,   8.470655486695272e-22,  -3.679354420317911e-03,  -2.477811462121852e-04,  -8.469635783937648e-06,  -1.052149735345045e-07,   5.717118761946962e-09,
   4.048027217319326e-10,   1.179430634344129e-11,   5.060938529835181e-14,  -1.151811808381463e-14,  -5.621704893983139e-16,  -1.155744246873466e-17,   1.147838937213882e-19,
   1.729620372992695e-20,   6.162097097407988e-22,  -2.381701052333019e-03,  -1.603866807354193e-04,  -5.481317184223503e-06,  -6.801152567092761e-08,   3.704414012858596e-09,
   2.620367710300056e-10,   7.626804331169751e-12,   3.230670601607144e-14,  -7.466775396717973e-15,  -3.637278947342411e-16,  -7.455190747023748e-18,   7.536360188317977e-20,
   1.121109568560318e-20,   3.981247134430902e-22,  -1.277656046094208e-03,  -8.603734479325705e-05,  -2.940103493615545e-06,  -3.645820774092191e-08,   1.988222821471930e-09,
   1.405692924081540e-10,   4.089218042658472e-12,   1.720593238702931e-14,  -4.008532792994377e-15,  -1.950726541270347e-16,  -3.992115795499371e-18,   4.072093290352127e-20,
   6.018268020898622e-21,   2.133634451562174e-22,  -4.754570172809353e-04,  -3.201706508746426e-05,  -1.094064333456960e-06,  -1.356386051395746e-08,   7.400115211151661e-10,
   5.231042791905029e-11,   1.521450432957658e-12,   6.386707197831001e-15,  -1.492093173900310e-15,  -7.258658950275098e-17,  -1.484662519991583e-18,   1.519142397513031e-20,
   2.240122734236787e-21,   7.937226396823525e-23,  -5.370668205131328e-05,  -3.616580513031229e-06,  -1.235825674450346e-07,  -1.532085592169716e-09,   8.359255883789052e-11,
   5.908883310983520e-12,   1.718550146898514e-13,   7.211398582311216e-16,  -1.685508552086472e-16,  -8.199125387119804e-18,  -1.676878186102992e-19,   1.716671531098761e-21,
   2.530493359957977e-22,   8.965246596193270e-24,  -4.201598869196915e-04,   1.729570402239236e-05,  -4.773980651479686e-07,   1.067379633192756e-08,  -2.106847669598905e-10,
   4.640815584081636e-12,  -4.787787509195564e-14,   9.467465474216151e-16,  -5.842201499225349e-17,  -7.189510527729031e-19,   1.115764549111664e-20,   1.123377091873434e-21,
   1.415559827270586e-23,   6.555396867188868e-26,  -3.997374199492876e-04,   1.645538992526867e-05,  -4.542149003687776e-07,   1.015600087700880e-08,  -2.004585274177376e-10,
   4.415672305816949e-12,  -4.559762515534868e-14,   8.999396508957055e-16,  -5.556519472051983e-17,  -6.821429414328886e-19,   1.064272597749729e-20,   1.068866320282785e-21,
   1.346892829662378e-23,   6.080290411507050e-26,  -3.608857896922908e-04,   1.485662968778682e-05,  -4.101026095063384e-07,   9.170534122967816e-09,  -1.809983403069394e-10,
   3.987184898562932e-12,  -4.124058315163451e-14,   8.112179869708072e-16,  -5.013730736234134e-17,  -6.128765691623543e-19,   9.651997405056534e-21,   9.651224740048163e-22,
   1.216162083296053e-23,   5.239304347589423e-26,  -3.073998808721614e-04,   1.265537283204920e-05,  -3.493575963028014e-07,   7.813066992909352e-09,  -1.541967466059548e-10,
   3.396958949480025e-12,  -3.520535477775420e-14,   6.897021487251312e-16,  -4.267835449413017e-17,  -5.189878901054534e-19,   8.266475863076691e-21,   8.222234560645728e-22,
   1.036039154647950e-23,   4.204179941614788e-26,  -2.445092087086775e-04,   1.006668774997749e-05,  -2.779100031148499e-07,   6.215890342150904e-09,  -1.226680883748487e-10,
   2.702520793150756e-12,  -2.806209240661055e-14,   5.476059408414043e-16,  -3.392496343274466e-17,  -4.104489783907977e-19,   6.609969288927228e-21,   6.541067363241720e-22,
   8.241190617775781e-24,   3.143448815780249e-26,  -1.783687856345975e-04,   7.343894841639802e-06,  -2.027505399331231e-07,   4.535233891159700e-09,  -8.949681087286509e-11,
   1.971799847945001e-12,  -2.050609245269749e-14,   3.988966310307072e-16,  -2.473528626137761e-17,  -2.980347164894195e-19,   4.842358323372464e-21,   4.772252882964843e-22,
   6.011906474258665e-24,   2.174783315498101e-26,  -1.154562102704373e-04,   4.753742005777973e-06,  -1.312450892982955e-07,   2.935933212038368e-09,  -5.793494731326540e-11,
   1.276461055134866e-12,  -1.328828594303144e-14,   2.579538648067842e-16,  -1.600536785710565e-17,  -1.923215971206942e-19,   3.143133140892969e-21,   3.089258573172954e-22,
   3.891350176524596e-24,   1.356945998633426e-26,  -6.193486319057839e-05,   2.550110479234166e-06,  -7.040646722318871e-08,   1.575029619365175e-09,  -3.107966207411532e-11,
   6.847770745996504e-13,  -7.132421443814305e-15,   1.383075962436017e-16,  -8.584332913451057e-18,  -1.030048342649578e-19,   1.688493455926957e-21,   1.657251102972170e-22,
   2.087420643209906e-24,   7.139047205732085e-27,  -2.304779697706804e-05,   9.489758239722577e-07,  -2.620057545097701e-08,   5.861267581617032e-10,  -1.156582769623086e-11,
   2.548306817805940e-13,  -2.654717167704996e-15,   5.145953372918397e-17,  -3.194287298430060e-18,  -3.830998738133621e-20,   6.286497630300589e-22,   6.167201106680018e-23,
   7.767850978798527e-25,   2.638490639993001e-27,  -2.603430532669644e-06,   1.071943824633136e-07,  -2.959566107368195e-09,   6.620785001392398e-11,  -1.306454457693562e-12,
   2.878522324823064e-14,  -2.998807857467249e-16,   5.812602335174079e-18,  -3.608164198175471e-19,  -4.327036039109691e-21,   7.101653188565606e-23,   6.966354377225835e-24,
   8.774389514468449e-26,   2.977127411212935e-28,  -3.701871229901141e-03,   1.425207400486721e-04,  -3.453483827601614e-06,   6.022050672243692e-08,  -7.172085244863132e-10,
   9.763530564416552e-12,   3.457713146103200e-13,  -7.333665473852276e-15,  -2.597713188959681e-16,  -1.160439887795653e-17,   1.664317511280135e-19,   1.032109601427056e-20,
   1.272059591648610e-22,   7.239783080810495e-25,  -3.521913852395402e-03,   1.355938608617756e-04,  -3.285632795445141e-06,   5.729424982897000e-08,  -6.821698918442794e-10,
   9.283992692325798e-12,   3.287379292496064e-13,  -6.989257295132817e-15,  -2.469112550526006e-16,  -1.102306668931283e-17,   1.585863424906395e-19,   9.820564268624443e-21,
   1.210482198099847e-22,   6.749391313577240e-25,  -3.179572777578111e-03,   1.224159687403415e-04,  -2.966309275672542e-06,   5.172700253391808e-08,  -6.155849224272062e-10,
   8.373731361835476e-12,   2.964261336895932e-13,  -6.329128099087086e-15,  -2.225408243325482e-16,  -9.924169043036434e-18,   1.435619786416495e-19,   8.867845671660445e-21,
   1.093193101265355e-22,   5.871986929628208e-25,  -2.708299655434552e-03,   1.042739194535082e-04,  -2.526697593512559e-06,   4.406206587079730e-08,  -5.240595704617310e-10,
   7.124507919877400e-12,   2.521224130096095e-13,  -5.410817923852939e-15,  -1.891744401809677e-16,  -8.424974124933390e-18,   1.226858314933511e-19,   7.555323564030078e-21,
   9.314855183840816e-23,   4.772523215696861e-25,  -2.154182254607263e-03,   8.294129738736691e-05,  -2.009775818664148e-06,   3.504851138864655e-08,  -4.166180380172496e-10,
   5.660586469879536e-12,   2.002546352805328e-13,  -4.319012396081260e-15,  -1.501742134077706e-16,  -6.679416387820971e-18,   9.789512426601583e-20,   6.010888325996801e-21,
   7.411042016769062e-23,   3.618203196711079e-25,  -1.571453047295897e-03,   6.050584904249570e-05,  -1.466133501436787e-06,   2.556841566899567e-08,  -3.037897784137513e-10,
   4.125659029994846e-12,   1.459171494757117e-13,  -3.159616557662152e-15,  -1.093767457462287e-16,  -4.859745589839116e-18,   7.159609049418233e-20,   4.385662344711911e-21,
   5.407192683733632e-23,   2.534429329439631e-25,  -1.017177548619358e-03,   3.916496272555087e-05,  -9.490158206537890e-07,   1.655042903559775e-08,  -1.965834874787585e-10,
   2.668900679033653e-12,   9.437879502056008e-14,  -2.048991202905334e-15,  -7.072349567503796e-17,  -3.140156646651931e-18,   4.642117203192193e-20,   2.839098040108068e-21,
   3.500302563703450e-23,   1.595429556650630e-25,  -5.456486250028156e-04,   2.100954202284810e-05,  -5.090871110334932e-07,   8.878318683954955e-09,  -1.054389221637889e-10,
   1.431254755300801e-12,   5.060840480643941e-14,  -1.100199930250561e-15,  -3.791797723202490e-17,  -1.682976457090651e-18,   2.492341484681129e-20,   1.523076956950139e-21,
   1.877752863701587e-23,   8.434019681828794e-26,  -2.030517564023826e-04,   7.818279008294543e-06,  -1.894465081631816e-07,   3.303894838196580e-09,  -3.923493463789043e-11,
   5.325553345173199e-13,   1.883032562860666e-14,  -4.095525843211602e-16,  -1.410772699001277e-17,  -6.260889646921627e-19,   9.277516336554887e-21,   5.667926630462140e-22,
   6.987750252885627e-24,   3.122416097570013e-26,  -2.293629348981910e-05,   8.831364164218424e-07,  -2.139948004891217e-08,   3.732011623712056e-10,  -4.431859411368086e-12,
   6.015530635014614e-14,   2.126987967538333e-15,  -4.626462647927274e-17,  -1.593531123351720e-18,  -7.071816803903911e-20,   1.048018426779724e-21,   6.402389352390958e-23,
   7.893228429938862e-25,   3.524122856722036e-27,  -9.752511991017399e-03,   3.141308292865585e-04,  -4.780319965893245e-06,  -9.168782667295801e-09,   2.486292631254675e-09,
  -4.639064319407842e-11,   1.493389506614595e-12,   7.164531068451764e-16,  -1.775801873088373e-15,  -1.726277771171780e-17,   3.181828151843850e-19,   3.155295564270291e-20,
   5.066659583872930e-22,  -2.407911688440572e-24,  -9.278288053983475e-03,   2.988505578681219e-04,  -4.547358506957029e-06,  -8.736600859496791e-09,   2.366018861488017e-09,
  -4.413382488437073e-11,   1.419274796024744e-12,   6.634830318028526e-16,  -1.688992441419840e-15,  -1.637157615226386e-17,   3.037049985207704e-19,   3.001213070850285e-20,
   4.824414078903106e-22,  -2.326903535052410e-24,  -8.376203007589693e-03,   2.697860959094676e-04,  -4.104420234798594e-06,  -7.908936886123115e-09,   2.136975258395384e-09,
  -3.984126402378347e-11,   1.278900560189530e-12,   5.701699203489266e-16,  -1.524045563303307e-15,  -1.469737039666553e-17,   2.757616948971616e-19,   2.708365970196544e-20,
   4.361786293084539e-22,  -2.158432246049948e-24,  -7.134477958464544e-03,   2.297829596637235e-04,  -3.495118636750838e-06,  -6.758886896374220e-09,   1.821202527462310e-09,
  -3.393336101004133e-11,   1.086855488297994e-12,   4.560898116413397e-16,  -1.297355779481067e-15,  -1.243365071697523e-17,   2.365149712194674e-19,   2.305764148238632e-20,
   3.721588557412373e-22,  -1.898369017388185e-24,  -5.674601492758962e-03,   1.827572954070643e-04,  -2.779285767472753e-06,  -5.393163823211114e-09,   1.449330926968854e-09,
  -2.698856105104612e-11,   8.625650864698532e-13,   3.400364336938046e-16,  -1.031299331325218e-15,  -9.823897329247292e-18,   1.893809824701494e-19,   1.833087229725833e-20,
   2.964845803960324e-22,  -1.556525842662771e-24,  -4.139464974679405e-03,   1.333123740951626e-04,  -2.027028880867973e-06,  -3.944329108381977e-09,   1.057709248758076e-09,
  -1.968667738140175e-11,   6.281041514620807e-13,   2.347406832580472e-16,  -7.519576974855604e-16,  -7.127755154912696e-18,   1.388906023057528e-19,   1.336670518426304e-20,
   2.165491503825208e-22,  -1.163009867776951e-24,  -2.679371169615059e-03,   8.628801342377525e-05,  -1.311880662036547e-06,  -2.557412156382887e-09,   6.848260700930418e-10,
  -1.274237922096128e-11,   4.060799406965084e-13,   1.462659901208950e-16,  -4.865745949860019e-16,  -4.597150170152552e-18,   9.021809483647140e-20,   8.649699937456890e-21,
   1.402802229631295e-22,  -7.646338963740811e-25,  -1.437294435813982e-03,   4.628698438513555e-05,  -7.036866588251639e-07,  -1.373069619726377e-09,   3.674154825295113e-10,
  -6.835306546606927e-12,   2.177022511920028e-13,   7.690044875991103e-17,  -2.609720856482743e-16,  -2.461512753257157e-18,   4.848322526469247e-20,   4.639337903700694e-21,
   7.528126198051765e-23,  -4.134452853767871e-25,  -5.348576772986231e-04,   1.722462711426405e-05,  -2.618557430157555e-07,  -5.111129351493251e-10,   1.367326768706499e-10,
  -2.543598814605246e-12,   8.099614856101328e-14,   2.841479003576676e-17,  -9.710973672268627e-17,  -9.154107133313421e-19,   1.805331348571799e-20,   1.726347739745241e-21,
   2.801823278428605e-23,  -1.542790802601434e-25,  -6.041635649794405e-05,   1.945655204751122e-06,  -2.957854864555924e-08,  -5.773698267691764e-11,   1.544515116265176e-11,
  -2.873191771498647e-13,   9.148843881567805e-15,   3.206052171404844e-18,  -1.096920873552572e-17,  -1.033922684279753e-19,   2.039466222728717e-21,   1.950030332175308e-22,
   3.164949258159813e-24,  -1.743463973681591e-26,  -1.699508233445357e-02,   3.311184404470727e-04,   4.021906316188284e-06,  -3.093632242072675e-07,   4.264101893649811e-09,
   1.528483435009898e-10,  -3.378443929223109e-12,   3.651076118480684e-14,  -7.098388728430369e-16,  -1.692216062710814e-16,   1.671081854481737e-18,   1.416699104678444e-19,
  -8.289285262221371e-22,  -9.683198868382782e-24,  -1.616831523741959e-02,   3.149852257788768e-04,   3.827036404098293e-06,  -2.942701858317477e-07,   4.055185747686693e-09,
   1.454356993689938e-10,  -3.214693478462676e-12,   3.455534313972538e-14,  -6.730891535410743e-16,  -1.607591951676072e-16,   1.588229597466546e-18,   1.347549328642804e-19,
  -7.835288536063370e-22,  -9.332980486125271e-24,  -1.459575978938788e-02,   2.843092126424674e-04,   3.456063776369912e-06,  -2.655800091098776e-07,   3.658416527081866e-09,
   1.313269364239092e-10,  -2.902984055462161e-12,   3.090922683930753e-14,  -6.040933839844523e-16,  -1.447568477071920e-16,   1.431287053117832e-18,   1.216112676485983e-19,
  -6.992820333284328e-22,  -8.618430673414914e-24,  -1.243141798286851e-02,   2.421089837459004e-04,   2.944866878205214e-06,  -2.261272247854823e-07,   3.113499272805713e-09,
   1.118904444407065e-10,  -2.473494748141631e-12,   2.603258416195219e-14,  -5.108833919760933e-16,  -1.229139340189518e-16,   1.216524581585494e-18,   1.035391830202162e-19,
  -5.873715633034372e-22,  -7.540413019105432e-24,  -9.887202005232932e-03,   1.925270773049972e-04,   2.343163843310732e-06,  -1.797930996301021e-07,   2.474415991688312e-09,
   8.901962647255883e-11,  -1.968023744982225e-12,   2.047874273317281e-14,  -4.035252729620045e-16,  -9.746690312651953e-17,   9.656185497799665e-19,   8.231833906247895e-20,
  -4.608680505706201e-22,  -6.152417879548231e-24,  -7.212167333200647e-03,   1.404191519322769e-04,   1.709792325478043e-06,  -1.311168659522456e-07,   1.803848206845182e-09,
   6.495166401547492e-11,  -1.436006496956241e-12,   1.480551462739866e-14,  -2.927053666043501e-16,  -7.092548803212228e-17,   7.032385199015140e-19,   6.002850433092805e-20,
  -3.325077518030702e-22,  -4.579493349652216e-24,  -4.668136941884044e-03,   9.087949553001560e-05,   1.106927325749149e-06,  -8.485271181360525e-08,   1.167084989285706e-09,
   4.204766026441798e-11,  -9.296559962815029e-13,   9.526352540852357e-15,  -1.887534559227813e-16,  -4.583390400026734e-17,   4.546978533811472e-19,   3.884610949596160e-20,
  -2.136574793019081e-22,  -3.003446906249383e-24,  -2.504095383679595e-03,   4.874763537715958e-05,   5.938498820483926e-07,  -4.551313263601647e-08,   6.259212588790124e-10,
   2.255728832613495e-11,  -4.987405802658410e-13,   5.094560490849374e-15,  -1.010582097313860e-16,  -2.456618400759543e-17,   2.437787297046053e-19,   2.083576464701917e-20,
  -1.141821665799680e-22,  -1.621974557019644e-24,  -9.318401386450881e-04,   1.813999932149224e-05,   2.209961563740098e-07,  -1.693614825535209e-08,   2.329050449625149e-10,
   8.394417568237972e-12,  -1.856012748278753e-13,   1.893801788422732e-15,  -3.758138142849075e-17,  -9.139114616116211e-18,   9.069949610878427e-20,   7.753256528969480e-21,
  -4.243477790914553e-23,  -6.049871692819427e-25,  -1.052585546044717e-04,   2.049048181537713e-06,   2.496338563156225e-08,  -1.913060176669089e-09,   2.630812574058505e-11,
   9.482189717738304e-13,  -2.096522050743740e-14,   2.138833812357089e-16,  -4.244658828666775e-18,  -1.032286892426087e-18,   1.024490504029650e-20,   8.757852509072793e-22,
  -4.792343477080953e-24,  -6.836321910695892e-26,  -2.095456277828344e-02,  -1.570603395997280e-04,   2.003329620878695e-05,   8.607284839698765e-08,  -2.033287797452760e-08,
   8.153533938123435e-11,   2.634782343017707e-11,  -7.094339678084307e-14,  -3.062025384130591e-14,  -9.028878821888511e-17,   2.615726421674087e-17,   5.397165544712688e-20,
  -2.124507962098733e-20,   1.905879362922908e-22,  -1.993473565462870e-02,  -1.494131496971280e-04,   1.905527161229618e-05,   8.191033930121758e-08,  -1.933222710238129e-08,
   7.752468963919669e-11,   2.504096536871635e-11,  -6.758867991031607e-14,  -2.909621323214263e-14,  -8.580473383794599e-17,   2.484402858779045e-17,   5.177870756550423e-20,
  -2.014420508846044e-20,   1.806041684029354e-22,  -1.799514925274665e-02,  -1.348704662218246e-04,   1.719642371545367e-05,   7.398296143094662e-08,  -1.743362789489179e-08,
   6.991408368448938e-11,   2.256549292795342e-11,  -6.116847190403544e-14,  -2.621147888539445e-14,  -7.731213297646847e-17,   2.236292641459983e-17,   4.742948656897026e-20,
  -1.807805832177793e-20,   1.619036374582282e-22,  -1.532600291748975e-02,  -1.148602632178830e-04,   1.464077765839169e-05,   6.305284932817626e-08,  -1.482962854409062e-08,
   5.947416555141979e-11,   1.917826679386322e-11,  -5.225602758708084e-14,  -2.226837011151577e-14,  -6.569494722147438e-17,   1.898041705363511e-17,   4.110044938158104e-20,
  -1.528783601973547e-20,   1.367266045341001e-22,  -1.218882205667116e-02,  -9.134456462880668e-05,   1.164002464543877e-05,   5.017969172445017e-08,  -1.178006451311548e-08,
   4.724596904327910e-11,   1.522156321012370e-11,  -4.168309507170550e-14,  -1.766752445631225e-14,  -5.213058188744699e-17,   1.504482443797234e-17,   3.322967737131987e-20,
  -1.207495767726748e-20,   1.078411472846314e-22,  -8.890743748801940e-03,  -6.662588517356668e-05,   8.488188872326837e-06,   3.662166275283823e-08,  -8.584377270474432e-09,
   3.443024237865993e-11,   1.108469946478700e-11,  -3.047699509206051e-14,  -1.286202725535463e-14,  -3.795570780592238e-17,   1.094447754164669e-17,   2.455558881697223e-20,
  -8.758864682238386e-21,   7.813336782331248e-23,  -5.754469541293935e-03,  -4.312206635964026e-05,   5.492956006415332e-06,   2.371152946134119e-08,  -5.552666918229639e-09,
   2.227110342548274e-11,   7.166723564200903e-12,  -1.975703956993156e-14,  -8.314184631008258e-15,  -2.453673854375707e-17,   7.071158248460824e-18,   1.602866946271944e-20,
  -5.648308312966109e-21,   5.034541939854901e-23,  -3.086790374343890e-03,  -2.313108171266744e-05,   2.946245139724309e-06,   1.272156713762801e-08,  -2.977573970580609e-09,
   1.194282406835592e-11,   3.842207563542991e-12,  -1.060653725495102e-14,  -4.456926034409876e-15,  -1.315365626376668e-17,   3.789624939664985e-18,   8.635218351721009e-21,
  -3.024125864090144e-21,   2.694387202230175e-23,  -1.148671353960845e-03,  -8.607612238578534e-06,   1.096336643606113e-06,   4.734311495951769e-09,  -1.107904099272891e-09,
   4.443734838015688e-12,   1.429503917149677e-12,  -3.948062049366770e-15,  -1.658152611206219e-15,  -4.893732148479407e-18,   1.409765938148181e-18,   3.218190536025868e-21,
  -1.124612506088192e-21,   1.001842391078462e-23,  -1.297512285688641e-04,  -9.722950633700674e-07,   1.238390066518788e-07,   5.347821348286069e-10,  -1.251440122808222e-10,
   5.019451674013471e-13,   1.614684542507923e-13,  -4.459836776744379e-16,  -1.872942242147512e-16,  -5.527653437751656e-19,   1.592358403798522e-19,   3.636054920595317e-22,
  -1.270203402276544e-22,   1.131513247398612e-24,  -1.133023732616515e-02,  -7.501862215653181e-04,  -2.095716475998181e-05,   1.511432892926971e-07,   3.872816457475677e-08,
   1.521924187529234e-09,   1.129396757927933e-11,  -1.640278321580397e-12,  -8.490645729673049e-14,  -1.378064283682374e-15,   5.314978205915721e-17,   3.953320686937241e-18,
   9.540554396561869e-20,  -1.016379188516484e-21,  -1.077974369965161e-02,  -7.136825715091649e-04,  -1.993088137687575e-05,   1.442409237453627e-07,   3.684918143619770e-08,
   1.446866506162726e-09,   1.067436303302335e-11,  -1.561925295952385e-12,  -8.070399171221115e-14,  -1.304595635509025e-15,   5.074694579919604e-17,   3.758457473620816e-18,
   9.033345865800297e-20,  -9.828741034149949e-22,  -9.732393219475719e-03,  -6.442542784718077e-04,  -1.798158587743388e-05,   1.309288024591109e-07,   3.327316208430908e-08,
   1.304516060135735e-09,   9.524448016269383e-12,  -1.412297957450157e-12,  -7.273959670332907e-14,  -1.167473235322841e-15,   4.610117286074111e-17,   3.388800599515114e-18,
   8.086104512579494e-20,  -9.125693741441329e-22,  -8.290355705912938e-03,  -5.487056833903326e-04,  -1.530406319925657e-05,   1.122517526369963e-07,   2.834739511458422e-08,
   1.109398661836195e-09,   7.997179300157985e-12,  -1.205217003216169e-12,  -6.183443415399019e-14,  -9.838208970857322e-16,   3.956195426562479e-17,   2.881990632231392e-18,
   6.816335597182453e-20,  -8.031528286450945e-22,  -6.594527616913383e-03,  -4.363959007675859e-04,  -1.216335050244146e-05,   8.984745792353661e-08,   2.255206547263070e-08,
   8.810531293037335e-10,   6.271838549066869e-12,  -9.603543351521182e-13,  -4.908716498026947e-14,  -7.743468550920310e-16,   3.169303798428457e-17,   2.288781569473852e-18,
   5.366689403526640e-20,  -6.586609378384584e-22,  -4.810858822790980e-03,  -3.183198423336185e-04,  -8.867448764320163e-06,   6.587295244775385e-08,   1.645413231519774e-08,
   6.419173127914541e-10,   4.522926593243131e-12,  -7.015755220730953e-13,  -3.575197011976389e-14,  -5.600725255785395e-16,   2.325146471132168e-17,   1.667521565944111e-18,
   3.882603829824869e-20,  -4.920772227092390e-22,  -3.114089893667113e-03,  -2.060323000347802e-04,  -5.737374832882262e-06,   4.277968399941474e-08,   1.065162903376003e-08,
   4.151602124067540e-10,   2.905265329307806e-12,  -4.545479873079403e-13,  -2.311743383633742e-14,  -3.604725493736264e-16,   1.510642048773094e-17,   1.078444465675967e-18,
   2.499317785547330e-20,  -3.234513859226770e-22,  -1.670529725990279e-03,  -1.105196250522095e-04,  -3.077064740640427e-06,   2.298733965061329e-08,   5.714203260176944e-09,
   2.226115131415942e-10,   1.552327555413973e-12,  -2.439528217675926e-13,  -1.239428096616586e-14,  -1.928041726331797e-16,   8.119013149818338e-18,   5.782600880254650e-19,
   1.336908388264516e-20,  -1.748670973850443e-22,  -6.216561679718425e-04,  -4.112717112528288e-05,  -1.144980217794784e-06,   8.559291679226617e-09,   2.126461284776568e-09,
   8.282798469187048e-11,   5.768692277278755e-13,  -9.079719699250853e-14,  -4.611405189939927e-15,  -7.167481321687004e-17,   3.023315725057087e-18,   2.151544112354831e-19,
   4.970090053208372e-21,  -6.524867672376666e-23,  -7.022101572692103e-05,  -4.645630350936797e-06,  -1.293329960997037e-07,   9.669295433176995e-10,   2.402012443756443e-10,
   9.355853014568275e-12,   6.514763118630935e-14,  -1.025653089711431e-14,  -5.208789366093382e-16,  -8.094921370654198e-18,   3.415430333949021e-19,   2.430279115949747e-20,
   5.613223040833651e-22,  -7.373496744431286e-24,  -3.578763099388358e-04,   1.393823228209462e-05,  -3.666626360213509e-07,   7.987894559676017e-09,  -1.283856138022468e-10,
   3.580383289917632e-12,  -5.019892476258249e-14,  -1.141887523161634e-15,  -6.252277165086864e-17,   9.130578280294733e-19,   7.433723876861735e-20,   1.585450536018583e-21,
  -1.056159385626961e-23,  -1.818321322623673e-24,  -3.404800228950625e-04,   1.326098654905371e-05,  -3.488510011042733e-07,   7.600423000765135e-09,  -1.221634783376270e-10,
   3.405524051378867e-12,  -4.780871049701098e-14,  -1.085351015329539e-15,  -5.938238403388467e-17,   8.711978304309923e-19,   7.069837163617673e-20,   1.504068626666771e-21,
  -1.025984912097173e-23,  -1.733507866065883e-24,  -3.073858751882339e-04,   1.197249834711327e-05,  -3.149619332383096e-07,   6.862976254881363e-09,  -1.103191261401116e-10,
   3.073210739481134e-12,  -4.324121521835165e-14,  -9.782127352378253e-16,  -5.344940090860793e-17,   7.905286199425484e-19,   6.378564329242170e-20,   1.350993391651297e-21,
  -9.598860457557886e-24,  -1.570638091302581e-24,  -2.618270721915277e-04,   1.019848354308082e-05,  -2.682995468629133e-07,   5.847130465352042e-09,  -9.399900694426033e-11,
   2.616379668919912e-12,  -3.691391923037463e-14,  -8.315298753366176e-16,  -4.536161824371337e-17,   6.774769111246756e-19,   5.428873109103165e-20,   1.143654073597671e-21,
  -8.521189793246817e-24,  -1.343539841367708e-24,  -2.082585779819506e-04,   8.112291229342370e-06,  -2.134217176213584e-07,   4.651872444934815e-09,  -7.479101680391983e-11,
   2.080048821342909e-12,  -2.942441457166661e-14,  -6.600873458263705e-16,  -3.595287202760037e-17,   5.420341389374558e-19,   4.314763999073117e-20,   9.041706552627432e-22,
  -7.043096555811658e-24,  -1.072969223152780e-24,  -1.519231564907376e-04,   5.918073965284974e-06,  -1.556983887736363e-07,   3.394116113985256e-09,  -5.457348066387744e-11,
   1.516774545999961e-12,  -2.150178732810118e-14,  -4.807535639840256e-16,  -2.615218915906657e-17,   3.972639638912322e-19,   3.145562386482662e-20,   6.563489018209759e-22,
  -5.293216677910234e-24,  -7.852128974569467e-25,  -9.833785400734961e-05,   3.830783142161181e-06,  -1.007852587954228e-07,   2.197226587359755e-09,  -3.533067205883417e-11,
   9.815290069875884e-13,  -1.393357526777433e-14,  -3.108530374448446e-16,  -1.689582530450356e-17,   2.579346285105083e-19,   2.035202600698148e-20,   4.234593770474878e-22,
  -3.492480850212549e-24,  -5.093088450292856e-25,  -5.275185579301844e-05,   2.054991069003449e-06,  -5.406576138549322e-08,   1.178740619104341e-09,  -1.895425302400274e-11,
   5.264550482982211e-13,  -7.478791335328400e-15,  -1.666607250376057e-16,  -9.054657730226579e-18,   1.385826793214969e-19,   1.091509823149411e-20,   2.267760643766045e-22,
  -1.891709223180995e-24,  -2.734982424244929e-25,  -1.963051427842738e-05,   7.647257912714792e-07,  -2.011959083383873e-08,   4.386532663646273e-10,  -7.053647521269269e-12,
   1.959001393857217e-13,  -2.783639124399535e-15,  -6.200746583434250e-17,  -3.368357504996040e-18,   5.159884075093179e-20,   4.061511549775696e-21,   8.434049275809733e-23,
  -7.063187154294820e-25,  -1.018137897153417e-25,  -2.217421242048769e-06,   8.638186166580673e-08,  -2.272668688812612e-09,   4.954950851688417e-11,  -7.967688851570315e-13,
   2.212829847631973e-14,  -3.144440292612335e-16,  -7.004018739424630e-18,  -3.804619673096872e-19,   5.829000177267640e-21,   4.587740398432946e-22,   9.526035034722856e-24,
  -7.982652366981357e-26,  -1.150133330330568e-26,  -3.182719926489551e-03,   1.176057124369114e-04,  -2.792026266766058e-06,   5.066720021592004e-08,  -4.618340789679165e-10,
   1.434256451529020e-11,  -2.390219920903521e-14,  -2.004673326544242e-14,  -4.315244249500871e-16,   5.938700632511710e-18,   7.471942898747912e-19,   1.465437564754028e-20,
  -9.232289832925967e-23,  -1.688503763094196e-23,  -3.027994507888503e-03,   1.118898589264467e-04,  -2.656303599522007e-06,   4.820695650651529e-08,  -4.393823281814043e-10,
   1.363245251407572e-11,  -2.309309148773083e-14,  -1.906513578556901e-14,  -4.095370052596881e-16,   5.673420981879982e-18,   7.106467555215172e-19,   1.390192929573157e-20,
  -8.986603319835483e-23,  -1.610093292987967e-23,  -2.733655488997407e-03,   1.010158199558205e-04,  -2.398110253100607e-06,   4.352557225882018e-08,  -3.966718943710341e-10,
   1.228681942463362e-11,  -2.140924527723030e-14,  -1.720064086709806e-14,  -3.681204558841875e-16,   5.159154182930389e-18,   6.412065383849353e-19,   1.248669327049885e-20,
  -8.435806642153043e-23,  -1.459369017690479e-23,  -2.328467077064500e-03,   8.604542210087092e-05,  -2.042672656421262e-06,   3.707886460213122e-08,  -3.378767659392195e-10,
   1.044455893949296e-11,  -1.881194083634718e-14,  -1.463948714339928e-14,  -3.119023018621746e-16,   4.432656357639734e-18,   5.457856131305029e-19,   1.056992904423986e-20,
  -7.516644014880763e-23,  -1.248919973187726e-23,  -1.852056598056967e-03,   6.844214733951683e-05,  -1.624748483862266e-06,   2.949609112454352e-08,  -2.687468989602805e-10,
   8.291305629021083e-12,  -1.540630322403306e-14,  -1.163518327925906e-14,  -2.468093613920047e-16,   3.555108815022674e-18,   4.338165330137998e-19,   8.356233115248136e-21,
  -6.233447031022266e-23,  -9.978325442638878e-24,  -1.351051641716570e-03,   4.992875675900629e-05,  -1.185240336445584e-06,   2.151916899331667e-08,  -1.960479233011183e-10,
   6.038845440406843e-12,  -1.149847954984957e-14,  -8.482391940049025e-15,  -1.792942257325532e-16,   2.610616017159406e-18,   3.162839462569440e-19,   6.065691798297617e-21,
  -4.696380298812287e-23,  -7.304757803524538e-24,  -8.745133957469792e-04,   3.231852270027496e-05,  -7.671894989042077e-07,   1.392991963336252e-08,  -1.268988333608573e-10,
   3.904759015632798e-12,  -7.553647253557228e-15,  -5.488227503920449e-15,  -1.157334913682383e-16,   1.697150502971314e-18,   2.046474365789881e-19,   3.913338174228830e-21,
  -3.103517249050917e-23,  -4.739105703816720e-24,  -4.691182565929809e-04,   1.733686507930971e-05,  -4.115469580838696e-07,   7.472727645435892e-09,  -6.807285851275950e-11,
   2.093518099387576e-12,  -4.082532923169870e-15,  -2.943438450286556e-15,  -6.199498982674219e-17,   9.124277874674485e-19,   1.097580856696141e-19,   2.095692821793148e-21,
  -1.682330769801440e-23,  -2.545183559948606e-24,  -1.745725155067433e-04,   6.451567101506233e-06,  -1.531486725724573e-07,   2.780851484011893e-09,  -2.533189626780478e-11,
   7.789130896021596e-13,  -1.523177542320378e-15,  -1.095257128431318e-15,  -2.305869510242957e-17,   3.398022351771704e-19,   4.084135379944901e-20,   7.794077411993819e-22,
  -6.283091014603919e-24,  -9.475198465280791e-25,  -1.971933807579357e-05,   7.287555214905008e-07,  -1.729934851867756e-08,   3.141196235127721e-10,  -2.861437025182019e-12,
   8.798174478091642e-14,  -1.721256434232204e-16,  -1.237164380101995e-16,  -2.604455848532795e-18,   3.838801811364355e-20,   4.613301487212285e-21,   8.803197877696331e-23,
  -7.101304356102075e-25,  -1.070366774483544e-25,  -8.572293455770886e-03,   2.760661211528556e-04,  -4.676243689128209e-06,   2.502216287611962e-08,   1.883454138226009e-09,
  -1.714135322453108e-11,   6.597415438070966e-13,  -6.046949962627710e-14,  -1.771861597307671e-15,   2.982867024423314e-17,   2.166844468383588e-18,   4.763417053297732e-20,
  -2.353055624265490e-22,  -5.144828920032380e-23,  -8.155472803115838e-03,   2.626403956855157e-04,  -4.448452978012099e-06,   2.379986482535609e-08,   1.792130938738571e-09,
  -1.634519173434082e-11,   6.261931066786184e-13,  -5.749579204411105e-14,  -1.682783229942186e-15,   2.845451673811114e-17,   2.060915657981588e-18,   4.519605949174651e-20,
  -2.302530029344610e-22,  -4.908490379124905e-23,  -7.362576489331875e-03,   2.371022446266615e-04,  -4.015306068376343e-06,   2.147701862742724e-08,   1.618305683876573e-09,
  -1.481549192346345e-11,   5.629762855889244e-13,  -5.185254084250023e-14,  -1.514523607263135e-15,   2.580926036313304e-17,   1.859626359585963e-18,   4.060731421173300e-20,
  -2.180203293050806e-22,  -4.453075237621434e-23,  -6.271139154623444e-03,   2.019502437139139e-04,  -3.419395751526542e-06,   1.828398759946642e-08,   1.378827428978635e-09,
  -1.268038220796852e-11,   4.771183129988105e-13,  -4.411073802655363e-14,  -1.285216179528104e-15,   2.210764775594277e-17,   1.582978788667012e-18,   3.438653089083899e-20,
  -1.961225747625340e-22,  -3.815079945097783e-23,  -4.987939419286806e-03,   1.606243719958537e-04,  -2.719197062308143e-06,   1.453555864861187e-08,   1.097016176194596e-09,
  -1.013290778078950e-11,   3.776401593326907e-13,  -3.504211184283164e-14,  -1.018536445984262e-15,   1.767968161105413e-17,   1.258296830450756e-18,   2.719458089029840e-20,
  -1.640094897919484e-22,  -3.051263331794044e-23,  -3.638574531109358e-03,   1.171697134078824e-04,  -1.983277894560568e-06,   1.059910110835138e-08,   8.004352819081100e-10,
  -7.419405640239341e-12,   2.743937249478429e-13,  -2.553716884506945e-14,  -7.408234912830000e-16,   1.295293406866123e-17,   9.174303415090153e-19,   1.974594792842370e-20,
  -1.243366931825380e-22,  -2.235567090056001e-23,  -2.355161949785436e-03,   7.584042966089874e-05,  -1.283596869314297e-06,   6.858736631078860e-09,   5.181836153613660e-10,
  -4.814247797716307e-12,   1.771450408122465e-13,  -1.651881436189457e-14,  -4.785881869979498e-16,   8.408042395424657e-18,   5.936282947486312e-19,   1.274173110578110e-20,
  -8.248370494368876e-23,  -1.451154489740659e-23,  -1.263380206328472e-03,   4.068290716623011e-05,  -6.885240673409423e-07,   3.678735758455400e-09,   2.779916905837727e-10,
  -2.585770282355959e-12,   9.489841306642408e-14,  -8.858218484980382e-15,  -2.564733013111513e-16,   4.516908424486339e-18,   3.183838896356629e-19,   6.824197700021171e-21,
  -4.479787685243124e-23,  -7.795724792168371e-24,  -4.701394631464973e-04,   1.513923353357264e-05,  -2.562145698570105e-07,   1.368896920979786e-09,   1.034514479357406e-10,
  -9.626605991626739e-13,   3.529786608207538e-14,  -3.296007928043679e-15,  -9.540781845211975e-17,   1.681720891537662e-18,   1.184723124070533e-19,   2.538070261660063e-21,
  -1.674188899004527e-23,  -2.902467751107669e-24,  -5.310593109260432e-05,   1.710094432410148e-06,  -2.894135650107445e-08,   1.546264609028617e-10,   1.168570226824197e-11,
  -1.087476189905516e-13,   3.986874194318150e-15,  -3.723029765664825e-16,  -1.077646558870398e-17,   1.899787968386977e-19,   1.338224319378551e-20,   2.866696807720550e-22,
  -1.892405743816059e-24,  -3.278825610691700e-25,  -1.562786039650738e-02,   3.498091070814348e-04,   8.062055066681035e-07,  -2.208512003958455e-07,   6.558511289436522e-09,
   7.658781510343650e-11,  -3.430780722434087e-12,  -5.926631805056581e-14,  -4.198703402057301e-15,   1.133509611874145e-17,   7.113137757317884e-18,   1.056713376433769e-19,
  -1.245954535512659e-21,  -8.540147700785370e-23,  -1.486769042467189e-02,   3.327746226593922e-04,   7.681575343978154e-07,  -2.100862693310511e-07,   6.237960024553183e-09,
   7.282562028628155e-11,  -3.267347215911526e-12,  -5.637028074977404e-14,  -3.984982572027106e-15,   1.095456558965740e-17,   6.764523809941957e-18,   1.003268378207410e-19,
  -1.201877942919834e-21,  -8.173603849505218e-23,  -1.342177160752318e-02,   3.003810989332973e-04,   6.953116360084424e-07,  -1.896193772443808e-07,   5.628860375790530e-09,
   6.568452618443631e-11,  -2.955068758818103e-12,  -5.086684590110358e-14,  -3.582325490342590e-15,   1.016085488970053e-17,   6.102444357380193e-18,   9.024262994922072e-20,
  -1.111266490339481e-21,  -7.455949905503266e-23,  -1.143165528775637e-02,   2.558107300481701e-04,   5.941284933462855e-07,  -1.614669860293121e-07,   4.791720709497549e-09,
   5.588477533831306e-11,  -2.522532249486963e-12,  -4.330226155169044e-14,  -3.035602868315327e-15,   8.933338064972465e-18,   5.193199003181292e-18,   7.652270807432360e-20,
  -9.734724850636991e-22,  -6.429121022884573e-23,  -9.092158883459333e-03,   2.034347258904357e-04,   4.740173126009141e-07,  -1.283944631019591e-07,   3.809144118148498e-09,
   4.440132488510760e-11,  -2.010625697424864e-12,  -3.442290818971935e-14,  -2.402362541355921e-15,   7.320034755282890e-18,   4.126952911342812e-18,   6.059857726379085e-20,
  -7.950139558895307e-22,  -5.173453379978530e-23,  -6.632290765863610e-03,   1.483816143492493e-04,   3.466408125227999e-07,  -9.364100450989722e-08,   2.777440900231461e-09,
   3.236125119052559e-11,  -1.469192770911677e-12,  -2.509939828287794e-14,  -1.745357880765551e-15,   5.465599364635498e-18,   3.008354920819069e-18,   4.404782768954877e-20,
  -5.920899556666196e-22,  -3.808704558492310e-23,  -4.292834009012538e-03,   9.603580554473294e-05,   2.247388473464583e-07,  -6.060324605504085e-08,   1.797243264433506e-09,
   2.093452485817245e-11,  -9.520370896562646e-13,  -1.624138284748176e-14,  -1.126690895766505e-15,   3.591467067696597e-18,   1.946306692446969e-18,   2.844353384393438e-20,
  -3.884296156983541e-22,  -2.480050019168462e-23,  -2.302781783363158e-03,   5.151429708386948e-05,   1.206576930309333e-07,  -3.250712309916463e-08,   9.639503267452902e-10,
   1.122657044253743e-11,  -5.109942394502559e-13,  -8.711023924352234e-15,  -6.035545831227028e-16,   1.941353056249506e-18,   1.043800410996569e-18,   1.523931080475606e-20,
  -2.097915800418419e-22,  -1.334422399141588e-23,  -8.569269901184166e-04,   1.916963788226174e-05,   4.491321268002933e-08,  -1.209652172255343e-08,   3.586943104284797e-10,
   4.177291058328788e-12,  -1.901932815135779e-13,  -3.241443275963661e-15,  -2.244913708036300e-16,   7.243458553847895e-19,   3.883941860987838e-19,   5.668557976540010e-21,
  -7.825397961635653e-23,  -4.970994754193694e-24,  -9.679655212114436e-05,   2.165355447738041e-06,   5.073533200858043e-09,  -1.366391456516588e-09,   4.051699140567862e-11,
   4.718499512242717e-13,  -2.148449842407142e-14,  -3.661432456935139e-16,  -2.535611502806000e-17,   8.185482694749057e-20,   4.387156267639794e-20,   6.402645840081971e-22,
  -8.842707743413691e-24,  -5.616064759429250e-25,  -2.126310672844985e-02,   2.142774029960375e-06,   1.927273710746574e-05,  -1.944860614323499e-07,  -1.309877264701536e-08,
   5.833608491180969e-10,   1.154485474770739e-11,  -9.113497576520439e-13,  -1.665964233610989e-14,   7.815878944979179e-16,   1.449648421082055e-17,  -3.409163140655682e-19,
   6.462733238036917e-21,   3.336107754555863e-22,  -2.022829265580393e-02,   2.021532998297339e-06,   1.833298073140762e-05,  -1.848545007819324e-07,  -1.245654826057091e-08,
   5.544209252913987e-10,   1.096955279889253e-11,  -8.661886669296586e-13,  -1.582982277313163e-14,   7.430206902987315e-16,   1.380318226328073e-17,  -3.236021138680208e-19,
   6.070186413299266e-21,   3.142957974348496e-22,  -1.826019090674943e-02,   1.797855718174227e-06,   1.654640374127180e-05,  -1.666041998142657e-07,  -1.123704449441948e-08,
   4.996043044499133e-10,   9.880877296828851e-12,  -7.806264418930299e-13,  -1.425931245690146e-14,   6.698868712150070e-16,   1.247943151815341e-17,  -2.909757947266844e-19,
   5.355606904298666e-21,   2.788356879481213e-22,  -1.555178017787686e-02,   1.503420002160230e-06,   1.408922421308476e-05,  -1.416203448051465e-07,  -9.562565480284084e-09,
   4.246016950745088e-10,   8.393306727389744e-12,  -6.635171756472425e-13,  -1.211302948740512e-14,   5.696621723725094e-16,   1.064793475027157e-17,  -2.466556116297376e-19,
   4.433991328671823e-21,   2.324856141549648e-22,  -1.236842058761734e-02,   1.174259421872232e-06,   1.120295466351980e-05,  -1.124212814127427e-07,  -7.599178532962608e-09,
   3.369943498513814e-10,   6.658279835964748e-12,  -5.266775040358895e-13,  -9.609372270459641e-15,   4.523896814273488e-16,   8.483161346642606e-18,  -1.952813023277282e-19,
   3.428489059078172e-21,   1.810713279667594e-22,  -9.021767889705533e-03,   8.439534730414265e-07,   8.170311137989492e-06,  -8.187890018603002e-08,  -5.539477516368086e-09,
   2.454029772314928e-10,   4.846723676122756e-12,  -3.835690507570366e-13,  -6.995035410505132e-15,   3.295915211628641e-16,   6.196347199449665e-18,  -1.419277992005373e-19,
   2.443474039864894e-21,   1.298437722139784e-22,  -5.839283271683953e-03,   5.408695207995691e-07,   5.287608928985253e-06,  -5.294288332530833e-08,  -3.583891989644284e-09,
   1.586614896922065e-10,   3.132758018597737e-12,  -2.480062919920959e-13,  -4.521403327202572e-15,   2.131594127871942e-16,   4.014168067401465e-18,  -9.164387177193189e-20,
   1.557062575051818e-21,   8.309018314242920e-23,  -3.132288390018579e-03,   2.886515618947546e-07,   2.836202963725498e-06,  -2.838492272349366e-08,  -1.922046022073609e-09,
   8.506072551073455e-11,   1.679292236047038e-12,  -1.329640807855802e-13,  -2.423677362121072e-15,   1.142963845001716e-16,   2.154256867406393e-18,  -4.909954948826233e-20,
   8.285057454736647e-22,   4.430992421074663e-23,  -1.165602627111547e-03,   1.072228133633392e-07,   1.055401372594699e-06,  -1.056085767390942e-08,  -7.151877720449606e-10,
   3.164701076905607e-11,   6.247548773800383e-13,  -4.947010670550568e-14,  -9.016933626305617e-16,   4.252659824100430e-17,   8.017805941017603e-19,  -1.826344745690028e-20,
   3.074367601758146e-22,   1.645506541620605e-23,  -1.316637515136233e-04,   1.210820390684376e-08,   1.192153079336684e-07,  -1.192896131233726e-09,  -8.078498236630697e-11,
   3.574661208055237e-12,   7.056813440817620e-14,  -5.587863865863434e-15,  -1.018492795203209e-16,   4.803598851216606e-18,   9.056955423335844e-20,  -2.062858116961233e-21,
   3.471173128012748e-23,   1.858120835349975e-24,  -1.463689073458124e-02,  -8.977469453985703e-04,  -1.443017841152609e-05,   1.007522262267603e-06,   6.646004333472467e-08,
   9.133108155978269e-10,  -7.491839185444365e-11,  -4.340153816128792e-12,  -4.610091955323964e-14,   4.946843749193149e-15,   2.534889485139140e-16,   2.046656124635240e-18,
  -2.951885273545533e-19,  -1.381780142548335e-20,  -1.392535918229824e-02,  -8.539898700701417e-04,  -1.371651673316385e-05,   9.587793161601135e-07,   6.319385614241600e-08,
   8.662024536359601e-10,  -7.131080192495038e-11,  -4.123732229091829e-12,  -4.352417597226142e-14,   4.709275021793557e-15,   2.405779247686325e-16,   1.915764816400465e-18,
  -2.810207361052228e-19,  -1.309417472238063e-20,  -1.257177795994184e-02,  -7.707956656721662e-04,  -1.236384500667793e-05,   8.659566209530413e-07,   5.699481310329293e-08,
   7.776927982823388e-10,  -6.443355425467095e-11,  -3.714229954449291e-12,  -3.875990748616407e-14,   4.256083577891192e-15,   2.162554766919688e-16,   1.679699424066996e-18,
  -2.539854836978985e-19,  -1.173866466031178e-20,  -1.070840838129064e-02,  -6.563598539329567e-04,  -1.051133811238492e-05,   7.379886167761967e-07,   4.848898074292791e-08,
   6.579898140917936e-10,  -5.493873209325763e-11,  -3.154783110087005e-12,  -3.246700654577687e-14,   3.629850507020134e-15,   1.832361320962646e-16,   1.379641646756764e-18,
  -2.166159712364690e-19,  -9.913542446044448e-21,  -8.517475539151895e-03,  -5.219226529501566e-04,  -8.345328411687602e-06,   5.872908886691438e-07,   3.852325140140186e-08,
   5.199474226488344e-10,  -4.374063583447919e-11,  -2.502417804586140e-12,  -2.540252480813578e-14,   2.890650618802789e-15,   1.449995931102973e-16,   1.058120157565405e-18,
  -1.724984694615438e-19,  -7.819398866841987e-21,  -6.213410286970814e-03,  -3.806511289634538e-04,  -6.078788825505269e-06,   4.285948437590174e-07,   2.807590746518302e-08,
   3.772907027273598e-10,  -3.193297546438511e-11,  -1.821431615202689e-12,  -1.828374045189111e-14,   2.110691858087922e-15,   1.053367659561201e-16,   7.489307699467548e-19,
  -1.259488198570402e-19,  -5.665467652752371e-21,  -4.021846500490468e-03,  -2.463529176988563e-04,  -3.930842793060666e-06,   2.774964007651277e-07,   1.816181321721804e-08,
   2.433577604828692e-10,  -2.068019195427171e-11,  -1.177249572117241e-12,  -1.172930995645663e-14,   1.367057040587755e-15,   6.799509133120870e-17,   4.749866824903797e-19,
  -8.157127983740672e-20,  -3.650614649514009e-21,  -2.157455466605945e-03,  -1.321419594632693e-04,  -2.107573500976199e-06,   1.488787178762165e-07,   9.739502659279364e-09,
   1.303095225987167e-10,  -1.109642831340052e-11,  -6.310385488239451e-13,  -6.262981165410791e-15,   7.335645478542362e-16,   3.642313573291987e-17,   2.521091169733907e-19,
  -4.377012841348523e-20,  -1.953752431267509e-21,  -8.028520894339534e-04,  -4.917256328706028e-05,  -7.841517017650278e-07,   5.540472580184099e-08,   3.623949753497392e-09,
   4.846143238763397e-11,  -4.129675377689421e-12,  -2.347658976216587e-13,  -2.326881349595364e-15,   2.730102287573451e-16,   1.354740779091695e-17,   9.346908288924892e-20,
  -1.628974444129759e-20,  -7.264573892169671e-22,  -9.068846086145675e-05,  -5.554404409241010e-06,  -8.857363402885981e-08,   6.258446577403421e-09,   4.093464130568681e-10,
   5.473552728705400e-12,  -4.664859720321446e-13,  -2.651754499970801e-14,  -2.627722338215567e-16,   3.083918107522385e-17,   1.530166154495041e-18,   1.055183106490652e-20,
  -1.840083457971336e-21,  -8.204848711684049e-23,  -3.074256468046141e-04,   1.135837769104725e-05,  -2.810201002228474e-07,   6.426803034164083e-09,  -7.237059702457282e-11,
   1.819692805924046e-12,  -1.004822992490862e-13,  -1.934396677280760e-15,   3.575111847971091e-17,   4.621359302083330e-18,   7.868548398469111e-20,  -2.970249660360900e-21,
  -1.996468713184017e-22,  -3.496230095090872e-24,  -2.924807358482013e-04,   1.080647669331563e-05,  -2.673642086469380e-07,   6.114738566699911e-09,  -6.889516086670757e-11,
   1.729997775639470e-12,  -9.556446452992228e-14,  -1.835394848557755e-15,   3.411428591750283e-17,   4.391645233320446e-18,   7.447086660400956e-20,  -2.833458580424346e-21,
  -1.895422533983605e-22,  -3.294809348765290e-24,  -2.640504229700819e-04,   9.756465281698738e-06,  -2.413838789186413e-07,   5.520937792713820e-09,  -6.226630386677023e-11,
   1.559873389352212e-12,  -8.622240411771957e-14,  -1.649086091295493e-15,   3.095862726236305e-17,   3.956689822619822e-18,   6.661270052349079e-20,  -2.570044005024626e-21,
  -1.704802581729235e-22,  -2.924585957665747e-24,  -2.249128556271099e-04,   8.310796079270397e-06,  -2.056147736113969e-07,   4.703217213334367e-09,  -5.310722483344041e-11,
   1.326654839641654e-12,  -7.338796324124302e-14,  -1.396532307014506e-15,   2.653408020519691e-17,   3.361893943557681e-18,   5.610314862942022e-20,  -2.201335108222700e-21,
  -1.445521715648105e-22,  -2.439881594166965e-24,  -1.788955315395993e-04,   6.610737101575537e-06,  -1.635526770641225e-07,   3.741393080818843e-09,  -4.229549923601602e-11,
   1.053670492346278e-12,  -5.833047947083451e-14,  -1.104535879492687e-15,   2.123105666970250e-17,   2.667592734077653e-18,   4.413452463773640e-20,  -1.760257497713067e-21,
  -1.144652843764824e-22,  -1.901320596367863e-24,  -1.305022630000602e-04,   4.822655021271144e-06,  -1.193138426058244e-07,   2.729572272834714e-09,  -3.088583450780005e-11,
   7.677326489216176e-13,  -4.252652162347673e-14,  -8.020697935669682e-16,   1.556132601307563e-17,   1.942175007823266e-18,   3.190847049038655e-20,  -1.289500097693727e-21,
  -8.319946396412563e-23,  -1.363962102995467e-24,  -8.447206761642637e-05,   3.121713296697254e-06,  -7.723169916983459e-08,   1.766924012222711e-09,  -2.000548988242573e-11,
   4.965537965681182e-13,  -2.751607738019057e-14,  -5.175962732039999e-16,   1.010389909160651e-17,   1.255509379560193e-18,   2.053125712495303e-20,  -8.369681079825932e-22,
  -5.372433032366442e-23,  -8.730530546163261e-25,  -4.531367473905961e-05,   1.674615858223921e-06,  -4.143017047838081e-08,   9.478693950372192e-10,  -1.073536007841504e-11,
   2.662616487972344e-13,  -1.475761090871523e-14,  -2.772236551029895e-16,   5.428671109422518e-18,   6.730481344558897e-19,   1.097992588698679e-20,  -4.496069199225779e-22,
  -2.878384890510324e-23,  -4.656357273534096e-25,  -1.686253714240644e-05,   6.231763075065138e-07,  -1.541743363858661e-08,   3.527338772296834e-10,  -3.995424094153153e-12,
   9.906990925701389e-14,  -5.491355000319264e-15,  -1.031069879167250e-16,   2.021278707206063e-18,   2.504025382326332e-19,   4.081582774681432e-21,  -1.673930829839068e-22,
  -1.070668058040536e-23,  -1.729272769555915e-25,  -1.904756209961435e-06,   7.039271975531634e-08,  -1.741521503761909e-09,   3.984413931198193e-11,  -4.513232577273220e-13,
   1.119047822390674e-14,  -6.202849022589342e-16,  -1.164574157195872e-17,   2.283392575788854e-19,   2.828389187016782e-20,   4.609686105903515e-22,  -1.890982100867143e-23,
  -1.209320827744263e-24,  -1.952723618618252e-26,  -2.753268919452892e-03,   9.759646137068483e-05,  -2.219569806378548e-06,   4.532735748366117e-08,  -2.325703519554696e-10,
   5.903914037226903e-12,  -6.990948750185375e-13,  -2.366282311010792e-14,   4.301524738696947e-16,   4.259791731467990e-17,   7.812834498820017e-19,  -2.825741865149011e-20,
  -1.905445135440754e-21,  -3.456601896216212e-23,  -2.619415061062857e-03,   9.285338333492318e-05,  -2.111651444089882e-06,   4.312433032215841e-08,  -2.215684181996190e-10,
   5.602185455905846e-12,  -6.647268081016823e-13,  -2.246658769151466e-14,   4.102448265805306e-16,   4.047901437191767e-17,   7.395838033336868e-19,  -2.695901955116132e-20,
  -1.809102153252802e-21,  -3.258158352629885e-23,  -2.364783048742302e-03,   8.382986849897750e-05,  -1.906361426826316e-06,   3.893322251931031e-08,  -2.005151218216061e-10,
   5.034220567278053e-12,  -5.995016009371086e-13,  -2.020968207327521e-14,   3.719588217535900e-16,   3.646752688022469e-17,   6.617793950232899e-19,  -2.445744194214615e-20,
  -1.627315596626495e-21,  -2.893161746743848e-23,  -2.014260100301605e-03,   7.140687744540176e-05,  -1.623770739550030e-06,   3.316330389256087e-08,  -1.712929360238646e-10,
   4.263995825574936e-12,  -5.100124601753138e-13,  -1.713906000121260e-14,   3.184561578210709e-16,   3.098301053113850e-17,   5.576146242802514e-19,  -2.095346143459911e-20,
  -1.379975010892008e-21,  -2.414815111246548e-23,  -1.602129766369033e-03,   5.679873903756135e-05,  -1.291523294333722e-06,   2.637865311247813e-08,  -1.366306315679050e-10,
   3.373056477281046e-12,  -4.051750209784870e-13,  -1.357446746652756e-14,   2.545493521382220e-16,   2.458244266046605e-17,   4.388476514044602e-19,  -1.675870756129092e-20,
  -1.092867801379917e-21,  -1.882683794135180e-23,  -1.168728843847117e-03,   4.143506924174970e-05,  -9.421382316364147e-07,   1.924326783289129e-08,  -9.989619592049205e-11,
   2.449746956118315e-12,  -2.952827995420849e-13,  -9.868425588933586e-15,   1.864208116089159e-16,   1.789641765473126e-17,   3.173916418439210e-19,  -1.227894098917867e-20,
  -7.944238047461931e-22,  -1.351125300772370e-23,  -7.564969952436612e-04,   2.682071201364674e-05,  -6.098255916291955e-07,   1.245600931589810e-08,  -6.475772109194053e-11,
   1.581046163339408e-12,  -1.910086164889028e-13,  -6.373152477797751e-15,   1.209780911857957e-16,   1.156855765920149e-17,   2.042716586171234e-19,  -7.970721329971277e-21,
  -5.130121842291987e-22,  -8.650665163329568e-24,  -4.058097948266157e-04,   1.438765893777363e-05,  -3.271295081271645e-07,   6.681864229094571e-09,  -3.476480229078595e-11,
   8.468506864061754e-13,  -1.024294784576407e-13,  -3.414775842783599e-15,   6.498213885515448e-17,   6.201486997933586e-18,   1.092559989409206e-19,  -4.282001383111080e-21,
  -2.748642908704969e-22,  -4.614400112985724e-24,  -1.510135332618656e-04,   5.354082376829403e-06,  -1.217342073465682e-07,   2.486521240754015e-09,  -1.294043558825008e-11,
   3.149726001909028e-13,  -3.811258337940052e-14,  -1.270219693537986e-15,   2.419279249769987e-17,   2.307199300569925e-18,   4.061562190229311e-20,  -1.594263253676729e-21,
  -1.022418615703686e-22,  -1.713773772565380e-24,  -1.705816462166396e-05,   6.047860018449292e-07,  -1.375083263351661e-08,   2.808722242837273e-10,  -1.461785663013756e-12,
   3.557567223658740e-14,  -4.305037085374706e-15,  -1.434720255659957e-16,   2.732964162800246e-18,   2.606063684246056e-19,   4.587106351563466e-21,  -1.800990107324151e-22,
  -1.154824901695288e-23,  -1.935236793345196e-25,  -7.540255217061148e-03,   2.403458075117298e-04,  -4.205502113428501e-06,   5.260349220055023e-08,   1.535392598360745e-09,
  -2.635185022835475e-11,  -1.526048181942640e-12,  -7.991480193817020e-14,   1.232602834586279e-15,   1.400802741076839e-16,   2.406713797149306e-18,  -8.527077392199728e-20,
  -6.064466333424573e-21,  -1.180250898459703e-22,  -7.173619344317648e-03,   2.286599845220476e-04,  -4.000672876082263e-06,   5.003685533116565e-08,   1.460034061117574e-09,
  -2.511927934829247e-11,  -1.450776826004820e-12,  -7.587877403642238e-14,   1.175772479882715e-15,   1.331248233130576e-16,   2.277873786557781e-18,  -8.138348941083969e-20,
  -5.758541822735661e-21,  -1.112967303077662e-22,  -6.476185807177015e-03,   2.064303266119246e-04,  -3.611175326239815e-06,   4.515804761563291e-08,   1.316969235746853e-09,
  -2.275466795459781e-11,  -1.308022941239718e-12,  -6.826254426889852e-14,   1.066383309031839e-15,   1.199518700768794e-16,   2.037622353987440e-18,  -7.388048477761986e-20,
  -5.181016139394811e-21,  -9.890444279762835e-23,  -5.516152669695398e-03,   1.758301410801044e-04,  -3.075292634804064e-06,   3.844921904165647e-08,   1.120591184975710e-09,
  -1.946116999429315e-11,  -1.112358355597021e-12,  -5.789728808317175e-14,   9.133394388684043e-16,   1.019321385336629e-16,   1.716254610547196e-18,  -6.334533649833488e-20,
  -4.394679237883057e-21,  -8.263045297422453e-23,  -4.387441699487691e-03,   1.398528005206545e-04,  -2.445596284129061e-06,   3.057049091975833e-08,   8.904096847664972e-10,
  -1.554039389566516e-11,  -8.833833294230463e-13,  -4.586072963925173e-14,   7.303156681559413e-16,   8.089041784209368e-17,   1.350204148297801e-18,  -5.070178429941862e-20,
  -3.481228648479487e-21,  -6.448317858758507e-23,  -3.200528837542016e-03,   1.020196375931948e-04,  -1.783747317600665e-06,   2.229376773427032e-08,   6.490107768628087e-10,
  -1.137229967964348e-11,  -6.436016518605041e-13,  -3.334294241504006e-14,   5.350033107944265e-16,   5.889879666496060e-17,   9.762205624179621e-19,  -3.717064340375034e-20,
  -2.531072326826780e-21,  -4.631333323424888e-23,  -2.071626373389543e-03,   6.603511385746389e-05,  -1.154468748251916e-06,   1.442738314432294e-08,   4.198666739192990e-10,
  -7.376378690215936e-12,  -4.162433654274540e-13,  -2.153453207731396e-14,   3.472556222768540e-16,   3.807717616850303e-17,   6.281613108193239e-19,  -2.413815766010554e-20,
  -1.634698045247075e-21,  -2.966811616090374e-23,  -1.111283379067082e-03,   3.542330447945023e-05,  -6.192622395100663e-07,   7.738502985244376e-09,   2.251679517051530e-10,
  -3.961140575639773e-12,  -2.231905233742798e-13,  -1.153868246960321e-14,   1.865423989596293e-16,   2.041289477087734e-17,   3.359402319360072e-19,  -1.296995830823682e-20,
  -8.759063727646091e-22,  -1.582979502605287e-23,  -4.135399688535170e-04,   1.318202121273869e-05,  -2.304411175600579e-07,   2.879614193427922e-09,   8.378342363470474e-11,
  -1.474599617398041e-12,  -8.304318388620050e-14,  -4.292174327443940e-15,   6.945184269527571e-17,   7.594548580655605e-18,   1.248802136565165e-19,  -4.829268967249154e-21,
  -3.258204741831149e-22,  -5.879702929379774e-24,  -4.671257590118201e-05,   1.489012602904794e-06,  -2.603005827962106e-08,   3.252731382562392e-10,   9.463851116057384e-12,
  -1.665773743057397e-13,  -9.380156639875439e-15,  -4.848042887137836e-16,   7.845740918137596e-18,   8.578338157371303e-19,   1.410382013771464e-20,  -5.455535356007675e-22,
  -3.680165847362156e-23,  -6.639611313492947e-25,  -1.422987867698611e-02,   3.475253262985007e-04,  -1.180482210749577e-06,  -1.089463945314455e-07,   7.063379577610651e-09,
  -3.831551443772019e-11,  -6.475410720130387e-12,  -1.252391760088876e-13,   2.081153526733159e-15,   3.403036590192563e-16,   7.026569973331363e-18,  -2.245386561302349e-19,
  -1.509512667030574e-20,  -3.254245062648426e-22,  -1.353776593276803e-02,   3.306118405737898e-04,  -1.121810251728593e-06,  -1.036588322674109e-07,   6.716933617377578e-09,
  -3.652832298474496e-11,  -6.158659924876004e-12,  -1.187858628831415e-13,   1.989086745661033e-15,   3.233771993260277e-16,   6.655440708437784e-18,  -2.143359728178855e-19,
  -1.433738635634958e-20,  -3.069625552684179e-22,  -1.222127569793895e-02,   2.984444359294680e-04,  -1.010719506831697e-06,  -9.359659657724725e-08,   6.059126282054269e-09,
  -3.309748291704068e-11,  -5.556879088597220e-12,  -1.066584804503631e-13,   1.810187561147179e-15,   2.913315736009208e-16,   5.961507378725282e-18,  -1.946287019709741e-19,
  -1.290540314045611e-20,  -2.729265762205366e-22,  -1.040925609023843e-02,   2.541774755481333e-04,  -8.588042829958425e-07,  -7.973798437766238e-08,   5.156003565949541e-09,
  -2.831476055826065e-11,  -4.729995377655361e-12,  -9.025210798642738e-14,   1.556682427959654e-15,   2.475177695402942e-16,   5.029586769843525e-18,  -1.669293685547971e-19,
  -1.095275589797948e-20,  -2.281653283997855e-22,  -8.279066131875217e-03,   2.021482593042745e-04,  -6.814669718882016e-07,  -6.343460040255834e-08,   4.097192856126787e-09,
  -2.261611984691819e-11,  -3.759718924708721e-12,  -7.132587904522451e-14,   1.249546051608688e-15,   1.963851430003916e-16,   3.963314669975584e-18,  -1.336521459470477e-19,
  -8.680806888580317e-21,  -1.781692449981375e-22,  -6.039221016612603e-03,   1.474505661302567e-04,  -4.961678097193585e-07,  -4.628134155415895e-08,   2.986571369451121e-09,
  -1.655358132434523e-11,  -2.741187334466137e-12,  -5.176113647485645e-14,   9.181718450433630e-16,   1.429716391757883e-16,   2.869367406204115e-18,  -9.800757201506400e-20,
  -6.314188599653830e-21,  -1.280322645739166e-22,  -3.908980141916873e-03,   9.543632284867733e-05,  -3.207535081412456e-07,  -2.995998066360041e-08,   1.932184036010503e-09,
  -1.073849540333807e-11,  -1.773690392146909e-12,  -3.338869025819539e-14,   5.971481440092351e-16,   9.241934874493096e-17,   1.847975471837789e-18,  -6.365514804166171e-20,
  -4.079177875435396e-21,  -8.204564062154509e-23,  -2.096878089339497e-03,   5.119358744526178e-05,  -1.719506278009216e-07,  -1.607231792481899e-08,   1.036219850622032e-09,
  -5.766989047030521e-12,  -9.512916680905741e-13,  -1.787903006540858e-14,   3.211082340875434e-16,   4.954266930238659e-17,   9.887511103027639e-19,  -3.420610636184383e-20,
  -2.186026187510879e-21,  -4.378442345210466e-23,  -7.803053348131232e-04,   1.905040557542027e-05,  -6.397327560401604e-08,  -5.981077143681820e-09,   3.855727209456791e-10,
  -2.146905321274046e-12,  -3.539805175321459e-13,  -6.649190721112065e-15,   1.195943497348626e-16,   1.843183702160484e-17,   3.676109189341474e-19,  -1.273675596459859e-20,
  -8.132008125529009e-22,  -1.626399621233156e-23,  -8.814155320052758e-05,   2.151889247750631e-06,  -7.226023760965826e-09,  -6.756115009720338e-10,   4.355284718773208e-11,
  -2.425249123738631e-13,  -3.998447509304610e-14,  -7.510046092699207e-16,   1.351092573266439e-17,   2.081941515367483e-18,   4.151859199626820e-20,  -1.438854137111046e-21,
  -9.185235062204414e-23,  -1.836618318141256e-24,  -2.096474672923419e-02,   1.443647781049144e-04,   1.608968712904122e-05,  -3.050668255013218e-07,  -9.161828148900380e-10,
   5.233673347738945e-10,  -1.654940272546944e-11,  -9.059517070060291e-13,   1.911528407973140e-14,   1.137690772910136e-15,   2.884793696583250e-18,  -4.816018649795101e-19,
  -2.893794100260059e-20,  -1.357901510532174e-21,  -1.994453645427085e-02,   1.373159149433964e-04,   1.530689810676128e-05,  -2.900743999045649e-07,  -8.789385408820439e-10,
   4.973506713963963e-10,  -1.572850298458008e-11,  -8.606739231949429e-13,   1.818890999911093e-14,   1.081536900827815e-15,   2.688089820310257e-18,  -4.611984179896356e-19,
  -2.749584849317629e-20,  -1.282479912987220e-21,  -1.800417551777177e-02,   1.239191376929166e-04,   1.381801681473632e-05,  -2.616198821601938e-07,  -8.051110070117853e-10,
   4.480926541430759e-10,  -1.417353055007436e-11,  -7.750443105287898e-13,   1.642535573400837e-14,   9.750509352469767e-16,   2.336954370546866e-18,  -4.211306315206941e-19,
  -2.476597365853404e-20,  -1.142863978547672e-21,  -1.533387457705857e-02,   1.055012827471947e-04,   1.176888871175603e-05,  -2.225770814369371e-07,  -6.977186367246129e-10,
   3.807370561048139e-10,  -1.204584633905111e-11,  -6.581415944704382e-13,   1.399525265639861e-14,   8.291224511450394e-16,   1.898191687723395e-18,  -3.635720779409318e-19,
  -2.103500072123452e-20,  -9.581193058119467e-22,  -1.219522450194956e-02,   8.387663933623859e-05,   9.360175600133008e-06,  -1.768329590323702e-07,  -5.641724018953233e-10,
   3.021140693147053e-10,  -9.560498464409484e-12,  -5.219229812515819e-13,   1.113513499141961e-14,   6.583895951423901e-16,   1.438621158625661e-18,  -2.929023233178052e-19,
  -1.668371794555974e-20,  -7.502794774203195e-22,  -8.895497222783240e-03,   6.116414778964718e-05,   6.827676420027166e-06,  -1.288775014267172e-07,  -4.169614741144341e-10,
   2.199640691581504e-10,  -6.962074814857710e-12,  -3.798196268748714e-13,   8.124840263602258e-15,   4.796408461340969e-16,   1.007686510003820e-18,  -2.158344673354505e-19,
  -1.214211844182432e-20,  -5.404044458544226e-22,  -5.757581845044002e-03,   3.958079884577888e-05,   4.419248343042627e-06,  -8.336904970412806e-08,  -2.722018671206422e-10,
   1.421978557690757e-10,  -4.501223249859054e-12,  -2.454592393510846e-13,   5.259867215951748e-15,   3.101860165218736e-16,   6.344159430609380e-19,  -1.406264836541399e-19,
  -7.847056190486685e-21,  -3.468446718728835e-22,  -3.088469681633991e-03,   2.122978201013458e-05,   2.370579297519749e-06,  -4.470784477940544e-08,  -1.466540925229624e-10,
   7.622979473352352e-11,  -2.413170754092167e-12,  -1.315646842258748e-13,   2.821783666960800e-15,   1.663174807839966e-16,   3.354102567396966e-19,  -7.568931300719671e-20,
  -4.205996750833245e-21,  -1.852475880321566e-22,  -1.149297537223017e-03,   7.899870395769485e-06,   8.821544187757347e-07,  -1.663526001360291e-08,  -5.465658567708434e-11,
   2.836085824072453e-11,  -8.978248546644022e-13,  -4.894506802565711e-14,   1.050095202669132e-15,   6.188161604280229e-17,   1.241799352433289e-19,  -2.819884301815608e-20,
  -1.564727904963673e-21,  -6.883096740479663e-23,  -1.298219835519270e-04,   8.923462394052818e-07,   9.964615276687029e-08,  -1.879050667601868e-09,  -6.175366912751299e-12,
   3.203466116478979e-12,  -1.014130417024302e-13,  -5.528479859379224e-15,   1.186170027646554e-16,   6.989836709389103e-18,   1.401570177562585e-20,  -3.185866003366447e-21,
  -1.767403233676048e-22,  -7.773116549172109e-24,  -1.835589191191651e-02,  -9.462045325458627e-04,   4.212448058630337e-06,   2.077791378721904e-06,   5.699057916307024e-08,
  -2.276928557770475e-09,  -1.770108387619841e-10,  -1.181590537129762e-12,   2.808867840806306e-13,   1.047293613888278e-14,  -1.693849181576427e-16,  -2.271830512597075e-17,
  -3.933886780516076e-19,   2.565155939653119e-20,  -1.746291530978278e-02,  -8.999968199586963e-04,   4.017528212856143e-06,   1.976047887542236e-06,   5.414049079377056e-08,
  -2.166864217607418e-09,  -1.681684894663791e-10,  -1.113159501962625e-12,   2.669918438208060e-13,   9.926951156333780e-15,  -1.618772253506608e-16,  -2.155385480783080e-17,
  -3.705829235129172e-19,   2.440044324007407e-20,  -1.576442938044521e-02,  -8.121794030661279e-04,   3.642695284588708e-06,   1.782795995248078e-06,   4.875116597834563e-08,
  -1.957221158471691e-09,  -1.514441070419096e-10,  -9.875036115350002e-13,   2.406552888452258e-13,   8.903427758352297e-15,  -1.472897061692403e-16,  -1.936311047559934e-17,
  -3.287249710408204e-19,   2.202100788582879e-20,  -1.342677399024160e-02,  -6.914541940162480e-04,   3.118902768074279e-06,   1.517342464418533e-06,   4.139504110160997e-08,
  -1.668122552137373e-09,  -1.286084464720589e-10,  -8.232402516739745e-13,   2.045881261126635e-13,   7.523623768576360e-15,  -1.266260842498203e-16,  -1.639466111386739e-17,
  -2.740333027750489e-19,   1.874768682359034e-20,  -1.067883501553107e-02,  -5.497167516821748e-04,   2.493201998814669e-06,   1.205960636458739e-06,   3.282521820846603e-08,
  -1.327585003692433e-09,  -1.019953720428958e-10,  -6.410529915030808e-13,   1.624210099206617e-13,   5.938018024233682e-15,  -1.016080411972046e-16,  -1.296432130806819e-17,
  -2.133930917993683e-19,   1.490340885305757e-20,  -7.789611830711566e-03,  -4.008562190238534e-04,   1.826053847895312e-06,   8.791865013736006e-07,   2.388673770120558e-08,
  -9.688998058074607e-10,  -7.422853858892642e-11,  -4.595941067284424e-13,   1.183023503468316e-13,   4.304615250326014e-15,  -7.463860603655083e-17,  -9.412694553795848e-18,
  -1.529990341773239e-19,   1.086622980909920e-20,  -5.041889325319432e-03,  -2.594012741684811e-04,   1.185090527316478e-06,   5.688491602324071e-07,   1.543635439809915e-08,
  -6.273406547267743e-10,  -4.797178245774587e-11,  -2.940572928727267e-13,   7.649719053310438e-14,   2.774746087608176e-15,  -4.853144499977323e-17,  -6.073607099685082e-18,
  -9.789822943392217e-20,   7.030924508738009e-21,  -2.704583730795856e-03,  -1.391332565641775e-04,   6.365799800300492e-07,   3.050853353178025e-07,   8.273657639045427e-09,
  -3.365779595616111e-10,  -2.571298457325432e-11,  -1.567989737212142e-13,   4.101413417730368e-14,   1.485286640611165e-15,  -2.609393019724997e-17,  -3.252832579707658e-18,
  -5.220403681175338e-20,   3.770871552198875e-21,  -1.006447029401904e-03,  -5.177315585313145e-05,   2.370009412061228e-07,   1.135227649496466e-07,   3.077972142473187e-09,
  -1.252570687876340e-10,  -9.565869056811085e-12,  -5.822738917438329e-14,   1.525975975380005e-14,   5.523066432878040e-16,  -9.718065901588162e-18,  -1.209793002960382e-18,
  -1.938630234095637e-20,   1.403151374481334e-21,  -1.136859779696912e-04,  -5.848142571645467e-06,   2.677311006492413e-08,   1.282313928053887e-08,   3.476650938425151e-10,
  -1.414888965117646e-11,  -1.080492104233751e-12,  -6.575054068111601e-15,   1.723659815605046e-15,   6.238000081950038e-17,  -1.097870891426762e-18,  -1.366434353558351e-19,
  -2.189112575859286e-21,   1.584951875633999e-22,  -2.660253283234471e-04,   9.400858600059805e-06,  -2.101096075341534e-07,   5.415015434515241e-09,  -6.311026390733722e-11,
  -9.467895375664695e-13,  -1.116574664179565e-13,   2.042570870838689e-15,   1.999588931080151e-16,   2.219540108612039e-18,  -2.567335525557058e-19,  -9.965171958634996e-21,
   1.066811700976419e-22,   1.801202694184454e-23,  -2.530920319265817e-04,   8.944080167437675e-06,  -1.999011847921170e-07,   5.151349776673823e-09,  -6.008972401296463e-11,
  -8.994515322269841e-13,  -1.060619122823253e-13,   1.945486189626032e-15,   1.898911617213947e-16,   2.095678333155685e-18,  -2.440268642746293e-19,  -9.439446464126488e-21,
   1.023788139462438e-22,   1.708059016584717e-23,  -2.284888950900097e-04,   8.075039842775732e-06,  -1.804789983502110e-07,   4.649941225149136e-09,  -5.432423234924924e-11,
  -8.099300300435512e-13,  -9.548578882302298e-14,   1.759875629459209e-15,   1.708804847363939e-16,   1.866634961653916e-18,  -2.199440143204712e-19,  -8.456306083031269e-21,
   9.382199946308060e-23,   1.533138970274553e-23,  -1.946206468877083e-04,   6.878528229862591e-06,  -1.537376969451492e-07,   3.960030780067361e-09,  -4.634987258595031e-11,
  -6.877257986003903e-13,  -8.105901656370849e-14,   1.502596168290682e-15,   1.449841928347070e-16,   1.564004175445829e-18,  -1.869672566146351e-19,  -7.135623676716017e-21,
   8.133357695440231e-23,   1.296743621028866e-23,  -1.547998845861591e-04,   5.471463187691188e-06,  -1.222900571288037e-07,   3.149269116733378e-09,  -3.692643276077840e-11,
  -5.453495112564915e-13,  -6.426332018909164e-14,   1.197891833809785e-15,   1.148820133277717e-16,   1.224077414678642e-18,  -1.484200535667564e-19,  -5.623934408076704e-21,
   6.577197072753830e-23,   1.024363856478920e-23,  -1.129240301338540e-04,   3.991538731450465e-06,  -8.921344782502379e-08,   2.297041124124238e-09,  -2.697247520009056e-11,
  -3.968455081983721e-13,  -4.675564740068070e-14,   8.754368738968259e-16,   8.354784045538382e-17,   8.812972151554359e-19,  -1.080968026863105e-19,  -4.072308767716865e-21,
   4.860610758954923e-23,   7.431115037706983e-24,  -7.309364040417516e-05,   2.583732389734658e-06,  -5.774827963351081e-08,   1.486704068021805e-09,  -1.747383483400560e-11,
  -2.564520414805970e-13,  -3.021136460169373e-14,   5.673312661918150e-16,   5.396925585062347e-17,   5.654842200489414e-19,  -6.989451957673357e-20,  -2.623023798704235e-21,
   3.172726149049661e-23,   4.792298280696933e-24,  -3.920981527691771e-05,   1.386021289078132e-06,  -3.097863099626243e-08,   7.974812912480738e-10,  -9.377677924298269e-12,
  -1.374538382863327e-13,  -1.619185720725588e-14,   3.045207863334295e-16,   2.892066061503791e-17,   3.019800015294284e-19,  -3.747309249549247e-20,  -1.403526135143529e-21,
   1.709223922461126e-23,   2.565863177961744e-24,  -1.459110223331141e-05,   5.157814273416919e-07,  -1.152811497779490e-08,   2.967611980025877e-10,  -3.490240532407998e-12,
  -5.113558285866616e-14,  -6.023578745733933e-15,   1.133449765788530e-16,   1.075829925346311e-17,   1.121989489685864e-19,  -1.394214382270298e-20,  -5.218331433009445e-22,
   6.369906290101485e-24,   9.541993483124225e-25,  -1.648179569938404e-06,   5.826161535574561e-08,  -1.302192427995275e-09,   3.352142559252572e-11,  -3.942596867592618e-13,
  -5.775897589378695e-15,  -6.803768602632092e-16,   1.280363535753187e-17,   1.215164260002734e-18,   1.267058932040440e-20,  -1.574826670618972e-21,  -5.893691870933470e-23,
   7.196991416478474e-25,   1.077729756887661e-25,  -2.395037397446018e-03,   8.195447112456922e-05,  -1.697530223151036e-06,   4.146152709509372e-08,  -3.213922250517711e-10,
  -1.572925734880765e-11,  -9.180246667154956e-13,   1.650209876456489e-14,   1.963956357062875e-15,   2.071397668596910e-17,  -2.440215357112370e-18,  -9.648801390317893e-20,
   9.827114530598462e-22,   1.737631283103310e-22,  -2.278592541894567e-03,   7.797186763132221e-05,  -1.615020109509902e-06,   3.944018047012970e-08,  -3.061628091876601e-10,
  -1.495377949415045e-11,  -8.717553595020783e-13,   1.572054656245130e-14,   1.865180942363111e-15,   1.955245172815799e-17,  -2.319496737716991e-18,  -9.139903039283945e-20,
   9.437698406864259e-22,   1.647841529314376e-22,  -2.057080719947476e-03,   7.039500567379185e-05,  -1.458052942568311e-06,   3.559724269030922e-08,  -2.770298658319451e-10,
  -1.348294302940526e-11,  -7.844065794919401e-13,   1.422513848398026e-14,   1.678622917855811e-15,   1.740657821213284e-17,  -2.090676262205756e-18,  -8.188176697808568e-20,
   8.659714839008051e-22,   1.479192979727321e-22,  -1.752156015798328e-03,   5.996344211021952e-05,  -1.241960308011845e-06,   3.031155678972146e-08,  -2.366131050891207e-10,
  -1.146669080531034e-11,  -6.654586259166574e-13,   1.215003078291693e-14,   1.424411171183805e-15,   1.457524108422836e-17,  -1.777306212027310e-18,  -6.909590235822081e-20,
   7.517901357537509e-22,   1.251221731938633e-22,  -1.393645092678466e-03,   4.769672353290468e-05,  -9.878699723317663e-07,   2.410249237080039e-08,  -1.886983959822493e-10,
  -9.106826672116406e-12,  -5.272382652239538e-13,   9.689598653039876e-15,   1.128806485234690e-15,   1.140016121787017e-17,  -1.410945915042463e-18,  -5.445954877974116e-20,
   6.087641512740876e-22,   9.884844237538167e-23,  -1.016637369366681e-03,   3.479530163377389e-05,  -7.206491722487183e-07,   1.757820873604889e-08,  -1.379444590689665e-10,
  -6.635223829388835e-12,  -3.834020798905183e-13,   7.083279231960832e-15,   8.210042041928509e-16,   8.203453211352807e-18,  -1.027655075064790e-18,  -3.943531511045115e-20,
   4.503484381566146e-22,   7.171299525345966e-23,  -6.580487448183150e-04,   2.252291564775393e-05,  -4.664688671604996e-07,   1.137626644540226e-08,  -8.941359197173040e-11,
  -4.291407348382793e-12,  -2.476524394042077e-13,   4.591192144932607e-15,   5.303772605087578e-16,   5.261885628438507e-18,  -6.644902168978277e-19,  -2.540118630530629e-20,
   2.941567064028356e-22,   4.624942059720621e-23,  -3.529983201568440e-04,   1.208218134699766e-05,  -2.502307756913826e-07,   6.102109569588203e-09,  -4.799868599606491e-11,
  -2.301099914301894e-12,  -1.327066554855425e-13,   2.464597952401704e-15,   2.842243270786128e-16,   2.809437760498564e-18,  -3.562628900214269e-19,  -1.359176779844840e-20,
   1.585223866695671e-22,   2.476312517213471e-23,  -1.313607814533413e-04,   4.496147814879469e-06,  -9.311829613219081e-08,   2.270707213167105e-09,  -1.786613697205153e-11,
  -8.561823712414823e-13,  -4.936556057309143e-14,   9.173718924898852e-16,   1.057308528519897e-16,   1.043763585039852e-18,  -1.325508594257473e-19,  -5.053454736329270e-21,
   5.908468295267730e-23,   9.209040357239371e-24,  -1.483823055057606e-05,   5.078755579793603e-07,  -1.051844655723967e-08,   2.564930696676871e-10,  -2.018200083229999e-12,
  -9.671031288310861e-14,  -5.575897734925241e-15,   1.036283709116213e-16,   1.194246311144682e-17,   1.178706656303499e-19,  -1.497221510347383e-20,  -5.707479372848977e-22,
   6.675761336590246e-24,   1.040125295740504e-24,  -6.641645618960928e-03,   2.095881718138977e-04,  -3.452447025117367e-06,   7.034698604253837e-08,   5.052001162451405e-10,
  -8.033202741950428e-11,  -2.390852638334122e-12,   4.585935410568928e-14,   6.255406111066569e-15,   6.958892920333853e-17,  -7.810404530490612e-18,  -3.128931243751147e-19,
   2.854733294794244e-21,   5.644734149673790e-22,  -6.318696297315300e-03,   1.993999624813626e-04,  -3.284431306066641e-06,   6.690149196683657e-08,   4.795805136870761e-10,
  -7.639568703580519e-11,  -2.269413061072661e-12,   4.369980053679561e-14,   5.940741052735258e-15,   6.570476635050520e-17,  -7.424562564747616e-18,  -2.963876399026464e-19,
   2.746744563668294e-21,   5.353484494429921e-22,  -5.704368515104512e-03,   1.800183022733640e-04,  -2.964882257354636e-06,   6.035745562703558e-08,   4.312776356751773e-10,
  -6.892003565975194e-11,  -2.040525505833433e-12,   3.956247303377032e-14,   5.346451013443300e-15,   5.852249360685614e-17,  -6.692980853963772e-18,  -2.655205205279094e-19,
   2.528361387210258e-21,   4.806264353688788e-22,  -4.858738072713444e-03,   1.533368242906436e-04,  -2.525129967038059e-06,   5.136912490811979e-08,   3.656221635854439e-10,
  -5.865345370869427e-11,  -1.729557049509594e-12,   3.381123340225503e-14,   4.536687984010354e-15,   4.903321464108991e-17,  -5.690650052689218e-18,  -2.240543988099597e-19,
   2.203048168868401e-21,   4.066220486165576e-22,  -3.864537598104209e-03,   1.219646528653928e-04,  -2.008257419215695e-06,   4.082644216075478e-08,   2.894826069606767e-10,
  -4.661327691154867e-11,  -1.369123669509953e-12,   2.697957588488452e-14,   3.595126670690004e-15,   3.837517561823687e-17,  -4.518292360432647e-18,  -1.765896628086490e-19,
   1.789958864918280e-21,   3.212900818675789e-22,  -2.819078001321544e-03,   8.897221065476277e-05,  -1.464866488579771e-06,   2.976332289202795e-08,   2.103929846591958e-10,
  -3.398052773970468e-11,  -9.949102427138771e-13,   1.973145652271650e-14,   2.614765949765704e-15,   2.762834170835258e-17,  -3.291264533536884e-18,  -1.278698524918858e-19,
   1.327613502412202e-21,   2.331212336570537e-22,  -1.824719994235816e-03,   5.759047744287924e-05,  -9.481276068850956e-07,   1.925716400577377e-08,   1.358505621311294e-10,
  -2.198507333566685e-11,  -6.423456352612392e-13,   1.279317106711194e-14,   1.689147086101863e-15,   1.772747168661973e-17,  -2.128324421372636e-18,  -8.236280277266582e-20,
   8.686074604549225e-22,   1.503582636015859e-22,  -9.788346550603678e-04,   3.089352467314998e-05,  -5.085918941566479e-07,   1.032794458913808e-08,   7.278306734102798e-11,
  -1.179078342492333e-11,  -3.441234078493647e-13,   6.868535815730854e-15,   9.051932328613952e-16,   9.466758927945053e-18,  -1.141135286287838e-18,  -4.407071147820019e-20,
   4.684884390007582e-22,   8.050917731435456e-23,  -3.642519712611391e-04,   1.149638536202442e-05,  -1.892597957509354e-07,   3.843037406580289e-09,   2.707281768849896e-11,
  -4.387336893465340e-12,  -1.279997480411616e-13,   2.556737842386186e-15,   3.367292989104261e-16,   3.517311342274344e-18,  -4.245756788139603e-19,  -1.638556576139446e-20,
   1.746660801085808e-22,   2.994062673325879e-23,  -4.114510936588511e-05,   1.298607259230833e-06,  -2.137834589863971e-08,   4.340960819146723e-10,   3.057874800284737e-12,
  -4.955778170644958e-13,  -1.445752834713127e-14,   2.888171898342572e-16,   3.803408207269125e-17,   3.972086175324984e-19,  -4.795783585809226e-20,  -1.850619969066195e-21,
   1.973578071117239e-23,   3.381685473730086e-24,  -1.286438448980475e-02,   3.346553596692968e-04,  -1.864982121827364e-06,  -1.140512290050949e-08,   4.550622980955586e-09,
  -2.157598880325951e-10,  -7.002827820900554e-12,   1.580738904742009e-13,   1.484578949345500e-14,   1.885189406944857e-16,  -1.960015124020608e-17,  -8.286907466445483e-19,
   6.508313881450448e-21,   1.484696703730627e-21,  -1.223871084482306e-02,   3.183764725832283e-04,  -1.773464563881012e-06,  -1.091421261223391e-08,   4.326202984222566e-09,
  -2.051656632916357e-10,  -6.649999195619036e-12,   1.505778353009885e-13,   1.409757741435501e-14,   1.780266388984234e-16,  -1.863303282580161e-17,  -7.849978487787649e-19,
   6.281656567842494e-21,   1.408238588573870e-21,  -1.104858676501288e-02,   2.874126448225982e-04,  -1.599715439880312e-06,  -9.954457335012624e-09,   3.900588568948318e-09,
  -1.850545682228753e-10,  -5.983871553312364e-12,   1.362392299322976e-13,   1.268503161446508e-14,   1.586143044810067e-16,  -1.679881966189947e-17,  -7.032786007791072e-19,
   5.812757016355301e-21,   1.264522481150145e-21,  -9.410478707523475e-03,   2.447954830277431e-04,  -1.361204778797810e-06,  -8.583118252747615e-09,   3.317211995313037e-09,
  -1.574523538148767e-10,  -5.076675690165483e-12,   1.163501186447865e-13,   1.076142997377466e-14,   1.329451505812410e-16,  -1.428486124496584e-17,  -5.934825719091341e-19,
   5.095349234776662e-21,   1.070049718071738e-21,  -7.484713070354510e-03,   1.946971443232676e-04,  -1.081620769838855e-06,  -6.907336828147392e-09,   2.634478377789008e-09,
  -1.251034122200080e-10,  -4.022373904762493e-12,   9.277740053776272e-14,   8.526139413748560e-15,   1.040864953672048e-16,  -1.134332837702400e-17,  -4.677826262082128e-19,
   4.162667539562626e-21,   8.456682308827894e-22,  -5.459792829884840e-03,   1.420217072040093e-04,  -7.883956098029917e-07,  -5.086000089853168e-09,   1.919458914542697e-09,
  -9.118263406630278e-11,  -2.925122387898651e-12,   6.781552604076997e-14,   6.200057853018480e-15,   7.496045668287823e-17,  -8.263612328017607e-18,  -3.387399905985171e-19,
   3.100391309687786e-21,   6.136991694060743e-22,  -3.533943918979475e-03,   9.192514830780821e-05,  -5.100449021633418e-07,  -3.312256022685623e-09,   1.241426435838428e-09,
  -5.898731844717169e-11,  -1.889476949641442e-12,   4.395347885874146e-14,   4.004795726146773e-15,   4.810761865052761e-17,  -5.344063195546142e-18,  -2.181937284595100e-19,
   2.033867858970217e-21,   3.958652008283864e-22,  -1.895701083403094e-03,   4.931085695529321e-05,  -2.735306546799076e-07,  -1.782360489087069e-09,   6.656653760695518e-10,
  -3.163348520750000e-11,  -1.012503567414256e-12,   2.359392380005482e-14,   2.145993645174609e-15,   2.569300465656977e-17,  -2.865394457007716e-18,  -1.167529301362356e-19,
   1.098442540515849e-21,   2.119771344855492e-22,  -7.054421780883564e-04,   1.834988807991168e-05,  -1.017790453933033e-07,  -6.639875225505457e-10,   2.476774983503239e-10,
  -1.177053460740093e-11,  -3.766427672343815e-13,   8.782027184773570e-15,   7.982870018207967e-16,   9.546422653711832e-18,  -1.066122426483711e-18,  -4.340916746328853e-20,
   4.097194381988791e-22,   7.883384359988863e-23,  -7.968518264701036e-05,   2.072762102350744e-06,  -1.149657040801340e-08,  -7.501550660323658e-11,   2.797647714089550e-11,
  -1.329552853620293e-12,  -4.254226701653542e-14,   9.920356223607779e-16,   9.016742458535011e-17,   1.078080257167452e-18,  -1.204237884604754e-19,  -4.902726001049348e-21,
   4.629817473437992e-23,   8.904024043103067e-24,  -2.015256154403286e-02,   2.588090859261196e-04,   1.259692886117591e-05,  -2.644678870561511e-07,   4.040366805989613e-09,
  -7.205831631491820e-11,  -2.743214712528281e-11,   3.095735636471174e-13,   5.202228905032689e-14,   2.679783210020730e-16,  -5.989611063949104e-17,  -2.085112606314699e-18,
   1.454078184165499e-20,   4.354049755624677e-21,  -1.917195877593687e-02,   2.461968986902040e-04,   1.198490127887965e-05,  -2.516249059604957e-07,   3.831772651826511e-09,
  -6.835886959711416e-11,  -2.605499028961470e-11,   2.947799355536166e-13,   4.941204317886607e-14,   2.516290367015734e-16,  -5.695072744099554e-17,  -1.973777051895115e-18,
   1.414996859324124e-20,   4.128938160407514e-21,  -1.730689407838186e-02,   2.222166940080282e-04,   1.082047176901377e-05,  -2.271875595637311e-07,   3.439934825974865e-09,
  -6.140094599951592e-11,  -2.345298985618781e-11,   2.665285922638922e-13,   4.447958447588080e-14,   2.219003893655497e-16,  -5.136045253434958e-17,  -1.766077333825141e-18,
   1.327365530404059e-20,   3.706132243414037e-21,  -1.474014866858731e-02,   1.892293920399409e-04,   9.217224526779952e-06,  -1.935359494298787e-07,   2.910153003345427e-09,
  -5.197726917065625e-11,  -1.990549908287874e-11,   2.274311942150465e-13,   3.775363844496278e-14,   1.836159252180933e-16,  -4.369053893194048e-17,  -1.488058363080113e-18,
   1.181401730020006e-20,   3.134661526333742e-21,  -1.172313312192782e-02,   1.504740657578123e-04,   7.331805683136740e-06,  -1.539553582594791e-07,   2.299390085355024e-09,
  -4.109318826365147e-11,  -1.577789293077723e-11,   1.812074184224382e-13,   2.992647324399464e-14,   1.419099724786473e-16,  -3.470621756436504e-17,  -1.171106203669012e-18,
   9.783734671860965e-21,   2.476167872242776e-21,  -8.551204614790855e-03,   1.097462877712386e-04,   5.348720906105403e-06,  -1.123186249226846e-07,   1.668379590458766e-09,
  -2.983027963757155e-11,  -1.147757663886919e-11,   1.323671919163006e-13,   2.177069152578366e-14,   1.011041809372448e-16,  -2.529071304077019e-17,  -8.469943644736444e-19,
   7.361765670064615e-21,   1.796244771076338e-21,  -5.534766281946196e-03,   7.102728251463369e-05,   3.462250211885856e-06,  -7.270631692375629e-08,   1.076072303380371e-09,
  -1.924587520233720e-11,  -7.415494948048611e-12,   8.575456580041921e-14,   1.406603787504425e-14,   6.441363654859093e-17,  -1.635853834675742e-17,  -5.451266664944743e-19,
   4.860383218829309e-21,   1.158358873091024e-21,  -2.968954794669882e-03,   3.809874629376848e-05,   1.857297539335878e-06,  -3.900329139203036e-08,   5.761836446562028e-10,
  -1.030683306017300e-11,  -3.974134823186667e-12,   4.602225158086318e-14,   7.538396613297251e-15,   3.427078402389632e-17,  -8.772011624636096e-18,  -2.915664972754012e-19,
   2.633366438850817e-21,   6.201912435811270e-22,  -1.104823983670149e-03,   1.417730376143805e-05,   6.911582695670628e-07,  -1.451441036441121e-08,   2.142777295926485e-10,
  -3.833230736940470e-12,  -1.478400846972245e-12,   1.712887817101044e-14,   2.804337058458632e-15,   1.271656211793523e-17,  -3.263896775717866e-18,  -1.083893509720544e-19,
   9.833235065814114e-22,   2.306368108750040e-22,  -1.247983711996898e-04,   1.601431730368618e-06,   7.807183127526520e-08,  -1.639519517288796e-09,   2.420190011731076e-11,
  -4.329533777751030e-13,  -1.669882157024741e-13,   1.934889135371595e-15,   3.167554446081753e-16,   1.435780013056016e-18,  -3.686752051048450e-19,  -1.224144008438157e-20,
   1.111345086154846e-22,   2.604947406409002e-23,  -2.189993094949659e-02,  -8.021987415628283e-04,   3.238787389865695e-05,   2.405133717534000e-06,  -2.731705198927915e-08,
  -5.655662327634028e-09,  -4.871536018999463e-11,   1.051711077468745e-11,   2.952318534373219e-13,  -1.467512636347023e-14,  -8.405225887681744e-16,   1.116831351502418e-17,
   1.760467409709151e-18,   1.399276621277344e-20,  -2.083375544986150e-02,  -7.629682141316977e-04,   3.080759331447236e-05,   2.286485765318508e-06,  -2.600915098497710e-08,
  -5.374076247869443e-09,  -4.610632557996508e-11,   9.989976414668121e-12,   2.797745637217333e-13,  -1.394278770272455e-14,  -7.962696018631679e-16,   1.065430132194899e-17,
   1.667206604768218e-18,   1.307153462456021e-20,  -1.880615776098729e-02,  -6.884334063865313e-04,   2.780371737610439e-05,   2.061481889562706e-06,  -2.351277256335948e-08,
  -4.841120084812550e-09,  -4.124223818381770e-11,   8.993666942418337e-12,   2.508251329820314e-13,  -1.255726817795684e-14,  -7.134855302232732e-16,   9.663967414059868e-18,
   1.492961398381511e-18,   1.142047034500698e-20,  -1.601616227185198e-02,  -5.860117694833251e-04,   2.367311245641957e-05,   1.753102503012249e-06,  -2.006026486219146e-08,
  -4.112698486510375e-09,  -3.473733025967261e-11,   7.634668374099428e-12,   2.118501395153381e-13,  -1.066481318109531e-14,  -6.022181412502134e-16,   8.277154727899377e-18,
   1.259190982305480e-18,   9.340844085927829e-21,  -1.273727918515355e-02,  -4.658186709462448e-04,   1.882220873824009e-05,   1.392237527167261e-06,  -1.598088252039957e-08,
  -3.262860972969181e-09,  -2.732891032717018e-11,   6.052603354093166e-12,   1.671249290349030e-13,  -8.458611118167203e-15,  -4.747709513047232e-16,   6.617944134655343e-18,
   9.919765663430998e-19,   7.135078224174294e-21,  -9.290546097613209e-03,  -3.396364069822707e-04,   1.372625501975627e-05,   1.014342773946319e-06,  -1.167244938661425e-08,
  -2.375306439276425e-09,  -1.975996015518247e-11,   4.403567241062284e-12,   1.211083925713121e-13,  -6.156218679385712e-15,  -3.438655612600714e-16,   4.847409345777031e-18,
   7.180333340253415e-19,   5.033950282905989e-21,  -6.013130925861020e-03,  -2.197673546463945e-04,   8.882935455900359e-06,   6.560218075192604e-07,  -7.561598830448354e-09,
  -1.535399794866208e-09,  -1.271521414118636e-11,   2.845345358204318e-12,   7.804749281123883e-14,  -3.978720909422947e-15,  -2.215245554209488e-16,   3.145929728025679e-18,
   4.623847922436727e-19,   3.185925139474704e-21,  -3.225510823891226e-03,  -1.178702754675130e-04,   4.764596176681566e-06,   3.517618721611672e-07,  -4.058002090229826e-09,
  -8.230626762419573e-10,  -6.800224445006986e-12,   1.524959050127957e-12,   4.177273561099896e-14,  -2.132637403734003e-15,  -1.185435268650129e-16,   1.689839461190590e-18,
   2.473828215088789e-19,   1.689183878576831e-21,  -1.200288832229134e-03,  -4.386032219602822e-05,   1.772978719693764e-06,   1.308813529827460e-07,  -1.510321186363045e-09,
  -3.062107760048408e-10,  -2.527889691662767e-12,   5.673029019126279e-13,   1.553261256870114e-14,  -7.933983367988154e-16,  -4.407600902979843e-17,   6.291292690996438e-19,
   9.197346835594665e-20,   6.260294571256381e-22,  -1.355817492061608e-04,  -4.954321116678367e-06,   2.002707061799852e-07,   1.478372923135591e-08,  -1.706066091352540e-10,
  -3.458757516375529e-11,  -2.854971477324413e-13,   6.407812153807333e-14,   1.754311467897024e-15,  -8.961667283580804e-17,  -4.978060181631060e-18,   7.107030504371303e-20,
   1.038760574937576e-20,   7.066900883417289e-23,  -2.313992483012292e-04,   7.960501522272804e-06,  -1.521997018734629e-07,   4.140722061658727e-09,  -1.004771283396718e-10,
  -2.231694924174781e-12,   2.910161890930352e-14,   7.116213038329671e-15,   2.918097615048856e-17,  -1.181163870353168e-17,  -2.479415245784373e-19,   1.573537456471927e-20,
   6.835710484341771e-22,  -1.402237666634204e-23,  -2.201484638199132e-04,   7.573668161669026e-06,  -1.448145492918999e-07,   3.938665976574459e-09,  -9.557682445596815e-11,
  -2.118760336157028e-12,   2.770856815985434e-14,   6.757610791394059e-15,   2.744045643756183e-17,  -1.121169900966713e-17,  -2.345802040741301e-19,   1.493747786348748e-20,
   6.467166386413795e-22,  -1.334134482160680e-23,  -1.987463509223161e-04,   6.837717711730636e-06,  -1.307598792955164e-07,   3.554598438072101e-09,  -8.626118912431014e-11,
  -1.905738620124893e-12,   2.504933598216380e-14,   6.080613534823159e-15,   2.426269257393504e-17,  -1.008095064201576e-17,  -2.097040468253148e-19,   1.343300841531154e-20,
   5.781091933197332e-22,  -1.204489671604658e-23,  -1.692852836420490e-04,   5.824478687019694e-06,  -1.114011829930069e-07,   3.026488773989374e-09,  -7.344959962452254e-11,
  -1.616004672309956e-12,   2.137117022250645e-14,   5.158667685332362e-15,   2.014422144722466e-17,  -8.544710712766922e-18,  -1.764997050752055e-19,   1.138791720553121e-20,
   4.865474421722424e-22,  -1.025908733946179e-23,  -1.346471811626530e-04,   4.632977608584592e-06,  -8.862582268919141e-08,   2.406306555037432e-09,  -5.840170938276352e-11,
  -1.279772618747049e-12,   1.702492979196328e-14,   4.087281878682697e-15,   1.562232976111178e-17,  -6.764087932423585e-18,  -1.387609859653282e-19,   9.016215878982586e-21,
   3.824981763215600e-22,  -8.158925676795528e-24,  -9.822228991771354e-05,   3.379816982372053e-06,  -6.466175418483706e-08,   1.754810062137715e-09,  -4.259159455266952e-11,
  -9.302978827488630e-13,   1.243473020056099e-14,   2.972295383409398e-15,   1.116253318219118e-17,  -4.915351929140724e-18,  -1.002746914114828e-19,   6.552712303045317e-21,
   2.764008111354014e-22,  -5.950784634576663e-24,  -6.357719026041317e-05,   2.187750530546887e-06,  -4.185890966037568e-08,   1.135620466507018e-09,  -2.756382586478870e-11,
  -6.007658175037613e-13,   8.055250845333829e-15,   1.919937190259106e-15,   7.125816961446035e-18,  -3.173530362621439e-18,  -6.450188999694204e-20,   4.230984501015396e-21,
   1.777918686863969e-22,  -3.851275462258759e-24,  -3.410480218441544e-05,   1.173596620186875e-06,  -2.245573905978087e-08,   6.091190277322439e-10,  -1.478477846265612e-11,
  -3.218854129607705e-13,   4.322872667996918e-15,   1.028823297377349e-15,   3.795192856872606e-18,  -1.700160227115279e-18,  -3.448992448468898e-20,   2.266755571796296e-21,
   9.506650995617909e-23,  -2.065776362775565e-24,  -1.269136957387767e-05,   4.367311704275019e-07,  -8.356589952209777e-09,   2.266623456932071e-10,  -5.501666265419937e-12,
  -1.197329956157616e-13,   1.608894452541265e-15,   3.827132149366717e-16,   1.408765668648231e-18,  -6.323905689333338e-19,  -1.282033725820196e-20,   8.431517235056242e-22,
   3.533729895584578e-23,  -7.687112634640391e-25,  -1.433589666648206e-06,   4.933225169959647e-08,  -9.439453622402438e-10,   2.560314122961932e-11,  -6.214532523615424e-13,
  -1.352388871756121e-14,   1.817413620204226e-16,   4.322792532755549e-17,   1.590678053407626e-19,  -7.142831803219877e-20,  -1.447900504770304e-21,   9.523391567285210e-23,
   3.990914269891026e-24,  -8.683154302049703e-26,  -2.091392077332288e-03,   7.024658325428709e-05,  -1.244364561955892e-06,   3.289113467028917e-08,  -7.822659662801486e-10,
  -2.526971152172143e-11,   3.637561367396729e-13,   6.638357882464133e-14,   3.094245618667530e-16,  -1.139109031549900e-16,  -2.391770543204185e-18,   1.515101048816715e-19,
   6.656895377761699e-21,  -1.344401804189172e-22,  -1.989703277041516e-03,   6.683268561262252e-05,  -1.183977400488998e-06,   3.128391208057041e-08,  -7.440531622426094e-10,
  -2.399970483046337e-11,   3.463028505342893e-13,   6.303442301631992e-14,   2.912770464625311e-16,  -1.081254915307711e-16,  -2.262762994396653e-18,   1.438285593248442e-19,
   6.297795204980739e-21,  -1.279279786294476e-22,  -1.796264570626100e-03,   6.033787897944921e-05,  -1.069057599659789e-06,   2.822981207869897e-08,  -6.714342536728893e-10,
  -2.160072700208859e-11,   3.130037102957673e-13,   5.671318059179636e-14,   2.580402811073814e-16,  -9.722117000276834e-17,  -2.022620651340088e-18,   1.293441820280140e-19,
   5.629376217699130e-21,  -1.155235904656875e-22,  -1.529989721481754e-03,   5.139624305738898e-05,  -9.107743711315317e-07,   2.403204140791240e-08,  -5.716113270007031e-10,
  -1.833113188593184e-11,   2.669789626574379e-13,   4.810783672537052e-14,   2.147564448079492e-16,  -8.240621661088837e-17,  -1.702168689540795e-18,   1.096540392068349e-19,
   4.737466838631544e-21,  -9.842303510954676e-23,  -1.216927748707315e-03,   4.088180742595775e-05,  -7.245624755618637e-07,   1.910463051629300e-08,  -4.544252270374706e-10,
  -1.452824422372585e-11,   2.126353344459192e-13,   3.811149203982233e-14,   1.669558486684792e-16,  -6.523415212229232e-17,  -1.338066904386118e-18,   8.681822644589301e-20,
   3.724101641166326e-21,  -7.829523776900119e-23,  -8.877202962407640e-04,   2.982356135921245e-05,  -5.286383354157732e-07,   1.393048803267391e-08,  -3.313604492594596e-10,
  -1.056750765748417e-11,   1.552776786953874e-13,   2.771196156455658e-14,   1.195379012712093e-16,  -4.740486879102559e-17,  -9.668577053620036e-19,   6.309756296738884e-20,
   2.690964925039468e-21,  -5.711720180212914e-23,  -5.746011327231690e-04,   1.930464231531240e-05,  -3.422127462656141e-07,   9.014370804227903e-09,  -2.144255428686767e-10,
  -6.827080416960247e-12,   1.005776626587717e-13,   1.789912423644926e-14,   7.641535140787586e-17,  -3.060643017530065e-17,  -6.218956786813511e-19,   4.074141000015992e-20,
   1.730872318496305e-21,  -3.697056544251225e-23,  -3.082337537988033e-04,   1.035575102293688e-05,  -1.835837056795432e-07,   4.834893486802639e-09,  -1.150088915298752e-10,
  -3.658671201582799e-12,   5.397211498580100e-14,   9.591131280642997e-15,   4.072817398643512e-17,  -1.639686196317065e-17,  -3.325246593626306e-19,   2.182734416404592e-20,
   9.254919642673253e-22,  -1.983191983465511e-23,  -1.147025259924238e-04,   3.853687712560520e-06,  -6.831803275669657e-08,   1.799111359468851e-09,  -4.279605411141299e-11,
  -1.361031224577991e-12,   2.008703000674721e-14,   3.567771473230156e-15,   1.512204112990584e-17,  -6.098971095047820e-18,  -1.236022451987768e-19,   8.118998914709193e-21,
   3.440136303078898e-22,  -7.379978215179445e-24,  -1.295654853227284e-05,   4.353045438380604e-07,  -7.717080569331167e-09,   2.032221090261827e-10,  -4.834113271951990e-12,
  -1.537308162653202e-13,   2.269031657951003e-15,   4.029833415267524e-16,   1.707542540227885e-18,  -6.888769639577553e-19,  -1.395933989786401e-20,   9.170404217743519e-22,
   3.885207812551610e-23,  -8.336255159445579e-25,  -5.853173576770894e-03,   1.853441508104110e-04,  -2.620716371627473e-06,   6.330680082962780e-08,  -1.454201595042267e-09,
  -1.000800239657899e-10,   1.518232623448397e-12,   2.059533297503253e-13,   1.020258543759624e-15,  -3.657269399713757e-16,  -7.795489274402656e-18,   4.917898755780438e-19,
   2.199243364617801e-20,  -4.334234424254565e-22,  -5.568551577602002e-03,   1.763345399993785e-04,  -2.493501599201931e-06,   6.019817327007094e-08,  -1.382788682981951e-09,
  -9.508533158866002e-11,   1.445177110205493e-12,   1.955497149164478e-13,   9.605431560570076e-16,  -3.471433793887611e-16,  -7.374472251822796e-18,   4.668616524601318e-19,
   2.080429450139032e-20,  -4.125338647336055e-22,  -5.027136551811918e-03,   1.591949663550420e-04,  -2.251419797552247e-06,   5.429719866707191e-08,  -1.247229202493012e-09,
  -8.563671701096066e-11,   1.305884042218002e-12,   1.759189135417060e-13,   8.511348909554081e-16,  -3.121205497724095e-16,  -6.590973636789440e-18,   4.198543654536377e-19,
   1.859340145921070e-20,  -3.726979405595261e-22,  -4.281881007497417e-03,   1.355999584967304e-04,  -1.918019505391661e-06,   4.619839406623204e-08,  -1.061183091449079e-09,
  -7.273203252160619e-11,   1.113528727080138e-12,   1.492047303592098e-13,   7.085712952182598e-16,  -2.645440625322352e-16,  -5.545856221505596e-18,   3.559479231804476e-19,
   1.564459601215446e-20,  -3.176948818247314e-22,  -3.405702458900559e-03,   1.078567876529122e-04,  -1.525826878332150e-06,   3.670695727020992e-08,  -8.431513775624648e-10,
  -5.768803375912469e-11,   8.866150362939416e-13,   1.181850363269168e-13,   5.510201917521817e-16,  -2.094064685644778e-16,  -4.358892684039307e-18,   2.818266208580431e-19,
   1.229591529941785e-20,  -2.528505483940740e-22,  -2.484360964352159e-03,   7.868069759952536e-05,  -1.113211673075496e-06,   2.675429958206687e-08,  -6.145326511030019e-10,
  -4.198721009128094e-11,   6.473062029083175e-13,   8.592610139677648e-14,   3.946202755433604e-16,  -1.521666162744582e-16,  -3.149241757973516e-18,   2.048287024484109e-19,
   8.883483501250064e-21,  -1.845291395683421e-22,  -1.608062053595880e-03,   5.092894868051783e-05,  -7.206235471881208e-07,   1.730780784117177e-08,  -3.975477090498996e-10,
  -2.713686050140063e-11,   4.192158270122428e-13,   5.549544630006338e-14,   2.523061899571689e-16,  -9.824189565521654e-17,  -2.025463842733209e-18,   1.322570470671514e-19,
   5.713440046183267e-21,  -1.194714950686034e-22,  -8.626117716269282e-04,   2.732005697415952e-05,  -3.865831222607598e-07,   9.281787301734346e-09,  -2.131947672831041e-10,
  -1.454590115340589e-11,   2.249430724440817e-13,   2.973574328447259e-14,   1.344871214149221e-16,  -5.263061195550161e-17,  -1.082958999671080e-18,   7.085751894095499e-20,
   3.054803773986031e-21,  -6.409571373401012e-23,  -3.210020235258221e-04,   1.016659424935098e-05,  -1.438609379322941e-07,   3.453672759175875e-09,  -7.932778158037316e-11,
  -5.411499434554734e-12,   8.371581005826021e-14,   1.106114813526143e-14,   4.993553163173927e-17,  -1.957636399990234e-17,  -4.025390008065732e-19,   2.635653493413417e-20,
   1.135477815250747e-21,  -2.385276457195879e-23,  -3.625968702369831e-05,   1.148396896886318e-06,  -1.625026231284108e-08,   3.901132237921669e-10,  -8.960550001847194e-12,
  -6.112453736385330e-13,   9.456501566464662e-15,   1.249365058446449e-15,   5.638621507082101e-18,  -2.211142671545288e-18,  -4.546167640299668e-20,   2.976969830330979e-21,
   1.282377944092489e-22,  -2.694372997123993e-24,  -1.155521535664237e-02,   3.200500185450846e-04,  -1.730483927435715e-06,   2.023714641649368e-08,  -8.073091986190256e-10,
  -2.776562413244003e-10,   3.682940246787049e-12,   5.370298284860452e-13,   1.804788150574367e-15,  -9.314982491758941e-16,  -2.014150882686011e-17,   1.295677183945729e-18,
   5.910893458580973e-20,  -1.164011062899382e-21,  -1.099321752493211e-02,   3.044843281404977e-04,  -1.646452595486848e-06,   1.917127479702412e-08,  -7.663938753178143e-10,
  -2.638202887342046e-10,   3.505154906590720e-12,   5.099259194320571e-13,   1.690967722688208e-15,  -8.840972433113156e-16,  -1.904947738744149e-17,   1.229946334385189e-18,
   5.590499376770756e-20,  -1.108151763905275e-21,  -9.924213135605865e-03,   2.748759458497957e-04,  -1.486558201204809e-06,   1.717713862552208e-08,  -6.892371798618322e-10,
  -2.376379811947716e-10,   3.166407364684186e-12,   4.587736794300408e-13,   1.485254773944014e-15,  -7.947918700769362e-16,  -1.701885055990450e-17,   1.106017857581009e-18,
   4.994712814362047e-20,  -1.001521143889161e-21,  -8.452814119072869e-03,   2.341221955516973e-04,  -1.266371743351649e-06,   1.449682591920370e-08,  -5.843377644129066e-10,
  -2.018625162416906e-10,   2.699066311877893e-12,   3.891459689599053e-13,   1.222827274624945e-15,  -6.735286098970168e-16,  -1.431330260490761e-17,   9.375779309458634e-19,
   4.200859094446210e-20,  -8.540914318730359e-22,  -6.723029301023666e-03,   1.862116475664951e-04,  -1.007387513958753e-06,   1.142722646081479e-08,  -4.626650007422729e-10,
  -1.601355610182247e-10,   2.148332087757346e-12,   3.082730351846425e-13,   9.402358800237430e-16,  -5.330609403116106e-16,  -1.124454625598103e-17,   7.422679959957488e-19,
   3.300352784263404e-20,  -6.800434664698469e-22,  -4.904177849766217e-03,   1.358339995606536e-04,  -7.349458501472000e-07,   8.275276993345791e-09,  -3.362645406437717e-10,
  -1.165674361565781e-10,   1.568045009638927e-12,   2.241471210569765e-13,   6.669805048597072e-16,  -3.873008737080375e-16,  -8.120908362999198e-18,   5.394297792828361e-19,
   2.383643467394504e-20,  -4.964515526748670e-22,  -3.174313629268996e-03,   8.792095374760165e-05,  -4.757479508519762e-07,   5.330499983690896e-09,  -2.171264407723736e-10,
  -7.534567378821536e-11,   1.015333433246838e-12,   1.447733701222503e-13,   4.236784381043972e-16,  -2.500273889254942e-16,  -5.221699209616883e-18,   3.482889878357255e-19,
   1.532715704495409e-20,  -3.214888238922284e-22,  -1.702786143075971e-03,   4.716315011375426e-05,  -2.552152788438025e-07,   2.852314554307891e-09,  -1.163273051949251e-10,
  -4.038863112357382e-11,   5.447581039204108e-13,   7.757506239528396e-14,   2.250652267879562e-16,  -1.339397831909474e-16,  -2.791527988966450e-18,   1.865927916025766e-19,
   8.194053035081669e-21,  -1.724947659866014e-22,  -6.336532917607392e-04,   1.755069993709330e-05,  -9.497406605293596e-08,   1.060503973657990e-09,  -4.326977855377521e-11,
  -1.502598696091143e-11,   2.027330979157358e-13,   2.885677059052805e-14,   8.346744674843174e-17,  -4.981915388094409e-17,  -1.037571233979428e-18,   6.940536492255120e-20,
   3.045630432968176e-21,  -6.419501891439233e-23,  -7.157607001446953e-05,   1.982488161920640e-06,  -1.072808633692545e-08,   1.197756816312180e-10,  -4.887321317751559e-12,
  -1.697235349296780e-12,   2.290052639209347e-14,   3.259399076082090e-15,   9.423182548432957e-18,  -5.627039881666141e-18,  -1.171796582346655e-19,   7.839321865659940e-21,
   3.439631411639355e-22,  -7.251415810483188e-24,  -1.893472557150935e-02,   3.476752935688707e-04,   9.663820154367540e-06,  -2.408701542888745e-07,  -2.344807277421897e-09,
  -4.495959456294717e-10,   1.876838549058613e-12,   1.536499940514049e-12,   5.040075947032712e-15,  -2.847543875954264e-15,  -4.846934654228235e-17,   4.077893365095631e-18,
   1.688851932962583e-19,  -4.107187050238766e-21,  -1.801344758438387e-02,   3.307425177080101e-04,   9.193352572363818e-06,  -2.292849086516075e-07,  -2.229903514633676e-09,
  -4.267822913344447e-10,   1.789389848546423e-12,   1.458761534846681e-12,   4.732671157980139e-15,  -2.702461685141996e-15,  -4.579213157453228e-17,   3.870028699183651e-18,
   1.596097168131184e-19,  -3.906909004339219e-21,  -1.626118925951538e-02,   2.985432825826706e-04,   8.298639424107957e-06,  -2.071949316326408e-07,  -2.011687492185136e-09,
  -3.837748710517009e-10,   1.621421343548788e-12,   1.312124355913834e-12,   4.173835876369843e-15,  -2.429193621617411e-15,  -4.083251775523853e-17,   3.478517106460087e-18,
   1.424076791014990e-19,  -3.525933877981157e-21,  -1.384963853054332e-02,   2.542419513528658e-04,   7.067500611552976e-06,  -1.766872726110878e-07,  -1.712007931385858e-09,
  -3.253275469705729e-10,   1.387138849524450e-12,   1.112671065135175e-12,   3.454277594275341e-15,  -2.058275991489998e-15,  -3.426079327954073e-17,   2.947149551753336e-18,
   1.195764320288672e-19,  -3.001748809520224e-21,  -1.101497663259522e-02,   2.021843013895527e-04,   5.620625273049328e-06,  -1.406930351316488e-07,  -1.360563730176409e-09,
  -2.575607463998088e-10,   1.107912560157748e-12,   8.811921820389355e-13,   2.670314046561821e-15,  -1.628790883374396e-15,  -2.685328961790889e-17,   2.331981332343505e-18,
   9.379200863798726e-20,  -2.386107760903945e-21,  -8.034703390030809e-03,   1.474678933851015e-04,   4.099677300533981e-06,  -1.027254573228321e-07,  -9.918292145709850e-10,
  -1.871814574769378e-10,   8.108593626056741e-13,   6.405778463755430e-13,   1.902952579863436e-15,  -1.183285500963496e-15,  -1.935722756906021e-17,   1.694000194304040e-18,
   6.765123941197508e-20,  -1.739630126405689e-21,  -5.200482030408710e-03,   9.544370154930728e-05,   2.653440804304237e-06,  -6.653162571002769e-08,  -6.417014221608464e-10,
  -1.208581099223935e-10,   5.259760721799543e-13,   4.136791153967935e-13,   1.212614854765169e-15,  -7.638312600603861e-16,  -1.243098744052680e-17,   1.093441221983943e-18,
   4.346263198847707e-20,  -1.125560786789561e-21,  -2.789644127560629e-03,   5.119648819513176e-05,   1.423335917619594e-06,  -3.570055887280925e-08,  -3.441492745145916e-10,
  -6.474940585937602e-11,   2.824574914593991e-13,   2.216481993796104e-13,   6.452349121400423e-16,  -4.091696663544766e-16,  -6.641320847241804e-18,   5.857164978299125e-19,
   2.322507680875364e-20,  -6.036510653437154e-22,  -1.038098653713851e-03,   1.905134804241230e-05,   5.296570131309468e-07,  -1.328660778093303e-08,  -1.280574557031054e-10,
  -2.408439669194034e-11,   1.051501694061118e-13,   8.244766542036879e-14,   2.394314704719871e-16,  -1.521894754461096e-16,  -2.467926617301438e-18,   2.178530624010961e-19,
   8.631121412921623e-21,  -2.246178604495941e-22,  -1.172612451997514e-04,   2.151993251217295e-06,   5.982878776861896e-08,  -1.500851786673329e-09,  -1.446490858954779e-11,
  -2.720329538561654e-12,   1.187824634355411e-14,   9.312501559574740e-15,   2.703349909332914e-17,  -1.718966381708475e-17,  -2.787089778727566e-19,   2.460626161695212e-20,
   9.747451287410327e-22,  -2.537202445758339e-23,  -2.442940675422126e-02,  -4.435415419376242e-04,   5.499077704744858e-05,   1.110798048739704e-06,  -1.255134509591532e-07,
  -2.893275942123752e-09,   2.648922236519310e-10,   7.372551523459602e-12,  -5.168708632499881e-13,  -1.784521566960077e-14,   9.367837418632987e-16,   4.086198278718274e-17,
  -1.572428492577868e-18,  -8.896619689602405e-20,  -2.323955010559302e-02,  -4.218700921767410e-04,   5.229390351519924e-05,   1.055922178336463e-06,  -1.192919255727218e-07,
  -2.748030792226048e-09,   2.515845310709732e-10,   6.995293020436500e-12,  -4.905013242661012e-13,  -1.691229596368085e-14,   8.882032396489517e-16,   3.867556738506466e-17,
  -1.489600405378147e-18,  -8.408704412484032e-20,  -2.097696036646177e-02,  -3.806882520890217e-04,   4.717315764089191e-05,   9.518878670305838e-07,  -1.075054942674601e-07,
  -2.473609185092277e-09,   2.264452233292319e-10,   6.285381692483720e-12,  -4.408484298835349e-13,  -1.516460704039906e-14,   7.970401163459419e-16,   3.459932219502869e-17,
  -1.334672219882537e-18,  -7.503655157038401e-20,  -1.786403627850773e-02,  -3.240832012452221e-04,   4.014250225444520e-05,   8.093656023876127e-07,  -9.137492818094760e-08,
  -2.099473739121648e-09,   1.921788208154522e-10,   5.323064363686114e-12,  -3.734807065257235e-13,  -1.281070385815022e-14,   6.739571333711633e-16,   2.914722426719475e-17,
  -1.126471386122956e-18,  -6.302009881438129e-20,  -1.420617274206752e-02,  -2.576371553326789e-04,   3.189951444318797e-05,   6.426643680035210e-07,  -7.252846702756048e-08,
  -1.664150906104969e-09,   1.523180715565809e-10,   4.210374642226503e-12,  -2.955093831408994e-13,  -1.010815775153560e-14,   5.322671123313032e-16,   2.293576748781164e-17,
  -8.880336181585348e-19,  -4.944256682553842e-20,  -1.036155642627196e-02,  -1.878621236996320e-04,   2.325283891324351e-05,   4.681685247840721e-07,  -5.282007694007352e-08,
  -1.210599245510660e-09,   1.107973908245372e-10,   3.057619826653299e-12,  -2.146593513994392e-13,  -7.326191251094858e-15,   3.860617906806309e-16,   1.658678061571567e-17,
  -6.431584664865264e-19,  -3.566978029006410e-20,  -6.706152196831358e-03,  -1.215654718048235e-04,   1.504372105888892e-05,   3.027614325098988e-07,  -3.415175843306428e-08,
  -7.821594930383014e-10,   7.158215181630540e-11,   1.973265704228895e-12,  -1.385569368635564e-13,  -4.721859941984838e-15,   2.489452091017825e-16,   1.067485793861984e-17,
  -4.143249974696164e-19,  -2.291941959065551e-20,  -3.597208391981919e-03,  -6.520226677085972e-05,   8.067902192123850e-06,   1.623353093819040e-07,  -1.830974082418548e-08,
  -4.191799909622555e-10,   3.836187325650183e-11,   1.056908792983471e-12,  -7.421973498267522e-14,  -2.527396318287426e-15,   1.332824458496227e-16,   5.709467993080374e-18,
  -2.217134827674857e-19,  -1.224836843288870e-20,  -1.338600222940145e-03,  -2.426242241758899e-05,   3.002034618300936e-06,   6.039983170647923e-08,  -6.812238628278949e-09,
  -1.559377085633403e-10,   1.427075217552144e-11,   3.930971811726833e-13,  -2.760548927835542e-14,  -9.397972647477863e-16,   4.956461062455375e-17,   2.122475311776005e-18,
  -8.243560073801642e-20,  -4.551977992477940e-21,  -1.512049636969346e-04,  -2.740609257594571e-06,   3.390986457228615e-07,   6.822459349026434e-09,  -7.694717634689542e-10,
  -1.761347023015099e-11,   1.611907376577981e-12,   4.439966730520984e-14,  -3.118009241110197e-15,  -1.061445839248302e-16,   5.598109356913441e-18,   2.397111537400805e-19,
  -9.310487369424339e-21,  -5.140742967132418e-22,  -2.010197948438192e-04,   6.887521079789150e-06,  -1.129369752797418e-07,   2.270329739170733e-09,  -1.227918731352968e-10,
   5.418376020976213e-13,   1.731513017277532e-13,   1.075600117204771e-15,  -3.534281708657855e-16,  -3.268749113886138e-18,  -1.858715101006363e-04,   6.368624771182929e-06,
  -1.044555904001814e-07,   2.099428274410773e-09,  -1.134233115921651e-10,   5.019595464853353e-13,   1.596718094479676e-13,   9.895157768473623e-16,  -3.255753008827559e-16,
  -3.001669582550375e-18,  -1.578781105551597e-04,   5.409648723897001e-06,  -8.876464836289525e-08,   1.783498667854524e-09,  -9.618060691703665e-11,   4.276851411581606e-13,
   1.350246298305504e-13,   8.335130159546243e-16,  -2.748481680278328e-16,  -2.520853080875531e-18,  -1.212979297987938e-04,   4.156384478777607e-06,  -6.823113197834085e-08,
   1.370474250706445e-09,  -7.376521918055943e-11,   3.296644746458756e-13,   1.032526171289125e-13,   6.347423755581676e-16,  -2.097929088531876e-16,  -1.913542440272654e-18,
  -8.169883021210562e-05,   2.799562118798848e-06,  -4.597385093112354e-08,   9.231788862851721e-10,  -4.961474251375429e-11,   2.226079985577961e-13,   6.928739780905083e-14,
   4.245497238508726e-16,  -1.405792336184410e-16,  -1.276628230038441e-18,  -4.511085732403600e-05,   1.545831822397181e-06,  -2.539052862754649e-08,   5.097784409801098e-10,
  -2.737335355398117e-11,   1.230951563860200e-13,   3.817599016490837e-14,   2.334761998769885e-16,  -7.739223555669483e-17,  -7.010322772558809e-19,  -1.710643990470397e-05,
   5.861967233373998e-07,  -9.629110795300847e-09,   1.933176146157892e-10,  -1.037709840929944e-11,   4.670434726419973e-14,   1.446504747669027e-14,   8.840223720388838e-17,
  -2.931512474230713e-17,  -2.652879904688426e-19,  -1.950365666988701e-06,   6.683442603911476e-08,  -1.097863985528380e-09,   2.204092040880746e-11,  -1.183070680470423e-12,
   5.325410579587047e-15,   1.648991489218468e-15,   1.007652036671846e-17,  -3.341703258790146e-18,  -3.023604143546299e-20,  -1.821812412096365e-03,   6.141147557915077e-05,
  -9.350037780769003e-07,   1.734588898955789e-08,  -1.057478960980903e-09,   2.828067493436026e-12,   1.702627411270625e-12,   9.049885710140928e-15,  -3.377040154021796e-15,
  -3.115439523997691e-17,  -1.684521862692058e-03,   5.678443706898892e-05,  -8.647968284019029e-07,   1.603958583526810e-08,  -9.766597084410096e-10,   2.622989546924965e-12,
   1.570200736591675e-12,   8.320007672340026e-15,  -3.110761858685304e-15,  -2.860777602223580e-17,  -1.430817001678048e-03,   4.823340478686774e-05,  -7.349045097423706e-07,
   1.362509196962649e-08,  -8.279954205144130e-10,   2.239106206954944e-12,   1.327989068737363e-12,   7.000534079014859e-15,  -2.625884593995620e-15,  -2.402380263611529e-17,
  -1.099293871219517e-03,   3.705863904595732e-05,  -5.649140705484232e-07,   1.046912891644035e-08,  -6.348706228467141e-10,   1.729347544576573e-12,   1.015642514227061e-12,
   5.324747225293200e-15,  -2.004190186915445e-15,  -1.823491954364171e-17,  -7.404144325928915e-04,   2.496087718209932e-05,  -3.806428677095079e-07,   7.051870208896528e-09,
  -4.269334142561169e-10,   1.169547664262222e-12,   6.816166965806511e-13,   3.558105636366316e-15,  -1.342894546110546e-15,  -1.216488281980019e-17,  -4.088267661552196e-04,
   1.378255264357888e-05,  -2.102241375684486e-07,   3.893925803951206e-09,  -2.355205340120635e-10,   6.472906535490977e-13,   3.755805009628363e-13,   1.955662428891836e-15,
  -7.392686342937368e-16,  -6.679880682922338e-18,  -1.550306534516427e-04,   5.226487697489568e-06,  -7.972573436945105e-08,   1.476634598768432e-09,  -8.928087429195876e-11,
   2.456733940633987e-13,   1.423123727683380e-13,   7.403284990922448e-16,  -2.800210467469696e-16,  -2.527804521871381e-18,  -1.767559065343550e-05,   5.958907231544884e-07,
  -9.089942434980153e-09,   1.683567669427862e-10,  -1.017864954136183e-11,   2.801415270000315e-14,   1.622343752697328e-14,   8.438336749336986e-17,  -3.192021602970293e-17,
  -2.881044949117145e-19,  -5.131768844601684e-03,   1.663123596672784e-04,  -2.048023047640808e-06,   2.776996102628903e-08,  -2.651119002167886e-09,  -3.744000777849570e-12,
   5.625567587531949e-12,   2.270407044002454e-14,  -1.079071151556452e-14,  -9.547694666310752e-17,  -4.745016400538964e-03,   1.537790428662555e-04,  -1.894327508818638e-06,
   2.567502505197624e-08,  -2.447621750667375e-09,  -3.441556060858863e-12,   5.188470830463373e-12,   2.084662845070954e-14,  -9.939149086568573e-15,  -8.765187567644242e-17,
  -4.030336225739567e-03,   1.306182875822898e-04,  -1.609918078636913e-06,   2.180505225530539e-08,  -2.073822997231536e-09,  -2.895078479275061e-12,   4.388747166951882e-12,
   1.750384641354708e-14,  -8.388926836271746e-15,  -7.357839640618296e-17,  -3.096469991844736e-03,   1.003536213108302e-04,  -1.237624543411524e-06,   1.675028462388151e-08,
  -1.589115248959950e-09,  -2.201502229507852e-12,   3.357013042276265e-12,   1.328382512935417e-14,  -6.401986510638851e-15,  -5.582545034842058e-17,  -2.085569677879399e-03,
   6.759173588280113e-05,  -8.339702855657928e-07,   1.128060955090879e-08,  -1.068106517096359e-09,  -1.470796410131695e-12,   2.253225857338849e-12,   8.860611951435900e-15,
  -4.289181241826640e-15,  -3.723004172433849e-17,  -1.151561878781476e-03,   3.732138441269899e-05,  -4.606070921943477e-07,   6.228275779612071e-09,  -5.890586156863786e-10,
  -8.083091808380562e-13,   1.241646272517684e-12,   4.865026281919190e-15,  -2.361074668981150e-15,  -2.043955754301076e-17,  -4.366815400095934e-04,   1.415258878013363e-05,
  -1.746836479931320e-07,   2.361756654222607e-09,  -2.232756267196323e-10,  -3.059773145120518e-13,   4.704884132556399e-13,   1.840961507993204e-15,  -8.943112707418693e-16,
  -7.734194688522200e-18,  -4.978758655842722e-05,   1.613586407364786e-06,  -1.991662741990908e-08,   2.692710675658788e-10,  -2.545454133666457e-11,  -3.487534279986766e-14,
   5.363534123868153e-14,   2.098208773704558e-16,  -1.019441456772781e-16,  -8.814881464077973e-19,  -1.026618855415633e-02,   3.055265388594358e-04,  -1.713596855856965e-06,
  -2.740218721270486e-08,  -4.349891760329303e-09,  -3.524958086417670e-11,   1.415260542766354e-11,   4.797795242696728e-14,  -2.783234881215247e-14,  -2.031004056380131e-16,
  -9.492378967405776e-03,   2.824916847663612e-04,  -1.585544439107687e-06,  -2.535188149763637e-08,  -4.012807472151652e-09,  -3.254968199260540e-11,   1.305215583381900e-11,
   4.405197214192528e-14,  -2.563406045023112e-14,  -1.862982353061507e-16,  -8.062518940955828e-03,   2.399310177931370e-04,  -1.348253826176435e-06,  -2.155413037582481e-08,
  -3.395528399783529e-09,  -2.758705186770402e-11,   1.103922922439663e-11,   3.698728090657121e-14,  -2.163330687968831e-14,  -1.561686385264910e-16,  -6.194239347740028e-03,
   1.843264911253467e-04,  -1.037086474561632e-06,  -1.657666827692986e-08,  -2.598279150870250e-09,  -2.114623420353151e-11,   8.443134845074486e-12,   2.806954188861784e-14,
  -1.650732130868210e-14,  -1.183116694705454e-16,  -4.171951289393884e-03,   1.241442191610304e-04,  -6.991637212559341e-07,  -1.117381546193799e-08,  -1.744484105180951e-09,
  -1.421703680858979e-11,   5.666540365205653e-12,   1.872293585658941e-14,  -1.105842760317585e-14,  -7.880856505315455e-17,  -2.303551923092156e-03,   6.854535981861596e-05,
  -3.862560365943701e-07,  -6.172536846788922e-09,  -9.614672025026578e-10,  -7.841910836896782e-12,   3.122407057207032e-12,   1.028006061098260e-14,  -6.087010074794373e-15,
  -4.323661979891157e-17,  -8.735225745929874e-04,   2.599270494032841e-05,  -1.465009809747491e-07,  -2.341079418927127e-09,  -3.643454338207938e-10,  -2.972561376871281e-12,
   1.183129917864455e-12,   3.890053283881885e-15,  -2.305545754196840e-15,  -1.635619972857033e-17,  -9.959330342268420e-05,   2.963514334455071e-06,  -1.670364709935276e-08,
  -2.669222649106331e-10,  -4.153555831852652e-11,  -3.388902968758689e-13,   1.348755425518102e-13,   4.433631703249546e-16,  -2.628123671796680e-16,  -1.864082110009819e-18,
  -1.734893031895857e-02,   4.107546024501739e-04,   6.275497126856905e-06,  -3.330203607176051e-07,  -7.696332959008942e-09,   3.232739818595137e-11,   3.147504845912009e-11,
   1.228464166603618e-13,  -7.726782345566526e-14,  -2.702857326240099e-16,  -1.604085995466324e-02,   3.797472850403966e-04,   5.800462142079430e-06,  -3.079020759106073e-07,
  -7.095821914192881e-09,   3.000168937085443e-11,   2.900923880289875e-11,   1.131771246402826e-13,  -7.114495745612138e-14,  -2.475618848399160e-16,  -1.362402566847378e-02,
   3.224796872477330e-04,   4.923911253527115e-06,  -2.614982540535803e-07,  -5.998583984291172e-09,   2.563673504626875e-11,   2.450971784488627e-11,   9.556186560006902e-14,
  -6.001347016500457e-14,  -2.070238305315550e-16,  -1.046655409782280e-02,   2.477001185928479e-04,   3.780635762903424e-06,  -2.008833660063124e-07,  -4.585510411066228e-09,
   1.982139320956082e-11,   1.872487334171650e-11,   7.296002007334673e-14,  -4.577081672457715e-14,  -1.564366203374949e-16,  -7.049203414133437e-03,   1.668030375750809e-04,
   2.545129227824290e-06,  -1.352888578670628e-07,  -3.076253199220808e-09,   1.341632697629824e-11,   1.255597338749754e-11,   4.889957292755764e-14,  -3.065044251142314e-14,
  -1.039929724664614e-16,  -3.892155702556159e-03,   9.209166085843508e-05,   1.404914061566932e-06,  -7.469673371624735e-08,  -1.694685097907422e-09,   7.428900096272741e-12,
   6.915130786290114e-12,   2.692382656800513e-14,  -1.686746649469717e-14,  -5.698668560334184e-17,  -1.475920951889068e-03,   3.492050375638787e-05,   5.326982714459114e-07,
  -2.832503944502640e-08,  -6.420849604522726e-10,   2.820082907024405e-12,   2.619750994075237e-12,   1.019888464456318e-14,  -6.388264968786812e-15,  -2.154828961085069e-17,
  -1.682745998576827e-04,   3.981382138947562e-06,   6.073372254931105e-08,  -3.229425956764689e-09,  -7.319589436865120e-11,   3.215838728454649e-13,   2.986393058132172e-13,
   1.162605633437365e-15,  -7.281970164521161e-16,  -2.455634483005768e-18,  -2.520227128815454e-02,   1.355056374713321e-05,   5.538613666235601e-05,  -9.794420828474731e-07,
  -1.137279578902049e-07,   3.778925346801266e-09,   2.057940731932119e-10,  -1.043777576628050e-11,  -3.262820422791508e-13,   2.473202146702336e-14,  -2.330008680896897e-02,
   1.240337284628974e-05,   5.118141779366597e-05,  -9.039816621709585e-07,  -1.050210563016238e-07,   3.484630579709442e-09,   1.898851631528451e-10,  -9.612858188431041e-12,
  -3.008332702763042e-13,   2.274276416269577e-14,  -1.978675060443137e-02,   1.035982992819217e-05,   4.343003043938752e-05,  -7.655372593993798e-07,  -8.901396198126379e-08,
   2.946583095984552e-09,   1.607296110013316e-10,  -8.111852227176046e-12,  -2.543281916279894e-13,   1.914354786155712e-14,  -1.519876128453488e-02,   7.816652987324364e-06,
   3.333221085732352e-05,  -5.862940025101214e-07,  -6.823474501095109e-08,   2.253112878709312e-09,   1.230354451988209e-10,  -6.189178133709653e-12,  -1.944273214043994e-13,
   1.456720069715144e-14,  -1.023513861683995e-02,   5.189245352969561e-06,   2.243192910489077e-05,  -3.939033517429286e-07,  -4.587684627589153e-08,   1.511881185028504e-09,
   8.262948039794310e-11,  -4.145886372891643e-12,  -1.304398742061856e-13,   9.737441824999762e-15,  -5.650860550012933e-03,   2.841243010143656e-06,   1.238010055652596e-05,
  -2.171834657665368e-07,  -2.530531950861652e-08,   8.329964910633617e-10,   4.554850664264526e-11,  -2.281966371122252e-12,  -7.186013937425404e-14,   5.353119769464186e-15,
  -2.142774557124771e-03,   1.074001784694232e-06,   4.693801758487924e-06,  -8.231318580710065e-08,  -9.592295189254584e-09,   3.156231026466211e-10,   1.726155738333641e-11,
  -8.643146687339502e-13,  -2.722673561359577e-14,   2.026611121153479e-15,  -2.443037458757299e-04,   1.223860601769627e-07,   5.351409976973022e-07,  -9.383972196034661e-09,
  -1.093581411266116e-09,   3.598045768079832e-11,   1.967846293715140e-12,  -9.852416465741706e-14,  -3.103776684326761e-15,   2.309980259481191e-16,  -1.751484240685204e-04,
   6.061850197108622e-06,  -9.641893835680330e-08,   6.057311264458240e-10,  -7.438523386280026e-11,   3.846642420991083e-12,   6.153217546515873e-14,  -7.451323904059318e-15,
  -6.611872236803328e-17,   1.474205871761420e-17,  -1.619496333901438e-04,   5.604978390689315e-06,  -8.917015647898506e-08,   5.617359676942893e-10,  -6.873775587766652e-11,
   3.549920600792459e-12,   5.681252991458870e-14,  -6.866825047746273e-15,  -6.113950244222954e-17,   1.356872787830472e-17,  -1.375588773975812e-04,   4.760739532381124e-06,
  -7.576437713733518e-08,   4.794336295732946e-10,  -5.832690330104919e-11,   3.005754641376315e-12,   4.814082267780559e-14,  -5.800700977865934e-15,  -5.193474174802884e-17,
   1.143858835782145e-17,  -1.056865262997045e-04,   3.657604774377460e-06,  -5.822924124596721e-08,   3.702194517064409e-10,  -4.476498770517461e-11,   2.301585289506142e-12,
   3.689258705146686e-14,  -4.430770585765934e-15,  -3.990272727082679e-17,   8.718115610435244e-18,  -7.118388779136100e-05,   2.463497189582366e-06,  -3.922990600035941e-08,
   2.503464926629034e-10,  -3.012572697382077e-11,   1.546116760470346e-12,   2.479872329687946e-14,  -2.970617272164100e-15,  -2.687597666263874e-17,   5.835006598790268e-18,
  -3.930490335848874e-05,   1.360232642631188e-06,  -2.166447024610071e-08,   1.385462987361378e-10,  -1.662620468974395e-11,   8.524040465882529e-13,   1.367698633585526e-14,
  -1.635911740468514e-15,  -1.483968330143951e-17,   3.210122096006350e-18,  -1.490476756096028e-05,   5.158105277306692e-07,  -8.215826132061075e-09,   5.258280271982877e-11,
  -6.303662628706730e-12,   3.230542596677210e-13,   5.184173276693273e-15,  -6.197344994108512e-16,  -5.627305974856919e-18,   1.215638946590682e-18,  -1.699345170333418e-06,
   5.880934642602765e-08,  -9.367241699003702e-10,   5.995997851923341e-12,  -7.186812610927213e-13,   3.682906328041091e-14,   5.910231647355092e-16,  -7.064644921846220e-17,
  -6.415883253385151e-19,   1.385677879643409e-19,  -1.590191051341378e-03,   5.449467795668656e-05,  -8.196012204332391e-07,   2.968876738339305e-09,  -6.330834591008199e-10,
   3.516949155201515e-11,   6.055519647904582e-13,  -7.194641668167160e-14,  -5.962984647235471e-16,   1.417542035489059e-16,  -1.470355372177897e-03,   5.038717718002596e-05,
  -7.579836199508128e-07,   2.760298895429120e-09,  -5.849647856503505e-10,   3.245312502942677e-11,   5.591709838976531e-13,  -6.630371213161430e-14,  -5.515145712828257e-16,
   1.304683423329277e-16,  -1.248906056135539e-03,   4.279725394907176e-05,  -6.440289715169664e-07,   2.365668746809521e-09,  -4.962925725316450e-10,   2.747356667446183e-11,
   4.739128179213374e-13,  -5.601089522087621e-14,  -4.686500546363457e-16,   1.099813416119992e-16,  -9.595320918990577e-04,   3.288011850034051e-05,  -4.949730136710835e-07,
   1.834700783617966e-09,  -3.808357401941537e-10,   2.103329315388068e-11,   3.632568993235216e-13,  -4.278408379926912e-14,  -3.602102240542941e-16,   8.382016364403744e-17,
  -6.462798068299080e-04,   2.214546614478191e-05,  -3.334706995969967e-07,   1.244817260084634e-09,  -2.562606302196380e-10,   1.412727132231432e-11,   2.442164521538331e-13,
  -2.868523315593037e-14,  -2.426856685588476e-16,   5.609845207131629e-17,  -3.568494563393467e-04,   1.222767057771196e-05,  -1.841571119888403e-07,   6.902268832057110e-10,
  -1.414183533447791e-10,   7.787971687401291e-12,   1.347029009043600e-13,  -1.579707280885532e-14,  -1.340222191772360e-16,   3.086182568871018e-17,  -1.353204078215063e-04,
   4.636816469040549e-06,  -6.983797915187997e-08,   2.621511726789016e-10,  -5.361591289574410e-11,   2.951483584139331e-12,   5.106007281210800e-14,  -5.984451267519750e-15,
  -5.082527370923988e-17,   1.168694795968995e-17,  -1.542835616539340e-05,   5.286593520374061e-07,  -7.962549602408262e-09,   2.989654711095300e-11,  -6.112728261699728e-12,
   3.364753535824610e-13,   5.821152471207207e-15,  -6.821962336497412e-16,  -5.794822292210679e-18,   1.332165550433150e-18,  -4.498144810498489e-03,   1.505802460521166e-04,
  -1.949077657947058e-06,  -8.383396330953704e-09,  -1.519426382183793e-09,   1.021692979281089e-10,   1.982996638097252e-12,  -2.319899958436476e-13,  -1.648715530004171e-15,
   4.564586233140495e-16,  -4.159151477109793e-03,   1.392281798476370e-04,  -1.802548824607549e-06,  -7.707282281286008e-09,  -1.403592195887803e-09,   9.425726660889953e-11,
   1.831480724246888e-12,  -2.137963133749616e-13,  -1.525967308580940e-15,   4.200969871845195e-16,  -3.532721500290380e-03,   1.182529180338060e-04,  -1.531558845312012e-06,
  -6.484767398092423e-09,  -1.190343400737423e-09,   7.976553532733222e-11,   1.552742122154061e-12,  -1.806087284672845e-13,  -1.298176923282196e-15,   3.541023376133708e-16,
  -2.714164513746150e-03,   9.084844592150523e-05,  -1.177093315059557e-06,  -4.932030943393800e-09,  -9.130283650879940e-10,   6.104345839309442e-11,   1.190602342161313e-12,
  -1.379598444558771e-13,  -9.989895814287292e-16,   2.698493680693686e-16,  -1.828078812789538e-03,   6.118706792795229e-05,  -7.930268236554675e-07,  -3.295347886454601e-09,
  -6.141582316033507e-10,   4.098803972777751e-11,   8.006587464910461e-13,  -9.249798880467641e-14,  -6.736784531788540e-16,   1.805904022181392e-16,  -1.009387728662888e-03,
   3.378416365591959e-05,  -4.379445797676791e-07,  -1.811107903345280e-09,  -3.388586120370595e-10,   2.259156321934691e-11,   4.416910256037024e-13,  -5.093925142792184e-14,
  -3.722340716283991e-16,   9.934558313556911e-17,  -3.827681323480290e-04,   1.281112682813694e-05,  -1.660819730886003e-07,  -6.855855641466716e-10,  -1.284618812065068e-10,
   8.561174747913502e-12,   1.674360639728231e-13,  -1.929749981113616e-14,  -1.411904455385286e-16,   3.762025455388058e-17,  -4.364073408447806e-05,   1.460639392741357e-06,
  -1.893577178323937e-08,  -7.814330769067446e-11,  -1.464570652039396e-11,   9.759811966970294e-13,   1.908889780888371e-14,  -2.199814986083775e-15,  -1.609829877190674e-17,
   4.288227017646631e-18,  -9.075178310155958e-03,   2.893806595751514e-04,  -2.426509746674090e-06,  -8.548423656161083e-08,  -2.046024058448827e-09,   2.273290690815993e-10,
   4.705729106256626e-12,  -5.842748780460285e-13,  -2.997665565019173e-15,   1.172940388787970e-15,  -8.391179917520617e-03,   2.675554922230748e-04,  -2.244125271712752e-06,
  -7.894220170852351e-08,  -1.888709220419575e-09,   2.096630599692706e-10,   4.347262432551047e-12,  -5.384178172190463e-13,  -2.781689507413565e-15,   1.079445652519990e-15,
  -7.127250952277828e-03,   2.272345359664406e-04,  -1.906801101392816e-06,  -6.691360166299349e-08,  -1.599893552272693e-09,   1.773423263934488e-10,   3.687147010124906e-12,
  -4.547896961511726e-13,  -2.376394229631493e-15,   9.097910660838936e-16,  -5.475740085410808e-03,   1.745638221527536e-04,  -1.465530313892479e-06,  -5.129643372968570e-08,
  -1.225645482748249e-09,   1.356477340637993e-10,   2.828430377367355e-12,  -3.473554896877722e-13,  -1.836715229219123e-15,   6.932557776195086e-16,  -3.688050477905031e-03,
   1.175644816860001e-04,  -9.873730909442737e-07,  -3.449017744173986e-08,  -8.236369571914792e-10,   9.104452543572358e-11,   1.902713054668210e-12,  -2.328702172891485e-13,
  -1.242797660803445e-15,   4.639109140296425e-16,  -2.036372576759362e-03,   6.491095193574696e-05,  -5.452780335173924e-07,  -1.902503814092367e-08,  -4.541801828120601e-10,
   5.016960829682230e-11,   1.049854397912182e-12,  -1.282363607109919e-13,  -6.880190880733906e-16,   2.551936680575455e-16,  -7.722074196382445e-04,   2.461431470547084e-05,
  -2.067870682303288e-07,  -7.211750897395610e-09,  -1.721438385321002e-10,   1.901031609801579e-11,   3.980074908250449e-13,  -4.857927304869165e-14,  -2.611571748955587e-16,
   9.663536097647748e-17,  -8.804203553558840e-05,   2.806355596684420e-06,  -2.357676570177710e-08,  -8.221859370175617e-10,  -1.962511462426777e-11,   2.167160371110066e-12,
   4.537622391491047e-14,  -5.537767097091859e-15,  -2.978024767373138e-17,   1.101516364581100e-17,  -1.563338444127626e-02,   4.431822401679308e-04,   1.686358656476398e-06,
  -4.135123661061987e-07,  -5.501635061661470e-10,   5.809163760309980e-10,   6.654729597071545e-12,  -1.464050457005427e-12,  -2.461250022678742e-16,   3.165362900447985e-15,
  -1.445483400633309e-02,   4.097203269987009e-04,   1.559103498885033e-06,  -3.820902907707918e-07,  -5.043158156081632e-10,   5.358006353678681e-10,   6.152366883335260e-12,
  -1.348794879132112e-12,  -2.988314552455873e-16,   2.912947720712786e-15,  -1.227720131877278e-02,   3.479233847677657e-04,   1.324048928823281e-06,  -3.241819604835623e-07,
  -4.222440140932296e-10,   4.532433256887743e-10,   5.224452471715892e-12,  -1.138811202345574e-12,  -3.522866137813680e-16,   2.454976549012499e-15,  -9.432061474131346e-03,
   2.672361714246388e-04,   1.017070855931162e-06,  -2.487740342786587e-07,  -3.194237759376479e-10,   3.467147188831502e-10,   4.012763511252494e-12,  -8.693953333617122e-13,
  -3.500009495332593e-16,   1.870555643691009e-15,  -6.352577976578996e-03,   1.799547843255247e-04,   6.849324676134004e-07,  -1.674027080559594e-07,  -2.125015331962080e-10,
   2.327266573175985e-10,   2.702069681432250e-12,  -5.826400610902526e-13,  -2.773452154760819e-16,   1.251666811622457e-15,  -3.507552996761704e-03,   9.935145516589119e-05,
   3.781596037164828e-07,  -9.238344990506971e-08,  -1.164929590205221e-10,   1.282484141237512e-10,   1.491747585533506e-12,  -3.207796000386549e-13,  -1.662984537696019e-16,
   6.885104956809783e-16,  -1.330082758401477e-03,   3.767318680485765e-05,   1.433968148013733e-07,  -3.502555859444931e-08,  -4.405528813974691e-11,   4.859681476184912e-11,
   5.656507059643327e-13,  -1.215101024483620e-13,  -6.492865682814039e-17,   2.607183768419112e-16,  -1.516471965131034e-04,   4.295219672929898e-06,   1.634908916332599e-08,
  -3.993254119630094e-09,  -5.020633462814172e-12,   5.540012034838947e-12,   6.449120185993281e-14,  -1.385129542335501e-14,  -7.437984561118819e-18,   2.971841728279493e-17,
  -2.437089080546151e-02,   3.856380751374892e-04,   3.577937576536886e-05,  -2.035878790654016e-06,  -1.496041514051289e-08,   4.863818943038618e-09,  -1.000524073544932e-10,
  -7.491761791299854e-12,   3.854459160949685e-13,   5.690736672778257e-15,  -2.253219968806610e-02,   3.563040919512215e-04,   3.307815768262613e-05,  -1.880298155117650e-06,
  -1.389669324770636e-08,   4.490317793329336e-09,  -9.204680024453293e-11,  -6.917881075959963e-12,   3.546879937944020e-13,   5.281667515766913e-15,  -1.913568602495198e-02,
   3.022616273728917e-04,   2.808941172888536e-05,  -1.594101885697109e-06,  -1.189215967831515e-08,   3.804329459149827e-09,  -7.753677606354620e-11,  -5.862971120738743e-12,
   2.988927386548327e-13,   4.513334141935062e-15,  -1.469950331918675e-02,   2.319178229055174e-04,   2.157542388180296e-05,  -1.222298956354498e-06,  -9.208442092482807e-09,
   2.914958981919976e-09,  -5.904658243833972e-11,  -4.493865830093627e-12,   2.277121205585339e-13,   3.489243962372950e-15,  -9.899375049551755e-03,   1.560413784284455e-04,
   1.452884683576756e-05,  -8.219679776414793e-07,  -6.240053692446152e-09,   1.959148962339284e-09,  -3.949312084993105e-11,  -3.021123300899687e-12,   1.523561775993923e-13,
   2.361389419988610e-15,  -5.465626276586750e-03,   8.610757803572982e-05,   8.021285100858056e-06,  -4.534451200807856e-07,  -3.457519377092511e-09,   1.080431028806141e-09,
  -2.171853819423503e-11,  -1.666334513933568e-12,   8.380216508803154e-14,   1.307401141432599e-15,  -2.072554991261750e-03,   3.264531948596283e-05,   3.041604866713435e-06,
  -1.718916543105975e-07,  -1.312829345620006e-09,   4.095193081705090e-10,  -8.223352939320455e-12,  -6.316309110830113e-13,   3.173263145147674e-14,   4.962781122710561e-16,
  -2.362981982155922e-04,   3.721867591006918e-06,   3.467815094427541e-07,  -1.959686416448669e-08,  -1.497125592815709e-10,   4.668715725230597e-11,  -9.373372060061836e-13,
  -7.200959439989772e-14,   3.617082489227910e-15,   5.659184860202511e-17,  -1.524183153874780e-04,   5.305360180401703e-06,  -9.368373383216404e-08,   4.188842512022931e-11,
   1.092922603634100e-12,   3.020288829003240e-12,  -1.083765997423955e-13,  -2.942974751643242e-15,   2.544195555674412e-16,   9.344045598472496e-20,  -1.409328180877940e-04,
   4.905439278589898e-06,  -8.662154688019914e-08,   4.004704394693959e-11,   9.404289432720926e-13,   2.789904124039980e-12,  -9.989955321972964e-14,  -2.720823552955224e-15,
   2.343735125210920e-16,   1.068828837435474e-19,  -1.197079044666240e-04,   4.166477143208506e-06,  -7.357241761199246e-08,   3.584811671127700e-11,   7.012435407302880e-13,
   2.365845585783906e-12,  -8.442295407109327e-14,  -2.310487631647246e-15,   1.978610285814599e-16,   1.191041829343967e-19,  -9.197207564284277e-05,   3.200968524011903e-06,
  -5.652303084142304e-08,   2.903435665377796e-11,   4.594954660417212e-13,   1.814518103759047e-12,  -6.451214186741669e-14,  -1.774652366372453e-15,   1.510309415866999e-16,
   1.143401470223462e-19,  -6.194692648138767e-05,   2.155901244295951e-06,  -3.806899761322602e-08,   2.034595667468226e-11,   2.675924557461272e-13,   1.220471232822387e-12,
  -4.326648147466678e-14,  -1.195014037155443e-15,   1.012045394038963e-16,   8.899245793298091e-20,  -3.420469875433176e-05,   1.190379562101498e-06,  -2.101973515429101e-08,
   1.148586335873067e-11,   1.344308855429244e-13,   6.733616680891118e-13,  -2.383125014642517e-14,  -6.597451776910579e-16,   5.571567441593113e-17,   5.292861411991427e-20,
  -1.297073574546598e-05,   4.513991867514211e-07,  -7.970806337766466e-09,   4.391361029580108e-12,   4.908219544098048e-14,   2.552686959680080e-13,  -9.028662120537449e-15,
  -2.501675490300060e-16,   2.110435133822289e-17,   2.060882557137534e-20,  -1.478839582001020e-06,   5.146555277927546e-08,  -9.087785730651227e-10,   5.013514729341409e-13,
   5.560228330560467e-15,   2.910264866545255e-14,  -1.029231724708901e-15,  -2.852222539870020e-17,   2.405737166620302e-18,   2.359837935338175e-21,  -1.385270588645741e-03,
   4.796340325378004e-05,  -8.208222046339248e-07,  -1.411268362561229e-09,   5.964832632313480e-11,   2.758181363138379e-11,  -1.022350667846852e-12,  -2.780293772810764e-14,
   2.445974590164978e-15,  -7.224354440764047e-19,  -1.280882022993421e-03,   4.434766084344268e-05,  -7.589328749019249e-07,  -1.292866479703192e-09,   5.449078874453852e-11,
   2.547703440541954e-11,  -9.423282895060950e-13,  -2.570667760269565e-14,   2.253287553540834e-15,  -4.635923861626324e-19,  -1.087975370311117e-03,   3.766674001149899e-05,
  -6.445850034295656e-07,  -1.081360922428781e-09,   4.536254298406439e-11,   2.160337800443712e-11,  -7.962635201853128e-13,  -2.183317202760543e-14,   1.902301113113775e-15,
  -1.111605993263670e-19,  -8.358944042337223e-04,   2.893786065488135e-05,  -4.951965544951984e-07,  -8.171368758731853e-10,   3.410323768055622e-11,   1.656801995996919e-11,
  -6.084044696123512e-13,  -1.677249656146536e-14,   1.452100002553972e-15,   1.424863945000871e-19,  -5.630079917535744e-04,   1.948994987861154e-05,  -3.335134824595480e-07,
  -5.431323508084847e-10,   2.257408688614467e-11,   1.114336366362435e-11,  -4.080060297614452e-13,  -1.129569913462863e-14,   9.730602466637158e-16,   2.155583410720351e-19,
  -3.108709926080035e-04,   1.076131881989935e-05,  -1.841464280168704e-07,  -2.975904314103454e-10,   1.233866691437057e-11,   6.147878044542167e-12,  -2.247196190967964e-13,
  -6.236606287935957e-15,   5.357009434501696e-16,   1.568642832777828e-19,  -1.178850966871525e-04,   4.080751268837009e-06,  -6.982904526036177e-08,  -1.125207376230786e-10,
   4.661030984273293e-12,   2.330611770442647e-12,  -8.513530997448644e-14,  -2.364912431320205e-15,   2.029172706469642e-16,   6.485378637373651e-20,  -1.344049723802363e-05,
   4.652601757086596e-07,  -7.961438759547421e-09,  -1.282268466175984e-11,   5.310823972088548e-13,   2.657077056447333e-13,  -9.705059089354641e-15,  -2.696307896898853e-16,
   2.313105869795689e-17,   7.495574172471335e-21,  -3.928016904597129e-03,   1.343332673318025e-04,  -2.125632902541684e-06,  -1.589771355996856e-08,   5.014044833418485e-10,
   7.926252164539159e-11,  -3.173995041979301e-12,  -8.486480544353740e-14,   7.838823836194101e-15,  -1.431186273868160e-17,  -3.632007954028293e-03,   1.242049243754369e-04,
  -1.965271440843025e-06,  -1.466479057499363e-08,   4.615562085295269e-10,   7.320930462296802e-11,  -2.925259801534631e-12,  -7.848467996409000e-14,   7.221524127523840e-15,
  -1.251961879062432e-17,  -3.084998524774145e-03,   1.054914154157231e-04,  -1.669039369429612e-06,  -1.240753908986509e-08,   3.891726677951101e-10,   6.207166695227616e-11,
  -2.471417445895747e-12,  -6.668407405202877e-14,   6.096959316836813e-15,  -9.647014562200890e-18,  -2.370202449619396e-03,   8.104308112875290e-05,  -1.282121648432992e-06,
  -9.493117257726538e-09,   2.966696959964685e-10,   4.759853047684093e-11,  -1.888007359364352e-12,  -5.124812869435852e-14,   4.654292219477877e-15,  -6.615617521127390e-18,
  -1.596419817844645e-03,   5.458241157143756e-05,  -8.634509608690856e-07,  -6.373007050512615e-09,   1.985860993381912e-10,   3.201109795065823e-11,  -1.265948464876857e-12,
  -3.452471354309656e-14,   3.118997292487835e-15,  -4.037942735794761e-18,  -8.814788572088884e-04,   3.013721753646374e-05,  -4.767292657181550e-07,  -3.512243617816880e-09,
   1.092595095809346e-10,   1.765985324189080e-11,  -6.971954781391803e-13,  -1.906530449263477e-14,   1.717149639483455e-15,  -2.097319080861051e-18,  -3.342645223576931e-04,
   1.142815569043463e-05,  -1.807751370561289e-07,  -1.330923519056906e-09,   4.137644151546382e-11,   6.694580117748866e-12,  -2.641251688203506e-13,  -7.230026032498276e-15,
   6.504421427459987e-16,  -7.765516041974072e-19,  -3.811067698838837e-05,   1.302961652094584e-06,  -2.061072045713280e-08,  -1.517253298189634e-10,   4.716421229586244e-12,
   7.632312736353781e-13,  -3.010897765557553e-14,  -8.243262814011913e-16,   7.414567468313906e-17,  -8.818303023681682e-20,  -7.963289257566378e-03,   2.656674198764847e-04,
  -3.493493340170593e-06,  -8.101624415263096e-08,   2.396065911279516e-09,   1.667634170357158e-10,  -7.815157604663694e-12,  -1.871494209876722e-13,   1.971090889125651e-14,
  -9.711526821033589e-17,  -7.363152445407621e-03,   2.456303438301472e-04,  -3.229528551998796e-06,  -7.483647001656673e-08,   2.210396495251766e-09,   1.540194218941247e-10,
  -7.202209284176772e-12,  -1.731789332389053e-13,   1.815967586574122e-14,  -8.768116032107714e-17,  -6.254152178302060e-03,   2.086130205035052e-04,  -2.742160119390190e-06,
  -6.346168299831065e-08,   1.870392481345124e-09,   1.305759662021260e-10,  -6.084115288170689e-12,  -1.472780723318130e-13,   1.533313152028235e-14,  -7.154851650071995e-17,
  -4.805019922476491e-03,   1.602581669728707e-04,  -2.106006257572644e-06,  -4.867304037739257e-08,   1.431252519563491e-09,   1.001200301009644e-10,  -4.647308091660192e-12,
  -1.132973911449455e-13,   1.170608322515482e-14,  -5.260820793791031e-17,  -3.236338360477866e-03,   1.079297462215462e-04,  -1.418053943465914e-06,  -3.273835133481847e-08,
   9.609536585829394e-10,   6.732775819583625e-11,  -3.115812280861724e-12,  -7.638425972613400e-14,   7.845209511596106e-15,  -3.419284196577344e-17,  -1.786968979831160e-03,
   5.959124728619151e-05,  -7.828587730468804e-07,  -1.806255008911692e-08,   5.296307189121823e-10,   3.714162976593711e-11,  -1.715872934649460e-12,  -4.219954453848507e-14,
   4.319324568466457e-15,  -1.848707476381275e-17,  -6.776333330474380e-04,   2.259706572626628e-05,  -2.968479068383431e-07,  -6.847448997367679e-09,   2.007027504871602e-10,
   1.407958229396434e-11,  -6.500264772252446e-13,  -1.600571445576388e-14,   1.636150192453604e-15,  -6.954703808345682e-18,  -7.725934720293205e-05,   2.576362488421990e-06,
  -3.384431743359728e-08,  -7.806634735870078e-10,   2.288022365292602e-11,   1.605171165181078e-12,  -7.409957635104691e-14,  -1.824929691628332e-15,   1.865097086074046e-16,
  -7.918776203227789e-19,  -1.386415637355454e-02,   4.375491198745648e-04,  -2.952634283535748e-06,  -3.334802907167714e-07,   9.716609507974110e-09,   3.329851279098517e-10,
  -2.154518078167522e-11,  -2.815432863891363e-13,   4.995296856621253e-14,  -6.320061245088842e-16,  -1.281917352229098e-02,   4.045221691449274e-04,  -2.727536053125915e-06,
  -3.081966361455681e-07,   8.970211688257539e-09,   3.076202177288712e-10,  -1.986063005808423e-11,  -2.612617560493560e-13,   4.603032774908471e-14,  -5.770107545887336e-16,
  -1.088822088945141e-02,   3.435226795098991e-04,  -2.313136807837667e-06,  -2.615663971870826e-07,   7.599515545442270e-09,   2.609103323686293e-10,  -1.678471790252109e-11,
  -2.232039582713452e-13,   3.887761453998808e-14,  -4.799046882006184e-16,  -8.365182842691748e-03,   2.638669715551484e-04,  -1.774242921421745e-06,  -2.007875250005051e-07,
   5.822684793477746e-09,   2.001466040499175e-10,  -1.282684853784398e-11,  -1.725252092043133e-13,   2.969068699897384e-14,  -3.604659656718475e-16,  -5.634140648340746e-03,
   1.776917803468283e-04,  -1.193463421121003e-06,  -1.351458575458254e-07,   3.913329067007512e-09,   1.346410598587967e-10,  -8.602989784322220e-12,  -1.167453965180201e-13,
   1.990318415957326e-14,  -2.384528186318383e-16,  -3.110907049377781e-03,   9.810391399277836e-05,  -6.584873894773864e-07,  -7.459280006147899e-08,   2.158090475624402e-09,
   7.429064863588550e-11,  -4.738661242484034e-12,  -6.463371165136210e-14,   1.095965012462155e-14,  -1.302907115816565e-16,  -1.179677719682515e-03,   3.720039270823930e-05,
  -2.496337297222534e-07,  -2.828207228882897e-08,   8.179838346318415e-10,   2.816414969323079e-11,  -1.795297167167044e-12,  -2.453399777187910e-14,   4.151715246545225e-15,
  -4.921238439334502e-17,  -1.344991121274758e-04,   4.241320126157375e-06,  -2.846029024454162e-08,  -3.224459950250655e-09,   9.325398507039803e-11,   3.210951924352711e-12,
  -2.046570871423637e-13,  -2.797666719176222e-15,   4.732708261741300e-16,  -5.607195546548199e-18,  -2.240796905647341e-02,   5.763766220088457e-04,   1.256660152015123e-05,
  -1.673437974053671e-06,   4.854670743530905e-08,   1.321581402178116e-09,  -1.459993423665537e-10,   2.920316176763795e-12,   1.652343417177290e-13,  -1.104851458127553e-14,
  -2.071824052705113e-02,   5.327091125342571e-04,   1.163184548793796e-05,  -1.546703015314877e-06,   4.479189665694743e-08,   1.224565622867052e-09,  -1.347898480085354e-10,
   2.683036110900110e-12,   1.529253952624784e-13,  -1.017593972304712e-14,  -1.759637285204083e-02,   4.521544898396421e-04,   9.897037026936083e-06,  -1.312881059246621e-06,
   3.791161334668596e-08,   1.043710003874759e-09,  -1.142002868957154e-10,   2.255028084972790e-12,   1.300883014145825e-13,  -8.587687101059301e-15,  -1.351803042034636e-02,
   3.471256999363462e-04,   7.617747094304570e-06,  -1.007970156252844e-06,   2.901818975324633e-08,   8.047755019667379e-10,  -8.750411788058249e-11,   1.713114934724828e-12,
   1.001008162187744e-13,  -6.552600709957020e-15,  -9.104234198664138e-03,   2.336620686294923e-04,   5.138168076610909e-06,  -6.785255915441581e-07,   1.948699404395296e-08,
   5.435706933677047e-10,  -5.881216125229262e-11,   1.143590563971445e-12,   6.750103649298511e-14,  -4.389437596845566e-15,  -5.026780592561057e-03,   1.289741881809675e-04,
   2.839422568474108e-06,  -3.745333490256300e-07,   1.074152264601601e-08,   3.006215319129815e-10,  -3.243381892745559e-11,   6.281850190560007e-13,   3.729616328382192e-14,
  -2.416036493514450e-15,  -1.906169202954669e-03,   4.890179261576912e-05,   1.077065887185427e-06,  -1.420090645415981e-07,   4.070659238994654e-09,   1.140670425665876e-10,
  -1.229350699577244e-11,   2.377497145085634e-13,   1.414652903183887e-14,  -9.150957090008893e-16,  -2.173285034445929e-04,   5.575345787068810e-06,   1.228063516590926e-07,
  -1.619062779635367e-08,   4.640606983054929e-10,   1.300648360498189e-11,  -1.401518693214411e-12,   2.709792607090650e-14,   1.612961529982549e-15,  -1.043127574565874e-16,
  -1.326874082544272e-04,   4.561795991362059e-06,  -9.157923964684346e-08,   3.888579353750876e-10,   3.321261274355052e-11,   2.553630382273227e-13,  -9.491208516180140e-14,
   2.852951241641985e-15,   6.804189118178755e-17,  -6.686655623362204e-18,  -1.226891624870636e-04,   4.217969825127809e-06,  -8.466722142404155e-08,   3.596650549916364e-10,
   3.064686420986591e-11,   2.386911160553428e-13,  -8.767287046482297e-14,   2.627475189388271e-15,   6.308287552014508e-17,  -6.163931115104766e-18,  -1.042123942391890e-04,
   3.582630884403158e-06,  -7.190068332473912e-08,   3.056524663427219e-10,   2.594356568506385e-11,   2.063169133947264e-13,  -7.434737499873079e-14,   2.217175912428860e-15,
   5.381464578181611e-17,  -5.209354311013896e-18,  -8.006729593149234e-05,   2.752468738736119e-06,  -5.522906149321113e-08,   2.349610168548159e-10,   1.986105893096351e-11,
   1.614151654729004e-13,  -5.702194668596548e-14,   1.691606209272374e-15,   4.153283056968512e-17,  -3.980969698650486e-18,  -5.392883068977745e-05,   1.853856341603557e-06,
  -3.719238377172267e-08,   1.583237515549806e-10,   1.333937208330661e-11,   1.102515482310620e-13,  -3.835376490329973e-14,   1.133097599092379e-15,   2.807185420347577e-17,
  -2.670010397427417e-18,  -2.977749784849015e-05,   1.023614098818018e-06,  -2.053408617178560e-08,   8.744206281304044e-11,   7.353430358077530e-12,   6.136349538013478e-14,
  -2.116060601750150e-14,   6.236594529755953e-16,   1.553109124672689e-17,  -1.470666698452620e-18,  -1.129191215527904e-05,   3.881619078952482e-07,  -7.786413563663180e-09,
   3.316194848058833e-11,   2.786772243089585e-12,   2.333883352553165e-14,  -8.021893316914765e-15,   2.362138493415143e-16,   5.893912932155665e-18,  -5.571764227599110e-19,
  -1.287431170490928e-06,   4.425567876604761e-08,  -8.877509478473463e-10,   3.780970298444459e-12,   3.176973578531286e-13,   2.662251075552889e-15,  -9.145590851400041e-16,
   2.692622170576412e-17,   6.720685900172065e-19,  -6.351594862033612e-20,  -1.206590988309356e-03,   4.137787296940644e-05,  -8.185061706793622e-07,   2.507523518498278e-09,
   3.449620877218729e-10,   1.591091209947905e-12,  -8.857533289613544e-13,   2.731388880888111e-14,   6.291369445344494e-16,  -6.390422834587468e-17,  -1.115671445547955e-03,
   3.825905523863519e-05,  -7.567161439442554e-07,   2.319275955861248e-09,   3.183784462653339e-10,   1.495832484224063e-12,  -8.182008286633059e-13,   2.515535616453163e-14,
   5.834303067252631e-16,  -5.891148420352550e-17,  -9.476524266046963e-04,   3.249603144800910e-05,  -6.425972135306982e-07,   1.970984534006468e-09,   2.696090635903748e-10,
   1.304800279553443e-12,  -6.938503686147432e-13,   2.122737483555937e-14,   4.979137285580954e-16,  -4.979221089632012e-17,  -7.280889343906173e-04,   2.496594387221568e-05,
  -4.935837907765779e-07,   1.515142774733393e-09,   2.064734798705919e-10,   1.030284892645601e-12,  -5.321669661355089e-13,   1.619570495706429e-14,   3.844403185865662e-16,
  -3.805430559854813e-17,  -4.903993990915960e-04,   1.681510457777906e-05,  -3.323818724857681e-07,   1.020955055908852e-09,   1.387143819406078e-10,   7.086193136108513e-13,
  -3.579466065006836e-13,   1.084854090423598e-14,   2.599267382589581e-16,  -2.552450218904000e-17,  -2.707802152458069e-04,   9.284500484766995e-06,  -1.835071444393306e-07,
   5.638751054001478e-10,   7.648002720398448e-11,   3.959379112528481e-13,  -1.974880550373116e-13,   5.971087940709125e-15,   1.438345399309823e-16,  -1.405968317275407e-17,
  -1.026824313783115e-04,   3.520746393148343e-06,  -6.958456499394696e-08,   2.138471052805476e-10,   2.898588670042061e-11,   1.508067810222606e-13,  -7.486701853246782e-14,
   2.261580443379790e-15,   5.458776647010087e-17,  -5.326726112755281e-18,  -1.170718982233396e-05,   4.014123775742665e-07,  -7.933525800549297e-09,   2.438185470568296e-11,
   3.304480594992103e-12,   1.720655012569468e-14,  -8.535433391992944e-15,   2.577995888238644e-16,   6.224582638035676e-18,  -6.072275665384057e-19,  -3.425587239879818e-03,
   1.167930288318402e-04,  -2.230419484038182e-06,   3.335389234397909e-10,   1.265904750730344e-09,  -4.750230550341055e-13,  -2.666756416665935e-12,   8.724654843330382e-14,
   1.827749992114198e-15,  -2.020716989921000e-16,  -3.167456768218415e-03,   1.079889740569873e-04,  -2.061957052780626e-06,   3.084332984803249e-10,   1.168732668710319e-09,
  -3.603638940276166e-13,  -2.463450678266789e-12,   8.035475010013796e-14,   1.696098063262079e-15,  -1.863063594584156e-16,  -2.690435035143453e-03,   9.172117557455186e-05,
  -1.750878238496419e-06,   2.620621970935847e-10,   9.902383010515566e-10,  -1.964746132818553e-13,  -2.089159264182875e-12,   6.781163161828510e-14,   1.449058730415557e-15,
  -1.574976377511811e-16,  -2.067077955339343e-03,   7.046622828766770e-05,  -1.344765898690173e-06,   2.014508067348368e-10,   7.587847749133772e-10,  -6.195574797878326e-14,
  -1.602420248565882e-12,   5.174115957489832e-14,   1.120083613198142e-15,  -1.203944157866087e-16,  -1.392263898121357e-03,   4.745999515642103e-05,  -9.055209251351680e-07,
   1.357627207728330e-10,   5.100029373917029e-10,   5.267016235896025e-15,  -1.077865242229225e-12,   3.466010974397095e-14,   7.579690562593566e-16,  -8.076634710212266e-17,
  -7.687552668741308e-04,   2.620497925711284e-05,  -4.999193183925097e-07,   7.499213223361358e-11,   2.812633576792377e-10,   1.784491696544689e-14,  -5.946989598933341e-13,
   1.907765199675136e-14,   4.196429709718762e-16,  -4.449276486812866e-17,  -2.915191888625754e-04,   9.937083829687597e-06,  -1.895634132876127e-07,   2.844218793485109e-11,
   1.066091695080102e-10,   8.891066707351830e-15,  -2.254502237904477e-13,   7.225839614276359e-15,   1.592915830571898e-16,  -1.685735761752079e-17,  -3.323713912132745e-05,
   1.132960564890547e-06,  -2.161259707060647e-08,   3.242881390122018e-12,   1.215397339909420e-11,   1.053829430383013e-15,  -2.570314916991846e-14,   8.236814724571769e-16,
   1.816440179055964e-17,  -1.921689173951718e-18,  -6.961506846515500e-03,   2.346656837019872e-04,  -4.160634090634609e-06,  -2.680153603796352e-08,   3.759545521025402e-09,
  -2.259925113495816e-11,  -6.056557142659797e-12,   2.224335597130907e-13,   3.625346946878434e-15,  -4.948013715350196e-16,  -6.436915179455040e-03,   2.169725572772873e-04,
  -3.846017373307843e-06,  -2.479046660382492e-08,   3.472176408591036e-09,  -2.069449666292077e-11,  -5.595441879575086e-12,   2.048938987779273e-13,   3.370551431031860e-15,
  -4.563162007665548e-16,  -5.467486767362092e-03,   1.842820623438260e-04,  -3.265274424089491e-06,  -2.106878247982925e-08,   2.943587339761898e-09,  -1.729733224236688e-11,
  -4.746139741145428e-12,   1.729534985500592e-13,   2.888378723280975e-15,  -3.859197814449962e-16,  -4.200684957694402e-03,   1.415734458524024e-04,  -2.507485257323798e-06,
  -1.619677259562141e-08,   2.256953275558922e-09,  -1.306183263678264e-11,  -3.641061963442792e-12,   1.320006255537259e-13,   2.239681867647584e-15,  -2.951378253253218e-16,
  -2.829327774572779e-03,   9.534951467703235e-05,  -1.688237285326448e-06,  -1.091418807639809e-08,   1.517704371141611e-09,  -8.677372115723040e-12,  -2.449518731239399e-12,
   8.844235908305440e-14,   1.519295016710982e-15,  -1.980625977261155e-16,  -1.562244150776959e-03,   5.264642156453393e-05,  -9.319705494581883e-07,  -6.027975843335077e-09,
   8.372389439705420e-10,  -4.753070526528872e-12,  -1.351607593304599e-12,   4.868640311293169e-14,   8.423078411110991e-16,  -1.091314334685811e-16,  -5.924171366042189e-04,
   1.996373640509466e-05,  -3.533820608200629e-07,  -2.286088348975554e-09,   3.173778339644115e-10,  -1.796969802342020e-12,  -5.124105143431565e-13,   1.844126802901946e-14,
   3.198950697275833e-16,  -4.135072660754206e-17,  -6.754357518958777e-05,   2.276131286105136e-06,  -4.028978024935757e-08,  -2.606492794170607e-10,   3.618327744125284e-11,
  -2.047761636448598e-13,  -5.841925361947659e-14,   2.102156405310106e-15,   3.648151273984705e-17,  -4.713920860919685e-18,  -1.218238019530734e-02,   4.008859632544662e-04,
  -5.893258840756534e-06,  -1.526922006415779e-07,   1.135360827401573e-08,  -1.341251670804968e-10,  -1.323416186886885e-11,   6.154066862624345e-13,   3.379189364072564e-15,
  -1.171853221276204e-15,  -1.126430141233252e-02,   3.706461530101405e-04,  -5.446046518156157e-06,  -1.412390376384673e-07,   1.048906088665709e-08,  -1.234564998761436e-10,
  -1.223202155288076e-11,   5.671813570366652e-13,   3.188483026097110e-15,  -1.081491285969187e-15,  -9.567759384540461e-03,   3.147824639003519e-04,  -4.621500435580426e-06,
  -1.200415795493042e-07,   8.896838011035787e-09,  -1.040824608018905e-10,  -1.038294721290229e-11,   4.791847019248120e-13,   2.796881883370134e-15,  -9.157344977093591e-16,
  -7.350864162037946e-03,   2.418134029053323e-04,  -3.547170822725155e-06,  -9.228811275621423e-08,   6.825260750679268e-09,  -7.933235280508340e-11,  -7.971545487014327e-12,
   3.660626757683046e-13,   2.220502445892510e-15,  -7.012007685103603e-16,  -4.951060418569827e-03,   1.628524500691771e-04,  -2.387284916924037e-06,  -6.219127305436344e-08,
   4.591677085917762e-09,  -5.309820527960459e-11,  -5.366083689147665e-12,   2.454486388239420e-13,   1.533295971318728e-15,  -4.710288649271322e-16,  -2.733769865271382e-03,
   8.991487185105029e-05,  -1.317568165643944e-06,  -3.434961700593044e-08,   2.533622229951473e-09,  -2.921214380750118e-11,  -2.961953736702993e-12,   1.351741815597051e-13,
   8.585775320310201e-16,  -2.596815619587613e-16,  -1.036668581881852e-03,   3.409569641840445e-05,  -4.995487708756544e-07,  -1.302711162282113e-08,   9.605272967546216e-10,
  -1.106234549556418e-11,  -1.123058305475943e-12,   5.120904762343646e-14,   3.272777921763012e-16,  -9.841623604997939e-17,  -1.181942228186563e-04,   3.887355232742948e-06,
  -5.695371742751190e-08,  -1.485294047899824e-09,   1.095084837893832e-10,  -1.260970683696851e-12,  -1.280411770792937e-13,   5.837575770646795e-15,   3.734615319217630e-17,
  -1.121969875424195e-17,  -2.000864331627583e-02,   6.107276430889633e-04,  -2.506191387099655e-06,  -8.413374695774056e-07,   4.825796478608825e-08,  -9.232085577807813e-10,
  -3.991450212516038e-11,   3.353862114791969e-12,  -8.039724368954334e-14,  -1.950031282069491e-15,  -1.850044187001423e-02,   5.645782682411815e-04,  -2.304635749424897e-06,
  -7.783110614373733e-07,   4.459354635369350e-08,  -8.505413731670474e-10,  -3.700203172230131e-11,   3.097864402916918e-12,  -7.393086544820962e-14,  -1.815826111912311e-15,
  -1.571359321435126e-02,   4.793726156424229e-04,  -1.939849411816019e-06,  -6.616130372718352e-07,   3.783859788084779e-08,  -7.181302295007676e-10,  -3.156168487500230e-11,
   2.626737605674277e-12,  -6.222841566399204e-14,  -1.560003380595954e-15,  -1.207230777248871e-02,   3.681584377365190e-04,  -1.475974120284603e-06,  -5.087405967071838e-07,
   2.903966294485561e-08,  -5.482271445216100e-10,  -2.435617541261639e-11,   2.014376306869565e-12,  -4.734788326257640e-14,  -1.212819528368002e-15,  -8.130918404589812e-03,
   2.478924948174816e-04,  -9.864896919159372e-07,  -3.428795481908599e-07,   1.954245294397541e-08,  -3.673918668484662e-10,  -1.646139250355215e-11,   1.354761010778485e-12,
  -3.164596063541043e-14,  -8.243834597206391e-16,  -4.489492500549063e-03,   1.368520628364341e-04,  -5.422683995833257e-07,  -1.893954270484528e-07,   1.078518153249507e-08,
  -2.022668850324841e-10,  -9.107287706395590e-12,   7.474057510353445e-13,  -1.739576541590087e-14,  -4.575694856945472e-16,  -1.702444457742219e-03,   5.189205617643764e-05,
  -2.052867716424324e-07,  -7.183052327004821e-08,   4.089069512381263e-09,  -7.661709206252445e-11,  -3.456117260841892e-12,   2.833316722912643e-13,  -6.585545776955260e-15,
  -1.738520480834726e-16,  -1.941014975423666e-04,   5.916331162756885e-06,  -2.339892692422332e-08,  -8.189842346632350e-09,   4.661947545699312e-10,  -8.733792082736736e-12,
  -3.940923530540004e-13,   3.230191933242840e-14,  -7.506319069363592e-16,  -1.982786136334433e-17,  -1.158635110023251e-04,   3.856589095589550e-06,  -8.387756829880333e-08,
   8.664333985453254e-10,   2.246845428081133e-11,  -1.004025263437013e-12,  -1.328756894348922e-14,   2.260416473554475e-15,  -6.788091990028732e-17,  -7.382519279777442e-19,
  -1.071331514165124e-04,   3.565984643120816e-06,  -7.754881427851858e-08,   8.006859716932073e-10,   2.076567580102650e-11,  -9.262637122705978e-13,  -1.236787649369935e-14,
   2.088794313884691e-15,  -6.252199397849231e-17,  -6.906676692184951e-19,  -9.099933309906125e-05,   3.028949208390348e-06,  -6.585836273395273e-08,   6.794637458614406e-10,
   1.762476073149551e-11,  -7.838345379913890e-13,  -1.061864983760730e-14,   1.772404340169189e-15,  -5.276645762733196e-17,  -5.978103923107627e-19,  -6.991578299067105e-05,
   2.327164476306682e-06,  -5.058999181304100e-08,   5.215171072695031e-10,   1.353007234106249e-11,  -5.998355462218753e-13,  -8.250432084522266e-15,   1.360253661180862e-15,
  -4.026426916300291e-17,  -4.683338070647553e-19,  -4.709144694089167e-05,   1.567445187722567e-06,  -3.406950694033979e-08,   3.509891047081219e-10,   9.107135408444035e-12,
  -4.027487252736838e-13,  -5.605626251593460e-15,   9.153877775866196e-16,  -2.697328319765117e-17,  -3.201992897058338e-19,  -2.600218183962870e-05,   8.654843829658472e-07,
  -1.881030206460158e-08,   1.937154846776372e-10,   5.026715521876547e-12,  -2.219794013202184e-13,  -3.110664517307882e-15,   5.051857261043057e-16,  -1.484701407920574e-17,
  -1.783108294060175e-19,  -9.860280953414891e-06,   3.281998680008164e-07,  -7.132816676042951e-09,   7.344629146684263e-11,   1.905906655365195e-12,  -8.411927117600008e-14,
  -1.181790268178222e-15,   1.915344894670285e-16,  -5.623492683682683e-18,  -6.783151034209340e-20,  -1.124205882068571e-06,   3.741923551904423e-08,  -8.132335196303318e-10,
   8.373637892301581e-12,   2.172940708468181e-13,  -9.589652527414945e-15,  -1.347816177557906e-16,   2.183683445132931e-17,  -6.410290339400024e-19,  -7.737760254668638e-21,
  -1.053857149060782e-03,   3.504030155981842e-05,  -7.572344738609327e-07,   7.403583840414597e-09,   2.301611302411388e-10,  -9.983423678864603e-12,  -1.119134579933645e-13,
   2.121224643527817e-14,  -6.516519271191806e-16,  -6.461602488654125e-18,  -9.744483528126031e-04,   3.239985736603627e-05,  -7.000922021052650e-07,   6.841168462887830e-09,
   2.127344265970326e-10,  -9.211367035909153e-12,  -1.042641158149171e-13,   1.960242003420158e-14,  -6.002398169412274e-16,  -6.053151235483281e-18,  -8.277000187262349e-04,
   2.752036862025409e-05,  -5.945435490402419e-07,   5.804578811473981e-09,   1.805797882316292e-10,  -7.796574963090784e-12,  -8.965128590232950e-14,   1.663422900038528e-14,
  -5.066283581838143e-16,  -5.250357573011413e-18,  -6.359306822700375e-04,   2.114403533601467e-05,  -4.566984754251068e-07,   4.454566146816466e-09,   1.386448530250637e-10,
  -5.967710905796168e-12,  -6.976419742079857e-14,   1.276694741601079e-14,  -3.866282422493898e-16,  -4.121985731234877e-18,  -4.283279644635134e-04,   1.424137790698960e-05,
  -3.075563291105013e-07,   2.997624857352466e-09,   9.333209384083287e-11,  -4.007613462478006e-12,  -4.745625965812750e-14,   8.591987865913614e-15,  -2.590245508266978e-16,
  -2.822737021920567e-18,  -2.365070514120028e-04,   7.863542176364237e-06,  -1.698052250535613e-07,   1.654311409267142e-09,   5.151810630373181e-11,  -2.209064549741144e-12,
  -2.635201894147867e-14,   4.741894799631267e-15,  -1.425822795501182e-16,  -1.573330888345860e-18,  -8.968577342608989e-05,   2.981927894245087e-06,  -6.438949405208594e-08,
   6.272075274840107e-10,   1.953381736178484e-11,  -8.371587419707270e-13,  -1.001404666372753e-14,   1.797845810493044e-15,  -5.400572904093996e-17,  -5.987135742464346e-19,
  -1.022539552081964e-05,   3.399801841557721e-07,  -7.341232878731760e-09,   7.150783905245175e-11,   2.227075889599346e-12,  -9.543725457404350e-14,  -1.142135947321581e-15,
   2.049726422144722e-16,  -6.156198347377768e-18,  -6.830096838909604e-20,  -2.993614498485776e-03,   9.929103617952153e-05,  -2.114077295572274e-06,   1.790943228268042e-08,
   8.241965820848470e-10,  -3.407274987142863e-11,  -2.538005907408976e-13,   6.453477856533584e-14,  -2.087827365280533e-15,  -1.606243068007907e-17,  -2.768042084275858e-03,
   9.180860161417361e-05,  -1.954497342302088e-06,   1.654462297859179e-08,   7.618901743099136e-10,  -3.144496767626861e-11,  -2.371913359394710e-13,   5.964266626233645e-14,
  -1.923371156824979e-15,  -1.511139731714949e-17,  -2.351182783892777e-03,   7.798145686264469e-05,  -1.659762847918478e-06,   1.403173063965402e-08,   6.468677690757363e-10,
  -2.662531588099741e-11,  -2.049672193510711e-13,   5.061925928024045e-14,  -1.623774383039731e-15,  -1.319541161165037e-17,  -1.806436689194245e-03,   5.991307369653789e-05,
  -1.274891941927553e-06,   1.076337007046287e-08,   4.967613678714912e-10,  -2.038794660614223e-11,  -1.603174423122203e-13,   3.885703146175781e-14,  -1.239464710865571e-15,
  -1.042955074429848e-17,  -1.216715474115324e-03,   4.035367380430360e-05,  -8.585268338532513e-07,   7.240430749141204e-09,   3.344661540784129e-10,  -1.369587552600136e-11,
  -1.094804819748309e-13,   2.615354828602574e-14,  -8.305467362914126e-16,  -7.178304118155544e-18,  -6.718255023818631e-04,   2.228167086278343e-05,  -4.739928830216160e-07,
   3.994978433213203e-09,   1.846399383194213e-10,  -7.550791067007380e-12,  -6.092774733714281e-14,   1.443511299941188e-14,  -4.572318804565856e-16,  -4.012318501261701e-18,
  -2.547627162636604e-04,   8.449404383127141e-06,  -1.797349834516293e-07,   1.514518722602377e-09,   7.001154126865216e-11,  -2.861686042144548e-12,  -2.317217828845009e-14,
   5.473088300683973e-15,  -1.731923736340312e-16,  -1.528433346136431e-18,  -2.904640680137765e-05,   9.633463746598067e-07,  -2.049208172848095e-08,   1.726678322568600e-10,
   7.982157836301291e-12,  -3.262399200545004e-13,  -2.643223413402642e-15,   6.239903265380193e-16,  -1.974260777071346e-17,  -1.743929032821813e-19,  -6.090104218526521e-03,
   2.010419070566721e-04,  -4.155876837829155e-06,   2.401210614046746e-08,   2.368306487952599e-09,  -9.325756941139414e-11,  -2.137015577769182e-13,   1.483311127853198e-13,
  -5.297032345135015e-15,  -1.782580362197495e-17,  -5.631200993526018e-03,   1.858900357843739e-04,  -3.841975460106816e-06,   2.216154674006188e-08,   2.189613183459566e-09,
  -8.609116311342407e-11,  -2.040012034501028e-13,   1.371161966997000e-13,  -4.881237855443319e-15,  -1.717050231288200e-17,  -4.783148819562470e-03,   1.578911608905029e-04,
  -3.262337627315010e-06,   1.876668054979483e-08,   1.859526000895588e-09,  -7.293183930798621e-11,  -1.821818239784447e-13,   1.164126372233093e-13,  -4.122919868340552e-15,
  -1.553963530416869e-17,  -3.674932390399323e-03,   1.213057592699424e-04,  -2.505632309295059e-06,   1.437190929946731e-08,   1.428411587205509e-09,  -5.587595574606951e-11,
  -1.472037553660887e-13,   8.939541538026101e-14,  -3.148762015167717e-15,  -1.271332695148790e-17,  -2.475226447537560e-03,   8.170293511469623e-05,  -1.687202468824511e-06,
   9.655396640639878e-09,   9.619476167863867e-10,  -3.755106643627364e-11,  -1.029689675583320e-13,   6.018700009448926e-14,  -2.110808467443333e-15,  -8.971147435439073e-18,
  -1.366727663548317e-03,   4.511275065284243e-05,  -9.314669723261591e-07,   5.323484732645792e-09,   5.311033552404058e-10,  -2.070759547851372e-11,  -5.807038059695357e-14,
   3.322500480218170e-14,  -1.162317972843090e-15,  -5.083122731898028e-18,  -5.182761423201543e-04,   1.710710466250223e-05,  -3.532007456909740e-07,   2.017596768811123e-09,
   2.013925433746976e-10,  -7.848715574809563e-12,  -2.219361812057330e-14,   1.259808734440951e-14,  -4.403076382263839e-16,  -1.945987417480324e-18,  -5.909050982676774e-05,
   1.950440452378416e-06,  -4.026929011196604e-08,   2.300122463290929e-10,   2.296135077218533e-11,  -8.947881826442936e-13,  -2.533637654341534e-15,   1.436331020025477e-15,
  -5.019245540057388e-17,  -2.222168588595584e-19,  -1.068074848238314e-02,   3.492114012456002e-04,  -6.764398426316535e-06,  -4.075145430108553e-09,   6.824528727499335e-09,
  -2.618112997626370e-10,   1.140294388748456e-12,   3.221725932816568e-13,  -1.404425428221317e-14,   7.613628560580521e-17,  -9.875905724885536e-03,   3.228863709250535e-04,
  -6.252686529036989e-06,  -3.881856465754294e-09,   6.310765682538436e-09,  -2.417781856492258e-10,   1.037291150148358e-12,   2.979923005844839e-13,  -1.295099773140575e-14,
   6.850603299434763e-17,  -8.388572521974964e-03,   2.742444969549454e-04,  -5.308251897854769e-06,  -3.455745688366242e-09,   5.361028947180446e-09,  -2.049412589949583e-10,
   8.573131463303481e-13,   2.532455462366714e-13,  -1.095176743929037e-14,   5.555780540261077e-17,  -6.444981551188220e-03,   2.106915832018724e-04,  -4.076101029342743e-06,
  -2.784108964969725e-09,   4.119444244646887e-09,  -1.571111618812881e-10,   6.393634121744035e-13,   1.946733566618902e-13,  -8.374493329338469e-15,   4.054943260785749e-17,
  -4.340960238097507e-03,   1.419031807954697e-04,  -2.744226446466644e-06,  -1.943529063695554e-09,   2.774894341819406e-09,  -1.056372760344038e-10,   4.204262172031785e-13,
   1.311736186635514e-13,  -5.619449933456035e-15,   2.618391886845846e-17,  -2.396911594700559e-03,   7.835148962127165e-05,  -1.514875606425696e-06,  -1.094893307217493e-09,
   1.532277599220376e-09,  -5.827034892846389e-11,   2.288951902205044e-13,   7.244556340831793e-14,  -3.096112023269681e-15,   1.409934564297721e-17,  -9.089310369002373e-04,
   2.971132446422117e-05,  -5.744005991395529e-07,  -4.182896015884252e-10,   5.810661812556914e-10,  -2.208832439663500e-11,   8.633709042066541e-14,   2.747435252118580e-14,
  -1.173115358953254e-15,   5.295635954199332e-18,  -1.036304539491139e-04,   3.387488185553142e-06,  -6.548842622964914e-08,  -4.774918537361707e-11,   6.624965068880984e-11,
  -2.518210824396161e-12,   9.834867656465525e-15,   3.132492229478268e-15,  -1.337329212791324e-16,   6.028114439058299e-19,  -1.765335217372225e-02,   5.618144812323467e-04,
  -8.673610804059068e-06,  -2.426415051793037e-07,   2.621150689246089e-08,  -1.064949289073597e-09,   1.597799180418995e-11,   7.724929426344772e-13,  -5.981948759545810e-14,
   1.713501177658112e-15,  -1.632297637383524e-02,   5.194309237763941e-04,  -8.012853103855556e-06,  -2.248155170296259e-07,   2.424585599014676e-08,  -9.839469725047462e-10,
   1.470012454036929e-11,   7.169217537435366e-13,  -5.530202864722987e-14,   1.578526326912708e-15,  -1.386453844870462e-02,   4.411360775481254e-04,  -6.796110837589468e-06,
  -1.915962218078049e-07,   2.060757181169899e-08,  -8.347087937697206e-10,   1.238329329657595e-11,   6.126212446338290e-13,  -4.695908500926570e-14,   1.332620416683798e-15,
  -1.065206113156458e-02,   3.388720058701482e-04,  -5.213339813989968e-06,  -1.477243236733269e-07,   1.584359495699762e-08,  -6.404490341459483e-10,   9.430233249992703e-12,
   4.736595823039040e-13,  -3.606649509539200e-14,   1.017180494733954e-15,  -7.174531359377347e-03,   2.282150448544803e-04,  -3.507079908952307e-06,  -9.977383141769771e-08,
   1.067695308449536e-08,  -4.309105104390903e-10,   6.307182153062087e-12,   3.206029097231239e-13,  -2.428534746007450e-14,   6.815667452421222e-16,  -3.961478437577948e-03,
   1.260022768419979e-04,  -1.935098351048528e-06,  -5.517899694871421e-08,   5.897194291147227e-09,  -2.377858960223095e-10,   3.468416303653079e-12,   1.775248191766125e-13,
  -1.340715440384690e-14,   3.752036193700048e-16,  -1.502226064458381e-03,   4.777990212316741e-05,  -7.336111527777765e-07,  -2.093687295928764e-08,   2.236525112334967e-09,
  -9.014974864239689e-11,   1.313238313856537e-12,   6.739018800080399e-14,  -5.083786438749595e-15,   1.421194822284468e-16,  -1.712740658717252e-04,   5.447531178268837e-06,
  -8.363790662775641e-08,  -2.387323184179755e-09,   2.549989743996550e-10,  -1.027789844241506e-11,   1.496888388599456e-13,   7.684738410361353e-15,  -5.796142592018806e-16,
   1.620049951612839e-17,  -1.017067641267591e-04,   3.231718743633766e-06,  -7.199414013185862e-08,   1.065019344004583e-09,   3.052080652422509e-12,  -8.070005524575553e-13,
   2.062684044026795e-14,   3.157066608243636e-16,  -4.169509350748645e-17,   1.341844873176789e-18,  -9.404305550670339e-05,   2.988244590398467e-06,  -6.656623757100003e-08,
   9.843829841074616e-10,   2.835379666840137e-12,  -7.458663955196124e-13,   1.902071793017093e-14,   2.939987071008565e-16,  -3.855636609606754e-17,   1.237042323610352e-18,
  -7.988046175147293e-05,   2.538278725882524e-06,  -5.653728239860981e-08,   8.355998175987313e-10,   2.426851373162903e-12,  -6.330846179634667e-13,   1.608393031761895e-14,
   2.526178574110924e-16,  -3.275371162902683e-17,   1.045591549199418e-18,  -6.137295871083478e-05,   1.950229368670642e-06,  -4.343466280931475e-08,   6.415612268403924e-10,
   1.879588767542033e-12,  -4.860306806712462e-13,   1.229848380339762e-14,   1.964409857523344e-16,  -2.516767256409168e-17,   7.991287448950974e-19,  -4.133742880243144e-05,
   1.313590091529280e-06,  -2.925332951699210e-08,   4.318878172740548e-10,   1.273924598759925e-12,  -3.271636820541455e-13,   8.252325120393593e-15,   1.335549540325604e-16,
  -1.695275052506028e-17,   5.360143551882390e-19,  -2.282501019128875e-05,   7.253236955494446e-07,  -1.615202252096993e-08,   2.383985838505850e-10,   7.059390920231607e-13,
  -1.805838865888648e-13,   4.546671970890319e-15,   7.413948599142477e-17,  -9.361020827980329e-18,   2.952547067000930e-19,  -8.655464712769235e-06,   2.750508286990895e-07,
  -6.124918922363836e-09,   9.039251272829231e-11,   2.680581066528682e-13,  -6.847004215270380e-14,   1.722723906391116e-15,   2.817064819368225e-17,  -3.549833904423398e-18,
   1.118619025669224e-19,  -9.868404419081138e-07,   3.135954736021457e-08,  -6.983222859779612e-10,   1.030577405047559e-11,   3.056904811796053e-14,  -7.806341648691035e-15,
   1.963871036628483e-16,   3.212898711180056e-18,  -4.047300559447072e-19,   1.275185567893212e-20,  -9.251808256101992e-04,   2.938510756213789e-05,  -6.529088142918530e-07,
   9.502243382954719e-09,   3.958671590634374e-11,  -7.864763881594745e-12,   2.023491141185239e-13,   2.757734624732287e-15,  -3.910159299859011e-16,   1.283152448585801e-17,
  -8.554674129810343e-04,   2.717124136566694e-05,  -6.036804632342470e-07,   8.782503478607915e-09,   3.673384409824665e-11,  -7.269266000895928e-12,   1.866150791540262e-13,
   2.569849854999338e-15,  -3.616014507429192e-16,   1.183022333831021e-17,  -7.266365339620381e-04,   2.307979827391538e-05,  -5.127247793799012e-07,   7.454677658459537e-09,
   3.138276138047488e-11,  -6.170499732200651e-12,   1.578325687725651e-13,   2.210539217833016e-15,  -3.072096117443135e-16,   1.000055026075917e-17,  -5.582820210431541e-04,
   1.773281615301337e-05,  -3.938962691931930e-07,   5.723259804923822e-09,   2.425877155182799e-11,  -4.737543065442828e-12,   1.207109035288230e-13,   1.720892090085164e-15,
  -2.360803436022722e-16,   7.644262009381316e-18,  -3.760278202046471e-04,   1.194404271228874e-05,  -2.652879924790078e-07,   3.852622560380525e-09,   1.641713101101402e-11,
  -3.189179449160852e-12,   8.101081189809771e-14,   1.170997083898729e-15,  -1.590341040243264e-16,   5.127908561775238e-18,  -2.076287360812434e-04,   6.595125136434627e-06,
  -1.464763125001065e-07,   2.126560389523382e-09,   9.089673359228583e-12,  -1.760382168760636e-12,   4.463770745386975e-14,   6.503659287046320e-16,  -8.781980920056200e-17,
   2.824793822745089e-18,  -7.873482315068647e-05,   2.500944281976261e-06,  -5.554438384331370e-08,   8.063102904852133e-10,   3.450411305628225e-12,  -6.674732381316435e-13,
   1.691373813466797e-14,   2.471633885894473e-16,  -3.330308798148414e-17,   1.070241859577977e-18,  -8.976838313888947e-06,   2.851417592492147e-07,  -6.332797472191342e-09,
   9.192838831320660e-11,   3.934602068231019e-13,  -7.609948106565073e-14,   1.928144089460148e-15,   2.819015153592152e-17,  -3.797022063749782e-18,   1.220041902467629e-19,
  -2.628665909286114e-03,   8.341081056423150e-05,  -1.842248493884667e-06,   2.579352217289827e-08,   1.897550002535657e-10,  -2.580816244729252e-11,   6.741879913272917e-13,
   6.967646121768652e-15,  -1.186354996734438e-15,   4.069140841887950e-17,  -2.430592392637136e-03,   7.712650416669775e-05,  -1.703324996116980e-06,   2.383785496001279e-08,
   1.758887513655028e-10,  -2.385596850660538e-11,   6.219074601020394e-13,   6.505881395500895e-15,  -1.097260182797201e-15,   3.752261297346133e-17,  -2.064551491744012e-03,
   6.551258140957594e-05,  -1.446658525346363e-06,   2.023108162701655e-08,   1.500016200195833e-10,  -2.025277534389129e-11,   5.261864057786605e-13,   5.614119564105476e-15,
  -9.324191943170104e-16,   3.172843705583800e-17,  -1.586214612678066e-03,   5.033485955359735e-05,  -1.111359016592899e-06,   1.552999829180583e-08,   1.157365889732879e-10,
  -1.555173166958801e-11,   4.025916102984109e-13,   4.384918727714947e-15,  -7.167021263139563e-16,   2.426013503117231e-17,  -1.068385870231827e-03,   3.390324538068416e-05,
  -7.484845584590017e-07,   1.045286449912044e-08,   7.821227699362630e-11,  -1.047015092100357e-11,   2.702713509698857e-13,   2.991255540703391e-15,  -4.828913997408623e-16,
   1.627807079272031e-17,  -5.899232794228308e-04,   1.872027646563690e-05,  -4.132648407436575e-07,   5.769367696266204e-09,   4.326819135401295e-11,  -5.779748205272729e-12,
   1.489496153054113e-13,   1.663689708891564e-15,  -2.666846025337498e-16,   8.968301488634863e-18,  -2.237045919998339e-04,   7.098931221701221e-06,  -1.567110567787464e-07,
   2.187469701875586e-09,   1.641941842059789e-11,  -2.191524484983474e-12,   5.644265006714066e-14,   6.325983958022389e-16,  -1.011363560279855e-16,   3.398038048915934e-18,
  -2.550535897372424e-05,   8.093749015665892e-07,  -1.786713109594629e-08,   2.493949893248691e-10,   1.872257625201985e-12,  -2.498595236427767e-13,   6.434462942653821e-15,
   7.215713231541272e-17,  -1.153104831446935e-17,   3.873689819500848e-19,  -5.349878522327290e-03,   1.694537314338184e-04,  -3.699778115951296e-06,   4.778283000347629e-08,
   6.932156466392393e-10,  -6.658866252430267e-11,   1.791578208938195e-12,   9.703740186754367e-15,  -2.700724365499267e-15,   1.007712491905867e-16,  -4.946755675381963e-03,
   1.566861914639767e-04,  -3.420695926484471e-06,   4.415168654161718e-08,   6.421253678046299e-10,  -6.155938041256862e-11,   1.653200048166551e-12,   9.129683104675017e-15,
  -2.498629360464188e-15,   9.295608588173441e-17,  -4.201783915659191e-03,   1.330910854708471e-04,  -2.905130853229262e-06,   3.745983712577835e-08,   5.470160587085419e-10,
  -5.227216110869227e-11,   1.399517116635219e-12,   7.973451631106067e-15,  -2.124274370515854e-15,   7.864694288698775e-17,  -3.228268062685287e-03,   1.022563100178581e-04,
  -2.231699345920964e-06,   2.874593311678973e-08,   4.215735310316299e-10,  -4.014754133160693e-11,   1.071416570879308e-12,   6.303894783529684e-15,  -1.633642484949790e-15,
   6.017153071947438e-17,  -2.174380284128976e-03,   6.887477063486764e-05,  -1.502967847948534e-06,   1.934320923824872e-08,   2.846339791845796e-10,  -2.703382228388712e-11,
   7.196071622220442e-13,   4.339986993525651e-15,  -1.101132125552124e-15,   4.039335168092455e-17,  -1.200612166697837e-03,   3.803030303089915e-05,  -8.298258320763966e-07,
   1.067472815088689e-08,   1.573825248077493e-10,  -1.492472583894777e-11,   3.966904760250124e-13,   2.426296772648771e-15,  -6.082564156719730e-16,   2.226066677042209e-17,
  -4.552836394637970e-04,   1.442148503003721e-05,  -3.146697484716677e-07,   4.047122744851046e-09,   5.971200978438882e-11,  -5.659263291402649e-12,   1.503362713813562e-13,
   9.243315210631312e-16,  -2.306923046307906e-16,   8.435322865767408e-18,  -5.190851152689299e-05,   1.644245503634862e-06,  -3.587646608286613e-08,   4.614110901112337e-10,
   6.808565857744524e-12,  -6.452264377238119e-13,   1.713862510308872e-14,   1.054667579218308e-16,  -2.630272452654962e-17,   9.616252558330867e-19,  -9.390320435990158e-03,
   2.963803245268663e-04,  -6.319801401474016e-06,   6.693489700838551e-08,   2.353397589138467e-09,  -1.711818668999762e-10,   4.887260425238321e-12,  -7.850726381904215e-15,
  -5.660216802223253e-15,   2.508479430167688e-16,  -8.682735029550579e-03,   2.740472281065302e-04,  -5.842774579596085e-06,   6.181411006822377e-08,   2.179181759154921e-09,
  -1.582831725490167e-10,   4.511857033541654e-12,  -6.865696093043286e-15,  -5.240506594326812e-15,   2.315683757392047e-16,  -7.375120772213794e-03,   2.327758026937618e-04,
  -4.961721808772305e-06,   5.239748973962733e-08,   1.855341581463864e-09,  -1.344458327856107e-10,   3.822415335912353e-12,  -5.283835755390809e-15,  -4.460700916013025e-15,
   1.961653434644157e-16,  -5.666361855046455e-03,   1.788433493265879e-04,  -3.811202953844030e-06,   4.016979982910651e-08,   1.429007729936918e-09,  -1.032953186459004e-10,
   2.928662693791183e-12,  -3.613745755065953e-15,  -3.434786077365849e-15,   1.502814198200486e-16,  -3.816538607223600e-03,   1.204586431093161e-04,  -2.566517953407101e-06,
   2.700966147010827e-08,   9.643688244863457e-10,  -6.957338848469009e-11,   1.968267131805714e-12,  -2.198056322146300e-15,  -2.317464902422914e-15,   1.009896962900587e-16,
  -2.107349539528063e-03,   6.651272947021420e-05,  -1.416978345045593e-06,   1.489892853266593e-08,   5.330837428585963e-10,  -3.841562364722911e-11,   1.085427838384657e-12,
  -1.138579579100688e-15,  -1.280879971493178e-15,   5.568872882703526e-17,  -7.991269182740392e-04,   2.522225484835712e-05,  -5.373093044104281e-07,   5.647708357352001e-09,
   2.022351477252280e-10,  -1.456753760724087e-11,   4.114085873561137e-13,  -4.210716785006150e-16,  -4.859010394558810e-16,   2.110713662110157e-17,  -9.111130587183082e-05,
   2.875679050088367e-06,  -6.126012554931050e-08,   6.438755308192035e-10,   2.305915065659191e-11,  -1.660896235604518e-12,   4.690245468141960e-14,  -4.780591308684898e-17,
  -5.540269140546344e-17,   2.406300168342715e-18,  -1.555518260131163e-02,   4.864481505363635e-04,  -9.692106403903007e-06,   3.135447287181653e-08,   9.613523986409470e-09,
  -5.841968116931742e-10,   1.940543872677992e-11,  -2.662823932856130e-13,  -1.073103008614348e-14,   8.384247091250441e-16,  -1.438302225901417e-02,   4.497823169676487e-04,
  -8.958934191131217e-06,   2.873393592448093e-08,   8.901551047714589e-09,  -5.403977397863322e-10,   1.792912877669166e-11,  -2.448802451737283e-13,  -9.975179654719230e-15,
   7.759314614897055e-16,  -1.221689772832782e-02,   3.820304582470465e-04,  -7.605751756618316e-06,   2.404691655397437e-08,   7.578305764843542e-09,  -4.593218425200072e-10,
   1.520933362343515e-11,  -2.061358642666872e-13,  -8.546375953791111e-15,   6.600203457469778e-16,  -9.386294796489949e-03,   2.935047173351129e-04,  -5.840314913433482e-06,
   1.818208983379132e-08,   5.836579540147651e-09,  -3.531497448166448e-10,   1.166932486500233e-11,  -1.568537179458695e-13,  -6.626001266815054e-15,   5.078570267849218e-16,
  -6.322051559588312e-03,   1.976815670022358e-04,  -3.931982856321312e-06,   1.209087946815794e-08,   3.938660256554729e-09,  -2.379929169996605e-10,   7.851207699982807e-12,
  -1.048403573737374e-13,  -4.494510704453800e-15,   3.424601938575748e-16,  -3.490792841999550e-03,   1.091502768792945e-04,  -2.170544819797877e-06,   6.626555031899443e-09,
   2.177160428630816e-09,  -1.314524590311782e-10,   4.332398360973343e-12,  -5.763151084500693e-14,  -2.491760788784388e-15,   1.892188859348111e-16,  -1.323740730221734e-03,
   4.139052392901598e-05,  -8.230130043493906e-07,   2.505792371529469e-09,   8.259386586968835e-10,  -4.985394315140883e-11,   1.642495145839632e-12,  -2.181775277144913e-14,
  -9.463309071446365e-16,   7.177133882981988e-17,  -1.509243759638334e-04,   4.719075448903604e-06,  -9.383316620052879e-08,   2.855608762240655e-10,   9.417461019500660e-11,
  -5.684137505635410e-12,   1.872593205854811e-13,  -2.486826744122900e-15,  -1.079216073211071e-16,   8.183240776238109e-18,  -8.985107171326298e-05,   2.706670636296454e-06,
  -5.936352587587901e-08,   1.012466487186097e-09,  -8.022170474713132e-12,  -3.152027495108359e-13,   1.736005503215407e-14,  -3.526716199462539e-16,  -4.728444646702584e-18,
   6.063894192825432e-19,  -8.308051990617163e-05,   2.502769188141483e-06,  -5.489066416894720e-08,   9.360054358568830e-10,  -7.406045189518319e-12,  -2.917623349121949e-13,
   1.604537115910631e-14,  -3.251246354453182e-16,  -4.413210968387522e-18,   5.612569499090365e-19,  -7.056859692490785e-05,   2.125928108168183e-06,  -4.662463162295192e-08,
   7.948077804607797e-10,  -6.274483697594231e-12,  -2.482556081857247e-13,   1.361974473432074e-14,  -2.748044039563936e-16,  -3.805764577262408e-18,   4.775065778572116e-19,
  -5.421835344413741e-05,   1.633427451668999e-06,  -3.582243829595128e-08,   6.104644974991538e-10,  -4.807520818138934e-12,  -1.910881230955636e-13,   1.045658907160173e-14,
  -2.100273501973597e-16,  -2.970524552856742e-18,   3.674959819550454e-19,  -3.651837335523658e-05,   1.100215799788790e-06,  -2.412815179952652e-08,   4.110720470922186e-10,
  -3.231071400316008e-12,  -1.288918060782985e-13,   7.038922467465925e-15,  -1.408751983407420e-16,  -2.025395453335003e-18,   2.478515177200825e-19,  -2.016406994300442e-05,
   6.075081463814348e-07,  -1.332272349282834e-08,   2.269460322613215e-10,  -1.781846314549951e-12,  -7.122828487718929e-14,   3.885334922622037e-15,  -7.759876038657169e-17,
  -1.126183057284392e-18,   1.369577669960685e-19,  -7.646405470694749e-06,   2.303743031996040e-07,  -5.052111906660678e-09,   8.605545144309363e-11,  -6.753754909541409e-13,
  -2.701884202304760e-14,   1.473171062283375e-15,  -2.939951520341463e-17,  -4.281743630584092e-19,   5.195035687675280e-20,  -8.717939006038001e-07,   2.626582225870987e-08,
  -5.760094383256260e-10,   9.811400883087794e-12,  -7.699596432089733e-14,  -3.080673127107916e-15,   1.679579843893903e-16,  -3.351439333911101e-18,  -4.883875401428489e-20,
   5.923322173516633e-21,  -8.173631089056871e-04,   2.461851735260647e-05,  -5.393957308520600e-07,   9.147124300184712e-09,  -6.849820686842706e-11,  -3.101361185743725e-12,
   1.668700733920919e-13,  -3.434944623952712e-15,  -4.122244360081966e-17,   5.667122501669684e-18,  -7.557722809397771e-04,   2.276392381232885e-05,  -4.987527266558929e-07,
   8.456225281515189e-09,  -6.322509392243564e-11,  -2.870694847541547e-12,   1.542381546214119e-13,  -3.167019217607683e-15,  -3.850679686327644e-17,   5.245701991911507e-18,
  -6.419529647793626e-04,   1.933635615132494e-05,  -4.236434878045946e-07,   7.180436274548059e-09,  -5.354788462333297e-11,  -2.442584081710422e-12,   1.309287996245754e-13,
  -2.677378756881282e-15,  -3.325155166895394e-17,   4.463461350074768e-18,  -4.932169818104873e-04,   1.485681225420173e-05,  -3.254906247990984e-07,   5.514918401260644e-09,
  -4.101449907738128e-11,  -1.880080756447950e-12,   1.005268236380411e-13,  -2.046695937039537e-15,  -2.598997970092269e-17,   3.435566738095649e-18,  -3.322026543179000e-04,
   1.000698949119932e-05,  -2.192330339452554e-07,   3.713545160250212e-09,  -2.755787092269698e-11,  -1.268125433310181e-12,   6.767345829321417e-14,  -1.373044208574255e-15,
  -1.773956501687411e-17,   2.317283689541397e-18,  -1.834297843841995e-04,   5.525575863212053e-06,  -1.210526054881820e-07,   2.050164862584927e-09,  -1.519502831357480e-11,
  -7.007869828627301e-13,   3.735531186182157e-14,  -7.563918786533156e-16,  -9.869664111753482e-18,   1.280555358150391e-18,  -6.955830318666520e-05,   2.095363753850496e-06,
  -4.590434388908668e-08,   7.773970013780278e-10,  -5.759052648162901e-12,  -2.658269548022406e-13,   1.416385548003897e-14,  -2.865814636950593e-16,  -3.753278304273969e-18,
   4.857460205709633e-19,  -7.930589683027438e-06,   2.389001297628774e-07,  -5.233718641917499e-09,   8.863295115271823e-11,  -6.565525353874915e-13,  -3.030942495454708e-14,
   1.614840718181208e-15,  -3.266945732540378e-17,  -4.281250749624143e-19,   5.538441415709573e-20,  -2.322509898661253e-03,   6.992908129399184e-05,  -1.528664189943966e-06,
   2.558485769824313e-08,  -1.656359042715304e-10,  -1.034003484515388e-11,   5.332684713275661e-13,  -1.129237550992236e-14,  -1.033344073983680e-16,   1.704723790005630e-17,
  -2.147501436486360e-03,   6.466104094992704e-05,  -1.413473062883144e-06,   2.365165137479889e-08,  -1.527996157095984e-10,  -9.570852818848722e-12,   4.929355450958359e-13,
  -1.041406313067806e-14,  -9.677052227361053e-17,   1.578223219072854e-17,  -1.824087428279090e-03,   5.492494276239304e-05,  -1.200601696743702e-06,   2.008230531435687e-08,
  -1.292929631810796e-10,  -8.143355637808817e-12,   4.184891973114331e-13,  -8.807468099395252e-15,  -8.389964495079550e-17,   1.343249283371122e-17,  -1.401458997956776e-03,
   4.220073182226667e-05,  -9.224287413853829e-07,   1.542333315596487e-08,  -9.893328886079339e-11,  -6.267875039117866e-12,   3.213549440545951e-13,  -6.735632725392599e-15,
  -6.584655665502368e-17,   1.034212938480057e-17,  -9.439422409196509e-04,   2.842479196415637e-05,  -6.212939505058396e-07,   1.038506621811171e-08,  -6.642202605364006e-11,
  -4.227643119839589e-12,   2.163535090024947e-13,  -4.520176469067065e-15,  -4.508396736826910e-17,   6.977343182520664e-18,  -5.212092903070219e-04,   1.569535382264621e-05,
  -3.430547343620303e-07,   5.733220004561304e-09,  -3.660763903424129e-11,  -2.336241608867915e-12,   1.194325008348929e-13,  -2.490590535151274e-15,  -2.512716064779575e-17,
   3.856260568224445e-18,  -1.976474704710107e-04,   5.951862424008504e-06,  -1.300895355752475e-07,   2.173945479244325e-09,  -1.387226575982264e-11,  -8.861946323347915e-13,
   4.528567916301713e-14,  -9.437032082613121e-16,  -9.561687013962132e-18,   1.462846264169099e-18,  -2.253449137774568e-05,   6.785937021078718e-07,  -1.483196988865050e-08,
   2.478565087839926e-10,  -1.581443145273485e-12,  -1.010433011466334e-13,   5.163101014296232e-15,  -1.075807434498748e-16,  -1.090789898653354e-18,   1.667940488068088e-19,
  -4.727476807621595e-03,   1.422514847396253e-04,  -3.096299822363114e-06,   5.051259428083209e-08,  -2.240772599851378e-10,  -2.709971753779676e-11,   1.325203616472885e-12,
  -2.947421379607915e-14,  -1.382069722687385e-16,   3.807326893256947e-17,  -4.371245771266468e-03,   1.315348985571769e-04,  -2.862951190334545e-06,   4.669288144127049e-08,
  -2.063147369830144e-10,  -2.508374201194986e-11,   1.225120088752169e-12,  -2.719183364998990e-14,  -1.307410177836098e-16,   3.526044863308885e-17,  -3.712934564533994e-03,
   1.117292266084046e-04,  -2.431744546763385e-06,   3.964218869398708e-08,  -1.740202291333961e-10,  -2.134241513409147e-11,   1.040298452503844e-12,  -2.301101632507085e-14,
  -1.151585953039921e-16,   3.002801100403028e-17,  -2.852672511393706e-03,   8.584519045761921e-05,  -1.868288541886162e-06,   3.044207883097134e-08,  -1.327037979381224e-10,
  -1.642703536060344e-11,   7.990044642411203e-13,  -1.760953597154208e-14,  -9.182115132897424e-17,   2.313365964029059e-17,  -1.921395830556599e-03,   5.782189760974425e-05,
  -1.258351709676556e-06,   2.049592403093628e-08,  -8.885321600515162e-11,  -1.107991401284055e-11,   5.380213447250599e-13,  -1.182362280476548e-14,  -6.361592869696314e-17,
   1.561462470110990e-17,  -1.060922144642553e-03,   3.192755138226296e-05,  -6.948079054988389e-07,   1.131448992441917e-08,  -4.889302997694746e-11,  -6.122875955859613e-12,
   2.970293078198184e-13,  -6.516709532412450e-15,  -3.569003138946308e-17,   8.632308490224654e-18,  -4.023116469345665e-04,   1.210729660266116e-05,  -2.634767820004533e-07,
   4.290192774400213e-09,  -1.851672504811408e-11,  -2.322558716653502e-12,   1.126297568997666e-13,  -2.469509588752147e-15,  -1.361423345483158e-17,   3.274944322495433e-18,
  -4.586898199992104e-05,   1.380397260278932e-06,  -3.003990805783706e-08,   4.891331815870822e-10,  -2.110704660614139e-12,  -2.648165324641431e-13,   1.284119528052991e-14,
  -2.815256678819878e-16,  -1.553723433237304e-18,   3.734162239387951e-19,  -8.300217933859447e-03,   2.494545904640621e-04,  -5.383873406224519e-06,   8.322545982992405e-08,
   1.020396421483889e-11,  -6.984618802720114e-11,   3.247944418231502e-12,  -7.870365735359322e-14,   1.590632086315765e-16,   7.594068810423422e-17,  -7.674766561270672e-03,
   2.306610815189491e-04,  -4.978017991604394e-06,   7.692089493807719e-08,   1.157217986050248e-11,  -6.465294738681347e-11,   3.003262705464239e-12,  -7.264956613684692e-14,
   1.401638051454362e-16,   7.039128739293695e-17,  -6.518940485650287e-03,   1.959286213443537e-04,  -4.228099108863420e-06,   6.529018065251776e-08,   1.280931032608934e-11,
  -5.501351922069666e-11,   2.551046086656096e-12,  -6.153597733961842e-14,   1.094187857291125e-16,   6.003061894214337e-17,  -5.008542862420745e-03,   1.505374924235731e-04,
  -3.248290684852820e-06,   5.012502197042227e-08,   1.227063369716247e-11,  -4.234645253859055e-11,   1.960037052499292e-12,  -4.713752069010727e-14,   7.621562402841046e-17,
   4.631684734824516e-17,  -3.373464386367778e-03,   1.013956146781267e-04,  -2.187762401545321e-06,   3.374123985027694e-08,   9.552360280789825e-12,  -2.856403848000545e-11,
   1.320190026850704e-12,  -3.167422747693212e-14,   4.717460018134553e-17,   3.129921040754945e-17,  -1.862699034398354e-03,   5.598753668087699e-05,  -1.207968063110936e-06,
   1.862423247555042e-08,   5.684735017538760e-12,  -1.578532072112072e-11,   7.289648984976566e-13,  -1.746541139580837e-14,   2.472291166393773e-17,   1.731491080477451e-17,
  -7.063529102413434e-04,   2.123110126791513e-05,  -4.580683313221897e-07,   7.061571693773385e-09,   2.214126592080025e-12,  -5.987840153294047e-12,   2.764310940836651e-13,
  -6.619642397623738e-15,   9.186501839696911e-18,   6.570621474401863e-18,  -8.053380670724462e-05,   2.420635293382652e-06,  -5.222591466609187e-08,   8.050976656725891e-10,
   2.535445738579650e-13,  -6.827308240759727e-13,   3.151690614275802e-14,  -7.546645964912185e-16,   1.043820430458896e-18,   7.492276623324724e-19,  -1.375937031275014e-02,
   4.122932290449284e-04,  -8.704519435142361e-06,   1.140610923444095e-07,   1.876154312765268e-09,  -2.255113738055385e-10,   1.038156180014863e-11,  -3.021074616067607e-13,
   4.174602944520750e-15,   1.102647435250767e-16,  -1.272254170830998e-02,   3.812285326925473e-04,  -8.047844211418824e-06,   1.053631589351791e-07,   1.741575445658625e-09,
  -2.087892543654086e-10,   9.603995232576531e-12,  -2.791537747666295e-13,   3.841121855518944e-15,   1.027479446674418e-16,  -1.080650206752700e-02,   3.238194934104687e-04,
  -6.834772906839905e-06,   8.935159669315629e-08,   1.488772571945013e-09,  -1.777230458983909e-10,   8.164181381795277e-12,  -2.368482453078660e-13,   3.236239199224776e-15,
   8.837803519143666e-17,  -8.302691445218136e-03,   2.487960259907856e-04,  -5.250333042665879e-06,   6.853203496690140e-08,   1.151564769731753e-09,  -1.368533361344017e-10,
   6.277906583006613e-12,  -1.817546221956523e-13,   2.464855400291153e-15,   6.880096153298879e-17,  -5.592205773773512e-03,   1.675764287411361e-04,  -3.535860220191376e-06,
   4.609693290214514e-08,   7.797272011606038e-10,  -9.233941670306296e-11,   4.231237133970661e-12,  -1.223034110847135e-13,   1.648731907427193e-15,   4.681695248953650e-17,
  -3.087801829822779e-03,   9.252992863873285e-05,  -1.952221024086932e-06,   2.543311701645653e-08,   4.318425989072058e-10,  -5.103821730139680e-11,   2.337218574790562e-12,
  -6.749417954877552e-14,   9.067136044155760e-16,   2.600237076600642e-17,  -1.170923071416472e-03,   3.508829799079448e-05,  -7.402795621188502e-07,   9.641646932801683e-09,
   1.639448682091322e-10,  -1.936155753905397e-11,   8.864216624932956e-13,  -2.558912650075606e-14,   3.433137190953712e-16,   9.881958171266515e-18,  -1.335010971221474e-04,
   4.000543174892795e-06,  -8.440150934966764e-08,   1.099224972343177e-09,   1.869545487932598e-11,  -2.207619627204349e-12,   1.010664747840211e-13,  -2.917407089425071e-15,
   3.913257751284021e-17,   1.127085687908400e-18,  -7.990080598952179e-05,   2.277829575565241e-06,  -4.812821711622044e-08,   8.528582382127653e-10,  -1.098149257714630e-11,
  -1.913911057950182e-14,   7.644836912054428e-15,  -2.902296731995766e-16,   5.309981563299853e-18,   4.629636423379578e-20,  -7.387983406852184e-05,   2.106234298851581e-06,
  -4.450309053309292e-08,   7.885588038714162e-10,  -1.014863053043189e-11,  -1.796330760027694e-14,   7.074992018463662e-15,  -2.682736143220302e-16,   4.895599749279034e-18,
   4.343845846985773e-20,  -6.275325111532336e-05,   1.789099794277621e-06,  -3.780299034105326e-08,   6.697543746317420e-10,  -8.612750314141812e-12,  -1.562937161642672e-14,
   6.018145897103570e-15,  -2.277500015765553e-16,   4.138410226529316e-18,   3.777562267378173e-20,  -4.821353729742557e-05,   1.374630465832798e-06,  -2.904598585110144e-08,
   5.145381651806290e-10,  -6.611120868319148e-12,  -1.231075721737779e-14,   4.630811293338361e-15,  -1.748815620417816e-16,   3.163305567473376e-18,   2.973941520656039e-20,
  -3.247375142186724e-05,   9.259000190667539e-07,  -1.956459999146392e-08,   3.465427242942480e-10,  -4.449627503332073e-12,  -8.452160745477164e-15,   3.122762856072927e-15,
  -1.177363802966790e-16,   2.121984659207451e-18,   2.041015307718921e-20,  -1.793074317145145e-05,   5.112559571662186e-07,  -1.080311835163251e-08,   1.913412329496200e-10,
  -2.455882318452470e-12,  -4.718045688075446e-15,   1.725453066235576e-15,  -6.499231322567630e-17,   1.168924494230722e-18,   1.139056519646964e-20,  -6.799501357020525e-06,
   1.938743402313181e-07,  -4.096684683416991e-09,   7.255745847641421e-11,  -9.311464107905310e-13,  -1.796400194097906e-15,   6.544760794010476e-16,  -2.464322787205510e-17,
   4.428745795631071e-19,   4.336614471325122e-21,  -7.752352438188164e-07,   2.210432732630078e-08,  -4.670783626316560e-10,   8.272516267733007e-12,  -1.061605316289781e-13,
  -2.049514243647101e-16,   7.462232118572706e-17,  -2.809615370549479e-18,   5.048628541769616e-20,   4.947579866451960e-22,  -7.268551302106888e-04,   2.072031524042631e-05,
  -4.376396413435279e-07,   7.739074066040440e-09,  -9.841795956685912e-11,  -2.599665101353931e-13,   7.339321533621788e-14,  -2.771529519216684e-15,   5.142410222888269e-17,
   3.912980225756177e-19,  -6.720825286419191e-04,   1.915939333598884e-05,  -4.046752449247376e-07,   7.155564779624959e-09,  -9.095048359851290e-11,  -2.429192377458216e-13,
   6.792306958300802e-14,  -2.561942262134148e-15,   4.741641499483065e-17,   3.677725845701257e-19,  -5.708643412798757e-04,   1.627457075281331e-05,  -3.437493950559681e-07,
   6.077452545416595e-09,  -7.718165170929677e-11,  -2.098791792416208e-13,   5.777768053396929e-14,  -2.175065136494118e-15,   4.009013975534576e-17,   3.206933968958738e-19,
  -4.385970146514261e-04,   1.250434190580751e-05,  -2.641199380450364e-07,   4.668953576080744e-09,  -5.924071957436712e-11,  -1.641393828977847e-13,   4.445912670187768e-14,
  -1.670251354042178e-15,   3.065012089649450e-17,   2.531597018645975e-19,  -2.954126782040322e-04,   8.422458658563098e-06,  -1.779039001398238e-07,   3.144528614563464e-09,
  -3.987012461760068e-11,  -1.120850554463379e-13,   2.998112728273005e-14,  -1.124520459894784e-15,   2.056375306228560e-17,   1.740999622567509e-19,  -1.631153955709945e-04,
   4.650644361854086e-06,  -9.823433314349966e-08,   1.736222929081092e-09,  -2.200488890638992e-11,  -6.237663611073749e-14,   1.656590112066771e-14,  -6.207683765434727e-16,
   1.132887340504079e-17,   9.727378627571304e-20,  -6.185484554166119e-05,   1.763579589607642e-06,  -3.725174161790316e-08,   6.583825132320644e-10,  -8.343052475550111e-12,
  -2.372321712233252e-14,   6.283575047631397e-15,  -2.353798501848492e-16,   4.292359932503325e-18,   3.704977360887280e-20,  -7.052290119056061e-06,   2.010722007296024e-07,
  -4.247210367433278e-09,   7.506435207267547e-11,  -9.511944754438071e-13,  -2.706080137666811e-15,   7.164435335366789e-16,  -2.683608995493416e-17,   4.893181277580235e-19,
   4.227250094707744e-21,  -2.065387045140479e-03,   5.887104845800443e-05,  -1.242416012612479e-06,   2.186717030775563e-08,  -2.701480007938650e-10,  -1.293698990657754e-12,
   2.336282729717503e-13,  -8.741482721494113e-15,   1.671675930181743e-16,   8.883297221032364e-19,  -1.909748518938910e-03,   5.443610388831346e-05,  -1.148830848948727e-06,
   2.021818555172562e-08,  -2.496291960807187e-10,  -1.204221250236384e-12,   2.162199048357950e-13,  -8.080987853464583e-15,   1.541755571588182e-16,   8.397771886737201e-19,
  -1.622133045821974e-03,   4.623965743493410e-05,  -9.758652530674426e-07,   1.717161269803318e-08,  -2.118085515301853e-10,  -1.034027212191117e-12,   1.839302294001940e-13,
  -6.861450358168700e-15,   1.304043508424446e-16,   7.389370273393638e-19,  -1.246290273172990e-03,   3.552758409604580e-05,  -7.498035001713962e-07,   1.319166947312319e-08,
  -1.625492183010937e-10,  -8.035468962241499e-13,   1.415368584991182e-13,  -5.269593387222642e-15,   9.973928641856363e-17,   5.886172422293148e-19,  -8.394264453719144e-04,
   2.393004654183924e-05,  -5.050454427820938e-07,   8.884406554779352e-09,  -1.093858043254286e-10,  -5.460435531613366e-13,   9.544846059792925e-14,  -3.548161128932034e-15,
   6.693895656175983e-17,   4.075264935609455e-19,  -4.634986365999649e-04,   1.321349427540367e-05,  -2.788736905289832e-07,   4.905396576617675e-09,  -6.036746689162790e-11,
  -3.030404644627134e-13,   5.274037130394626e-14,  -1.958795406743644e-15,   3.688467815187035e-17,   2.285467473394140e-19,  -1.757629084046837e-04,   5.010713546980474e-06,
  -1.057524761160154e-07,   1.860138715877305e-09,  -2.288746123990387e-11,  -1.151344703648335e-13,   2.000495657822411e-14,  -7.427413662799048e-16,   1.397611800796482e-17,
   8.716910422245149e-20,  -2.003935196396513e-05,   5.712898873189602e-07,  -1.205723398289087e-08,   2.120803937245672e-10,  -2.609396773611114e-12,  -1.313102328291996e-14,
   2.280936630025200e-15,  -8.468159596428280e-17,   1.593260909375724e-18,   9.947947318914285e-21,  -4.204300608712010e-03,   1.198133927678128e-04,  -2.524708555111163e-06,
   4.404248105528733e-08,  -5.134065074355824e-10,  -4.789602833014832e-12,   5.745634879520138e-13,  -2.129329995165672e-14,   4.290450567786242e-16,   6.894234670071538e-19,
  -3.887482714419694e-03,   1.107874037432693e-04,  -2.334525001227108e-06,   4.072030643220838e-08,  -4.743248355697503e-10,  -4.448158142122051e-12,   5.317736227991608e-13,
  -1.968674780730619e-14,   3.958495611132881e-16,   6.805562776851576e-19,  -3.302012576940459e-03,   9.410605235189129e-05,  -1.983030450634707e-06,   3.458302372732599e-08,
  -4.023404732098117e-10,  -3.805406206710350e-12,   4.523917405576961e-13,  -1.671900255356209e-14,   3.350250937687355e-16,   6.381387091456688e-19,  -2.536947130775823e-03,
   7.230497747501348e-05,  -1.523645370693468e-06,   2.656645384837265e-08,  -3.086714181720239e-10,  -2.945842108102464e-12,   3.481476767205461e-13,  -1.284286154070478e-14,
   2.564135355502831e-16,   5.392585605319129e-19,  -1.708735438887723e-03,   4.870187978584110e-05,  -1.026276653936841e-06,   1.789155218659214e-08,  -2.076648451859442e-10,
  -1.995874385290125e-12,   2.347947842884770e-13,  -8.648866120931218e-15,   1.721801559484231e-16,   3.891714387352603e-19,  -9.434972143740303e-04,   2.689178724482713e-05,
  -5.666829251724937e-07,   9.878374730997840e-09,  -1.145886557830391e-10,  -1.105782207296889e-12,   1.297410727115444e-13,  -4.775139055784943e-15,   9.490372724998424e-17,
   2.231572665553522e-19,  -3.577827392591942e-04,   1.019768254122995e-05,  -2.148931629135149e-07,   3.745877888853111e-09,  -4.344226694560119e-11,  -4.198549393168482e-13,
   4.921273160586553e-14,  -1.810714596390594e-15,   3.596449320887934e-17,   8.580114349444422e-20,  -4.079207771940821e-05,   1.162675274100570e-06,  -2.450076553992774e-08,
   4.270790741414240e-10,  -4.952802727957913e-12,  -4.787920820716409e-14,   5.611177405839479e-15,  -2.064448176201635e-16,   4.099988144008569e-18,   9.804753320375760e-21,
  -7.382322186690152e-03,   2.102989601597844e-04,  -4.418535954557110e-06,   7.573386399183115e-08,  -7.750316705667644e-10,  -1.604834735910936e-11,   1.370086725139620e-12,
  -5.071713546403268e-14,   1.118108872805777e-15,  -4.652778287439264e-18,  -6.826021653200407e-03,   1.944561432127665e-04,  -4.085659344891726e-06,   7.001770507109351e-08,
  -7.157015087516706e-10,  -1.488533478897385e-11,   1.268170462148320e-12,  -4.690059084137851e-14,   1.032211145227590e-15,  -4.207078842788258e-18,  -5.797995067037044e-03,
   1.651764224391581e-04,  -3.470461437599264e-06,   5.945993586467997e-08,  -6.066202762922969e-10,  -1.270813840081409e-11,   1.079027638568649e-12,  -3.984435914723135e-14,
   8.744601202027316e-16,  -3.440817554901802e-18,  -4.454617905085875e-03,   1.269105897962071e-04,  -2.666463157218129e-06,   4.567278168106363e-08,  -4.650126169731853e-10,
  -9.816364763201770e-12,   8.305248850698680e-13,  -3.061821832080313e-14,   6.699720581789212e-16,  -2.535373545929323e-18,  -3.000363045388307e-03,   8.548201188255789e-05,
  -1.796020512371158e-06,   3.075687786174437e-08,  -3.126444930808801e-10,  -6.639629494067474e-12,   5.601879094853712e-13,  -2.062550721983521e-14,   4.502539265268960e-16,
  -1.650277479380889e-18,  -1.656683581761801e-03,   4.720068462434473e-05,  -9.917088036171923e-07,   1.698097383920498e-08,  -1.724515250287817e-10,  -3.675040642011105e-12,
   3.095673823072049e-13,  -1.138950994734993e-14,   2.482935999480888e-16,  -8.929209209706847e-19,  -6.282294880977701e-04,   1.789904981464442e-05,  -3.760673129879297e-07,
   6.439086720341918e-09,  -6.536974986113124e-11,  -1.394875610809749e-12,   1.174268369703734e-13,  -4.319133701349785e-15,   9.410970452769006e-17,  -3.359976303511175e-19,
  -7.162666938158564e-05,   2.040736356758154e-06,  -4.287681020330067e-08,   7.341383028916901e-10,  -7.452555947317164e-12,  -1.590586506611052e-13,   1.338893121214699e-14,
  -4.924421418402780e-16,   1.072892078353245e-17,  -3.825902309539727e-20,  -1.224043773495974e-02,   3.483744185155738e-04,  -7.267805374963884e-06,   1.189572728027442e-07,
  -7.415590780798268e-10,  -6.108669243037606e-11,   4.010759878645578e-12,  -1.544169499815285e-13,   4.090925246178282e-15,  -5.906306974080906e-17,  -1.131804741027504e-02,
   3.221288381130437e-04,  -6.720131841787120e-06,   1.099627916064842e-07,  -6.830006536840539e-10,  -5.662451761092890e-11,   3.713434536392492e-12,  -1.428683001374779e-13,
   3.780842878661614e-15,  -5.439740322150587e-17,  -9.613499616696825e-03,   2.736239016287847e-04,  -5.708048349393027e-06,   9.335953504947497e-08,  -5.764005218685318e-10,
  -4.829341644170969e-11,   3.161017681267173e-12,  -1.214734303948241e-13,   3.208890043754405e-15,  -4.590455059830014e-17,  -7.386078916182296e-03,   2.102334178197772e-04,
  -4.385507126473278e-06,   7.169377344337502e-08,  -4.397996386095932e-10,  -3.726449414904236e-11,   2.434193971749982e-12,  -9.342717956143257e-14,   2.463304579500244e-15,
  -3.502301227612630e-17,  -4.974817411989466e-03,   1.416044746213310e-04,  -2.953811391774736e-06,   4.827021440548898e-08,  -2.946036451679620e-10,  -2.518425075843147e-11,
   1.642479971998057e-12,  -6.297907443845080e-14,   1.658011851281742e-15,  -2.345886081456328e-17,  -2.746899821435706e-03,   7.818970746368951e-05,  -1.630978588558110e-06,
   2.664705872426290e-08,  -1.621523368333810e-10,  -1.393289802626957e-11,   9.078541480085205e-13,  -3.479115872929735e-14,   9.151294758751181e-16,  -1.291139455517810e-17,
  -1.041649329166234e-03,   2.965042409018465e-05,  -6.184817738017778e-07,   1.010397023286964e-08,  -6.141608994415362e-11,  -5.287346448897321e-12,   3.444004800863893e-13,
  -1.319547972343117e-14,   3.469739723481706e-16,  -4.890178450927514e-18,  -1.187621285122351e-04,   3.380553202512945e-06,  -7.051529512478512e-08,   1.151973618358034e-09,
  -7.000875718867926e-12,  -6.029021438863561e-13,   3.926884971902723e-14,  -1.504507889354974e-15,   3.955875823632243e-17,  -5.574342755700445e-19,  -7.149891062809340e-05,
   1.930777450306939e-06,  -3.893518742127831e-08,   6.816479851756828e-10,  -1.008749169345062e-11,   8.609748781997354e-14,   1.870111016935157e-15,  -1.296360940294261e-16,
   4.061627222228885e-18,  -7.124866442268113e-20,  -6.611088731760145e-05,   1.785321238862027e-06,  -3.600282445583611e-08,   6.303013466353691e-10,  -9.325826091104454e-12,
   7.948734683900454e-14,   1.734123016336268e-15,  -1.199750884253475e-16,   3.754917450936772e-18,  -6.571278728714448e-20,  -5.615408464475735e-05,   1.516498989960114e-06,
  -3.058292215139511e-08,   5.354024822834168e-10,  -7.919202549940204e-12,   6.734572400834760e-14,   1.479838040830500e-15,  -1.020563755819832e-16,   3.188497157210906e-18,
  -5.558291673528119e-20,  -4.314316929397796e-05,   1.165175291198966e-06,  -2.349880492941706e-08,   4.113734226897094e-10,  -6.082619138297556e-12,   5.160281782956759e-14,
   1.142572373655726e-15,  -7.853219769802729e-17,   2.448967895338320e-18,  -4.251379045396454e-20,  -2.905854607253208e-05,   7.848155865820302e-07,  -1.582836347564749e-08,
   2.770880588599358e-10,  -4.095968369886407e-12,   3.468276159662695e-14,   7.725401636070993e-16,  -5.295905447256934e-17,   1.649063129056558e-18,  -2.853334532340880e-20,
  -1.604496477316628e-05,   4.333520792315895e-07,  -8.740117861951965e-09,   1.530009299604711e-10,  -2.261341035778007e-12,   1.912694122433762e-14,   4.275135011464177e-16,
  -2.926243817925600e-17,   9.104142594950607e-19,  -1.572262979472781e-20,  -6.084392037987985e-06,   1.643321177250120e-07,  -3.314376671066848e-09,   5.801987096251813e-11,
  -8.574793262318108e-13,   7.249758887615300e-15,   1.622518364141093e-16,  -1.109950094302984e-17,   3.452181205167276e-19,  -5.957550149178467e-21,  -6.937030028038451e-07,
   1.873610702480616e-08,  -3.778846652360690e-10,   6.615060959807427e-12,  -9.776346591098742e-14,   8.265073504373416e-16,   1.850145470632782e-17,  -1.265548556383193e-18,
   3.935917611628931e-20,  -6.791541655236675e-22,  -6.504256074818044e-04,   1.756401335051097e-05,  -3.541444050647058e-07,   6.195483463763166e-09,  -9.132350338816181e-11,
   7.556517574062945e-13,   1.837602621199372e-14,  -1.233246997111229e-15,   3.862808551318932e-17,  -6.863596328262318e-19,  -6.014107557831529e-04,   1.624081773822995e-05,
  -3.274722738449751e-07,   5.728783050338011e-09,  -8.442707589764897e-11,   6.975481455261033e-13,   1.703821786002087e-14,  -1.141354296270741e-15,   3.571219281209221e-17,
  -6.330939776893507e-19,  -5.108337165339311e-04,   1.379537829811440e-05,  -2.781740991113441e-07,   4.866234480090753e-09,  -7.169151628917912e-11,   5.908747337498940e-13,
   1.453762335360531e-14,  -9.709082834768813e-16,   3.032658712307850e-17,  -5.355884423897104e-19,  -3.924734149593716e-04,   1.059943512471849e-05,  -2.137387275983559e-07,
   3.738929685913419e-09,  -5.506406932327958e-11,   4.526492969814901e-13,   1.122263044945644e-14,  -7.471280351882253e-16,   2.329396047366141e-17,  -4.097286474530818e-19,
  -2.643455948330158e-04,   7.139356147866445e-06,  -1.439704119869195e-07,   2.518416926961444e-09,  -3.707895308966541e-11,   3.041762778953983e-13,   7.587152138680755e-15,
  -5.038424706343812e-16,   1.568611722343103e-17,  -2.750299704755382e-19,  -1.459610447601463e-04,   3.942142298101286e-06,  -7.949767001102110e-08,   1.390603021610983e-09,
  -2.047071431331223e-11,   1.677307580987971e-13,   4.198334652363419e-15,  -2.784000187321311e-16,   8.660193386459791e-18,  -1.515611287307410e-19,  -5.534971438834435e-05,
   1.494905908001131e-06,  -3.014664095793725e-08,   5.273337720650571e-10,  -7.762276571362519e-12,   6.357319094770257e-14,   1.593328862409731e-15,  -1.055999668654611e-16,
   3.283870462334149e-18,  -5.743063906742614e-20,  -6.310616217433687e-06,   1.704397010728848e-07,  -3.437132908498498e-09,   6.012327551915288e-11,  -8.849970014363185e-13,
   7.247602920123121e-15,   1.816852993040627e-16,  -1.204035810666311e-17,   3.744027916614166e-19,  -6.547062964388011e-21,  -1.848223889857310e-03,   4.990750817839251e-05,
  -1.006012398962450e-06,   1.757008202362803e-08,  -2.566777610383730e-10,   1.970382018741011e-12,   6.101376864401590e-14,  -3.855134809982423e-15,   1.208117950743994e-16,
  -2.207062955397238e-18,  -1.708945195401229e-03,   4.614769109458383e-05,  -9.302445620850555e-07,   1.624646619445236e-08,  -2.372881456628074e-10,   1.818283233503932e-12,
   5.656275925610984e-14,  -3.567977208798517e-15,   1.116994692054476e-16,  -2.036208351305013e-18,  -1.451565015663451e-03,   3.919905765027352e-05,  -7.902031006397517e-07,
   1.380022586345253e-08,  -2.014852869840432e-10,   1.539392391663616e-12,   4.824875597260295e-14,  -3.035286410187762e-15,   9.486475573780474e-17,  -1.723200035483414e-18,
  -1.115237016858254e-03,   3.011789791899256e-05,  -6.071621047622448e-07,   1.060319809493890e-08,  -1.547476150356331e-10,   1.178599585076376e-12,   3.723642271764691e-14,
  -2.335810650673645e-15,   7.287430251213504e-17,  -1.318748157682382e-18,  -7.511540345302102e-04,   2.028621028106399e-05,  -4.089725991549855e-07,   7.141910118746704e-09,
  -1.041999285920756e-10,   7.916479986927052e-13,   2.516859583811434e-14,  -1.575266479404408e-15,   4.907787398060932e-17,  -8.854688960907348e-19,  -4.147571551960464e-04,
   1.120144723702532e-05,  -2.258265971294286e-07,   3.943558484405445e-09,  -5.752596057377763e-11,   4.364202410479287e-13,   1.392527794605974e-14,  -8.704386033974029e-16,
   2.709695770262632e-17,  -4.880398208751773e-19,  -1.572795677024180e-04,   4.247718088626717e-06,  -8.563661964063510e-08,   1.495443775065899e-09,  -2.181305949916905e-11,
   1.653952567872537e-13,   5.284601761388612e-15,  -3.301689902069533e-16,   1.027513353972804e-17,  -1.849434674258125e-19,  -1.793199840607229e-05,   4.842979038151375e-07,
  -9.763755517066952e-09,   1.705010409143692e-10,  -2.486959455170809e-12,   1.885542282716731e-14,   6.025919458004944e-16,  -3.764545088327122e-17,   1.171499068198439e-18,
  -2.108368390626656e-20,  -3.762296854923153e-03,   1.015868095392487e-04,  -2.046707857574180e-06,   3.563547665920980e-08,  -5.118027461103199e-10,   3.334616263904627e-12,
   1.582403829419967e-13,  -9.225956572553437e-15,   2.903202618769369e-16,  -5.566410018690650e-18,  -3.478777147810517e-03,   9.393367860840455e-05,  -1.892557235403836e-06,
   3.295063708180807e-08,  -4.731165090656281e-10,   3.074706619433757e-12,   1.466685390843495e-13,  -8.539200917317285e-15,   2.684540087774338e-16,  -5.137288169289894e-18,
  -2.954846701399876e-03,   7.978970276955807e-05,  -1.607642792937407e-06,   2.798882854052965e-08,  -4.016971064053389e-10,   2.599604886556747e-12,   1.250711544885923e-13,
  -7.264958943779684e-15,   2.280379610370915e-16,  -4.350079399338579e-18,  -2.270207874713570e-03,   6.130497732993174e-05,  -1.235248586094201e-06,   2.150446399647193e-08,
  -3.084894359303550e-10,   1.987461554501678e-12,   9.649322639697457e-14,  -5.591287677459203e-15,   1.752126259478231e-16,  -3.331121198759910e-18,  -1.529070270493783e-03,
   4.129256780735679e-05,  -8.320377586634002e-07,   1.448440905704394e-08,  -2.077078756399006e-10,   1.333423322369189e-12,   6.520441666510418e-14,  -3.771032842929452e-15,
   1.180175725465040e-16,  -2.237760348460705e-18,  -8.442913148520634e-04,   2.280053516729280e-05,  -4.594342876136168e-07,   7.997819489103289e-09,  -1.146651978009031e-10,
   7.346027600579158e-13,   3.607101282568854e-14,  -2.083833209166559e-15,   6.516612334307362e-17,  -1.233724830558072e-18,  -3.201627041765467e-04,   8.646225635770993e-06,
  -1.742238622520441e-07,   3.032859142404124e-09,  -4.347880917454718e-11,   2.783313676877818e-13,   1.368809272290585e-14,  -7.904384414986428e-16,   2.471177910348585e-17,
  -4.675717506230662e-19,  -3.650287942880747e-05,   9.857878572035251e-07,  -1.986392128469584e-08,   3.457872640923058e-10,  -4.957111104388224e-12,   3.172907161489066e-14,
   1.560810062241822e-15,  -9.012503133307343e-17,   2.817481048914509e-18,  -5.330444590536640e-20,  -6.606384884232369e-03,   1.783601896713057e-04,  -3.590089048036489e-06,
   6.213854787904456e-08,  -8.625416891406491e-10,   3.529635247346933e-12,   3.974635768032075e-13,  -2.118257439213691e-14,   6.769307757577247e-16,  -1.410892805009829e-17,
  -6.108539800925177e-03,   1.649232108290361e-04,  -3.319687084730591e-06,   5.745590328869290e-08,  -7.972567938271851e-10,   3.243947530842531e-12,   3.683343073883716e-13,
  -1.960793677423265e-14,   6.260797244276194e-16,  -1.302861504670625e-17,  -5.188546730888806e-03,   1.400899710415083e-04,  -2.819912605826820e-06,   4.880259577648766e-08,
  -6.767852902428846e-10,   2.727890501786359e-12,   3.140079071028824e-13,  -1.668497507066785e-14,   5.320095893636209e-16,  -1.104247700722009e-17,  -3.986358760299610e-03,
   1.076355329833966e-04,  -2.166697549039542e-06,   3.749500208909410e-08,  -5.196483935068335e-10,   2.073400537762843e-12,   2.421878857195052e-13,  -1.284359954179247e-14,
   4.089213804703410e-16,  -8.464322255604950e-18,  -2.684962238656960e-03,   7.249893186960853e-05,  -1.459436673093045e-06,   2.525427716745545e-08,  -3.498298225055397e-10,
   1.384608423617798e-12,   1.636187167321427e-13,  -8.663636192380783e-15,   2.755172795336334e-16,  -5.690594502925092e-18,  -1.482528493761978e-03,   4.003175552083957e-05,
  -8.058693468803536e-07,   1.394439363910825e-08,  -1.931068421754112e-10,   7.607291721276680e-13,   9.050179765552192e-14,  -4.787848025449888e-15,   1.521590681786663e-16,
  -3.138778922178306e-18,  -5.621878598011590e-04,   1.518050131671647e-05,  -3.055965869893876e-07,   5.287835973689062e-09,  -7.321995544490820e-11,   2.879344709557092e-13,
   3.434159323822819e-14,  -1.816182733548018e-15,   5.770423508612766e-17,  -1.189776326959853e-18,  -6.409702118512969e-05,   1.730784533227705e-06,  -3.484221742796723e-08,
   6.028848165442344e-10,  -8.347916854203422e-12,   3.281820426697852e-14,   3.915831715736133e-15,  -2.070805231025107e-16,   6.579142222862760e-18,  -1.356415901922850e-19,
  -1.095455628641209e-02,   2.956750396771279e-04,  -5.938316614905885e-06,   1.013184131367521e-07,  -1.283153828744234e-09,  -3.964857789412830e-12,   1.187789739823548e-12,
  -5.852129460180760e-14,   1.976919724322339e-15,  -4.876363145330261e-17,  -1.012904025547446e-02,   2.733997748977592e-04,  -5.491009816816185e-06,   9.367891459955941e-08,
  -1.185636129668660e-09,  -3.720249084424055e-12,   1.100687869858884e-12,  -5.418676334095966e-14,   1.829328117536016e-15,  -4.507856413015419e-17,  -8.603527916603791e-03,
   2.322324015142607e-04,  -4.664291581956084e-06,   7.956408591356716e-08,  -1.005922751610872e-09,  -3.235573864152536e-12,   9.382751284338124e-13,  -4.613110945905701e-14,
   1.555744234275916e-15,  -3.827471880065934e-17,  -6.610086888274621e-03,   1.784311979405201e-04,  -3.583793574503371e-06,   6.112408824288319e-08,  -7.719127565317486e-10,
  -2.547622995486350e-12,   7.236170065961092e-13,  -3.552832361783460e-14,   1.196843607274220e-15,  -2.939422153247048e-17,  -4.452141178425162e-03,   1.201838817921586e-04,
  -2.413935883783747e-06,   4.116671693525135e-08,  -5.194143957842895e-10,  -1.748683235235341e-12,   4.888368463789048e-13,  -2.397513042611058e-14,   8.069465919923827e-16,
  -1.979149272407316e-17,  -2.458293712509882e-03,   6.636192292676554e-05,  -1.332915670039043e-06,   2.272976265308466e-08,  -2.866409596537141e-10,  -9.760022182103187e-13,
   2.703795324199510e-13,  -1.325259262704208e-14,   4.458266923186313e-16,  -1.092592980486409e-17,  -9.322066038111093e-04,   2.516519672802151e-05,  -5.054586348732695e-07,
   8.619205193018123e-09,  -1.086741422975286e-10,  -3.715972438689430e-13,   1.025963047927596e-13,  -5.027562493816456e-15,   1.690988379055546e-16,  -4.142902080195341e-18,
  -1.062841631767786e-04,   2.869176091977577e-06,  -5.762922180758685e-08,   9.827037034683758e-10,  -1.238989449143841e-11,  -4.239525031554161e-14,   1.169861419490592e-14,
  -5.732491180236092e-16,   1.928026222651165e-17,  -4.723410719471631e-19,  -6.435064599458309e-05,   1.649412809474881e-06,  -3.166188887747989e-08,   5.354623694487162e-10,
  -8.144754335744481e-12,   9.978422516627987e-14,  -3.140321671025402e-16,  -3.852774166111419e-17,   1.774588858960922e-18,  -4.916864906305522e-20,  -5.950115381557439e-05,
   1.525147220311892e-06,  -2.927729444008791e-08,   4.951417683359755e-10,  -7.530984087824777e-12,   9.222642634328290e-14,  -2.881707486557464e-16,  -3.570109363151879e-17,
   1.642478822210257e-18,  -4.546457005789550e-20,  -5.053962004537773e-05,   1.295491748476593e-06,  -2.486984351775758e-08,   4.206126243507600e-10,  -6.396763168421262e-12,
   7.828300991468658e-14,  -2.417049279599682e-16,  -3.043122678691772e-17,   1.397363565423304e-18,  -3.861867705576560e-20,  -3.882940857709169e-05,   9.953612924278385e-07,
  -1.910906979698712e-08,   3.231915842872203e-10,  -4.914631842572439e-12,   6.010118627991107e-14,  -1.832007664357164e-16,  -2.346752008673013e-17,   1.075427968189418e-18,
  -2.967163997117323e-20,  -2.615297653508176e-05,   6.704319555105767e-07,  -1.287151163723693e-08,   2.177002252799824e-10,  -3.310188528166341e-12,   4.045723840798969e-14,
  -1.220657154403506e-16,  -1.585248580522317e-17,   7.253112646942148e-19,  -1.998533751275224e-20,  -1.444059716073871e-05,   3.701916253320984e-07,  -7.107399006215316e-09,
   1.202112485180167e-10,  -1.827753035471956e-12,   2.233147345615464e-14,  -6.697671952153162e-17,  -8.767838357066284e-18,   4.007965115212065e-19,  -1.103519590721937e-20,
  -5.475997637015522e-06,   1.403807758256809e-07,  -2.695226218850537e-09,   4.558600579256137e-11,  -6.930999825516767e-13,   8.467238202973765e-15,  -2.533789964384258e-17,
  -3.326939163213443e-18,   1.520294944430181e-19,  -4.184655001847018e-21,  -6.243377338471646e-07,   1.600532358335586e-08,  -3.072929662681500e-10,   5.197437247119437e-12,
  -7.902277284797256e-14,   9.653597898629743e-16,  -2.887724300818656e-18,  -3.793557148177266e-19,   1.733424901070057e-20,  -4.771074865133873e-22,  -5.853984257089160e-04,
   1.500465650773036e-05,  -2.880159701737550e-07,   4.869657989847929e-09,  -7.397056993054984e-11,   8.996960949684528e-13,  -2.431276825601817e-15,  -3.689247995534824e-16,
   1.680017716225832e-17,  -4.662121250955486e-19,  -5.412825496103197e-04,   1.387421615260093e-05,  -2.663242038481477e-07,   4.502966691601289e-09,  -6.839603513896817e-11,
   8.315318200414393e-13,  -2.227277271042607e-15,  -3.418508746156191e-16,   1.554968609292602e-17,  -4.311025621350294e-19,  -4.597593927265186e-04,   1.178504729786022e-05,
  -2.262312857335354e-07,   3.825171625181431e-09,  -5.809470410110990e-11,   7.057872416014227e-13,  -1.862830790204634e-15,  -2.913800280234469e-16,   1.322941650653701e-17,
  -3.662056273370078e-19,  -3.532314896071492e-04,   9.054769847511826e-06,  -1.738277330289639e-07,   2.939192843929903e-09,  -4.463382975527440e-11,   5.418399449329451e-13,
  -1.407547408706229e-15,  -2.246942281084973e-16,   1.018175437180952e-17,  -2.813782675439693e-19,  -2.379138695020353e-04,   6.098897942091063e-06,  -1.170870869657610e-07,
   1.979823414344400e-09,  -3.006238549397055e-11,   3.647285445884853e-13,  -9.354809727851103e-16,  -1.517783850903191e-16,   6.867103637572225e-18,  -1.895297310208392e-19,
  -1.313662458570277e-04,   3.367621274746067e-06,  -6.465321161596667e-08,   1.093232211227019e-09,  -1.659918659776941e-11,   2.013179682306995e-13,  -5.125318790307053e-16,
  -8.394563434910185e-17,   3.794701940085440e-18,  -1.046539559793913e-19,  -4.981520110636298e-05,   1.277039384192564e-06,  -2.451741131252654e-08,   4.145708413692188e-10,
  -6.294549434153437e-12,   7.633149963878198e-14,  -1.937863874729676e-16,  -3.185281577867039e-17,   1.439405970463225e-18,  -3.968614565813087e-20,  -5.679606133856597e-06,
   1.455999116561143e-07,  -2.795323060346997e-09,   4.726682701834940e-11,  -7.176636293755792e-13,   8.702633642431535e-15,  -2.208349195299386e-17,  -3.632027843004492e-18,
   1.641197184572095e-19,  -4.524765759753026e-21,  -1.663448881703635e-03,   4.263631496315987e-05,  -8.183376785411526e-07,   1.382829957155505e-08,  -2.094159378589775e-10,
   2.505310592356702e-12,  -4.185262043205895e-15,  -1.167019082158131e-15,   5.199857100756990e-17,  -1.448864782379923e-18,  -1.538090657718268e-03,   3.942412350250803e-05,
  -7.567048174021261e-07,   1.278698935341903e-08,  -1.936322376391041e-10,   2.315369255781439e-12,  -3.805613844696368e-15,  -1.081335914090381e-15,   4.812959501074396e-17,
  -1.339836593064761e-18,  -1.306437136030936e-03,   3.348766742369642e-05,  -6.427888475321117e-07,   1.086223668448759e-08,  -1.644661993863783e-10,   1.965056825934634e-12,
  -3.142793623191663e-15,  -9.216316496627616e-16,   4.094988480274197e-17,  -1.138257545115324e-18,  -1.003730953531110e-03,   2.572947710895673e-05,  -4.938948884547733e-07,
   8.346321441632325e-09,  -1.263563931112445e-10,   1.508445623025317e-12,  -2.341438738279299e-15,  -7.106600057275061e-16,   3.151790587876976e-17,  -8.746879981491108e-19,
  -6.760482043939079e-04,   1.733025254837282e-05,  -3.326781710695548e-07,   5.622020791168486e-09,  -8.510419184664665e-11,   1.015300755050793e-12,  -1.538227281696901e-15,
  -4.800189110119093e-16,   2.125818861904446e-17,  -5.892194743081808e-19,  -3.732859906044878e-04,   9.569224846535163e-06,  -1.836983747743894e-07,   3.104400989092058e-09,
  -4.699061284256102e-11,   5.603869486305525e-13,  -8.369694505765599e-16,  -2.654814554700608e-16,   1.174737059952351e-17,  -3.253695086682350e-19,  -1.415532320128550e-04,
   3.628756292278705e-06,  -6.966101352649311e-08,   1.177237051256906e-09,  -1.781918120507637e-11,   2.124721167030609e-13,  -3.156230556322425e-16,  -1.007347434993023e-16,
   4.456051347344609e-18,  -1.233866536851648e-19,  -1.613898141237421e-05,   4.137277215540054e-07,  -7.942316276145103e-09,   1.342213434699611e-10,  -2.031626330069410e-12,
   2.422409921335383e-14,  -3.595197268001148e-17,  -1.148629217852384e-17,   5.080755481734509e-19,  -1.406781673792336e-20,  -3.386177256950289e-03,   8.679048109736599e-05,
  -1.665545477941060e-06,   2.811528475702655e-08,  -4.233852339875321e-10,   4.906445716563347e-12,   1.856225620582419e-15,  -2.832922668347176e-15,   1.225033075699322e-16,
  -3.444745618669097e-18,  -3.130993466834008e-03,   8.025173969594308e-05,  -1.540104648001708e-06,   2.599804051882239e-08,  -3.914677748624102e-10,   4.533952342982173e-12,
   1.867478834569635e-15,  -2.624816388385503e-15,   1.133948542601052e-16,  -3.185882249470229e-18,  -2.659431085645953e-03,   6.816748421065832e-05,  -1.308252917547988e-06,
   2.208458696477833e-08,  -3.324929740614535e-10,   3.847260244949238e-12,   1.797136991834965e-15,  -2.236998389933536e-15,   9.648825433149644e-17,  -2.707062556265042e-18,
  -2.043231323536039e-03,   5.237490945262948e-05,  -1.005211697821748e-06,   1.696925155601921e-08,  -2.554404694921610e-10,   2.952709058455936e-12,   1.552860141756154e-15,
  -1.724799910678489e-15,   7.427150990383598e-17,  -2.080634603390487e-18,  -1.376188364077411e-03,   3.527744977197117e-05,  -6.770909527069600e-07,   1.143031253975928e-08,
  -1.720413812976972e-10,   1.987093142560867e-12,   1.137233077447422e-15,  -1.164959243443010e-15,   5.009854600994462e-17,  -1.401801962222751e-18,  -7.598745645227351e-04,
   1.947910640857922e-05,  -3.738762241003313e-07,   6.311642035528973e-09,  -9.499199329183636e-11,   1.096661230029745e-12,   6.570549495797532e-16,  -6.442769153828760e-16,
   2.768593191167371e-17,  -7.741499470014688e-19,  -2.881509167117003e-04,   7.386693266128955e-06,  -1.417791140988988e-07,   2.393470347285817e-09,  -3.602146340954065e-11,
   4.157878039888958e-13,   2.533090444147037e-16,  -2.444626012626650e-16,   1.050209709008332e-17,  -2.935830314823347e-19,  -3.285309859482677e-05,   8.421838007217927e-07,
  -1.616477396460692e-08,   2.728887559270235e-10,  -4.106927746374837e-12,   4.740400165991061e-14,   2.895906101298930e-17,  -2.787482413401854e-17,   1.197444401398110e-18,
  -3.347278709970321e-20,  -5.945983952669680e-03,   1.523954064330844e-04,  -2.923679452855289e-06,   4.925762681768640e-08,  -7.338120551017011e-10,   7.966018279933097e-12,
   3.867478886392748e-14,  -6.567650994911786e-15,   2.746989299854329e-16,  -7.889628526988407e-18,  -5.497891971766729e-03,   1.409140153220226e-04,  -2.703479526665426e-06,
   4.554796045039651e-08,  -6.784690293276611e-10,   7.359414369206593e-12,   3.609857296183729e-14,  -6.085050999183993e-15,   2.543029887318215e-16,  -7.298249161184266e-18,
  -4.669848331352097e-03,   1.196952522773453e-04,  -2.296486500478071e-06,   3.869128858828215e-08,  -5.762243505116983e-10,   6.242232898708163e-12,   3.113392844238243e-14,
  -5.185788337155157e-15,   2.164277585933551e-16,  -6.203466688214814e-18,  -3.587827599788854e-03,   9.196506078932265e-05,  -1.764529842032598e-06,   2.972911044112184e-08,
  -4.426621388827716e-10,   4.788720144015015e-12,   2.430547918244723e-14,  -3.998260708789952e-15,   1.666272739640864e-16,  -4.769670566176523e-18,  -2.416528408670253e-03,
   6.194363615531115e-05,  -1.188551278437935e-06,   2.002505125565381e-08,  -2.981224791507536e-10,   3.221567237174314e-12,   1.657510254130638e-14,  -2.700413503546285e-15,
   1.124128921946696e-16,  -3.214418953095998e-18,  -1.334307503255674e-03,   3.420333910286481e-05,  -6.562940038733906e-07,   1.105746961828141e-08,  -1.646026187413870e-10,
   1.777602914692221e-12,   9.217305209714540e-15,  -1.493429825650998e-15,   6.212822033180773e-17,  -1.775464931724146e-18,  -5.059807858243027e-04,   1.297028525043339e-05,
  -2.488758320266343e-07,   4.193152365578272e-09,  -6.241752706433254e-11,   6.739092263840472e-13,   3.504570717779296e-15,  -5.666592268449306e-16,   2.356787110340970e-17,
  -6.733559577432710e-19,  -5.768864741655907e-05,   1.478789449775372e-06,  -2.837527521849530e-08,   4.780772751566291e-10,  -7.116419095653816e-12,   7.683148954139744e-14,
   3.997440178463298e-16,  -6.461319602797258e-17,   2.687213028609680e-18,  -7.677327476964339e-20,  -9.859659822912339e-03,   2.526844994463984e-04,  -4.844531968813033e-06,
   8.125516076341951e-08,  -1.179308124734796e-09,   1.060745529914082e-11,   2.110064152449518e-13,  -1.778856857960827e-14,   7.283376148275089e-16,  -2.218692449964887e-17,
  -9.116631327555285e-03,   2.336473226656297e-04,  -4.479651180820654e-06,   7.513458044867850e-08,  -1.090267127839962e-09,   9.791290400969024e-12,   1.960007274613469e-13,
  -1.648280955972156e-14,   6.744537363158126e-16,  -2.053368766253487e-17,  -7.743565080499251e-03,   1.984647438275973e-04,  -3.805252099423265e-06,   6.382243481516467e-08,
  -9.258260776865879e-10,   8.293174323820348e-12,   1.677314388958150e-13,  -1.404886732919435e-14,   5.742734100470824e-16,  -1.746722570160973e-17,  -5.949352878261775e-03,
   1.524857005706489e-04,  -2.923794661999350e-06,   4.903776258258456e-08,  -7.111167647162946e-10,   6.352468870267585e-12,   1.298884564634710e-13,  -1.083330924367238e-14,
   4.423533751949854e-16,  -1.344126694670901e-17,  -4.007098856872417e-03,   1.027076530550318e-04,  -1.969402397935167e-06,   3.303036268215877e-08,  -4.788600515074874e-10,
   4.268443365795778e-12,   8.802638472143051e-14,  -7.317631674602997e-15,   2.985454914357408e-16,  -9.064412982405512e-18,  -2.212554991000841e-03,   5.671194357004361e-05,
  -1.087462302438106e-06,   1.823854726854434e-08,  -2.643741711740812e-10,   2.353614191139813e-12,   4.877739766021823e-14,  -4.047195623961596e-15,   1.650372810439008e-16,
  -5.008573931801376e-18,  -8.390197192451267e-04,   2.150579593627088e-05,  -4.123805865528992e-07,   6.916289617705843e-09,  -1.002482877628649e-10,   8.920482656843334e-13,
   1.852143020584553e-14,  -1.535685517825719e-15,   6.261099132597591e-17,  -1.899803101921935e-18,  -9.565958643144412e-05,   2.451954073292238e-06,  -4.701706573651994e-08,
   7.885519368091263e-10,  -1.142957159193151e-11,   1.016968182517715e-13,   2.112158807978066e-15,  -1.751069418073404e-16,   7.139017860371092e-18,  -2.166128478605740e-19,
  -5.822182254753505e-05,   1.419752112551487e-06,  -2.595447120226807e-08,   4.204322310360256e-10,  -6.284769602854029e-12,   8.430881834009549e-14,  -8.194148299161671e-16,
  -3.929858905281986e-18,   5.580293710649680e-19,  -2.067650283584589e-20,  -5.383408263476888e-05,   1.312783670432794e-06,  -2.399962500935314e-08,   3.887761508374772e-10,
  -5.811547146732978e-12,   7.794966915817964e-14,  -7.569542985398189e-16,  -3.666431192642224e-18,   5.170004309046450e-19,  -1.913948572273368e-20,  -4.572590742063931e-05,
   1.115098308294673e-06,  -2.038654057029439e-08,   3.302610104041377e-10,  -4.936821504124700e-12,   6.620173888939607e-14,  -6.419583748431967e-16,  -3.159900202797844e-18,
   4.405630591110821e-19,  -1.628635349102771e-20,  -3.513091575553687e-05,   8.567540871422056e-07,  -1.566414939171627e-08,   2.537700225564700e-10,  -3.793396359928210e-12,
   5.085612493207602e-14,  -4.924055457412502e-16,  -2.465014025303015e-18,   3.396478771329507e-19,  -1.253674607987982e-20,  -2.366183973777191e-05,   5.770689783836220e-07,
  -1.055101638516180e-08,   1.709398500560547e-10,  -2.555226694770920e-12,   3.424996584016326e-14,  -3.312230532614292e-16,  -1.680051183337671e-18,   2.293823941385902e-19,
  -8.456643084264694e-21,  -1.306507120487943e-05,   3.186384774859323e-07,  -5.826047008683035e-09,   9.439129797891488e-11,  -1.410967550668291e-12,   1.891032480502428e-14,
  -1.827507213668001e-16,  -9.339616161351462e-19,   1.268523334362887e-19,  -4.673453735272520e-21,  -4.954383219725511e-06,   1.208311040062518e-07,  -2.209316638824449e-09,
   3.579474706436934e-11,  -5.350618272658511e-13,   7.170800052730636e-15,  -6.928111029044955e-17,  -3.550645414096404e-19,   4.813151466960092e-20,  -1.772789003569114e-21,
  -5.648665798855609e-07,   1.377639153886753e-08,  -2.518925190669634e-10,   4.081099293185281e-12,  -6.100448507168428e-14,   8.175651546439351e-16,  -7.898613815089728e-18,
  -4.049913578201718e-20,   5.488172841205865e-21,  -2.021327784054145e-22,  -5.296446055570041e-04,   1.291548565282625e-05,  -2.361050749350129e-07,   3.824313407852138e-09,
  -5.714083117029610e-11,   7.647806343009096e-13,  -7.333100515227499e-15,  -4.134024357027355e-17,   5.292908588708487e-18,  -1.951344724070116e-19,  -4.897292837371764e-04,
   1.194239363417848e-05,  -2.183220378416988e-07,   3.536364107214833e-09,  -5.283823672224808e-11,   7.070903345516599e-13,  -6.773758953130863e-15,  -3.853362349432388e-17,
   4.903723179642769e-18,  -1.806312905929540e-19,  -4.159691181185960e-04,   1.014404973822777e-05,  -1.854541810295098e-07,   3.004100612733765e-09,  -4.488517485948548e-11,
   6.005161158286547e-13,  -5.744177065077572e-15,  -3.316098503234635e-17,   4.178682758351171e-18,  -1.537078744153904e-19,  -3.195863540429281e-04,   7.793892203238300e-06,
  -1.424950835591120e-07,   2.308326753662229e-09,  -3.448915848260709e-11,   4.613099684895206e-13,  -4.405570478213359e-15,  -2.582916466976146e-17,   3.221486727996903e-18,
  -1.183224677273617e-19,  -2.152520344540575e-04,   5.249596650097060e-06,  -9.598145703652155e-08,   1.554891632038161e-09,  -2.323180353739296e-11,   3.106742252207623e-13,
  -2.963239643651045e-15,  -1.758346433513383e-17,   2.175627384922239e-18,  -7.981570739172571e-20,  -1.188531064207670e-04,   2.898654305065367e-06,  -5.299891907402827e-08,
   8.585956301341024e-10,  -1.282832651357618e-11,   1.715305470233690e-13,  -1.634881246284340e-15,  -9.768371528062750e-18,   1.203153889798403e-18,  -4.410957963615686e-20,
  -4.507008241871856e-05,   1.099200580372065e-06,  -2.009791411379347e-08,   3.255936894893945e-10,  -4.864707757639936e-12,   6.504428158303543e-14,  -6.197760138835258e-16,
  -3.712726215691975e-18,   4.565113786928866e-19,  -1.673222709073760e-20,  -5.138597920580869e-06,   1.253238369077115e-07,  -2.291438952433556e-09,   3.712221114769779e-11,
  -5.546442577197566e-13,   7.415897518428802e-15,  -7.065934609933139e-17,  -4.234611788520880e-19,   5.205347796675600e-20,  -1.907803905133201e-21,  -1.505021566853772e-03,
   3.670014003814471e-05,  -6.708896106092774e-07,   1.086475983553208e-08,  -1.621688056077149e-10,   2.159378297743744e-12,  -2.006714107612419e-14,  -1.531840711320787e-16,
   1.643090033776220e-17,  -6.000314331919563e-19,  -1.391599434267773e-03,   3.393503942106217e-05,  -6.203592807509916e-07,   1.004669854295798e-08,  -1.499573104612666e-10,
   1.996454259372870e-12,  -1.853408321109686e-14,  -1.425891634021335e-16,   1.522262571868345e-17,  -5.554514821990168e-19,  -1.182004850513402e-03,   2.882493519635729e-05,
  -5.269656117120469e-07,   8.534546475127904e-09,  -1.273854666127508e-10,   1.695496824586046e-12,  -1.571361277856046e-14,  -1.224382439564119e-16,   1.297172184335088e-17,
  -4.726839382914943e-19,  -9.081265982124421e-04,   2.214681906131240e-05,  -4.048978419029701e-07,   6.557870082009984e-09,  -9.788069471212070e-11,   1.302423513857188e-12,
  -1.204900013015017e-14,  -9.514989066305717e-17,   1.000020656106757e-17,  -3.638855930287827e-19,  -6.116534550216783e-04,   1.491704820380929e-05,  -2.727299726561669e-07,
   4.417385432557187e-09,  -6.593186908380300e-11,   8.771107159956276e-13,  -8.102835641260422e-15,  -6.466041567825435e-17,   6.753560925553335e-18,  -2.454731820961837e-19,
  -3.377292731668023e-04,   8.236702467290808e-06,  -1.505956797561382e-07,   2.439234965311819e-09,  -3.640670040320675e-11,   4.842668845196058e-13,  -4.470035220677335e-15,
  -3.588573526299021e-17,   3.734797231042284e-18,  -1.356622516296061e-19,  -1.280697377814091e-04,   3.123445280042572e-06,  -5.710793754161989e-08,   9.249981515495519e-10,
  -1.380599269751666e-11,   1.836327784973807e-13,  -1.694503122811983e-15,  -1.363423265834988e-17,   1.417087084463902e-18,  -5.146165682831861e-20,  -1.460167927178794e-05,
   3.561153020463008e-07,  -6.511091214753176e-09,   1.054626572631156e-10,  -1.574074681084126e-12,   2.093651711725149e-14,  -1.931854362428857e-16,  -1.554979269321701e-18,
   1.615825783267252e-19,  -5.867652640779177e-21,  -3.063680156279095e-03,   7.470785756616435e-05,  -1.365618320321247e-06,   2.210827129588144e-08,  -3.293716485105393e-10,
   4.344167896580162e-12,  -3.795074356705612e-14,  -4.473676511953869e-16,   3.878181072938154e-17,  -1.398546198428837e-18,  -2.832793669572105e-03,   6.907913830858721e-05,
  -1.262761941424958e-06,   2.044360837001017e-08,  -3.045677170399887e-10,   4.016272880151539e-12,  -3.504189393482599e-14,  -4.158646207696166e-16,   3.592983291061817e-17,
  -1.294713555254508e-18,  -2.406134817887043e-03,   5.867686217399685e-05,  -1.072655748452836e-06,   1.736656200651593e-08,  -2.587210210045226e-10,   3.410654771902903e-12,
  -2.969595677860836e-14,  -3.563163435980901e-16,   3.061692624268202e-17,  -1.101892052604177e-18,  -1.848617644402483e-03,   4.508269674052844e-05,  -8.241825837256182e-07,
   1.334428733173482e-08,  -1.987944278837779e-10,   2.619801993791678e-12,  -2.275956146314161e-14,  -2.762749003277230e-16,   2.360322427281980e-17,  -8.483522243645148e-19,
  -1.245105439669072e-03,   3.036556822034657e-05,  -5.551505144637496e-07,   8.988706872486219e-09,  -1.339056396439697e-10,   1.764214125405466e-12,  -1.529977215398857e-14,
  -1.874172258190417e-16,   1.594021039478079e-17,  -5.723337444143167e-19,  -6.874947755152713e-04,   1.676686593485450e-05,  -3.065422472504609e-07,   4.963467504491699e-09,
  -7.394054917598598e-11,   9.740257907024120e-13,  -8.438462126319745e-15,  -1.039102316262665e-16,   8.815108240266681e-18,  -3.163180123075171e-19,  -2.607037132703328e-04,
   6.358174064592294e-06,  -1.162449993330818e-07,   1.882228171272954e-09,  -2.803936611305328e-11,   3.693445400080836e-13,  -3.198591460172134e-15,  -3.946435173965277e-17,
   3.344698247823085e-18,  -1.199930321905348e-19,  -2.972374326562596e-05,   7.249184386480424e-07,  -1.325353043099900e-08,   2.146001842710534e-10,  -3.196875716167569e-12,
   4.210999761265572e-14,  -3.646572210721684e-16,  -4.500616854494804e-18,   3.813773536530283e-19,  -1.368163121816045e-20,  -5.379703330069617e-03,   1.311829277458054e-04,
  -2.397747293466717e-06,   3.879401575389315e-08,  -5.759374700822433e-10,   7.458513870813639e-12,  -5.697211586779631e-14,  -1.244760291475242e-15,   8.652419293523870e-17,
  -3.082878127174695e-18,  -4.974275618528348e-03,   1.212991996999232e-04,  -2.217151826478116e-06,   3.587291071555568e-08,  -5.325591837941791e-10,   6.895105759796291e-12,
  -5.257024002844822e-14,  -1.155824811693664e-15,   8.016311251415818e-17,  -2.854312795816824e-18,  -4.225079237184294e-03,   1.030333649342580e-04,  -1.883363319892188e-06,
   3.047343795968325e-08,  -4.523840883466213e-10,   5.854764634742344e-12,  -4.450115107934582e-14,  -9.885426005983883e-16,   6.831205546918217e-17,  -2.429664239582610e-18,
  -3.246100733403596e-03,   7.916274875994413e-05,  -1.447094713162544e-06,   2.341539194335211e-08,  -3.475928792981138e-10,   4.496671381349745e-12,  -3.406638935771364e-14,
  -7.650425541837526e-16,   5.266531429217015e-17,  -1.870973350231075e-18,  -2.186356751988920e-03,   5.332027409256219e-05,  -9.747294713997155e-07,   1.577255455994215e-08,
  -2.341307627681352e-10,   3.027856660085212e-12,  -2.287923640150804e-14,  -5.182279020947991e-16,   3.556815763075238e-17,  -1.262429132129789e-18,  -1.207214099219667e-03,
   2.944169722514848e-05,  -5.382246543294122e-07,   8.709421200843240e-09,  -1.292820432042991e-10,   1.671599053561503e-12,  -1.261201763069720e-14,  -2.870832605965358e-16,
   1.966994242390900e-17,  -6.977820880407914e-19,  -4.577855852601622e-04,   1.116460492578121e-05,  -2.041021090056599e-07,   3.302753139059597e-09,  -4.902551840920974e-11,
   6.338477314147771e-13,  -4.779598919328832e-15,  -1.089982071693228e-16,   7.463378048850475e-18,  -2.647075211244763e-19,  -5.219373761427287e-05,   1.272917016182941e-06,
  -2.327045025075147e-08,   3.765597449623437e-10,  -5.589584193191991e-12,   7.226650980774195e-14,  -5.448824287450465e-16,  -1.242979742455266e-17,   8.510085171845679e-19,
  -3.018217364457242e-20,  -8.920689119521373e-03,   2.175249533321079e-04,  -3.975158121571642e-06,   6.422842388669352e-08,  -9.459181390626128e-10,   1.171602227828728e-11,
  -5.631719269922234e-14,  -3.936014809980053e-15,   2.216477709864890e-16,  -7.912306344595346e-18,  -8.248403945948383e-03,   2.011359360838879e-04,  -3.675751543662106e-06,
   5.939188035144758e-08,  -8.746488659033140e-10,   1.082915872898663e-11,  -5.179712046608230e-14,  -3.651894066400859e-15,   2.053786373165842e-16,  -7.327706795452709e-18,
  -7.006077397118573e-03,   1.708478708019945e-04,  -3.122369918392683e-06,   5.045201418789183e-08,  -7.429384680412162e-10,   9.192660976321251e-12,  -4.361044140513705e-14,
  -3.119328345337155e-15,   1.750524701879860e-16,  -6.240355950119360e-18,  -5.382723378684453e-03,   1.312660756047554e-04,  -2.399090908514186e-06,   3.876634595447599e-08,
  -5.708141907344301e-10,   7.058185317570021e-12,  -3.319086091735801e-14,  -2.410816647446281e-15,   1.349868289083968e-16,  -4.807720501005111e-18,  -3.625443106016897e-03,
   8.841459633444642e-05,  -1.615970589231090e-06,   2.611275039100125e-08,  -3.844725176989813e-10,   4.751542893170338e-12,  -2.218798555082506e-14,  -1.631333363995667e-15,
   9.118083967043337e-17,  -3.245208913675834e-18,  -2.001816955446876e-03,   4.881962216481117e-05,  -8.923037438696092e-07,   1.441910226072690e-08,  -2.122927491787722e-10,
   2.622842018529509e-12,  -1.219793217165156e-14,  -9.031676705938565e-16,   5.042999382023669e-17,  -1.794114347178863e-18,  -7.591055686060468e-04,   1.851291991962857e-05,
  -3.383736488228823e-07,   5.467948569724926e-09,  -8.050362563474166e-11,   9.944951124409958e-13,  -4.617956594074216e-15,  -3.428325943250252e-16,   1.913540459942377e-17,
  -6.806629648840875e-19,  -8.654828403434601e-05,   2.110724997635734e-06,  -3.857925301519389e-08,   6.234219586817260e-10,  -9.178508882870960e-12,   1.133838226583804e-13,
  -5.263657304869782e-16,  -3.909404574249414e-17,   2.181920040133297e-18,  -7.761081501524876e-20,  -5.292838601069620e-05,   1.230708775046815e-06,  -2.146047117015138e-08,
   3.322881662802055e-10,  -4.796188740914604e-12,   6.477879880203067e-14,  -7.667425239467269e-16,   5.344913822913763e-18,   1.046849172571233e-19,  -6.574336167977390e-21,
  -4.893947854454768e-05,   1.137979193978577e-06,  -1.984400012702142e-08,   3.072680280712352e-10,  -4.435146099109760e-12,   5.990051243866504e-14,  -7.088128880846968e-16,
   4.931529950848747e-18,   9.721223297505275e-20,  -6.090819353316872e-21,  -4.156836899012578e-05,   9.666108307993339e-07,  -1.685638810364600e-08,   2.610196720845855e-10,
  -3.767721783244242e-12,   5.088365964074812e-14,  -6.018513963783896e-16,   4.173999695602023e-18,   8.315219027649797e-20,  -5.190112331074150e-21,  -3.193659933320385e-05,
   7.426631359900816e-07,  -1.295161107189646e-08,   2.005646214922465e-10,  -2.895181758844024e-12,   3.909765695775667e-14,  -4.622313653572541e-16,   3.194791295652116e-18,
   6.435990178488808e-20,  -4.001113942479040e-21,  -2.151030480020149e-05,   5.002201625583747e-07,  -8.723848643771944e-09,   1.351001469201821e-10,  -1.950247973686680e-12,
   2.633572516707186e-14,  -3.112392925894749e-16,   2.145391400901699e-18,   4.360039430900939e-20,  -2.702086888121265e-21,  -1.187706619499236e-05,   2.762042793177157e-07,
  -4.817103634097510e-09,   7.460081872642771e-11,  -1.076923412318547e-12,   1.454216294232472e-14,  -1.718248298623387e-16,   1.182550699365426e-18,   2.415462092354602e-20,
  -1.494274691601635e-21,  -4.503879309978418e-06,   1.047394882516907e-07,  -1.826708650665329e-09,   2.828984764366143e-11,  -4.083894737538769e-13,   5.514606062284727e-15,
  -6.515335013481087e-17,   4.481417752261985e-19,   9.171073986397109e-21,  -5.669683451752944e-22,  -5.135030030183481e-07,   1.194172598948923e-08,  -2.082698856124720e-10,
   3.225435919424564e-12,  -4.656212556225401e-14,   6.287413885340060e-16,  -7.428285054275507e-18,   5.108870765484921e-20,   1.045842526619380e-21,  -6.464822686560546e-23,
  -4.814901850560679e-04,   1.119576932435082e-05,  -1.952254570531717e-07,   3.022742320038811e-09,  -4.362313818669345e-11,   5.887377539455065e-13,  -6.942926679902668e-15,
   4.706818526164361e-17,   1.016154943002905e-18,  -6.204737544276436e-20,  -4.452030442487448e-04,   1.035220743969345e-05,  -1.805204517308638e-07,   2.795140141225742e-09,
  -4.033929911335244e-11,   5.444003694208494e-13,  -6.418283634502401e-15,   4.342124356311443e-17,   9.434976447355299e-19,  -5.748406261620290e-20,  -3.781479690195722e-04,
   8.793267810185690e-06,  -1.533422050971436e-07,   2.374430116498705e-09,  -3.426879853830167e-11,   4.624495553417925e-13,  -5.449631600476712e-15,   3.674206572266615e-17,
   8.068684947316469e-19,  -4.898339568509231e-20,  -2.905276407758814e-04,   6.756013512743227e-06,  -1.178205288768992e-07,   1.824485495545875e-09,  -2.633270644075534e-11,
   3.553323886091039e-13,  -4.185306324324995e-15,   2.811489281361435e-17,   6.243805133469193e-19,  -3.776187101628010e-20,  -1.956795098971418e-04,   4.550507502635534e-06,
  -7.936066324191471e-08,   1.228971626942864e-09,  -1.773818551587680e-11,   2.393468940183462e-13,  -2.818086620942931e-15,   1.887588888418569e-17,   4.229124381330649e-19,
  -2.550188465102663e-20,  -1.080458186666963e-04,   2.512632912914344e-06,  -4.382108761911196e-08,   6.786246006926079e-10,  -9.794990042674131e-12,   1.321632245128787e-13,
  -1.555755201755196e-15,   1.040319186271937e-17,   2.342706943190168e-19,  -1.410274450117545e-20,  -4.097184601163935e-05,   9.528161041630582e-07,  -1.661752904636546e-08,
   2.573455143315260e-10,  -3.714442615029206e-12,   5.011823601691806e-14,  -5.899162636865236e-16,   3.942229601848593e-18,   8.894511852958998e-20,  -5.350964839898786e-21,
  -4.671343195073682e-06,   1.086339930007879e-07,  -1.894626639232380e-09,   2.934096614892802e-11,  -4.234985232350184e-13,   5.714171583795159e-15,  -6.725768169785696e-17,
   4.494154763974006e-19,   1.014298072301766e-20,  -6.101405900065730e-22,  -1.368187682874165e-03,   3.181353028443367e-05,  -5.547421657321613e-07,   8.588784027134610e-09,
  -1.239087913450171e-10,   1.669433919472782e-12,  -1.952548222998995e-14,   1.238775608897621e-16,   3.294485826629906e-18,  -1.906717047938745e-19,  -1.265075260763997e-03,
   2.941649247326904e-05,  -5.129571999119100e-07,   7.942076387751143e-09,  -1.145811215979150e-10,   1.543701197908039e-12,  -1.804949483296113e-14,   1.142356596102842e-16,
   3.058207218585364e-18,  -1.766492504174664e-19,  -1.074533623613257e-03,   2.498666074712696e-05,  -4.357289387687221e-07,   6.746674039773073e-09,  -9.733808219680833e-11,
   1.311309045190449e-12,  -1.532469446046584e-14,   9.660256900117081e-17,   2.614349823329441e-18,  -1.505274700646389e-19,  -8.255543969167712e-04,   1.919766582159989e-05,
  -3.347924447216657e-07,   5.184066998768768e-09,  -7.479602855482682e-11,   1.007560384342236e-12,  -1.176871592585204e-14,   7.386988127363753e-17,   2.022261410908428e-18,
  -1.160441163694503e-19,  -5.560368690308156e-04,   1.293057242777493e-05,  -2.255069619863071e-07,   3.491981485477165e-09,  -5.038387326513235e-11,   6.786730621956341e-13,
  -7.923884438134788e-15,   4.956837160625897e-17,   1.369316589796950e-18,  -7.836896422786235e-20,  -3.070196708212880e-04,   7.139815016347356e-06,  -1.245196264145716e-07,
   1.928233433091419e-09,  -2.782184727586770e-11,   3.747498212315981e-13,  -4.374361063886077e-15,   2.731039925514586e-17,   7.583930794938566e-19,  -4.333878789056545e-20,
  -1.164243358050952e-04,   2.707490890610406e-06,  -4.721946910472000e-08,   7.312175179172385e-10,  -1.055055894901622e-11,   1.421103899076233e-13,  -1.658669331584211e-15,
   1.034789918492563e-17,   2.879185943508909e-19,  -1.644393339842184e-20,  -1.327394495832511e-05,   3.086907800342540e-07,  -5.383668275420334e-09,   8.336896134488562e-11,
  -1.202911538617989e-12,   1.620254387343993e-14,  -1.891083427047516e-16,   1.179640860976354e-18,   3.283283825811722e-20,  -1.875010096815359e-21,  -2.785136584227170e-03,
   6.476078785616171e-05,  -1.129238582727205e-06,   1.748165941090073e-08,  -2.520517795364146e-10,   3.385389662401869e-12,  -3.898965192400129e-14,   2.151591864069704e-16,
   8.245150935930179e-18,  -4.429720837968523e-19,  -2.575236887144138e-03,   5.988128959093083e-05,  -1.044180649151395e-06,   1.616534140963252e-08,  -2.330772092346654e-10,
   3.130386814280754e-12,  -3.604024303837922e-14,   1.982343110486723e-16,   7.651518344082604e-18,  -4.104002501717292e-19,  -2.187362845857504e-03,   5.086376148597094e-05,
  -8.869739847821607e-07,   1.373220571652071e-08,  -1.980012963827587e-10,   2.659084547844401e-12,  -3.059661980791328e-14,   1.673859644003122e-16,   6.537814789827436e-18,
  -3.497204413042822e-19,  -1.680530952589035e-03,   3.907947114436763e-05,  -6.815066395211918e-07,   1.055166303877317e-08,  -1.521465819887580e-10,   2.043101811110374e-12,
  -2.349454390906045e-14,   1.277917294801448e-16,   5.054569686853636e-18,  -2.696115425629629e-19,  -1.131890487508203e-03,   2.632194630282023e-05,  -4.590440569585671e-07,
   7.107584502511505e-09,  -1.024882224080615e-10,   1.376173203546047e-12,  -1.581763622918723e-14,   8.564195538677164e-17,   3.421196111265013e-18,  -1.820821919965187e-19,
  -6.249812991735683e-04,   1.453406860671732e-05,  -2.534732935606439e-07,   3.924728213681585e-09,  -5.659364268724521e-11,   7.598890694163491e-13,  -8.731686426042699e-15,
   4.715067994066258e-17,   1.894390490094746e-18,  -1.006942739303078e-19,  -2.369979501493709e-04,   5.511467483729584e-06,  -9.612038305238847e-08,   1.488320694957563e-09,
  -2.146134235930116e-11,   2.881596680710847e-13,  -3.310821905795033e-15,   1.786037944000023e-17,   7.191307201884447e-19,  -3.820634325119205e-20,  -2.702096364747185e-05,
   6.283822420975898e-07,  -1.095904434090992e-08,   1.696892447153036e-10,  -2.446893458713820e-12,   3.285415777060508e-14,  -3.774726156362612e-16,   2.035954866993206e-18,
   8.200501778843294e-20,  -4.356459340552704e-21,  -4.890594100881052e-03,   1.137172215064560e-04,  -1.982848430259992e-06,   3.069074753607751e-08,  -4.420102004602941e-10,
   5.902606115881658e-12,  -6.598639591807133e-14,   2.551694999138140e-16,   1.965318197503871e-17,  -9.656097265042476e-19,  -4.522018199397101e-03,   1.051490267767480e-04,
  -1.833493664016891e-06,   2.837980545863571e-08,  -4.087338795712013e-10,   5.457883168355609e-12,  -6.098771526253472e-14,   2.343956253607753e-16,   1.823239720903202e-17,
  -8.946451014464944e-19,  -3.840926105881485e-03,   8.931462536023759e-05,  -1.557451727400725e-06,   2.410817716770206e-08,  -3.472210709650526e-10,   4.636003100366506e-12,
  -5.176606166976534e-14,   1.969364888584453e-16,   1.557055396003782e-17,  -7.624188677857310e-19,  -2.950948542222442e-03,   6.862190628786182e-05,  -1.196668171263654e-06,
   1.852441486959232e-08,  -2.668070317200866e-10,   3.561934968816226e-12,  -3.974205480203564e-14,   1.495440583243176e-16,   1.203150486996864e-17,  -5.878173907060334e-19,
  -1.987556716150043e-03,   4.622022916455514e-05,  -8.060425480046192e-07,   1.247800718163407e-08,  -1.797242544176108e-10,   2.399146522415252e-12,  -2.675192819541427e-14,
   9.978775806093393e-17,   8.140108571366408e-18,  -3.970051527165374e-19,  -1.097443429201772e-03,   2.552121220599257e-05,  -4.450776402378833e-07,   6.890211672863202e-09,
  -9.924280375075634e-11,   1.324728137533253e-12,  -1.476628553520062e-14,   5.480022885358967e-17,   4.506263517352146e-18,  -2.195572271280944e-19,  -4.161594009716038e-04,
   9.677904699394869e-06,  -1.687792492222213e-07,   2.612879692349649e-09,  -3.763463867404998e-11,   5.023507857499925e-13,  -5.598784758211423e-15,   2.073818720821289e-17,
   1.710470477170821e-18,  -8.330744349585376e-20,  -4.744778610030348e-05,   1.103412742480604e-06,  -1.924315332037307e-08,   2.979045906234049e-10,  -4.290874809699580e-12,
   5.727482697391444e-14,  -6.383235757952746e-16,   2.363629703247740e-18,   1.950480689030462e-19,  -9.499109408691360e-21,  -8.109650999545989e-03,   1.885665566499863e-04,
  -3.287804449170949e-06,   5.086896076648955e-08,  -7.308237110952737e-10,   9.631878143613499e-12,  -1.000215260252641e-13,  -5.396380897806802e-17,   5.333823334346514e-17,
  -2.382316369852757e-18,  -7.498473316533276e-03,   1.743587233139188e-04,  -3.040155473491253e-06,   4.703857821251038e-08,  -6.757982623592588e-10,   8.905739422301289e-12,
  -9.241530686763039e-14,  -5.369446541787579e-17,   4.946930470006836e-17,  -2.207546765686618e-18,  -6.369076945257324e-03,   1.481020231115635e-04,  -2.582443584051424e-06,
   3.995840238981428e-08,  -5.740848452175627e-10,   7.564046845249249e-12,  -7.840072576966025e-14,  -5.091139225941930e-17,   4.222904047174872e-17,  -1.881713214584719e-18,
  -4.893303794437292e-03,   1.137892343205368e-04,  -1.984220109788544e-06,   3.070344759238527e-08,  -4.411237565186768e-10,   5.811108156282790e-12,  -6.015666099364031e-14,
  -4.344808697591866e-17,   3.261619922142587e-17,  -1.451139165449537e-18,  -3.295794103411452e-03,   7.664264433201580e-05,  -1.336515386290045e-06,   2.068173698539464e-08,
  -2.971422956060826e-10,   3.913813591352732e-12,  -4.047599861327561e-14,  -3.156514517234132e-17,   2.205935704241369e-17,  -9.802725967858034e-19,  -1.819795908206221e-03,
   4.231941722218114e-05,  -7.379920918365307e-07,   1.142020350999798e-08,  -1.640792609990556e-10,   2.160991240883513e-12,  -2.233588832152838e-14,  -1.816331092525592e-17,
   1.220936076081344e-17,  -5.421843610812097e-19,  -6.900812876813764e-04,   1.604795576746118e-05,  -2.798562160677316e-07,   4.330723979027050e-09,  -6.222161011758908e-11,
   8.194583730138669e-13,  -8.468064885227127e-15,  -6.992320709892143e-18,   4.634038556086097e-18,  -2.057317312464535e-19,  -7.867857664961430e-05,   1.829685186912644e-06,
  -3.190745336599530e-08,   4.937626731215006e-10,  -7.094130020791258e-12,   9.342917848642551e-14,  -9.654380194791111e-16,  -7.991970814061930e-19,   5.284213677395120e-19,
  -2.345866990895198e-20,  -4.832538431970208e-05,   1.073762514344955e-06,  -1.789378168775910e-08,   2.649693091794959e-10,  -3.671299515546715e-12,   4.838142104181905e-14,
  -5.963354711425330e-16,   6.171114686625148e-18,  -2.324860944352965e-20,  -1.471313112323598e-21,  -4.468330371459372e-05,   9.928549934603240e-07,  -1.654587873194597e-08,
   2.450166154785869e-10,  -3.394941844378474e-12,   4.474000265687191e-14,  -5.514102534719036e-16,   5.703564501986258e-18,  -2.136356574007095e-20,  -1.365053074870927e-21,
  -3.795314137967425e-05,   8.433363069593232e-07,  -1.405469477143167e-08,   2.081360191858392e-10,  -2.884062423433055e-12,   3.800810966515638e-14,  -4.683823013632939e-16,
   4.841060466467228e-18,  -1.796021090297154e-20,  -1.165908126171429e-21,  -2.915896778768436e-05,   6.479455352345711e-07,  -1.079883100213323e-08,   1.599277854721687e-10,
  -2.216170616539204e-12,   2.920674719520512e-14,  -3.598729847350917e-16,   3.716520179678275e-18,  -1.364703082909896e-20,  -9.010259702869696e-22,  -1.963943742368157e-05,
   4.364212160426999e-07,  -7.273743248767885e-09,   1.077263511100496e-10,  -1.492857696535672e-12,   1.967455753845187e-14,  -2.423958200836862e-16,   2.501692778820452e-18,
  -9.111181842797291e-21,  -6.096659773270887e-22,  -1.084403922989509e-05,   2.409760751728480e-07,  -4.016373035887807e-09,   5.948503515195127e-11,  -8.243546714730115e-13,
   1.086436730706112e-14,  -1.338437346852675e-16,   1.380848138630933e-18,  -5.005111588953158e-21,  -3.375233047678047e-22,  -4.112145104684770e-06,   9.138050291503585e-08,
  -1.523058783641025e-09,   2.255765689378990e-11,  -3.126108818255929e-13,   4.119986970820400e-15,  -5.075507459559483e-17,   5.235604556306623e-19,  -1.894317997208830e-21,
  -1.281186246294199e-22,  -4.688399800549468e-07,   1.041861829535889e-08,  -1.736495839481140e-10,   2.571885747677231e-12,  -3.564202692163035e-14,   4.697365776377792e-16,
  -5.786771747631412e-18,   5.969166407835187e-20,  -2.159086092486397e-22,  -1.460965342677579e-23,  -4.396166292634114e-04,   9.768030282323126e-06,  -1.627797952312501e-07,
   2.410408986521207e-09,  -3.339600097823911e-11,   4.399913065917509e-13,  -5.416810813936577e-15,   5.573427078574385e-17,  -1.941403314401372e-19,  -1.402745275941162e-20,
  -4.064845761604284e-04,   9.032013605958722e-06,  -1.505179167869370e-07,   2.228900539621233e-09,  -3.088210635707352e-11,   4.068750836055426e-13,  -5.008711606848581e-15,
   5.151042225145220e-17,  -1.782588770975796e-19,  -1.301374847709913e-20,  -3.452602047002426e-04,   7.671840344482832e-06,  -1.278556068817807e-07,   1.893400022818551e-09,
  -2.623488176463974e-11,   3.456533141104138e-13,  -4.254501142868204e-15,   4.371926675504186e-17,  -1.496641054025580e-19,  -1.111432985036761e-20,  -2.652594968667045e-04,
   5.894368183340124e-06,  -9.823700236270285e-08,   1.454852744175023e-09,  -2.015939617935308e-11,   2.656115590524161e-13,  -3.268844045779181e-15,   3.356227542793468e-17,
  -1.135594145601810e-19,  -8.588566069761788e-21,  -1.786602093580341e-04,   3.970128952838073e-06,  -6.616926677874978e-08,   9.799796286618103e-10,  -1.357977699834799e-11,
   1.789238444451105e-13,  -2.201747677997955e-15,   2.259098072554605e-17,  -7.572850739800617e-20,  -5.810955810805192e-21,  -9.864836131882972e-05,   2.192162199234553e-06,
  -3.653695890952702e-08,   5.411314950331493e-10,  -7.498739585822295e-12,   9.880237378055384e-14,  -1.215735228710841e-15,   1.246921315899633e-17,  -4.157239378309515e-20,
  -3.216943842877294e-21,  -3.740823575791976e-05,   8.312895131826681e-07,  -1.385527082337128e-08,   2.052055356698462e-10,  -2.843663725682957e-12,   3.746784075870376e-14,
  -4.610201151601002e-16,   4.727776820143794e-18,  -1.573015748780429e-20,  -1.221085385859629e-21,  -4.265043197681966e-06,   9.477829355685044e-08,  -1.579690842806793e-09,
   2.339627711891925e-11,  -3.242175628309254e-13,   4.271861691944177e-15,  -5.256257897057423e-17,   5.390180626522765e-19,  -1.792799340700773e-21,  -1.392427828457014e-22,
  -1.249201124712470e-03,   2.775653000763723e-05,  -4.625490607105244e-07,   6.849218196498576e-09,  -9.488541570405076e-11,   1.249417292304794e-12,  -1.534148174758685e-14,
   1.558182101790412e-16,  -4.416814104571643e-19,  -4.395112711219965e-20,  -1.155054099175342e-03,   2.566508797268463e-05,  -4.277061562081174e-07,   6.333458483145796e-09,
  -8.774285309903168e-11,   1.155376826898533e-12,  -1.418552947164203e-14,   1.440018921877365e-16,  -4.045799305463640e-19,  -4.077127570415095e-20,  -9.810808037545562e-04,
   2.180006206003963e-05,  -3.633097686043835e-07,   5.380127588595922e-09,  -7.453902073477018e-11,   9.815261389398223e-13,  -1.204928835045254e-14,   1.222104684849275e-16,
  -3.383162210902109e-19,  -3.481538342665801e-20,  -7.537532470506553e-04,   1.674925262796093e-05,  -2.791466327949846e-07,   4.133987795747641e-09,  -5.727720382342920e-11,
   7.542348793894412e-13,  -9.257628534631146e-15,   9.380952336145321e-17,  -2.555738943804156e-19,  -2.689932561349314e-20,  -5.076753688564117e-04,   1.128139448824653e-05,
  -1.880241394488415e-07,   2.784627870195168e-09,  -3.858306310452340e-11,   5.080736556535101e-13,  -6.235444433811328e-15,   6.313919082730672e-17,  -1.698263231707937e-19,
  -1.819767742121864e-20,  -2.803161565626294e-04,   6.229179664528191e-06,  -1.038220695467138e-07,   1.537633771379237e-09,  -2.130552340065486e-11,   2.805596099670293e-13,
  -3.442988584063442e-15,   3.484854801534610e-17,  -9.303353020670817e-20,  -1.007353427215937e-20,  -1.062980948809084e-04,   2.362166326753162e-06,  -3.937062445320998e-08,
   5.830947913583022e-10,  -8.079456098872838e-12,   1.063937651772070e-13,  -1.305615271639337e-15,   1.321282640047801e-17,  -3.517401407754025e-20,  -3.823606537644248e-21,
  -1.211941588026987e-05,   2.693190398643539e-07,  -4.488790994761449e-09,   6.648089312536317e-11,  -9.211713372363153e-13,   1.213038690844308e-14,  -1.488578723875351e-16,
   1.506402196787334e-18,  -4.008326337528660e-21,  -4.360115533681657e-22,  -2.542923049327797e-03,   5.650226802805917e-05,  -9.415794327826326e-07,   1.394207961235355e-08,
  -1.931099461435607e-10,   2.540246607641043e-12,  -3.104233987024869e-14,   3.077054743594564e-16,  -4.880852454561209e-19,  -1.048765318499569e-19,  -2.351273652965568e-03,
   5.224484751743670e-05,  -8.706521079323141e-07,   1.289221201029396e-08,  -1.785733461150137e-10,   2.349040202592208e-12,  -2.870285269690432e-14,   2.843420551213029e-16,
  -4.425400031066294e-19,  -9.727688242477289e-20,  -1.997126755065547e-03,   4.437705092489779e-05,  -7.395647795013175e-07,   1.095163624740568e-08,  -1.517008744599525e-10,
   1.995565938890817e-12,  -2.437969998001910e-14,   2.412729535853024e-16,  -3.636504818015789e-19,  -8.305013016549197e-20,  -1.534369819939411e-03,   3.409542749101709e-05,
  -5.682396430696902e-07,   8.415027617165591e-09,  -1.165697045375183e-10,   1.533444550504473e-12,  -1.873067180220794e-14,   1.851696107109055e-16,  -2.693947777566186e-19,
  -6.415345247082176e-20,  -1.033443991473830e-03,   2.296484360701293e-05,  -3.827478300598759e-07,   5.668308224262663e-09,  -7.852359693956306e-11,   1.032965870269767e-12,
  -1.261567463491113e-14,   1.246122092014482e-16,  -1.761382684948089e-19,  -4.339344049245914e-20,  -5.706226172597568e-04,   1.268035940132264e-05,  -2.113434558737962e-07,
   3.129962718630064e-09,  -4.336061718394767e-11,   5.704048261733094e-13,  -6.965824960630645e-15,   6.877187280488283e-17,  -9.556250703881131e-20,  -2.401870406817269e-20,
  -2.163845917876595e-04,   4.808517267326728e-06,  -8.014407568363498e-08,   1.186930811901238e-09,  -1.644316008104319e-11,   2.163085816693620e-13,  -2.641495688920425e-15,
   2.607405473987090e-17,  -3.599677379944484e-20,  -9.116450383316347e-21,  -2.467076066495137e-05,   5.482362689127138e-07,  -9.137523470245260e-09,   1.353265733272511e-10,
  -1.874750857654302e-12,   2.466221879631280e-14,  -3.011661191443936e-16,   2.972703369651402e-18,  -4.099556501549302e-21,  -1.039556432038201e-21,  -4.465276880758429e-03,
   9.921579214106993e-05,  -1.653366483055131e-06,   2.448032266616816e-08,  -3.389590515831045e-10,   4.450629431199337e-12,  -5.390564249169836e-14,   5.094578468337550e-16,
   4.962977398162780e-19,  -2.356033114821066e-19,  -4.128747774842965e-03,   9.173992658224570e-05,  -1.528821605272176e-06,   2.263689909921959e-08,  -3.134430828440951e-10,
   4.115599261792033e-12,  -4.984140504051957e-14,   4.706767987957360e-16,   4.776637468920253e-19,  -2.185016397273154e-19,  -3.506879190275336e-03,   7.792438054431838e-05,
  -1.298638755352042e-06,   1.922951673010684e-08,  -2.662742991508331e-10,   3.496261460422081e-12,  -4.233208019531831e-14,   3.992452839808814e-16,   4.319332125899469e-19,
  -1.865052082056489e-19,  -2.694295480651633e-03,   5.987024827658294e-05,  -9.978003455222268e-07,   1.477558753762431e-08,  -2.046095580693337e-10,   2.686586194483455e-12,
  -3.252139073290279e-14,   3.062952968520514e-16,   3.532640652837859e-19,  -1.440361893691638e-19,  -1.814688635706786e-03,   4.032537455857551e-05,  -6.720859928813015e-07,
   9.952737648883880e-09,  -1.378287005693551e-10,   1.809733546735822e-12,  -2.190312663568765e-14,   2.060650211345525e-16,   2.493067183138859e-19,  -9.740887279509895e-20,
  -1.001991774348742e-03,   2.226621919441814e-05,  -3.711085016373286e-07,   5.495765541954289e-09,  -7.610873453686983e-11,   9.993313725561810e-13,  -1.209362667321853e-14,
   1.137053873739452e-16,   1.412850927874170e-19,  -5.391129861736410e-20,  -3.799631744347075e-04,   8.443569777233009e-06,  -1.407289736491680e-07,   2.084080120999782e-09,
  -2.886185022910850e-11,   3.789650880414547e-13,  -4.585952312912961e-15,   4.310732979495986e-17,   5.409349141978150e-20,  -2.046159351116762e-20,  -4.332092438037191e-05,
   9.626816195366079e-07,  -1.604503248920264e-08,   2.376140342768261e-10,  -3.290655498037058e-12,   4.320733239068263e-14,  -5.228595150554139e-16,   4.914615434155270e-18,
   6.177161656539304e-21,  -2.333237839668106e-21,  -7.404385994392038e-03,   1.645208487614043e-04,  -2.741596353340735e-06,   4.058857178854091e-08,  -5.615885934944140e-10,
   7.344229940121452e-12,  -8.717176152827386e-14,   7.291674700633427e-16,   6.015374122256997e-18,  -5.936749043743253e-19,  -6.846348615368280e-03,   1.521242757079855e-04,
  -2.535077111043212e-06,   3.753214502894679e-08,  -5.193122107856366e-10,   6.791273829128299e-12,  -8.059292402489127e-14,   6.732515804377941e-16,   5.606994510944477e-18,
  -5.505307217973868e-19,  -5.815157230908797e-03,   1.292151662154380e-04,  -2.153389970848774e-06,   3.188265812671279e-08,  -4.411610109757288e-10,   5.769140180364047e-12,
  -6.844137230217688e-14,   5.705031291140678e-16,   4.825293255593959e-18,  -4.698424626750188e-19,  -4.467719299321916e-03,   9.927758125213207e-05,  -1.654542542327298e-06,
   2.449799796372813e-08,  -3.389937510698729e-10,   4.432985305587287e-12,  -5.257229751866717e-14,   4.372124269026717e-16,   3.758542696933315e-18,  -3.627976630259309e-19,
  -3.009142647890751e-03,   6.686803110753809e-05,  -1.114446186614764e-06,   1.650167922991478e-08,  -2.283514541565645e-10,   2.986076550397587e-12,  -3.540345219434867e-14,
   2.938917636784125e-16,   2.558751992009604e-18,  -2.453230263389467e-19,  -1.661517089500384e-03,   3.692211786354833e-05,  -6.153683341628085e-07,   9.111998430873718e-09,
  -1.260949412690166e-10,   1.648885485836599e-12,  -1.954645906841603e-14,   1.620877902845272e-16,   1.421530288256625e-18,  -1.357654566791808e-19,  -6.300603695683265e-04,
   1.400123098390698e-05,  -2.333553459243436e-07,   3.455411673941930e-09,  -4.781751157843854e-11,   6.252852356655647e-13,  -7.411917215575643e-15,   6.143840001399111e-17,
   5.402951015302273e-19,  -5.152732828400688e-20,  -7.183537632393761e-05,   1.596330470601695e-06,  -2.660570883464820e-08,   3.939648397325597e-10,  -5.451865854639484e-12,
   7.129122765732665e-14,  -8.450536821725377e-16,   7.004303641998697e-18,   6.162435886000893e-20,  -5.875641772366092e-21,  -4.429781594224645e-05,   9.424009656430499e-07,
  -1.503702609158563e-08,   2.132486839232947e-10,  -2.833382407536562e-12,   3.602468393962391e-14,  -4.390664802520990e-16,   4.958913511137960e-18,  -4.404892584213094e-20,
  -9.998021846823544e-24,  -4.095921610092729e-05,   8.713889325668194e-07,  -1.390425048632340e-08,   1.971893742169185e-10,  -2.620085285839977e-12,   3.331363649586428e-14,
  -4.060226541944676e-16,   4.585073512314120e-18,  -4.069639152816830e-20,  -1.069044773624071e-23,  -3.478988896926808e-05,   7.401588396300107e-07,  -1.181070335574032e-08,
   1.675060887304785e-10,  -2.225789025315562e-12,   2.830151509232977e-14,  -3.449330145556598e-16,   3.894320769515466e-18,  -3.452095855567997e-20,  -1.109968617131235e-23,
  -2.672860854218525e-05,   5.686701389291418e-07,  -9.074599718978221e-09,   1.287070625424945e-10,  -1.710324685321001e-12,   2.174825777865337e-14,  -2.650611844442657e-16,
   2.991835055383992e-18,  -2.648463232200030e-20,  -1.017738873743884e-23,  -1.800248152472405e-05,   3.830240444863743e-07,  -6.112316839083425e-09,   8.669549892110575e-11,
  -1.152101296993337e-12,   1.465050082284468e-14,  -1.785547417410957e-16,   2.015021515520108e-18,  -1.781829852365862e-20,  -7.730836643470159e-24,  -9.940172165946170e-06,
   2.114915915660667e-07,  -3.375050644891923e-09,   4.787183764633831e-11,  -6.361866634285520e-13,   8.090130648203625e-15,  -9.859907584724810e-17,   1.112584562447939e-18,
  -9.832134486109573e-21,  -4.548159271039545e-24,  -3.769389950020159e-06,   8.019962649620889e-08,  -1.279859513905910e-09,   1.815371562408209e-11,  -2.412536399482954e-13,
   3.067950095501150e-15,  -3.739082022958758e-17,   4.218976368085345e-19,  -3.727517574607130e-21,  -1.764527789747147e-24,  -4.297612404903897e-07,   9.143845229636769e-09,
  -1.459214984035619e-10,   2.069774703078088e-12,  -2.750629302269328e-14,   3.497897282477864e-16,  -4.263081666280795e-18,   4.810195793217536e-20,  -4.249701418569187e-22,
  -2.019328744169376e-25,  -4.029777907731550e-04,   8.573033301721821e-06,  -1.367919806165345e-07,   1.939921467082188e-09,  -2.577489216943563e-11,   3.276854928529782e-13,
  -3.992263760065094e-15,   4.501156841260350e-17,  -3.962843924497271e-19,  -2.619059412357856e-22,  -3.726065058736692e-04,   7.927035953290543e-06,  -1.264871092017459e-07,
   1.793830049255670e-09,  -2.383455618359346e-11,   3.030253422820349e-13,  -3.691803603982492e-15,   4.161798594790861e-17,  -3.661086779202121e-19,  -2.557382976121968e-22,
  -3.164840590828461e-04,   6.733234165439122e-06,  -1.074420893368665e-07,   1.523801436023724e-09,  -2.024769548312211e-11,   2.574342836230614e-13,  -3.136332278213150e-15,
   3.534775023369508e-17,  -3.105332261083602e-19,  -2.361729894618209e-22,  -2.431504892835660e-04,   5.173199322589630e-06,  -8.255172641392350e-08,   1.170847015633564e-09,
  -1.555858611842410e-11,   1.978248959264771e-13,  -2.410084963647636e-15,   2.715580631206986e-17,  -2.382255596185202e-19,  -1.969320540951515e-22,  -1.637688016612721e-04,
   3.484374493430042e-06,  -5.560380870327175e-08,   7.886681825992313e-10,  -1.048050472753938e-11,   1.332627492465671e-13,  -1.623516665273007e-15,   1.828945639582990e-17,
  -1.602641047384239e-19,  -1.408621846935131e-22,  -9.042587166008205e-05,   1.923941637058898e-06,  -3.070287016022864e-08,   4.354896786144416e-10,  -5.787301057887184e-12,
   7.358880162066416e-14,  -8.965153146435971e-16,   1.009838345708358e-17,  -8.843083478244432e-20,  -8.040156299356683e-23,  -3.429018795313853e-05,   7.295769990024930e-07,
  -1.164289505632244e-08,   1.651441881749812e-10,  -2.194650570363027e-12,   2.790644068015064e-14,  -3.399771075376592e-16,   3.829350008152500e-18,  -3.352511714622891e-20,
  -3.086274498099984e-23,  -3.909543429250989e-06,   8.318167369858289e-08,  -1.327449359745397e-09,   1.882872189871369e-11,  -2.502208941861612e-13,   3.181729120463824e-15,
  -3.876218981883423e-17,   4.365968344424992e-19,  -3.822153648390866e-21,  -3.525835798590101e-24,  -1.145089336181734e-03,   2.436086749993393e-05,  -3.887036772906171e-07,
   5.512393301038000e-09,  -7.323849923297982e-11,   9.309438323448825e-13,  -1.133219061869218e-14,   1.272763201401851e-16,  -1.098135904416759e-18,  -1.825889149933515e-21,
  -1.058787224092260e-03,   2.252522131853806e-05,  -3.594216865532823e-07,   5.097266434336636e-09,  -6.772509120557674e-11,   8.608845852464552e-13,  -1.047928991765907e-14,
   1.176787693018361e-16,  -1.014421831232834e-18,  -1.729506662353487e-21,  -8.993113998223737e-04,   1.913295090589872e-05,  -3.053039718856521e-07,   4.329965204562001e-09,
  -5.753313600351048e-11,   7.313611700760040e-13,  -8.902522217548175e-15,   9.994666241627051e-17,  -8.602996817975804e-19,  -1.526589248614740e-21,  -6.909289760593092e-04,
   1.470000392145626e-05,  -2.345763194773505e-07,   3.327025797110563e-09,  -4.420918275660595e-11,   5.620124883812817e-13,  -6.841021246603283e-15,   7.678174956258313e-17,
  -6.598704523656203e-19,  -1.219897459469722e-21,  -4.653604061175941e-04,   9.901091280502477e-06,  -1.580019864607568e-07,   2.241043699533060e-09,  -2.977998587804481e-11,
   3.785937132277582e-13,  -4.608328544070190e-15,   5.171151326798129e-17,  -4.438642174071791e-19,  -8.466172235469368e-22,  -2.569513847085944e-04,   5.467013319092321e-06,
  -8.724428381593276e-08,   1.237467681346208e-09,  -1.644441106067478e-11,   2.090624973735863e-13,  -2.544739291811548e-15,   2.855178003424307e-17,  -2.448978096506907e-19,
  -4.754355499189897e-22,  -9.743794684745624e-05,   2.073143537110279e-06,  -3.308407438239819e-08,   4.692662182950429e-10,  -6.236021679222427e-12,   7.928093558067446e-14,
  -9.650167332239111e-16,   1.082690860986225e-17,  -9.284086533384812e-20,  -1.814246266636685e-22,  -1.110923875300951e-05,   2.363664828641086e-07,  -3.772037207235858e-09,
   5.350284022062769e-11,  -7.109937831708947e-13,   9.039148207699614e-15,  -1.100255136524303e-16,   1.234410681670631e-18,  -1.058461283362070e-20,  -2.070632223458232e-23,
  -2.330989027504855e-03,   4.958993895630166e-05,  -7.912597418661143e-07,   1.122114364888836e-08,  -1.490775706966075e-10,   1.894346589394740e-12,  -2.302391164460015e-14,
   2.567798802679531e-16,  -2.132013199126994e-18,  -7.745685126157528e-21,  -2.155309043403056e-03,   4.585322545793949e-05,  -7.316522238989159e-07,   1.037610236023889e-08,
  -1.378549543791214e-10,   1.751783294647878e-12,  -2.129092738132135e-14,   2.374103312168303e-16,  -1.969120294049161e-18,  -7.255935535941156e-21,  -1.830673764010407e-03,
   3.894778651541426e-05,  -6.214881768823125e-07,   8.814167459174578e-09,  -1.171091095117911e-10,   1.488217834501262e-12,  -1.808721290508560e-14,   2.016277172414331e-16,
  -1.669441620894949e-18,  -6.294353472606480e-21,  -1.406482281305693e-03,   2.992390546658978e-05,  -4.775123210383945e-07,   6.772562728203418e-09,  -8.998807465739087e-11,
   1.143614557746051e-12,  -1.389873008099855e-14,   1.548884821503182e-16,  -1.280085666133223e-18,  -4.943141942843751e-21,  -9.473060014682410e-04,   2.015505036276524e-05,
  -3.216347459381083e-07,   4.561914851562254e-09,  -6.061733456006365e-11,   7.703824832955720e-13,  -9.362549825609980e-15,   1.043114392416559e-16,  -8.608327783843518e-19,
  -3.386319309581110e-21,  -5.230603756070417e-04,   1.112886707453350e-05,  -1.775977227227810e-07,   2.519014715407377e-09,  -3.347268884672756e-11,   4.254110106642841e-13,
  -5.170017290395588e-15,   5.759282469567335e-17,  -4.748854325673774e-19,  -1.887954258218053e-21,  -1.983485285900788e-04,   4.220172423625832e-06,  -6.734717743704720e-08,
   9.552479764726743e-10,  -1.269345551471596e-11,   1.613248259011111e-13,  -1.960571970040242e-15,   2.183916805524052e-17,  -1.800191793899778e-19,  -7.185171525421358e-22,
  -2.261440467196033e-05,   4.811568977167366e-07,  -7.678499815780520e-09,   1.089114830484812e-10,  -1.447231637193167e-12,   1.839331126226537e-14,  -2.235327828799173e-16,
   2.489950413537904e-18,  -2.052345796496647e-20,  -8.196960235157595e-23,  -4.093128858710975e-03,   8.707805109888768e-05,  -1.389419807590574e-06,   1.970358900717280e-08,
  -2.617445104048781e-10,   3.324132985064077e-12,  -4.028823639599532e-14,   4.434969728189106e-16,  -3.409152812711004e-18,  -2.678457112120752e-20,  -3.784641429289116e-03,
   8.051652394351668e-05,  -1.284751431184605e-06,   1.821975118200021e-08,  -2.420401926926558e-10,   3.073961280422209e-12,  -3.725538528830227e-14,   4.100214338445094e-16,
  -3.147427027689409e-18,  -2.496500260881725e-20,  -3.214594116621093e-03,   6.839083513594536e-05,  -1.091307851492611e-06,   1.547709515614911e-08,  -2.056153438692463e-10,
   2.611457577970715e-12,  -3.164888791805405e-14,   3.481927968542796e-16,  -2.666667060028826e-18,  -2.148284387602470e-20,  -2.469729864080436e-03,   5.254524240176004e-05,
  -8.384921207077031e-07,   1.189217112953342e-08,  -1.579972452771177e-10,   2.006755699897391e-12,  -2.431945041929313e-14,   2.674538550264121e-16,  -2.043295059661145e-18,
  -1.673218010418954e-20,  -1.663433626745605e-03,   3.539150353643798e-05,  -5.647774643760123e-07,   8.010419420639078e-09,  -1.064292899197374e-10,   1.351823323136166e-12,
  -1.638197779355738e-14,   1.801068579682470e-16,  -1.373310719192853e-18,  -1.139026928228141e-20,  -9.184743010518737e-04,   1.954186822491875e-05,  -3.118543387608388e-07,
   4.423222303476003e-09,  -5.876987924996286e-11,   7.464857362132129e-13,  -9.046080760800779e-15,   9.943711536917281e-17,  -7.573533180334685e-19,  -6.327706313737923e-21,
  -3.482925387882202e-04,   7.410462612527468e-06,  -1.182588893910880e-07,   1.677351886767723e-09,  -2.228661004255638e-11,   2.830829490123048e-13,  -3.430440208845035e-15,
   3.770590734619393e-17,  -2.870619593547500e-19,  -2.405001718464791e-21,  -3.971004207773449e-05,   8.448932515725719e-07,  -1.348313165714781e-08,   1.912413170038846e-10,
  -2.540985509931489e-12,   3.227545547321894e-14,  -3.911182288346487e-16,   4.298954724322733e-18,  -3.272643069290966e-20,  -2.743063167276470e-22,  -6.787285228954269e-03,
   1.443940373273017e-04,  -2.303947556708174e-06,   3.267169057054880e-08,  -4.339240908172682e-10,   5.504145516574142e-12,  -6.630340718488677e-14,   7.085398234011932e-16,
  -4.414218290708652e-18,  -9.432676925120249e-20,  -6.275746929774529e-03,   1.335136214479638e-04,  -2.130385550805543e-06,   3.021124749159407e-08,  -4.012576422383768e-10,
   5.089883581782160e-12,  -6.131067428857198e-14,   6.549760979015505e-16,  -4.070057650191837e-18,  -8.768437361375372e-20,  -5.330486264713104e-03,   1.134066351715620e-04,
  -1.809615752710171e-06,   2.566348236269043e-08,  -3.408715582291455e-10,   4.324033403273776e-12,  -5.208205569975761e-14,   5.560944885116014e-16,  -3.440986542361226e-18,
  -7.512923578434800e-20,  -4.095341632232219e-03,   8.713125247854830e-05,  -1.390394574051836e-06,   1.971910484807762e-08,  -2.619293358229428e-10,   3.322744602000806e-12,
  -4.001888040171687e-14,   4.270529511177242e-16,  -2.630556073947347e-18,  -5.825351954404212e-20,  -2.758329598118886e-03,   5.868668378970816e-05,  -9.365186486500289e-07,
   1.328254306298274e-08,  -1.764392905893527e-10,   2.238306433943922e-12,  -2.695646400101018e-14,   2.875327695557957e-16,  -1.764788437296746e-18,  -3.951838791086875e-20,
  -1.523027314607768e-03,   3.240459787120583e-05,  -5.171194307025909e-07,   7.334401883045786e-09,  -9.742909182074226e-11,   1.236002858008149e-12,  -1.488499237124414e-14,
   1.587310113461942e-16,  -9.722140789668546e-19,  -2.191060728359313e-20,  -5.775437041957797e-04,   1.228813223763523e-05,  -1.960978627379705e-07,   2.781314517914157e-09,
  -3.694687947612265e-11,   4.687173758537008e-13,  -5.644621681266571e-15,   6.018748320919432e-17,  -3.683541218716744e-19,  -8.321539885307692e-21,  -6.584776370766760e-05,
   1.401013748302625e-06,  -2.235783976044747e-08,   3.171083256494663e-10,  -4.212461267181018e-12,   5.344039007576619e-14,  -6.435651484190770e-16,   6.862098154918213e-18,
  -4.199134086978204e-20,  -9.490109311761509e-22,  -4.075361783622458e-05,   8.316212743050285e-07,  -1.272800276677080e-08,   1.731503456868552e-10,  -2.207829888784670e-12,
   2.699702076694319e-14,  -3.193664376406972e-16,   3.626915094262866e-18,  -3.756188286965599e-20,   2.779754467717383e-22,  -3.768208541976440e-05,   7.689547583850572e-07,
  -1.176912127354462e-08,   1.601097678351271e-10,  -2.041609421566412e-12,   2.496527251427247e-14,  -2.953380487614681e-16,   3.353946917924273e-18,  -3.472715849157874e-20,
   2.566609333830528e-22,  -3.200629585592164e-05,   6.531483614679978e-07,  -9.996988095976704e-09,   1.360067649051178e-10,  -1.734347057443756e-12,   2.120907259612875e-14,
  -2.509115179262749e-16,   2.849303359784991e-18,  -2.949119032396335e-20,   2.174932296520931e-22,  -2.458995569097628e-05,   5.018170180778708e-07,  -7.680998196832028e-09,
   1.045027251637413e-10,  -1.332677413792966e-12,   1.629799070369266e-14,  -1.928189650930689e-16,   2.189514804845853e-18,  -2.265331671850346e-20,   1.666809140202638e-22,
  -1.656200840055800e-05,   3.379943687779829e-07,  -5.173607814875913e-09,   7.039115776884744e-11,  -8.977032199517852e-13,   1.097893433974879e-14,  -1.298939841926520e-16,
   1.474929917441055e-18,  -1.525532171200347e-20,   1.120431371645982e-22,  -9.144797424599462e-06,   1.866275035141266e-07,  -2.856712096350464e-09,   3.886865689960019e-11,
  -4.957059879212046e-13,   6.062645475516360e-15,  -7.172963371569128e-17,   8.144638469075891e-19,  -8.422564739308292e-21,   6.179462925999681e-23,  -3.467776382981854e-06,
   7.077087321645110e-08,  -1.083297972457859e-09,   1.473954799749773e-11,  -1.879803853174093e-13,   2.299082333614498e-15,  -2.720156009979108e-17,   3.088613525483418e-19,
  -3.193794791247678e-21,   2.342293417224081e-23,  -3.953732049630665e-07,   8.068838441992369e-09,  -1.235107669447047e-10,   1.680511853788082e-12,  -2.143238833723080e-14,
   2.621278820188415e-16,  -3.101365698233897e-18,   3.521455172122486e-20,  -3.641336187110704e-22,   2.670339786368712e-24,  -3.707361762368607e-04,   7.565269199387475e-06,
  -1.157867943504130e-07,   1.575149904992946e-09,  -2.008456290150370e-11,   2.455851431586009e-13,  -2.904836428624777e-15,   3.297056758790069e-17,  -3.406264118008224e-19,
   2.485908816411875e-21,  -3.427944070457847e-04,   6.995191115190289e-06,  -1.070638378414378e-07,   1.456519674011301e-09,  -1.857245996132245e-11,   2.271028165370453e-13,
  -2.686282010597804e-15,   3.048907746992153e-17,  -3.149168756573600e-19,   2.295124839603137e-21,  -2.911616776891139e-04,   5.941698864695030e-06,  -9.094272096636256e-08,
   1.237254483998214e-09,  -1.577730300412849e-11,   1.929335793563574e-13,  -2.282193487045925e-15,   2.590151993402473e-17,  -2.674311189239900e-19,   1.944639431775049e-21,
  -2.236951375286192e-04,   4.565035729090122e-06,  -6.987413296541338e-08,   9.506620123257022e-10,  -1.212332601019881e-11,   1.482586830046370e-13,  -1.753804787178918e-15,
   1.990365374978779e-17,  -2.054205728602623e-19,   1.490123759963556e-21,  -1.506647996225135e-04,   3.074739026532032e-06,  -4.706437249261703e-08,   6.403488463270913e-10,
  -8.166378787248787e-12,   9.987256506002742e-14,  -1.181463359214536e-15,   1.340772255924903e-17,  -1.383335712572400e-19,   1.001559251606903e-21,  -8.319033768381274e-05,
   1.697752748204169e-06,  -2.598754428101574e-08,   3.535884385241120e-10,  -4.509422183467866e-12,   5.515033526752895e-14,  -6.524236089137484e-16,   7.403800263938933e-18,
  -7.637428400938760e-20,   5.523520544584586e-22,  -3.154640555908791e-05,   6.438035243088014e-07,  -9.854774677074519e-09,   1.340857691867094e-10,  -1.710051797451215e-12,
   2.091416337619295e-14,  -2.474143051576074e-16,   2.807670707586986e-18,  -2.896066400756810e-20,   2.093614411027871e-22,  -3.596715039692304e-06,   7.340232485389942e-08,
  -1.123578931526071e-09,   1.528762785377136e-11,  -1.949697789453578e-13,   2.384510221520720e-15,  -2.820875781986802e-17,   3.201140380164878e-19,  -3.301885966948425e-21,
   2.386823444449031e-23,  -1.053472555047208e-03,   2.149723684248064e-05,  -3.290161587370559e-07,   4.475891617195433e-09,  -5.707109616665501e-11,   6.978029472696117e-13,
  -8.251518141865862e-15,   9.354077794243447e-17,  -9.611657073806255e-19,   6.794133437933346e-21,  -9.740740801481507e-04,   1.987732044849770e-05,  -3.042292762818000e-07,
   4.138796026916059e-09,  -5.277439282485451e-11,   6.452873336494993e-13,  -7.630681470262790e-15,   8.650012969939045e-17,  -8.885999207401620e-19,   6.271614258076269e-21,
  -8.273560989880246e-04,   1.688374919127233e-05,  -2.584200110626712e-07,   3.515739604799536e-09,  -4.483183925901042e-11,   5.481990707269257e-13,  -6.482812100023356e-15,
   7.348425649209886e-17,  -7.545820265941280e-19,   5.312351539534608e-21,  -6.356452463676047e-04,   1.297186546283549e-05,  -1.985521656472932e-07,   2.701368314481576e-09,
  -3.444891502050152e-11,   4.212602250904232e-13,  -4.981858943947095e-15,   5.646745618878106e-17,  -5.795909654642698e-19,   4.069452863908268e-21,  -4.281244766101041e-04,
   8.737084077794329e-06,  -1.337366587611472e-07,   1.819593136178029e-09,  -2.320509036392658e-11,   2.837764808407548e-13,  -3.356060677924571e-15,   3.803798994595008e-17,
  -3.902940788533922e-19,   2.734538587574643e-21,  -2.363911137111474e-04,   4.824282118212890e-06,  -7.384539846298882e-08,   1.004744674789794e-09,  -1.281370226930680e-11,
   1.567033497761846e-13,  -1.853270666257874e-15,   2.100465626793040e-17,  -2.154784459947528e-19,   1.507862470281561e-21,  -8.964129911378000e-05,   1.829412341232626e-06,
  -2.800302155564513e-08,   3.810134825891115e-10,  -4.859180063688190e-12,   5.942519190738186e-14,  -7.028033990226027e-16,   7.965378767106245e-18,  -8.170757230876308e-20,
   5.715039631329174e-22,  -1.022031521455444e-05,   2.085777941442282e-07,  -3.192726984553520e-09,   4.344079437406881e-11,  -5.540143653380331e-13,   6.775311712140529e-15,
  -8.012960217273529e-17,   9.081652443442060e-19,  -9.315697613734185e-21,   6.515368617114296e-23,  -2.144490301737301e-03,   4.376062273461218e-05,  -6.697581059948993e-07,
   9.111279713905590e-09,  -1.161740718325544e-10,   1.420314714638389e-12,  -1.678701318047120e-14,   1.898767188988231e-16,  -1.931812715731140e-18,   1.283489076366763e-20,
  -1.982863633261975e-03,   4.046305706314916e-05,  -6.193009622012442e-07,   8.425076205989820e-09,  -1.074276847653019e-10,   1.313423454404228e-12,  -1.552394428221560e-14,
   1.755835039744837e-16,  -1.785891819059411e-18,   1.184355397396087e-20,  -1.684198721497727e-03,   3.436922540204640e-05,  -5.260498372143853e-07,   7.156760925271416e-09,
  -9.125979387216068e-11,   1.115808482775348e-12,  -1.318866483070646e-14,   1.491609103618663e-16,  -1.516442363959814e-18,   1.002611322324072e-20,  -1.293944545232752e-03,
   2.640604067666698e-05,  -4.041805192312724e-07,   5.498998528829842e-09,  -7.012428219058320e-11,   8.574356552180952e-13,  -1.013508475409889e-14,   1.146178647230787e-16,
  -1.164688336438199e-18,   7.675501483286592e-21,  -8.715070778122430e-04,   1.778555275577430e-05,  -2.722395494110609e-07,   3.704026514833958e-09,  -4.723632562821509e-11,
   5.776001018761542e-13,  -6.827545871243603e-15,   7.720873150770505e-17,  -7.842514724276419e-19,   5.155093113253695e-21,  -4.812070787490075e-04,   9.820498847573388e-06,
  -1.503225680621942e-07,   2.045292882881194e-09,  -2.608359518669770e-11,   3.189547064933138e-13,  -3.770274905773571e-15,   4.263452336674196e-17,  -4.329651147255374e-19,
   2.841760580866949e-21,  -1.824773656020886e-04,   3.724023875093499e-06,  -5.700404087744536e-08,   7.756041726966942e-10,  -9.891355420084919e-12,   1.209542908528294e-13,
  -1.429775240965903e-15,   1.616780745574590e-17,  -1.641746118100457e-19,   1.076954319113051e-21,  -2.080487693074675e-05,   4.245891796494684e-07,  -6.499239347015294e-09,
   8.842957771148752e-11,  -1.127752605764598e-12,   1.379049830742697e-14,  -1.630147358713419e-16,   1.843356714712014e-18,  -1.871794565504952e-20,   1.227747646596812e-22,
  -3.765644152299300e-03,   7.684200180116103e-05,  -1.176069474166574e-06,   1.599899636139130e-08,  -2.039907705938864e-10,   2.493518512247420e-12,  -2.944564237170849e-14,
   3.317129040986682e-16,  -3.313188387354010e-18,   1.933358297783017e-20,  -3.481833813515717e-03,   7.105160093764953e-05,  -1.087468668581873e-06,   1.479405372163263e-08,
  -1.886329148655885e-10,   2.305857630277068e-12,  -2.723003375074601e-14,   3.067378396807828e-16,  -3.062682267251284e-18,   1.782539674500030e-20,  -2.957389483952258e-03,
   6.035106253757570e-05,  -9.237232775142895e-07,   1.256694900108098e-08,  -1.602435896042029e-10,   1.958920927328285e-12,  -2.313366659435285e-14,   2.605716375507369e-16,
  -2.600256590901922e-18,   1.506914684481178e-20,  -2.272117857586779e-03,   4.636801072011258e-05,  -7.097254413361954e-07,   9.655992842357323e-09,  -1.231316011909330e-10,
   1.505318090591498e-12,  -1.777740653636434e-14,   2.002221706641084e-16,  -1.996824268272634e-18,   1.151908252068750e-20,  -1.530333584840214e-03,   3.123075930967417e-05,
  -4.780421735650368e-07,   6.504102991164660e-09,  -8.294250362081573e-11,   1.014036539000723e-12,  -1.197577360783357e-14,   1.348703830458749e-16,  -1.344429202073543e-18,
   7.727425893753114e-21,  -8.449814954076678e-04,   1.724442529220774e-05,  -2.639606450844859e-07,   3.591441731289023e-09,  -4.580031300641513e-11,   5.599575795227879e-13,
  -6.613186528525760e-15,   7.447422457030391e-17,  -7.421778780385162e-19,   4.256844181261672e-21,  -3.204233771145123e-04,   6.539245357561733e-06,  -1.000969022092810e-07,
   1.361925816907984e-09,  -1.736827903381694e-11,   2.123475748946014e-13,  -2.507870331155509e-15,   2.824187998483450e-17,  -2.814172798693062e-19,   1.612817467719004e-21,
  -3.653257983313934e-05,   7.455625729053640e-07,  -1.141241419532821e-08,   1.552783352822149e-10,  -1.980226268233275e-12,   2.421062332422656e-14,  -2.859328779535446e-16,
   3.219967669987422e-18,  -3.208493994087952e-20,   1.838562527974754e-22,  -6.244245456875788e-03,   1.274205074689121e-04,  -1.950173634813963e-06,   2.652953932928200e-08,
  -3.382382356727143e-10,   4.133064214207695e-12,  -4.871653422646702e-14,   5.440234660356292e-16,  -5.209924168031960e-18,   2.032881600987668e-20,  -5.773627058745573e-03,
   1.178187818295804e-04,  -1.803254625466304e-06,   2.453150241744119e-08,  -3.127732172739431e-10,   3.822006560775088e-12,  -4.505056756223789e-14,   5.030450451523392e-16,
  -4.815083910745682e-18,   1.867783426882655e-20,  -4.903985905674771e-03,   1.000749958250951e-04,  -1.531729889705923e-06,   2.083851592780185e-08,  -2.657006286381076e-10,
   3.246944230859610e-12,  -3.827288393016495e-14,   4.273077326634732e-16,  -4.086775766285471e-18,   1.569845599470095e-20,  -3.767658608990324e-03,   7.688809909837476e-05,
  -1.176875902294504e-06,   1.601156730463473e-08,  -2.041649885372955e-10,   2.495083725780322e-12,  -2.941097379924612e-14,   3.283206475029729e-16,  -3.137314877051068e-18,
   1.192512456859114e-20,  -2.537621226900914e-03,   5.178729211255177e-05,  -7.926957088112550e-07,   1.078510310085345e-08,  -1.375272451693824e-10,   1.680775054838787e-12,
  -1.981253591934615e-14,   2.211468990244898e-16,  -2.111740561487959e-18,   7.959746484461102e-21,  -1.401160505330999e-03,   2.859495284364856e-05,  -4.377029510612033e-07,
   5.955328266984866e-09,  -7.594163956940763e-11,   9.281338751370206e-13,  -1.094068851542777e-14,   1.221118092215760e-16,  -1.165584342836170e-18,   4.371981338330508e-21,
  -5.313306663349360e-04,   1.084347024902766e-05,  -1.659819759554738e-07,   2.258345212424958e-09,  -2.879839477905379e-11,   3.519675429533308e-13,  -4.148947875171335e-15,
   4.630634974867829e-17,  -4.419379471658040e-19,   1.654605573302134e-21,  -6.057885089552905e-05,   1.236302529715066e-06,  -1.892421260241053e-08,   2.574825149679675e-10,
  -3.283418988051554e-12,   4.012926922192731e-14,  -4.730388759191125e-16,   5.279559286938855e-18,  -5.038573407097208e-20,   1.885852549870292e-22,  -3.761841827223464e-05,
   7.375464307496204e-07,  -1.084559253417372e-08,   1.417603421262805e-10,  -1.736973555641509e-12,   2.042447163772715e-14,  -2.331071850507944e-16,   2.587711036839693e-18,
  -2.750956958121005e-20,   2.609008305392672e-22,  -3.478314090088939e-05,   6.819673341322650e-07,  -1.002848694484950e-08,   1.310831215972067e-10,  -1.606190409381071e-12,
   1.888721836998312e-14,  -2.155688873821566e-16,   2.393055605385635e-18,  -2.543882878303824e-20,   2.411812308412982e-22,  -2.954394371415761e-05,   5.792592782889814e-07,
  -8.518396393526509e-09,   1.113487761816639e-10,  -1.364441975177706e-12,   1.604530426296030e-14,  -1.831419256343721e-16,   2.033130572350020e-18,  -2.161078600824020e-20,
   2.047754415544650e-22,  -2.269812240806995e-05,   4.450459121891507e-07,  -6.544906756175513e-09,   8.555557196505050e-11,  -1.048427670545312e-12,   1.232975954660517e-14,
  -1.407399788069017e-16,   1.562450868911999e-18,  -1.660619256148996e-20,   1.572616652085802e-22,  -1.528778294457554e-05,   2.997557599237068e-07,  -4.408359923340778e-09,
   5.762825155495237e-11,  -7.062228949909343e-13,   8.305699579103573e-15,  -9.481067247880345e-17,   1.052579837365121e-18,  -1.118628509916422e-20,   1.058858168337319e-22,
  -8.441219708819710e-06,   1.655133141360735e-07,  -2.434157702988657e-09,   3.182108154107037e-11,  -3.899694806955886e-13,   4.586438791248647e-15,  -5.235607392373137e-17,
   5.812594568965102e-19,  -6.177060449328441e-21,   5.845445031972091e-23,  -3.200973302593291e-06,   6.276413501888372e-08,  -9.230594623964250e-10,   1.206698693697020e-11,
  -1.478829247747159e-13,   1.739269883237629e-15,  -1.985465636429970e-17,   2.204282545753313e-19,  -2.342458634065998e-21,   2.216480877126540e-23,  -3.649540404763696e-07,
   7.155960997596757e-09,  -1.052413682401144e-10,   1.375802634804950e-12,  -1.686071185778814e-14,   1.983012761948990e-16,  -2.263714007551272e-18,   2.513198341466184e-20,
  -2.670731612834797e-22,   2.527057151686535e-24,  -3.422152262787504e-04,   6.709469190633023e-06,  -9.866249071862057e-08,   1.289595416717953e-09,  -1.580125030769593e-11,
   1.858001269675577e-13,  -2.120480196665083e-15,   2.353509557030134e-17,  -2.500050223083938e-19,   2.363189303298551e-21,  -3.164226722117712e-04,   6.203865447097525e-06,
  -9.122927096348488e-08,   1.192464621548037e-09,  -1.461151582076737e-11,   1.718158263773468e-13,  -1.960941218544991e-15,   2.176469914856810e-17,  -2.311855614410475e-19,
   2.184541620511701e-21,  -2.687616292140285e-04,   5.269528966564366e-06,  -7.749195835400663e-08,   1.012941059889356e-09,  -1.241232997387550e-11,   1.459631074382187e-13,
  -1.665966112835821e-15,   1.849118056626231e-17,  -1.963956877759583e-19,   1.854745909781439e-21,  -2.064851063050994e-04,   4.048588280951200e-06,  -5.953909847555600e-08,
   7.782999924260829e-10,  -9.537547463902003e-12,   1.121630290999504e-13,  -1.280252855542107e-15,   1.421036379043247e-17,  -1.509138515509219e-19,   1.424355795431356e-21,
  -1.390731545864156e-04,   2.726881931793318e-06,  -4.010290525872038e-08,   5.242448467479763e-10,  -6.424510273070921e-12,   7.555641161872275e-14,  -8.624529420684415e-16,
   9.573118725918023e-18,  -1.016583512840509e-19,   9.590136148895058e-22,  -7.678988233404339e-05,   1.505676707937533e-06,  -2.214356301224039e-08,   2.894767333399085e-10,
  -3.547552683220101e-12,   4.172253596526301e-14,  -4.762611987611896e-16,   5.286499346292146e-18,  -5.613554674364823e-20,   5.294190527306559e-22,  -2.911929457347394e-05,
   5.709661285252038e-07,  -8.397083452794099e-09,   1.097735146010059e-10,  -1.345291085229742e-12,   1.582202509353770e-14,  -1.806094556484926e-16,   2.004773531761755e-18,
  -2.128764566199694e-20,   2.007447037542466e-22,  -3.319991516893034e-06,   6.509786752330699e-08,  -9.573820406992857e-10,   1.251569189594854e-11,  -1.533819092534030e-13,
   1.803933819523893e-15,  -2.059205377644037e-17,   2.285729361653253e-19,  -2.427090009369924e-21,   2.288731568527237e-23,  -9.724282983177204e-04,   1.906542196315841e-05,
  -2.803562998763027e-07,   3.664473529940381e-09,  -4.490022391076968e-11,   5.279543065615907e-13,  -6.024875770370103e-15,   6.684323734393443e-17,  -7.088431591801675e-19,
   6.651017635801958e-21,  -8.991369672056597e-04,   1.762871386540111e-05,  -2.592342911490231e-07,   3.388469731616169e-09,  -4.151951984215141e-11,   4.882176420372696e-13,
  -5.571579170219418e-15,   6.181494583997832e-17,  -6.554795454662358e-19,   6.148028679861864e-21,  -7.637048082029044e-04,   1.497373196559941e-05,  -2.201987660016369e-07,
   2.878341254111238e-09,  -3.527039759281391e-11,   4.147566519922130e-13,  -4.733470290424237e-15,   5.251753555771710e-17,  -5.568336571380986e-19,   5.219595968715318e-21,
  -5.867417494398545e-04,   1.150434434303825e-05,  -1.691844713784762e-07,   2.211592618826138e-09,  -2.710152615332499e-11,   3.187131201826602e-13,  -3.637550170255803e-15,
   4.035930664729440e-17,  -4.278754920662286e-19,   4.008171989682782e-21,  -3.951860135690440e-04,   7.748624100239795e-06,  -1.139551823834392e-07,   1.489677557239007e-09,
  -1.825563977716438e-11,   2.146947870235656e-13,  -2.450464677487013e-15,   2.718886011114934e-17,  -2.882220815433284e-19,   2.698566977883260e-21,  -2.182037760792819e-04,
   4.278484774193614e-06,  -6.292246771497908e-08,   8.225679188687620e-10,  -1.008058834395414e-11,   1.185552667179876e-13,  -1.353187956107174e-15,   1.501430353481982e-17,
  -1.591548080583510e-19,   1.489692914827152e-21,  -8.274449497208085e-05,   1.622439846874073e-06,  -2.386089411834323e-08,   3.119289428771266e-10,  -3.822727047211615e-12,
   4.495854163320897e-14,  -5.131606696223116e-16,   5.693798885855218e-18,  -6.035434535208290e-20,   5.648551001318453e-22,  -9.433986138769513e-06,   1.849801046676766e-07,
  -2.720467366104461e-09,   3.556419375315681e-11,  -4.358440929332853e-13,   5.125907271670413e-15,  -5.850763400750687e-17,   6.491746856152228e-19,  -6.881239047204445e-21,
   6.440018532817163e-23,  -1.979513416562371e-03,   3.881032510789626e-05,  -5.707043119573796e-07,   7.459542327445669e-09,  -9.140021940626427e-11,   1.074689859824094e-12,
  -1.226224706566666e-14,   1.359475669198115e-16,  -1.437249427160325e-18,   1.330418022697140e-20,  -1.830318690836374e-03,   3.588570542316715e-05,  -5.277075200291681e-07,
   6.897698434888433e-09,  -8.451835709070746e-11,   9.938028443601979e-13,  -1.133965945490661e-14,   1.257205358107308e-16,  -1.329032827451432e-18,   1.229729870012346e-20,
  -1.554627643747519e-03,   3.048111952409890e-05,  -4.482452694109644e-07,   5.859261396311121e-09,  -7.179745780845854e-11,   8.442674543942987e-13,  -9.633873396222968e-15,
   1.068107682104276e-16,  -1.128997842372068e-18,   1.043920925149677e-20,  -1.194394658277612e-03,   2.341869720663914e-05,  -3.443985645331318e-07,   4.502002390072701e-09,
  -5.516866139037913e-11,   6.487637064037405e-13,  -7.403376167072540e-15,   8.208281413828464e-17,  -8.675121027347319e-19,   8.015509273403267e-21,  -8.044562434544486e-04,
   1.577340491176992e-05,  -2.319716514277794e-07,   3.032444513264151e-09,  -3.716171479336309e-11,   4.370267672375475e-13,  -4.987339269409380e-15,   5.529652463741443e-17,
  -5.843565035427070e-19,   5.396120988433323e-21,  -4.441842170143367e-04,   8.709452398027806e-06,  -1.280874501694950e-07,   1.674450659345381e-09,  -2.052034047597392e-11,
   2.413277989377726e-13,  -2.754091610340012e-15,   3.053592237915254e-17,  -3.226755497399977e-19,   2.978682591683629e-21,  -1.684379591032191e-04,   3.302702559599928e-06,
  -4.857217456914691e-08,   6.349744644054772e-10,  -7.781654946451578e-12,   9.151635214079880e-14,  -1.044416065726023e-15,   1.157997453422040e-17,  -1.223638715098825e-19,
   1.129423012890430e-21,  -1.920419445376379e-05,   3.765527987601756e-07,  -5.537890372390069e-09,   7.239583050431771e-11,  -8.872169780528390e-13,   1.043415367364234e-14,
  -1.190783213208714e-16,   1.320282892956896e-18,  -1.395118316258381e-20,   1.287672396017467e-22,  -3.475950964536169e-03,   6.814946786175143e-05,  -1.002135158906948e-06,
   1.309866118309682e-08,  -1.604939637988965e-10,   1.887007512321622e-12,  -2.152512147443517e-14,   2.383399181136073e-16,  -2.505807295037326e-18,   2.261616806388642e-20,
  -3.213970648332030e-03,   6.301394594244249e-05,  -9.266344202240875e-07,   1.211208549033846e-08,  -1.484097720802202e-10,   1.744980701346818e-12,  -1.990559184866715e-14,
   2.204090040290441e-16,  -2.317081016637907e-18,   2.090210421116193e-20,  -2.729867558634567e-03,   5.352369683723610e-05,  -7.871017169573161e-07,   1.028863107831011e-08,
  -1.260725383454373e-10,   1.482416706310200e-12,  -1.691123210476208e-14,   1.872554496858209e-16,  -1.968258537306967e-18,   1.774044473271934e-20,  -2.097312010977397e-03,
   4.112234947777905e-05,  -6.047508356941631e-07,   7.905337935112041e-09,  -9.687324620927864e-11,   1.139138813725215e-12,  -1.299580887452018e-14,   1.439023038238512e-16,
  -1.512331630532983e-18,   1.361880946271866e-20,  -1.412594848784742e-03,   2.769750441219924e-05,  -4.073334340724469e-07,   5.324852463453025e-09,  -6.525399936077762e-11,
   7.673579969324403e-13,  -8.754710057965018e-15,   9.694161599061534e-17,  -1.018674730904310e-18,   9.166836086508114e-21,  -7.799707466632970e-04,   1.529347008877589e-05,
  -2.249167111642347e-07,   2.940269030965100e-09,  -3.603262818008815e-11,   4.237378605778489e-13,  -4.834492208904705e-15,   5.353301130260290e-17,  -5.624911659508746e-19,
   5.059660344874599e-21,  -2.957707088540583e-04,   5.799421191892318e-06,  -8.529089885402873e-08,   1.114990006143718e-09,  -1.366417273007661e-11,   1.606899045591938e-13,
  -1.833352124474530e-15,   2.030100617307137e-17,  -2.133044168297222e-19,   1.918396980080156e-21,  -3.372184177961745e-05,   6.612125196213013e-07,  -9.724325744041301e-09,
   1.271242105123640e-10,  -1.557905882769961e-12,   1.832091317418680e-14,  -2.090282683947299e-16,   2.314604769318670e-18,  -2.431964217577656e-20,   2.187180876976143e-22,
  -5.763872051136782e-03,   1.130064293821784e-04,  -1.661754631251385e-06,   2.172034243023201e-08,  -2.661287972395914e-10,   3.128700032325676e-12,  -3.566960363429129e-14,
   3.939076364791812e-16,  -4.092214174810267e-18,   3.484812690471808e-20,  -5.329452510129688e-03,   1.044906329459028e-04,  -1.536558242027701e-06,   2.008439172672927e-08,
  -2.460909477535898e-10,   2.893215264695911e-12,  -3.298578155932606e-14,   3.642689120529554e-16,  -3.783811619580560e-18,   3.219775205222897e-20,  -4.526705780639123e-03,
   8.875376515338142e-05,  -1.305183147210201e-06,   1.706071958965729e-08,  -2.090516466852612e-10,   2.457876896367508e-12,  -2.802368915221770e-14,   3.094705176208558e-16,
  -3.213908921047192e-18,   2.731455921357406e-20,  -3.477793043040539e-03,   6.818967230183834e-05,  -1.002806347502384e-06,   1.310871687993431e-08,  -1.606337880959280e-10,
   1.888713847982301e-12,  -2.153533543834526e-14,   2.378176534790233e-16,  -2.469216723081883e-18,   2.095797196924829e-20,  -2.342385163486961e-03,   4.592840081539996e-05,
  -6.754460327673538e-07,   8.829727859023681e-09,  -1.082032099107780e-10,   1.272293452121050e-12,  -1.450737128256359e-14,   1.602064183419010e-16,  -1.663093727656981e-18,
   1.410119503579116e-20,  -1.293358747913445e-03,   2.535985241153326e-05,  -3.729600554565896e-07,   4.875585828572062e-09,  -5.974876440880121e-11,   7.025648144459273e-13,
  -8.011190016107277e-15,   8.846825550082961e-17,  -9.182881513154748e-19,   7.781391307881123e-21,  -4.904512577030281e-04,   9.616683763872075e-06,  -1.414305686499222e-07,
   1.848888452947705e-09,  -2.265772615242681e-11,   2.664266509414637e-13,  -3.038027895146550e-15,   3.354917923499772e-17,  -3.482221457861231e-19,   2.950098708548466e-21,
  -5.591804468046224e-05,   1.096432125119863e-06,  -1.612501378388953e-08,   2.107987367759405e-10,  -2.583296146037982e-12,   3.037639142830933e-14,  -3.463784342111772e-16,
   3.825083669022013e-18,  -3.970201991223909e-20,   3.363384293541738e-22,  -3.483161665779350e-05,   6.571429158136871e-07,  -9.298659146455931e-09,   1.169556610145572e-10,
  -1.379039829429638e-12,   1.560812167719209e-14,  -1.716543828223013e-16,   1.844836395995567e-18,  -1.932813663163586e-20,   1.929142133187487e-22,  -3.220634613560688e-05,
   6.076215336195910e-07,  -8.598070283558552e-09,   1.081461537765635e-10,  -1.275197994726276e-12,   1.443325003105862e-14,  -1.587384781231334e-16,   1.706073566831605e-18,
  -1.787443414904827e-20,   1.783887727043145e-22,  -2.735523207101433e-05,   5.161086481407929e-07,  -7.303331514822270e-09,   9.186416947435297e-11,  -1.083255050361894e-12,
   1.226134335050910e-14,  -1.348586534010900e-16,   1.449489249996916e-18,  -1.518635213797184e-20,   1.515390048619660e-22,  -2.101653434822422e-05,   3.965257718378020e-07,
  -5.611307610626358e-09,   7.058382438945187e-11,  -8.323555552520972e-13,   9.421895893789803e-15,  -1.036342081634731e-16,   1.113938441175681e-18,  -1.167088383585857e-20,
   1.164410956088653e-22,  -1.415516941600696e-05,   2.670748123563369e-07,  -3.779511298435165e-09,   4.754330021310393e-11,  -5.606709757514484e-13,   6.346800904094394e-15,
  -6.981337665977565e-17,   7.504364237295660e-19,  -7.862481308498527e-21,   7.843467934086521e-23,  -7.815835657474834e-06,   1.474679464777755e-07,  -2.086921692372065e-09,
   2.625228339701761e-11,  -3.095954152718518e-13,   3.504704060836989e-15,  -3.855192318706683e-17,   4.144109587051562e-19,  -4.341889422167585e-21,   4.331077932054564e-23,
  -2.963822124340596e-06,   5.592113584979615e-08,  -7.913829410825809e-10,   9.955208008340446e-12,  -1.174034982523324e-13,   1.329050965683377e-15,  -1.461976643677330e-17,
   1.571554124135083e-19,  -1.646559938072418e-21,   1.642415487893784e-23,  -3.379155972849649e-07,   6.375765825159539e-09,  -9.022843387459250e-11,   1.135030482337997e-12,
  -1.338562841231241e-14,   1.515304757365069e-16,  -1.666861309099783e-18,   1.791797769062289e-20,  -1.877315668912882e-22,   1.872581995265656e-24,  -3.168636568008406e-04,
   5.978037405972069e-06,  -8.459001941189469e-08,   1.063947083197578e-09,  -1.254513854730039e-11,   1.419869507065283e-13,  -1.561520741352989e-15,   1.678132451528176e-17,
  -1.757722424675632e-19,   1.752596887493645e-21,  -2.929815376926559e-04,   5.527540766608566e-06,  -7.821675369805978e-08,   9.838068876228611e-10,  -1.160048836764119e-11,
   1.312991522272122e-13,  -1.444026132502282e-15,   1.551908215679428e-17,  -1.625519439073587e-19,   1.620628529138007e-21,  -2.488508917577494e-04,   4.695046891439703e-06,
  -6.643849880465639e-08,   8.356894764778974e-10,  -9.854381545429399e-12,   1.115413342203755e-13,  -1.226793951651613e-15,   1.318509042721608e-17,  -1.381060186057325e-19,
   1.376693788964426e-21,  -1.911876784900017e-04,   3.607199955175852e-06,  -5.104613602916760e-08,   6.421019160578873e-10,  -7.571946424675874e-12,   8.571090409140195e-14,
  -9.427486203878731e-16,   1.013279206466013e-17,  -1.061358527200776e-19,   1.057830220031031e-21,  -1.287697550146991e-04,   2.429582941592598e-06,  -3.438226189818644e-08,
   4.325019849854971e-10,  -5.100429205282745e-12,   5.773679136446364e-14,  -6.350843170569404e-16,   6.826242407236309e-18,  -7.150186729884843e-20,   7.125498593646454e-22,
  -7.110075572179541e-05,   1.341517771865948e-06,  -1.898475292745427e-08,   2.388173439238721e-10,  -2.816392438071474e-12,   3.188226145740342e-14,  -3.507024308688556e-16,
   3.769631979232343e-18,  -3.948536565886947e-20,   3.934609672726306e-22,  -2.696192731023638e-05,   5.087152791994256e-07,  -7.199220585182852e-09,   9.056264930180847e-11,
  -1.068020740135590e-12,   1.209036470392163e-14,  -1.329943393967715e-16,   1.429542378266904e-18,  -1.497389617527556e-20,   1.492066342223454e-22,  -3.074022457747640e-06,
   5.800042224764365e-08,  -8.208091996899955e-10,   1.032538621312204e-11,  -1.217691889598794e-13,   1.378471376927612e-15,  -1.516324621988963e-17,   1.629883931791023e-19,
  -1.707239915380514e-21,   1.701162706271685e-23,  -9.003900555975311e-04,   1.698700786198833e-05,  -2.403684045599168e-07,   3.023279158586583e-09,  -3.564785515270341e-11,
   4.034637235852000e-13,  -4.437036812733200e-15,   4.767797996933799e-17,  -4.991193947306213e-19,   4.965464385835619e-21,  -8.325273579037028e-04,   1.570689041955829e-05,
  -2.222583281855011e-07,   2.795555254049963e-09,  -3.296356802929184e-11,   3.730937502087553e-13,  -4.103177298251679e-15,   4.409175888155370e-17,  -4.615782606845955e-19,
   4.591527760599685e-21,  -7.071270669770005e-04,   1.334130134032405e-05,  -1.887896003420863e-07,   2.374669393833675e-09,  -2.800188791679290e-11,   3.169508162434645e-13,
  -3.485914926395228e-15,   3.746054944591375e-17,  -3.921608021739753e-19,   3.900356819928910e-21,  -5.432730474775913e-04,   1.025010882944607e-05,  -1.450511343996093e-07,
   1.824576962902941e-09,  -2.151619491688949e-11,   2.435522253421389e-13,  -2.678804291224322e-15,   2.878854903198167e-17,  -3.013783048574040e-19,   2.996924311364672e-21,
  -3.659081891798037e-04,   6.903828418404414e-06,  -9.769958079666251e-08,   1.228984275123552e-09,  -1.449321249593902e-11,   1.640622488404466e-13,  -1.804581112943254e-15,
   1.939420800915737e-17,  -2.030326630771124e-19,   2.018688904263558e-21,  -2.020377282888012e-04,   3.812015782064450e-06,  -5.394649159459677e-08,   6.786159842554816e-10,
  -8.002968445990222e-12,   9.059518748574755e-14,  -9.965148163087370e-16,   1.070999136041921e-17,  -1.121202129589276e-19,   1.114685919326239e-21,  -7.661418628744496e-05,
   1.445549744888481e-06,  -2.045708439117478e-08,   2.573400255483641e-10,  -3.034852728850620e-12,   3.435543155353924e-14,  -3.779010750379458e-16,   4.061506343740373e-18,
  -4.251892492828717e-20,   4.227053667656301e-22,  -8.735048000083080e-06,   1.648122221047503e-07,  -2.332386244928208e-09,   2.934029837161241e-11,  -3.460153360966977e-13,
   3.917001691540421e-15,  -4.308609708137981e-17,   4.630701308754280e-19,  -4.847769534880467e-21,   4.819425565213316e-23,  -1.832869527368827e-03,   3.457942349187358e-05,
  -4.893034023589501e-07,   6.154305413893535e-09,  -7.256608743340217e-11,   8.212993429232407e-13,  -9.031729763824607e-15,   9.702875806375456e-17,  -1.014760431371453e-18,
   1.005457374701241e-20,  -1.694725542020355e-03,   3.197356591395505e-05,  -4.524378167624343e-07,   5.690741715393047e-09,  -6.710185334683276e-11,   7.594775547880197e-13,
  -8.352146574799427e-15,   8.973041099844840e-17,  -9.384317077396270e-19,   9.297229483086762e-21,  -1.439455761402221e-03,   2.715807944064953e-05,  -3.843075546179447e-07,
   4.833969976990782e-09,  -5.700167410117096e-11,   6.451917736040248e-13,  -7.095687467812450e-15,   7.623523270956963e-17,  -7.972942418229449e-19,   7.897477655014295e-21,
  -1.105908053483284e-03,   2.086552599048481e-05,  -2.952718086655974e-07,   3.714180286942797e-09,  -4.379915826319957e-11,   4.957800248509816e-13,  -5.452787118586172e-15,
   5.858692127563220e-17,  -6.127218456655474e-19,   6.068016882994464e-21,  -7.448571489569537e-04,   1.405370554539187e-05,  -1.988811190267280e-07,   2.501768495842922e-09,
  -2.950291658037628e-11,   3.339685447194495e-13,  -3.673278490460250e-15,   3.946866226220073e-17,  -4.127764108098413e-19,   4.087239564065083e-21,  -4.112759722930451e-04,
   7.759889743570441e-06,  -1.098156054298067e-07,   1.381417259583471e-09,  -1.629113694726880e-11,   1.844174535831704e-13,  -2.028435232913364e-15,   2.179561683529375e-17,
  -2.279457369499170e-19,   2.256873681841977e-21,  -1.559588608706110e-04,   2.942618100361697e-06,  -4.164324762007466e-08,   5.238514285856306e-10,  -6.177857839234847e-12,
   6.993463250791522e-14,  -7.692287168210183e-16,   8.265460637343939e-18,  -8.644289631282510e-20,   8.558354233962786e-22,  -1.778140840172701e-05,   3.354982626098326e-07,
  -4.747897407356557e-09,   5.972625977598924e-11,  -7.043615447242102e-13,   7.973530269102268e-15,  -8.770301293347266e-17,   9.423813341388256e-19,  -9.855732614048872e-21,
   9.757698659524441e-23,  -3.218449822231496e-03,   6.072016449514657e-05,  -8.591983146651251e-07,   1.080672553365955e-08,  -1.274230308736238e-10,   1.442148233963550e-12,
  -1.585790717902856e-14,   1.702970525354299e-16,  -1.777935616834252e-18,   1.748825635334909e-20,  -2.975874189623683e-03,   5.614437679200773e-05,  -7.944637371037711e-07,
   9.992725353098554e-09,  -1.178280621600372e-10,   1.333593120328796e-12,  -1.466469059599481e-14,   1.574873276279099e-16,  -1.644190043140584e-18,   1.617047070309381e-20,
  -2.527630074161012e-03,   4.768856402031819e-05,  -6.748295670230780e-07,   8.488266852027560e-09,  -1.000925663580693e-10,   1.132914628457850e-12,  -1.245859435981693e-14,
   1.338013611742535e-16,  -1.396891775081401e-18,   1.373519754459476e-20,  -1.941932868097629e-03,   3.663907730210317e-05,  -5.184861561215731e-07,   6.521958867616152e-09,
  -7.690949715466580e-11,   8.705572682301227e-13,  -9.573987704410866e-15,   1.028263093199267e-16,  -1.073499768777571e-18,   1.055283672577753e-20,  -1.307941085192714e-03,
   2.467777731021130e-05,  -3.492277416581365e-07,   4.393010016535151e-09,  -5.180589178219873e-11,   5.864268567236374e-13,  -6.449528782488313e-15,   6.927156638681576e-17,
  -7.231844636882228e-19,   7.107772768350291e-21,  -7.221851092760178e-04,   1.362607395067697e-05,  -1.928320600155385e-07,   2.425715993955267e-09,  -2.860655724935153e-11,
   3.238249365944280e-13,  -3.561518161069344e-15,   3.825350243660699e-17,  -3.993587118627463e-19,   3.924638930286417e-21,  -2.738578827068961e-04,   5.167126488783779e-06,
  -7.312397170378972e-08,   9.198631185336431e-10,  -1.084806076420277e-11,   1.228006195665060e-13,  -1.350608457076284e-15,   1.450670873351618e-17,  -1.514467812996709e-19,
   1.488259227022080e-21,  -3.122348309842723e-05,   5.891223055613339e-07,  -8.337128718534573e-09,   1.048770330196553e-10,  -1.236829501885583e-12,   1.400099520579990e-14,
  -1.539885686669436e-16,   1.653973206012584e-18,  -1.726710353053527e-20,   1.696817141409094e-22,  -5.336879944419650e-03,   1.006870527543812e-04,  -1.424734975652212e-06,
   1.791985888808383e-08,  -2.112937719514034e-10,   2.391316299019434e-12,  -2.629087400629097e-14,   2.821114441872743e-16,  -2.934652127396407e-18,   2.841784450463147e-20,
  -4.934637529534644e-03,   9.309941557046295e-05,  -1.317391169888125e-06,   1.657007271260623e-08,  -1.953833236612406e-10,   2.211314014988155e-12,  -2.431262027753975e-14,
   2.608901660433886e-16,  -2.713849870426517e-18,   2.627463351683896e-20,  -4.191352668137606e-03,   7.907786484179288e-05,  -1.119012071887078e-06,   1.407535917484800e-08,
  -1.659741949157875e-10,   1.878556125964462e-12,  -2.065510617970473e-14,   2.216512557590840e-16,  -2.305607560800913e-18,   2.231508328210290e-20,  -3.220141108163078e-03,
   6.075544655777357e-05,  -8.597611841034117e-07,   1.081480057881269e-08,  -1.275318634081588e-10,   1.443524800137503e-12,  -1.587269765776886e-14,   1.703379143253033e-16,
  -1.771791793762488e-18,   1.714269699382766e-20,  -2.168846783877946e-03,   4.092104635015959e-05,  -5.790944523113208e-07,   7.284548722674653e-09,  -8.590488830971510e-11,
   9.723904544491098e-13,  -1.069265275184612e-14,   1.147519417383802e-16,  -1.193576965461076e-18,   1.154519006488296e-20,  -1.197537770889870e-03,   2.259495240154582e-05,
  -3.197568888297629e-07,   4.022355116564072e-09,  -4.743559059215861e-11,   5.369540036115937e-13,  -5.904626203908634e-15,   6.336873808338419e-17,  -6.591117817351965e-19,
   6.374450402958692e-21,  -4.541150934642481e-04,   8.568203687207275e-06,  -1.212552191147478e-07,   1.525329481428085e-09,  -1.798832911205543e-11,   2.036232377758037e-13,
  -2.239167716451962e-15,   2.403102534621693e-17,  -2.499504476286016e-19,   2.417199008083319e-21,  -5.177523029598778e-05,   9.768911060490214e-07,  -1.382474646808217e-08,
   1.739085165504590e-10,  -2.050919201194192e-12,   2.321590859840190e-14,  -2.552969503417331e-16,   2.739881666457894e-18,  -2.849791099388081e-20,   2.755924643215600e-22,
  -3.234343491460321e-05,   5.880147679856635e-07,  -8.017957614289994e-09,   9.718086912159904e-11,  -1.104225954612426e-12,   1.204436467654202e-14,  -1.277016883720165e-16,
   1.325289395183480e-18,  -1.349395304906755e-20,   1.339653711577364e-22,  -2.990567237083998e-05,   5.437018027501368e-07,  -7.413838275292285e-09,   8.986046180925230e-11,
  -1.021071210623407e-12,   1.113765738256631e-14,  -1.180918586188129e-16,   1.225598063895483e-18,  -1.247923498633192e-20,   1.238906457976535e-22,  -2.540106186422030e-05,
   4.618143902124974e-07,  -6.297395662572448e-09,   7.633092020724543e-11,  -8.673705037599815e-13,   9.461543038515872e-15,  -1.003251934144715e-16,   1.041264665640882e-18,
  -1.060278027433730e-20,   1.052605520492188e-22,  -1.951514960031057e-05,   3.548104268349263e-07,  -4.838399899940915e-09,   5.864839223380233e-11,  -6.664660818142038e-13,
   7.270362395713194e-15,  -7.709520448089365e-17,   8.002080286508244e-19,  -8.148569677820782e-21,   8.089509909778040e-23,  -1.314393233935072e-05,   2.389773870539495e-07,
  -3.258903754310416e-09,   3.950368038884903e-11,  -4.489246990488173e-13,   4.897424927611640e-15,  -5.193467327960591e-17,   5.390786737223538e-19,  -5.489669897516564e-21,
   5.449830695292003e-23,  -7.257471695154064e-06,   1.319534916277707e-07,  -1.799455052155085e-09,   2.181291788869639e-11,  -2.478893025956582e-13,   2.704341097867041e-15,
  -2.867884463536822e-17,   2.976922174934081e-19,  -3.031590622506215e-21,   3.009573618295238e-23,  -2.752085679171447e-06,   5.003789186872133e-08,  -6.823719164925515e-10,
   8.271731640405486e-12,  -9.400338473502593e-14,   1.025535507742573e-15,  -1.087564073196684e-17,   1.128924357930346e-19,  -1.149664956069261e-21,   1.141313138152435e-23,
  -3.137747798359970e-07,   5.704995930974889e-09,  -7.779968078509081e-11,   9.430908380353059e-13,  -1.071768734855743e-14,   1.169254039994641e-16,  -1.239977165605977e-18,
   1.287135795695747e-20,  -1.310784743128976e-22,   1.301262015366194e-24,  -2.942286360504165e-04,   5.349177773128790e-06,  -7.293946165267039e-08,   8.840555855609889e-10,
  -1.004515659895649e-11,   1.095676692719568e-13,  -1.161699378364736e-15,   1.205592302789893e-17,  -1.227424679193375e-19,   1.218164679603759e-21,  -2.720522793907068e-04,
   4.946062168546242e-06,  -6.744378039790987e-08,   8.174617483737190e-10,  -9.288696904195129e-12,   1.013193464808586e-13,  -1.074278959260690e-15,   1.114904784077105e-17,
  -1.135124444836911e-19,   1.126552327439003e-21,  -2.310737806999943e-04,   4.201131342154275e-06,  -5.728748785340069e-08,   6.943833386505477e-10,  -7.890479748159761e-12,
   8.607172234475955e-14,  -9.126559884413284e-16,   9.472198557090386e-18,  -9.644396130747442e-20,   9.571445045066605e-22,  -1.775295624716228e-04,   3.227714935458888e-06,
  -4.401498497918172e-08,   5.335251598249051e-10,  -6.062849838294555e-12,   6.613853664760730e-14,  -7.013332940326341e-16,   7.279348507258381e-18,  -7.412017093369093e-20,
   7.355852791516602e-22,  -1.195705185536663e-04,   2.173980309179534e-06,  -2.964628859959283e-08,   3.593654760054220e-10,  -4.083873301442766e-12,   4.455190806360490e-14,
  -4.724485140860839e-16,   4.903901251052694e-18,  -4.993454095931174e-20,   4.955562993702642e-22,  -6.602131170290133e-05,   1.200382580388012e-06,  -1.636966532917032e-08,
   1.984323876344194e-10,  -2.255051919556363e-12,   2.460140941988815e-14,  -2.608907793309087e-16,   2.708052137675860e-18,  -2.757561914979100e-20,   2.736619915907199e-22,
  -2.503575819372331e-05,   4.551953344894029e-07,  -6.207545939876786e-09,   7.524804648483660e-11,  -8.551499034108303e-13,   9.329303505163982e-15,  -9.893544913514934e-17,
   1.026962001607068e-18,  -1.045745412110686e-20,   1.037801152924977e-22,  -2.854413136449959e-06,   5.189842005882105e-08,  -7.077446783910680e-10,   8.579309182749831e-12,
  -9.749892864598218e-14,   1.063671197161519e-15,  -1.128004323945194e-17,   1.170884071298266e-19,  -1.192301375908091e-21,   1.183243302773109e-23,  -8.360710743947512e-04,
   1.520005961138455e-05,  -2.072625383133161e-07,   2.512105203199896e-09,  -2.854400379416624e-11,   3.113437076908037e-13,  -3.301021489454469e-15,   3.425618094646781e-17,
  -3.487054103635696e-19,   3.458260135845496e-21,  -7.730554189931011e-04,   1.405457866462040e-05,  -1.916461789254296e-07,   2.322874200311562e-09,  -2.639447149285936e-11,
   2.879055568879133e-13,  -3.052612311396044e-15,   3.167934464388227e-17,  -3.224831274988091e-19,   3.198171168089134e-21,  -6.566121730625301e-04,   1.193780605996981e-05,
  -1.627863693647030e-07,   1.973138370660604e-09,  -2.242134119438649e-11,   2.445784325857340e-13,  -2.593353193569337e-15,   2.691467198244722e-17,  -2.739921022083646e-19,
   2.717225437142630e-21,  -5.044625636201837e-04,   9.171775833264556e-06,  -1.250716320576741e-07,   1.516048709435337e-09,  -1.722800501469050e-11,   1.879369791422872e-13,
  -1.992870113099553e-15,   2.068381723407514e-17,  -2.105711490796091e-19,   2.088232633030183e-21,  -3.397679208082136e-04,   6.177515815496463e-06,  -8.424198489035681e-08,
   1.021161900277828e-09,  -1.160460699599512e-11,   1.265971608052138e-13,  -1.342483656376669e-15,   1.393412820201732e-17,  -1.418610216049353e-19,   1.406815113318421e-21,
  -1.876041358494008e-04,   3.410970349491749e-06,  -4.651553919403068e-08,   5.638593786824747e-10,  -6.407885195227398e-12,   6.990651371506131e-14,  -7.413328406466912e-16,
   7.694759544464400e-18,  -7.834062695961750e-20,   7.768862810361021e-22,  -7.114084316294456e-05,   1.293469111046419e-06,  -1.763917225295341e-08,   2.138225379576118e-10,
  -2.429967291263833e-12,   2.650982597531678e-14,  -2.811295097484052e-16,   2.918047693092461e-18,  -2.970897335218876e-20,   2.946162663337797e-22,  -8.111012883697897e-06,
   1.474729597865812e-07,  -2.011105582489543e-09,   2.437870149547197e-11,  -2.770499143949384e-13,   3.022491261986282e-15,  -3.205274801761768e-17,   3.326993142119929e-19,
  -3.387253543740530e-21,   3.359050722462478e-23,  -1.701939271218777e-03,   3.094184114731798e-05,  -4.219118003563595e-07,   5.113740292124925e-09,  -5.810528152524877e-11,
   6.337820254954448e-13,  -6.719589815075462e-15,   6.972762843690728e-17,  -7.095652820195673e-19,   7.028059977498005e-21,  -1.573662116423826e-03,   2.861005493077535e-05,
  -3.901225230511982e-07,   4.728534209020750e-09,  -5.372961011326564e-11,   5.860705095388622e-13,  -6.213925471387369e-15,   6.448252253289871e-17,  -6.562058672616294e-19,
   6.499457869507448e-21,  -1.336625650043305e-03,   2.430106908775058e-05,  -3.313743560639640e-07,   4.016598178831650e-09,  -4.564175185314657e-11,   4.978723096009434e-13,
  -5.279052962772369e-15,   5.478412416441622e-17,  -5.575325597356894e-19,   5.522010127815486e-21,  -1.026903901090295e-03,   1.867042880923884e-05,  -2.546007487959619e-07,
   3.086128461324546e-09,  -3.506999520265057e-11,   3.825710037019847e-13,  -4.056703856889860e-15,   4.210135876074931e-17,  -4.284795280783678e-19,   4.243715424541537e-21,
  -6.916449871708804e-04,   1.257519496199630e-05,  -1.714863081251216e-07,   2.078717381464627e-09,  -2.362278805028023e-11,   2.577055484932718e-13,  -2.732771289770220e-15,
   2.836253573926813e-17,  -2.886645940914474e-19,   2.858914212533888e-21,  -3.818943819772804e-04,   6.943505842075911e-06,  -9.468886680592883e-08,   1.147814358053680e-09,
  -1.304413960092110e-11,   1.423041102989663e-13,  -1.509063449664518e-15,   1.566246851148200e-17,  -1.594105394616441e-19,   1.578772875442082e-21,  -1.448171076295692e-04,
   2.633036763404089e-06,  -3.590699497329477e-08,   4.352655793475344e-10,  -4.946535650309516e-12,   5.396431590195853e-14,  -5.722696173626368e-16,   5.939604224827339e-18,
  -6.045294528159929e-20,   5.987123452710369e-22,  -1.651109789453724e-05,   3.002017763005774e-07,  -4.093885869790683e-09,   4.962624488254745e-11,  -5.639735494849311e-13,
   6.152687435738572e-15,  -6.524684588125036e-17,   6.772001121373380e-19,  -6.892511483264261e-21,   6.826183137157087e-23,  -2.988541226475531e-03,   5.433270706004907e-05,
  -7.408612183663056e-07,   8.979534681373596e-09,  -1.020306273675938e-10,   1.112892759025650e-12,  -1.179904180900568e-14,   1.224218887664609e-16,  -1.245127084042100e-18,
   1.230467195707020e-20,  -2.763291376493797e-03,   5.023817833341931e-05,  -6.850404456315360e-07,   8.303127356105018e-09,  -9.434711737966579e-11,   1.029113465173241e-12,
  -1.091113619332855e-14,   1.132129186813121e-16,  -1.151490696044724e-18,   1.137908765000471e-20,  -2.347064273719781e-03,   4.267176157032704e-05,  -5.818808787686771e-07,
   7.052994591867589e-09,  -8.014515079085456e-11,   8.742413695586415e-13,  -9.269576425091267e-15,   9.618521954357960e-17,  -9.783379877662432e-19,   9.667640237996836e-21,
  -1.803204553731326e-03,   3.278456942303848e-05,  -4.470693182127135e-07,   5.419124933355994e-09,  -6.158155480842075e-11,   6.717774474761193e-13,  -7.123232252155491e-15,
   7.391785516827311e-17,  -7.518773657981316e-19,   7.429542228952777e-21,  -1.214502534373157e-03,   2.208156847661196e-05,  -3.011234932201927e-07,   3.650149152455820e-09,
  -4.148070178988494e-11,   4.525193238590559e-13,  -4.798516918902135e-15,   4.979640678411132e-17,  -5.065345509169264e-19,   5.005079998393842e-21,  -6.705921439139387e-04,
   1.219253460345729e-05,  -1.662700809929573e-07,   2.015518628343795e-09,  -2.290500438900904e-11,   2.498795985084566e-13,  -2.649788507686939e-15,   2.749875238619642e-17,
  -2.797253261907455e-19,   2.763924292649382e-21,  -2.542933838877568e-04,   4.623513334636496e-06,  -6.305132972622096e-08,   7.643099053706480e-10,  -8.685925187459187e-12,
   9.475890402127582e-14,  -1.004857293071542e-15,   1.042822091875839e-17,  -1.060796119477359e-19,   1.048149948062749e-21,  -2.899286571890198e-05,   5.271430065460732e-07,
  -7.188709275988546e-09,   8.714181026322686e-11,  -9.903157288892992e-13,   1.080384153878350e-14,  -1.145679704833894e-16,   1.188966795703141e-18,  -1.209461104674855e-20,
   1.195041333755456e-22,  -4.955642193541804e-03,   9.009527893292564e-05,  -1.228506751048021e-06,   1.488999215874137e-08,  -1.691884720748813e-10,   1.845399771289916e-12,
  -1.956433407101347e-14,   2.029443541397536e-16,  -2.061847081134904e-18,   2.027996276105278e-20,  -4.582129641407167e-03,   8.330567230922644e-05,  -1.135943941049832e-06,
   1.376836390219175e-08,  -1.564475783241953e-10,   1.706476818787892e-12,  -1.809206855521754e-14,   1.876780344262930e-16,  -1.906782342787751e-18,   1.875406655513255e-20,
  -3.891935852433522e-03,   7.075893083990471e-05,  -9.648832602758991e-07,   1.169537595880880e-08,  -1.328976975291198e-10,   1.449667705669551e-12,  -1.537014634354989e-14,
   1.594502036151371e-16,  -1.620041634960014e-18,   1.593285155526596e-20,  -2.990099815551284e-03,   5.436384613710289e-05,  -7.413367873605193e-07,   8.986070042157150e-09,
  -1.021153083224622e-10,   1.113941815855336e-12,  -1.181122857460430e-14,   1.225364588900320e-16,  -1.245032304478895e-18,   1.224388209145897e-20,  -2.013905630673163e-03,
   3.661597551071616e-05,  -4.993273167153939e-07,   6.052729237588665e-09,  -6.878382075701486e-11,   7.503678157828993e-13,  -7.956551653098878e-15,   8.254929496699030e-17,
  -8.387640385779819e-19,   8.248130440529724e-21,  -1.111985571286066e-03,   2.021783683190411e-05,  -2.757114448343862e-07,   3.342161653239772e-09,  -3.798136586433316e-11,
   4.143504908117996e-13,  -4.393685862534562e-15,   4.558563428338305e-17,  -4.631917879662781e-19,   4.554737596668735e-21,  -4.216729592241857e-04,   7.666776534160595e-06,
  -1.045526237402263e-07,   1.267389554542197e-09,  -1.440311018464323e-11,   1.571292665041706e-13,  -1.666180911804979e-15,   1.728721776201623e-17,  -1.756549360365000e-19,
   1.727260733685737e-21,  -4.807638837145290e-05,   8.741161407402811e-07,  -1.192042133563563e-08,   1.444997890420892e-10,  -1.642153973229832e-12,   1.791493592454070e-14,
  -1.899682323481365e-16,   1.970990740833867e-18,  -2.002720016478750e-20,   1.969323013958989e-22,  -3.011267859477638e-05,   5.282527241365388e-07,  -6.950350529565191e-09,
   8.128562191482529e-11,  -8.912157717273849e-13,   9.380157132324584e-15,  -9.597825666485012e-17,   9.617621702353633e-19,  -9.476429139247738e-21,   9.180779824483393e-23,
  -2.784302814199322e-05,   4.884426509138945e-07,  -6.426653500916221e-09,   7.516226146152464e-11,  -8.240972833557770e-13,   8.673948132600433e-15,  -8.875486609044625e-17,
   8.894076626599517e-19,  -8.763788122334770e-21,   8.490563996263028e-23,  -2.364907660720166e-05,   4.148767624560467e-07,  -5.458845826054578e-09,   6.384528034111865e-11,
  -7.000403278588361e-13,   7.368508702019391e-15,  -7.540074737166148e-17,   7.556263514276385e-19,  -7.445965647355126e-21,   7.214093841204679e-23,  -1.816910714580374e-05,
   3.187475052703640e-07,  -4.194107537823685e-09,   4.905478113349856e-11,  -5.378883951759304e-13,   5.661976071420576e-15,  -5.794100708649868e-17,   5.806863530008836e-19,
  -5.722421867275366e-21,   5.544439678282323e-23,  -1.223732606895628e-05,   2.146872543604672e-07,  -2.824930221572664e-09,   3.304154717003590e-11,  -3.623132764238721e-13,
   3.813952702423371e-15,  -3.903108231148676e-17,   3.911876775722696e-19,  -3.855161249317258e-21,   3.735370762395058e-23,  -6.756881287519383e-06,   1.185413263216009e-07,
  -1.559826389549311e-09,   1.824463530929388e-11,  -2.000629122589743e-13,   2.106039016753006e-15,  -2.155319592669189e-17,   2.160216146573292e-19,  -2.128950806600309e-21,
   2.062835048692504e-23,  -2.562257562784096e-06,   4.495186245844258e-08,  -5.915017804500282e-10,   6.918585859808393e-12,  -7.586676410804722e-14,   7.986466621761924e-16,
  -8.173417622712437e-18,   8.192063989366798e-20,  -8.073575261412353e-22,   7.822897965533484e-24,  -2.921318099047556e-07,   5.125119431036026e-09,  -6.743924018310871e-11,
   7.888135056374696e-13,  -8.649859078911607e-15,   9.105686591335551e-17,  -9.318850144240549e-19,   9.340124304902861e-21,  -9.205044770387218e-23,   8.919246201704809e-25,
  -2.739354176258487e-04,   4.805521705452090e-06,  -6.322742656674215e-08,   7.394563278211417e-10,  -8.107400962284578e-12,   8.533139405604694e-14,  -8.731144889185297e-16,
   8.749110193352067e-18,  -8.620461437295675e-20,   8.350648183384104e-22,  -2.532883787816947e-04,   4.443368966382199e-06,  -5.846334808154966e-08,   6.837520405368787e-10,
  -7.496823237993733e-12,   7.890700286089377e-14,  -8.074032800767142e-16,   8.090904095863565e-18,  -7.972189594426548e-20,   7.722838629671145e-22,  -2.151359486825334e-04,
   3.774139149644264e-06,  -4.965918943758607e-08,   5.808013205348836e-10,  -6.368275569788334e-12,   6.703140574075302e-14,  -6.859208181362593e-16,   6.873900894951678e-18,
  -6.773399695461910e-20,   6.561783362380320e-22,  -1.652845972572452e-04,   2.899650082522178e-06,  -3.815384925289893e-08,   4.462519626855877e-10,  -4.893177420593961e-12,
   5.150705933624927e-14,  -5.270895064260992e-16,   5.282478947098561e-18,  -5.205536176351753e-20,   5.043098180532250e-22,  -1.113231098579416e-04,   1.953012665290410e-06,
  -2.569842591104630e-08,   3.005793713458055e-10,  -3.295968381321236e-12,   3.469557015194012e-14,  -3.550658650195547e-16,   3.558617487505660e-18,  -3.506937964226057e-20,
   3.397607502240480e-22,  -6.146743444025455e-05,   1.078371943206663e-06,  -1.418976036993455e-08,   1.659716775198309e-10,  -1.819974800664841e-12,   1.915866034903762e-14,
  -1.960694830597313e-16,   1.965139309432560e-18,  -1.936649937718766e-20,   1.876306738283445e-22,  -2.330888942068393e-05,   4.089276607092878e-07,  -5.380899168784183e-09,
   6.293846282744408e-11,  -6.901608965010052e-13,   7.265297563349869e-15,  -7.435360267274060e-17,   7.452285223315614e-19,  -7.344316503317116e-21,   7.115524919187864e-23,
  -2.657526765551000e-06,   4.662327621523615e-08,  -6.134956198586955e-10,   7.175846409702913e-12,  -7.868787560232298e-14,   8.283453213514089e-16,  -8.477360546624028e-18,
   8.496670724024536e-20,  -8.373584153898932e-22,   8.112737437464118e-24,  -7.784064868897764e-04,   1.365522319359228e-05,  -1.796651173987701e-07,   2.101216426995249e-09,
  -2.303774102423431e-11,   2.424749882479810e-13,  -2.481009653301663e-15,   2.486087872026325e-17,  -2.449403805140938e-19,   2.372199577948579e-21,  -7.197364941205057e-04,
   1.262614106988311e-05,  -1.661276579949191e-07,   1.942928832285268e-09,  -2.130274215303829e-11,   2.242196412908747e-13,  -2.294287107321760e-15,   2.299056380500390e-17,
  -2.265204393813424e-19,   2.193853235593822e-21,  -6.113237180830528e-04,   1.072447813388928e-05,  -1.411100306410986e-07,   1.650387223084776e-09,  -1.809589583167683e-11,
   1.904743200577391e-13,  -1.949087038355489e-15,   1.953240863836351e-17,  -1.924581556412835e-19,   1.864025273163649e-21,  -4.696676457650598e-04,   8.239556803003446e-06,
  -1.084168086130926e-07,   1.268055893518375e-09,  -1.390430233289879e-11,   1.463608285415785e-13,  -1.497757879238810e-15,   1.501033119523308e-17,  -1.479091063561939e-19,
   1.432605401695334e-21,  -3.163323370347035e-04,   5.549620931724901e-06,  -7.302385940619804e-08,   8.541171247762300e-10,  -9.365722291098157e-12,   9.858983312799633e-14,
  -1.008941905150942e-15,   1.011192362420322e-17,  -9.964543153371270e-20,   9.651654752252273e-22,  -1.746639777924418e-04,   3.064268662750379e-06,  -4.032118814774970e-08,
   4.716200295469165e-10,  -5.171584367741662e-12,   5.444064232113996e-14,  -5.571437187833080e-16,   5.584005007793410e-18,  -5.502757276033952e-20,   5.330059643173106e-22,
  -6.623382578457836e-05,   1.161996307430919e-06,  -1.529019815219787e-08,   1.788440060479296e-10,  -1.961139957584826e-12,   2.064483939064047e-14,  -2.112804193026393e-16,
   2.117590199672989e-18,  -2.086798834995042e-20,   2.021319875239623e-22,  -7.551546606556177e-06,   1.324832727345152e-07,  -1.743290349605943e-09,   2.039066512020156e-11,
  -2.235970449820953e-13,   2.353799822931939e-15,  -2.408895098201162e-17,   2.414355606943908e-19,  -2.379252780419542e-21,   2.304599704013713e-23,  -1.584554961406647e-03,
   2.779711118023609e-05,  -3.657334024639390e-07,   4.277319037419974e-09,  -4.689653093373346e-11,   4.935913491514114e-13,  -5.050420758157253e-15,   5.060662488811459e-17,
  -4.985529013475957e-19,   4.826443708891962e-21,  -1.465124008949265e-03,   2.570227100070457e-05,  -3.381760159197147e-07,   3.955102566129083e-09,  -4.336469903854864e-11,
   4.564300664317781e-13,  -4.670322441101745e-15,   4.679942154056548e-17,  -4.610606747167498e-19,   4.463574952268284e-21,  -1.244434683971489e-03,   2.183117088686331e-05,
  -2.872491464951477e-07,   3.359593327504348e-09,  -3.683671663188268e-11,   3.877368000623233e-13,  -3.967622310200561e-15,   3.976002111269265e-17,  -3.917298983750480e-19,
   3.792501899033834e-21,  -9.560739932715340e-04,   1.677276696848353e-05,  -2.206975336776898e-07,   2.581304592596430e-09,  -2.830414418203916e-11,   2.979376908395911e-13,
  -3.048882531048350e-15,   3.055491058957148e-17,  -3.010544210248231e-19,   2.914736262321989e-21,  -6.439385880563061e-04,   1.129702736162754e-05,  -1.486502496861049e-07,
   1.738674507933817e-09,  -1.906523230261699e-11,   2.006932279677113e-13,  -2.053833486091271e-15,   2.058374883221187e-17,  -2.028183514442525e-19,   1.963692167875202e-21,
  -3.555528856084769e-04,   6.237746208677318e-06,  -8.207940164389850e-08,   9.600483341164277e-10,  -1.052748034317014e-11,   1.108214495664609e-13,  -1.134139048841682e-15,
   1.136675407141129e-17,  -1.120031079384633e-19,   1.084433914169001e-21,  -1.348281894196903e-04,   2.365405536820017e-06,  -3.112533070080038e-08,   3.640619127991733e-10,
  -3.992173555271732e-12,   4.202542306982840e-14,  -4.300889781953489e-16,   4.310548861816806e-18,  -4.247469320454421e-20,   4.112499331848416e-22,  -1.537222626384115e-05,
   2.696881778868182e-07,  -3.548710624864666e-09,   4.150804218121693e-11,  -4.551629303907112e-13,   4.791484762714497e-15,  -4.903621613491266e-17,   4.914642017433658e-19,
  -4.842729840377825e-21,   4.688849119397860e-23,  -2.782418801852878e-03,   4.881067975716230e-05,  -6.422140720612597e-07,   7.510810936355520e-09,  -8.234852974156511e-11,
   8.667268879412747e-13,  -8.868286725831249e-15,   8.885979258424268e-17,  -8.752645429718854e-19,   8.467369878706013e-21,  -2.572702549823548e-03,   4.513221934151017e-05,
  -5.938243397868038e-07,   6.945010962815656e-09,  -7.614676683967683e-11,   8.014731419595989e-13,  -8.200852844598152e-15,   8.217474102045284e-17,  -8.094422381551054e-19,
   7.830739350662739e-21,  -2.185180411341612e-03,   3.833471341580437e-05,  -5.043986762528037e-07,   5.899319195328693e-09,  -6.468387726027282e-11,   6.808504789550459e-13,
  -6.966946230609218e-15,   6.981429595272829e-17,  -6.877237103349213e-19,   6.653398305546615e-21,  -1.678829904694231e-03,   2.945234675037082e-05,  -3.875365521413510e-07,
   4.532673525052671e-09,  -4.970100361570252e-11,   5.231667926350661e-13,  -5.353684911484131e-15,   5.365110415962560e-17,  -5.285325646193376e-19,   5.113457106907836e-21,
  -1.130731895254524e-03,   1.983715434240040e-05,  -2.610242365554571e-07,   3.053046871243587e-09,  -3.347782475989595e-11,   3.524093628384118e-13,  -3.606428532623306e-15,
   3.614281999184634e-17,  -3.560685095458059e-19,   3.444981518020470e-21,  -6.243374689204506e-04,   1.095324728614218e-05,  -1.441283361190424e-07,   1.685808671607980e-09,
  -1.848585615673836e-11,   1.945980773747853e-13,  -1.991491213351750e-15,   1.995877925180782e-17,  -1.966328833276552e-19,   1.902459854439801e-21,  -2.367532199249550e-04,
   4.153562987342299e-06,  -5.465490775038798e-08,   6.392789902114702e-10,  -7.010105331755398e-12,   7.379497879095881e-14,  -7.552146407982056e-16,   7.568852896156425e-18,
  -7.456864169246241e-20,   7.214692823792982e-22,  -2.699305005165226e-05,   4.735622777396449e-07,  -6.231402123857994e-09,   7.288655681437082e-11,  -7.992488404845850e-13,
   8.413657508769248e-15,  -8.610513215695157e-17,   8.629574421592747e-19,  -8.501904224685748e-21,   8.225800937296111e-23,  -4.613847014325051e-03,   8.093857361810433e-05,
  -1.064928640381707e-06,   1.245453473567518e-08,  -1.365514839148540e-10,   1.437216053452589e-12,  -1.470531951670475e-14,   1.473369755297349e-16,  -1.450794123612987e-18,
   1.401499197438875e-20,  -4.266092498492646e-03,   7.483889746859790e-05,  -9.846880881303108e-07,   1.151631707934643e-08,  -1.262676337874012e-10,   1.329011563921131e-12,
  -1.359858548649080e-14,   1.362525608109703e-16,  -1.341688475431907e-18,   1.296117257216311e-20,  -3.623497695571698e-03,   6.356717503966528e-05,  -8.364011625810889e-07,
   9.782335946850908e-09,  -1.072597097773096e-10,   1.128993724882802e-12,  -1.155253089356600e-14,   1.157578587069600e-16,  -1.139931603027057e-18,   1.101236111206202e-20,
  -2.783859977575588e-03,   4.883830644305034e-05,  -6.426187022456297e-07,   7.516144436740422e-09,  -8.241489903547069e-11,   8.675208962000446e-13,  -8.877433912554419e-15,
   8.895790885265296e-17,  -8.760632264705417e-19,   8.463434511764093e-21,  -1.874995947931034e-03,   3.289425562393094e-05,  -4.328341551803137e-07,   5.062606235794569e-09,
  -5.551339696937788e-11,   5.843690524749488e-13,  -5.980148103487055e-15,   5.992772089050775e-17,  -5.901961895771410e-19,   5.701840304807459e-21,  -1.035285401676787e-03,
   1.816283272909695e-05,  -2.389956864709553e-07,   2.795432187052148e-09,  -3.065350504828509e-11,   3.226846541354999e-13,  -3.302273094416588e-15,   3.309326374730202e-17,
  -3.259256059870738e-19,   3.148773472126927e-21,  -3.925876062061359e-04,   6.887498090570555e-06,  -9.062955660559669e-08,   1.060061616587194e-09,  -1.162425463478294e-11,
   1.223676383244930e-13,  -1.252290210136291e-15,   1.254976670323313e-17,  -1.235999736762076e-19,   1.194106111975351e-21,  -4.476026517121750e-05,   7.852678034828470e-07,
  -1.033300090991611e-08,   1.208615368668914e-10,  -1.325325597573190e-12,   1.395161859894527e-14,  -1.427787650551212e-16,   1.430852807649398e-18,  -1.409218458371380e-20,
   1.361454501574237e-22,  -2.810502000014301e-05,   4.763227068549776e-07,  -6.054670674992218e-09,   6.841041542796382e-11,  -7.246310901821189e-13,   7.368394758732463e-15,
  -7.284154877243436e-17,   7.053267291057588e-19,  -6.720564066995474e-21,   6.314703182631410e-23,  -2.598667163179872e-05,   4.404255293063183e-07,  -5.598447959796180e-09,
   6.325673142331433e-11,  -6.700548628928479e-13,   6.813600134561771e-15,  -6.735886314544458e-17,   6.522575536531520e-19,  -6.215108265774988e-21,   5.839956419627097e-23,
  -2.207231366163670e-05,   3.740907535208521e-07,  -4.755343057658376e-09,   5.373201205803815e-11,  -5.691821838803596e-13,   5.788080741541160e-15,  -5.722319326959934e-17,
   5.541382413163567e-19,  -5.280450872282705e-21,   4.961972797877091e-23,  -1.695769047109553e-05,   2.874111101576242e-07,  -3.653581031297998e-09,   4.128410604308988e-11,
  -4.373373281872368e-13,   4.447519614123572e-15,  -4.397197448157507e-17,   4.258385598847856e-19,  -4.058098547208363e-21,   3.813552960043995e-23,  -1.142139665775852e-05,
   1.935807417006261e-07,  -2.460851783854023e-09,   2.780735896267149e-11,  -2.945815745660325e-13,   2.995857156499509e-15,  -2.962070549471593e-17,   2.868682621018098e-19,
  -2.733880692114270e-21,   2.569244791554483e-23,  -6.306359434040585e-06,   1.068870688450767e-07,  -1.358792556451830e-09,   1.535441590174545e-11,  -1.626620201324160e-13,
   1.654283273440861e-15,  -1.635661848396391e-17,   1.584130901332098e-19,  -1.509730207442367e-21,   1.418848674178222e-23,  -2.391415944008436e-06,   4.053245294358103e-08,
  -5.152673658348653e-10,   5.822573467799282e-12,  -6.168370858169926e-14,   6.273317534012989e-16,  -6.202752131758648e-18,   6.007390836522967e-20,  -5.725301749729248e-22,
   5.380704874364878e-24,  -2.726535586993368e-07,   4.621246726062377e-09,  -5.874747401281802e-11,   6.638529687950328e-13,  -7.032793064414720e-15,   7.152455141215986e-17,
  -7.072010237363955e-19,   6.849281116881351e-21,  -6.527669882769604e-23,   6.134789235498792e-25,  -2.556717220254621e-04,   4.333113682199571e-06,  -5.507941562379943e-08,
   6.223304131233293e-10,  -6.591978148417753e-12,   6.703037744655376e-14,  -6.626403031517420e-16,   6.416355472845813e-18,  -6.113652273255936e-20,   5.744258912756757e-22,
  -2.364010801550183e-04,   4.006556604508494e-06,  -5.092915181983310e-08,   5.754472846444212e-10,  -6.095497521685868e-12,   6.198340393966987e-14,  -6.127642561133071e-16,
   5.933585281683987e-18,  -5.653842329094468e-20,   5.312398065618686e-22,  -2.007921162457122e-04,   3.403108311103524e-06,  -4.325941587346966e-08,   4.888007922865034e-10,
  -5.177857490857593e-12,   5.265424143769461e-14,  -5.205599643185563e-16,   5.040994100136135e-18,  -4.803590517754126e-20,   4.513726930212505e-22,  -1.542643244622381e-04,
   2.614582500303264e-06,  -3.323667280024124e-08,   3.755620340595068e-10,  -3.978463178991284e-12,   4.045914042204175e-14,  -4.000134930792936e-16,   3.873852199737265e-18,
  -3.691624657111624e-20,   3.469050141144815e-22,  -1.039005896957238e-04,   1.761006452981577e-06,  -2.238639976756397e-08,   2.529638956675647e-10,  -2.679812291453313e-12,
   2.725334925287070e-14,  -2.694598547109603e-16,   2.609639763756706e-18,  -2.486992570965648e-20,   2.337147893075035e-22,  -5.736903144720997e-05,   9.723530157124906e-07,
  -1.236095305271783e-08,   1.396793153716218e-10,  -1.479738444397250e-12,   1.504903520208071e-14,  -1.487963221309944e-16,   1.441083422990700e-18,  -1.373391211857770e-20,
   1.290674530422890e-22,  -2.175474105624794e-05,   3.687242365214398e-07,  -4.687393736770001e-09,   5.296802437077380e-11,  -5.611374733110963e-13,   5.706844644710712e-15,
  -5.642649823424579e-17,   5.464921697319529e-19,  -5.208267673350409e-21,   4.894629405235087e-23,  -2.480332868244708e-06,   4.203953985258134e-08,  -5.344265132967716e-10,
   6.039078841032193e-12,  -6.397740702076297e-14,   6.506597202764175e-16,  -6.433414791912555e-18,   6.230789038687366e-20,  -5.938176443138333e-22,   5.580592185729429e-24,
  -7.265089292357701e-04,   1.231284303384858e-05,  -1.565119792947660e-07,   1.768395026091590e-09,  -1.873156285931282e-11,   1.904714490804476e-13,  -1.882937226194477e-15,
   1.823245297797242e-17,  -1.737203681123673e-19,   1.632125670000317e-21,  -6.717500639218029e-04,   1.138490845052080e-05,  -1.447187168717594e-07,   1.635173365272644e-09,
  -1.732077874206068e-11,   1.761301250718343e-13,  -1.741211062147679e-15,   1.686063274704870e-17,  -1.606547870434284e-19,   1.509419875075336e-21,  -5.705647234547449e-04,
   9.670168275052096e-06,  -1.229246302780235e-07,   1.388961348490578e-09,  -1.471324098345181e-11,   1.496206651342965e-13,  -1.479206327588690e-15,   1.432428191546418e-17,
  -1.364947376631791e-19,   1.282491557942262e-21,  -4.383527763511449e-04,   7.429517498589179e-06,  -9.444431075048625e-08,   1.067185564132974e-09,  -1.130507890476858e-11,
   1.149674429215114e-13,  -1.136665376257526e-15,   1.100777914317569e-17,  -1.048980501910825e-19,   9.856655440006667e-22,  -2.952407312345924e-04,   5.004021963750273e-06,
  -6.361250745339142e-08,   7.188144519921237e-10,  -7.614872386651551e-12,   7.744227485992511e-14,  -7.656883866894310e-16,   7.415444925033386e-18,  -7.066824807203804e-20,
   6.640564624035384e-22,  -1.630180814593749e-04,   2.763008527825606e-06,  -3.512450534078672e-08,   3.969084610598377e-10,  -4.204779362811664e-12,   4.276287326604508e-14,
  -4.228148039009494e-16,   4.094923288042279e-18,  -3.902510474968005e-20,   3.667207169294435e-22,  -6.181760542529615e-05,   1.047755489479508e-06,  -1.331955437734863e-08,
   1.505123144570175e-10,  -1.594511027527397e-12,   1.621639334273097e-14,  -1.603397075115385e-16,   1.552889630070503e-18,  -1.479936565901068e-20,   1.390716091084002e-22,
  -7.048037858787047e-06,   1.194582679762995e-07,  -1.518610000417449e-09,   1.716046132265191e-11,  -1.817962368562684e-13,   1.848894549087150e-15,  -1.828098283957753e-17,
   1.770515336692060e-19,  -1.687341161096550e-21,   1.585619377556426e-23,  -1.478910245119629e-03,   2.506450915652149e-05,  -3.186019611179181e-07,   3.599814690465895e-09,
  -3.813070777971594e-11,   3.877311374609916e-13,  -3.832977234582127e-15,   3.711446545300877e-17,  -3.536202526889104e-19,   3.321899248839893e-21,  -1.367440938047049e-03,
   2.317556890149293e-05,  -2.945951307595648e-07,   3.328623421164629e-09,  -3.525886001294176e-11,   3.585373767245187e-13,  -3.544474155664343e-15,   3.432195095985731e-17,
  -3.270242874091185e-19,   3.072151916083510e-21,  -1.161464066117799e-03,   1.968497613498446e-05,  -2.502302280801354e-07,   2.827424525011027e-09,  -2.995085335552144e-11,
   3.045736821346785e-13,  -3.011127529749203e-15,   2.915888685256441e-17,  -2.778447274939878e-19,   2.610277904034705e-21,  -8.923282093783489e-04,   1.512381899614652e-05,
  -1.922545657976424e-07,   2.172405042086773e-09,  -2.301306427215766e-11,   2.340322264167267e-13,  -2.313838386578200e-15,   2.240772523805653e-17,  -2.135273825026296e-19,
   2.006140709086025e-21,  -6.010036829949906e-04,   1.018638457300456e-05,  -1.294921303629351e-07,   1.463247060583828e-09,  -1.550113441188064e-11,   1.576445255161813e-13,
  -1.558663797128782e-15,   1.509507457107349e-17,  -1.438501813128067e-19,   1.351563623580852e-21,  -3.318460394748615e-04,   5.624489190256960e-06,  -7.150082910743354e-08,
   8.079625240607496e-10,  -8.559414624663649e-12,   8.704977836310226e-14,  -8.606975593023837e-16,   8.335733306008787e-18,  -7.943833347812568e-20,   7.463915980048643e-22,
  -1.258383569881260e-04,   2.132852419839423e-06,  -2.711381048876705e-08,   3.063888060382963e-10,  -3.245849503685944e-12,   3.301072491775636e-14,  -3.263934788333921e-16,
   3.161102860408428e-18,  -3.012514405091596e-20,   2.830542663535641e-22,  -1.434726398795353e-05,   2.431739642324815e-07,  -3.091342442183119e-09,   3.493251216473087e-11,
  -3.700715861994869e-13,   3.763682100581434e-15,  -3.721344935019854e-17,   3.604107452529877e-19,  -3.434700946581390e-21,   3.227231785606833e-23,  -2.596910661043572e-03,
   4.401233357878352e-05,  -5.594530377704325e-07,   6.321138923901483e-09,  -6.695608377135744e-11,   6.808410852131728e-13,  -6.730551287688387e-15,   6.517089163213743e-17,
  -6.209080741180172e-19,   5.831543992525905e-21,  -2.401174758292746e-03,   4.069542567144662e-05,  -5.172979483155988e-07,   5.844937275790861e-09,  -6.191322747109814e-11,
   6.295779544676527e-13,  -6.223951635171390e-15,   6.026739247168276e-17,  -5.742091311344578e-19,   5.393111134168884e-21,  -2.039487132957362e-03,   3.456607630864927e-05,
  -4.393948510228339e-07,   4.964850903610081e-09,  -5.259256809984488e-11,   5.348197647014545e-13,  -5.287416715419235e-15,   5.120134233177654e-17,  -4.878565012724307e-19,
   4.582291806560921e-21,  -1.566894710298714e-03,   2.655685624987145e-05,  -3.375917727649189e-07,   3.814661378417738e-09,  -4.041007230326924e-11,   4.109516592520445e-13,
  -4.063005466232496e-15,   3.934668476859900e-17,  -3.749240971690632e-19,   3.521734846027132e-21,  -1.055339819875183e-03,   1.788690745902801e-05,  -2.273833012333853e-07,
   2.569406690210949e-09,  -2.721940697879524e-11,   2.768177709198858e-13,  -2.736949781608900e-15,   2.650608667534980e-17,  -2.525806439207701e-19,   2.372636356660257e-21,
  -5.827091404506607e-04,   9.876391071768603e-06,  -1.255527615291350e-07,   1.418751741015054e-09,  -1.503000902733468e-11,   1.528560887647678e-13,  -1.511349649740856e-15,
   1.463706994596640e-17,  -1.394824941113724e-19,   1.310270896345644e-21,  -2.209674129373753e-04,   3.745208477454519e-06,  -4.761082948179719e-08,   5.380071959375509e-10,
  -5.699589221822466e-12,   5.796557316434400e-14,  -5.731335746790541e-16,   5.550715385289854e-18,  -5.289549490372634e-20,   4.968942055709084e-22,  -2.519325491866366e-05,
   4.270043177240907e-07,  -5.428280836645593e-09,   6.134017479228398e-11,  -6.498317379152299e-13,   6.608882134544332e-15,  -6.534529219471611e-17,   6.328606037170391e-19,
  -6.030849320276859e-21,   5.665318944440308e-23,  -4.306234737925169e-03,   7.298188674378774e-05,  -9.276931010105106e-07,   1.048180372462148e-08,  -1.110275373935314e-10,
   1.128979933579323e-12,  -1.116065768378276e-14,   1.080650068123211e-16,  -1.029481834324495e-18,   9.664723109953927e-21,  -3.981662639035137e-03,   6.748174218090217e-05,
  -8.577909233109335e-07,   9.692159283871457e-09,  -1.026654008009795e-10,   1.043974711891083e-12,  -1.032060966760702e-14,   9.993411919019374e-17,  -9.520533651651018e-19,
   8.938082968565090e-21,  -3.381906998665481e-03,   5.731796660629951e-05,  -7.286108831145375e-07,   8.232787368935806e-09,  -8.720974986127110e-11,   8.868453921310454e-13,
  -8.767639280733441e-15,   8.490097476060722e-17,  -8.088779463905072e-19,   7.594275682441254e-21,  -2.598247422746485e-03,   4.403696231258870e-05,  -5.597995495689321e-07,
   6.325526510514729e-09,  -6.700856077571475e-11,   6.814456161806461e-13,  -6.737309991719713e-15,   6.524382497612534e-17,  -6.216328159326107e-19,   5.836584605091347e-21,
  -1.749979720455925e-03,   2.966032809947668e-05,  -3.770502715958990e-07,   4.260627228035992e-09,  -4.513561055980402e-11,   4.590229816538168e-13,  -4.538433165714993e-15,
   4.395181695149840e-17,  -4.187843004140430e-19,   3.932168674657524e-21,  -9.662567066156564e-04,   1.637717421518344e-05,  -2.081934010866604e-07,   2.352594597224685e-09,
  -2.492297626315323e-11,   2.534680388538602e-13,  -2.506132683233131e-15,   2.427086975417525e-17,  -2.312649860622670e-19,   2.171507704725360e-21,  -3.664113532338319e-04,
   6.210358749642781e-06,  -7.894896454400628e-08,   8.921312910706774e-10,  -9.451140489400783e-12,   9.611929927540451e-14,  -9.503749034370033e-16,   9.204074817074052e-18,
  -8.770186126226254e-20,   8.235006711365275e-22,  -4.177581890651287e-05,   7.080647223450158e-07,  -9.001253621742550e-09,   1.017151624459323e-10,  -1.077560296085043e-12,
   1.095893795272033e-14,  -1.083561118398631e-16,   1.049395603557250e-18,  -9.999276881121589e-21,   9.389108278134654e-23,  -2.629166894275333e-05,   4.309825562351930e-07,
  -5.298737466532779e-09,   5.790657866840984e-11,  -5.932627183636554e-13,   5.834835801439491e-15,  -5.579114217960385e-17,   5.225514934346174e-19,  -4.817259575045090e-21,
   4.383621999333259e-23,  -2.430998150007800e-05,   3.985018290897952e-07,  -4.899463952623577e-09,   5.354402233702309e-11,  -5.485780825562034e-13,   5.395475512121319e-15,
  -5.159141166696390e-17,   4.832297674984871e-19,  -4.454903466199088e-21,   4.054018599857105e-23,  -2.064816005053468e-05,   3.384806660375973e-07,  -4.161608349059854e-09,
   4.548152282362868e-11,  -4.659894608978012e-13,   4.583352701944394e-15,  -4.382774641086126e-17,   4.105308593073168e-19,  -3.784886439513453e-21,   3.444481927072865e-23,
  -1.586352520555296e-05,   2.600515500515498e-07,  -3.197396041955261e-09,   3.494477779694722e-11,  -3.580451962173263e-13,   3.521777522646854e-15,  -3.367805978683424e-17,
   3.154753100247012e-19,  -2.908681805358410e-21,   2.647233944232175e-23,  -1.068444137624113e-05,   1.751528701003279e-07,  -2.153584103074039e-09,   2.353732898123324e-11,
  -2.411704724152482e-13,   2.372255628684959e-15,  -2.268620272131051e-17,   2.125187013551478e-19,  -1.959506527387029e-21,   1.783456549985994e-23,  -5.899444216867111e-06,
   9.671187933287332e-08,  -1.189128486243982e-09,   1.299659545648424e-11,  -1.331689973834086e-13,   1.309930182403386e-15,  -1.252729285179788e-17,   1.173552179046434e-19,
  -1.082088469776989e-21,   9.848950636156906e-24,  -2.237110386780148e-06,   3.667392326480170e-08,  -4.509288039889517e-10,   4.928455643987317e-12,  -5.049947339811504e-14,
   4.967464217664091e-16,  -4.750585265138577e-18,   4.450368595846648e-20,  -4.103556377470749e-22,   3.735010833460625e-24,  -2.550606429830508e-07,   4.181321989999771e-09,
  -5.141199905309547e-11,   5.619112231719713e-13,  -5.757634773896356e-15,   5.663598889849587e-17,  -5.416333571545312e-19,   5.074051604907684e-21,  -4.678643715732745e-23,
   4.258455797074733e-25,  -2.391756445461903e-04,   3.920653759185199e-06,  -4.820268167783911e-08,   5.267768776848704e-10,  -5.396918437734685e-12,   5.307957446221928e-14,
  -5.075326884262667e-16,   4.753655399493674e-18,  -4.382256328160755e-20,   3.987738418264888e-22,  -2.211482088431554e-04,   3.625176173975968e-06,  -4.457048547734296e-08,
   4.870906476254880e-10,  -4.990421741713873e-12,   4.908270839817346e-14,  -4.693276895361815e-16,   4.395945315326874e-18,  -4.052621293376032e-20,   3.687901243376354e-22,
  -1.878365728525088e-04,   3.079162895371593e-06,  -3.785820372957848e-08,   4.137459876976501e-10,  -4.239112007937298e-12,   4.169481700645598e-14,  -3.987015335793737e-16,
   3.734602717229107e-18,  -3.443107413179754e-20,   3.133411445257501e-22,  -1.443106892177203e-04,   2.365692236358498e-06,  -2.908675218989009e-08,   3.178930850782528e-10,
  -3.257141669538774e-12,   3.203765428561174e-14,  -3.063697127511034e-16,   2.869881568788917e-18,  -2.646024890828223e-20,   2.408162588191784e-22,  -9.719649818893704e-05,
   1.593367872216547e-06,  -1.959118179426154e-08,   2.141193790905871e-10,  -2.193930831804669e-12,   2.158043920036679e-14,  -2.063766574574205e-16,   1.933284422692928e-18,
  -1.782561080003771e-20,   1.622392722260240e-22,  -5.366731857554423e-05,   8.797891881669772e-07,  -1.081751686292941e-08,   1.182301930542605e-10,  -1.211440050155826e-12,
   1.191645129443625e-14,  -1.139609328597947e-16,   1.067581407861953e-18,  -9.843747649887081e-21,   8.959492331410316e-23,  -2.035102145261858e-05,   3.336231432850522e-07,
  -4.102105026966933e-09,   4.483422325476611e-11,  -4.593943469442030e-13,   4.518908427419365e-15,  -4.321613095538358e-17,   4.048504066092606e-19,  -3.733000994398917e-21,
   3.397702123058783e-23,  -2.320289891701654e-06,   3.803753897062576e-08,  -4.676956049303272e-10,   5.111713495846382e-12,  -5.237727621522949e-14,   5.152183011566453e-16,
  -4.927245125782540e-18,   4.615869025201804e-20,  -4.256157349581059e-22,   3.873874780215420e-24,  -6.796341810583978e-04,   1.114080955813838e-05,  -1.369712628909431e-07,
   1.496873030071762e-09,  -1.533571798208514e-11,   1.508292886234652e-13,  -1.442189105031853e-15,   1.350782830141268e-17,  -1.245241862637072e-19,   1.133113819248265e-21,
  -6.284079722867563e-04,   1.030118950808862e-05,  -1.266501254908449e-07,   1.384101855104906e-09,  -1.418062943228462e-11,   1.394719167546560e-13,  -1.333626967412502e-15,
   1.249137123605435e-17,  -1.151574260057073e-19,   1.047915141692423e-21,  -5.337506484226353e-04,   8.749654910345776e-06,  -1.075767114012203e-07,   1.175687917444532e-09,
  -1.204573072511788e-11,   1.184787114561673e-13,  -1.132937877850612e-15,   1.061212215604267e-17,  -9.783775625688272e-20,   8.903570278493047e-22,  -4.100688315089582e-04,
   6.722278552828193e-06,  -8.265202354240120e-08,   9.033152472238180e-10,  -9.255393915195864e-12,   9.103721444975413e-14,  -8.705706464608865e-16,   8.154959413607396e-18,
  -7.518822340201273e-20,   6.842778768609614e-22,  -2.761905902823850e-04,   4.527665310621390e-06,  -5.566970173608409e-08,   6.084350649235578e-10,  -6.234206593053471e-12,
   6.132231322721937e-14,  -5.864334902202641e-16,   5.493556282323485e-18,  -5.065243245526550e-20,   4.610018062707862e-22,  -1.524994076169244e-04,   2.499981992471099e-06,
  -3.073872437142569e-08,   3.359592928597013e-10,  -3.442390907781737e-12,   3.386142200345572e-14,  -3.238278417561936e-16,   3.033603573244703e-18,  -2.797153829258555e-20,
   2.545833558387296e-22,  -5.782883882217849e-05,   9.480132987562222e-07,  -1.165641591913604e-08,   1.273995546439442e-10,  -1.305400892762787e-12,   1.284079139594726e-14,
  -1.228016133476117e-16,   1.150409354935589e-18,  -1.060752300405426e-20,   9.654546844430297e-23,  -6.593264641794181e-06,   1.080863049278959e-07,  -1.328989496558726e-09,
   1.452528839716219e-11,  -1.488336623787666e-13,   1.464028500412936e-15,  -1.400110647136888e-17,   1.311629881083398e-19,  -1.209409989923111e-21,   1.100758807129936e-23,
  -1.383490158005948e-03,   2.267867156396916e-05,  -2.788241077534812e-07,   3.047093806725709e-09,  -3.121799254368704e-11,   3.070340400142053e-13,  -2.935776248653093e-15,
   2.749702154226104e-17,  -2.534839780048111e-19,   2.306505334136091e-21,  -1.279212065993041e-03,   2.096950785784565e-05,  -2.578139931801778e-07,   2.817532352999697e-09,
  -2.886664872103425e-11,   2.839145265090740e-13,  -2.714782934975260e-15,   2.542788478597581e-17,  -2.344168013190335e-19,   2.133079150960351e-21,  -1.086523882262710e-03,
   1.781114280558214e-05,  -2.189873988047341e-07,   2.393276717463531e-09,  -2.452076468678903e-11,   2.411799309769307e-13,  -2.306252413133518e-15,   2.160241750541960e-17,
  -1.991605175576413e-19,   1.812361916999970e-21,  -8.347522951452237e-04,   1.368413548993230e-05,  -1.682497206480696e-07,   1.838824162114873e-09,  -1.884064499279330e-11,
   1.853189389186151e-13,  -1.772167468075104e-15,   1.660052847229971e-17,  -1.530546606137360e-19,   1.392878099279658e-21,  -5.622244643353205e-04,   9.216694172475510e-06,
  -1.133234416317769e-07,   1.238554427034125e-09,  -1.269059688919473e-11,   1.248301157456410e-13,  -1.193766819797735e-15,   1.118288050747894e-17,  -1.031091058794579e-19,
   9.383894967992979e-22,  -3.104338119239223e-04,   5.089061995649064e-06,  -6.257296030889686e-08,   6.838919935133827e-10,  -7.007466739026607e-12,   6.892964412202088e-14,
  -6.591965481751550e-16,   6.175312374763032e-18,  -5.693942193462607e-20,   5.182155737146136e-22,  -1.177186662901545e-04,   1.929813280495440e-06,  -2.372826021791844e-08,
   2.593395606249840e-10,  -2.657325557188033e-12,   2.613922064575762e-14,  -2.499797397415580e-16,   2.341814591220398e-18,  -2.159288543255614e-20,   1.965225207371520e-22,
  -1.342150968164306e-05,   2.200247475042756e-07,  -2.705343462346438e-09,   2.956825022975014e-11,  -3.029716748328413e-13,   2.980234069977998e-15,  -2.850119681827220e-17,
   2.670000882413025e-19,  -2.461899097306386e-21,   2.240642644338506e-23,  -2.429356583763561e-03,   3.982289267178735e-05,  -4.896046263298075e-07,   5.350581897649387e-09,
  -5.481761810108986e-11,   5.391401692488715e-13,  -5.155110059737919e-15,   4.828359320290619e-17,  -4.451011719806361e-19,   4.049816058962415e-21,  -2.246248183672744e-03,
   3.682166560980985e-05,  -4.527116568598376e-07,   4.947480635705633e-09,  -5.068874698409504e-11,   4.985431772569661e-13,  -4.767054300910968e-15,   4.465027710327014e-17,
  -4.116204407392625e-19,   3.745309226502847e-21,  -1.907894994060310e-03,   3.127569559389162e-05,  -3.845336202329066e-07,   4.202503727372675e-09,  -4.305753844211503e-11,
   4.235028425881081e-13,  -4.049690422932495e-15,   3.793291963510371e-17,  -3.497126975014896e-19,   3.182185051183260e-21,  -1.465793574524343e-03,   2.402882626456443e-05,
  -2.954401693297333e-07,   3.228905934211343e-09,  -3.308346237847376e-11,   3.254130518403463e-13,  -3.111857817276070e-15,   2.914981621936123e-17,  -2.687538336605423e-19,
   2.445644870456159e-21,  -9.872449732165533e-04,   1.618416765655164e-05,  -1.989916931555549e-07,   2.174854900034138e-09,  -2.228420974368954e-11,   2.191969646969602e-13,
  -2.096208551259224e-15,   1.963665838275709e-17,  -1.810527368581681e-19,   1.647643498055523e-21,  -5.451100757429126e-04,   8.936201094545708e-06,  -1.098757603751479e-07,
   1.200888568736226e-09,  -1.230484743498765e-11,   1.210378495269899e-13,  -1.157523744434105e-15,   1.084358348910568e-17,  -9.998183568886598e-20,   9.098933082265218e-22,
  -2.067095420440438e-04,   3.388679399892562e-06,  -4.166593079426778e-08,   4.553904954718958e-10,  -4.666163505832801e-12,   4.589948338376460e-14,  -4.389547928018608e-16,
   4.112125899052106e-18,  -3.791566916380219e-20,   3.450581574504241e-22,  -2.356766524175419e-05,   3.863551654815459e-07,  -4.750481174836780e-09,   5.192073314966356e-11,
  -5.320068399522020e-13,   5.233178373094230e-15,  -5.004700363224798e-17,   4.688406936286738e-19,  -4.322930888541070e-21,   3.934164941212034e-23,  -4.028394148768398e-03,
   6.603489536989759e-05,  -8.118694574819221e-07,   8.872412111776758e-09,  -9.089936414673794e-11,   8.940098985906136e-13,  -8.548270246076789e-15,   8.006410102026412e-17,
  -7.380501445310424e-19,   6.714421916777348e-21,  -3.724761157034653e-03,   6.105821734069290e-05,  -7.506930030574845e-07,   8.203983782406011e-09,  -8.405281056675121e-11,
   8.266913885133176e-13,  -7.904791134514635e-15,   7.403931608053351e-17,  -6.825335651474494e-19,   6.209559028657417e-21,  -3.163699014753227e-03,   5.186180981841130e-05,
  -6.376391987590239e-07,   6.968652322902179e-09,  -7.139863060576552e-11,   7.022584375069226e-13,  -6.715249029162892e-15,   6.290055758085285e-17,  -5.798803557788657e-19,
   5.275918753407451e-21,  -2.430600060271282e-03,   3.984494650650746e-05,  -4.899031526512040e-07,   5.354218413199017e-09,  -5.485947396751895e-11,   5.396045507812286e-13,
  -5.160122842554644e-15,   4.833636960052328e-17,  -4.456373400512940e-19,   4.054764386082739e-21,  -1.637063862953111e-03,   2.683682038513051e-05,  -3.299708974897034e-07,
   3.606375778347256e-09,  -3.695199765469588e-11,   3.634755241594032e-13,  -3.475960088870502e-15,   3.256160318558291e-17,  -3.002146824362865e-19,   2.731713396138074e-21,
  -9.039093948717530e-04,   1.481813762616585e-05,  -1.821975716091594e-07,   1.991330753465664e-09,  -2.040407529667260e-11,   2.007066833390754e-13,  -1.919420815141232e-15,
   1.798088298104703e-17,  -1.657860175075491e-19,   1.508558493945428e-21,  -3.427687459429207e-04,   5.619157087815441e-06,  -6.909104777641960e-08,   7.551350908617799e-10,
  -7.737499552180698e-12,   7.611117606224628e-14,  -7.278805029814857e-16,   6.818747158934575e-18,  -6.287029563186596e-20,   5.720894081407513e-22,  -3.908024264306775e-05,
   6.406597114494114e-07,  -7.877316444272895e-09,   8.609570892326462e-11,  -8.821814067872338e-13,   8.677730796653135e-15,  -8.298858736134225e-17,   7.774339168291890e-19,
  -7.168116700694921e-21,   6.522651267657405e-23,  -2.464833430390288e-05,   3.912192245943061e-07,  -4.657183536734240e-09,   4.927987621541763e-11,  -4.888549399885993e-13,
   4.655362950260188e-15,  -4.310064751676915e-17,   3.908842297729972e-19,  -3.489405811929449e-21,   3.075795627584150e-23,  -2.279049662678366e-05,   3.617348030622875e-07,
  -4.306244180892805e-09,   4.556710076172022e-11,  -4.520324218185712e-13,   4.304792377635743e-15,  -3.985592042825976e-17,   3.614671811085923e-19,  -3.226897214961766e-21,
   2.844494809627496e-23,  -1.935753672435360e-05,   3.072507770465500e-07,  -3.657715062639634e-09,   3.870555240363878e-11,  -3.839761450767547e-13,   3.656804863286385e-15,
  -3.385785694361116e-17,   3.070822115351185e-19,  -2.741524571369186e-21,   2.416769134817266e-23,  -1.487195231272153e-05,   2.360574247174958e-07,  -2.810241156192084e-09,
   2.973844763559683e-11,  -2.950277281771287e-13,   2.809805151887436e-15,  -2.601668575065761e-17,   2.359758173048157e-19,  -2.106820321084360e-21,   1.857355054552599e-23,
  -1.001658649039433e-05,   1.589918138812567e-07,  -1.892813421546339e-09,   2.003048240142206e-11,  -1.987223097084204e-13,   1.892659338040404e-15,  -1.752517859619579e-17,
   1.589622428640009e-19,  -1.419291821659318e-21,   1.251291058182415e-23,  -5.530683653108019e-06,   8.778835629484178e-08,  -1.045139034002688e-09,   1.106019553148666e-11,
  -1.097296980628757e-13,   1.045098437255716e-15,  -9.677326935854194e-18,   8.778012138015423e-20,  -7.837618507654862e-22,   6.910060423594110e-24,  -2.097273436530218e-06,
   3.329003965490072e-08,  -3.963264028781742e-10,   4.194147217880703e-12,  -4.161092437095029e-14,   3.963173425038935e-16,  -3.669816733894539e-18,   3.328806937156731e-20,
  -2.972216158175184e-22,   2.620488613727088e-24,  -2.391173446900824e-07,   3.795513385672181e-09,  -4.518658038482903e-11,   4.781899679372177e-13,  -4.744216912244350e-15,
   4.518566709442441e-17,  -4.184104369850388e-19,   3.795310527961002e-21,  -3.388751591939434e-23,   2.987736622952498e-25,  -2.242262085743688e-04,   3.558926228872407e-06,
  -4.236645747332942e-08,   4.482996565308131e-10,  -4.447119564099152e-12,   4.234989547081822e-14,  -3.920871278329051e-16,   3.555878356762795e-18,  -3.174314733459560e-20,
   2.798045523947683e-22,  -2.073254357533392e-04,   3.290706073683849e-06,  -3.917395771941136e-08,   4.145244913214868e-10,  -4.112144651174127e-12,   3.916075054995694e-14,
  -3.625698050278791e-16,   3.288271123512183e-18,  -2.935510484822687e-20,   2.587631569993879e-22,  -1.760957561482616e-04,   2.795064200657148e-06,  -3.327428013703337e-08,
   3.521048992195494e-10,  -3.493035841987842e-12,   3.326599995917842e-14,  -3