#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <math.h>

#include <lvtk-1/lvtk/plugin.hpp>

#include "vcalin_cv.hpp"

VcaLinCV::VcaLinCV(double rate):
Plugin<VcaLinCV>(p_n_ports)
{
}

void VcaLinCV::run(uint32_t nframes)
{
	for (unsigned int l2 = 0; l2 < nframes; l2++)
	{
		p(p_out)[l2] = (*p(p_gain1) + p(p_gain1Data)[l2] + *p(p_gain2) * p(p_gain2Data)[l2]) * *p(p_outputLevel) * (*p(p_in1) * p(p_in1Data)[l2] + *p(p_in2) * p(p_in2Data)[l2]);
	}
}

static int _ = VcaLinCV::register_class("http://avwlv2.sourceforge.net/plugins/avw/vcalin_cv");

