/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jiapi.file.attribute;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import net.sf.jiapi.file.ConstantPool;
import net.sf.jiapi.file.attribute.Attribute;

public class StackMapTableAttribute
extends Attribute {
    public static final String ATTRIBUTE_NAME = "StackMapTable";
    private List<StackMapFrame> entries = new LinkedList<StackMapFrame>();
    private ConstantPool constantPool;

    StackMapTableAttribute(ConstantPool constantPool, short nameIndex, int attributeLength, DataInputStream dis) throws IOException {
        super(nameIndex, attributeLength, dis);
        this.constantPool = constantPool;
        dis = this.getDataInputStream();
        int number_of_entries = dis.readShort();
        StackMapFrame prevFrame = null;
        for (int i = 0; i < number_of_entries; ++i) {
            StackMapFrame entry = this.readFrame(dis);
            this.entries.add(entry);
            entry.setPreviousFrame(prevFrame);
            prevFrame = entry;
        }
    }

    public List<StackMapFrame> getEntries() {
        return this.entries;
    }

    private StackMapFrame readFrame(DataInputStream dis) throws IOException {
        StackMapFrame frame = null;
        byte tag = dis.readByte();
        int __tag = tag & 0xFF;
        if (__tag < 64) {
            frame = new SameFrame(tag);
        } else if (__tag < 128) {
            frame = new SameLocals1StackItemFrame(tag, dis);
        } else {
            if (__tag < 246) {
                throw new RuntimeException("Don't know how to handle reserved stack frame type: " + tag);
            }
            if (__tag == 247) {
                frame = new SameLocals1StackItemFrameExtended(tag, dis);
            } else if (__tag < 251) {
                frame = new ChopFrame(tag, dis);
            } else if (__tag == 251) {
                frame = new SameFrameExtended(tag, dis);
            } else if (__tag < 255) {
                frame = new AppendFrame(tag, dis);
            } else if (__tag == 255) {
                frame = new FullFrame(tag, dis);
            } else {
                throw new RuntimeException("Illegal StackMapFrame tag: " + tag);
            }
        }
        return frame;
    }

    @Override
    public byte[] getBytes() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        try {
            dos.writeShort(this.entries.size());
            for (StackMapFrame frame : this.entries) {
                frame.writeTo(dos);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return baos.toByteArray();
    }

    public class VerificationTypeInfo {
        public static final byte ITEM_TOP = 0;
        public static final byte ITEM_INTEGER = 1;
        public static final byte ITEM_FLOAT = 2;
        public static final byte ITEM_DOUBLE = 3;
        public static final byte ITEM_LONG = 4;
        public static final byte ITEM_NULL = 5;
        public static final byte ITEM_UNINITIALIZEDTHIS = 6;
        public static final byte ITEM_OBJECT = 7;
        public static final byte ITEM_UNINITIALIZED = 8;
        private byte verification_type;
        private short cpool_index = (short)-1;
        private short offset = (short)-1;

        VerificationTypeInfo(DataInputStream dis) throws IOException {
            this.verification_type = dis.readByte();
            if (this.verification_type == 7) {
                this.cpool_index = dis.readShort();
            } else if (this.verification_type == 8) {
                this.offset = dis.readShort();
            }
        }

        void writeTo(DataOutputStream dos) throws IOException {
            dos.writeByte(this.verification_type);
            if (this.verification_type == 7) {
                dos.writeShort(this.cpool_index);
            } else if (this.verification_type == 8) {
                dos.writeShort(this.offset);
            }
        }

        public byte getVerificationType() {
            return this.verification_type;
        }

        public short getConstantPoolIndex() {
            return this.cpool_index;
        }

        public short getOffset() {
            return this.offset;
        }

        public String toString() {
            switch (this.verification_type) {
                case 3: {
                    return "ITEM_Double";
                }
                case 2: {
                    return "ITEM_Float";
                }
                case 1: {
                    return "ITEM_Integer";
                }
                case 4: {
                    return "ITEM_Long";
                }
                case 5: {
                    return "ITEM_Null";
                }
                case 7: {
                    return "ITEM_Object(" + this.cpInfo() + ")";
                }
                case 0: {
                    return "ITEM_Top";
                }
                case 8: {
                    return "ITEM_Uninitialized(" + this.offset + ")";
                }
                case 6: {
                    return "ITEM_UninitializedThis";
                }
            }
            return "UNKNOWN verification type: " + this.verification_type;
        }

        private String cpInfo() {
            StringBuffer sb = new StringBuffer();
            sb.append(this.getConstantPoolIndex() + ": ");
            ConstantPool.Entry entry = StackMapTableAttribute.this.constantPool.get(this.getConstantPoolIndex());
            if (entry instanceof ConstantPool.ClassInfo) {
                ConstantPool.ClassInfo cInfo = (ConstantPool.ClassInfo)entry;
                sb.append("class_info:" + cInfo.getName());
            } else {
                sb.append(entry);
            }
            return sb.toString();
        }
    }

    public class FullFrame
    extends StackMapFrame {
        FullFrame(byte tag, DataInputStream dis) throws IOException {
            super(tag);
            this.offset_delta = dis.readShort();
            int number_of_locals = dis.readShort();
            this.locals = new VerificationTypeInfo[number_of_locals];
            for (int i = 0; i < number_of_locals; ++i) {
                this.locals[i] = new VerificationTypeInfo(dis);
            }
            int number_of_stack_items = dis.readShort();
            this.stack = new VerificationTypeInfo[number_of_stack_items];
            for (int i = 0; i < number_of_stack_items; ++i) {
                this.stack[i] = new VerificationTypeInfo(dis);
            }
        }

        @Override
        void writeTo(DataOutputStream dos) throws IOException {
            dos.writeByte(this.tag);
            dos.writeShort(this.offset_delta);
            dos.writeShort(this.locals.length);
            for (VerificationTypeInfo vti : this.locals) {
                vti.writeTo(dos);
            }
            dos.writeShort(this.stack.length);
            for (VerificationTypeInfo vti : this.stack) {
                vti.writeTo(dos);
            }
        }

        public String toString() {
            int i;
            StringBuffer sb = new StringBuffer("full_frame, offset_delta ");
            sb.append(this.offset_delta);
            sb.append(", locals: [");
            for (i = 0; i < this.locals.length; ++i) {
                sb.append(this.locals[i]);
                if (i >= this.locals.length - 1) continue;
                sb.append(", ");
            }
            sb.append("], stack: [");
            for (i = 0; i < this.stack.length; ++i) {
                sb.append(this.stack[i]);
                if (i >= this.stack.length - 1) continue;
                sb.append(", ");
            }
            sb.append("]");
            return sb.toString();
        }
    }

    public class AppendFrame
    extends StackMapFrame {
        AppendFrame(byte tag, DataInputStream dis) throws IOException {
            super(tag);
            this.offset_delta = dis.readShort();
            int __tag = tag & 0xFF;
            this.locals = new VerificationTypeInfo[__tag - 251];
            for (int i = 0; i < this.locals.length; ++i) {
                this.locals[i] = new VerificationTypeInfo(dis);
            }
            this.stack = new VerificationTypeInfo[0];
        }

        public int getAdditionalLocalsCount() {
            return 251 - this.tag;
        }

        @Override
        void writeTo(DataOutputStream dos) throws IOException {
            dos.writeByte(this.tag);
            dos.writeShort(this.offset_delta);
            for (VerificationTypeInfo vti : this.locals) {
                vti.writeTo(dos);
            }
        }

        public String toString() {
            return "append_frame, offset_delta: " + this.offset_delta + ", additional " + this.getAdditionalLocalsCount();
        }
    }

    public class SameFrameExtended
    extends StackMapFrame {
        SameFrameExtended(byte tag, DataInputStream dis) throws IOException {
            super(tag);
            this.offset_delta = dis.readShort();
            this.locals = new VerificationTypeInfo[0];
            this.stack = new VerificationTypeInfo[0];
        }

        @Override
        void writeTo(DataOutputStream dos) throws IOException {
            dos.writeByte(this.tag);
            dos.writeShort(this.offset_delta);
        }

        public String toString() {
            return "same_frame_extended, offset_delta: " + this.offset_delta;
        }
    }

    public class ChopFrame
    extends StackMapFrame {
        ChopFrame(byte tag, DataInputStream dis) throws IOException {
            super(tag);
            this.offset_delta = dis.readShort();
            this.locals = new VerificationTypeInfo[0];
            this.stack = new VerificationTypeInfo[0];
        }

        @Override
        void writeTo(DataOutputStream dos) throws IOException {
            dos.writeByte(this.tag);
            dos.writeShort(this.offset_delta);
        }

        public int getAbsentLocalsCount() {
            return 251 - this.tag;
        }

        public String toString() {
            return "chop_frame, offset_delta: " + this.offset_delta + ", absent " + this.getAbsentLocalsCount();
        }
    }

    public class SameLocals1StackItemFrameExtended
    extends StackMapFrame {
        SameLocals1StackItemFrameExtended(byte tag, DataInputStream dis) throws IOException {
            super(tag);
            this.offset_delta = dis.readShort();
            this.locals = new VerificationTypeInfo[0];
            this.stack = new VerificationTypeInfo[1];
            this.stack[0] = new VerificationTypeInfo(dis);
        }

        @Override
        void writeTo(DataOutputStream dos) throws IOException {
            dos.writeByte(this.tag);
            dos.writeShort(this.offset_delta);
            this.stack[0].writeTo(dos);
        }

        public String toString() {
            return "same_locals_1_stack_item_frame_extended, offset_delta: " + this.offset_delta + ", " + this.stack[0];
        }
    }

    public class SameLocals1StackItemFrame
    extends StackMapFrame {
        SameLocals1StackItemFrame(byte tag, DataInputStream dis) throws IOException {
            super(tag);
            int __tag = tag & 0xFF;
            this.offset_delta = (short)(__tag - 64);
            this.locals = new VerificationTypeInfo[0];
            this.stack = new VerificationTypeInfo[1];
            this.stack[0] = new VerificationTypeInfo(dis);
        }

        @Override
        void writeTo(DataOutputStream dos) throws IOException {
            dos.writeByte(this.tag);
            this.stack[0].writeTo(dos);
        }

        public String toString() {
            return "same_locals_1_stack_item_frame, offset_delta: " + this.offset_delta + ", " + this.stack[0];
        }
    }

    public class SameFrame
    extends StackMapFrame {
        SameFrame(byte tag) {
            super(tag);
            this.offset_delta = tag;
            this.locals = new VerificationTypeInfo[0];
            this.stack = new VerificationTypeInfo[0];
        }

        @Override
        void writeTo(DataOutputStream dos) throws IOException {
            dos.writeByte(this.tag);
        }

        public String toString() {
            return "same_frame, offset_delta: " + this.offset_delta;
        }
    }

    public abstract class StackMapFrame {
        protected final byte tag;
        protected short offset_delta;
        protected VerificationTypeInfo[] locals;
        protected VerificationTypeInfo[] stack;
        private StackMapFrame prevFrame;

        protected StackMapFrame(byte tag) {
            this.tag = tag;
        }

        void setPreviousFrame(StackMapFrame prevFrame) {
            this.prevFrame = prevFrame;
        }

        abstract void writeTo(DataOutputStream var1) throws IOException;

        public StackMapFrame getPreviousFrame() {
            return this.prevFrame;
        }

        public short getOffsetDelta() {
            return this.offset_delta;
        }

        public void setOffsetDelta(short offset_delta) {
            this.offset_delta = offset_delta;
        }

        public short getBytecodeOffset() {
            if (this.prevFrame == null) {
                return this.getOffsetDelta();
            }
            return (short)(this.prevFrame.getBytecodeOffset() + this.getOffsetDelta() + 1);
        }

        public VerificationTypeInfo[] getLocals() {
            return this.locals;
        }

        public VerificationTypeInfo[] getStack() {
            return this.stack;
        }
    }

    public static enum FrameType {
        SAME_FRAME,
        SAME_LOCALS_1_STACK_ITEM_FRAME,
        SAME_LOCALS_1_STACK_ITEM_FRAME_EXTENDED,
        CHOP_FRAME,
        SAME_FRAME_EXTENDED,
        APPEND_FRAME,
        FULL_FRAME;

    }
}

