/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jiapi.file;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import net.sf.jiapi.Configuration;
import net.sf.jiapi.JiapiRuntimeException;
import net.sf.jiapi.file.ConstantPool;
import net.sf.jiapi.file.Field;
import net.sf.jiapi.file.Interface;
import net.sf.jiapi.file.Method;
import net.sf.jiapi.file.ParseException;
import net.sf.jiapi.file.ProgramElement;

public class ClassFile
extends ProgramElement {
    private static transient Configuration config = new Configuration();
    private LinkedList<Interface> interfaces = new LinkedList();
    private LinkedList<Field> fields = new LinkedList();
    private LinkedList<Method> methods = new LinkedList();
    public static final int ACC_PUBLIC = 1;
    public static final int ACC_FINAL = 16;
    public static final int ACC_SUPER = 32;
    public static final int ACC_INTERFACE = 512;
    public static final int ACC_ABSTRACT = 1024;
    public static final int ACC_SYNTHETIC = 4096;
    public static final int ACC_ANNOTATION = 8192;
    public static final int ACC_ENUM = 16384;
    private int magic_number;
    private short minor_version;
    private short major_version;
    private short this_class;
    private short super_class;

    public static void main(String[] args) throws Exception {
        ClassFile cf = ClassFile.parse(args[0]);
        System.out.println("Magic: " + cf.getMagicNumber());
        String version = null;
        switch (cf.getMajorVersion()) {
            case 45: {
                version = "JDK 1.1";
                break;
            }
            case 46: {
                version = "JDK 1.2";
                break;
            }
            case 47: {
                version = "JDK 1.3";
                break;
            }
            case 48: {
                version = "JDK 1.4";
                break;
            }
            case 49: {
                version = "J2SE 5.0";
                break;
            }
            case 50: {
                version = "J2SE 6.0";
                break;
            }
            case 51: {
                version = "J2SE 7";
                break;
            }
            default: {
                version = "Unknown version";
            }
        }
        System.out.println(version + ", " + cf.getMajorVersion() + " " + cf.getMinorVersion());
        System.out.println("Access flags: " + cf.getAccessFlags());
        System.out.println(cf.getConstantPool());
    }

    public ClassFile(String className) {
        super(new ConstantPool());
        String name = className.replace('.', '/');
        this.magic_number = -889275714;
        this.minor_version = 0;
        this.major_version = (short)50;
        this.access_flags = 1;
        this.this_class = this.constantPool.addClassInfo(name).getEntryIndex();
        this.super_class = this.constantPool.addClassInfo("java.lang.Object").getEntryIndex();
        this.interfaces = new LinkedList();
        this.methods = new LinkedList();
        this.fields = new LinkedList();
        this.attributes = new LinkedList();
    }

    private ClassFile() {
        super(null);
    }

    public static ClassFile parse(String fileName) throws ParseException, IOException {
        return ClassFile.parse(new FileInputStream(fileName));
    }

    public static ClassFile parse(InputStream is) throws ParseException, IOException {
        InputStream input = null;
        if (config.getBoolean("net.sf.jiapi.file.use-ZipFileInputStream-bug-workaround", true)) {
            ByteArrayOutputStream bos = new ByteArrayOutputStream(is.available());
            int i = 0;
            while ((i = is.read()) != -1) {
                bos.write(i);
            }
            input = new ByteArrayInputStream(bos.toByteArray());
        } else {
            input = is;
        }
        ClassFile cf = null;
        try (DataInputStream dis = new DataInputStream(input);){
            cf = new ClassFile();
            cf.parseClassFile(dis);
            if (dis.available() != 0) {
                System.out.println(is.available() + ":::" + dis.available() + ":" + is);
                System.out.println("" + dis.readByte());
            }
        }
        return cf;
    }

    @Override
    public ConstantPool getConstantPool() {
        return this.constantPool;
    }

    public int getMagicNumber() {
        return this.magic_number;
    }

    public short getMinorVersion() {
        return this.minor_version;
    }

    public short getMajorVersion() {
        return this.major_version;
    }

    public List<Field> getFields() {
        return this.fields;
    }

    public List<Interface> getInterfaces() {
        return this.interfaces;
    }

    public List<Method> getMethods() {
        return this.methods;
    }

    public String getClassName() {
        return this.constantPool.getClassName(this.this_class);
    }

    public String getSuperclassName() {
        if (this.super_class != 0) {
            return this.constantPool.getClassName(this.super_class);
        }
        return null;
    }

    public void setAccessFlags(short access_flags) {
        this.access_flags = access_flags;
    }

    public short getSuperClassIndex() {
        return this.super_class;
    }

    public short getThisClassIndex() {
        return this.this_class;
    }

    public byte[] toBytes() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        try {
            dos.writeInt(this.magic_number);
            dos.writeShort(this.minor_version);
            dos.writeShort(this.major_version);
            this.writeConstantPool(dos);
            dos.writeShort(this.access_flags);
            dos.writeShort(this.this_class);
            dos.writeShort(this.super_class);
            this.writeInterfaces(dos);
            this.writeFields(dos);
            this.writeMethods(dos);
            this.writeAttributes(dos);
        }
        catch (IOException ioe) {
            throw new ParseException(ioe.getMessage(), this);
        }
        return baos.toByteArray();
    }

    private void parseClassFile(DataInputStream dis) throws ParseException, IOException {
        this.magic_number = dis.readInt();
        this.minor_version = dis.readShort();
        this.major_version = dis.readShort();
        this.parseConstantPool(dis);
        this.access_flags = dis.readShort();
        this.this_class = dis.readShort();
        this.super_class = dis.readShort();
        this.readInterfaces(dis);
        this.readFields(dis);
        this.readMethods(dis);
        this.readAttributes(dis);
    }

    void addInterface(short constantClassIndex) {
        this.interfaces.add(new Interface(this.constantPool, constantClassIndex));
    }

    private void readInterfaces(DataInputStream dis) throws IOException {
        int iCount = dis.readShort();
        for (int i = 0; i < iCount; ++i) {
            short constantClassIndex = dis.readShort();
            this.addInterface(constantClassIndex);
        }
    }

    private void readFields(DataInputStream dis) throws IOException {
        int fCount = dis.readShort();
        for (int i = 0; i < fCount; ++i) {
            this.fields.add(new Field(this.constantPool, dis));
        }
    }

    private void readMethods(DataInputStream dis) throws IOException {
        int mCount = dis.readShort();
        for (int i = 0; i < mCount; ++i) {
            this.methods.add(new Method(this.constantPool, dis));
        }
    }

    private void parseConstantPool(DataInputStream dis) throws IOException {
        short constantPoolCount = dis.readShort();
        this.constantPool = new ConstantPool(constantPoolCount - 1);
        block16: for (int i = 0; i < constantPoolCount - 1; ++i) {
            byte tag = dis.readByte();
            switch (tag) {
                case 7: {
                    this.constantPool.addClassInfo(dis.readShort());
                    continue block16;
                }
                case 9: {
                    this.constantPool.addFieldRefInfo(dis.readShort(), dis.readShort());
                    continue block16;
                }
                case 10: {
                    this.constantPool.addMethodRefInfo(dis.readShort(), dis.readShort());
                    continue block16;
                }
                case 11: {
                    this.constantPool.addInterfaceMethodRefInfo(dis.readShort(), dis.readShort());
                    continue block16;
                }
                case 8: {
                    this.constantPool.addString_info(dis.readShort());
                    continue block16;
                }
                case 3: {
                    this.constantPool.addInteger_info(dis.readInt());
                    continue block16;
                }
                case 4: {
                    this.constantPool.addFloat_info(dis.readInt());
                    continue block16;
                }
                case 5: {
                    this.constantPool.addLong_info(dis.readInt(), dis.readInt());
                    ++i;
                    continue block16;
                }
                case 6: {
                    this.constantPool.addDouble_info(dis.readInt(), dis.readInt());
                    ++i;
                    continue block16;
                }
                case 12: {
                    this.constantPool.addNameAndTypeInfo(dis.readShort(), dis.readShort());
                    continue block16;
                }
                case 1: {
                    short length = dis.readShort();
                    byte[] byteArray = new byte[length];
                    for (int j = 0; j < byteArray.length; ++j) {
                        byteArray[j] = dis.readByte();
                    }
                    this.constantPool.addUtf8_info(byteArray);
                    continue block16;
                }
                case 15: {
                    this.constantPool.addMethodHandle_info(dis.readByte(), dis.readShort());
                    continue block16;
                }
                case 16: {
                    this.constantPool.addMethodType_info(dis.readShort());
                    continue block16;
                }
                case 18: {
                    this.constantPool.addInvokeDynamic_info(dis.readShort(), dis.readShort());
                    continue block16;
                }
                default: {
                    throw new ParseException(this.constantPool + "\nInvalid constant pool tag: " + tag, this);
                }
            }
        }
    }

    private void writeConstantPool(DataOutputStream dos) throws IOException {
        List<ConstantPool.Entry> cp = this.constantPool.getList();
        dos.writeShort(cp.size() + 1);
        for (ConstantPool.Entry e : cp) {
            if (e instanceof ConstantPool.NullEntry) continue;
            if (e.getTag() == 0) {
                throw new JiapiRuntimeException("ERROR: invalid constant pool tag: 0");
            }
            dos.writeByte(e.getTag());
            e.writeData(dos);
        }
    }

    private void writeInterfaces(DataOutputStream dos) throws IOException {
        dos.writeShort(this.interfaces.size());
        for (Interface iFace : this.interfaces) {
            dos.writeShort(iFace.getConstantClassIndex());
        }
    }

    private void writeFields(DataOutputStream dos) throws IOException {
        dos.writeShort(this.fields.size());
        for (Field f : this.fields) {
            dos.writeShort(f.getAccessFlags());
            dos.writeShort(f.getNameIndex());
            dos.writeShort(f.getDescriptorIndex());
            f.writeAttributes(dos);
        }
    }

    private void writeMethods(DataOutputStream dos) throws IOException {
        dos.writeShort(this.methods.size());
        for (Method m : this.methods) {
            dos.writeShort(m.getAccessFlags());
            dos.writeShort(m.getNameIndex());
            dos.writeShort(m.getDescriptorIndex());
            m.writeAttributes(dos);
        }
    }
}

