%{
(* Syntax *)
(* $Id: syntax.mly,v 1.7 2004/10/24 20:27:24 berke Exp $ *)
(* Prolog *)

open Ast
%}
%token EOF
%token EQ
%token NEQ
%token LEQ
%token GEQ
%token LT
%token GT
%token MATCHES
%token DOESNT_MATCH
%token LPAREN
%token RPAREN
%token LBRACK
%token RBRACK
%token COLON
%token COMMA
%token AND
%token TRUE
%token FALSE
%token NOT
%token OR
%token ASSIGN
%token STAR
%token PLUS
%token COMMA
%token IDENTITY
%token REVERSE
%token DOT
%token TILDE
%token <string> IDENT
%token <string> STRING
%token <string * Ast.regexp_option list> REGEXP
%type <Ast.statement> statement
%start statement

%left OR
%left AND
%nonassoc ASSIGN
%nonassoc NOT
%nonassoc EQ
%nonassoc NEQ
%nonassoc MATCHES
%nonassoc DOESNT_MATCH
%left LT
%left LEQ
%left GT
%left GEQ
%nonassoc COLON

%%
statement :
| IDENT ASSIGN set_query EOF
  { let s1 = Parsing.rhs_start 3
    and s2 = Parsing.rhs_end 3
    in
    Assign($1,s1,s2,$3) }
| set_query EOF { Display($1) }

relation :
| IDENTITY { Identity }
| relation AND relation { Intersection($1,$3) }
| relation OR relation { Union($1,$3) }
| NOT relation { Complement($2) }
| relation STAR { Star($1) }
| relation PLUS { Plus($1) }
| relation REVERSE { Reverse($1) }
| relation DOT relation { Compose($1,$3) }
| LPAREN relation RPAREN { $2 }
| field { Relation(Field_link($1)) }

set_query :
| LPAREN set_query RPAREN { $2 }
| LBRACK relation RBRACK set_query { Meta(Apply_relation(Reverse($2)), $4) }
| set_query LBRACK relation RBRACK { Meta(Apply_relation($3), $1) }
| set_query AND set_query { And($1,$3) }
| set_query set_query { And($1,$2) }
| set_query OR set_query { Or($1,$3) }
| NOT set_query { Not($2) }
| TRUE { True }
| FALSE { False }
| REGEXP { let (x,y) = $1 in Atom(Matches(Current_field, Regular(x,y))) }
| field MATCHES REGEXP { let (x,y) = $3 in Atom(Matches($1,Regular(x,y))) }
| field DOESNT_MATCH REGEXP { let (x,y) = $3 in Not(Atom(Matches($1,Regular(x,y)))) }
| field EQ STRING { Atom(Matches($1,Exact($3))) }
| field NEQ STRING { Not(Atom(Matches($1,Exact($3)))) }
| field LEQ STRING { Atom(Matches($1,Lexicographic_le($3))) }
| field GEQ STRING { Atom(Matches($1,Lexicographic_ge($3))) }
| field LT STRING {
  And(Not(Atom(Matches($1,Exact($3)))),Atom(Matches($1,Lexicographic_le($3)))) }
| field GT STRING {
  And(Not(Atom(Matches($1,Exact($3)))),Atom(Matches($1,Lexicographic_ge($3)))) }
| STRING { Atom(Matches(Current_field, Regular(Util.reg_of_string $1,[Case_insensitive]))) }
| IDENT { Atom(Reference($1)) }
| field_spec COLON set_query { Meta(With_field($1),$3) }

field_spec :
| field { $1 }
| field COMMA field_spec { Either_field($1, $3) }

field :
| TILDE { Current_field }
| STAR { Some_field(Regular("",[])) }
| STRING { 
  let w = $1 in
  try
    let m = String.length w in
    let b = Buffer.create m in
    Buffer.add_char b '^';
    for i = 0 to m - 1 do
      match w.[i] with
      | ('.'|'+'|'?'|'['|']'|'^'|'$'|'\\') as c -> Buffer.add_char b '\\'; Buffer.add_char b c
      | '*' -> Buffer.add_string b ".*"
      | c -> Buffer.add_char b (Char.lowercase c)
    done;
    Buffer.add_char b '$';
    Some_field(Regular(Buffer.contents b,[Case_insensitive]))
  with
  | Not_found -> This_field($1) }
