# D.5 What causes imperialism?

In a word: power. Imperialism is the process by which one country dominates
another directly, by political means, or indirectly, by economic means, in
order to steal its wealth (either natural or produced). This, by necessity,
means the exploitation of working people in the dominated nation. Moreover, it
can also aid the exploitation of working people in the imperialist nation
itself. As such, imperialism cannot be considered in isolation from the
dominant economic and social system. Fundamentally the cause is the same
inequality of power, which is used in the service of exploitation.

While the rhetoric used for imperial adventures may be about self-defence,
defending/exporting "democracy" and/or "humanitarian" interests, the reality
is much more basic and grim. As Chomsky stresses, _"deeds consistently accord
with interests, and conflict with words -- discoveries that must not, however,
weaken our faith in the sincerity of the declarations of our leaders."_ This
is unsurprising as states are always _"pursuing the strategic and economic
interests of dominant sectors to the accompaniment of rhetorical flourishes
about its exceptional dedication to the highest values"_ and so _"the evidence
for . . . the proclaimed messianic missions reduces to routine
pronouncements"_ (faithfully repeated by the media) while _"counter-evidence
is mountainous."_ [ **Failed States** , p. 171 and pp. 203-4]

We must stress that we are concentrating on the roots of imperialism here. We
do not, and cannot, provide a detailed history of the horrors associated with
it. For US imperialism, the works of Noam Chomsky are recommended. His books
**Turning the Tide** and **The Culture of Terrorism** expose the evils of US
intervention in Central America, for example, while **Deterring Democracy** ,
**Rogue States: The Rule of Force in World Affairs** and **Failed States: The
Abuse of Power and the Assault on Democracy** present a wider perspective.
**Killing Hope: US Military and CIA Interventions Since World War II** and
**Rogue State: A Guide to the World's Only Superpower** by William Blum are
also worth reading. For post-1945 British imperialism, Mark Curtis's **Web of
Deceit: Britain's Real Role in the World** and **Unpeople: Britain's Secret
Human Rights Abuses** are recommended.

As we will discuss in the following sections, imperialism has changed over
time, particularly during the last two hundred years (where its forms and
methods have evolved with the changing needs of capitalism). But even in the
pre-capitalist days of empire building, imperialism was driven by economic
forces and needs. In order to make one's state secure, in order to increase
the wealth available to the state, its ruling bureaucracy and its associated
ruling class, it had to be based on a strong economy and have a sufficient
resource base for the state and ruling elite to exploit (both in terms of
human and natural resources). By increasing the area controlled by the state,
one increased the wealth available.

States by their nature, like capital, are expansionist bodies, with those who
run them always wanting to increase the range of their power and influence
(this can be seen from the massive number of wars that have occurred in Europe
over the last 500 years). This process was began as nation-states were created
by Kings declaring lands to be their private property, regardless of the
wishes of those who actually lived there. Moreover, this conflict did not end
when monarchies were replaced by more democratic forms of government. As
Bakunin argued:

> _"we find wars of extermination, wars among races and nations; wars of
> conquest, wars to maintain equilibrium, political and religious wars, wars
> waged in the name of 'great ideas' . . . , patriotic wars for greater
> national unity . . . And what do we find beneath all that, beneath all the
> hypocritical phrases used in order to give these wars the appearance of
> humanity and right? Always the same economic phenomenon: **the tendency on
> the part of some to live and prosper at the expense of others.** All the
> rest is mere humbug. The ignorant and naive, and the fools are entrapped by
> it, but the strong men who direct the destinies of the State know only too
> well that underlying all those wars there is only one motive: pillage, the
> seizing of someone else's wealth and the enslavement of someone else's
> labour."_ [ **The Political Philosophy of Bakunin** , p. 170]

However, while the economic motive for expansion is generally the same, the
economic system which a nation is based on has a definite impact on what
drives that motive as well as the specific nature of that imperialism. Thus
the empire building of ancient Rome or Feudal England has a different economic
base (and so driving need) than, say, the imperialism of nineteenth century
Germany and Britain or twentieth and twenty-first century United States. Here
we will focus mainly on modern capitalist imperialism as it is the most
relevant one in the modern world.

Capitalism, by its very nature, is growth-based and so is characterised by the
accumulation and concentration of capital. Companies **must** expand in order
to survive competition in the marketplace. This, inevitably, sees a rise in
international activity and organisation as a result of competition over
markets and resources within a given country. By expanding into new markets in
new countries, a company can gain an advantage over its competitors as well as
overcome limited markets and resources in the home nation. In Bakunin's words:

> _"just as capitalist production and banking speculation, which in the long
> run swallows up that production, must, under the threat of bankruptcy,
> ceaselessly expand at the expense of the small financial and productive
> enterprises which they absorb, must become universal, monopolistic
> enterprises extending all over the world -- so this modern and necessarily
> military State is driven on by an irrepressible urge to become a universal
> State. . . . Hegemony is only a modest manifestation possible under the
> circumstances, of this unrealisable urge inherent in every State. And the
> first condition of this hegemony is the relative impotence and subjection of
> all the neighbouring States."_ [ **Op. Cit.** , p. 210]

Therefore, economically and politically, the imperialistic activities of
**both** capitalist and state-capitalist (i.e. the Soviet Union and other
"socialist" nations) comes as no surprise. Capitalism is inevitably
imperialistic and so _"[w]ar, capitalism and imperialism form a veritable
trinity,"_ to quote Dutch pacifist-syndicalist Bart de Ligt [ **The Conquest
of Violence** , p. 64] The growth of big business is such that it can no
longer function purely within the national market and so they have to expand
internationally to gain advantage in and survive. This, in turn, requires the
home state of the corporations also to have global reach in order to defend
them and to promote their interests. Hence the economic basis for modern
imperialism, with _"the capitalistic interests of the various countries
fight[ing] for the foreign markets and compete with each other there"_ and
when they _"get into trouble about concessions and sources of profit,"_ they
_"call upon their respective governments to defend their interests . . . to
protect the privileges and dividends of some . . . capitalist in a foreign
country."_ [Alexander Berkman, **What is Anarchism?** , p. 31] Thus a
capitalist class needs the power of nation states not only to create internal
markets and infrastructure but also to secure and protect international
markets and opportunities in a world of rivals and **their** states.

As power depends on profits within capitalism, this means that modern
imperialism is caused more by economic factors than purely political
considerations (although, obviously, this factor does play a role).
Imperialism serves capital by increasing the pool of profits available for the
imperialistic country in the world market as well as reducing the number of
potential competitors. As Kropotkin stressed, _"capital knows no fatherland;
and if high profits can be derived from the work of Indian coolies whose wages
are only one-half of those of English workmen [or women], or even less,
capital will migrate to India, as it has gone to Russian, although its
migration may mean starvation for Lancashire."_ [ **Fields, Factories and
Workshops** , p. 57]

Therefore, capital will travel to where it can maximise its profits --
regardless of the human or environmental costs at home or abroad. This is the
economic base for modern imperialism, to ensure that any trade conducted
benefits the stronger party more than the weaker one. Whether this trade is
between nations or between classes is irrelevant, the aim of imperialism is to
give business an advantage on the market. By travelling to where labour is
cheap and the labour movement weak (usually thanks to dictatorial regimes),
environmental laws few or non-existent, and little stands in the way of
corporate power, capital can maximise its profits. Moreover, the export of
capital allows a reduction in the competitive pressures faced by companies in
the home markets (at least for short periods).

This has two effects. Firstly, the industrially developed nation (or, more
correctly corporation based in that nation) can exploit less developed
nations. In this way, the dominant power can maximise for itself the benefits
created by international trade. If, as some claim, trade always benefits each
party, then imperialism allows the benefits of international trade to accrue
more to one side than the other. Secondly, it gives big business more weapons
to use to weaken the position of labour in the imperialist nation. This,
again, allows the benefits of trade (this time the trade of workers liberty
for wages) to accrue to more to business rather than to labour.

How this is done and in what manner varies and changes, but the aim is always
the same -- exploitation.

This can be achieved in many ways. For example, allowing the import of cheaper
raw materials and goods; the export of goods to markets sheltered from foreign
competitors; the export of capital from capital-rich areas to capital-poor
areas as the investing of capital in less industrially developed countries
allows the capitalists in question to benefit from lower wages; relocating
factories to countries with fewer (or no) social and environmental laws,
controls or regulations. All these allow profits to be gathered at the expense
of the working people of the oppressed nation (the rulers of these nations
generally do well out of imperialism, as would be expected). The initial
source of exported capital is, of course, the exploitation of labour at home
but it is exported to less developed countries where capital is scarcer and
the price of land, labour and raw materials cheaper. These factors all
contribute to enlarging profit margins:

> _"The relationship of these global corporations with the poorer countries
> had long been an exploiting one . . . Whereas U.S. corporations in Europe
> between 1950 and 1965 invested $8.1 billion and made $5.5 billion in
> profits, in Latin America they invested $3.8 billion and made $11.2 billion
> in profits, and in Africa they invested $5.2 billion and made $14.3 bullion
> in profits."_ [Howard Zinn, **A People's History of the United States** , p.
> 556]

Betsy Hartman, looking at the 1980s, concurs. _"Despite the popular Western
image of the Third World as a bottomless begging bowl,"_ she observes, _"it
today gives more to the industrialised world than it takes. Inflows of
official 'aid' and private loans and investments are exceeded by outflows in
the form of repatriated profits, interest payments, and private capital sent
abroad by Third World Elites."_ [quoted by George Bradford, **Woman's Freedom:
Key to the Population Question** , p. 77]

In addition, imperialism allows big business to increase its strength with
respect to its workforce in the imperialist nation by the threat of switching
production to other countries or by using foreign investments to ride out
strikes. This is required because, while the "home" working class are still
exploited and oppressed, their continual attempts at organising and resisting
their exploiters proved more and more successful. As such, _"the opposition of
the white working classes to the . . . capitalist class continually gain[ed]
strength, and the workers . . . [won] increased wages, shorter hours,
insurances, pensions, etc., the white exploiters found it profitable to obtain
their labour from men [,women and children] of so-called inferior race . . .
Capitalists can therefore make infinitely more out there than at home."_ [Bart
de Ligt, **Op. Cit.** , p. 49]

As such, imperialism (like capitalism) is not only driven by the need to
increase profits (important as this is, of course), it is also driven by the
class struggle -- the need for capital to escape from the strength of the
working class in a particular country. From this perspective, the export of
capital can be seen in two ways. Firstly, as a means of disciplining
rebellious workers at home by an "investment strike" (capital, in effect, runs
away, so causing unemployment which disciplines the rebels). Secondly, as a
way to increase the 'reserve army' of the unemployed facing working people in
the imperialist nations by creating new competitors for their jobs (i.e.
dividing, and so ruling, workers by playing one set of workers against
another). Both are related, of course, and both seek to weaken working class
power by the fear of unemployment. This process played a key role in the rise
of globalisation -- see [section D.5.3](secD5.md#secd53) for details.

Thus imperialism, which is rooted in the search from surplus profits for big
business, is also a response to working class power at home. The export of
capital is done by emerging and established transnational companies to
overcome a militant and class consciousness working class which is often too
advanced for heavy exploitation, and finance capital can make easier and
bigger profits by investing productive capital elsewhere. It aids the
bargaining position of business by pitting the workers in one country against
another, so while they are being exploited by the same set of bosses, those
bosses can use this fictional "competition" of foreign workers to squeeze
concessions from workers at home.

Imperialism has another function, namely to hinder or control the
industrialisation of other countries. Such industrialisation will, of course,
mean the emergence of new capitalists, who will compete with the existing ones
both in the "less developed" countries and in the world market as a whole.
Imperialism, therefore, attempts to reduce competition on the world market. As
we discuss in the [next section](secD5.md#secd51), the nineteenth century
saw the industrialisation of many European nations as well as America, Japan
and Russia by means of state intervention. However, this state-led
industrialisation had a drawback, namely that it created more and more
competitors on the world market. Moreover, as Kropotkin noted, they has the
advantage that the _"new manufacturers . . . begin where"_ the old have
_"arrived after a century of experiments and groupings"_ and so they _"are
built according to the newest and best models which have been worked out
elsewhere."_ [ **Op. Cit.** , p. 32 and p. 49] Hence the need to stop new
competitors and secure raw materials and markets, which was achieved by
colonialism:

> _"Industries of all kinds decentralise and are scattered all over the globe;
> and everywhere a variety, an integrated variety, of trades grows, instead of
> specialisation . . . each nation becomes in its turn a manufacturing nation
> . . . For each new-comer the first steps only are difficult . . . The fact
> is so well felt, if not understood, that the race for colonies has become
> the distinctive feature of the last twenty years [Kropotkin is writing in
> 1912]. Each nation will have her own colonies. But colonies will not help."_
> [ **Op. Cit.** , p. 75]

Imperialism hinders industrialisation in two ways. The first way was direct
colonisation, a system which has effectively ended. The second is by indirect
means -- namely the extraction of profits by international big business. A
directly dominated country can be stopped from developing industry and be
forced to specialise as a provider of raw materials. This was the aim of
"classic" imperialism, with its empires and colonial wars. By means of
colonisation, the imperialist powers ensure that the less-developed nation
stays that way -- so ensuring one less competitor as well as favourable access
to raw materials and cheap labour. French anarchist Elisee Reclus rightly
called this a process of creating _"colonies of exploitation."_ [quoted by
John P Clark and Camille Martin (eds.), **Anarchy, Geography, Modernity** , p.
92]

This approach has been superseded by indirect means (see [next
section](secD5.md#secd51)). Globalisation can be seen as an intensification
of this process. By codifying into international agreements the ability of
corporations to sue nation states for violating "free trade," the possibility
of new competitor nations developing is weakened. Industrialisation will be
dependent on transnational corporations and so development will be hindered
and directed to ensure corporate profits and power. Unsurprisingly, those
nations which **have** industrialised over the last few decades (such as the
East Asian Tiger economies) have done so by using the state to protect
industry and control international finance.

The new attack of the capitalist class ("globalisation") is a means of
plundering local capitalists and diminish their power and area of control. The
steady weakening and ultimate collapse of the Eastern Block (in terms of
economic/political performance and ideological appeal) also played a role in
this process. The end of the Cold War meant a reduction in the space available
for local elites to manoeuvre. Before this local ruling classes could, if they
were lucky, use the struggle between US and USSR imperialism to give them a
breathing space in which they could exploit to pursue their own agenda (within
limits, of course, and with the blessing of the imperialist power in whose
orbit they were in). The Eastern Tiger economies were an example of this
process at work. The West could use them to provide cheap imports for the home
market as well as in the ideological conflict of the Cold War as an example of
the benefits of the "free market" (not that they were) and the ruling elites,
while maintaining a pro-west and pro-business environment (by force directed
against their own populations, of course), could pursue their own economic
strategies. With the end of the Cold War, this factor is no longer in play and
the newly industrialised nations are now an obvious economic competitor. The
local elites are now "encouraged" (by economic blackmail via the World Bank
and the IMF) to embrace US economic ideology. Just as neo-liberalism attacks
the welfare state in the Imperialist nations, so it results in a lower
tolerance of local capital in "less developed" nations.

However, while imperialism is driven by the needs of capitalism it cannot end
the contradictions inherent in that system. As Reclus put it in the late
nineteenth century, _"the theatre expands, since it now embraces the whole of
the land and seas. But the forces that struggled against one another in each
particularly state are precisely those that fight across the earth. In each
country, capital seeks to subdue the workers. Similarly, on the level of the
broadest world market, capital, which had grown enormously, disregards all the
old borders and seeks to put the entire mass of producers to work on behalf of
its profits, and to secure all the consumers in the world."_ [Reclus, quoted
by Clark and Martin (eds.), **Op. Cit.** , p. 97]

This struggle for markets and resources does, by necessity, lead to conflict.
This may be the wars of conquest required to initially dominate an
economically "backward" nation (such as the US invasion of the Philippines,
the conquest of Africa by West European states, and so on) or maintain that
dominance once it has been achieved (such as the Vietnam War, the Algerian
War, the Gulf War and so on). Or it may be the wars between major imperialist
powers once the competition for markets and colonies reaches a point when they
cannot be settled peacefully (as in the First and Second World Wars). As
Kropotkin argued:

> _"men no longer fight for the pleasure of kings, they fight for the
> integrity of revenues and for the growing wealth . . . [for the] benefit of
> the barons of high finance and industry . . . [P]olitical preponderance . .
> . is quite simply a matter of economic preponderance in international
> markets. What Germany, France, Russia, England, and Austria are all trying
> to win . . . is not military preponderance: it is economic domination. It is
> the right to impose their goods and their customs tariffs on their
> neighbours; the right to exploit industrially backward peoples; the
> privilege of building railroads . . . to appropriate from a neighbour either
> a port which will activate commerce, or a province where surplus merchandise
> can be unloaded . . . When we fight today, it is to guarantee our great
> industrialists a profit of 30%, to assure the financial barons their
> domination at the Bourse [stock-exchange], and to provide the shareholders
> of mines and railways with their incomes."_ [ **Words of a Rebel** , pp.
> 65-6]

In summary, current imperialism is caused by, and always serves, the needs and
interests of Capital. If it did not, if imperialism were bad for business, the
business class would oppose it. This partly explains why the colonialism of
the 19th century is no more (the other reasons being social resistance to
foreign domination, which obviously helped to make imperialism bad for
business as well, and the need for US imperialism to gain access to these
markets after the second world war). There are now more cost-effective means
than direct colonialism to ensure that "underdeveloped" countries remain open
to exploitation by foreign capital. Once the costs exceeded the benefits,
colonialist imperialism changed into the neo-colonialism of multinationals,
political influence, and the threat of force. Moreover, we must not forget
that any change in imperialism relates to changes in the underlying economic
system and so the changing nature of modern imperialism can be roughly linked
to developments within the capitalist economy.

Imperialism, then, is basically the ability of countries to globally and
locally dictate trade relations and investments with other countries in such a
way as to gain an advantage over the other countries. When capital is invested
in foreign nations, the surplus value extracted from the workers in those
nations are not re-invested in those nations. Rather a sizeable part of it
returns to the base nation of the corporation (in the form of profits for that
company). Indeed, that is to be expected as the whole reason for the
investment of capital in the first place was to get more out of the country
than the corporation put into it. Instead of this surplus value being re-
invested into industry in the less-developed nation (as would be the case with
home-grown exploiters, who are dependent on local markets and labour) it ends
up in the hands of foreign exploiters who take them out of the dominated
country. This means that industrial development as less resources to draw on,
making the local ruling class dependent on foreign capital and its whims.

This can be done directly (by means of invasion and colonies) or indirectly
(by means of economic and political power). Which method is used depends on
the specific circumstances facing the countries in question. Moreover, it
depends on the balance of class forces within each country as well (for
example, a nation with a militant working class would be less likely to pursue
a war policy due to the social costs involved). However, the aim of
imperialism is always to enrich and empower the capitalist and bureaucratic
classes.

## D.5.1 How has imperialism changed over time?

The development of Imperialism cannot be isolated from the general dynamics
and tendencies of the capitalist economy. Imperialist capitalism, therefore,
is not identical to pre-capitalist forms of imperialism, although there can,
of course, be similarities. As such, it must be viewed as an advanced stage of
capitalism and not as some kind of deviation of it. This kind of imperialism
was attained by some nations, mostly Western European, in the late 19th and
early 20th-century. Since then it has changed and developed as economic and
political developments occurred, but it is based on the same basic principles.
As such, it is useful to describe the history of capitalism in order to fully
understand the place imperialism holds within it, how it has changed, what
functions it provides and, consequently, how it may change in the future.

Imperialism has important economic advantages for those who run the economy.
As the needs of the business class change, the forms taken by imperialism also
change. We can identify three main phases: classic imperialism (i.e.
conquest), indirect (economic) imperialism, and globalisation. We will
consider the first two in this section and globalisation in [section
D.5.3](secD5.md#secd53). However, for all the talk of globalisation in
recent years, it is important to remember that capitalism has always been an
international system, that the changing forms of imperialism reflect this
international nature and that the changes within imperialism are in response
to developments within capitalism itself.

Capitalism has always been expansive. Under mercantilism, for example, the
"free" market was nationalised **within** the nation state while state aid was
used to skew international trade on behalf of the home elite and favour the
development of capitalist industry. This meant using the centralised state
(and its armed might) to break down "internal" barriers and customs which
hindered the free flow of goods, capital and, ultimately, labour. We should
stress this as the state has always played a key role in the development and
protection of capitalism. The use of the state to, firstly, protect infant
capitalist manufacturing and, secondly, to create a "free" market (i.e. free
from the customs and interference of society) should not be forgotten,
particularly as this second ("internal") role is repeated "externally" through
imperialism. Needless to say, this process of "internal" imperialism within
the country by the ruling class by means of the state was accompanied by
extensive violence against the working class (also see [section
F.8](secF8.md)).

So, state intervention was used to create and ensure capital's dominant
position at home by protecting it against foreign competition and the recently
dispossessed working class. This transition from feudal to capitalist economy
enjoyed the active promotion of the state authorities, whose increasing
centralisation ran parallel with the growing strength and size of merchant
capital. It also needed a powerful state to protect its international trade,
to conquer colonies and to fight for control over the world market. The
absolutist state was used to actively implant, help and develop capitalist
trade and industry.

The first industrial nation was Britain. After building up its industrial base
under mercantilism and crushing its rivals in various wars, it was in an ideal
position to dominate the international market. It embraced free trade as its
unique place as the only capitalist/industrialised nation in the world market
meant that it did not have to worry about competition from other nations. Any
free exchange between unequal traders will benefit the stronger party. Thus
Britain, could achieve domination in the world market by means of free trade.
This meant that goods were exported rather than capital.

Faced with the influx of cheap, mass produced goods, existing industry in
Europe and the Americas faced ruin. As economist Nicholas Kaldor notes, _"the
arrival of cheap factory-made English goods **did** cause a loss of employment
and output of small-scale industry (the artisanate) both in European countries
(where it was later offset by large-scale industrialisation brought about by
protection) and even more in India and China, where it was no so offset."_ [
**Further Essays on Applied Economics** , p. 238] The existing industrial base
was crushed, industrialisation was aborted and unemployment rose. These
countries faced two possibilities: turn themselves into providers of raw
materials for Britain or violate the principles of the market and
industrialise by protectionism.

In many nations of Western Europe (soon to be followed by the USA and Japan),
the decision was simple. Faced with this competition, these countries utilised
the means by which Britain had industrialised -- state protection. Tariff
barriers were raised, state aid was provided and industry revived sufficiently
to turn these nations into successful competitors of Britain. This process was
termed by Kropotkin as _"the consecutive development of nations"_ (although he
underestimated the importance of state aid in this process). No nation, he
argued, would let itself become specialised as the provider of raw materials
or the manufacturer of a few commodities but would diversify into many
different lines of production. Obviously no national ruling class would want
to see itself be dependent on another and so industrial development was
essential (regardless of the wishes of the general population). Thus a nation
in such a situation _"tries to emancipate herself from her dependency . . .
and rapidly begins to manufacture all those goods she used to import."_ [
**Fields, Factories and Workshops** , p. 49 and p. 32]

Protectionism may have violated the laws of neo-classical economics, but it
proved essential for industrialisation. While, as Kropotkin argued,
protectionism ensured _"the high profits of those manufacturers who do not
improve their factories and chiefly rely upon cheap labour and long hours,"_
it also meant that these profits would be used to finance industry and develop
an industrial base. [ **Op. Cit.** , p. 41] Without this state aid, it is
doubtful that these countries would have industrialised (as Kaldor notes,
_"all the present 'developed' or 'industrialised' countries established their
industries through 'import substitution' by means of protective tariffs and/or
differential subsidies."_ [ **Op. Cit.** , p. 127]).

Within the industrialising country, the usual process of competition driving
out competitors continued. More and more markets became dominated by big
business (although, as Kropotkin stressed, without totally eliminating smaller
workshops within an industry and even creating more around them). Indeed, as
Russian anarchist G. P. Maximoff stressed, the _"specific character of
Imperialism is . . . the concentration and centralisation of capital in
syndicates, trusts and cartels, which . . . have a decisive voice, not only in
the economic and political life of their countries, but also in the life of
the nations of the worlds a whole."_ [ **Program of Anarcho-Syndicalism** , p.
10] The modern multi-national and transnational corporations are the latest
expression of this process.

Simply put, the size of big business was such that it had to expand
internationally as their original national markets were not sufficient and to
gain further advantages over their competitors. Faced with high tariff
barriers and rising international competition, industry responded by exporting
capital as well as finished goods. This export of capital was an essential way
of beating protectionism (and even reap benefits from it) and gain a foothold
in foreign markets ( _"protective duties have no doubt contributed . . .
towards attracting German and English manufacturers to Poland and Russia"_
[Kropotkin, **Op. Cit.** , p. 41]). In addition, it allowed access to cheap
labour and raw materials by placing capital in foreign lands As part of this
process colonies were seized to increase the size of "friendly" markets and,
of course, allow the easy export of capital into areas with cheap labour and
raw materials. The increased concentration of capital this implies was
essential to gain an advantage against foreign competitors and dominate the
international market as well as the national one.

This form of imperialism, which arose in the late nineteenth century, was
based on the creation of larger and larger businesses and the creation of
colonies across the globe by the industrialised nations. Direct conquest had
the advantage of opening up more of the planet for the capitalist market, thus
leading to more trade and exploitation of raw materials and labour. This gave
a massive boost to both the state and the industries of the invading country
in terms of new profits, so allowing an increase in the number of capitalists
and other social parasites that could exist in the developed nation. As
Kropotkin noted at the time, _"British, French, Belgian and other capitalists,
by means of the ease with which they exploit countries which themselves have
no developed industry, today control the labour of hundreds of millions of
those people in Eastern Europe, Asia, and Africa. The result is that the
number of those people in the leading industrialised countries of Europe who
live off the work of others doesn't gradually decrease at all. Far from it."_
[ _"Anarchism and Syndicalism"_ , **Black Flag** , no. 210, p. 26]

As well as gaining access to raw materials, imperialism allows the dominating
nation to gain access to markets for its goods. By having an empire, products
produced at home can be easily dumped into foreign markets with less developed
industry, undercutting locally produced goods and consequently destroying the
local economy (and so potential competitors) along with the society and
culture based on it. Empire building is a good way of creating privileged
markets for one's goods. By eliminating foreign competition, the imperialist
nation's capitalists can charge monopoly prices in the dominated country, so
ensuring high profit margins for capitalist business. This adds with the
problems associated with the over-production of goods:

> _"The workman being unable to purchase with their wages the riches they are
> producing, industry must search for new markets elsewhere, amidst the middle
> classes of other nations. It must find markets, in the East, in Africa,
> anywhere; it must increase, by trade, the number of its serfs in Egypt, in
> India, on the Congo. But everywhere it finds competitors in other nations
> which rapidly enter into the same line of industrial development. And wars,
> continuous wars, must be fought for the supremacy in the world-market --
> wars for the possession of the East, wars for getting possession of the
> seas, wars for the right of imposing heavy duties on foreign merchandise."_
> [Kropotkin, **Anarchism** , pp. 55-6]

This process of expansion into non-capitalist areas also helps Capital to
weather both the subjective and objective economic pressures upon it which
cause the business cycle (see [section C.7](secC7.md) for more details). As
wealth looted from less industrially developed countries is exported back to
the home country, profit levels can be protected both from working-class
demands and from any relative decline in surplus-value production caused by
increased capital investment (see [section C.2](secC2.md) for more on
surplus value). In fact, the working class of the imperialist country could
receive improved wages and living conditions as the looted wealth was imported
into the country and that meant that the workers could fight for, and win,
improvements that otherwise would have provoked intense class conflict. And as
the sons and daughters of the poor emigrated to the colonies to make a living
for themselves on stolen land, the wealth extracted from those colonies helped
to overcome the reduction in the supply of labour at home which would increase
its market price. This loot also helps reduce competitive pressures on the
nation's economy. Of course, these advantages of conquest cannot totally
**stop** the business cycle nor eliminate competition, as the imperialistic
nations soon discovered.

Therefore, the "classic" form of imperialism based on direct conquest and the
creation of colonies had numerous advantages for the imperialist nations and
the big business which their states represented.

These dominated nations were, in the main, pre-capitalist societies. The
domination of imperialist powers meant the importation of capitalist social
relationships and institutions into them, so provoking extensive cultural and
physical resistance to these attempts of foreign capitalists to promote the
growth of the free market. However, peasants', artisans' and tribal people's
desires to be "left alone" was never respected, and "civilisation" was forced
upon them "for their own good." As Kropotkin realised, _"force is necessary to
continually bring new 'uncivilised nations' under the same conditions [of wage
labour]."_ [ **Anarchism and Anarchist Communism** , p. 53] Anarchist George
Bradford also stresses this, arguing that we _"should remember that,
historically, colonialism, bringing with it an emerging capitalist economy and
wage system, destroyed the tradition economies in most countries. By
substituting cash crops and monoculture for forms of sustainable agriculture,
it destroyed the basic land skills of the people whom it reduced to plantation
workers."_ [ **How Deep is Deep Ecology** , p. 40] Indeed, this process was in
many ways similar to the development of capitalism in the "developed" nations,
with the creation of a class of landless workers who forms the nucleus of the
first generation of people given up to the mercy of the manufacturers.

However, this process had objective limitations. Firstly, the expansion of
empires had the limitation that there were only so many potential colonies out
there. This meant that conflicts over markets and colonies was inevitable (as
the states involved knew, and so they embarked on a policy of building larger
and larger armed forces). As Kropotkin argued before the First World War, the
real cause of war at the time was _"the competition for markets and the right
to exploit nations backward in industry."_ [quoted by Martin Miller,
**Kropotkin** , p. 225] Secondly, the creation of trusts, the export of goods
and the import of cheap raw materials cannot stop the business cycle nor "buy-
off" the working class indefinitely (i.e. the excess profits of imperialism
will never be enough to grant more and more reforms and improvements to the
working class in the industrialised world). Thus the need to overcome economic
slumps propelled business to find new ways of dominating the market, up to and
including the use of war to grab new markets and destroy rivals. Moreover, war
was a good way of side tracking class conflict at home -- which, let us not
forget, had been reaching increasingly larger, more militant and more radical
levels in all the imperialist nations (see John Zerzan's _"Origins and Meaning
of WWI"_ in his **Elements of Refusal** ).

Thus this first phase of imperialism began as the growing capitalist economy
started to reach the boundaries of the nationalised market created by the
state within its own borders. Imperialism was then used to expand the area
that could be colonised by the capital associated with a given nation-state.
This stage ended, however, once the dominant powers had carved up the planet
into different spheres of influence and there was nowhere left to expand into.
In the competition for access to cheap raw materials and foreign markets,
nation-states came into conflict with each other. As it was obvious that a
conflict was brewing, the major European countries tried to organise a
"balance of power." This meant that armies were built and navies created to
frighten other countries and so deter war. Unfortunately, these measures were
not enough to countermand the economic and power processes at play ( _"Armies
equipped to the teeth with weapons, with highly developed instruments of
murder and backed by military interests, have their own dynamic interests,"_
as Goldman put it [ **Red Emma Speaks** , p. 353]). War did break out, a war
over empires and influence, a war, it was claimed, that would end all wars. As
we now know, of course, it did not because it did not fight the root cause of
modern wars, capitalism.

After the First World War, the identification of nation-state with national
capital became even more obvious, and can be seen in the rise of extensive
state intervention to keep capitalism going -- for example, the rise of
Fascism in Italy and Germany and the efforts of "national" governments in
Britain and the USA to "solve" the economic crisis of the Great Depression.
However, these attempts to solve the problems of capital did not work. The
economic imperatives at work before the first world war had not gone away. Big
business still needed markets and raw materials and the statification of
industry under fascism only aided to the problems associated with imperialism.
Another war was only a matter of time and when it came most anarchists, as
they had during the first world war, opposed both sides and called for
revolution:

> _"the present struggle is one between rival Imperialisms and for the
> protection of vested interests. The workers in every country, belonging to
> the oppressed class, have nothing in common with these interests and the
> political aspirations of the ruling class. Their immediate struggle is their
> **emancipation.** **Their** front line is the workshop and factory, not the
> Maginot Line where they will just rot and die, whilst their masters at home
> pile up their ill-gotten gains."_ [ _"War Commentary"_ , quoted Mark
> Shipway, **Anti-Parliamentary Communism** , p. 170]

After the Second World War, the European countries yielded to pressure from
the USA and national liberation movements and grated many former countries
"independence" (often after intense conflict). As Kropotkin predicted, such
social movements were to be expected for with the growth of capitalism _"the
number of people with an interest in the capitulation of the capitalist state
system also increases."_ [ _"Anarchism and Syndicalism"_ , **Op. Cit.** , p.
26] Unfortunately these "liberation" movements transformed mass struggle from
a potential struggle against capitalism into movements aiming for independent
capitalist nation states (see [section D.7](secD7.md)). Not, we must stress,
that the USA was being altruistic in its actions, independence for colonies
weakened its rivals as well as allowing US capital access to those markets.

This process reflected capital expanding even more **beyond** the nation-state
into multinational corporations. The nature of imperialism and imperialistic
wars changed accordingly. In addition, the various successful struggles for
National Liberation ensured that imperialism had to change itself in face of
popular resistance. These two factors ensured that the old form of imperialism
was replaced by a new system of "neo-colonialism" in which newly "independent"
colonies are forced, via political and economic pressure, to open their
borders to foreign capital. If a state takes up a position which the imperial
powers consider "bad for business," action will be taken, from sanctions to
outright invasion. Keeping the world open and "free" for capitalist
exploitation has been America's general policy since 1945. It springs directly
from the expansion requirements of private capital and so cannot be
fundamentally changed. However, it was also influenced by the shifting needs
resulting from the new political and economic order and the rivalries existing
between imperialist nations (particularly those of the Cold War). As such,
which method of intervention and the shift from direct colonialism to neo-
colonialism (and any "anomalies") can be explained by these conflicts.

Within this basic framework of indirect imperialism, many "developing" nations
did manage to start the process of industrialising. Partly in response to the
Great Depression, some former colonies started to apply the policies used so
successfully by imperialist nations like Germany and America in the previous
century. They followed a policy of "import substitution" which meant that they
tried to manufacture goods like, for instance, cars that they had previously
imported. Without suggesting this sort of policy offered a positive
alternative (it was, after all, just local capitalism) it did have one big
disadvantage for the imperialist powers: it tended to deny them both markets
and cheap raw materials (the current turn towards globalisation was used to
break these policies). As such, whether a nation pursued such policies was
dependent on the costs involved to the imperialist power involved.

So instead of direct rule over less developed nations (which generally proved
to be too costly, both economically and politically), indirect forms of
domination were now preferred. These are rooted in economic and political
pressure rather than the automatic use of violence, although force is always
an option and is resorted to if "business interests" are threatened. This is
the reality of the expression "the international community" -- it is code for
imperialist aims for Western governments, particularly the U.S. and its junior
partner, the U.K. As discussed in [section D.2.1](secD2.md#secd21), economic
power can be quite effective in pressuring governments to do what the
capitalist class desire even in advanced industrial countries. This applies
even more so to so-called developing nations.

In addition to the stick of economic and political pressure, the imperialist
countries also use the carrot of foreign aid and investment to ensure their
aims. This can best be seen when Western governments provide lavish funds to
"developing" states, particularly petty right-wing despots, under the
pseudonym "foreign aid." Hence the all to common sight of US Presidents
supporting authoritarian (indeed, dictatorial) regimes while at the same time
mouthing nice platitudes about "liberty" and "progress." The purpose of this
foreign aid, noble-sounding rhetoric about freedom and democracy aside, is to
ensure that the existing world order remains intact and that US corporations
have access to the raw materials and markets they need. Stability has become
the watchword of modern imperialists, who see **any** indigenous popular
movements as a threat to the existing world order. The U.S. and other Western
powers provide much-needed war material and training for the military of these
governments, so that they may continue to keep the business climate friendly
to foreign investors (that means tacitly and overtly supporting fascism around
the globe).

Foreign aid also channels public funds to home based transnational companies
via the ruling classes in Third World countries. It is, in other words, is a
process where the poor people of rich countries give their money to the rich
people of poor countries to ensure that the investments of the rich people of
rich countries is safe from the poor people of poor countries! Needless to
say, the owners of the companies providing this "aid" also do very well out of
it. This has the advantage of securing markets as other countries are
"encouraged" to buy imperialist countries' goods (often in exchange for "aid",
typically military "aid") and open their markets to the dominant power's
companies and their products.

Thus, the Third World sags beneath the weight of well-funded oppression, while
its countries are sucked dry of their native wealth, in the name of
"development" and in the spirit of "democracy" and "freedom". The United
States leads the West in its global responsibility (another favourite
buzzword) to ensure that this peculiar kind of "freedom" remains unchallenged
by any indigenous movements. The actual form of the regime supported is
irrelevant, although fascist states are often favoured due to their stability
(i.e. lack of popular opposition movements). As long as the fascist regimes
remain compliant and obedient to the West and capitalism thrives unchallenged
then they can commit any crime against their own people while being praised
for making progress towards "democracy." However, the moment they step out of
line and act in ways which clash with the interests of the imperialist powers
then their short-comings will used to justify intervention (the example of
Saddam Hussein is the most obvious one to raise here). As for "democracy,"
this can be tolerated by imperialism as long as its in _"the traditional sense
of 'top-down' rule by elites linked to US power, with democratic forms of
little substance -- unless they are compelled to do so, by their own
populations in particular."_ This applies _"internally"_ as well as abroad,
for _"democracy is fine as long as it . . . does not risk popular interference
with primary interests of power and wealth."_ Thus the aim is to ensure _"an
obedient client state is firmly in place, the general perferene of conquerors,
leaving just military bases for future contingencies."_ [ **Failed States** ,
p. 171, p. 204 and p. 148]

In these ways, markets are kept open for corporations based in the advanced
nations all without the apparent use of force or the need for colonies.
However, this does not mean that war is not an option and, unsurprisingly, the
post-1945 period has been marked by imperialist conflict. These include old-
fashioned direct war by the imperialist nation (such as the Vietnam and Iraq
wars) as well as new-style imperialistic wars by proxy (such as US support for
the Contras in Nicaragua or support for military coups against reformist or
nationalist governments). As such, if a regime becomes too independent,
military force always remains an option. This can be seen from the 1990 Gulf
War, when Saddam invaded Kuwait (and all his past crimes, conducted with the
support of the West, were dragged from the Memory Hole to justify war).

Least it be considered that we are being excessive in our analysis, let us not
forget that the US _"has intervened well over a hundred times in the internal
affairs of other nations since 1945. The rhetoric has been that we have done
so largely to preserve or restore freedom and democracy, or on behalf of human
rights. The reality has been that [they] . . . have been consistently designed
and implemented to further the interests of US (now largely transnational)
corporations, and the elites both at home and abroad who profit from their
depredations."_ [Henry Rosemont, Jr., _"U.S. Foreign Policy: the Execution of
Human Rights"_ , pp. 13-25, **Social Anarchism** , no. 29 p. 13] This has
involved the overthrow of democratically elected governments (such as in Iran,
1953; Guatemala, 1954; Chile, 1973) and their replacement by reactionary
right-wing dictatorships (usually involving the military). As George Bradford
argues, _"[i]n light of [the economic] looting [by corporations under
imperialism], it should become clearer . . . why nationalist regimes that
cease to serve as simple conduits for massive U.S. corporate exploitation come
under such powerful attack -- Guatemala in 1954, Chile in 1973 . . . Nicaragua
[in the 1980s] . . . [U.S.] State Department philosophy since the 1950s has
been to rely on various police states and to hold back 'nationalistic regimes'
that might be more responsive to 'increasing popular demand for immediate
improvements in the low living standards of the masses,' in order to 'protect
our resources' -- in their countries!"_ [ **How Deep is Deep Ecology?** , p.
62]

This is to be expected, as imperialism is the only means of defending the
foreign investments of a nation's capitalist class, and by allowing the
extraction of profits and the creation of markets, it also safeguards the
future of private capital.

This process has not come to an end and imperialism is continuing to evolve
based on changing political and economic developments. The most obvious
political change is the end of the USSR. During the cold war, the competition
between the USA and the USSR had an obvious impact on how imperialism worked.
On the one hand, acts of imperial power could be justified in fighting
"Communism" (for the USA) or "US imperialism" (for the USSR). On the other,
fear of provoking a nuclear war or driving developing nations into the hands
of the other side allowed more leeway for developing nations to pursue
policies like import substitution. With the end of the cold-war, these options
have decreased considerably for developing nations as US imperialism how has,
effectively, no constraints beyond international public opinion and pressure
from below. As the invasion of Iraq in 2003 shows, this power is still weak
but sufficient to limit some of the excesses of imperial power (for example,
the US could not carpet bomb Iraq as it had Vietnam).

The most obvious economic change is the increased global nature of capitalism.
Capital investments in developing nations have increased steadily over the
years, with profits from the exploitation of cheap labour flowing back into
the pockets of the corporate elite in the imperialist nation, not to its
citizens as a whole (though there are sometimes temporary benefits to other
classes, as discussed in [section D.5.4](secD5.md#secd54)). With the
increasing globalisation of big business and markets, capitalism (and so
imperialism) is on the threshold of a new transformation. Just as direct
imperialism transformed into in-direct imperialism, so in-direct imperialism
is transforming into a global system of government which aims to codify the
domination of corporations over governments. This process is often called
"globalisation" and we discuss it in [section D.5.3](secD5.md#secd53).
First, however, we need to discuss non-private capitalist forms of imperialism
associated with the Stalinist regimes and we do that in the [next
section](secD5.md#secd52).

## D.5.2 Is imperialism just a product of private capitalism?

While we are predominantly interested in **capitalist** imperialism, we cannot
avoid discussing the activities of the so-called "socialist" nations (such as
the Soviet Union, China, etc.). Given that modern imperialism has an economic
base caused in developed capitalism by, in part, the rise of big business
organised on a wider and wider scale, we should not be surprised that the
state capitalist ("socialist") nations are/were also imperialistic. As the
state-capitalist system expresses the logical end point of capital
concentration (the one big firm) the same imperialistic pressures that apply
to big business and its state will also apply to the state capitalist nation.

In the words of libertarian socialist Cornelius Castoriadis:

> _"But if imperialist expansion is the necessary expression of an economy in
> which the process of capital concentration has arrived at the stage of
> monopoly domination, this is true a fortiori for an economy in which this
> process of concentration has arrived at its natural limit . . . In other
> words, imperialist expansion is even more necessary for a totally
> concentrated economy . . . That they are realised through different modes
> (for example, capital exportation play a much more restricted role and acts
> in a different way than is the case with monopoly domination) is the result
> of the differences separating bureaucratic capitalism from monopoly
> capitalism, but at bottom this changes nothing.  
>  _
>
> _"We must strongly emphasise that the imperialistic features of capital are
> not tied to 'private' or 'State' ownership of the means of production . . .
> the same process takes place if, instead of monopolies, there is an
> exploiting bureaucracy; in other words, this bureaucracy also can
> **exploit** , but only on the condition that it **dominates.** "_ [
> **Political and Social Writings** , vol. 1, p. 159]

Given this, it comes as no surprise that the state-capitalist countries also
participated in imperialist activities, adventures and wars, although on a
lesser scale and for slightly different reasons than those associated with
private capitalism. However, regardless of the exact cause the USSR _"has
always pursued an imperialist foreign policy, that it is the state and not the
workers which owns and controls the whole life of the country."_ Given this,
it is unsurprising that _"world revolution was abandoned in favour of
alliances with capitalist countries. Like the bourgeois states the USSR took
part in the manoeuvrings to establish a balance of power in Europe."_ This has
its roots in its internal class structure, as _"it is obvious that a state
which pursues an imperialist foreign policy cannot itself by revolutionary"_
and this is shown in _"the internal life of the USSR"_ where _"the means of
wealth production"_ are _"owned by the state which represents, as always, a
privileged class -- the bureaucracy."_ [ _"USSR -- Anarchist Position,"_ pp.
21-24, Vernon Richards (ed.), **The Left and World War II** , p. 22 and p. 23]

This process became obvious after the defeat of Nazi Germany and the creation
of Stalinist states in Eastern Europe. As anarchists at the time noted, this
was _"the consolidation of Russian imperialist power"_ and their
_"incorporation . . . within the structure of the Soviet Union."_ As such,
_"all these countries behind the Iron Curtain are better regarded as what they
really [were] -- satellite states of Russia."_ [ _"Russia's Grip Tightens"_ ,
pp. 283-5, Vernon Richards (ed.), **World War - Cold War** , p. 285 and p.
284] Of course, the creation of these satellite states was based on the inter-
imperialist agreements reached at the Yalta conference of February 1945.

As can be seen by Russia's ruthless policy towards her satellite regimes,
Soviet imperialism was more inclined to the defence of what she already had
and the creation of a buffer zone between herself and the West. This is not to
deny that the ruling elite of the Soviet Union did not try to exploit the
countries under its influence. For example, in the years after the end of the
Second World War, the Eastern Block countries paid the USSR millions of
dollars in reparations. As in private capitalism, the _"satellite states were
regarded as a source of raw materials and of cheap manufactured goods. Russia
secured the satellites exports at below world prices. And it exported to them
at above world prices."_ Thus trade _"was based on the old imperialist
principle of buying cheap and selling dear -- very, very dear!"_ [Andy
Anderson, **Hungary '56** , pp. 25-6 and p. 25] However, the nature of the
imperialist regime was such that it discouraged too much expansionism as
_"Russian imperialism [had] to rely on armies of occupation, utterly
subservient quisling governments, or a highly organised and loyal political
police (or all three). In such circumstances considerable dilution of Russian
power occur[red] with each acquisition of territory."_ [ _"Russian
Imperialism"_ , pp. 270-1, Vernon Richards (ed.), **Op. Cit.** , p. 270]

Needless to say, the form and content of the state capitalist domination of
its satellite countries was dependent on its own economic and political
structure and needs, just as traditional capitalist imperialism reflected its
needs and structures. While direct exploitation declined over time, the
satellite states were still expected to develop their economies in accordance
with the needs of the Soviet Bloc as a whole (i.e., in the interests of the
Russian elite). This meant the forcing down of living standards to accelerate
industrialisation in conformity with the requirements of the Russian ruling
class. This was because these regimes served not as outlets for excess Soviet
products but rather as a means of _"plugging holes in the Russian economy,
which [was] in a chronic state of underproduction in comparison to its
needs."_ As such, the _"form and content"_ of this regimes' _"domination over
its satellite countries are determined fundamentally by its own economic
structure"_ and so it would be _"completely incorrect to consider these
relations identical to the relations of classical colonialism."_ [Castoriadis,
**Op. Cit.** , p. 187] So part of the difference between private and state
capitalist was drive by the need to plunder these countries of commodities to
make up for shortages caused by central planning (in contrast, capitalist
imperialism tended to export goods). As would be expected, within this overall
imperialist agenda the local bureaucrats and elites feathered their own nests,
as with any form of imperialism.

As well as physical expansionism, the state-capitalist elites also aided
"anti-imperialist" movements when it served their interests. The aim of this
was to placed such movements and any regimes they created within the Soviet or
Chinese sphere of influence. Ironically, this process was aided by imperialist
rivalries with US imperialism as American pressure often closed off other
options in an attempt to demonise such movements and states as "communist" in
order to justify supporting their repression or for intervening itself. This
is **not** to suggest that Soviet regime was encouraging "world revolution" by
this support. Far from it, given the Stalinist betrayals and attacks on
genuine revolutionary movements and struggles (the example of the Spanish
Revolution is the obvious one to mention here). Soviet aid was limited to
those parties which were willing to subjugate themselves and any popular
movements they influenced to the needs of the Russian ruling class. Once the
Stalinist parties had replaced the local ruling class, trade relations were
formalised between the so-called "socialist" nations for the benefit of both
the local and Russian rulers. In a similar way, and for identical needs, the
Western Imperialist powers supported murderous local capitalist and feudal
elites in their struggle against their own working classes, arguing that it
was supporting "freedom" and "democracy" against Soviet aggression.

The turning of Communist Parties into conduits of Soviet elite interests
became obvious under Stalin, when the twists and turns of the party line were
staggering. However, it actually started under Lenin and Trotsky and _"almost
from the beginning"_ the Communist International (Comintern) _"served
primarily not as an instrument for World Revolution, but as an instrument of
Russian Foreign Policy."_ This explains _"the most bewildering changes of
policy and political somersaults"_ it imposed on its member parties.
Ultimately, _"the allegedly revolutionary aims of the Comintern stood in
contrast to the diplomatic relations of the Soviet Union with other
countries."_ [Marie-Louise Berneri, **Neither East Nor West** , p. 64 and p.
63] As early as 1920, the Dutch Council Communist Anton Pannekoek was arguing
that the Comintern opposition to anti-parliamentarianism was rooted _"in the
needs of the Soviet Republic"_ for _"peaceful trade with the rest of the
world."_ This meant that the Comintern's policies were driven _"by the
political needs of Soviet Russia."_ [ _"Afterword to World Revolution and
Communist Tactics,"_ D.A. Smart (ed.), **Pannekoek and Gorter's Marxism** , p.
143 and p. 144] This is to be expected, as the regime had always been state
capitalist and so the policies of the Comintern were based on the interests of
a (state) capitalist regime.

Therefore, imperialism is not limited to states based on private capitalism --
the state capitalist regimes have also been guilty of it. This is to be
expected, as both are based on minority rule, the exploitation and oppression
of labour and the need to expand the resources available to it. This means
that anarchists oppose all forms of capitalist imperialism and raise the
slogan _"Neither East nor West."_ We _"cannot alter our views about Russia [or
any other state capitalist regime] simply because, for imperialist reasons,
American and British spokesmen now denounce Russia totalitarianism. We know
that their indignation is hypocritical and that they may become friendly to
Russia again if it suits their interests."_ [Marie-Louise Berneri, **Op.
Cit.** , p. 187] In the clash of imperialism, anarchists support neither side
as both are rooted in the exploitation and oppression of the working class.

Finally, it is worthwhile to refute two common myths about state capitalist
imperialism. The first myth is that state-capitalist imperialism results in a
non-capitalist regimes and that is why it is so opposed to by Western
interests. From this position, held by many Trotskyists, it is argued that we
should support such regimes against the West (for example, that socialists
should have supported the Russian invasion of Afghanistan). This position is
based on a fallacy rooted in the false Trotskyist notion that state ownership
of the means of production is inherently socialist.

Just as capitalist domination saw the transformation of the satellite's
countries social relations from pre-capitalist forms in favour of capitalist
ones, the domination of "socialist" nations meant the elimination of
traditional bourgeois social relations in favour of state capitalist ones. As
such, the nature and form of imperialism was fundamentally identical and
served the interests of the appropriate ruling class in each case. This
transformation of one kind of class system into another explains the root of
the West's very public attacks on Soviet imperialism. It had nothing to do
with the USSR being considered a "workers' state" as Trotsky, for example,
argued. _"Expropriation of the capitalist class,"_ argued one anarchist in
1940, _"is naturally terrifying"_ to the capitalist class _"but that does not
prove anything about a workers' state . . . In Stalinist Russia expropriation
is carried out . . . by, and ultimately for the benefit of, the bureaucracy,
not by the workers at all. The bourgeoisie are afraid of expropriation, of
power passing out of their hands, whoever seizes it from them. They will
defend their property against any class or clique. The fact that they are
indignant [about Soviet imperialism] proves their fear -- it tells us nothing
at all about the agents inspiring that fear."_ [J.H., _"The Fourth
International"_ , pp. 37-43, Vernon Richards (ed.), **Op. Cit.** , pp. 41-2]
This elimination of tradition forms of class rule and their replacement with
new forms is required as these are the only economic forms compatible with the
needs of the state capitalist regimes to exploit these countries on a regular
basis.

The second myth is the notion that opposition to state-capitalist imperialism
by its subject peoples meant support for Western capitalism. In fact, the
revolts and revolutions which repeatedly flared up under Stalinism almost
always raised genuine socialist demands. For example, the 1956 Hungarian
revolution _"was a social revolution in the fullest sense of the term. Its
object was a fundamental change in the relations of production, and in the
relations between ruler and ruled in factories, pits and on the land."_ Given
this, unsurprisingly Western political commentary _"was centred upon the
nationalistic aspects of the Revolution, no matter how trivial."_ This was
unsurprising, as the West was _"opposed both to its methods and to its aims .
. . What capitalist government could genuinely support a people demanding
'workers' management of industry' and already beginning to implement this on
an increasing scale?"_ The revolution _"showed every sign of making both them
and their bureaucratic counterparts in the East redundant."_ The revolt itself
was rooted _"[n]ew organs of struggle,"_ workers' councils _"which embodied,
in embryo, the new society they were seeking to achieve."_ [Anderson, **Op.
Cit.** , p.6, p. 106 and p. 107]

The ending of state capitalism in Eastern Europe in 1989 has ended its
imperialist domination of those countries. However, it has simply opened the
door for private-capitalist imperialism as the revolts themselves remained
fundamentally at the political level. The ruling bureaucracy was faced with
both popular pressure from the streets and economic stagnation flowing from
its state-run capitalism. Being unable to continue as before and unwilling,
for obvious reasons, to encourage economic and political participation, it
opted for the top-down transformation of state to private capitalism.
Representative democracy was implemented and state assets were privatised into
the hands of a new class of capitalists (often made up of the old bureaucrats)
rather than the workers themselves. In other words, the post-Stalinist regimes
are still class systems and now subject to a different form of imperialism --
namely, globalisation.

## D.5.3 Does globalisation mean the end of imperialism?

No. While it is true that the size of multinational companies has increased
along with the mobility of capital, the need for nation-states to serve
corporate interests still exists. With the increased mobility of capital, i.e.
its ability to move from one country and invest in another easily, and with
the growth in international money markets, we have seen what can be called a
"free market" in states developing. Corporations can ensure that governments
do as they are told simply by threatening to move elsewhere (which they will
do anyway, if it results in more profits).

Therefore, as Howard Zinn stresses, _"it's very important to point out that
globalisation is in fact imperialism and that there is a disadvantage to
simply using the term 'globalisation' in a way that plays into the thinking of
people at the World Bank and journalists . . . who are agog at globalisation.
They just can't contain their joy at the spread of American economic and
corporate power all over the world. . . it would be very good to puncture that
balloon and say 'This is imperialism.'"_ [ **Bush Drives us into Bakunin's
Arms** ] Globalisation is, like the forms of imperialism that preceded it, a
response to both objective economic forces and the class struggle. Moreover,
like the forms that came before, it is rooted in the economic power of
corporations based in a few developed nations and political power of the
states that are the home base of these corporations. These powers influence
international institutions and individual countries to pursue neo-liberal
policies, the so-called "Washington Consensus" of free market reforms,
associated with globalisation.

Globalisation cannot be understood unless its history is known. The current
process of increasing international trade, investment and finance markets
started in the late 60s and early 1970s. Increased competition from a re-built
Europe and Japan challenged US domination combined with working class struggle
across the globe to leave the capitalist world feeling the strain.
Dissatisfaction with factory and office life combined with other social
movements (such as the women's movement, anti-racist struggles, anti-war
movements and so on) which demanded more than capitalism could provide. The
near revolution in France, 1968, is the most famous of these struggles but it
occurred all across the globe.

For the ruling class, the squeeze on profits and authority from ever-
increasing wage demands, strikes, stoppages, boycotts, squatting, protests and
other struggles meant that a solution had to be found and the working class
disciplined (and profits regained). One part of the solution was to "run away"
and so capital flooded into certain areas of the "developing" world. This
increased the trends towards globalisation. Another solution was the embrace
of Monetarism and tight money (i.e. credit) policies. It is a moot point
whether those who applied Monetarism actually knew it was nonsense and,
consequently, sought an economic crisis or whether they were simply
incompetent ideologues who knew little about economics and mismanaged the
economy by imposing its recommendations, the outcome was the same. It resulted
in increases in the interest rate, which helped deepen the recessions of the
early 1980s which broke the back of working class resistance in the U.K. and
U.S.A. High unemployment helped to discipline a rebellious working class and
the new mobility of capital meant a virtual "investment strike" against
nations which had a "poor industrial record" (i.e. workers who were not
obedient wage slaves). Moreover, as in any economic crisis, the "degree of
monopoly" (i.e. the dominance of large firms) in the market increased as
weaker firms went under and others merged to survive. This enhancing the
tendencies toward concentration and centralisation which always exist in
capitalism, so ensuring an extra thrust towards global operations as the size
and position of the surviving firms required wider and larger markets to
operate in.

Internationally, another crisis played its role in promoting globalisation.
This was the Debit Crisis of the late 1970s and early 1980s. Debt plays a
central role for the western powers in dictating how their economies should be
organised. The debt crisis proved an ideal leverage for the western powers to
force "free trade" on the "third world." This occurred when third world
countries faced with falling incomes and rising interest rates defaulted on
their loans (loans that were mainly given as a bribe to the ruling elites of
those countries and used as a means to suppress the working people of those
countries -- who now, sickenly, are expected to repay them!).

Before this, as noted in [section D.5.1](secD5.md#secd51), many countries
had followed a policy of "import substitution." This tended to create new
competitors who could deny transnational corporations both markets and cheap
raw materials. With the debt crisis, the imperialist powers could end this
policy but instead of military force, the governments of the west sent in the
International Monetary Fund (IMF) and World Bank (WB). The loans required by
"developing" nations in the face of recession and rising debt repayments meant
that they had little choice but to agree to an IMF-designed economic reform
programme. If they refused, not only were they denied IMF funds, but also WB
loans. Private banks and lending agencies would also pull out, as they lent
under the cover of the IMF -- the only body with the power to both underpin
loans and squeeze repayment from debtors. These policies meant introducing
austerity programmes which, in turn, meant cutting public spending, freezing
wages, restricting credit, allowing foreign multinational companies to cherry
pick assets at bargain prices, and passing laws to liberalise the flow of
capital into and out of the country. Not surprisingly, the result was
disastrous for the working population, but the debts were repaid and both
local and international elites did very well out of it. So while workers in
the West suffered repression and hardship, the fate of the working class in
the "developing" world was considerably worse.

Leading economist Joseph Stiglitz worked in the World Bank and described some
of dire consequences of these policies. He notes how the neo-liberalism the
IMF and WB imposed has, _"too often, not been followed by the promised growth,
but by increased misery"_ and workers _"lost their jobs [being] forced into
poverty"_ or _"been hit by a heightened sense of insecurity"_ if they remained
in work. For many _"it seems closer to an unmitigated disaster."_ He argues
that part of the problem is that the IMF and WB have been taken over by true
believers in capitalism and apply market fundamentalism in all cases. Thus,
they _"became the new missionary institutions"_ of _"free market ideology"_
through which _"these ideas were pushed on reluctant poor countries."_ Their
policies were _"based on an ideology -- market fundamentalism -- that required
little, if any, consideration of a country's particular circumstances and
immediate problems. IMF economists could ignore the short-term effects their
policies might have on [a] country, content in the belief **in the long run**
the country would be better off"_ \-- a position which many working class
people there rejected by rioting and protest. In summary, globalisation _"as
it has been practised has not lived up to what its advocates promised it would
accomplish . . . In some cases it has not even resulted in growth, but when it
has, it has not brought benefits to all; the net effect of the policies set by
the Washington Consensus had all too often been to benefit the few at the
expense of the many, the well-off at the expense of the poor."_ [
**Globalisation and Its Discontents** , p. 17, p. 20, p. 13, p. 36 and p. 20]

While transnational companies are, perhaps, the most well-known
representatives of this process of globalisation, the power and mobility of
modern capitalism can be seen from the following figures. From 1986 to 1990,
foreign exchange transactions rose from under $300 billion to $700 billion
daily and were expected to exceed $1.3 trillion in 1994. The World Bank
estimates that the total resources of international financial institutions at
about $14 trillion. To put some kind of perspective on these figures, the
Balse-based Bank for International Settlement estimated that the aggregate
daily turnover in the foreign exchange markets at nearly $900 billion in April
1992, equal to 13 times the Gross Domestic Product of the OECD group of
countries on an annualised basis [ **Financial Times** , 23/9/93]. In Britain,
some $200-300 billion a day flows through London's foreign exchange markets.
This is the equivalent of the UK's annual Gross National Product in two or
three days. Needless to say, since the early 1990s, these amounts have grown
to even higher levels (daily currency transactions have risen from a mere $80
billion in 1980 to $1.26 billion in 1995. In proportion to world trade, this
trading in foreign exchange rose from a ration of 10:1 to nearly 70:1 [Mark
Weisbrot, **Globalisation for Whom?** ]).

Little wonder that a **Financial Times** special supplement on the IMF stated
that _"Wise governments realise that the only intelligent response to the
challenge of globalisation is to make their economies more acceptable."_ [
**Op. Cit.** ] More acceptable to business, that is, not their populations. As
Chomsky put it, _"free capital flow creates what's sometimes called a 'virtual
parliament' of global capital, which can exercise veto power over government
policies that it considers irrational. That means things like labour rights,
or educational programmes, or health, or efforts to stimulate the economy, or,
in fact, anything that might help people and not profits (and therefore
irrational in the technical sense)."_ [ **Rogue States** , pp. 212-3]

This means that under globalisation, states will compete with each other to
offer the best deals to investors and transnational companies -- such as tax
breaks, union busting, no pollution controls, and so forth. The effects on the
countries' ordinary people will be ignored in the name of future benefits (not
so much pie in the sky when you die, more like pie in the future, maybe, if
you are nice and do what you are told). For example, such an "acceptable"
business climate was created in Britain, where _"market forces have deprived
workers of rights in the name of competition."_ [ **Scotland on Sunday** ,
9/1/95] Unsurprisingly. number of people with less than half the average
income rose from 9% of the population in 1979 to 25% in 1993. The share of
national wealth held by the poorer half of the population has fallen from one
third to one quarter. However, as would be expected, the number of
millionaires has increased, as has the welfare state for the rich, with the
public's tax money being used to enrich the few via military Keynesianism,
privatisation and funding for Research and Development. Like any religion, the
free-market ideology is marked by the hypocrisy of those at the top and the
sacrifices required from the majority at the bottom.

In addition, the globalisation of capital allows it to play one work force
against another. For example, General Motors plans to close two dozen plants
in the United States and Canada, but it has become the largest employer in
Mexico. Why? Because an _"economic miracle"_ has driven wages down. Labour's
share of personal income in Mexico has _"declined from 36 percent in the
mid-1970's to 23 percent by 1992."_ Elsewhere, General Motors opened a $690
million assembly plant in the former East Germany. Why? Because there workers
are willing to _"work longer hours than their pampered colleagues in western
Germany"_ (as the **Financial Times** put it) at 40% of the wage and with few
benefits. [Noam Chomsky, **World Orders, Old and New** , p. 160]

This mobility is a useful tool in the class war. There has been _"a
significant impact of NAFTA on strikebreaking. About half of union organising
efforts are disrupted by employer threats to transfer production abroad, for
example . . . The threats are not idle. When such organising drives succeed,
employers close the plant in whole or in part at triple the pre-NAFTA rate
(about 15 percent of the time). Plant-closing threats are almost twice as high
in more mobile industries (e.g. manufacturing vs. construction)."_ [ **Rogue
States** , pp. 139-40] This process is hardly unique to America, and takes
place all across the world (including in the "developing" world itself). This
process has increased the bargaining power of employers and has helped to hold
wages down (while productivity has increased). In the US, the share of
national income going to corporate profits increased by 3.2 percentage points
between 1989 and 1998. This represents a significant redistribution of the
economic pie. [Mark Weisbrot, **Op. Cit.** ] Hence the need for
**international** workers' organisation and solidarity (as anarchists have
been arguing since Bakunin [ **The Political Philosophy of Bakunin** , pp.
305-8]).

This means that such agreements such as NAFTA and the Multilateral Agreement
on Investment (shelved due to popular protest and outrage but definitely not
forgotten) considerably weaken the governments of nation-states -- but only in
one area, the regulation of business. Such agreements restrict the ability of
governments to check capital flight, restrict currency trading, eliminate
environment and labour protection laws, ease the repatriation of profits and
anything else that might impede the flow of profits or reduce business power.
Indeed, under NAFTA, corporations can sue governments if they think the
government is hindering its freedom on the market. Disagreements are settled
by unelected panels outside the control of democratic governments. Such
agreements represent an increase in corporate power and ensure that states can
only intervene when it suits corporations, not the general public.

The ability of corporations to sue governments was enshrined in chapter 11 of
NAFTA. In a small town in the Mexican state of San Luis Potosi, a California
firm -- Metalclad -- a commercial purveyor of hazardous wastes, bought an
abandoned dump site nearby. It proposed to expand on the dumpsite and use it
to dump toxic waste material. The people in the neighbourhood of the dump site
protested. The municipality, using powers delegated to it by the state,
rezoned the site and forbid Metalclad to extend its land holdings. Metalclad,
under Chapter 11 of NAFTA, then sued the Mexican government for damage to its
profit margins and balance sheet as a result of being treated unequally by the
people of San Luis Potosi. A trade panel, convened in Washington, agreed with
the company. [Naomi Klein, **Fences and Windows** , pp. 56-59] In Canada, the
Ethyl corporation sued when the government banned its gasoline additive as a
health hazard. The government settled "out of court" to prevent a public
spectacle of a corporation overruling the nation's Parliament.

NAFTA and other Free Trade agreements are designed for corporations and
corporate rule. Chapter 11 was not enshrined in the NAFTA in order to make a
better world for the people of Canada, any more than for the people of San
Luis Potosi but, instead, for the capitalist elite. This is an inherently
imperialist situation, which will "justify" further intervention in the
"developing" nations by the US and other imperialist nations, either through
indirect military aid to client regimes or through outright invasion,
depending on the nature of the _"crisis of democracy"_ (a term used by the
Trilateral Commission to characterise popular uprisings and a politicising of
the general public).

However, force is always required to protect private capital. Even a
globalised capitalist company still requires a defender. After all, _"[a]t the
international level, U.S. corporations need the government to insure that
target countries are 'safe for investment' (no movements for freedom and
democracy), that loans will be repaid, contracts kept, and international law
respected (but only when it is useful to do so)."_ [Henry Rosemont, Jr., **Op.
Cit.** , p. 18] For the foreseeable future, America seems to be the global
rent-a-cop of choice -- particularly as many of the largest corporations are
based there.

It makes sense for corporations to pick and choose between states for the best
protection, blackmailing their citizens to pay for the armed forces via taxes.
It is, in other words, similar to the process at work within the US when
companies moved to states which promised the most favourable laws. For
example, New Jersey repealed its anti-trust law in 1891-2 and amended its
corporation law in 1896 to allow companies to be as large as they liked, to
operate anywhere and to own other corporations. This drew corporations to it
until Delaware offered even more freedoms to corporate power until other
states offered similar laws. In other words, competed for revenue by writing
laws to sell to corporations and the mobility of corporations meant that they
bargained from a superior position. Globalisation is simply this process on a
larger scale, as capital will move to countries whose governments supply what
it demands (and punish those which do not). Therefore, far from ending
imperialism, globalisation will see it continue, but with one major
difference: the citizens in the imperialist countries will see even fewer
benefits from imperialism than before, while, as ever, still having to carry
the costs.

So, in spite of claims that governments are powerless in the face of global
capital, we should never forget that state power has increased drastically in
one area -- in state repression against its own citizens. No matter how mobile
capital is, it still needs to take concrete form to generate surplus value.
Without wage salves, capital would not survive. As such, it can never
permanently escape from its own contradictions -- wherever it goes, it has to
create workers who have a tendency to disobey and do problematic things like
demand higher wages, better working conditions, go on strike and so on
(indeed, this fact has seen companies based in "developing" nations move to
less "developed" to find more compliant labour).

This, of course, necessitates a strengthening of the state in its role as
protector of property and as a defence against any unrest provoked by the
inequalities, impoverishment and despair caused by globalisation (and, of
course, the hope, solidarity and direct action generated by that unrest within
the working class). Hence the rise of the neo-liberal consensus in both
Britain and the USA saw an increase in state centralisation as well as the
number of police, police powers and in laws directed against the labour and
radical movements.

As such, it would be a mistake (as many in the anti-globalisation movement do)
to contrast the market to the state. State and capital are not opposed to each
other -- in fact, the opposite is the case. The modern state exists to protect
capitalist rule, just as every state exists to defend minority rule, and it is
essential for nation states to attract and retain capital within their borders
to ensure their revenue by having a suitably strong economy to tax.
Globalisation is a state-led initiative whose primary aim is to keep the
economically dominant happy. The states which are being "undermined" by
globalisation are not horrified by this process as certain protestors are,
which should give pause for thought. States are complicit in the process of
globalisation -- unsurprisingly, as they represent the ruling elites who
favour and benefit from globalisation. Moreover, with the advent of a "global
market" under GATT, corporations still need politicians to act for them in
creating a "free" market which best suits their interests. Therefore, by
backing powerful states, corporate elites can increase their bargaining powers
and help shape the "New World Order" in their own image.

Governments may be, as Malatesta put it, the property owners **gendarme** ,
but they can be influenced by their subjects, unlike multinationals. NAFTA was
designed to reduce this influence even more. Changes in government policy
reflect the changing needs of business, modified, of course, by fear of the
working population and its strength. Which explains globalisation -- the need
for capital to strengthen its position vis-à-vis labour by pitting one labour
force against -- and our next step, namely to strengthen and globalise working
class resistance. Only when it is clear that the costs of globalisation -- in
terms of strikes, protests, boycotts, occupations, economic instability and so
on -- is higher than potential profits will business turn away from it. Only
international working class direct action and solidarity will get results.
Until that happens, we will see governments co-operating in the process of
globalisation.

So, for better or for worse, globalisation has become the latest buzz word to
describe the current stage of capitalism and so we shall use it here. It use
does have two positive side effects though. Firstly, it draws attention to the
increased size and power of transnational corporations and their impact on
global structures of governance **and** the nation state. Secondly, it allows
anarchists and other protesters to raise the issue of international solidarity
and a globalisation from below which respects diversity and is based on
people's needs, not profit.

After all, as Rebecca DeWitt stresses, anarchism and the WTO _"are well suited
opponents and anarchism is benefiting from this fight. The WTO is practically
the epitome of an authoritarian structure of power to be fought against.
People came to Seattle because they knew that it was wrong to let a secret
body of officials make policies unaccountable to anyone except themselves. A
non-elected body, the WTO is attempting to become more powerful than any
national government . . . For anarchism, the focus of global capitalism
couldn't be more ideal."_ [ _"An Anarchist Response to Seattle,"_ pp. 5-12,
**Social Anarchism** , no. 29, p. 6]

To sum up, globalisation will see imperialism change as capitalism itself
changes. The need for imperialism remains, as the interests of private capital
still need to be defended against the dispossessed. All that changes is that
the governments of the imperialistic nations become even more accountable to
capital and even less to their populations.

## D.5.4 What is the relationship between imperialism and the social classes
within capitalism?

The two main classes within capitalist society are, as we indicated in
[section B.7](secB7.md), the ruling class and the working class. The grey
area between these two classes is sometimes called the middle class. As would
be expected, different classes have different positions in society and,
therefore, different relationships with imperialism. Moreover, we have to also
take into account the differences resulting from the relative positions of the
nations in question in the world economic and political systems. The ruling
class in imperialist nations will not have identical interests as those in the
dominated ones, for example. As such, our discussion will have indicate these
differences as well.

The relationship between the ruling class and imperialism is quite simple: It
is in favour of it when it supports its interests and when the benefits
outweigh the costs. Therefore, for imperialist countries, the ruling class
will always be in favour of expanding their influence and power as long as it
pays. If the costs outweigh the benefits, of course, sections of the ruling
class will argue against imperialist adventures and wars (as, for example,
elements of the US elite did when it was clear that they would lose both the
Vietnam war and, perhaps, the class war at home by continuing it).

There are strong economic forces at work as well. Due to capital's need to
grow in order to survive and compete on the market, find new markets and raw
materials, it needs to expand (as we discussed in [section D.5](secD5.md)).
Consequently, it needs to conquer foreign markets and gain access to cheap raw
materials and labour. As such, a nation with a powerful capitalist economy
will need an aggressive and expansionist foreign policy, which it achieves by
buying politicians, initiating media propaganda campaigns, funding right-wing
think tanks, and so on, as previously described.

Thus the ruling class benefits from, and so usually supports, imperialism --
only, we stress, when the costs out-weight the benefits will we see members of
the elite oppose it. Which, of course, explains the elites support for what is
termed "globalisation." Needless to say, the ruling class has done **very**
well over the last few decades. For example, in the US, the gaps between rich
and poor **and** between the rich and middle income reaching their widest
point on record in 1997 (from the **Congressional Budget Office** study on
Historic Effective Tax Rates 1979-1997). The top 1% saw their after-tax
incomes rise by $414,200 between 1979-97, the middle fifth by $3,400 and the
bottom fifth fell by -$100. The benefits of globalisation are concentrated at
the top, as is to be expected (indeed, almost all of the income gains from
economic growth between 1989 and 1998 accrued to the top 5% of American
families).

Needless to say, the local ruling classes of the dominated nations may not see
it that way. While, of course, local ruling classes do extremely well from
imperialism, they need not **like** the position of dependence and
subordination they are placed in. Moreover, the steady stream of profits
leaving the country for foreign corporations cannot be used to enrich local
elites even more. Just as the capitalist dislikes the state or a union
limiting their power or taxing/reducing their profits, so the dominated
nation's ruling class dislikes imperialist domination and will seek to ignore
or escape it whenever possible. This is because _"every State, in so far as it
wants to live not only on paper and not merely by sufferance of its
neighbours, but to enjoy real independence -- inevitably must become a
conquering State."_ [Bakunin, **Op. Cit.** , p. 211] So the local ruling
class, while benefiting from imperialism, may dislike its dependent position
and, if it feels strong enough, may contest their position and gain more
independence for themselves.

Many of the post-war imperialist conflicts were of this nature, with local
elites trying to disentangle themselves from an imperialist power. Similarly,
many conflicts (either fought directly by imperialist powers or funded
indirectly by them) were the direct result of ensuring that a nation trying to
free itself from imperialist domination did not serve as a positive example
for other satellite nations. Which means that local ruling classes can come
into conflict with imperialist ones. These can express themselves as wars of
national liberation, for example, or just as normal conflicts (such as the
first Gulf War). As competition is at the heart of capitalism, we should not
be surprised that sections of the international ruling class disagree and
fight each other.

The relationship between the working class and imperialism is more complex. In
traditional imperialism, foreign trade and the export of capital often make it
possible to import cheap goods from abroad and increase profits for the
capitalist class, and in this sense, workers can gain because they can improve
their standard of living without necessarily coming into system threatening
conflict with their employers (i.e. struggle can win reforms which otherwise
would be strongly resisted by the capitalist class). Thus living standard may
be improved by low wage imports while rising profits may mean rising wages for
some key workers (CEOs giving themselves higher wages because they control
their own pay rises does not, of course, count!). Therefore, in imperialistic
nations during economic boom times, one finds a tendency among the working
class (particularly the unorganised sector) to support foreign military
adventurism and an aggressive foreign policy. This is part of what is often
called the "embourgeoisement" of the proletariat, or the co-optation of labour
by capitalist ideology and "patriotic" propaganda. Needless to say, those
workers made redundant by these cheap imports may not consider this as a
benefit and, by increasing the pool of unemployment and the threat of
companies outsourcing work and moving plants to other countries, help hold or
drive down wages for most of the working population (as has happened in
various degrees in Western countries since the 1970s).

However, as soon as international rivalry between imperialist powers becomes
too intense, capitalists will attempt to maintain their profit rates by
depressing wages and laying people off in their own country. Workers' real
wages will also suffer if military spending goes beyond a certain point.
Moreover, if militarism leads to actual war, the working class has much more
to lose than to gain as they will be fighting it and making the necessary
sacrifices on the "home front" in order to win it. In addition, while
imperialism can improve living conditions (for a time), it cannot remove the
hierarchical nature of capitalism and therefore cannot stop the class
struggle, the spirit of revolt and the instinct for freedom. So, while workers
in the developed nations may sometimes benefit from imperialism, such periods
cannot last long and cannot end the class struggle.

Rudolf Rocker was correct to stress the contradictory (and self-defeating)
nature of working class support for imperialism:

> _"No doubt some small comforts may sometimes fall to the share of the
> workers when the bourgeoisie of their country attain some advantage over
> that of another country; but this always happens at the cost of their own
> freedom and the economic oppression of other peoples. The worker . . .
> participates to some extent in the profits which, without effort on their
> part, fall into the laps of the bourgeoisie of his country from the
> unrestrained exploitation of colonial peoples; but sooner or later there
> comes the time when these people too, wake up, and he has to pay all the
> more dearly for the small advantages he has enjoyed. . . . Small gains
> arising from increased opportunity of employment and higher wages may accrue
> to the workers in a successful state from the carving out of new markets at
> the cost of others; but at the same time their brothers on the other side of
> the border have to pay for them by unemployment and the lowering of the
> standards of labour. The result is an ever widening rift in the
> international labour movement . . . By this rift the liberation of the
> workers from the yoke of wage-slavery is pushed further and further into the
> distance. As long as the worker ties up his interests with those of the
> bourgeoisie of his country instead of with his class, he must logically also
> take in his stride all the results of that relationship. He must stand ready
> to fight the wars of the possessing classes for the retention and extension
> of their markets, and to defend any injustice they may perpetrate on other
> people . . . Only when the workers in every country shall come to understand
> clearly that their interests are everywhere the same, and out of this
> understanding learn to act together, will the effective basis be laid for
> the international liberation of the working class."_ [ **Anarcho-
> Syndicalism** , p. 71]

Ultimately, any _"collaboration of workers and employers . . . can only result
in the workers being condemned to . . . eat the crumbs that fall from the rich
man's table."_ [Rocker, **Op. Cit.** , pp. 70-1] This applies to both the
imperialist and the satellite state, of course. Moreover, as imperialism needs
to have a strong military force available for it and as a consequence it
required militarism at home. This has an impact at home in that resources
which could be used to improve the quality of life for all are funnelled
towards producing weapons (and profits for corporations). Moreover, militarism
is directed not only at external enemies, but also against those who threaten
elite role at home. We discuss militarism in more detail in [section
D.8](secD8.md).

However, under globalisation things are somewhat different. With the increase
in world trade and the signing of "free trade" agreements like NAFTA, the
position of workers in the imperialist nations need not improve. For example,
since the 1970s, the wages -- adjusted for inflation -- of the typical
American employee have actually fallen, even as the economy has grown. In
other words, the majority of Americans are no longer sharing in the gains from
economic growth. This is very different from the previous era, for example
1946-73, when the real wages of the typical worker rose by about 80 percent.
Not that this globalisation has aided the working class in the "developing"
nations. In Latin America, for example, GDP per capita grew by 75 percent from
1960-1980, whereas between 1981 and 1998 it has only risen 6 percent. [Mark
Weisbrot, Dean Baker, Robert Naiman, and Gila Neta, **Growth May Be Good for
the Poor-- But are IMF and World Bank Policies Good for Growth?** ]

As Chomsky noted, _"[t]o the credit of the **Wall Street Journal** , it points
out that there's a 'but.' Mexico has 'a stellar reputation,' and it's an
economic miracle, but the population is being devastated. There's been a 40
percent drop in purchasing power since 1994. The poverty rate is going up and
is in fact rising fast. The economic miracle wiped out, they say, a generation
of progress; most Mexicans are poorer than their parents. Other sources reveal
that agriculture is being wiped out by US-subsidised agricultural imports,
manufacturing wages have declines about 20 percent, general wages even more.
In fact, NAFTA is a remarkable success: it's the first trade agreement in
history that's succeeded in harming the populations of all three countries
involved. That's quite an achievement."_ In the U.S., _"the medium income
(half above, half below) for families has gotten back now to what it was in
1989, which is below what it was in the 1970s."_ [ **Rogue States** , pp. 98-9
and p. 213]

An achievement which was predicted. But, of course, while occasionally
admitting that globalisation may harm the wages of workers in developed
countries, it is argued that it will benefit those in the "developing" world.
It is amazing how open to socialist arguments capitalists and their supporters
are, as long as its not their income being redistributed! As can be seen from
NAFTA, this did not happen. Faced with cheap imports, agriculture and local
industry would be undermined, increasing the number of workers seeking work,
so forcing down wages as the bargaining power of labour is decreased. Combine
this with governments which act in the interests of capital (as always) and
force the poor to accept the costs of economic austerity and back business
attempts to break unions and workers resistance then we have a situation where
productivity can increase dramatically while wages fall behind (either
relatively or absolutely). As has been the case in both the USA and Mexico,
for example.

This reversal has had much to do with changes in the global "rules of the
game," which have greatly favoured corporations and weakened labour.
Unsurprisingly, the North American union movement has opposed NAFTA and other
treaties which empower business over labour. Therefore, the position of labour
within both imperialist and dominated nations can be harmed under
globalisation, so ensuring international solidarity and organisation have a
stronger reason to be embraced by both sides. This should not come as a
surprise, however, as the process towards globalisation was accelerated by
intensive class struggle across the world and was used as a tool against the
working class (see [last section](secD5.md#secd53)).

It is difficult to generalise about the effects of imperialism on the "middle
class" (i.e. professionals, self-employed, small business people, peasants and
so on -- **not** middle income groups, who are usually working class). Some
groups within this strata stand to gain, others to lose (in particular,
peasants who are impoverished by cheap imports of food). This lack of common
interests and a common organisational base makes the middle class unstable and
susceptible to patriotic sloganeering, vague theories of national or racial
superiority, or fascist scapegoating of minorities for society's problems. For
this reason, the ruling class finds it relatively easy to recruit large
sectors of the middle class to an aggressive and expansionist foreign policy,
through media propaganda campaigns. Since many in organised labour tends to
perceive imperialism as being against its overall best interests, and thus
usually opposes it, the ruling class is able to intensify the hostility of the
middle class to the organised working class by portraying the latter as
"unpatriotic" and "unwilling to sacrifice" for the "national interest." Sadly,
the trade union bureaucracy usually accepts the "patriotic" message,
particularly at times of war, and often collaborates with the state to further
imperialistic interests. This eventually brings them into conflict with the
rank-and-file, whose interests are ignored even more than usual when this
occurs.

To summarise, the ruling class is usually pro-imperialism -- as long as it is
in their interests (i.e. the benefits outweigh the costs). The working class,
regardless of any short term benefit its members may gain, end up paying the
costs of imperialism by having to fight its wars and pay for the militarism it
produces. So, under imperialism, like any form of capitalism, the working
class will pay the bill required to maintain it. This means that we have a
real interest in ending it -- particularly as under globalisation the few
benefits that used to accrue to us are much less.

[‹ D.4 What is the relationship between capitalism and the ecological
crisis?](secD4.md "Go to previous page") [up](secDcon.md "Go to parent
page") [D.6 Are anarchists against Nationalism? ›](secD6.md "Go to next
page")

