//
// This file is part of the aMule AdunanzA Project (mod of official aMule)
//
// Copyright (c) 2003-2008 aMule AdunanzA Team ( http://www.adunanza.net )
//
// Any parts of this program derived from the xMule, lMule, eMule or aMule project,
// or contributed by third-party developers are copyrighted by their
// respective authors.
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301, USA
//


#include <protocol/kad/Constants.h>
#include <protocol/Protocols.h>
#include "KADUSettings.h"

void CKADUSettings::assign(
		long          kadRepublishTimeK,
		long          kadRepublishTimeS,
		long          kadRepublishTimeN,

		long          kadIndexLifeK,
		long          kadIndexLifeS,

		uint32_t      kadTotalStoreKey,
		uint32_t      kadTotalStoreSrc,
		uint32_t      kadTotalStoreNotes,

		long          kadTotalSearchFile,

		long          kadMaxSrcFile,
		long          kadMaxNotFile,

		double        kadFreshGuess_Tol,
		double        kadFreshGuess_Weight,
		long          kadFreshGuess_NoNorm,
		long          kadFreshGuess_LowNorm,

		long          kadFindValue,
		long          kadStore,
		long          kadFindNode,

		long          kadReaskTime,
		long          kadPubTime,

		long          kadReaskIncs,

		long          mVer,

		unsigned char kadOpcode,
		unsigned char kadZOpcode
	   )
{
	m_kadRepublishTimeK = kadRepublishTimeK;
	m_kadRepublishTimeS = kadRepublishTimeS;
	m_kadRepublishTimeN = kadRepublishTimeN;

	m_kadIndexLifeK = kadIndexLifeK;
	m_kadIndexLifeS = kadIndexLifeS;

	m_kadTotalStoreKey   = kadTotalStoreKey;
	m_kadTotalStoreSrc   = kadTotalStoreSrc;
	m_kadTotalStoreNotes = kadTotalStoreNotes;

	m_kadTotalSearchFile = kadTotalSearchFile;

	m_kadMaxSrcFile = kadMaxSrcFile;
	m_kadMaxNotFile = kadMaxNotFile;

	m_kadFreshGuess_Tol     = kadFreshGuess_Tol;
	m_kadFreshGuess_Weight  = kadFreshGuess_Weight;
	m_kadFreshGuess_NoNorm  = kadFreshGuess_NoNorm;
	m_kadFreshGuess_LowNorm = kadFreshGuess_LowNorm;

	// ATTENZIONE:
	// se per scaricare il file delle impostazioni remote si una una stringa di User-Agent NON riconosciuta dal server,
	// quest'ultimo restituira' un file contenente valori non validi, ad esempio le tre segg. avranno valore 0 per cui KAdu non potra'
	// funzionare correttamente.
	// Sintomo classico di questo caso: le ricerche KAdu falliscono sempre
	m_kadFindValue = kadFindValue;
	m_kadStore     = kadStore;
	m_kadFindNode  = kadFindNode;

	m_kadReaskTime = kadReaskTime;
	m_kadPubTime    = kadPubTime;

	m_kadReaskIncs = kadReaskIncs;
	m_mVer = mVer ;

	m_kadOpcode = kadOpcode;
	m_kadZOpcode = kadZOpcode;
}


CKADUSettings::CKADUSettings() // questo mi sa che prima o poi lo tolgo...
{
	m_kadRepublishTimeK = 18000; // KADEMLIAREPUBLISHTIMEK;
	m_kadRepublishTimeS = 18000; // KADEMLIAREPUBLISHTIMES;
	m_kadRepublishTimeN = 86400; // KADEMLIAREPUBLISHTIMEN;

	m_kadIndexLifeK = 345600; // HR2S(96);
	m_kadIndexLifeS = 345600; // HR2S(96);

	m_kadTotalStoreKey   =  8; // KADEMLIATOTALSTOREKEY;
	m_kadTotalStoreSrc   = 12; // KADEMLIATOTALSTORESRC;
	m_kadTotalStoreNotes =  1; // KADEMLIATOTALSTORENOTES;

	m_kadTotalSearchFile = 15; // KADEMLIATOTALFILE;

	m_kadMaxSrcFile = 300; // KADEMLIAMAXSOURCEPERFILE;
	m_kadMaxNotFile =  50; // KADEMLIAMAXNOTESPERFILE;

	m_kadFreshGuess_Tol     = 3996; // KADEMLIAFRESHGUESS_TOLERANCE;
	m_kadFreshGuess_Weight  = 7999; // KADEMLIAFRESHGUESS_WEIGHT;
	m_kadFreshGuess_NoNorm  = 8; // KADEMLIAFRESHGUESS_NONORMSOURCES;
	m_kadFreshGuess_LowNorm = 16; // KADEMLIAFRESHGUESS_LOWNORMSOURCES;

	m_kadFindValue = 8; // KADEMLIA_FIND_VALUE / KADEMLIA_FIND_VALUE_MORE (hanno lo stesso valore!);
	m_kadStore     = 6; // KADEMLIA_STORE;
	m_kadFindNode  = 56; // KADEMLIA_FIND_NODE;

	m_kadReaskTime = 600000; // KADEMLIAREASKTIME;
	m_kadPubTime    = 2; // KADEMLIAPUBLISHTIME;

	m_kadReaskIncs = 3; // 7;
	m_mVer = 0;

	m_kadOpcode = 164; // OP_KADEMLIAHEADER;
	m_kadZOpcode = 165; // OP_KADEMLIAPACKEDPROT;
}

