#ifndef MAINWINDOW_HPP
#define MAINWINDOW_HPP

/*
    Copyright (c) 2008-12 Qtrac Ltd. All rights reserved.
    This program or module is free software: you can redistribute it
    and/or modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation, either version 2 of
    the License, or version 3 of the License, or (at your option) any
    later version. This program is distributed in the hope that it will
    be useful, but WITHOUT ANY WARRANTY; without even the implied
    warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
    See the GNU General Public License for more details.
*/

#include <QMainWindow>

class QPushButton;
class QSplitter;
class QTextBrowser;
class QTextEdit;


class MainWindow : public QMainWindow
{
    Q_OBJECT

public:
    explicit MainWindow(QWidget *parent=0);

protected:
    void closeEvent(QCloseEvent *event);

private slots:
    void setOptions();
    void calculate();
    void copy();
    void new_();
    void load();
    void save();
    void saveAs();
    void help();
    void about();
    void afterCreation();

private:
    void loadFile(const QString &new_filename);
    QString highlightUnused(const QStringList &list_of_strings);

    QTextEdit *inputText;
    QTextBrowser *outputText;
    QTextBrowser *logText;
    QSplitter *splitter;
    QPushButton *calculateButton;
    QDialog *helpDialog;

    QString filename;
    QString alphabet;
    bool prompt_to_save_on_exit;
    bool restore_workspace_at_startup;
    bool load_last_file_at_startup;
    QStringList predefined_accelerators;
};

#endif // MAINWINDOW_HPP
