#include <Alib.h>

/*
 *  ForceWindowRedraw :  Invalidate the previous frame's drawing information
 *                       so that the animation is completely redrawn at the
 *                       completion of the current frame.
 */

void
ForceWindowRedraw(AWindow * w)
{

	register int i;

	if (!w) {
	  return;
	}

	for (i = 0; i < w->height; ++i) {
		w->lastScanLine[i].count = 0;
		if (w->doubleBuffered) {
			w->otherLastScanLine[i].count = 0;
		}
	}

#if defined(HAS_FRAME_BUFFER) && defined(X11)
	LocateWindowOrigin(w->display, w->d, &x, &y);
	FrameBufferSetOrigin(x, y);
#endif
}
