!{\src2tex{textfont=tt}}
!!****f* ABINIT/initrhoij
!! NAME
!! initrhoij
!!
!! FUNCTION
!! Initialize PAW rhoij occupancies (in packed storage)
!! from atomic ones
!!
!! COPYRIGHT
!! Copyright (C) 1998-2007 ABINIT group (MT)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt.
!!
!! INPUTS
!!  indlmn(6,i,ntypat)= array giving l,m,n,lm,ln,s for i=lmn
!!  lmnmax=max number of (l,m,n) comp. over all type of psps
!!  lpawu(ntypat)=l on which U is applied for a given type of atom (PAW+U only)
!!  natom=number of atoms
!!  nspden=number of spin-density components
!!  nsppol=1 for unpolarized, 2 for spin-polarized
!!  ntypat=number of atom types
!!  pawtab(ntypat) <type(pawtab_type)>=paw tabulated starting data
!!                                     (containing initial rhoij)
!!  spinat(3,natom)=initial spin of each atom, in unit of hbar/2.
!!  typat(natom)=type of each atom
!!
!! OUTPUT
!!  pawrhoij(natom) <type(pawrhoij_type)>=rhoij quantities for each atom
!!                                        in packed storage
!!
!! PARENTS
!!      gstate
!!
!! CHILDREN
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine initrhoij(indlmn,lmnmax,lpawu,natom,nspden,nsppol,ntypat,pawrhoij,pawtab,spinat,typat)

 use defs_basis
 use defs_datatypes

 implicit none

!Arguments ---------------------------------------------
!scalars
 integer,intent(in) :: lmnmax,natom,nspden,nsppol,ntypat
!arrays
 integer,intent(in) :: indlmn(6,lmnmax,ntypat),lpawu(ntypat),typat(natom)
 real(dp),intent(in) :: spinat(3,natom)
 type(pawrhoij_type),intent(out) :: pawrhoij(natom)
 type(pawtab_type),intent(in) :: pawtab(ntypat)

!Local variables ---------------------------------------
!scalars
 integer :: iatom,ilmn,ispden,itypat,j0lmn,jl,jlmn,klmn,nselect
 real(dp) :: ratio,ro,zratio,zshift,zz

!************************************************************************

 ratio=one;if (nspden==2) ratio=half

 do iatom=1,natom
  itypat=typat(iatom)

  pawrhoij(iatom)%nspden=nspden
  pawrhoij(iatom)%nsppol=nsppol
  pawrhoij(iatom)%lmn_size=pawtab(itypat)%lmn_size
  pawrhoij(iatom)%lmn2_size=pawtab(itypat)%lmn2_size
  allocate(pawrhoij(iatom)%nrhoijsel(nspden))
  allocate(pawrhoij(iatom)%rhoijp(pawtab(itypat)%lmn2_size,nspden))
  allocate(pawrhoij(iatom)%rhoijselect(pawtab(itypat)%lmn2_size,nspden))

! Determine Z (trace of rhoij0 or part of it)
  zz=zero
  do jlmn=1,pawtab(itypat)%lmn_size
   jl=indlmn(1,jlmn,itypat)
   j0lmn=jlmn*(jlmn-1)/2
   do ilmn=1,jlmn
    klmn=j0lmn+ilmn
    if ((ilmn==jlmn).and.(lpawu(itypat)==-1.or.lpawu(itypat)==jl)) &
&    zz=zz+pawtab(itypat)%rhoij0(klmn)
   end do
  end do

  do ispden=1,nspden

   ratio=1.d0/dble(nspden)
   zratio=zero
   if (nspden>1.and.&
&      ((spinat(3,iatom)>zero.and.ispden==1).or.&
&       (spinat(3,iatom)<zero.and.ispden==2))) &
&       zratio=abs(spinat(3,iatom))/zz

   nselect=0
   do jlmn=1,pawtab(itypat)%lmn_size
    jl=indlmn(1,jlmn,itypat)
    j0lmn=jlmn*(jlmn-1)/2
    do ilmn=1,jlmn
     klmn=j0lmn+ilmn
     ro=pawtab(itypat)%rhoij0(klmn)
     if ((ilmn==jlmn).and.(lpawu(itypat)==-1.or.lpawu(itypat)==jl)) then
      ro=ro*(ratio+zratio)
     else
      ro=ro*ratio
     end if
     if (abs(ro)>tol10) then
      nselect=nselect+1
      pawrhoij(iatom)%rhoijselect(nselect,ispden)=klmn
      pawrhoij(iatom)%rhoijp(nselect,ispden)=ro
     end if
    end do
   end do

   pawrhoij(iatom)%nrhoijsel(ispden)=nselect
  end do

 end do ! iatom

end subroutine initrhoij
!!***
