**==spmpar.f    processed by SPAG 4.03F  at 14:31 on 28 Jul 1994
      DOUBLE PRECISION FUNCTION spmpar(I)
      IMPLICIT NONE
C-----------------------------------------------------------------------
C
C     SPMPAR PROVIDES THE SINGLE PRECISION MACHINE CONSTANTS FOR
C     THE COMPUTER BEING USED. IT IS ASSUMED THAT THE ARGUMENT
C     I IS AN INTEGER HAVING ONE OF THE VALUES 1, 2, OR 3. IF THE
C     SINGLE PRECISION ARITHMETIC BEING USED HAS M BASE B DIGITS AND
C     ITS SMALLEST AND LARGEST EXPONENTS ARE EMIN AND EMAX, THEN
C
C        SPMPAR(1) = B**(1 - M), THE MACHINE PRECISION,
C
C        SPMPAR(2) = B**(EMIN - 1), THE SMALLEST MAGNITUDE,
C
C        SPMPAR(3) = B**EMAX*(1 - B**(-M)), THE LARGEST MAGNITUDE.
C
C-----------------------------------------------------------------------
C     WRITTEN BY
C        ALFRED H. MORRIS, JR.
C        NAVAL SURFACE WARFARE CENTER
C        DAHLGREN VIRGINIA
C-----------------------------------------------------------------------
C-----------------------------------------------------------------------
C     MODIFIED BY BARRY W. BROWN TO RETURN DOUBLE PRECISION MACHINE
C     CONSTANTS FOR THE COMPUTER BEING USED.  THIS MODIFICATION WAS
C     MADE AS PART OF CONVERTING BRATIO TO DOUBLE PRECISION
C-----------------------------------------------------------------------
C     .. Scalar Arguments ..
      INTEGER I
C     ..
C     .. Local Scalars ..
      DOUBLE PRECISION b,binv,bm1,one,w,z
      INTEGER emax,emin,ibeta,m
C     ..
C     .. External Functions ..
      INTEGER ipmpar
      EXTERNAL ipmpar
C     ..
C     .. Intrinsic Functions ..
      INTRINSIC dble
C     ..
C     .. Executable Statements ..
C
      IF(I.le.1)THEN
       b=ipmpar(4)
       m=ipmpar(8)
       spmpar=b**(1-m)
       RETURN
C
      ELSE IF(I.le.2)THEN
       b=ipmpar(4)
       emin=ipmpar(9)
       one=dble(1)
       binv=one/b
       w=b**(emin+2)
       spmpar=((w*binv)*binv)*binv
       RETURN
      END IF
C
      ibeta=ipmpar(4)
      m=ipmpar(8)
      emax=ipmpar(10)
C
      b=ibeta
      bm1=ibeta-1
      one=dble(1)
      z=b**(m-1)
      w=((z-one)*b+bm1)/(b*z)
C
      z=b**(emax-2)
      spmpar=((w*z)*b)*b
      RETURN
 
      END
