/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.drda;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.apache.derby.impl.drda.DDMReader;
import org.apache.derby.impl.drda.DRDAProtocolException;
import org.apache.derby.impl.drda.EXTDTAReaderInputStream;

final class StandardEXTDTAReaderInputStream
extends EXTDTAReaderInputStream {
    private final long length;
    private final DDMReader reader;
    private long remainingBytes;
    private ByteArrayInputStream currentBuffer;

    StandardEXTDTAReaderInputStream(DDMReader dDMReader) throws DRDAProtocolException {
        this.reader = dDMReader;
        this.remainingBytes = this.length = dDMReader.getDdmLength();
        this.currentBuffer = dDMReader.readLOBInitStream(this.remainingBytes);
    }

    public final int read() throws IOException {
        int n;
        if (this.remainingBytes <= 0L) {
            return -1;
        }
        int n2 = n = this.currentBuffer == null ? -1 : this.currentBuffer.read();
        if (n < 0) {
            n = this.refreshCurrentBuffer();
        }
        --this.remainingBytes;
        return n;
    }

    public final int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.remainingBytes <= 0L) {
            return -1;
        }
        int n3 = this.currentBuffer.read(byArray, n, n2);
        if (n3 < 0) {
            this.currentBuffer = this.reader.readLOBContinuationStream(this.remainingBytes);
            n3 = this.currentBuffer.read(byArray, n, n2);
        }
        this.remainingBytes -= (long)n3;
        return n3;
    }

    public final int available() {
        if (this.remainingBytes <= 0L) {
            return 0;
        }
        return this.currentBuffer.available();
    }

    final long getLength() {
        return this.length;
    }

    private int refreshCurrentBuffer() throws IOException {
        if (this.remainingBytes > 0L) {
            this.currentBuffer = this.reader.readLOBContinuationStream(this.remainingBytes);
            return this.currentBuffer.read();
        }
        return -1;
    }
}

