#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2024 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Doors: Paradox
# send your bug reports to contact@dotslashplay.it
###

script_version=20240927.1

PLAYIT_COMPATIBILITY_LEVEL='2.30'

GAME_ID='doors-paradox'
GAME_NAME='Doors: Paradox'

ARCHIVE_BASE_1_NAME='setup_doors_paradox_1.01_(65794).exe'
ARCHIVE_BASE_1_MD5='cdae131a2fb76a2c3cee4176acfb4b8f'
ARCHIVE_BASE_1_TYPE='innosetup'
ARCHIVE_BASE_1_PART1_NAME='setup_doors_paradox_1.01_(65794)-1.bin'
ARCHIVE_BASE_1_PART1_MD5='bf9609151ca9b9daa4517db4b3643fdc'
ARCHIVE_BASE_1_SIZE='4161487'
ARCHIVE_BASE_1_VERSION='1.01-gog65794'
ARCHIVE_BASE_1_URL='https://www.gog.com/game/doors_paradox'

UNITY3D_NAME='doors paradox'

CONTENT_PATH_DEFAULT='.'

WINE_PERSISTENT_DIRECTORIES='
users/${USER}/AppData/LocalLow/Big Loop Studios/Doors_ Paradox'

PACKAGES_LIST='
PKG_BIN
PKG_DATA'

PKG_BIN_ARCH='64'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers

launchers_generation 'PKG_BIN'

# Build packages

packages_generation
print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
