#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2018 Mopi
# SPDX-FileCopyrightText: © 2022 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Stories: The Path of Destinies
# send your bug reports to contact@dotslashplay.it
###

script_version=20230811.2

GAME_ID='stories-the-path-of-destinies'
GAME_NAME='Stories: The Path of Destinies'

ARCHIVE_BASE_1='setup_stories_the_path_of_destinies_update_4_(25956).exe'
ARCHIVE_BASE_1_MD5='61f632db33297ca2b178d4383545732c'
ARCHIVE_BASE_1_TYPE='innosetup'
ARCHIVE_BASE_1_VERSION='1.0-gog25956'
ARCHIVE_BASE_1_SIZE='2000000'
ARCHIVE_BASE_1_URL='https://www.gog.com/game/stories_the_path_of_destinies'

ARCHIVE_BASE_0='setup_stories_-_the_path_of_destinies_0.0.13825_(16929).exe'
ARCHIVE_BASE_0_MD5='6f81dbadddbb4b30b4edda9ced9ddef8'
ARCHIVE_BASE_0_TYPE='innosetup'
ARCHIVE_BASE_0_VERSION='0.0.13825-gog16929'
ARCHIVE_BASE_0_SIZE='1700000'

UNREALENGINE4_NAME='stories'

CONTENT_PATH_DEFAULT='.'
CONTENT_PATH_DEFAULT_0='app'
CONTENT_GAME_BIN_FILES="
engine
${UNREALENGINE4_NAME}/binaries
${UNREALENGINE4_NAME}/plugins
language_setup.exe
language_setup.ini
language_setup.png"
CONTENT_GAME_DATA_FILES="
${UNREALENGINE4_NAME}/content"

APP_WINETRICKS='vcrun2019'
WINE_DIRECT3D_RENDERER='dxvk'
WINE_PERSISTENT_DIRECTORIES="
users/\${USER}/AppData/Local/${UNREALENGINE4_NAME}/Saved"

APP_MAIN_EXE="${UNREALENGINE4_NAME}/binaries/win64/${UNREALENGINE4_NAME}.exe"
APP_MAIN_ICON_WRESTOOL_OPTIONS='--type=14 --name=101'

APP_LANGUAGE_ID="${GAME_ID}-language-selector"
APP_LANGUAGE_NAME="$GAME_NAME - Language Selector"
APP_LANGUAGE_CAT='Settings'
APP_LANGUAGE_EXE='language_setup.exe'
APP_LANGUAGE_ICON='language_setup.png'

PACKAGES_LIST='PKG_BIN PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN_ARCH='64'
PKG_BIN_DEPS="$PKG_DATA_ID"
PKG_BIN_DEPENDENCIES_GSTREAMER_PLUGINS='
video/quicktime, variant=(string)iso'

# Load common functions

target_version='2.24'

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction 'SOURCE_ARCHIVE'

# Include game icon

PKG='PKG_DATA'
icons_inclusion

# Include game data

content_inclusion_default

# Delete temporary files

rm --recursive "${PLAYIT_WORKDIR}/gamedata"

# Write launchers

PKG='PKG_BIN'
launchers_write

# Build packages

packages_generation

# Print instructions

print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
