#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2020 HS-157
# SPDX-FileCopyrightText: © 2023 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Art of Fighting 2
# send your bug reports to contact@dotslashplay.it
###

script_version=20231110.6

PLAYIT_COMPATIBILITY_LEVEL='2.27'

GAME_ID='art-of-fighting-2'
GAME_NAME='Art of Fighting 2'

## This game is no longer available for sale from Humble Store.
ARCHIVE_BASE_0_NAME='ArtOfFighting2_jan2016.sh'
ARCHIVE_BASE_0_MD5='f50a3d75ecea5a1fbbfde30cd876d674'
ARCHIVE_BASE_0_SIZE='44000'
ARCHIVE_BASE_0_VERSION='1.0-humble.2016.01'

CONTENT_PATH_DEFAULT='data'
CONTENT_LIBS_BIN_FILES='
libRocketControls.so.1
libRocketCore.so.1
libRocketDebugger.so.1'
## Using system-provided SDL2 instead of the shipped one, the game menu fails to render.
CONTENT_LIBS_BIN_FILES="${CONTENT_LIBS_BIN_FILES:-}
libSDL2-2.0.so.0"
CONTENT_LIBS_BIN32_PATH="${CONTENT_PATH_DEFAULT}/x86/lib"
CONTENT_LIBS_BIN32_FILES="$CONTENT_LIBS_BIN_FILES"
CONTENT_LIBS_BIN64_PATH="${CONTENT_PATH_DEFAULT}/x86_64/lib64"
CONTENT_LIBS_BIN64_FILES="$CONTENT_LIBS_BIN_FILES"
CONTENT_GAME_BIN32_PATH="${CONTENT_PATH_DEFAULT}/x86"
CONTENT_GAME_BIN32_FILES='
NeogeoEmu.bin.x86'
CONTENT_GAME_BIN64_PATH="${CONTENT_PATH_DEFAULT}/x86_64"
CONTENT_GAME_BIN64_FILES='
NeogeoEmu.bin.x86_64'
CONTENT_GAME_DATA_PATH="${CONTENT_PATH_DEFAULT}/noarch"
## TODO: Check if the shipped .ttf fonts could be replaced by system-provided ones.
CONTENT_GAME_DATA_FILES='
*.brm
*.dat
*.ini
*.png
*.rcss
*.rml
*.tga
*.ttf
*.txt
*.wav
*.xor
*.zip'

APP_MAIN_EXE_BIN32='NeogeoEmu.bin.x86'
APP_MAIN_EXE_BIN64='NeogeoEmu.bin.x86_64'
APP_MAIN_ICON='noarch/ArtOfFighting2.png'
## The shipped build of SDL2 has no support for the wayland backend.
APP_MAIN_PRERUN='# The shipped build of SDL2 has no support for the wayland backend
if [ "${SDL_VIDEODRIVER:-}" = "wayland" ]; then
	unset SDL_VIDEODRIVER
fi
'

USER_PERSISTENT_FILES='
*.ini
*.rml
*.txt'

PACKAGES_LIST='
PKG_BIN64
PKG_BIN32
PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN64_ARCH='64'
PKG_BIN32_ARCH='32'
PKG_BIN_DEPS="$PKG_DATA_ID"
PKG_BIN64_DEPS="$PKG_BIN_DEPS"
PKG_BIN32_DEPS="$PKG_BIN_DEPS"
PKG_BIN_DEPENDENCIES_LIBRARIES='
libc.so.6
libdl.so.2
libfreetype.so.6
libgcc_s.so.1
libm.so.6
libpthread.so.0
librt.so.1
libstdc++.so.6'
PKG_BIN64_DEPENDENCIES_LIBRARIES="$PKG_BIN_DEPENDENCIES_LIBRARIES"
PKG_BIN32_DEPENDENCIES_LIBRARIES="$PKG_BIN_DEPENDENCIES_LIBRARIES"

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction_default

# Include game data

set_current_package 'PKG_DATA'
icons_inclusion
content_inclusion_default

# Write launchers

set_current_package 'PKG_BIN64'
launchers_write
set_current_package 'PKG_BIN32'
launchers_write

# Build packages

packages_generation
print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
