#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2018 Mopi
# SPDX-FileCopyrightText: © 2022 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Alan Wake's American Nightmare
# build native packages from the original installers
# send your bug reports to contact@dotslashplay.it
###

script_version=20220701.1

GAME_ID='alan-wakes-american-nightmare'
GAME_NAME='Alan Wakeʼs American Nightmare'

ARCHIVE_BASE_0='setup_alan_wake_american_nightmare_2.1.0.24.exe'
ARCHIVE_BASE_0_MD5='dc500730b639a48897c00f5791e5b2f3'
ARCHIVE_BASE_0_TYPE='innosetup'
ARCHIVE_BASE_0_SIZE='2500000'
ARCHIVE_BASE_0_VERSION='1.0-gog2.1.0.24'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/alan_wakes_american_nightmare'

CONTENT_PATH_DEFAULT='app'
ARCHIVE_GAME_BIN_FILES='
*.dll
*.exe'
ARCHIVE_GAME_DATA_FILES='
data
shaders'

APP_MAIN_TYPE='wine'
APP_MAIN_EXE='alan_wakes_american_nightmare.exe'
APP_MAIN_ICON='alan_wakes_american_nightmare.exe'

PACKAGES_LIST='PKG_BIN PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN_ARCH='32'
PKG_BIN_DEPS="$PKG_DATA_ID wine"

# Apply d3dcompiler_43 winetricks verb

APP_WINETRICKS="$APP_WINETRICKS d3dcompiler_43"
PKG_BIN_DEPS="$PKG_BIN_DEPS winetricks"

# Grant required write access to some paths to the user

DATA_DIRS='./shaders'

# Load common functions

target_version='2.16'

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction 'SOURCE_ARCHIVE'
prepare_package_layout

# Delete temporary files

rm --recursive "${PLAYIT_WORKDIR}/gamedata"

# Include game icon

PKG='PKG_BIN'
icons_get_from_package 'APP_MAIN'
icons_move_to 'PKG_DATA'

# Write launchers

PKG='PKG_BIN'
launchers_write 'APP_MAIN'

# Build package

write_metadata
build_pkg

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

# Print instructions

print_instructions

exit 0
