#!/bin/bash

###############################################################################
# Linux Management Providers (LMP), Software Inventory provider package
# Copyright (C) 2009 Nazarov Nodir, TUIT <nazarov.nodir@gmail.com, nodir2000@yahoo.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
###############################################################################

if test "$3" = pegasus
then
	
	cimmof -aE -n $1 $6/mof/OpenDRIM_SystemSpecificSoftwareInventoryCollection.mof

	OUTFILE=./TEMP_REGISTRATION
	
cat >> $OUTFILE << EOFC
instance of PG_ProviderModule {
Caption = "OpenDRIM_SystemSpecificSoftwareInventoryCollection provider module";
Name = "SoftwareInventory_OpenDRIM_SystemSpecificSoftwareInventoryCollectionModule";
Location = "cmpiSoftwareInventory_OpenDRIM_SystemSpecificSoftwareInventoryCollectionProvider";
Vendor = "$2";
Version = "$5";
InterfaceType = "CMPI";
InterfaceVersion = "2.0.0";
};

instance of PG_Provider {
Caption = "OpenDRIM_SystemSpecificSoftwareInventoryCollection provider";
Name = "SoftwareInventory_OpenDRIM_SystemSpecificSoftwareInventoryCollectionProvider";
ProviderModuleName = "SoftwareInventory_OpenDRIM_SystemSpecificSoftwareInventoryCollectionModule";
};

instance of PG_ProviderCapabilities {
Caption = "OpenDRIM_SystemSpecificSoftwareInventoryCollection provider capabilities";
ProviderModuleName = "SoftwareInventory_OpenDRIM_SystemSpecificSoftwareInventoryCollectionModule";
ProviderName = "SoftwareInventory_OpenDRIM_SystemSpecificSoftwareInventoryCollectionProvider";
ClassName = "OpenDRIM_SystemSpecificSoftwareInventoryCollection";
ProviderType = {2};
Namespaces = {"$1"};
SupportedProperties = {"Caption", "Description", "ElementName", "InstanceID"};
CapabilityID = "SoftwareInventory_OpenDRIM_SystemSpecificSoftwareInventoryCollection";
};

EOFC
	
	cimmof -n root/PG_InterOp $OUTFILE
	
	rm -f $OUTFILE
	
fi

if test "$3" = sfcb
then
	
	OUTFILE=./OpenDRIM_SystemSpecificSoftwareInventoryCollection.reg
	
cat >> $OUTFILE <<EOFC
[OpenDRIM_SystemSpecificSoftwareInventoryCollection]   
   provider: SoftwareInventory_OpenDRIM_SystemSpecificSoftwareInventoryCollectionProvider
   location: cmpiSoftwareInventory_OpenDRIM_SystemSpecificSoftwareInventoryCollectionProvider
   type: instance
   namespace: $1
#
EOFC
	
	sfcbstage -r $OUTFILE -n $1 $6/mof/OpenDRIM_SystemSpecificSoftwareInventoryCollection.mof
	
	rm -f $OUTFILE
	
	sfcbrepos -f
	
fi

if test "$3" = openwbem
then
	
	OUTFILE=./OpenDRIM_SystemSpecificSoftwareInventoryCollection-reg.mof
	rm -f $OUTFILE
	sed "s/Provider *( *\"cmpi:/Provider(\"cmpi::/g" < $6/mof/OpenDRIM_SystemSpecificSoftwareInventoryCollection.mof >> $OUTFILE
	owmofc -u http://localhost/$1 $OUTFILE
	
	rm -f $OUTFILE
	
fi
