/*###############################################################################
# Linux Management Providers (LMP), Software Inventory provider package
# Copyright (C) 2009 Nazarov Nodir, TUIT <nazarov.nodir@gmail.com, nodir2000@yahoo.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
###############################################################################*/

#include "cmpiOpenDRIM_InstalledSoftwareIdentity.h"
#include "OpenDRIM_InstalledSoftwareIdentityAccess.h"

static const CMPIBroker * _broker;

#ifdef CMPI_VER_100
#define SoftwareInventory_OpenDRIM_InstalledSoftwareIdentityProviderSetInstance SoftwareInventory_OpenDRIM_InstalledSoftwareIdentityProviderModifyInstance
#endif

int SoftwareInventory_OpenDRIM_InstalledSoftwareIdentity_init(const CMPIBroker* broker);

int SoftwareInventory_OpenDRIM_InstalledSoftwareIdentity_finalize();

/* ---------------------------------------------------------------------------*/
/*                      Instance Provider Interface                           */
/* ---------------------------------------------------------------------------*/

CMPIStatus SoftwareInventory_OpenDRIM_InstalledSoftwareIdentityProviderCleanup(CMPIInstanceMI * mi, const CMPIContext* ctx, CMPIBoolean terminate) {
	_E_;
	int errorCode = SoftwareInventory_OpenDRIM_InstalledSoftwareIdentity_finalize();
	CMPIStatus rc;
	CMSetStatus(&rc, (CMPIrc) errorCode);
	_L_;
	return rc;
}

CMPIStatus SoftwareInventory_OpenDRIM_InstalledSoftwareIdentityProviderEnumInstanceNames(CMPIInstanceMI* mi, const CMPIContext* ctx, const CMPIResult* rslt, const CMPIObjectPath* ref) {
	_E_;
	CMPIStatus rc = {CMPI_RC_OK, NULL};
	vector<OpenDRIM_InstalledSoftwareIdentity> instances;
	string errorMessage;
	
	int errorCode = SoftwareInventory_OpenDRIM_InstalledSoftwareIdentity_retrieve(_broker, ctx, instances, NULL, errorMessage, "ein");
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_InstalledSoftwareIdentity_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	for (size_t i=0; i < instances.size(); i++) {
		CMPIObjectPath* op = SoftwareInventory_OpenDRIM_InstalledSoftwareIdentity_toCMPIObjectPath(_broker, instances[i]);
		CMReturnObjectPath(rslt, op);
	}
	CMReturnDone(rslt);
	_L_;
	return rc;
}

CMPIStatus SoftwareInventory_OpenDRIM_InstalledSoftwareIdentityProviderEnumInstances(CMPIInstanceMI* mi, const CMPIContext* ctx, const CMPIResult* rslt, const CMPIObjectPath* ref, const char** properties) {
	_E_;
	CMPIStatus rc = {CMPI_RC_OK, NULL};
	vector<OpenDRIM_InstalledSoftwareIdentity> instances;
	string errorMessage;
	
	int errorCode = SoftwareInventory_OpenDRIM_InstalledSoftwareIdentity_retrieve(_broker, ctx, instances, properties, errorMessage, "ei");
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_InstalledSoftwareIdentity_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	for (size_t i=0; i < instances.size(); i++) {
		CMPIInstance* ci = SoftwareInventory_OpenDRIM_InstalledSoftwareIdentity_toCMPIInstance(_broker, instances[i]);
		CMReturnInstance(rslt, ci);
	}
	CMReturnDone(rslt);
	_L_;
	return rc;
}

CMPIStatus SoftwareInventory_OpenDRIM_InstalledSoftwareIdentityProviderGetInstance(CMPIInstanceMI* mi, const CMPIContext* ctx, const CMPIResult* rslt, const CMPIObjectPath* cop, const char** properties) {
	_E_;
	CMPIStatus rc = {CMPI_RC_OK, NULL};
	OpenDRIM_InstalledSoftwareIdentity instance;
	SoftwareInventory_OpenDRIM_InstalledSoftwareIdentity_toCPP(_broker, cop, instance);
	string errorMessage;
	
	int errorCode = SoftwareInventory_OpenDRIM_InstalledSoftwareIdentity_getInstance(_broker, ctx, instance, properties, errorMessage);
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_InstalledSoftwareIdentity_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	CMPIInstance* ci = SoftwareInventory_OpenDRIM_InstalledSoftwareIdentity_toCMPIInstance(_broker, instance);
	CMReturnInstance(rslt, ci);
	CMReturnDone(rslt);
	_L_;
	return rc;
}

CMPIStatus SoftwareInventory_OpenDRIM_InstalledSoftwareIdentityProviderSetInstance(CMPIInstanceMI* mi, const CMPIContext* ctx, const CMPIResult* rslt, const CMPIObjectPath* cop, const CMPIInstance* ci, const char** properties) {
	_E_;
	CMPIStatus rc = {CMPI_RC_OK, NULL};
	OpenDRIM_InstalledSoftwareIdentity newInstance, oldInstance;
	SoftwareInventory_OpenDRIM_InstalledSoftwareIdentity_toCPP(_broker, ci, newInstance);
	SoftwareInventory_OpenDRIM_InstalledSoftwareIdentity_toCPP(_broker, cop, oldInstance);
	string errorMessage;
	
	int errorCode = SoftwareInventory_OpenDRIM_InstalledSoftwareIdentity_getInstance(_broker, ctx, oldInstance, properties, errorMessage);
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_InstalledSoftwareIdentity_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	errorCode = SoftwareInventory_OpenDRIM_InstalledSoftwareIdentity_setInstance(_broker, ctx, newInstance, oldInstance, properties, errorMessage);
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_InstalledSoftwareIdentity_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	CMReturnDone(rslt);
	_L_;
	return rc;
}

CMPIStatus SoftwareInventory_OpenDRIM_InstalledSoftwareIdentityProviderCreateInstance(CMPIInstanceMI* mi, const CMPIContext* ctx, const CMPIResult* rslt, const CMPIObjectPath* cop, const CMPIInstance* ci) {
	_E_;
	CMPIStatus rc = {CMPI_RC_OK, NULL};
	OpenDRIM_InstalledSoftwareIdentity instance;
	SoftwareInventory_OpenDRIM_InstalledSoftwareIdentity_toCPP(_broker, ci, instance);
	string errorMessage;
	
	int errorCode = SoftwareInventory_OpenDRIM_InstalledSoftwareIdentity_getInstance(_broker, ctx, instance, NULL, errorMessage);
	if (errorCode != NOT_FOUND) {
		if (errorCode == OK)
			errorCode = ALREADY_EXISTS;
		errorMessage = (string) OpenDRIM_InstalledSoftwareIdentity_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	errorCode = SoftwareInventory_OpenDRIM_InstalledSoftwareIdentity_createInstance(_broker, ctx, instance, errorMessage);
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_InstalledSoftwareIdentity_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	errorCode = SoftwareInventory_OpenDRIM_InstalledSoftwareIdentity_getInstance(_broker, ctx, instance, NULL, errorMessage);
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_InstalledSoftwareIdentity_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	CMPIObjectPath* _cop = SoftwareInventory_OpenDRIM_InstalledSoftwareIdentity_toCMPIObjectPath(_broker, instance);
	CMReturnObjectPath(rslt, _cop);
	CMReturnDone(rslt);
	_L_;
	return rc;
}

CMPIStatus SoftwareInventory_OpenDRIM_InstalledSoftwareIdentityProviderDeleteInstance(CMPIInstanceMI* mi, const CMPIContext* ctx, const CMPIResult* rslt, const CMPIObjectPath* cop) {
	_E_;
	CMPIStatus rc = {CMPI_RC_OK, NULL};
	OpenDRIM_InstalledSoftwareIdentity instance;
	SoftwareInventory_OpenDRIM_InstalledSoftwareIdentity_toCPP(_broker, cop, instance);
	string errorMessage;
	
	int errorCode = SoftwareInventory_OpenDRIM_InstalledSoftwareIdentity_getInstance(_broker, ctx, instance, NULL, errorMessage);
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_InstalledSoftwareIdentity_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	errorCode = SoftwareInventory_OpenDRIM_InstalledSoftwareIdentity_deleteInstance(_broker, ctx, instance, errorMessage);
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_InstalledSoftwareIdentity_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	CMReturnDone(rslt);
	_L_;
	return rc;
}

CMPIStatus SoftwareInventory_OpenDRIM_InstalledSoftwareIdentityProviderExecQuery(CMPIInstanceMI* mi, const CMPIContext* ctx, const CMPIResult* rslt, const CMPIObjectPath* ref, const char* lang, const char* query) {
	_E_;
	CMReturn(CMPI_RC_ERR_NOT_SUPPORTED);
}

/* ---------------------------------------------------------------------------*/
/*                   End of Instance Provider Interface                       */
/* ---------------------------------------------------------------------------*/

/* ---------------------------------------------------------------------------*/
/*                     Association Provider Interface                         */
/* ---------------------------------------------------------------------------*/

CMPIStatus SoftwareInventory_OpenDRIM_InstalledSoftwareIdentityProviderAssociationCleanup(CMPIAssociationMI * mi, const CMPIContext* ctx, CMPIBoolean terminate) {
	_E_;
	int errorCode = SoftwareInventory_OpenDRIM_InstalledSoftwareIdentity_finalize();
	CMPIStatus rc;
	CMSetStatus(&rc, (CMPIrc) errorCode);
	_L_;
	return rc;
}

CMPIStatus SoftwareInventory_OpenDRIM_InstalledSoftwareIdentityProviderAssociatorNames(CMPIAssociationMI* mi, const CMPIContext* ctx, const CMPIResult* rslt, const CMPIObjectPath* cop, const char* assocClass, const char* resultClass, const char* role, const char* resultRole) {
	_E_;
	CMPIStatus rc = {CMPI_RC_OK, NULL};
	
	string errorMessage;
	bool leftToRight;
	vector<Instance> associatedInstances;
	Instance known;
	int errorCode = SoftwareInventory_OpenDRIM_InstalledSoftwareIdentity_associator(_broker, ctx, cop, known, assocClass, resultClass, role, resultRole, NULL, associatedInstances, leftToRight, errorMessage, "an");
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_InstalledSoftwareIdentity_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	
	for (size_t i=0; i < associatedInstances.size(); i++)
		CMReturnObjectPath(rslt, associatedInstances[i].getObjectpath().getHdl());
	CMReturnDone(rslt);
	_L_;
	return rc;
}

CMPIStatus SoftwareInventory_OpenDRIM_InstalledSoftwareIdentityProviderAssociators(CMPIAssociationMI* mi, const CMPIContext* ctx, const CMPIResult* rslt, const CMPIObjectPath* cop, const char* assocClass, const char* resultClass, const char* role, const char* resultRole, const char** properties) {
	_E_;
	CMPIStatus rc = {CMPI_RC_OK, NULL};
	
	string errorMessage;
	bool leftToRight;
	vector<Instance> associatedInstances;
	Instance known;
	int errorCode = SoftwareInventory_OpenDRIM_InstalledSoftwareIdentity_associator(_broker, ctx, cop, known, assocClass, resultClass, role, resultRole, properties, associatedInstances, leftToRight, errorMessage, "a");
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_InstalledSoftwareIdentity_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	
	for (size_t i=0; i < associatedInstances.size(); i++)
		CMReturnInstance(rslt, associatedInstances[i].getHdl());
	CMReturnDone(rslt);
	_L_;
	return rc;
}

CMPIStatus SoftwareInventory_OpenDRIM_InstalledSoftwareIdentityProviderReferenceNames(CMPIAssociationMI* mi, const CMPIContext* ctx, const CMPIResult* rslt, const CMPIObjectPath* cop, const char* assocClass, const char* role) {
	_E_;
	CMPIStatus rc = {CMPI_RC_OK, NULL};
	
	string errorMessage;
	bool leftToRight;
	vector<Instance> associatedInstances;
	Instance known;
	int errorCode = SoftwareInventory_OpenDRIM_InstalledSoftwareIdentity_associator(_broker, ctx, cop, known, assocClass, NULL, role, NULL, NULL, associatedInstances, leftToRight, errorMessage, "an");
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_InstalledSoftwareIdentity_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	
	vector<OpenDRIM_InstalledSoftwareIdentity> associationInstances;
	if (leftToRight)
		errorCode = SoftwareInventory_OpenDRIM_InstalledSoftwareIdentity_referenceSystemToInstalledSoftware(_broker, ctx, known, associatedInstances, associationInstances, NULL, errorMessage, "rn");
	else
		errorCode = SoftwareInventory_OpenDRIM_InstalledSoftwareIdentity_referenceInstalledSoftwareToSystem(_broker, ctx, known, associatedInstances, associationInstances, NULL, errorMessage, "rn");
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_InstalledSoftwareIdentity_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	
	for (size_t i=0; i < associationInstances.size(); i++) {
		CMPIObjectPath* op = SoftwareInventory_OpenDRIM_InstalledSoftwareIdentity_toCMPIObjectPath(_broker, associationInstances[i]);
		CMReturnObjectPath(rslt, op);
	}
	_L_;
	return rc;
}

CMPIStatus SoftwareInventory_OpenDRIM_InstalledSoftwareIdentityProviderReferences(CMPIAssociationMI* mi, const CMPIContext* ctx, const CMPIResult* rslt, const CMPIObjectPath* cop, const char* assocClass, const char* role, const char** properties) {
	_E_;
	CMPIStatus rc = {CMPI_RC_OK, NULL};
	
	string errorMessage;
	bool leftToRight;
	vector<Instance> associatedInstances;
	Instance known;
	int errorCode = SoftwareInventory_OpenDRIM_InstalledSoftwareIdentity_associator(_broker, ctx, cop, known, assocClass, NULL, role, NULL, NULL, associatedInstances, leftToRight, errorMessage, "an");
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_InstalledSoftwareIdentity_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	
	vector<OpenDRIM_InstalledSoftwareIdentity> associationInstances;
	if (leftToRight)
		errorCode = SoftwareInventory_OpenDRIM_InstalledSoftwareIdentity_referenceSystemToInstalledSoftware(_broker, ctx, known, associatedInstances, associationInstances, properties, errorMessage, "r");
	else
		errorCode = SoftwareInventory_OpenDRIM_InstalledSoftwareIdentity_referenceInstalledSoftwareToSystem(_broker, ctx, known, associatedInstances, associationInstances, properties, errorMessage, "r");
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_InstalledSoftwareIdentity_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	
	for (size_t i=0; i < associationInstances.size(); i++) {
		CMPIInstance* inst = SoftwareInventory_OpenDRIM_InstalledSoftwareIdentity_toCMPIInstance(_broker, associationInstances[i]);
		CMReturnInstance(rslt, inst);
	}
	_L_;
	return rc;
}

/* ---------------------------------------------------------------------------*/
/*                  End Of Association Provider Interface                     */
/* ---------------------------------------------------------------------------*/

/* ---------------------------------------------------------------------------*/
/*                              Provider Factory                              */
/* ---------------------------------------------------------------------------*/

int SoftwareInventory_OpenDRIM_InstalledSoftwareIdentity_init(const CMPIBroker* broker) {
	_E_;
	_broker = broker;
	static bool initialized = false;
	if (!initialized) {
		string errorMessage;
		int errorCode = SoftwareInventory_OpenDRIM_InstalledSoftwareIdentity_load(broker, errorMessage);
		if (errorCode != OK) {
			errorMessage += "SoftwareInventory_OpenDRIM_InstalledSoftwareIdentity_init FAILED: " + (string) OpenDRIM_InstalledSoftwareIdentity_classnames[0] + ": " + errorMessage;
			string cmd = "/bin/echo \"" + errorMessage + "\" >> cmpi_prov_debug.txt";
			system(cmd.c_str());
			return -1;
		}
		initialized = true;
	}
	_L_;
	return OK;
}

int SoftwareInventory_OpenDRIM_InstalledSoftwareIdentity_finalize() {
	_E_;
	static bool finalized = false;
	if (!finalized) {
		string errorMessage;
		int errorCode = SoftwareInventory_OpenDRIM_InstalledSoftwareIdentity_unload(errorMessage);
		if (errorCode != OK) {
			errorMessage += "SoftwareInventory_OpenDRIM_InstalledSoftwareIdentity_unload FAILED: " + (string) OpenDRIM_InstalledSoftwareIdentity_classnames[0] + ": " + errorMessage;
			string cmd = "/bin/echo \"" + errorMessage + "\" >> cmpi_prov_debug.txt";
			system(cmd.c_str());
			return errorCode;
		}
		finalized = true;
	}
	_L_;
	return OK;
}

#define SoftwareInventory_OpenDRIM_InstalledSoftwareIdentity_INIT if (SoftwareInventory_OpenDRIM_InstalledSoftwareIdentity_init(_broker) < 0) return NULL

CMInstanceMIStub(SoftwareInventory_OpenDRIM_InstalledSoftwareIdentityProvider, SoftwareInventory_OpenDRIM_InstalledSoftwareIdentityProvider, _broker, SoftwareInventory_OpenDRIM_InstalledSoftwareIdentity_INIT);
CMAssociationMIStub(SoftwareInventory_OpenDRIM_InstalledSoftwareIdentityProvider, SoftwareInventory_OpenDRIM_InstalledSoftwareIdentityProvider, _broker, SoftwareInventory_OpenDRIM_InstalledSoftwareIdentity_INIT);

/* ---------------------------------------------------------------------------*/
/*                          End of Provider Factory                           */
/* ---------------------------------------------------------------------------*/
