/*###############################################################################
# Linux Management Providers (LMP), Power Supply provider package
# Copyright (C) 2009 Shakhrom RUSTAMOV, TUIT <shahrombek@gmail.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by <Author(s)>, <Affiliation>, <Year>
###############################################################################*/

#ifndef OPENDRIM_POWERSUPPLYREDUNDANCYSET_H_
#define OPENDRIM_POWERSUPPLYREDUNDANCYSET_H_

#include <Instance.h>

const static char* OpenDRIM_PowerSupplyRedundancySet_classnames[] = {"OpenDRIM_PowerSupplyRedundancySet"};
static string OpenDRIM_PowerSupplyRedundancySet_NAMESPACE = _NAMESPACE;

class OpenDRIM_PowerSupplyRedundancySet {

public:
	
	string Caption;
	bool Caption_isNULL;
	
	string Description;
	bool Description_isNULL;
	
	string ElementName;
	bool ElementName_isNULL;
	
	string InstanceID;
	bool InstanceID_isNULL;
	
	unsigned short RedundancyStatus;
	bool RedundancyStatus_isNULL;
	
	vector<unsigned short> TypeOfSet;
	bool TypeOfSet_isNULL;
	
	unsigned int MinNumberNeeded;
	bool MinNumberNeeded_isNULL;
	
	unsigned int MaxNumberSupported;
	bool MaxNumberSupported_isNULL;
	
	string VendorIdentifyingInfo;
	bool VendorIdentifyingInfo_isNULL;
	
	vector<string> OtherTypeOfSet;
	bool OtherTypeOfSet_isNULL;
	
	unsigned short LoadBalanceAlgorithm;
	bool LoadBalanceAlgorithm_isNULL;
	
	string OtherLoadBalanceAlgorithm;
	bool OtherLoadBalanceAlgorithm_isNULL;
	
	OpenDRIM_PowerSupplyRedundancySet() {
		Caption_isNULL = true;
		Description_isNULL = true;
		ElementName_isNULL = true;
		InstanceID_isNULL = true;
		RedundancyStatus_isNULL = true;
		TypeOfSet_isNULL = true;
		MinNumberNeeded_isNULL = true;
		MaxNumberSupported_isNULL = true;
		VendorIdentifyingInfo_isNULL = true;
		OtherTypeOfSet_isNULL = true;
		LoadBalanceAlgorithm_isNULL = true;
		OtherLoadBalanceAlgorithm_isNULL = true;
	}
	
	~OpenDRIM_PowerSupplyRedundancySet() {}
	
	string getKeys() const {
		return CF_toLowCase(".InstanceID=\"" + CF_quoteString(InstanceID) + "\"");
	}

	int getCaption(string& value) const {
		if (Caption_isNULL==true)
			return NOT_FOUND;
		value = Caption;
		return OK;
	}
	
	int setCaption(const string& newValue) {
		Caption = newValue;
		Caption_isNULL = false;
		return OK;
	}

	int getDescription(string& value) const {
		if (Description_isNULL==true)
			return NOT_FOUND;
		value = Description;
		return OK;
	}
	
	int setDescription(const string& newValue) {
		Description = newValue;
		Description_isNULL = false;
		return OK;
	}

	int getElementName(string& value) const {
		if (ElementName_isNULL==true)
			return NOT_FOUND;
		value = ElementName;
		return OK;
	}
	
	int setElementName(const string& newValue) {
		ElementName = newValue;
		ElementName_isNULL = false;
		return OK;
	}

	int getInstanceID(string& value) const {
		if (InstanceID_isNULL==true)
			return NOT_FOUND;
		value = InstanceID;
		return OK;
	}
	
	int setInstanceID(const string& newValue) {
		InstanceID = newValue;
		InstanceID_isNULL = false;
		return OK;
	}

	int getRedundancyStatus(unsigned short& value) const {
		if (RedundancyStatus_isNULL==true)
			return NOT_FOUND;
		value = RedundancyStatus;
		return OK;
	}
	
	int setRedundancyStatus(const unsigned short& newValue) {
		RedundancyStatus = newValue;
		RedundancyStatus_isNULL = false;
		return OK;
	}

	int getTypeOfSet(vector<unsigned short>& value) const {
		if (TypeOfSet_isNULL==true)
			return NOT_FOUND;
		value = TypeOfSet;
		return OK;
	}
	
	int setTypeOfSet(const vector<unsigned short>& newValue) {
		TypeOfSet = newValue;
		TypeOfSet_isNULL = false;
		return OK;
	}

	int getMinNumberNeeded(unsigned int& value) const {
		if (MinNumberNeeded_isNULL==true)
			return NOT_FOUND;
		value = MinNumberNeeded;
		return OK;
	}
	
	int setMinNumberNeeded(const unsigned int& newValue) {
		MinNumberNeeded = newValue;
		MinNumberNeeded_isNULL = false;
		return OK;
	}

	int getMaxNumberSupported(unsigned int& value) const {
		if (MaxNumberSupported_isNULL==true)
			return NOT_FOUND;
		value = MaxNumberSupported;
		return OK;
	}
	
	int setMaxNumberSupported(const unsigned int& newValue) {
		MaxNumberSupported = newValue;
		MaxNumberSupported_isNULL = false;
		return OK;
	}

	int getVendorIdentifyingInfo(string& value) const {
		if (VendorIdentifyingInfo_isNULL==true)
			return NOT_FOUND;
		value = VendorIdentifyingInfo;
		return OK;
	}
	
	int setVendorIdentifyingInfo(const string& newValue) {
		VendorIdentifyingInfo = newValue;
		VendorIdentifyingInfo_isNULL = false;
		return OK;
	}

	int getOtherTypeOfSet(vector<string>& value) const {
		if (OtherTypeOfSet_isNULL==true)
			return NOT_FOUND;
		value = OtherTypeOfSet;
		return OK;
	}
	
	int setOtherTypeOfSet(const vector<string>& newValue) {
		OtherTypeOfSet = newValue;
		OtherTypeOfSet_isNULL = false;
		return OK;
	}

	int getLoadBalanceAlgorithm(unsigned short& value) const {
		if (LoadBalanceAlgorithm_isNULL==true)
			return NOT_FOUND;
		value = LoadBalanceAlgorithm;
		return OK;
	}
	
	int setLoadBalanceAlgorithm(const unsigned short& newValue) {
		LoadBalanceAlgorithm = newValue;
		LoadBalanceAlgorithm_isNULL = false;
		return OK;
	}

	int getOtherLoadBalanceAlgorithm(string& value) const {
		if (OtherLoadBalanceAlgorithm_isNULL==true)
			return NOT_FOUND;
		value = OtherLoadBalanceAlgorithm;
		return OK;
	}
	
	int setOtherLoadBalanceAlgorithm(const string& newValue) {
		OtherLoadBalanceAlgorithm = newValue;
		OtherLoadBalanceAlgorithm_isNULL = false;
		return OK;
	}

};

class OpenDRIM_PowerSupplyRedundancySet_Failover_In {

public:

	Objectpath FailoverFrom;
	bool FailoverFrom_isNULL;

	Objectpath FailoverTo;
	bool FailoverTo_isNULL;

	OpenDRIM_PowerSupplyRedundancySet_Failover_In() {
		FailoverFrom_isNULL = true;
		FailoverTo_isNULL = true;
	}

	~OpenDRIM_PowerSupplyRedundancySet_Failover_In() {}

	int getFailoverFrom(Objectpath& value) const {
		if (FailoverFrom_isNULL == true)
			return NOT_FOUND;
		value = FailoverFrom;
		return OK;
	}
	int setFailoverFrom(const Objectpath&  newValue) {
		FailoverFrom = newValue;
		FailoverFrom_isNULL = false;
		return OK;
	}

	int getFailoverTo(Objectpath& value) const {
		if (FailoverTo_isNULL == true)
			return NOT_FOUND;
		value = FailoverTo;
		return OK;
	}
	int setFailoverTo(const Objectpath&  newValue) {
		FailoverTo = newValue;
		FailoverTo_isNULL = false;
		return OK;
	}

};

#endif /*OPENDRIM_POWERSUPPLYREDUNDANCYSET_H_*/
