/*###############################################################################
# Linux Management Providers (LMP), BIOS provider package
# Copyright (C) 2010 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by <Author(s)>, <Affiliation>, <Year>
###############################################################################*/

#include "OpenDRIM_BIOSElementAccess.h"

vector<bios_information> bios;
vector< vector<string> > dmi_strings;

int BIOS_OpenDRIM_BIOSElement_load(const CMPIBroker* broker, string& errorMessage) {
	_E_;
	SMBIOS_getBIOSInformation(bios,dmi_strings,errorMessage);
	_L_;
	return OK;
}

int BIOS_OpenDRIM_BIOSElement_unload(string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return OK;
}

int BIOS_OpenDRIM_BIOSElement_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_BIOSElement>& result, const char** properties, string& errorMessage, const string& discriminant) {
	_E_;
	for(unsigned int i=0;i<bios.size();i++)
	{
		OpenDRIM_BIOSElement instance;
		char buffer[256];
		
		sprintf(buffer,"BIOS%u",i+1);
		
		instance.setName(buffer);
		instance.setVersion(dmi_strings[i][bios[i].bios_version]);
		instance.setSoftwareElementState(2); // Set to executable. BIOS is not running when OS is running (??)
		
		sprintf(buffer,"0x%X",bios[i].bios_starting);
		instance.setSoftwareElementID(buffer);
		
		// Not applicable. Usually most of the computers BIOS are not targetted for one Operating System.
		// FIXME: May need to be improved.
		instance.setTargetOperatingSystem(66);
		
		if (discriminant == "ei")
			CF_assert(BIOS_OpenDRIM_BIOSElement_populate(instance, i, errorMessage));
		
		result.push_back(instance);
	}
	
	_L_;
	return OK;
}

int BIOS_OpenDRIM_BIOSElement_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_BIOSElement& instance, const char** properties, string& errorMessage) {
	_E_;
	char buffer[256];
	unsigned int num=atoi(instance.Name.substr(4).c_str());
	
	num--;
	
	if(num >= 0 && num < bios.size())
		sprintf(buffer,"0x%X",bios[num].bios_starting);
	else
	{
		errorMessage="No instance";
		return NOT_FOUND;
	}
	
	if(instance.Name.substr(0,4) != "BIOS" ||
		 instance.Version != dmi_strings[num][bios[num].bios_version] ||
		 instance.SoftwareElementState != 2 ||
		 instance.SoftwareElementID != buffer ||
		 instance.TargetOperatingSystem != 66)
	{
		errorMessage="No instance";
		return NOT_FOUND;
	}
	
	CF_assert(BIOS_OpenDRIM_BIOSElement_populate(instance, num, errorMessage));
	_L_;
	return OK;
}

int BIOS_OpenDRIM_BIOSElement_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_BIOSElement& newInstance, const OpenDRIM_BIOSElement& oldInstance, const char** properties, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int BIOS_OpenDRIM_BIOSElement_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_BIOSElement& instance, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int BIOS_OpenDRIM_BIOSElement_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_BIOSElement& instance, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int BIOS_OpenDRIM_BIOSElement_populate(OpenDRIM_BIOSElement& instance, unsigned int num, string& errorMessage) {
	_E_;
	/*
	 * Properties to fill from profile
	 * + Mandatory:
	 * [X] Version                [KEY]
	 * [X] Name                   [KEY]
	 * [X] SoftwareElementState   [KEY]
	 * [X] SoftwareElementID      [KEY]
	 * [X] TargetOperatingSystem  [KEY]
	 * [X] Manufacturer
	 */
	
	instance.setManufacturer(dmi_strings[num][bios[num].vendor]);
	_L_;
	return OK;
}

