/*###############################################################################
# Linux Management Providers (LMP), BIOS provider package
# Copyright (C) 2010 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by <Author(s)>, <Affiliation>, <Year>
###############################################################################*/

#ifndef OPENDRIM_BIOSCONCRETEDEPENDENCY_H_
#define OPENDRIM_BIOSCONCRETEDEPENDENCY_H_

#include <Association.h>

// Direct Invocation includes, may have to be adjusted
/*
#include "cmpiCIM_ManagedElement.h"
#include "CIM_ManagedElementAccess.h"
#include "cmpiCIM_ManagedElement.h"
#include "CIM_ManagedElementAccess.h"
*/

const static char* OpenDRIM_BIOSConcreteDependency_classnames[] = {"OpenDRIM_BIOSConcreteDependency"};
static string OpenDRIM_BIOSConcreteDependency_NAMESPACE = _NAMESPACE;
const static string Antecedent_role = "Antecedent";
const static char* Antecedent_classnames[] = {"CIM_BIOSAttribute"};
const static string Antecedent_NAMESPACE = _NAMESPACE;

const static string Dependent_role = "Dependent";
const static char* Dependent_classnames[] = {"CIM_ManagedElement"};
const static string Dependent_NAMESPACE = _NAMESPACE;

class OpenDRIM_BIOSConcreteDependency {

public:
	
	Objectpath Antecedent;
	bool Antecedent_isNULL;
	
	Objectpath Dependent;
	bool Dependent_isNULL;
	
	OpenDRIM_BIOSConcreteDependency() {
		Antecedent_isNULL = true;
		Dependent_isNULL = true;
	}
	
	~OpenDRIM_BIOSConcreteDependency() {}
	
	string getKeys() const {
		return CF_toLowCase(".Antecedent=\"" + CF_quoteString(Antecedent.toString()) + "\""".Dependent=\"" + CF_quoteString(Dependent.toString()) + "\"");
	}

	int getAntecedent(Objectpath& value) const {
		if (Antecedent_isNULL==true)
			return NOT_FOUND;
		value = Antecedent;
		return OK;
	}
	
	int setAntecedent(const Objectpath& newValue) {
		Antecedent = newValue;
		Antecedent.setNamespace(Antecedent_NAMESPACE);
		Antecedent_isNULL = false;
		return OK;
	}

	int getDependent(Objectpath& value) const {
		if (Dependent_isNULL==true)
			return NOT_FOUND;
		value = Dependent;
		return OK;
	}
	
	int setDependent(const Objectpath& newValue) {
		Dependent = newValue;
		Dependent.setNamespace(Dependent_NAMESPACE);
		Dependent_isNULL = false;
		return OK;
	}

};

#endif /*OPENDRIM_BIOSCONCRETEDEPENDENCY_H_*/
