/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.index;

import com.ibm.icu.text.MessageFormat;
import com.nvidia.cuda.ide.index.CudaSdkHeadersLocationConverter;
import com.nvidia.cuda.ide.language.SMVersion;
import java.util.Collections;
import java.util.Map;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.index.IIndexLocationConverter;
import org.eclipse.cdt.core.index.export.AbstractExportProjectProvider;
import org.eclipse.cdt.core.index.export.Messages;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;

public class CudaExportProjectProvider
extends AbstractExportProjectProvider {
    private static final String OPT_SM_VERSION = "-sm";
    private SMVersion sm;

    static {
        System.setProperty("generatingIndex", Boolean.toString(true));
    }

    private ICProject createCCProject(final IPath location) throws CoreException {
        IWorkspace ws = ResourcesPlugin.getWorkspace();
        final ICProject[] newProject = new ICProject[1];
        ws.run(new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                IWorkspace workspace = ResourcesPlugin.getWorkspace();
                IProjectDescription description = workspace.loadProjectDescription(location.append(".project"));
                IProject project = workspace.getRoot().getProject(description.getName());
                if (!project.exists()) {
                    project.create(description, NPM);
                }
                if (!project.isOpen()) {
                    project.open((IProgressMonitor)new NullProgressMonitor());
                }
                newProject[0] = CCorePlugin.getDefault().getCoreModel().create(project);
            }
        }, null);
        return newProject[0];
    }

    public ICProject createProject() throws CoreException {
        Path source = new Path(this.getSingleString("-source"));
        if (source.isEmpty() || !source.toFile().exists()) {
            this.fail(MessageFormat.format((String)Messages.ExternalContentPEM_LocationToIndexNonExistent, (Object[])new Object[]{source}));
        }
        String smVersion = this.getSingleString(OPT_SM_VERSION);
        try {
            this.sm = SMVersion.valueOf((String)smVersion.trim().toLowerCase());
            SMVersion.setCurrent((SMVersion)this.sm);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.fail(String.format("SM version %s is not supported\n", smVersion));
        }
        return this.createCCProject((IPath)source);
    }

    public IIndexLocationConverter getLocationConverter(ICProject cproject) {
        return new CudaSdkHeadersLocationConverter(cproject.getProject(), "sdkheaders");
    }

    public Map<String, String> getExportProperties() {
        return Collections.emptyMap();
    }
}

