/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.debug.view;

import com.nvidia.cuda.ide.debug.model.query.ElementQuery;
import com.nvidia.cuda.ide.debug.model.query.IElementQuery;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.antlr.runtime.RecognitionException;
import org.eclipse.cdt.dsf.ui.concurrent.DisplayDsfExecutor;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Text;

public final class FilterFieldHarness
implements FocusListener {
    private static final int TYPING_TIMEOUT = 500;
    private final Filterable filterable;
    private boolean placeholderMode;
    private final String placeholderText = "Search CUDA Information";
    private ScheduledFuture<?> queryFuture;

    public FilterFieldHarness(final Text searchField, Filterable filterable) {
        this.filterable = filterable;
        searchField.addFocusListener((FocusListener)this);
        searchField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FilterFieldHarness.this.reparseText((Text)e.widget);
            }
        });
        searchField.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 27) {
                    FilterFieldHarness.this.clear((Text)e.widget);
                } else if (e.keyCode == 13) {
                    FilterFieldHarness.this.immediate((Text)e.widget);
                } else if (e.keyCode == 0x1000002) {
                    FilterFieldHarness.this.immediate((Text)e.widget);
                    e.widget.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            FilterFieldHarness.this.transferFocus();
                        }
                    });
                }
            }
        });
        searchField.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                if (e.detail == 256) {
                    FilterFieldHarness.this.clear(searchField);
                    if (!searchField.isFocusControl()) {
                        FilterFieldHarness.this.decorate(true, searchField);
                    }
                }
            }
        });
        this.decorate(true, searchField);
    }

    protected void transferFocus() {
        this.filterable.moveFocus();
    }

    private void cancel() {
        if (this.queryFuture != null && !this.queryFuture.isDone()) {
            this.queryFuture.cancel(false);
            this.queryFuture = null;
        }
    }

    protected void clear(Text widget) {
        this.cancel();
        widget.setText("");
        this.updateQuery("");
    }

    private void decorate(boolean showPlaceholder, Text text) {
        if (showPlaceholder) {
            if (text.getText().length() == 0) {
                text.setText("Search CUDA Information");
                text.setForeground(text.getDisplay().getSystemColor(33));
                this.placeholderMode = true;
            }
        } else if (this.placeholderMode) {
            text.setText("");
            text.setForeground(text.getDisplay().getSystemColor(21));
            this.placeholderMode = false;
        }
    }

    public void focusGained(FocusEvent e) {
        this.decorate(false, (Text)e.widget);
    }

    public void focusLost(FocusEvent e) {
        this.immediate((Text)e.widget);
        this.decorate(true, (Text)e.widget);
    }

    protected void immediate(Text widget) {
        this.cancel();
        this.updateQuery(widget.getText());
    }

    protected void reparseText(Text widget) {
        this.cancel();
        final String filter = widget.getText();
        this.queryFuture = DisplayDsfExecutor.getDisplayDsfExecutor((Display)widget.getDisplay()).schedule(new Runnable(){

            @Override
            public void run() {
                FilterFieldHarness.this.updateQuery(filter);
            }
        }, 500L, TimeUnit.MILLISECONDS);
    }

    private void updateQuery(String filter) {
        try {
            IElementQuery query = ElementQuery.parse(filter);
            this.filterable.setFilter(query);
        }
        catch (RecognitionException recognitionException) {}
    }

    public static interface Filterable {
        public void setFilter(IElementQuery var1);

        public void moveFocus();
    }
}

