/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.debug.ui.viewmodel.vms;

import com.ibm.icu.text.MessageFormat;
import com.nvidia.cuda.ide.debug.core.CudaDebugImages;
import com.nvidia.cuda.ide.debug.model.Device;
import com.nvidia.cuda.ide.debug.model.ICudaApplication;
import com.nvidia.cuda.ide.debug.model.Kernel;
import com.nvidia.cuda.ide.debug.model.RangeContext;
import com.nvidia.cuda.ide.debug.ui.viewmodel.ICudaUIConstants;
import com.nvidia.cuda.ide.debug.ui.viewmodel.vms.AbstractCudaDMVMNode;
import com.nvidia.cuda.ide.debug.util.OccupancyImage;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.ImmediateExecutor;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.dsf.ui.concurrent.ViewerDataRequestMonitor;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.AbstractDMVMProvider;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.IPropertiesUpdate;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.LabelAttribute;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.LabelColumnInfo;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.LabelImage;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.LabelText;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.PropertiesBasedLabelProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementLabelProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdate;
import org.eclipse.ui.IMemento;

public final class DeviceVMNode
extends AbstractCudaDMVMNode<Device> {
    public static void encodeDevice(Device object, IMemento memento) {
        if (object != null) {
            memento.putInteger("device_id", (int)object.getId());
        }
    }

    public static boolean compareDevices(Device object, IMemento memento) {
        return object != null && Integer.valueOf(object.getId()).equals(memento.getInteger("device_id"));
    }

    public DeviceVMNode(AbstractDMVMProvider provider, DsfSession session) {
        super(provider, session, Device.class);
    }

    @Override
    protected boolean compareElement(Device object, IMemento memento) {
        return DeviceVMNode.compareDevices(object, memento);
    }

    private LabelColumnInfo createLabelColumn(String label) {
        return new LabelColumnInfo(new LabelAttribute[]{new LabelText(label, new String[]{"device_id", "name", "sm_version"}), new LabelImage(CudaDebugImages.DEVICE.getDescriptor())});
    }

    @Override
    protected IElementLabelProvider createLabelProvider() {
        PropertiesBasedLabelProvider provider = new PropertiesBasedLabelProvider();
        provider.setColumnInfo("org.eclipse.cdt.dsf.ui.COLUMN_ID__NAME", this.createLabelColumn("[{0}] {1} (CC {2})"));
        provider.setColumnInfo(ICudaUIConstants.COLUMN_ID__HARDWARE, new LabelColumnInfo(new LabelAttribute[]{new LabelText("{0,choice,0#Unoccupied|1#Kernel {2} {1}|1<Executing {0} kernels}", new String[]{"active_kernels", "kernel_name", "kernel_id"})}));
        provider.setColumnInfo(ICudaUIConstants.COLUMN_ID__DETAILS, new LabelColumnInfo(new LabelAttribute[]{new LabelText("{0,choice,0#Inactive|1#1 of {1} SMs is active|1<{0} of {1} SMs are active}", new String[]{"active_sm_count", "sm_count"}), new OccupancyImage("sm_count", "active_sm_count")}));
        provider.setColumnInfo("ID_COLUMN_NO_COLUMNS", this.createLabelColumn("[{0}] {1}"));
        return provider;
    }

    @Override
    protected void encodeElement(Device object, IMemento memento) {
        DeviceVMNode.encodeDevice(object, memento);
    }

    @Override
    protected String getInactiveElementRangeStateLabel(RangeContext rangeContext) {
        return MessageFormat.format((String)"{0} Inactive Elements", (Object[])new Object[]{rangeContext.getEnd() - rangeContext.getStart() + 1L});
    }

    @Override
    protected boolean isLogicalNode() {
        return false;
    }

    @Override
    protected void updatePropertiesInSessionThread(final Device device, final IPropertiesUpdate update) {
        update.setProperty("name", (Object)device.getName());
        update.setProperty("sm_version", (Object)device.getSmType());
        update.setProperty("device_id", (Object)device.getId());
        update.setProperty("active_sm_count", (Object)device.getActiveSMs());
        update.setProperty("sm_count", (Object)device.getSmCount());
        ICudaApplication cudaApplication = (ICudaApplication)DMContexts.getAncestorOfType((IDMContext)device, ICudaApplication.class);
        cudaApplication.getKernels((DataRequestMonitor<? super Kernel[]>)new ViewerDataRequestMonitor<Kernel[]>(ImmediateExecutor.getInstance(), (IViewerUpdate)update){

            protected void handleSuccess() {
                Kernel[] kernels = (Kernel[])this.getData();
                int count = 0;
                Kernel[] kernelArray = kernels;
                int n = kernels.length;
                int n2 = 0;
                while (n2 < n) {
                    Kernel kernel = kernelArray[n2];
                    if (kernel.getDeviceId() == device.getId()) {
                        ++count;
                        update.setProperty("kernel_id", (Object)kernel.getId());
                        update.setProperty("kernel_name", (Object)kernel.getName());
                    }
                    ++n2;
                }
                update.setProperty("active_kernels", (Object)count);
                update.done();
            }
        });
    }

    @Override
    protected CudaDebugImages getInactiveImageDescriptor() {
        return CudaDebugImages.DEVICE_INACTIVE;
    }
}

