/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.debug.service;

import com.nvidia.cuda.ide.debug.model.IFocusDMContext;
import com.nvidia.cuda.ide.debug.service.CudaCommandFactory;
import java.util.concurrent.Executor;
import java.util.regex.Pattern;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IExpressions;
import org.eclipse.cdt.dsf.mi.service.IMICommandControl;
import org.eclipse.cdt.dsf.mi.service.MIVariableManager;
import org.eclipse.cdt.dsf.mi.service.command.CommandFactory;
import org.eclipse.cdt.dsf.mi.service.command.output.MIInfo;
import org.eclipse.cdt.dsf.mi.service.command.output.MIVarChange;
import org.eclipse.cdt.dsf.mi.service.command.output.MIVarUpdateInfo;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.cdt.dsf.service.DsfSession;

public final class CudaMIVariableManager
extends MIVariableManager {
    private final CommandFactory fCommandFactory;

    protected MIVariableManager.VariableObjectId createVariableObjectId() {
        return new VariableId();
    }

    public CudaMIVariableManager(DsfSession session, DsfServicesTracker tracker) {
        super(session, tracker);
        this.fCommandFactory = ((IMICommandControl)tracker.getService(IMICommandControl.class)).getCommandFactory();
    }

    protected MIVariableManager.MIRootVariableObject createRootVariableObject(MIVariableManager.VariableObjectId id) {
        return new RootVarObject(id);
    }

    public void writeValue(final IExpressions.IExpressionDMContext ctx, final String expressionValue, final String formatId, final RequestMonitor rm) {
        IFocusDMContext focus = (IFocusDMContext)DMContexts.getAncestorOfType((IDMContext)ctx, IFocusDMContext.class);
        if (focus != null) {
            this.getCommandControl().queueCommand(((CudaCommandFactory)this.fCommandFactory).createMICudaThreadSelect(focus), (DataRequestMonitor)new DataRequestMonitor<MIInfo>((Executor)this.getSession().getExecutor(), rm){

                protected void handleSuccess() {
                    CudaMIVariableManager.this.baseWriteValue(ctx, expressionValue, formatId, rm);
                }
            });
        } else {
            this.baseWriteValue(ctx, expressionValue, formatId, rm);
        }
    }

    protected void baseWriteValue(IExpressions.IExpressionDMContext ctx, String expressionValue, String formatId, RequestMonitor rm) {
        super.writeValue(ctx, expressionValue, formatId, rm);
    }

    private final class RootVarObject
    extends MIVariableManager.MIRootVariableObject {
        private String actualType;

        private RootVarObject(MIVariableManager.VariableObjectId id) {
            super((MIVariableManager)CudaMIVariableManager.this, id);
        }

        public void update(DataRequestMonitor<Boolean> rm) {
            if (this.isOutOfScope()) {
                rm.setData((Object)false);
                rm.done();
            } else if (this.currentState != 0) {
                this.updatesPending.add(rm);
            } else if (!this.getOutOfDate()) {
                rm.setData((Object)false);
                rm.done();
            } else {
                this.currentState = 1;
                MIVariableManager.MIRootVariableObject rootToUpdate = this.getRootToUpdate();
                IFocusDMContext focusContext = ((VariableId)rootToUpdate.getInternalId()).getFocusContext();
                Object varUpdateCommand = focusContext == null ? CudaMIVariableManager.this.fCommandFactory.createMIVarUpdate(rootToUpdate.getControlDMContext(), this.getGdbName()) : ((CudaCommandFactory)CudaMIVariableManager.this.fCommandFactory).createMIVarUpdate(focusContext, this.getGdbName());
                CudaMIVariableManager.this.getCommandControl().queueCommand(varUpdateCommand, (DataRequestMonitor)new VariableUpdateRequestMonitor((Executor)CudaMIVariableManager.this.getSession().getExecutor(), rm));
            }
        }

        public void setType(String newTypeName) {
            this.actualType = newTypeName;
            String type = Pattern.compile("\\s?@\\w*\\b\\s?").matcher(newTypeName).replaceAll("");
            super.setType(type);
        }

        public String getType() {
            return this.actualType;
        }

        private final class VariableUpdateRequestMonitor
        extends DataRequestMonitor<MIVarUpdateInfo> {
            private final DataRequestMonitor<Boolean> rm;

            private VariableUpdateRequestMonitor(Executor executor, DataRequestMonitor<Boolean> rm) {
                super(executor, rm);
                this.rm = rm;
            }

            protected void handleCompleted() {
                if (this.isSuccess()) {
                    RootVarObject.this.setOutOfDate(false);
                    MIVarChange[] changes = ((MIVarUpdateInfo)this.getData()).getMIVarChanges();
                    if (changes.length > 0 && !changes[0].isInScope()) {
                        RootVarObject.this.currentState = 0;
                        RootVarObject.this.outOfScope = true;
                        CudaMIVariableManager.this.getLRUCache().remove(RootVarObject.this.getInternalId());
                        this.rm.setData((Object)true);
                        this.rm.done();
                        while (RootVarObject.this.updatesPending.size() > 0) {
                            DataRequestMonitor pendingRm = (DataRequestMonitor)RootVarObject.this.updatesPending.poll();
                            pendingRm.setData((Object)false);
                            pendingRm.done();
                        }
                    } else {
                        RootVarObject.this.processChanges(changes, new RequestMonitor((Executor)CudaMIVariableManager.this.getSession().getExecutor(), (RequestMonitor)this.rm){

                            protected void handleCompleted() {
                                RootVarObject.this.currentState = 0;
                                CudaMIVariableManager.this.rootVariableUpdated(RootVarObject.this);
                                if (this.isSuccess()) {
                                    VariableUpdateRequestMonitor.this.rm.setData((Object)false);
                                } else {
                                    VariableUpdateRequestMonitor.this.rm.setStatus(this.getStatus());
                                }
                                VariableUpdateRequestMonitor.this.rm.done();
                                while (RootVarObject.this.updatesPending.size() > 0) {
                                    DataRequestMonitor pendingRm = (DataRequestMonitor)RootVarObject.this.updatesPending.poll();
                                    if (this.isSuccess()) {
                                        pendingRm.setData((Object)false);
                                    } else {
                                        pendingRm.setStatus(this.getStatus());
                                    }
                                    pendingRm.done();
                                }
                            }
                        });
                    }
                } else {
                    RootVarObject.this.currentState = 0;
                    this.rm.setData((Object)false);
                    this.rm.done();
                    while (RootVarObject.this.updatesPending.size() > 0) {
                        DataRequestMonitor pendingRm = (DataRequestMonitor)RootVarObject.this.updatesPending.poll();
                        pendingRm.setStatus(this.getStatus());
                        pendingRm.done();
                    }
                }
            }
        }
    }

    private final class VariableId
    extends MIVariableManager.VariableObjectId {
        private IExpressions.IExpressionDMContext exprCtx;

        private VariableId() {
            super((MIVariableManager)CudaMIVariableManager.this);
        }

        public void generateId(IExpressions.IExpressionDMContext exprCtx, RequestMonitor rm) {
            this.exprCtx = exprCtx;
            super.generateId(exprCtx, rm);
        }

        public IFocusDMContext getFocusContext() {
            return this.exprCtx != null ? (IFocusDMContext)DMContexts.getAncestorOfType((IDMContext)this.exprCtx, IFocusDMContext.class) : null;
        }
    }
}

