/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.debug.model;

import com.nvidia.cuda.ide.debug.model.CudaCoord;
import com.nvidia.cuda.ide.debug.model.CudaDim;

public interface ICoordSorter {
    public static final ICoordSorter HARDWARE = new ICoordSorter(){

        @Override
        public long ordinal(CudaDim dim, CudaCoord coord) {
            return dim.getOrdinal(coord);
        }

        @Override
        public CudaCoord getCoord(CudaDim dim, long ordinal) {
            return dim.getCoord(ordinal);
        }

        @Override
        public int compare(CudaDim dim, CudaCoord idx1, CudaCoord idx2) {
            return Long.signum(this.ordinal(dim, idx1) - this.ordinal(dim, idx2));
        }
    };
    public static final ICoordSorter CUDA = new ICoordSorter(){

        @Override
        public long ordinal(CudaDim dim, CudaCoord coord) {
            long ordinal = coord.getX();
            ordinal = ordinal * (long)dim.getY() + (long)coord.getY();
            return ordinal * (long)dim.getZ() + (long)coord.getZ();
        }

        @Override
        public CudaCoord getCoord(CudaDim dim, long ordinal) {
            long x = ordinal;
            long z = ordinal % (long)dim.getZ();
            x /= (long)dim.getZ();
            long y = ordinal % (long)dim.getY();
            return new CudaCoord((int)(x /= (long)dim.getY()), (int)y, (int)z);
        }

        @Override
        public int compare(CudaDim dim, CudaCoord idx1, CudaCoord idx2) {
            long o1 = this.ordinal(dim, idx1);
            long o2 = this.ordinal(dim, idx2);
            return Long.signum(o1 - o2);
        }
    };

    public long ordinal(CudaDim var1, CudaCoord var2);

    public CudaCoord getCoord(CudaDim var1, long var2);

    public int compare(CudaDim var1, CudaCoord var2, CudaCoord var3);
}

