/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.debug.model;

import com.nvidia.cuda.ide.debug.model.Block;
import com.nvidia.cuda.ide.debug.model.CudaCoord;
import com.nvidia.cuda.ide.debug.model.CudaException;
import com.nvidia.cuda.ide.debug.model.CudaRuntimeInformation;
import com.nvidia.cuda.ide.debug.model.Device;
import com.nvidia.cuda.ide.debug.model.ElementType;
import com.nvidia.cuda.ide.debug.model.ICudaApplication;
import com.nvidia.cuda.ide.debug.model.ICudaRuntimeObject;
import com.nvidia.cuda.ide.debug.model.ICudaVisitor;
import com.nvidia.cuda.ide.debug.model.IFocusDMContext;
import com.nvidia.cuda.ide.debug.model.Kernel;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DsfRunnable;
import org.eclipse.cdt.dsf.concurrent.ImmediateExecutor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.datamodel.AbstractDMContext;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.command.ICommandControlService;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public final class DeviceThread
extends AbstractDMContext
implements IFocusDMContext {
    private final Block block;
    private final CudaCoord threadIdx;

    public DeviceThread(Block cudaBlock, CudaCoord threadIdx) {
        super(cudaBlock.getSessionId(), new IDMContext[]{cudaBlock});
        this.block = cudaBlock;
        this.threadIdx = threadIdx;
    }

    @Override
    public void accept(ICudaVisitor visitor) {
        visitor.visitThread(this);
    }

    public boolean equals(Object obj) {
        if (obj instanceof DeviceThread) {
            return ((DeviceThread)obj).getThreadIdx().equals(this.getThreadIdx()) && ((DeviceThread)obj).getBlock().equals(this.getBlock());
        }
        return false;
    }

    @Override
    public Block getBlock() {
        return (Block)DMContexts.getAncestorOfType((IDMContext)this, Block.class);
    }

    @Override
    public CudaCoord getBlockIdx() {
        return this.block.getBlockIdx();
    }

    @Override
    public Kernel getKernel() {
        return this.block.getKernel();
    }

    @Override
    public long getKernelId() {
        return this.block.getKernel().getId();
    }

    @Override
    public void getState(DataRequestMonitor<CudaRuntimeInformation> rm) {
        this.getApplication().getThreadState(this, rm);
    }

    private ICudaApplication getApplication() {
        return (ICudaApplication)DMContexts.getAncestorOfType((IDMContext)this, ICudaApplication.class);
    }

    public int getThreadId() {
        return this.hashCode();
    }

    @Override
    public CudaCoord getThreadIdx() {
        return this.threadIdx;
    }

    @Override
    public ElementType getType() {
        return ElementType.thread;
    }

    public int hashCode() {
        return this.block.hashCode() ^ this.threadIdx.hashCode() >> 5;
    }

    public String toString() {
        return String.format("Thread %s", this.threadIdx);
    }

    @Override
    public void getExpressionContexts(final IDMContext[] contexts, final DataRequestMonitor<IDMContext[]> rm) {
        if (contexts.length == 0 || this.equals(DMContexts.getAncestorOfType((IDMContext)contexts[0], IFocusDMContext.class))) {
            rm.setData((Object)contexts);
            rm.done();
        } else {
            final ICudaApplication application = this.getApplication();
            application.getExecutor().execute((Runnable)new DsfRunnable(){

                public void run() {
                    application.getExpressions(DeviceThread.this, contexts, (DataRequestMonitor<IDMContext[]>)rm);
                }
            });
        }
    }

    public String getCommandControlId() {
        return ((ICommandControlService.ICommandControlDMContext)DMContexts.getAncestorOfType((IDMContext)this.getBlock(), ICommandControlService.ICommandControlDMContext.class)).getCommandControlId();
    }

    @Override
    public void toHardwareElement(final DataRequestMonitor<ICudaRuntimeObject> drm) {
        this.getState(new DataRequestMonitor<CudaRuntimeInformation>(ImmediateExecutor.getInstance(), drm){

            protected void handleSuccess() {
                final CudaRuntimeInformation information = (CudaRuntimeInformation)this.getData();
                if (information.getState().isActive()) {
                    DeviceThread.this.getApplication().getDevices(new DataRequestMonitor<Device[]>(ImmediateExecutor.getInstance(), (RequestMonitor)drm){

                        protected void handleSuccess() {
                            try {
                                Device[] deviceArray = (Device[])this.getData();
                                int n = deviceArray.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    Device device = deviceArray[n2];
                                    if (device.getId() == information.getDeviceId() && DsfSession.isSessionActive((String)device.getSessionId())) {
                                        drm.setData((Object)device.getSm(information.getSm()).getWarp(information.getWarpId()).getLane(information.getLane()));
                                        break;
                                    }
                                    ++n2;
                                }
                            }
                            catch (CudaException e) {
                                drm.setStatus((IStatus)new Status(4, "com.nvidia.cuda.ide.debug", null, (Throwable)e));
                            }
                            drm.done();
                        }
                    });
                } else {
                    drm.done();
                }
            }
        });
    }

    @Override
    public void toLogicalElement(DataRequestMonitor<ICudaRuntimeObject> drm) {
        drm.setData((Object)this);
        drm.done();
    }
}

