/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.e4.compatibility.ModeledPageLayout;
import org.eclipse.ui.internal.registry.ActionSetRegistry;
import org.eclipse.ui.internal.registry.IActionSetDescriptor;
import org.eclipse.ui.internal.registry.PerspectiveDescriptor;

public class Perspective {
    protected PerspectiveDescriptor descriptor;
    protected WorkbenchPage page;
    protected boolean editorHidden = false;
    protected boolean editorAreaRestoreOnUnzoom = false;
    protected int editorAreaState = 2;
    protected ArrayList alwaysOnActionSets;
    protected ArrayList alwaysOffActionSets;
    protected Collection hideMenuIDs;
    protected Collection hideToolBarIDs;
    private Map mapIDtoViewLayoutRec;
    protected boolean fixed;
    protected ArrayList showInPartIds;
    protected HashMap showInTimes = new HashMap();
    protected IMemento memento;
    private IWorkbenchPartReference oldPartRef = null;
    protected boolean shouldHideEditorsOnActivate = false;
    protected MPerspective layout;

    public Perspective(PerspectiveDescriptor desc, MPerspective layout, WorkbenchPage page) {
        this(page);
        this.layout = layout;
        this.descriptor = desc;
    }

    public void initActionSets() {
        if (this.descriptor != null) {
            ArrayList temp = new ArrayList();
            this.createInitialActionSets(temp, ModeledPageLayout.getIds(this.layout, "persp.actionSet:"));
            for (IActionSetDescriptor descriptor : temp) {
                if (this.alwaysOnActionSets.contains(descriptor)) continue;
                this.alwaysOnActionSets.add(descriptor);
            }
        }
    }

    protected Perspective(WorkbenchPage page) {
        this.page = page;
        this.alwaysOnActionSets = new ArrayList(2);
        this.alwaysOffActionSets = new ArrayList(2);
        this.hideMenuIDs = new HashSet();
        this.hideToolBarIDs = new HashSet();
        this.mapIDtoViewLayoutRec = new HashMap();
    }

    protected void createInitialActionSets(List outputList, List stringList) {
        ActionSetRegistry reg = WorkbenchPlugin.getDefault().getActionSetRegistry();
        for (String id : stringList) {
            IActionSetDescriptor desc = reg.findActionSet(id);
            if (desc == null) continue;
            outputList.add(desc);
        }
    }

    public void dispose() {
        this.mapIDtoViewLayoutRec.clear();
    }

    public IPerspectiveDescriptor getDesc() {
        return this.descriptor;
    }

    public String[] getNewWizardShortcuts() {
        return this.page.getNewWizardShortcuts();
    }

    public String[] getPerspectiveShortcuts() {
        return this.page.getPerspectiveShortcuts();
    }

    public ArrayList getShowInPartIds() {
        return this.page.getShowInPartIds();
    }

    public long getShowInTime(String partId) {
        Long t = (Long)this.showInTimes.get(partId);
        return t == null ? 0L : t;
    }

    public String[] getShowViewShortcuts() {
        return this.page.getShowViewShortcuts();
    }

    private void removeAlwaysOn(IActionSetDescriptor descriptor) {
        if (descriptor == null) {
            return;
        }
        if (!this.alwaysOnActionSets.contains(descriptor)) {
            return;
        }
        this.alwaysOnActionSets.remove(descriptor);
        if (this.page != null) {
            this.page.perspectiveActionSetChanged(this, descriptor, 3);
        }
    }

    protected void addAlwaysOff(IActionSetDescriptor descriptor) {
        if (descriptor == null) {
            return;
        }
        if (this.alwaysOffActionSets.contains(descriptor)) {
            return;
        }
        this.alwaysOffActionSets.add(descriptor);
        if (this.page != null) {
            this.page.perspectiveActionSetChanged(this, descriptor, 0);
        }
        this.removeAlwaysOn(descriptor);
    }

    protected void addAlwaysOn(IActionSetDescriptor descriptor) {
        if (descriptor == null) {
            return;
        }
        if (this.alwaysOnActionSets.contains(descriptor)) {
            return;
        }
        this.alwaysOnActionSets.add(descriptor);
        if (this.page != null) {
            this.page.perspectiveActionSetChanged(this, descriptor, 2);
        }
        this.removeAlwaysOff(descriptor);
    }

    private void removeAlwaysOff(IActionSetDescriptor descriptor) {
        if (descriptor == null) {
            return;
        }
        if (!this.alwaysOffActionSets.contains(descriptor)) {
            return;
        }
        this.alwaysOffActionSets.remove(descriptor);
        if (this.page != null) {
            this.page.perspectiveActionSetChanged(this, descriptor, 1);
        }
    }

    protected ArrayList getPerspectiveExtensionActionSets() {
        return this.page.getPerspectiveExtensionActionSets(this.descriptor.getOriginalId());
    }

    public void turnOnActionSets(IActionSetDescriptor[] newArray) {
        int i = 0;
        while (i < newArray.length) {
            IActionSetDescriptor descriptor = newArray[i];
            this.addActionSet(descriptor);
            ++i;
        }
    }

    public void turnOffActionSets(IActionSetDescriptor[] toDisable) {
        int i = 0;
        while (i < toDisable.length) {
            IActionSetDescriptor descriptor = toDisable[i];
            this.turnOffActionSet(descriptor);
            ++i;
        }
    }

    public void turnOffActionSet(IActionSetDescriptor toDisable) {
        this.removeActionSet(toDisable);
    }

    public IWorkbenchPartReference getOldPartRef() {
        return this.oldPartRef;
    }

    public void setOldPartRef(IWorkbenchPartReference oldPartRef) {
        this.oldPartRef = oldPartRef;
    }

    protected void addActionSet(IActionSetDescriptor newDesc) {
        IContextService service = (IContextService)this.page.getWorkbenchWindow().getService(IContextService.class);
        try {
            service.deferUpdates(true);
            int i = 0;
            while (i < this.alwaysOnActionSets.size()) {
                IActionSetDescriptor desc = (IActionSetDescriptor)this.alwaysOnActionSets.get(i);
                if (desc.getId().equals(newDesc.getId())) {
                    this.removeAlwaysOn(desc);
                    this.removeAlwaysOff(desc);
                    break;
                }
                ++i;
            }
            this.addAlwaysOn(newDesc);
            String actionSetID = newDesc.getId();
            String tag = "persp.actionSet:" + actionSetID;
            if (!this.layout.getTags().contains(tag)) {
                this.layout.getTags().add(tag);
            }
        }
        finally {
            service.deferUpdates(false);
        }
    }

    protected void removeActionSet(IActionSetDescriptor toRemove) {
        String id = toRemove.getId();
        IContextService service = (IContextService)this.page.getWorkbenchWindow().getService(IContextService.class);
        try {
            IActionSetDescriptor desc;
            service.deferUpdates(true);
            int i = 0;
            while (i < this.alwaysOnActionSets.size()) {
                desc = (IActionSetDescriptor)this.alwaysOnActionSets.get(i);
                if (desc.getId().equals(id)) {
                    this.removeAlwaysOn(desc);
                    break;
                }
                ++i;
            }
            i = 0;
            while (i < this.alwaysOffActionSets.size()) {
                desc = (IActionSetDescriptor)this.alwaysOffActionSets.get(i);
                if (desc.getId().equals(id)) {
                    this.removeAlwaysOff(desc);
                    break;
                }
                ++i;
            }
            this.addAlwaysOff(toRemove);
            String tag = "persp.actionSet:" + id;
            if (this.layout.getTags().contains(tag)) {
                this.layout.getTags().remove(tag);
            }
        }
        finally {
            service.deferUpdates(false);
        }
    }

    public IActionSetDescriptor[] getAlwaysOnActionSets() {
        return this.alwaysOnActionSets.toArray(new IActionSetDescriptor[this.alwaysOnActionSets.size()]);
    }

    public IActionSetDescriptor[] getAlwaysOffActionSets() {
        return this.alwaysOffActionSets.toArray(new IActionSetDescriptor[this.alwaysOffActionSets.size()]);
    }

    public Collection getHiddenMenuItems() {
        return this.hideMenuIDs;
    }

    public Collection getHiddenToolbarItems() {
        return this.hideToolBarIDs;
    }

    public void updateActionBars() {
        this.page.getActionBars().getMenuManager().updateAll(true);
        this.page.resetToolBarLayout();
    }
}

