/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.pdf.emitter;

import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IListBandContent;
import org.eclipse.birt.report.engine.content.IListContent;
import org.eclipse.birt.report.engine.layout.area.impl.AreaFactory;
import org.eclipse.birt.report.engine.layout.area.impl.ContainerArea;
import org.eclipse.birt.report.engine.layout.pdf.emitter.ContainerLayout;
import org.eclipse.birt.report.engine.layout.pdf.emitter.IInlineStackingLayout;
import org.eclipse.birt.report.engine.layout.pdf.emitter.Layout;
import org.eclipse.birt.report.engine.layout.pdf.emitter.LayoutEngineContext;
import org.eclipse.birt.report.engine.layout.pdf.emitter.RegionLayout;
import org.eclipse.birt.report.engine.layout.pdf.emitter.RepeatableLayout;
import org.eclipse.birt.report.engine.layout.pdf.util.PropertyUtil;

public class ListLayout
extends RepeatableLayout {
    public ListLayout(LayoutEngineContext context, ContainerLayout parent, IContent content) {
        super(context, parent, content);
        this.isInline = PropertyUtil.isInlineElement(content);
        this.isInBlockStacking &= !this.isInline;
    }

    @Override
    protected void repeatHeader() throws BirtException {
        if (this.bandStatus == 1) {
            return;
        }
        IListContent listContent = (IListContent)this.content;
        if (!listContent.isHeaderRepeat()) {
            return;
        }
        IListBandContent band = listContent.getHeader();
        if (band == null || band.getChildren().isEmpty()) {
            return;
        }
        ContainerArea headerArea = (ContainerArea)AreaFactory.createLogicContainer(this.content.getReportContent());
        headerArea.setAllocatedWidth(this.parent.getCurrentMaxContentWidth());
        RegionLayout regionLayout = new RegionLayout(this.context, band, headerArea);
        ((Layout)regionLayout).layout();
        if (headerArea.getAllocatedHeight() < this.getCurrentMaxContentHeight()) {
            this.addArea(headerArea);
            ++this.repeatCount;
        }
    }

    @Override
    protected void initialize() throws BirtException {
        this.checkInlineBlock();
        super.initialize();
    }

    protected void checkInlineBlock() throws BirtException {
        if (PropertyUtil.isInlineElement(this.content) && this.parent instanceof IInlineStackingLayout) {
            int avaWidth = this.parent.getCurrentMaxContentWidth();
            this.calculateSpecifiedWidth();
            if (avaWidth < this.specifiedWidth && this.specifiedWidth > 0 && this.specifiedWidth < this.parent.getMaxAvaWidth()) {
                ((IInlineStackingLayout)((Object)this.parent)).endLine();
            }
        }
    }
}

