/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.internal.document.v3;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.archive.IDocArchiveWriter;
import org.eclipse.birt.core.archive.RAOutputStream;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.internal.document.DocumentExtension;
import org.eclipse.birt.report.engine.internal.document.IReportContentWriter;

public class ReportContentWriterV3
implements IReportContentWriter {
    protected static Logger logger = Logger.getLogger(IReportContentWriter.class.getName());
    protected RAOutputStream cntStream;
    protected long cntOffset;
    protected long rootOffset;
    private ByteArrayOutputStream buffer = new ByteArrayOutputStream();
    private DataOutputStream bufferStream = new DataOutputStream(this.buffer);
    protected Stack contents = new Stack();
    static final long OFFSET_PARENT = 0L;
    static final long OFFSET_NEXT = 8L;
    static final long OFFSET_CHILD = 16L;
    static final int INDEX_ENTRY_SIZE = 24;
    static final int VERSION_SIZE = 4;
    protected static final int VERSION_1 = 1;

    public ReportContentWriterV3(IDocArchiveWriter writer, String name) throws IOException {
        this.cntStream = writer.createRandomAccessStream(name);
        this.cntStream.writeInt(1);
        this.cntOffset = 0L;
        this.rootOffset = -1L;
    }

    @Override
    public void close() {
        if (this.cntStream != null) {
            try {
                this.cntStream.close();
            }
            catch (Exception ex) {
                logger.log(Level.SEVERE, "Failed in close the writer", ex);
            }
            this.cntStream = null;
        }
    }

    @Override
    public long getOffset() {
        return this.cntOffset;
    }

    @Override
    public long writeContent(IContent content) throws IOException {
        this.updateIndex(content);
        this.buffer.reset();
        IOUtil.writeInt((OutputStream)this.bufferStream, (int)content.getContentType());
        content.writeContent(this.bufferStream);
        this.bufferStream.flush();
        byte[] values = this.buffer.toByteArray();
        this.cntStream.seek(this.cntOffset + 4L);
        this.cntStream.writeInt(values.length);
        this.cntStream.write(values);
        this.cntOffset = this.cntOffset + 4L + (long)values.length;
        DocumentExtension docExt = (DocumentExtension)content.getExtension(0);
        if (docExt != null) {
            return docExt.getIndex();
        }
        return -1L;
    }

    public long writeReport(IReportContent report) throws IOException {
        this.cntStream.seek(4L);
        this.cntStream.writeLong(-1L);
        this.cntStream.writeLong(-1L);
        this.cntStream.writeLong(-1L);
        this.cntOffset += 24L;
        this.buffer.reset();
        IOUtil.writeInt((OutputStream)this.bufferStream, (int)0);
        report.writeContent(this.bufferStream);
        this.bufferStream.flush();
        byte[] values = this.buffer.toByteArray();
        this.cntStream.seek(this.cntOffset + 4L);
        this.cntStream.writeInt(values.length);
        this.cntStream.write(values);
        this.cntOffset = this.cntOffset + 4L + (long)values.length;
        return this.cntOffset;
    }

    @Override
    public long writeFullContent(IContent content) throws IOException {
        long offset = this.writeContent(content);
        for (IContent child : content.getChildren()) {
            this.writeFullContent(child);
        }
        return offset;
    }

    protected void updateIndex(IContent content) throws IOException {
        long index = this.cntOffset;
        long previous = -1L;
        DocumentExtension pDocExt = null;
        DocumentExtension docExt = new DocumentExtension(index);
        docExt.setContentId(content.getInstanceID().getUniqueID());
        content.setExtension(0, docExt);
        IContent pContent = (IContent)content.getParent();
        if (pContent != null) {
            pDocExt = (DocumentExtension)pContent.getExtension(0);
            if (pDocExt != null) {
                pDocExt.add(docExt);
                previous = docExt.getPrevious();
            } else {
                previous = this.rootOffset;
                this.rootOffset = index;
            }
        } else {
            previous = this.rootOffset;
            this.rootOffset = index;
        }
        this.cntStream.seek(4L + index);
        this.cntStream.writeLong(docExt.getParent());
        this.cntStream.writeLong(docExt.getNext());
        this.cntStream.writeLong(-1L);
        this.cntOffset += 24L;
        if (previous == -1L) {
            if (docExt.getParent() != -1L) {
                this.cntStream.seek(4L + docExt.getParent() + 16L);
                this.cntStream.writeLong(index);
            }
        } else {
            this.cntStream.seek(4L + previous + 8L);
            this.cntStream.writeLong(index);
        }
    }
}

