/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.codan.internal.ui.actions;

import org.eclipse.cdt.codan.core.CodanRuntime;
import org.eclipse.cdt.codan.core.model.CheckerLaunchMode;
import org.eclipse.cdt.codan.internal.ui.CodanUIMessages;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class RunCodeAnalysis
implements IObjectActionDelegate {
    private ISelection sel;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void run(IAction action) {
        Job job = new Job(CodanUIMessages.Job_TitleRunningAnalysis){

            protected IStatus run(IProgressMonitor monitor) {
                IStructuredSelection ss = (IStructuredSelection)RunCodeAnalysis.this.sel;
                int count = ss.size();
                monitor.beginTask(this.getName(), count * 100);
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                for (Object o : ss) {
                    if (o instanceof IAdaptable) {
                        o = ((IAdaptable)o).getAdapter(IResource.class);
                    }
                    if (o instanceof IResource) {
                        IResource res = (IResource)o;
                        SubProgressMonitor subMon = new SubProgressMonitor(monitor, 100);
                        CodanRuntime.getInstance().getBuilder().processResource(res, (IProgressMonitor)subMon, CheckerLaunchMode.RUN_ON_DEMAND);
                        if (subMon.isCanceled()) {
                            return Status.CANCEL_STATUS;
                        }
                    }
                    if (!monitor.isCanceled()) continue;
                    return Status.CANCEL_STATUS;
                }
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.sel = selection;
    }
}

