/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.repository.tree.command;

import java.net.URISyntaxException;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.fetch.FetchOperationUI;
import org.eclipse.egit.ui.internal.fetch.SimpleConfigureFetchDialog;
import org.eclipse.egit.ui.internal.repository.tree.FetchNode;
import org.eclipse.egit.ui.internal.repository.tree.RemoteNode;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryNode;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryTreeNode;
import org.eclipse.egit.ui.internal.repository.tree.command.RepositoriesViewCommandHandler;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FetchConfiguredRemoteCommand
extends RepositoriesViewCommandHandler<RepositoryTreeNode> {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        RepositoryTreeNode node = (RepositoryTreeNode)this.getSelectedNodes(event).get(0);
        RemoteConfig config = this.getRemoteConfig(node);
        if (config == null) {
            MessageDialog.openInformation((Shell)this.getShell(event), (String)UIText.SimpleFetchActionHandler_NothingToFetchDialogTitle, (String)UIText.SimpleFetchActionHandler_NothingToFetchDialogMessage);
            return null;
        }
        int timeout = Activator.getDefault().getPreferenceStore().getInt("remote_connection_timeout");
        new FetchOperationUI(node.getRepository(), config, timeout, false).start();
        return null;
    }

    public boolean isEnabled() {
        RepositoryTreeNode node = (RepositoryTreeNode)this.getSelectedNodes().get(0);
        try {
            return this.getRemoteConfig(node) != null;
        }
        catch (ExecutionException executionException) {
            return false;
        }
    }

    private RemoteConfig getRemoteConfig(RepositoryTreeNode node) throws ExecutionException {
        if (node instanceof FetchNode) {
            try {
                RemoteNode remote = (RemoteNode)node.getParent();
                return new RemoteConfig((Config)node.getRepository().getConfig(), (String)remote.getObject());
            }
            catch (URISyntaxException e) {
                throw new ExecutionException(e.getMessage());
            }
        }
        if (node instanceof RemoteNode) {
            try {
                RemoteNode remote = (RemoteNode)node;
                return new RemoteConfig((Config)node.getRepository().getConfig(), (String)remote.getObject());
            }
            catch (URISyntaxException e) {
                throw new ExecutionException(e.getMessage());
            }
        }
        if (node instanceof RepositoryNode) {
            return SimpleConfigureFetchDialog.getConfiguredRemote(node.getRepository());
        }
        return null;
    }
}

