/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.preferences;

import java.io.File;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.ui.StringVariableSelectionDialog;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.ComboFieldEditor;
import org.eclipse.jface.preference.DirectoryFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class GitPreferenceRoot
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private static final int GROUP_SPAN = 3;
    private static final String[][] MERGE_MODE_NAMES_AND_VALUES = new String[3][2];
    private static final boolean HAS_DEBUG_UI = GitPreferenceRoot.hasDebugUiBundle();

    static {
        GitPreferenceRoot.MERGE_MODE_NAMES_AND_VALUES[0][0] = UIText.GitPreferenceRoot_MergeMode_0_Label;
        GitPreferenceRoot.MERGE_MODE_NAMES_AND_VALUES[0][1] = "0";
        GitPreferenceRoot.MERGE_MODE_NAMES_AND_VALUES[1][0] = UIText.GitPreferenceRoot_MergeMode_1_Label;
        GitPreferenceRoot.MERGE_MODE_NAMES_AND_VALUES[1][1] = "1";
        GitPreferenceRoot.MERGE_MODE_NAMES_AND_VALUES[2][0] = UIText.GitPreferenceRoot_MergeMode_2_Label;
        GitPreferenceRoot.MERGE_MODE_NAMES_AND_VALUES[2][1] = "2";
    }

    public GitPreferenceRoot() {
        super(0);
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return Activator.getDefault().getPreferenceStore();
    }

    public void init(IWorkbench workbench) {
    }

    protected void createFieldEditors() {
        Composite main = this.getFieldEditorParent();
        GridLayoutFactory.swtDefaults().margins(0, 0).applyTo(main);
        Group cloningGroup = new Group(main, 16);
        cloningGroup.setText(UIText.GitPreferenceRoot_CloningRepoGroupHeader);
        GridDataFactory.fillDefaults().grab(true, false).span(3, 1).applyTo((Control)cloningGroup);
        DirectoryFieldEditor editor = new DirectoryFieldEditor("default_repository_dir", UIText.GitPreferenceRoot_DefaultRepoFolderLabel, (Composite)cloningGroup){
            private static final int NUMBER_OF_OWN_CONTROLS = 1;

            protected boolean doCheckState() {
                String substitutedFileName;
                String fileName = this.getTextControl().getText();
                if ((fileName = fileName.trim()).length() == 0 && this.isEmptyStringAllowed()) {
                    return true;
                }
                IStringVariableManager manager = VariablesPlugin.getDefault().getStringVariableManager();
                try {
                    substitutedFileName = manager.performStringSubstitution(fileName);
                }
                catch (CoreException coreException) {
                    return false;
                }
                File file = new File(substitutedFileName);
                return !file.exists() || file.isDirectory();
            }

            public int getNumberOfControls() {
                return super.getNumberOfControls() + 1;
            }

            protected void doFillIntoGrid(Composite parent, int numColumns) {
                super.doFillIntoGrid(parent, numColumns - 1);
            }

            protected void adjustForNumColumns(int numColumns) {
                super.adjustForNumColumns(numColumns - 1);
            }

            protected void createControl(Composite parent) {
                super.setValidateStrategy(0);
                super.createControl(parent);
                if (HAS_DEBUG_UI) {
                    this.addVariablesButton(parent);
                }
            }

            private void addVariablesButton(Composite parent) {
                Button variableButton = new Button(parent, 8);
                variableButton.setText(UIText.GitPreferenceRoot_DefaultRepoFolderVariableButton);
                variableButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        StringVariableSelectionDialog dialog = new StringVariableSelectionDialog(this.getShell());
                        int returnCode = dialog.open();
                        if (returnCode == 0) {
                            this.setStringValue(dialog.getVariableExpression());
                        }
                    }
                });
            }
        };
        this.updateMargins(cloningGroup);
        editor.setEmptyStringAllowed(false);
        editor.getLabelControl((Composite)cloningGroup).setToolTipText(UIText.GitPreferenceRoot_DefaultRepoFolderTooltip);
        this.addField((FieldEditor)editor);
        Group remoteConnectionsGroup = new Group(main, 16);
        GridDataFactory.fillDefaults().grab(true, false).span(3, 1).applyTo((Control)remoteConnectionsGroup);
        remoteConnectionsGroup.setText(UIText.GitPreferenceRoot_RemoteConnectionsGroupHeader);
        IntegerFieldEditor timeoutEditor = new IntegerFieldEditor("remote_connection_timeout", UIText.RemoteConnectionPreferencePage_TimeoutLabel, (Composite)remoteConnectionsGroup);
        timeoutEditor.getLabelControl((Composite)remoteConnectionsGroup).setToolTipText(UIText.RemoteConnectionPreferencePage_ZeroValueTooltip);
        this.addField((FieldEditor)timeoutEditor);
        this.updateMargins(remoteConnectionsGroup);
        Group repoChangeScannerGroup = new Group(main, 16);
        GridDataFactory.fillDefaults().grab(true, false).span(3, 1).applyTo((Control)repoChangeScannerGroup);
        repoChangeScannerGroup.setText(UIText.GitPreferenceRoot_RepoChangeScannerGroupHeader);
        this.addField((FieldEditor)new BooleanFieldEditor("refesh_on_index_change", UIText.RefreshPreferencesPage_RefreshWhenIndexChange, (Composite)repoChangeScannerGroup));
        this.addField((FieldEditor)new BooleanFieldEditor("refesh_only_when_active", UIText.RefreshPreferencesPage_RefreshOnlyWhenActive, (Composite)repoChangeScannerGroup));
        this.updateMargins(repoChangeScannerGroup);
        Group mergeGroup = new Group(main, 16);
        GridDataFactory.fillDefaults().grab(true, false).span(3, 1).applyTo((Control)mergeGroup);
        mergeGroup.setText(UIText.GitPreferenceRoot_MergeGroupHeader);
        ComboFieldEditor mergeMode = new ComboFieldEditor("merge_mode", UIText.GitPreferenceRoot_MergeModeLabel, MERGE_MODE_NAMES_AND_VALUES, (Composite)mergeGroup);
        mergeMode.getLabelControl((Composite)mergeGroup).setToolTipText(UIText.GitPreferenceRoot_MergeModeTooltip);
        this.addField((FieldEditor)mergeMode);
        this.updateMargins(mergeGroup);
        Group blameGroup = new Group(main, 16);
        GridDataFactory.fillDefaults().grab(true, false).span(3, 1).applyTo((Control)blameGroup);
        blameGroup.setText(UIText.GitPreferenceRoot_BlameGroupHeader);
        this.addField((FieldEditor)new BooleanFieldEditor("Blame_IgnoreWhitespace", UIText.GitPreferenceRoot_BlameIgnoreWhitespaceLabel, (Composite)blameGroup));
        this.updateMargins(blameGroup);
        Group secureGroup = new Group(main, 16);
        GridDataFactory.fillDefaults().grab(true, false).span(3, 1).applyTo((Control)secureGroup);
        secureGroup.setText(UIText.GitPreferenceRoot_SecureStoreGroupLabel);
        this.addField((FieldEditor)new BooleanFieldEditor("CloneWizard_StoreInSecureStore", UIText.GitPreferenceRoot_SecureStoreUseByDefault, (Composite)secureGroup));
        this.updateMargins(secureGroup);
    }

    private void updateMargins(Group group) {
        GridLayout layout = (GridLayout)group.getLayout();
        layout.marginWidth = 5;
        layout.marginHeight = 5;
    }

    private static final boolean hasDebugUiBundle() {
        try {
            return Class.forName("org.eclipse.debug.ui.StringVariableSelectionDialog") != null;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }
}

