/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.egit.core.internal.util.ResourceUtil;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.FileRevisionEditorInput;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.jface.util.OpenStrategy;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.ide.IDE;

public class EgitUiEditorUtils {
    public static IEditorPart openEditor(IWorkbenchPage page, IFileRevision revision, IProgressMonitor monitor) throws CoreException {
        IStorage file = revision.getStorage(monitor);
        if (file instanceof IFile) {
            return IDE.openEditor((IWorkbenchPage)page, (IFile)((IFile)file), (boolean)OpenStrategy.activateOnOpen());
        }
        FileRevisionEditorInput fileRevEditorInput = FileRevisionEditorInput.createEditorInputFor(revision, monitor);
        IEditorPart part = EgitUiEditorUtils.openEditor(page, fileRevEditorInput);
        return part;
    }

    public static void openTextEditor(IWorkbenchPage page, IFileRevision revision, IProgressMonitor monitor) throws CoreException {
        FileRevisionEditorInput fileRevEditorInput = FileRevisionEditorInput.createEditorInputFor(revision, monitor);
        EgitUiEditorUtils.openEditor(page, fileRevEditorInput, "org.eclipse.ui.DefaultTextEditor");
    }

    private static IEditorPart openEditor(IWorkbenchPage page, FileRevisionEditorInput editorInput) throws PartInitException {
        String id = EgitUiEditorUtils.getEditorId(editorInput);
        return EgitUiEditorUtils.openEditor(page, editorInput, id);
    }

    private static IEditorPart openEditor(IWorkbenchPage page, FileRevisionEditorInput editorInput, String editorId) throws PartInitException {
        try {
            IEditorPart part = page.openEditor((IEditorInput)editorInput, editorId, OpenStrategy.activateOnOpen());
            if (part == null) {
                throw new PartInitException(NLS.bind((String)UIText.EgitUiUtils_CouldNotOpenEditorMessage, (Object)editorId));
            }
            return part;
        }
        catch (PartInitException e) {
            if (editorId.equals("org.eclipse.ui.DefaultTextEditor")) {
                throw e;
            }
            return page.openEditor((IEditorInput)editorInput, "org.eclipse.ui.DefaultTextEditor");
        }
    }

    public static IEditorPart openEditor(File file, IWorkbenchPage page) {
        if (!file.exists()) {
            return null;
        }
        IFile fileResource = ResourceUtil.getFileForLocation((IPath)new Path(file.getAbsolutePath()));
        if (fileResource != null) {
            try {
                return IDE.openEditor((IWorkbenchPage)page, (IFile)fileResource, (boolean)OpenStrategy.activateOnOpen());
            }
            catch (PartInitException e) {
                Activator.handleError(UIText.EgitUiEditorUtils_openFailed, e, true);
            }
        } else {
            IFileStore store = EFS.getLocalFileSystem().getStore((IPath)new Path(file.getAbsolutePath()));
            try {
                return IDE.openEditor((IWorkbenchPage)page, (IEditorInput)new FileStoreEditorInput(store), (String)"org.eclipse.ui.DefaultTextEditor");
            }
            catch (PartInitException e) {
                Activator.handleError(UIText.EgitUiEditorUtils_openFailed, e, true);
            }
        }
        return null;
    }

    private static String getEditorId(FileRevisionEditorInput editorInput) {
        String id = EgitUiEditorUtils.getEditorId(editorInput.getFileRevision().getName(), EgitUiEditorUtils.getContentType(editorInput));
        return id;
    }

    private static String getEditorId(String fileName, IContentType type) {
        IEditorRegistry registry = PlatformUI.getWorkbench().getEditorRegistry();
        IEditorDescriptor descriptor = registry.getDefaultEditor(fileName, type);
        String id = descriptor == null || descriptor.isOpenExternal() ? "org.eclipse.ui.DefaultTextEditor" : descriptor.getId();
        return id;
    }

    private static IContentType getContentType(FileRevisionEditorInput editorInput) {
        IContentType type = null;
        try {
            InputStream contents = editorInput.getStorage().getContents();
            try {
                type = EgitUiEditorUtils.getContentType(editorInput.getFileRevision().getName(), contents);
            }
            catch (Throwable throwable) {
                try {
                    contents.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                contents.close();
            }
            catch (IOException iOException) {}
        }
        catch (CoreException e) {
            Activator.handleError(e.getMessage(), e, false);
        }
        return type;
    }

    private static IContentType getContentType(String fileName, InputStream contents) {
        IContentType type = null;
        if (contents != null) {
            try {
                type = Platform.getContentTypeManager().findContentTypeFor(contents, fileName);
            }
            catch (IOException e) {
                Activator.handleError(e.getMessage(), e, false);
            }
        }
        if (type == null) {
            type = Platform.getContentTypeManager().findContentTypeFor(fileName);
        }
        return type;
    }
}

