/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.core.de;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.birt.report.item.crosstab.core.ICrosstabConstants;
import org.eclipse.birt.report.item.crosstab.core.ILevelViewConstants;
import org.eclipse.birt.report.item.crosstab.core.de.AbstractCrosstabItemHandle;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabCellHandle;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.DimensionViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.MeasureViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.internal.LevelViewTask;
import org.eclipse.birt.report.item.crosstab.core.util.CrosstabExtendedItemFactory;
import org.eclipse.birt.report.item.crosstab.core.util.CrosstabUtil;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.olap.LevelHandle;

public class LevelViewHandle
extends AbstractCrosstabItemHandle
implements ILevelViewConstants,
ICrosstabConstants {
    LevelViewHandle(DesignElementHandle handle) {
        super(handle);
    }

    public LevelHandle getCubeLevel() {
        LevelHandle cubeLevel = (LevelHandle)this.handle.getElementProperty("level");
        if (cubeLevel == null) {
            String fullLevelName = this.getCubeLevelName();
            this.getCrosstab().getCube();
            cubeLevel = this.findLevelHandle(fullLevelName);
        }
        return cubeLevel;
    }

    public String getCubeLevelName() {
        return this.handle.getStringProperty("level");
    }

    public Iterator filtersIterator() {
        PropertyHandle propHandle = this.handle.getPropertyHandle("filter");
        if (propHandle == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        return propHandle.getListValue().iterator();
    }

    public String getSortType() {
        return this.handle.getStringProperty("sortType");
    }

    public String getSortDirection() {
        return this.handle.getStringProperty("sortDirection");
    }

    public String getDisplayField() {
        return this.handle.getStringProperty("displayField");
    }

    public Iterator sortsIterator() {
        PropertyHandle propHandle = this.handle.getPropertyHandle("sort");
        if (propHandle == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        return propHandle.getListValue().iterator();
    }

    public String getPageBreakBefore() {
        return this.handle.getStringProperty("pageBreakBefore");
    }

    public String getPageBreakAfter() {
        return this.handle.getStringProperty("pageBreakAfter");
    }

    public String getPageBreakInside() {
        return this.handle.getStringProperty("pageBreakInside");
    }

    public int getPageBreakInterval() {
        return this.handle.getIntProperty("pageBreakInterval");
    }

    public void setPageBreakBefore(String value) throws SemanticException {
        this.handle.setStringProperty("pageBreakBefore", value);
    }

    public void setPageBreakAfter(String value) throws SemanticException {
        this.handle.setStringProperty("pageBreakAfter", value);
    }

    public void setPageBreakInside(String value) throws SemanticException {
        this.handle.setStringProperty("pageBreakInside", value);
    }

    public void setPageBreakInterval(int value) throws SemanticException {
        this.handle.setIntProperty("pageBreakInterval", value);
    }

    public String getAggregationHeaderLocation() {
        return this.handle.getStringProperty("aggregationHeaderLocation");
    }

    public void setAggregationHeaderLocation(String value) throws SemanticException {
        this.handle.setStringProperty("aggregationHeaderLocation", value);
    }

    public PropertyHandle getMemberProperty() {
        return this.handle.getPropertyHandle("member");
    }

    public PropertyHandle getAggregationHeaderProperty() {
        return this.handle.getPropertyHandle("aggregationHeader");
    }

    public CrosstabCellHandle getCell() {
        PropertyHandle propHandle = this.getMemberProperty();
        return propHandle.getContentCount() == 0 ? null : (CrosstabCellHandle)CrosstabUtil.getReportItem(propHandle.getContent(0), "CrosstabCell");
    }

    public CrosstabCellHandle getAggregationHeader() {
        PropertyHandle propHandle = this.getAggregationHeaderProperty();
        return propHandle.getContentCount() == 0 ? null : (CrosstabCellHandle)CrosstabUtil.getReportItem(propHandle.getContent(0), "CrosstabCell");
    }

    public void addAggregationHeader() throws SemanticException {
        if (this.getAggregationHeaderProperty().getContentCount() != 0) {
            logger.log(Level.INFO, "the aggregation header is set");
            return;
        }
        if (this.isInnerMost()) {
            logger.log(Level.WARNING, "This level: [" + this.handle.getName() + "] can not add aggregation for it is innermost");
            return;
        }
        this.getAggregationHeaderProperty().add((DesignElementHandle)CrosstabExtendedItemFactory.createCrosstabCell(this.moduleHandle));
    }

    public void removeAggregationHeader() throws SemanticException {
        if (this.getAggregationHeaderProperty().getContentCount() > 0) {
            this.getAggregationHeaderProperty().drop(0);
        }
    }

    public CrosstabCellHandle addSubTotal(List measureList, List functionList) throws SemanticException {
        return new LevelViewTask(this).addSubTotal(measureList, functionList);
    }

    public void removeSubTotal() throws SemanticException {
        new LevelViewTask(this).removeSubTotal();
    }

    public void removeSubTotal(int measureIndex) throws SemanticException {
        new LevelViewTask(this).removeSubTotal(measureIndex);
    }

    public int getIndex() {
        return this.handle.getIndex();
    }

    public boolean isInnerMost() {
        CrosstabViewHandle container;
        DimensionViewHandle dimensionView = (DimensionViewHandle)this.getContainer();
        return dimensionView != null && (container = (CrosstabViewHandle)dimensionView.getContainer()) != null && dimensionView.getIndex() == container.getDimensionCount() - 1 && this.getIndex() == dimensionView.getLevelCount() - 1;
    }

    public int getAxisType() {
        DimensionViewHandle dimensionView = (DimensionViewHandle)CrosstabUtil.getReportItem(this.handle.getContainer(), "DimensionView");
        return dimensionView == null ? -1 : dimensionView.getAxisType();
    }

    public String getAggregationFunction(MeasureViewHandle measureView) {
        return new LevelViewTask(this).getAggregationFunction(measureView);
    }

    public List getAggregationMeasures() {
        return new LevelViewTask(this).getAggregationMeasures();
    }

    public void setAggregationFunction(MeasureViewHandle measureView, String function) throws SemanticException {
        new LevelViewTask(this).setAggregationFunction(measureView, function);
    }
}

